/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFacadeFactory;
import com.kingdee.eas.ma.view.BgViewDimensionFactory;
import com.kingdee.eas.ma.view.BgViewDimensionInfo;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.IBgBillIntegrateSchemeFacade;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BudgetViewLoaderImpl;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.common.IBudgetView;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BgViewCommonHelper {
    private static Boolean hasBillIntegrate = null;

    public static boolean hasBillIntegrate(Context ctx) throws BOSException, EASBizException {
        if (hasBillIntegrate == null) {
            IBgBillIntegrateSchemeFacade facade = null;
            facade = ctx == null ? BgBillIntegrateSchemeFacadeFactory.getRemoteInstance() : BgBillIntegrateSchemeFacadeFactory.getLocalInstance(ctx);
            hasBillIntegrate = facade.hasBillIngegrate();
        }
        return hasBillIntegrate;
    }

    public static Boolean hasBillIntegrate() {
        return hasBillIntegrate;
    }

    public static void setHasBillIntegrate(boolean hasBillIntegrate) {
        BgViewCommonHelper.hasBillIntegrate = hasBillIntegrate;
    }

    public static void converPeriodToRPT(BgFormInfo report) {
        BgPeriodInfo period = report.getBgPeriod();
        if (period != null) {
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    report.setPeriodType(RptPeriodTypeEnum.YEARLY);
                    report.setYear(year);
                    report.setPeriod((short)1);
                } else if (periodType.getValue() == 2) {
                    report.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                    report.setYear(year);
                    report.setPeriod((short)halfYear);
                } else if (periodType.getValue() == 3) {
                    report.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                    report.setYear(year);
                    report.setPeriod((short)quart);
                } else if (periodType.getValue() == 4) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                }
            }
        }
    }

    public static StringBuffer convertArray(Object[] obj, StringBuffer str) {
        if (obj == null || obj.length == 0) {
            return str;
        }
        if (str == null) {
            str = new StringBuffer();
        }
        for (int i = 0; i < obj.length; ++i) {
            if (i != 0) {
                str.append(", ");
            }
            str.append(obj[i]);
        }
        return str;
    }

    public static boolean isShowMeasure(IBgDimensionManager dm) {
        return dm != null && dm.getDefaultMeasureUnit() != null && dm.getMeasureMap().isEmpty();
    }

    public static void setLocked(boolean isLocked, Range r) {
        if (r != null) {
            StyleAttributes s1 = Styles.getEmptySA();
            StyleAttributes s2 = Styles.getEmptySA();
            r.getStyle(s1, s2);
            s1.setLocked(isLocked);
            r.setIgnoreProtected(true);
            r.setStyle(s1, s2);
        }
    }

    public static int getBeginRowIndex(IBgDimensionManager dm) {
        if (BgViewCommonHelper.isShowMeasure(dm)) {
            return 2;
        }
        return 0;
    }

    public static boolean isShowLevel(IBgDimensionManager bm, BgDimensionInfo dimen) {
        if (bm != null && dimen != null) {
            return "row".equalsIgnoreCase(dimen.getLayout()) && bm.isRowShowLevel();
        }
        return false;
    }

    public static List getViewOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        sheetOperation.add(new Integer(8));
        sheetOperation.add(new Integer(16));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(16384));
        sheetOperation.add(new Integer(32768));
        return sheetOperation;
    }

    public static List getViewAuditOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(4));
        sheetOperation.add(new Integer(8));
        sheetOperation.add(new Integer(16));
        return sheetOperation;
    }

    public static String getOrgId(boolean isBg063, String orgId) {
        if (isBg063) {
            return orgId;
        }
        return "00000000-0000-0000-0000-000000000000CCE7AED4";
    }

    public static Map filterMap(Map orgMap, String orgid, boolean flag) {
        if (flag) {
            HashMap tempOrgMap = new HashMap();
            for (Object id : orgMap.keySet()) {
                if (!id.equals(orgid)) continue;
                tempOrgMap.put(id, orgMap.get(id));
            }
            return tempOrgMap;
        }
        return orgMap;
    }

    public static void fillDimensionMember(IBgDimensionManager bm, Map resMap, boolean isBg063, String orgId, BgPeriodInfo bgPeriod, CurrencyInfo currency, boolean isCurOrg) throws EASBizException {
        if (bm == null || resMap == null || resMap.isEmpty()) {
            return;
        }
        Map orgMap = (Map)resMap.get("ORGUNIT");
        Map bgItemMap = (Map)resMap.get("BGITEM");
        Map bgPeriodMap = (Map)resMap.get("BGPERIOD");
        for (int i = 0; i < bm.getDimension().size(); ++i) {
            BgDimensionInfo dimen = (BgDimensionInfo)bm.getDimension().get(i);
            if ("ORGUNIT".equalsIgnoreCase(dimen.getType())) {
                BgViewCommonHelper.fillOrgDimensionMember(dimen, BgViewCommonHelper.filterMap(orgMap, orgId, isCurOrg));
            } else if ("BGPERIOD".equalsIgnoreCase(dimen.getType())) {
                BgViewCommonHelper.fillBgPeriodDimensionMember(dimen, bgPeriodMap, bgPeriod);
            } else if ("CURRENCY".equalsIgnoreCase(dimen.getType())) {
                BgViewCommonHelper.fillCurrencyDimensionMember(dimen, currency);
            } else if ("BGITEM".equalsIgnoreCase(dimen.getType())) {
                BgViewCommonHelper.fillBgItemDimensionMember(dimen, bgItemMap, isBg063, orgId);
            } else if ("BGELEMENT".equalsIgnoreCase(dimen.getType())) {
                // empty if block
            }
            if ("BGPERIOD".equalsIgnoreCase(dimen.getType())) continue;
            dimen.sortMember();
        }
    }

    private static void fillCurrencyDimensionMember(BgDimensionInfo dimen, CurrencyInfo currency) {
        if (dimen != null && StringUtils.isEmpty((String)dimen.getValue())) {
            dimen.getMember().clear();
            BgDimensionMember member = new BgDimensionMember(dimen.getType(), currency.getId().toString(), currency.getName(), currency.getNumber());
            dimen.getMember().add(member);
        }
    }

    public static void fillBgPeriodDimensionMember(BgDimensionInfo dimen, Map bgPeriodMap, BgPeriodInfo bgPeriod) throws BgFormException, BgPeriodException {
        if (dimen != null) {
            if (StringUtils.isEmpty((String)dimen.getValue())) {
                dimen.getMember().clear();
                BgDimensionMember member = new BgDimensionMember(dimen.getType(), bgPeriod.getId().toString(), bgPeriod.getName(), bgPeriod.getNumber());
                member.setNumber(bgPeriod.getNumber());
                member.setAttribute(bgPeriod.getId().toString());
                member.setName(bgPeriod.getName());
                member.setLevel(bgPeriod.getLevel());
                member.setSortValue(Integer.valueOf(bgPeriod.getShowLevel()));
                dimen.getMember().add(member);
            } else {
                ArrayList<String> notExistPeriodNum = new ArrayList<String>();
                ArrayList<BgDimensionMember> newMember = new ArrayList<BgDimensionMember>();
                for (int i = 0; i < dimen.getMember().size(); ++i) {
                    BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(i);
                    String number = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriod.getNumber(), (String)member.getNumber(), (int)bgPeriod.getPeriodType().getValue());
                    if (bgPeriodMap.containsKey(number)) {
                        BgPeriodInfo p = (BgPeriodInfo)bgPeriodMap.get(number);
                        member.setNumber(p.getNumber());
                        member.setAttribute(p.getId().toString());
                        member.setLevel(p.getLevel());
                        member.setName(p.getName());
                        member.setSortValue(Integer.valueOf(p.getShowLevel()));
                        newMember.add(member);
                        continue;
                    }
                    notExistPeriodNum.add(number);
                }
                if (notExistPeriodNum.size() > 0) {
                    throw new BgPeriodException(BgPeriodException.NOEXISTDETAIL, new Object[]{((Object)notExistPeriodNum).toString()});
                }
                dimen.getMember().clear();
                dimen.getMember().addAll(newMember);
            }
        }
    }

    public static void fillBgItemDimensionMember(BgDimensionInfo dimen, Map bgItemMap, boolean isBg063, String orgId) {
        if (dimen != null) {
            Map subBgItemMap = null;
            orgId = BgViewCommonHelper.getOrgId(isBg063, orgId);
            if (bgItemMap != null && bgItemMap.containsKey(orgId)) {
                subBgItemMap = (Map)bgItemMap.get(orgId);
            }
            if (subBgItemMap != null && subBgItemMap.containsKey(dimen.getAttributeNumber())) {
                Map items = (Map)subBgItemMap.get(dimen.getAttributeNumber());
                if (StringUtils.isEmpty((String)dimen.getValue())) {
                    dimen.getMember().clear();
                    if (items != null && !items.isEmpty()) {
                        for (BgItemInfo info : items.values()) {
                            BgDimensionMember member = new BgDimensionMember(dimen.getType(), info.getRefField(), info.getName(), info.getNumber());
                            member.setLevel(info.getLevel());
                            member.setSortValue((Comparable)((Object)info.getLongNumber()));
                            dimen.getMember().add(member);
                        }
                    }
                } else {
                    for (int m = dimen.getMember().size() - 1; m >= 0; --m) {
                        BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(m);
                        if (items == null || !items.containsKey(member.getNumber())) {
                            dimen.getMember().remove(m);
                            continue;
                        }
                        BgItemInfo info = (BgItemInfo)items.get(member.getNumber());
                        member.setAttribute(info.getRefField());
                        member.setLevel(info.getLevel());
                        member.setName(info.getName());
                        member.setSortValue((Comparable)((Object)info.getLongNumber()));
                    }
                }
            } else {
                dimen.getMember().clear();
            }
            dimen.sortMember();
        }
    }

    public static void fillOrgDimensionMember(BgDimensionInfo dimen, Map orgMap) {
        if (dimen != null) {
            dimen.getMember().clear();
            if (orgMap != null && !orgMap.isEmpty()) {
                for (OrgUnitInfo org : orgMap.values()) {
                    BgDimensionMember member = new BgDimensionMember(dimen.getType(), org.getId().toString(), org.getName(), org.getNumber());
                    member.setLevel(org.getLevel());
                    member.setSortValue((Comparable)((Object)org.getLongNumber()));
                    dimen.getMember().add(member);
                }
            }
            dimen.sortMember();
        }
    }

    public static Map buildItemFormula(List pageMems, List colDimension, List rowDimension) {
        HashMap bgDataMap = new HashMap();
        ArrayList allDimen = new ArrayList();
        if (colDimension != null && !colDimension.isEmpty()) {
            allDimen.addAll(colDimension);
        }
        if (rowDimension != null && !rowDimension.isEmpty()) {
            allDimen.addAll(rowDimension);
        }
        if (allDimen.isEmpty()) {
            return null;
        }
        int memCount = allDimen.size();
        if (pageMems != null) {
            memCount += pageMems.size();
        }
        BgDimensionMember[] ms = new BgDimensionMember[memCount];
        if (pageMems != null && !pageMems.isEmpty()) {
            for (int i = 0; i < pageMems.size(); ++i) {
                ms[i] = (BgDimensionMember)pageMems.get(i);
            }
        }
        BgViewCommonHelper.buildItemFormula(bgDataMap, ms, allDimen, 0, pageMems == null ? 0 : pageMems.size());
        return bgDataMap;
    }

    private static void buildItemFormula(Map bgDataMap, BgDimensionMember[] ms, List allDimen, int index, int startIndex) {
        if (ms == null || ms.length != allDimen.size() + startIndex || allDimen == null || index >= allDimen.size()) {
            return;
        }
        BgDimensionInfo dimen = (BgDimensionInfo)allDimen.get(index);
        if (dimen.getMember().isEmpty()) {
            return;
        }
        for (int i = 0; i < dimen.getMember().size(); ++i) {
            ms[index + startIndex] = (BgDimensionMember)dimen.getMember().get(i);
            if (allDimen.size() == index + 1) {
                BgViewCommonHelper.addItemFormula(bgDataMap, ms);
                continue;
            }
            BgViewCommonHelper.buildItemFormula(bgDataMap, ms, allDimen, index + 1, startIndex);
        }
    }

    public static void addItemFormula(Map bgDataMap, BgDimensionMember[] members) {
        if (members != null) {
            String orgId = null;
            String bgElement = null;
            String currency = null;
            String bgPeriod = null;
            HashMap<Integer, String> bgItems = new HashMap<Integer, String>();
            for (int i = 0; i < members.length; ++i) {
                BgDimensionMember m = members[i];
                if ("BGITEM".equalsIgnoreCase(m.getType())) {
                    Integer f = new Integer(m.getAttribute().toUpperCase().replaceAll("F", ""));
                    bgItems.put(f, m.getNumber());
                    continue;
                }
                if ("BGELEMENT".equalsIgnoreCase(m.getType())) {
                    bgElement = m.getNumber();
                    continue;
                }
                if ("BGPERIOD".equalsIgnoreCase(m.getType())) {
                    bgPeriod = m.getNumber();
                    continue;
                }
                if ("ORGUNIT".equalsIgnoreCase(m.getType())) {
                    orgId = m.getAttribute();
                    continue;
                }
                if (!"CURRENCY".equalsIgnoreCase(m.getType())) continue;
                currency = m.getNumber();
            }
            BgViewCommonHelper.addItemFormula(bgDataMap, orgId, bgElement, currency, bgPeriod, bgItems);
        }
    }

    public static void addItemFormula(Map bgDataMap, String orgId, String bgElement, String currency, String bgPeriod, Map bgItems) {
        if (bgDataMap == null || StringUtils.isEmpty((String)orgId)) {
            return;
        }
        if (!bgDataMap.containsKey(orgId)) {
            bgDataMap.put(orgId, new HashMap());
        }
        Map formula = (Map)bgDataMap.get(orgId);
        formula.put(BgViewCommonHelper.parseItemFormula(bgElement, currency, bgPeriod, bgItems), null);
    }

    public static String parseItemFormula(String bgElement, String currency, String bgPeriod, Map bgItems) {
        StringBuffer f = new StringBuffer();
        f.append("=BgItem(\"");
        if (bgItems != null && !bgItems.isEmpty()) {
            Object[] reffields = bgItems.keySet().toArray();
            Arrays.sort(reffields);
            for (int i = 0; i < reffields.length; ++i) {
                if (i != 0) {
                    f.append(",");
                }
                f.append(bgItems.get(reffields[i]));
            }
        }
        f.append("\",\"");
        f.append(bgPeriod == null ? "" : bgPeriod);
        f.append("\",\"");
        f.append(bgElement == null ? "" : bgElement);
        f.append("\",\"BgData\",true,\"");
        f.append(currency == null ? "" : currency);
        f.append("\")");
        return f.toString();
    }

    public static Map getSubMap(Map parent, String key, boolean create) {
        if (parent == null) {
            return null;
        }
        if (parent.containsKey(key)) {
            return (Map)parent.get(key);
        }
        if (create) {
            parent.put(key, new HashMap());
            return (Map)parent.get(key);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map getSubMap(Map parent, Object key, boolean isCreate, Object defaultKey) {
        void var4_7;
        if (parent == null || key == null) {
            return null;
        }
        Object var4_4 = null;
        if (parent.get(key) == null) {
            if (!isCreate) return BgViewCommonHelper.getSubMap(parent, defaultKey, false, null);
            HashMap hashMap = new HashMap();
            parent.put(key, hashMap);
            return var4_7;
        } else {
            if (!(parent.get(key) instanceof Map)) return var4_7;
            Map map = (Map)parent.get(key);
        }
        return var4_7;
    }

    public static void setSheetLocked(Book book, boolean isLocked, List sheetOperation) {
        if (book != null) {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                BgNFSHelper.setSheetLANDP((Sheet)book.getSheet(i), (boolean)isLocked, (List)sheetOperation);
            }
        }
    }

    public static String[] splitField(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        return fieldName.split("\\.");
    }

    public static void addFilterItem(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        if (filter.getFilterItems() != null) {
            FilterItemCollection fiCol = filter.getFilterItems();
            fiCol.add(item);
            int itemsSize = fiCol.size();
            if (itemsSize <= 1) {
                filter.setMaskString("(#0)");
            } else {
                filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
            }
        }
    }

    public static List buildFormula(Context ctx, BOSUuid bgTemplateId, boolean isCtrlSet) throws Exception {
        if (bgTemplateId == null) {
            return null;
        }
        BgViewDimensionInfo viewDimen = null;
        CoreBaseCollection col = null;
        String oql = "select id, data, template.id, template.orgUnit.id where template.id = '" + bgTemplateId + "'";
        col = ctx == null ? BgViewDimensionFactory.getRemoteInstance().getCollection(oql) : BgViewDimensionFactory.getLocalInstance(ctx).getCollection(oql);
        if (col == null || col.isEmpty()) {
            return null;
        }
        viewDimen = (BgViewDimensionInfo)col.getObject(0);
        BgDimensionManagerImpl bgDimensionManager = new BgDimensionManagerImpl();
        IBudgetView view = BudgetViewLoaderImpl.getIntance();
        view.load(bgDimensionManager, viewDimen.getData());
        Map initData = null;
        initData = ctx == null ? BgViewFacadeFactory.getRemoteInstance().getInitBgTemplateDimensionInfo(bgDimensionManager, String.valueOf(bgTemplateId)) : BgViewFacadeFactory.getLocalInstance(ctx).getInitBgTemplateDimensionInfo(bgDimensionManager, String.valueOf(bgTemplateId));
        BgViewCommonHelper.processTemplateDimension(ctx, bgDimensionManager, initData, viewDimen.getTemplate().getOrgUnit().getId().toString());
        HashSet<String> dimenTypes = new HashSet<String>();
        dimenTypes.add("ORGUNIT");
        dimenTypes.add("BGITEM");
        dimenTypes.add("BGELEMENT");
        if (!isCtrlSet) {
            dimenTypes.add("BGPERIOD");
            dimenTypes.add("CURRENCY");
        }
        ArrayList dimenList = new ArrayList(bgDimensionManager.getDimension());
        BgViewCommonHelper.filterDimension(dimenList, dimenTypes);
        Map bgDataMap = BgViewCommonHelper.buildItemFormula(null, dimenList, null);
        ArrayList formulas = new ArrayList();
        for (Map map : bgDataMap.values()) {
            if (map == null || map.isEmpty()) continue;
            formulas.addAll(map.keySet());
        }
        return formulas;
    }

    private static void filterDimension(List dimensions, Set dimenTypes) {
        if (dimensions == null || dimensions.isEmpty() || dimenTypes == null || dimenTypes.isEmpty()) {
            return;
        }
        for (int i = dimensions.size() - 1; i >= 0; --i) {
            BgDimensionInfo dimen = (BgDimensionInfo)dimensions.get(i);
            if (dimenTypes.contains(dimen.getType().toUpperCase())) continue;
            dimensions.remove(i);
        }
    }

    public static void processTemplateDimension(Context ctx, IBgDimensionManager bm, Map initData, String orgUnitId) {
        if (initData == null) {
            return;
        }
        Map bgPeriod = (Map)initData.get("BGPERIOD");
        Map bgItem = (Map)initData.get("BGITEM");
        boolean isBg063 = BgSHelper.isBgItemIsolate((Context)ctx);
        ArrayList dims = new ArrayList();
        dims.addAll(bm.getColDimension());
        dims.addAll(bm.getRowDimension());
        dims.addAll(bm.getPageDimension());
        for (int i = 0; i < dims.size(); ++i) {
            BgDimensionMember member;
            BgDimensionInfo bd = (BgDimensionInfo)dims.get(i);
            if ("BGITEM".equals(bd.getType())) {
                BgViewCommonHelper.fillBgItemDimensionMember(bd, bgItem, isBg063, orgUnitId);
                continue;
            }
            if ("BGPERIOD".equalsIgnoreCase(bd.getType())) {
                if (!StringUtils.isEmpty((String)bd.getValue())) continue;
                member = new BgDimensionMember(bd.getType(), "BGPERIOD", ctx == null ? EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgViewTemplateResource", (String)"period") : ResourceBase.getString((String)"com.kingdee.eas.ma.view.client.BgViewTemplateResource", (String)"period", (Locale)ctx.getLocale()), "BGPERIOD");
                bd.getMember().add(member);
                continue;
            }
            if (!"ORGUNIT".equals(bd.getType())) continue;
            member = new BgDimensionMember(bd.getType(), orgUnitId, orgUnitId, orgUnitId);
            bd.getMember().add(member);
        }
    }

    public static int getRollMethod(BgFormInfo form) {
        if (form != null && !form.getEntries().isEmpty() && form.getEntries().get(0).getRollMethod() != null) {
            return form.getEntries().get(0).getRollMethod().getValue();
        }
        return 0;
    }

    public static BgDimensionInfo fillRollPeriodNumber(IBgDimensionManager bm, int oldHistoryNum, int historyNum, String currentPeriodNum) {
        List dimensionList;
        BgDimensionInfo bgPeriodDimensionInfo = null;
        if (bm != null && bm.getDimension() != null && (dimensionList = bm.getDimension()).size() > 0) {
            int diff;
            for (BgDimensionInfo dimensionInfo : dimensionList) {
                if (!"BGPERIOD".equalsIgnoreCase(dimensionInfo.getType())) continue;
                bgPeriodDimensionInfo = dimensionInfo;
                break;
            }
            if ((diff = historyNum - oldHistoryNum) > 0) {
                HashSet<String> newPeriodNumSet = new HashSet<String>();
                if (currentPeriodNum == null && bgPeriodDimensionInfo != null) {
                    currentPeriodNum = ((BgDimensionMember)bgPeriodDimensionInfo.getMember().get(0)).getNumber();
                }
                for (int i = 0; i < diff; ++i) {
                    currentPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currentPeriodNum, (int)-1);
                    newPeriodNumSet.add(currentPeriodNum);
                }
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                evi.getSelector().add("longNumber");
                evi.getSelector().add("periodType");
                evi.getSelector().add("showlevel");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(newPeriodNumSet), CompareType.INCLUDE));
                evi.getSorter().add(new SorterItemInfo("number"));
                BgPeriodCollection col = null;
                try {
                    col = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(evi);
                }
                catch (BOSException e) {
                    Logger.error((Throwable)e);
                }
                BgPeriodInfo bgPeriodInfo = null;
                BgDimensionMember member = null;
                if (bgPeriodDimensionInfo != null) {
                    for (int i = col.size() - 1; i >= 0; --i) {
                        bgPeriodInfo = col.get(i);
                        member = new BgDimensionMember(bgPeriodDimensionInfo.getType(), bgPeriodInfo.getId().toString(), bgPeriodInfo.getName(), bgPeriodInfo.getNumber());
                        member.setLevel(bgPeriodInfo.getLevel());
                        member.setSortValue(Integer.valueOf(bgPeriodInfo.getShowLevel()));
                        bgPeriodDimensionInfo.getMember().add(0, member);
                    }
                }
            } else if (diff < 0 && bgPeriodDimensionInfo != null) {
                for (int i = 0; i < diff * -1; ++i) {
                    bgPeriodDimensionInfo.getMember().remove(0);
                }
            }
            if (bgPeriodDimensionInfo != null) {
                bgPeriodDimensionInfo.unParseBgPeriod();
            }
        }
        return bgPeriodDimensionInfo;
    }

    public static List buildFormula(List<BgDimensionInfo> allDimension, int start, List formulas) {
        if (formulas == null) {
            formulas = new ArrayList();
        }
        if (start == allDimension.size()) {
            return formulas;
        }
        List members = allDimension.get(start).getMember();
        List<Object[]> result = new ArrayList();
        HashMap<Integer, String> _item = null;
        String _element = null;
        String _period = null;
        String _currency = null;
        Object[] curFormula2 = null;
        BgDimensionMember curMemeber2 = null;
        if (start == 0) {
            for (BgDimensionMember curMemeber2 : members) {
                curFormula2 = new Object[4];
                if ("bgitem".equalsIgnoreCase(curMemeber2.getType())) {
                    _item = new HashMap<Integer, String>();
                    _item.put(new Integer(curMemeber2.getAttribute().toUpperCase().replaceAll("F", "")), curMemeber2.getNumber());
                    curFormula2[3] = _item;
                } else if ("bgperiod".equalsIgnoreCase(curMemeber2.getType())) {
                    _period = "BGPERIOD".equals(curMemeber2.getNumber()) ? "" : curMemeber2.getNumber();
                    curFormula2[2] = _period;
                } else if ("bgelement".equalsIgnoreCase(curMemeber2.getType())) {
                    _element = curMemeber2.getNumber();
                    curFormula2[0] = _element;
                } else if ("currency".equalsIgnoreCase(curMemeber2.getType())) {
                    _currency = curMemeber2.getNumber();
                    curFormula2[1] = _currency;
                }
                result.add(curFormula2);
            }
        } else {
            for (Object[] curFormula2 : formulas) {
                for (BgDimensionMember curMemeber2 : members) {
                    Object[] newFormula = new Object[4];
                    if (curFormula2[0] != null) {
                        newFormula[0] = curFormula2[0];
                    }
                    if (curFormula2[1] != null) {
                        newFormula[1] = curFormula2[1];
                    }
                    if (curFormula2[2] != null) {
                        newFormula[2] = curFormula2[2];
                    }
                    if (curFormula2[3] != null) {
                        HashMap newItemMap = new HashMap();
                        newItemMap.putAll((Map)curFormula2[3]);
                        newFormula[3] = newItemMap;
                    }
                    if ("bgitem".equalsIgnoreCase(curMemeber2.getType())) {
                        if (newFormula[3] == null) {
                            newFormula[3] = new HashMap();
                        }
                        ((Map)newFormula[3]).put(new Integer(curMemeber2.getAttribute().toUpperCase().replaceAll("F", "")), curMemeber2.getNumber());
                    } else if ("bgperiod".equalsIgnoreCase(curMemeber2.getType())) {
                        _period = "BGPERIOD".equals(curMemeber2.getNumber()) ? "" : curMemeber2.getNumber();
                        newFormula[2] = _period;
                    } else if ("bgelement".equalsIgnoreCase(curMemeber2.getType())) {
                        _element = curMemeber2.getNumber();
                        newFormula[0] = _element;
                    } else if ("currency".equalsIgnoreCase(curMemeber2.getType())) {
                        _currency = curMemeber2.getNumber();
                        newFormula[1] = _currency;
                    }
                    result.add(newFormula);
                }
            }
        }
        if (start + 1 < allDimension.size()) {
            result = BgViewCommonHelper.buildFormula(allDimension, start + 1, result);
        }
        return result;
    }

    public static String valueOf(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }
}

