/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.util;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.framework.command.ICommand;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.client.common.BgDimensionParseHelper;
import com.kingdee.eas.ma.view.client.designer.IProvider;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.BudgetViewLoaderImpl;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.common.IBudgetView;
import com.kingdee.eas.ma.view.util.IOHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BookParseHelper {
    public static final String kdf_magic = "###PACKER4.0.1###";
    public static final String kds1_magic = "###KDSpread1.0###";
    public static final String kds2_magic = "###KDSpread2.0###";
    public static final String view_magic = "<?xml version=\"1.";
    private IBgDimensionManager bgDimensionManager;
    private ICommand afterLoad = null;

    public void setAfterLoad(ICommand afterLoad) {
        this.afterLoad = afterLoad;
    }

    public BookParseHelper(IBgDimensionManager bgDimensionManager) {
        this.bgDimensionManager = bgDimensionManager;
    }

    public Book getBook(byte[] bytes) throws Exception {
        if (bytes == null || bytes.length == 0) {
            return Book.Manager.getNewBook();
        }
        if (bytes.length < 17) {
            return Book.Manager.getNewBook();
        }
        Book _book = null;
        String magic_str = new String(bytes, 0, 17);
        if (magic_str.equalsIgnoreCase(kds2_magic) || magic_str.equalsIgnoreCase(kds1_magic)) {
            _book = IOHelper.unpackBook((byte[])bytes);
        } else if (magic_str.equalsIgnoreCase(view_magic)) {
            _book = this.getViewBook(bytes, null, false);
        } else if (magic_str.equalsIgnoreCase(kdf_magic)) {
            // empty if block
        }
        _book = this.getViewBook(bytes, null, false);
        return _book;
    }

    public Book getViewDimensionBook(byte[] bytes, byte[] bytesStyle) throws Exception {
        if (bytes == null || bytes.length == 0) {
            return Book.Manager.getNewBook();
        }
        if (bytes.length < 17) {
            return Book.Manager.getNewBook();
        }
        Book _book = this.getViewBook(bytes, bytesStyle, false);
        return _book;
    }

    public Book getViewDimensionBookNoChangeStyle(byte[] bytes) throws Exception {
        if (bytes == null || bytes.length == 0) {
            return Book.Manager.getNewBook();
        }
        if (bytes.length < 17) {
            return Book.Manager.getNewBook();
        }
        Book _book = this.getViewBook(bytes, null, true);
        return _book;
    }

    public byte[] setBook(Book book) throws Exception {
        if (book == null) {
            return null;
        }
        return IOHelper.packBook((Book)book);
    }

    protected Book getViewBook(byte[] bytes, byte[] bytesStyle, boolean isSynchStyle) throws Exception {
        IBudgetView view = BudgetViewLoaderImpl.getIntance();
        view.load(this.bgDimensionManager, bytes);
        if (isSynchStyle) {
            this.bgDimensionManager.synchStyle();
        } else {
            view.loadStyle(this.bgDimensionManager, bytesStyle);
        }
        if (this.afterLoad != null) {
            this.afterLoad.execute(null);
        }
        this.bgDimensionManager.copyAllowEditDimension();
        return BgDimensionParseHelper.parseRowAndColDimension(this.bgDimensionManager);
    }

    public void parseBgItem(Book book, List pageDimensions, Map bgDataMap) {
        if (book == null || book.getSheetCount() == 0) {
            return;
        }
        BgDimensionParseHelper.parseBgItem(this.bgDimensionManager, book.getSheet(0), pageDimensions, bgDataMap);
    }

    public void fillData(Book book, IProvider provider, Map bgDataMap) {
        if (book == null) {
            return;
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        book.getUndoManager().discardAllEdits();
        Range locked = null;
        Range unLocked = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                for (int c = 0; c <= maxCol; ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                    if (formula == null) continue;
                    BgNViewDataInfo data = null;
                    String orgId = formula.getExt("ORGUNITID");
                    if (bgDataMap != null && bgDataMap.containsKey(orgId)) {
                        Map subMap = (Map)bgDataMap.get(orgId);
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    boolean isLocked = provider.isLocked(data);
                    if (data != null) {
                        cell.setValue(new Variant((Object)data.getBudgetValue()));
                    } else {
                        cell.setValue(Variant.emptyVariant);
                    }
                    Range range = sheet.getRange(cell);
                    if (isLocked == cell.isLocked()) continue;
                    if (isLocked) {
                        if (locked == null) {
                            locked = range;
                            continue;
                        }
                        locked.addAll((SortedCellBlockArray)range);
                        continue;
                    }
                    if (unLocked == null) {
                        unLocked = range;
                        continue;
                    }
                    unLocked.addAll((SortedCellBlockArray)range);
                }
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (locked != null) {
            sa.setLocked(true);
            locked.setStyle(sa, Styles.getEmptySA());
        }
        if (unLocked != null) {
            sa.setLocked(false);
            unLocked.setStyle(sa, Styles.getEmptySA());
        }
        BgNFSHelper.enableUndo((Book)book);
        BgNFSHelper.enableCal((Book)book);
    }

    public void fillData(Book book, IProvider provider, Map bgDataMap, Map newDataMap) {
        if (book == null) {
            return;
        }
        if (newDataMap == null) {
            newDataMap = new HashMap();
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        book.getUndoManager().discardAllEdits();
        Range locked = null;
        Range unLocked = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                for (int c = 0; c <= maxCol; ++c) {
                    Map subMap;
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                    if (formula == null) continue;
                    BgNViewDataInfo data = null;
                    String orgId = formula.getExt("ORGUNITID");
                    if (bgDataMap.containsKey(orgId)) {
                        subMap = (Map)bgDataMap.get(orgId);
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    if (newDataMap.containsKey(orgId) && (subMap = (Map)newDataMap.get(orgId)).get(formula.getFormula()) != null) {
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    boolean isLocked = provider.isLocked(data);
                    if (data != null) {
                        if (data.getBudgetValueNoDef() != null) {
                            cell.setValue(new Variant((Object)data.getBudgetValueNoDef()));
                        }
                    } else {
                        cell.setValue(Variant.emptyVariant);
                    }
                    Range range = sheet.getRange(cell);
                    if (isLocked == cell.isLocked()) continue;
                    if (isLocked) {
                        if (locked == null) {
                            locked = range;
                            continue;
                        }
                        locked.addAll((SortedCellBlockArray)range);
                        continue;
                    }
                    if (unLocked == null) {
                        unLocked = range;
                        continue;
                    }
                    unLocked.addAll((SortedCellBlockArray)range);
                }
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (locked != null) {
            sa.setLocked(true);
            locked.setStyle(sa, Styles.getEmptySA());
        }
        if (unLocked != null) {
            sa.setLocked(false);
            unLocked.setStyle(sa, Styles.getEmptySA());
        }
        BgNFSHelper.enableCal((Book)book);
        BgNFSHelper.enableUndo((Book)book);
    }
}

