/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.common.Helper;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SqlGenerator {
    private String language = null;
    private Set ignoreTables = new HashSet();

    public SqlGenerator(String language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main() {
        try {
            System.out.println("\u8d44\u6e90\u6253\u5305\u5f00\u59cb......");
            SqlGenerator sqlGenerator = new SqlGenerator("zh_TW");
            sqlGenerator.generateMenuUpdateSql();
            sqlGenerator.generatePresetDataUpdateSql2();
            sqlGenerator.testGenerateFile();
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("System");
            root.addAttribute("name", "ml");
            Element element = null;
            element = root.addElement("sql");
            element.addText("./ml/t_res_Language.sql");
            element = root.addElement("sql");
            element.addText("./ml/T_RES_EASResourceDomain.sql");
            sqlGenerator.testGenerateTransResourseInsSql(root);
            sqlGenerator.testGenerateMultiFieldSql(root);
            sqlGenerator.testGeneratePresetDataResourseInsSql(root);
            String sqlCreateFileName = System.getProperty("user.home") + "/easSql/ml/create.xml";
            File f = new File(sqlCreateFileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fo = null;
            BufferedOutputStream bo = null;
            BufferedWriter out = null;
            try {
                fo = new FileOutputStream(f);
                bo = new BufferedOutputStream(fo);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                document.write((Writer)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (fo != null) {
                    fo.close();
                }
                if (bo != null) {
                    bo.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map getDomain() throws Exception {
        HashMap<String, EASDomain> map = new HashMap<String, EASDomain>();
        EASDomain domain = new EASDomain();
        domain.setId("scm");
        domain.setProject("scm");
        domain.setName1("scm");
        domain.setName2("\u4f9b\u5e94\u94fe");
        domain.setName3("\u4f9b\u5e94\u94fe");
        map.put("scm", domain);
        domain = new EASDomain();
        domain.setId("fm");
        domain.setProject("fm");
        domain.setName1("fm");
        domain.setName2("\u8d22\u52a1");
        domain.setName3("\u8d22\u52a1");
        map.put("fm", domain);
        domain = new EASDomain();
        domain.setId("cp");
        domain.setProject("cp");
        domain.setName1("cp");
        domain.setName2("\u534f\u540c");
        domain.setName3("\u534f\u540c");
        map.put("cp", domain);
        domain = new EASDomain();
        domain.setId("bd");
        domain.setProject("bd");
        domain.setName1("bd");
        domain.setName2("\u57fa\u7840\u6570\u636e");
        domain.setName3("\u57fa\u7840\u6570\u636e");
        map.put("bd", domain);
        domain = new EASDomain();
        domain.setId("mm");
        domain.setProject("mm");
        domain.setName1("mm");
        domain.setName2("\u5236\u9020\u7ba1\u7406");
        domain.setName3("\u5236\u9020\u7ba1\u7406");
        map.put("mm", domain);
        domain = new EASDomain();
        domain.setId("qm");
        domain.setProject("qm");
        domain.setName1("qm");
        domain.setName2("\u8d28\u91cf\u7ba1\u7406");
        domain.setName3("\u8d28\u91cf\u7ba1\u7406");
        map.put("qm", domain);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTransResourseInsSql(Element root) throws Exception {
        File file;
        Connection conn = Helper.getInitDBConn();
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        sqlFileSeq = 1;
        recordIndex = 0;
        ResultSet rs = conn.createStatement().executeQuery(Sql.EASResource_quy);
        if (!rs.next()) {
            return;
        }
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/ml");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_EASResource_" + sqlFileSeq + ".xml")).exists()) {
            file.createNewFile();
        }
        Element element = null;
        element = root.addElement("xml");
        element.addText("./ml/t_res_EASResource_" + sqlFileSeq + ".xml");
        FileOutputStream fo = null;
        BufferedOutputStream bo = null;
        BufferedWriter bw = null;
        try {
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            String lineSep = System.getProperty("line.separator");
            StringBuilder sb = new StringBuilder();
            String fMD5Code = null;
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bw.write(lineSep);
            bw.write("<doc>");
            bw.write(lineSep);
            bw.write("<item>");
            bw.write(lineSep);
            sb.append("<sql> ").append(Sql.EASResource_ins).append("(?,?,?,?,?) </sql>").append(lineSep);
            bw.write(sb.toString());
            sb.delete(0, sb.length());
            do {
                fMD5Code = rs.getString("FMD5Code");
                sb.append("<para>").append(lineSep);
                sb.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                sb.append("<FRes dataInFile=\"false\" type=\"9\"><![CDATA[").append(SqlGenerator.transformStr(rs.getString("FRes"))).append("]]></FRes>").append(lineSep);
                sb.append("<FISInvalid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISInvalid")).append("]]></FISInvalid>").append(lineSep);
                sb.append("<fMD5Code dataInFile=\"false\" type=\"9\"><![CDATA[").append(fMD5Code).append("]]></fMD5Code>").append(lineSep);
                if (StringUtils.isEmpty((String)rs.getString("FDomainId"))) {
                    sb.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[]]]></FDomainId>").append(lineSep);
                } else {
                    sb.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FDomainId")).append("]]></FDomainId>").append(lineSep);
                }
                sb.append("</para>").append(lineSep);
                bw.write(sb.toString());
                bw.write(lineSep);
                sb.delete(0, sb.length());
                if (++recordIndex % sqlFileMaxRecord != 0) continue;
                bw.write("</item>");
                bw.write(lineSep);
                bw.write("</doc>");
                bw.flush();
                bw.close();
                recordIndex = 0;
                file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_EASResource_" + ++sqlFileSeq + ".xml");
                if (!file.exists()) {
                    file.createNewFile();
                }
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                element = root.addElement("xml");
                element.addText("./ml/t_res_EASResource_" + sqlFileSeq + ".xml");
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                bw.write("<item>");
                bw.write(lineSep);
                sb.append("<sql> ").append(Sql.EASResource_ins).append("(?,?,?,?,?) </sql>").append(lineSep);
                bw.write(sb.toString());
                sb.delete(0, sb.length());
            } while (rs.next());
            bw.write("</item>");
            bw.write(lineSep);
            bw.write("</doc>");
            bw.flush();
            rs.close();
            bw.close();
            sqlFileSeq = 1;
            recordIndex = 0;
            rs = conn.createStatement().executeQuery(Sql.EasMultilan_quy + " where FLanguageId = '" + this.language + "'");
            if (!rs.next()) {
                return;
            }
            file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_EASMultiLanRes_" + sqlFileSeq + ".xml");
            if (!file.exists()) {
                file.createNewFile();
            }
            element = root.addElement("xml");
            element.addText("./ml/t_res_EASMultiLanRes_" + sqlFileSeq + ".xml");
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            sb.delete(0, sb.length());
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bw.write(lineSep);
            bw.write("<doc>");
            bw.write(lineSep);
            bw.write("<item>");
            bw.write(lineSep);
            sb.append("<sql> ").append(Sql.EasMultilan_ins).append("(?,?,?,?,?,?) </sql>").append(lineSep);
            bw.write(sb.toString());
            sb.delete(0, sb.length());
            do {
                sb.append("<para>").append(lineSep);
                sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FID")).append("]]></FID>").append(lineSep);
                sb.append("<fparentID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fparentID")).append("]]></fparentID>").append(lineSep);
                sb.append("<FLanguageId dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FLanguageId")).append("]]></FLanguageId>").append(lineSep);
                sb.append("<Fcontent dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("Fcontent")).append("]]></Fcontent>").append(lineSep);
                sb.append("<FISTranslated dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISTranslated")).append("]]></FISTranslated>").append(lineSep);
                sb.append("<FCNMD5Code dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FCNMD5Code")).append("]]></FCNMD5Code>").append(lineSep);
                sb.append("</para>").append(lineSep);
                bw.write(sb.toString());
                bw.write(lineSep);
                sb.delete(0, sb.length());
                if (++recordIndex % sqlFileMaxRecord != 0) continue;
                bw.write("</item>");
                bw.write(lineSep);
                bw.write("</doc>");
                bw.flush();
                recordIndex = 0;
                file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_EASMultiLanRes_" + ++sqlFileSeq + ".xml");
                if (!file.exists()) {
                    file.createNewFile();
                }
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                element = root.addElement("xml");
                element.addText("./ml/t_res_EASMultiLanRes_" + sqlFileSeq + ".xml");
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                bw.write("<item>");
                bw.write(lineSep);
                sb.append("<sql> ").append(Sql.EasMultilan_ins).append("(?,?,?,?,?,?) </sql>").append(lineSep);
                bw.write(sb.toString());
                sb.delete(0, sb.length());
            } while (rs.next());
            bw.write("</item>");
            bw.write(lineSep);
            bw.write("</doc>");
            bw.flush();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (fo != null) {
                fo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePresetDataResourseInsSql(Element root) throws Exception {
        File file;
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        sqlFileSeq = 1;
        recordIndex = 0;
        Connection conn = Helper.getInitDBConn();
        ResultSet rs = conn.createStatement().executeQuery(Sql.PresetDataRes_quy);
        if (!rs.next()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        BufferedWriter bw = null;
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/ml");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_PresetDataRes_" + sqlFileSeq + ".xml")).exists()) {
            file.createNewFile();
        }
        Element element = null;
        element = root.addElement("xml");
        element.addText("./ml/t_res_PresetDataRes_" + sqlFileSeq + ".xml");
        FileOutputStream fo = null;
        BufferedOutputStream bo = null;
        try {
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            sb.delete(0, sb.length());
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bw.write(lineSep);
            bw.write("<doc>");
            bw.write(lineSep);
            sb.append("<item>").append(lineSep);
            sb.append("<sql> ").append(Sql.PresetDataRes_ins).append("(?,?,?,?,?,?,?,?) </sql>").append(lineSep);
            bw.write(sb.toString());
            sb.delete(0, sb.length());
            do {
                sb.append("<para>").append(lineSep);
                sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FID")).append("]]></FID>").append(lineSep);
                sb.append("<FParentID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FParentID")).append("]]></FParentID>").append(lineSep);
                sb.append("<FSourceID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FSourceID")).append("]]></FSourceID>").append(lineSep);
                sb.append("<FText_zh_CN dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FText_zh_CN").substring(250)).append("]]></FText_zh_CN>").append(lineSep);
                sb.append("<FText_zh_TW dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FText_zh_TW").substring(250)).append("]]></FText_zh_TW>").append(lineSep);
                sb.append("<FText_en_US dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FText_en_US").substring(250)).append("]]></FText_en_US>").append(lineSep);
                sb.append("<FISInvalid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FISInvalid")).append("]]></FISInvalid>").append(lineSep);
                sb.append("<FMD5 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FMD5")).append("]]></FMD5>").append(lineSep);
                sb.append("</para>").append(lineSep);
                bw.write(sb.toString());
                sb.delete(0, sb.length());
                if (++recordIndex % sqlFileMaxRecord != 0) continue;
                bw.write("</item>");
                bw.write(lineSep);
                bw.write("</doc>");
                bw.flush();
                recordIndex = 0;
                file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_PresetDataRes_" + ++sqlFileSeq + ".xml");
                if (!file.exists()) {
                    file.createNewFile();
                }
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                element = root.addElement("xml");
                element.addText("./ml/t_res_PresetDataRes_" + sqlFileSeq + ".xml");
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                sb.append("<item>").append(lineSep);
                sb.append("<sql> ").append(Sql.PresetDataRes_ins).append("(?,?,?,?,?,?,?,?) </sql>").append(lineSep);
                bw.write(sb.toString());
                sb.delete(0, sb.length());
            } while (rs.next());
            bw.write("</item>");
            bw.write(lineSep);
            bw.write("</doc>");
            bw.flush();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (bw != null) {
                bw.close();
            }
            if (fo != null) {
                fo.close();
            }
            if (bo != null) {
                bo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMetaDataResSql() throws Exception {
        Map map;
        String[] resArr = new String[]{"t_res_UIResource", "t_res_ResResource", "t_res_EnumResource", "t_res_EntityResource", "t_res_QueryResource", "T_RES_MdbviewResource"};
        String[] resMlArr = new String[]{"t_res_UIMultiLan", "t_res_ResMultiLan", "t_res_EnumMultiLan", "t_res_EntityMultiLan", "t_res_QueryMultiLan", "T_RES_MdbviewMultiLan"};
        String temp_Sql = "select fid,fkey,fpackage,FFileName,FProject,FIsValid,FmetaType,FISPatch,FRes,FRes2,FMD5,FDomainId from ";
        StringBuilder ins_sql = new StringBuilder();
        Connection conn = Helper.getInitDBConn();
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((map = this.getDomain()) == null || map.size() <= 0) {
            return;
        }
        String notInSQL = this.getNotInSql(map);
        EASDomain otherDomain = new EASDomain();
        otherDomain.setId("other");
        otherDomain.setProject("other");
        otherDomain.setName1("other");
        otherDomain.setName2("\u5176\u5b83");
        otherDomain.setName3("\u5176\u5b83");
        map.put("other", otherDomain);
        Set set = map.entrySet();
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        for (Map.Entry entry : set) {
            String lineSep;
            BufferedWriter bw;
            BufferedOutputStream bo;
            FileOutputStream fo;
            File f;
            ResultSet rs;
            String quy_sql;
            int i;
            String projectId = entry.getKey().toString();
            EASDomain dmInfo = (EASDomain)entry.getValue();
            File d = new File(dir.getPath() + System.getProperty("file.separator") + dmInfo.getProject());
            if (!d.exists()) {
                d.mkdirs();
            }
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("System");
            root.addAttribute("name", dmInfo.getProject());
            Element element = null;
            for (i = 0; i < resArr.length; ++i) {
                sqlFileSeq = 1;
                recordIndex = 0;
                quy_sql = projectId.equals("other") ? temp_Sql + resArr[i] + " where " + notInSQL : temp_Sql + resArr[i] + " where FProject = '" + projectId + "'";
                rs = conn.createStatement().executeQuery(quy_sql);
                if (!rs.next()) continue;
                f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                if (!f.exists()) {
                    f.createNewFile();
                }
                element = root.addElement("xml");
                element.addText("./" + dmInfo.getProject() + "/" + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                fo = null;
                bo = null;
                bw = null;
                lineSep = System.getProperty("line.separator");
                try {
                    fo = new FileOutputStream(f);
                    bo = new BufferedOutputStream(fo);
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                    String fpackage = null;
                    String ffileName = null;
                    String fkey = null;
                    String fMD5 = null;
                    bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    bw.write(lineSep);
                    bw.write("<doc>");
                    bw.write(lineSep);
                    ins_sql.append("<item>").append(lineSep);
                    ins_sql.append("<sql> insert into ").append(resArr[i]).append("(fid,fkey,fpackage,FFileName,FProject,FIsValid,FmetaType,FISPatch,FRes,FMD5,FDomainId) values");
                    ins_sql.append("(?,?,?,?,?,?,?,?,?,?,?)</sql>").append(lineSep);
                    bw.write(ins_sql.toString());
                    ins_sql.delete(0, ins_sql.length());
                    do {
                        fpackage = rs.getString("fpackage");
                        ffileName = rs.getString("FFileName");
                        fkey = rs.getString("fkey");
                        fMD5 = rs.getString("FMD5");
                        ins_sql.append("<para>").append(lineSep);
                        ins_sql.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                        ins_sql.append("<fkey dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fkey")).append("]]></fkey>").append(lineSep);
                        ins_sql.append("<fpackage dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fpackage")).append("]]></fpackage>").append(lineSep);
                        ins_sql.append("<FFileName dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFileName")).append("]]></FFileName>").append(lineSep);
                        ins_sql.append("<FProject dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FProject")).append("]]></FProject>").append(lineSep);
                        ins_sql.append("<FIsValid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FIsValid")).append("]]></FIsValid>").append(lineSep);
                        ins_sql.append("<FmetaType dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FmetaType")).append("]]></FmetaType>").append(lineSep);
                        ins_sql.append("<FISPatch dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FISPatch")).append("]]></FISPatch>").append(lineSep);
                        ins_sql.append("<FRes dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FRes") == null ? "" : rs.getString("FRes")).append("]]></FRes>").append(lineSep);
                        ins_sql.append("<FMD5 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FMD5")).append("]]></FMD5>").append(lineSep);
                        if (StringUtils.isEmpty((String)rs.getString("FDomainId"))) {
                            ins_sql.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[]]></FDomainId>").append(lineSep);
                        } else {
                            ins_sql.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FDomainId")).append("]]></FDomainId>").append(lineSep);
                        }
                        ins_sql.append("</para>").append(lineSep);
                        bw.write(ins_sql.toString());
                        ins_sql.delete(0, ins_sql.length());
                        if (++recordIndex % sqlFileMaxRecord != 0) continue;
                        bw.write("</item>");
                        bw.write(lineSep);
                        bw.write("</doc>");
                        bw.flush();
                        recordIndex = 0;
                        f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resArr[i] + "_" + ++sqlFileSeq + ".xml");
                        f.createNewFile();
                        fo = new FileOutputStream(f);
                        bo = new BufferedOutputStream(fo);
                        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                        element = root.addElement("xml");
                        element.addText("./" + dmInfo.getProject() + "/" + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                        bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        bw.write(lineSep);
                        bw.write("<doc>");
                        bw.write(lineSep);
                        ins_sql.append("<item>").append(lineSep);
                        ins_sql.append("<sql> insert into ").append(resArr[i]).append("(fid,fkey,fpackage,FFileName,FProject,FIsValid,FmetaType,FISPatch,FRes,FMD5,FDomainId) values");
                        ins_sql.append("(?,?,?,?,?,?,?,?,?,?,?)</sql>").append(lineSep);
                    } while (rs.next());
                    bw.write("</item>");
                    bw.write(lineSep);
                    bw.write("</doc>");
                    bw.flush();
                    continue;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                    if (bo != null) {
                        bo.close();
                    }
                    if (fo != null) {
                        fo.close();
                    }
                }
            }
            for (i = 0; i < resMlArr.length; ++i) {
                sqlFileSeq = 1;
                recordIndex = 0;
                quy_sql = projectId.equals("other") ? " select ml.fid fid, ml.fresid fresId,ml.flanguage flanguage, ml.fmlRes fmlRes, ml.fmlRes2 fmlRes2, ml.fcnmd5 fcnmd5, ml.FForbidSysUpd FForbidSysUpd from " + resMlArr[i] + " ml left join " + resArr[i] + " res on res.fid = ml.fresId where ml.flanguage = '" + this.language + "' and " + notInSQL : " select ml.fid fid, ml.fresid fresId,ml.flanguage flanguage, ml.fmlRes fmlRes, ml.fmlRes2 fmlRes2, ml.fcnmd5 fcnmd5, ml.FForbidSysUpd FForbidSysUpd from " + resMlArr[i] + " ml left join " + resArr[i] + " res on res.fid = ml.fresId where ml.flanguage = '" + this.language + "' and FProject = '" + projectId + "'";
                rs = conn.createStatement().executeQuery(quy_sql);
                if (!rs.next()) continue;
                d = new File(dir.getPath() + System.getProperty("file.separator") + dmInfo.getProject());
                if (!d.exists()) {
                    d.mkdir();
                }
                if (!(f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resMlArr[i] + "_" + sqlFileSeq + ".xml")).exists()) {
                    f.createNewFile();
                }
                element = root.addElement("xml");
                element.addText("./" + dmInfo.getProject() + "/" + dmInfo.getProject() + "_" + resMlArr[i] + "_" + sqlFileSeq + ".xml");
                fo = null;
                bo = null;
                bw = null;
                try {
                    fo = new FileOutputStream(f);
                    bo = new BufferedOutputStream(fo);
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                    lineSep = System.getProperty("line.separator");
                    ins_sql.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    ins_sql.append(lineSep);
                    ins_sql.append("<doc>");
                    ins_sql.append(lineSep);
                    ins_sql.append("<item>").append(lineSep);
                    ins_sql.append("<sql> insert into ").append(resMlArr[i]).append("(fid,fresid,flanguage,fmlRes,fcnmd5,FForbidSysUpd) values");
                    ins_sql.append("(?,?,?,?,?,?)</sql>").append(lineSep);
                    bw.write(ins_sql.toString());
                    ins_sql.delete(0, ins_sql.length());
                    do {
                        ins_sql.append("<para>").append(lineSep);
                        ins_sql.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                        ins_sql.append("<fresid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fresid")).append("]]></fresid>").append(lineSep);
                        ins_sql.append("<flanguage dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("flanguage")).append("]]></flanguage>").append(lineSep);
                        ins_sql.append("<fmlRes dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fmlRes2") == null ? "" : rs.getString("fmlRes2")).append("]]></fmlRes>").append(lineSep);
                        ins_sql.append("<fcnmd5 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fcnmd5")).append("]]></fcnmd5>").append(lineSep);
                        ins_sql.append("<FForbidSysUpd dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FForbidSysUpd")).append("]]></FForbidSysUpd>").append(lineSep);
                        ins_sql.append("</para>").append(lineSep);
                        bw.write(ins_sql.toString());
                        bw.write(lineSep);
                        ins_sql.delete(0, ins_sql.length());
                        if (++recordIndex % sqlFileMaxRecord != 0) continue;
                        bw.write("</item>");
                        bw.write(lineSep);
                        bw.write("</doc>");
                        bw.flush();
                        recordIndex = 0;
                        f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resMlArr[i] + "_" + ++sqlFileSeq + ".xml");
                        if (!f.exists()) {
                            f.createNewFile();
                        }
                        fo = new FileOutputStream(f);
                        bo = new BufferedOutputStream(fo);
                        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                        element = root.addElement("xml");
                        element.addText("./" + dmInfo.getProject() + "/" + dmInfo.getProject() + "_" + resMlArr[i] + "_" + sqlFileSeq + ".xml");
                        bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        bw.write(lineSep);
                        bw.write("<doc>");
                        bw.write(lineSep);
                        ins_sql.append("<item>").append(lineSep);
                        ins_sql.append("<sql> insert into ").append(resMlArr[i]).append("(fid,fresid,flanguage,fmlRes,fcnmd5,FForbidSysUpd) values");
                        ins_sql.append("(?,?,?,?,?,?)</sql>").append(lineSep);
                    } while (rs.next());
                    bw.write("</item>");
                    bw.write(lineSep);
                    bw.write("</doc>");
                    bw.flush();
                    continue;
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (bo != null) {
                        bo.close();
                    }
                    if (fo != null) {
                        fo.close();
                    }
                }
            }
            String sqlCreateFileName = d.getPath() + System.getProperty("file.separator") + "create.xml";
            File f2 = new File(sqlCreateFileName);
            if (!f2.exists()) {
                f2.createNewFile();
            }
            FileOutputStream fo2 = null;
            FilterOutputStream bo2 = null;
            BufferedWriter out = null;
            try {
                fo2 = new FileOutputStream(f2);
                bo2 = new BufferedOutputStream(fo2);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)bo2, "UTF-8"));
                document.write((Writer)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (bo2 != null) {
                    bo2.close();
                }
                if (fo2 == null) continue;
                fo2.close();
            }
        }
    }

    private void generateMenuUpdateSql2() throws Exception {
        Connection conn = Helper.getInitDBConn();
        String sql_US = "select mf.FTableName tn, mf.FFieldName_l1 fn,  res.FSourceId srcId, res.FText_en_US en  from t_res_presetDataRes res  left join t_res_multifieldmeta mf on res.fparentID = mf.fid  where mf.ftype = 2 and res.FText_en_US is not null and res.FSourceId is not null  order by mf.FTableName ,mf.FFieldName_l1 ";
        String sql_TW = "select mf.FTableName tn, mf.FFieldName_l3 fn,  res.FSourceId srcId, res.FText_zh_TW tw  from t_res_presetDataRes res  left join t_res_multifieldmeta mf on res.fparentID = mf.fid  where mf.ftype = 2 and res.FText_zh_TW is not null and res.FSourceId is not null  order by mf.FTableName ,mf.FFieldName_l3";
        if ("en_US".equalsIgnoreCase(this.language)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMenuUpdateSql() throws Exception {
        Connection conn = Helper.getInitDBConn();
        StringBuilder sb = new StringBuilder();
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/update");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file_sysmenuitem = new File(dir.getPath() + System.getProperty("file.separator") + "updateMenu_sysmenuitem.sql");
        File file_mainmenuitem = new File(dir.getPath() + System.getProperty("file.separator") + "updateMenu_mainmenuitem.sql");
        if (!file_mainmenuitem.exists()) {
            file_mainmenuitem.createNewFile();
        }
        if (!file_sysmenuitem.exists()) {
            file_sysmenuitem.createNewFile();
        }
        String lineSep = System.getProperty("line.separator");
        if ("en_US".equalsIgnoreCase(this.language)) {
            String sql = " select mf.FTableName tn, mf.FFieldName_l1 fn,  res.FSourceId srcId, res.FText_en_US en  from t_res_presetDataRes res  left join t_res_multifieldmeta mf on res.fparentID = mf.fid  where mf.ftype = 2 and res.FText_en_US is not null and res.FSourceId is not null  order by mf.FTableName ,mf.FFieldName_l1 ";
            ResultSet rs = conn.createStatement().executeQuery(sql);
            FileOutputStream fo = null;
            FilterOutputStream bo = null;
            BufferedWriter bw = null;
            try {
                fo = new FileOutputStream(file_sysmenuitem);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                bw.write("<item>");
                bw.write(lineSep);
                sb.append("<sql>").append("update t_bas_sysmenuitem set  Fname_l1= ? where FID = ?").append("</sql>");
                bw.write(sb.toString());
                bw.write(lineSep);
                sb.delete(0, sb.length());
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
                if (bo != null) {
                    bo.close();
                }
                if (fo != null) {
                    fo.close();
                }
            }
            FileOutputStream fo2 = null;
            BufferedOutputStream bo2 = null;
            BufferedWriter bw2 = null;
            try {
                fo2 = new FileOutputStream(file_mainmenuitem);
                bo2 = new BufferedOutputStream(fo2);
                bw2 = new BufferedWriter(new OutputStreamWriter((OutputStream)bo2, "utf-8"));
                bw2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw2.write(lineSep);
                bw2.write("<doc>");
                bw2.write(lineSep);
                bw2.write("<item>");
                bw2.write(lineSep);
                sb.append("<sql>").append("update t_pm_mainmenuitem set FDescription_L1 = ? where FID = ?").append("</sql>");
                bw2.write(sb.toString());
                bw2.write(lineSep);
                sb.delete(0, sb.length());
                while (rs.next()) {
                    String tableName = rs.getString("tn");
                    String fieldName = rs.getString("fn");
                    String en = SqlGenerator.transformStr(rs.getString("en"));
                    String srcId = rs.getString("srcId");
                    if (tableName.equalsIgnoreCase("t_bas_sysmenuitem")) {
                        sb.append("<para>").append(lineSep);
                        sb.append("<Fname_l1 dataInFile=\"false\" type=\"9\"><![CDATA[").append(en).append("]]></Fname_l1>").append(lineSep);
                        sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(srcId).append("]]></FID>").append(lineSep);
                        sb.append("</para>");
                        bw.write(sb.toString());
                        bw.write(lineSep);
                        sb.delete(0, sb.length());
                    } else {
                        sb.append("<para>").append(lineSep);
                        sb.append("<FDescription_L1 dataInFile=\"false\" type=\"9\"><![CDATA[").append(en).append("]]></FDescription_L1>").append(lineSep);
                        sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(srcId).append("]]></FID>").append(lineSep);
                        sb.append("</para>");
                        bw2.write(sb.toString());
                        bw2.write(lineSep);
                        sb.delete(0, sb.length());
                    }
                    bw.flush();
                    bw2.flush();
                }
                bw.write("</item>");
                bw.write(lineSep);
                bw.write("</doc>");
                bw2.write("</item>");
                bw2.write(lineSep);
                bw2.write("</doc>");
                bw.flush();
                bw2.flush();
            }
            finally {
                if (bw2 != null) {
                    bw2.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (fo2 != null) {
                    fo2.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        if ("zh_TW".equalsIgnoreCase(this.language)) {
            String sql = " select mf.FTableName tn, mf.FFieldName_l3 fn,  res.FSourceId srcId, res.FText_zh_TW tw  from t_res_presetDataRes res  left join t_res_multifieldmeta mf on res.fparentID = mf.fid  where mf.ftype = 2 and res.FText_zh_TW is not null and res.FSourceId is not null  order by mf.FTableName ,mf.FFieldName_l3 ";
            ResultSet rs = conn.createStatement().executeQuery(sql);
            FileOutputStream fo = null;
            BufferedOutputStream bo = null;
            BufferedWriter bw = null;
            FileOutputStream fo2 = null;
            FilterOutputStream bo2 = null;
            BufferedWriter bw2 = null;
            try {
                fo = new FileOutputStream(file_sysmenuitem);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
                fo2 = new FileOutputStream(file_mainmenuitem);
                bo2 = new BufferedOutputStream(fo2);
                bw2 = new BufferedWriter(new OutputStreamWriter((OutputStream)bo2, "utf-8"));
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                bw.write("<item>");
                bw.write(lineSep);
                sb.append("<sql>").append("update t_bas_sysmenuitem set Fname_l3  = ? where FID = ?").append("</sql>");
                bw.write(sb.toString());
                bw.write(lineSep);
                sb.delete(0, sb.length());
                bw2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw2.write(lineSep);
                bw2.write("<doc>");
                bw2.write(lineSep);
                bw2.write("<item>");
                bw2.write(lineSep);
                sb.append("<sql>").append("update t_pm_mainmenuitem set FDescription_L3 = ? where FID = ?").append("</sql>");
                bw2.write(sb.toString());
                bw2.write(lineSep);
                sb.delete(0, sb.length());
                while (rs.next()) {
                    String tableName = rs.getString("tn");
                    String fieldName = rs.getString("fn");
                    String tw = SqlGenerator.transformStr(rs.getString("tw"));
                    String srcId = rs.getString("srcId");
                    if (tableName.equalsIgnoreCase("t_bas_sysmenuitem")) {
                        sb.append("<para>").append(lineSep);
                        sb.append("<Fname_l3 dataInFile=\"false\" type=\"9\"><![CDATA[").append(tw).append("]]></Fname_l3>").append(lineSep);
                        sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(srcId).append("]]></FID>").append(lineSep);
                        sb.append("</para>");
                        bw.write(sb.toString());
                        bw.write(lineSep);
                        sb.delete(0, sb.length());
                    } else {
                        sb.append("<para>").append(lineSep);
                        sb.append("<FDescription_L3 dataInFile=\"false\" type=\"9\"><![CDATA[").append(tw).append("]]></FDescription_L3>").append(lineSep);
                        sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(srcId).append("]]></FID>").append(lineSep);
                        sb.append("</para>");
                        bw2.write(sb.toString());
                        bw2.write(lineSep);
                        sb.delete(0, sb.length());
                    }
                    bw.flush();
                    bw2.flush();
                }
                bw.write("</item>");
                bw.write(lineSep);
                bw.write("</doc>");
                bw2.write("</item>");
                bw2.write(lineSep);
                bw2.write("</doc>");
                bw.flush();
                bw2.flush();
            }
            finally {
                if (fo != null) {
                    fo.close();
                }
                if (fo2 != null) {
                    fo2.close();
                }
                if (bo != null) {
                    bo.close();
                }
                if (bo2 != null) {
                    bo2.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (bw != null) {
                    bw.close();
                }
                if (bw2 != null) {
                    bw2.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePresetDataUpdateSql() throws Exception {
        String sql = " select mf.FTableName tn, mf.FFieldName_l1 fn,  res.FSourceId srcId, res.FText_en_US en  from t_res_presetDataRes res  left join t_res_multifieldmeta mf on res.fparentID = mf.fid  where mf.ftype != 2 and res.FText_en_US is not null and res.FSourceId is not null  order by mf.FTableName ,mf.FFieldName_l1 ";
        Connection conn = Helper.getInitDBConn();
        ResultSet rs = conn.createStatement().executeQuery(sql);
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "updatePresetData.xml");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fo = null;
        FilterOutputStream bo = null;
        BufferedWriter bw = null;
        try {
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            StringBuilder sb = new StringBuilder();
            String lineSep = System.getProperty("line.separator");
            while (rs.next()) {
                String tableName = rs.getString("tn");
                String fieldName = rs.getString("fn");
                String srcId = rs.getString("srcId");
                String en = SqlGenerator.transformStr(rs.getString("en"));
                sb.append("update ").append(tableName).append(" set ").append(fieldName).append(" = '").append(en).append("' where FID = '").append(srcId).append("';").append(lineSep);
                bw.write(sb.toString());
                sb.delete(0, sb.length());
            }
            bw.flush();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (bo != null) {
                bo.close();
            }
            if (fo != null) {
                fo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePresetDataUpdateSql2() throws Exception {
        this.ignoreTables.add("t_log_app");
        this.ignoreTables.add("t_log_his");
        this.ignoreTables.add("t_pm_user");
        this.ignoreTables.add("t_pm_permitemchangereport");
        this.ignoreTables.add("t_bas_message");
        this.ignoreTables.add("t_fa_assistactitem");
        this.ignoreTables.add("t_bd_person");
        this.ignoreTables.add("t_fw_usercustomconfig");
        if ("en_US".equalsIgnoreCase(this.language)) {
            File file;
            StringBuffer sb = new StringBuffer();
            sb.append(" select mf.FTableName tn, ");
            sb.append("        mf.FFieldName_l1 fn, ");
            sb.append("        res.FSourceId srcId, ");
            sb.append("        res.FText_en_US en, ");
            sb.append("        mf.ffieldlen length, ");
            sb.append("        mf.FPrimeryKey primeryKey ");
            sb.append(" from t_res_presetDataRes res ");
            sb.append("      left join t_res_multifieldmeta mf on res.fparentID = mf.fid ");
            sb.append(" where mf.ftype != 2 ");
            sb.append("   and res.FText_en_US is not null ");
            sb.append("   and res.FText_en_US <> 'null' ");
            sb.append("   and res.FSourceId is not null ");
            sb.append(" order by mf.FTableName ,mf.FFieldName_l1 ");
            String sql = sb.toString();
            Connection conn = Helper.getInitDBConn();
            ResultSet rs = conn.createStatement().executeQuery(sql);
            File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/update");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "updatePresetData.sql")).exists()) {
                file.createNewFile();
            }
            FileOutputStream fo = null;
            FilterOutputStream bo = null;
            BufferedWriter bw = null;
            try {
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
                String lineSep = System.getProperty("line.separator");
                while (rs.next()) {
                    String tableName = rs.getString("tn");
                    if (this.ignoreTables.contains(tableName.toLowerCase())) continue;
                    String fieldName = rs.getString("fn");
                    String srcId = rs.getString("srcId");
                    String en = SqlGenerator.transformStr(rs.getString("en"));
                    if (en.length() > 250) {
                        en = en.substring(0, 250);
                    }
                    int length = rs.getInt("length");
                    String primeryKey = rs.getString("primeryKey");
                    String upd_sql = "";
                    upd_sql = tableName.equalsIgnoreCase("t_hr_f7info") || tableName.equalsIgnoreCase("t_hr_employeesystempage") ? "update " + tableName + " set " + fieldName + " = N'" + en + "' where " + primeryKey + " = " + srcId + "^" : "update " + tableName + " set " + fieldName + " = N'" + en + "' where " + primeryKey + " = '" + srcId + "'^";
                    bw.write(upd_sql);
                    bw.write(lineSep);
                }
                bw.flush();
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
                if (bo != null) {
                    bo.close();
                }
                if (fo != null) {
                    fo.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        if ("zh_TW".equalsIgnoreCase(this.language)) {
            File file;
            StringBuffer sb = new StringBuffer();
            sb.append(" select mf.FTableName tn, ");
            sb.append("        mf.FFieldName_l3 fn, ");
            sb.append("        res.FSourceId srcId, ");
            sb.append("        res.FText_zh_TW tw, ");
            sb.append("        mf.ffieldlen length, ");
            sb.append("        mf.FPrimeryKey primeryKey ");
            sb.append(" from t_res_presetDataRes res ");
            sb.append("      left join t_res_multifieldmeta mf on res.fparentID = mf.fid ");
            sb.append(" where mf.ftype != 2 ");
            sb.append("   and res.FText_zh_TW is not null ");
            sb.append("   and res.FText_zh_TW <> 'null' ");
            sb.append("   and res.FSourceId is not null ");
            sb.append(" order by mf.FTableName ,mf.FFieldName_l3 ");
            String sql = sb.toString();
            Connection conn = Helper.getInitDBConn();
            ResultSet rs = conn.createStatement().executeQuery(sql);
            File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/update");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "updatePresetData.sql")).exists()) {
                file.createNewFile();
            }
            FileOutputStream fo = null;
            FilterOutputStream bo = null;
            BufferedWriter bw = null;
            try {
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
                String lineSep = System.getProperty("line.separator");
                while (rs.next()) {
                    String tableName = rs.getString("tn");
                    if (this.ignoreTables.contains(tableName.toLowerCase())) continue;
                    String fieldName = rs.getString("fn");
                    String srcId = rs.getString("srcId");
                    String tw = SqlGenerator.transformStr(rs.getString("tw"));
                    if (tw.length() > 250) {
                        tw = tw.substring(0, 250);
                    }
                    int length = rs.getInt("length");
                    String primeryKey = rs.getString("primeryKey");
                    String upd_sql = "";
                    upd_sql = tableName.equalsIgnoreCase("t_hr_f7info") || tableName.equalsIgnoreCase("t_hr_employeesystempage") ? "update " + tableName + " set " + fieldName + " = N'" + tw + "' where " + primeryKey + " = " + srcId + "^" : "update " + tableName + " set " + fieldName + " = N'" + tw + "' where " + primeryKey + " = '" + srcId + "'^";
                    bw.write(upd_sql);
                    bw.write(lineSep);
                }
                bw.flush();
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
                if (bo != null) {
                    bo.close();
                }
                if (fo != null) {
                    fo.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUpdateL1Sql() throws Exception {
        File file;
        String sql = " select FTableName tn, FFieldName_l1 l1,FFieldName_l2 l2 from t_res_multifieldmeta where FISInvalid = 0 order by FTableName";
        Connection conn = Helper.getInitDBConn();
        ResultSet rs = conn.createStatement().executeQuery(sql);
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/update");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "updateL1.xml")).exists()) {
            file.createNewFile();
        }
        FileOutputStream fo = null;
        BufferedOutputStream bo = null;
        BufferedWriter bw = null;
        try {
            String upd_sql;
            String l2;
            String tableName;
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            String lineSep = System.getProperty("line.separator");
            while (rs.next()) {
                tableName = rs.getString("tn");
                l2 = rs.getString("l2");
                String l1 = rs.getString("l1");
                upd_sql = "update " + tableName + " set " + l1 + " = " + l2 + " where " + l1 + " is null;";
                bw.write(upd_sql);
                bw.write(lineSep);
            }
            bw.flush();
            sql = " select FTableName tn, FFieldName_l3 l3,FFieldName_l2 l2 from t_res_multifieldmeta where FISInvalid = 0 order by FTableName";
            rs = conn.createStatement().executeQuery(sql);
            dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/update");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "updateL3.xml")).exists()) {
                file.createNewFile();
            }
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            while (rs.next()) {
                tableName = rs.getString("tn");
                l2 = rs.getString("l2");
                String l3 = rs.getString("l3");
                upd_sql = "update " + tableName + " set " + l3 + " = " + l2 + " where " + l3 + " is null;";
                bw.write(upd_sql);
                bw.write(lineSep);
            }
            bw.flush();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (bo != null) {
                fo.close();
            }
            if (bo != null) {
                bo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUpdateL1Sql2() throws Exception {
        String sql = " select FTableName tn, FFieldName_l1 l1,FFieldName_l2 l2 from t_res_multifieldmeta where FISInvalid = 0 order by FTableName";
        Connection conn = Helper.getInitDBConn();
        ResultSet rs = conn.createStatement().executeQuery(sql);
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "updateL1.xml");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fo = null;
        FilterOutputStream bo = null;
        BufferedWriter bw = null;
        try {
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            String lineSep = System.getProperty("line.separator");
            while (rs.next()) {
                String tableName = rs.getString("tn");
                String l2 = rs.getString("l2");
                String l1 = rs.getString("l1");
                String upd_sql = "update " + tableName + " set " + l1 + " = " + l2 + " where " + l1 + " is null or " + l1 + " = 'null' or " + l1 + " = '' ";
                bw.write(upd_sql);
                bw.write(lineSep);
            }
            bw.flush();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (bo != null) {
                bo.close();
            }
            if (fo != null) {
                fo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMultiFieldSql(Element root) throws Exception {
        File file;
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        sqlFileSeq = 1;
        recordIndex = 0;
        Connection conn = Helper.getInitDBConn();
        ResultSet rs = conn.createStatement().executeQuery(Sql.MultiFieldMeta_quy);
        if (!rs.next()) {
            rs.close();
            return;
        }
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        BufferedWriter bw = null;
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/ml");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_MultiFieldMeta_" + sqlFileSeq + ".xml")).exists()) {
            file.createNewFile();
        }
        Element element = null;
        element = root.addElement("xml");
        element.addText("./ml/t_res_MultiFieldMeta_" + sqlFileSeq + ".xml");
        FileOutputStream fo = null;
        BufferedOutputStream bo = null;
        try {
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bw.write(lineSep);
            bw.write("<doc>");
            bw.write(lineSep);
            sb.append("<item>").append(lineSep);
            sb.append("<sql> ").append(Sql.MultiFieldMeta_ins);
            sb.append("(?,?,?,?,?,?,?,?,?,?,?)</sql>").append(lineSep);
            bw.write(sb.toString());
            sb.delete(0, sb.length());
            do {
                sb.append("<para>").append(lineSep);
                sb.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                sb.append("<FTableName dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FTableName")).append("]]></FTableName>").append(lineSep);
                sb.append("<FProject dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FProject")).append("]]></FProject>").append(lineSep);
                sb.append("<FFieldName_l1 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFieldName_l1") == null ? "" : rs.getString("FFieldName_l1")).append("]]></FFieldName_l1>").append(lineSep);
                sb.append("<FFieldName_l2 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFieldName_l2") == null ? "" : rs.getString("FFieldName_l2")).append("]]></FFieldName_l2>").append(lineSep);
                sb.append("<FFieldName_l3 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFieldName_l3") == null ? "" : rs.getString("FFieldName_l3")).append("]]></FFieldName_l3>").append(lineSep);
                sb.append("<FISBigField dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISBigField")).append("]]></FISBigField>").append(lineSep);
                sb.append("<FFieldLen dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FFieldLen")).append("]]></FFieldLen>").append(lineSep);
                sb.append("<FISInvalid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISInvalid")).append("]]></FISInvalid>").append(lineSep);
                sb.append("<FType dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FType")).append("]]></FType>").append(lineSep);
                sb.append("<FPrimeryKey dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FPrimeryKey")).append("]]></FPrimeryKey>").append(lineSep);
                sb.append("</para>").append(lineSep);
                bw.write(sb.toString());
                bw.write(lineSep);
                sb.delete(0, sb.length());
                if (++recordIndex % sqlFileMaxRecord != 0) continue;
                bw.write("</item>");
                bw.write(lineSep);
                bw.write("</doc>");
                bw.flush();
                recordIndex = 0;
                file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_MultiFieldMeta_" + ++sqlFileSeq + ".xml");
                if (!file.exists()) {
                    file.createNewFile();
                }
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                element = root.addElement("xml");
                element.addText("./ml/t_res_MultiFieldMeta_" + sqlFileSeq + ".xml");
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                sb.append("<item>").append(lineSep);
                sb.append("<sql> ").append(Sql.MultiFieldMeta_ins);
                sb.append("(?,?,?,?,?,?,?,?,?,?,?)</sql>").append(lineSep);
            } while (rs.next());
            bw.write("</item>");
            bw.write(lineSep);
            bw.write("</doc>");
            if (bw != null) {
                bw.flush();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (bw != null) {
                bw.close();
            }
            if (fo != null) {
                fo.close();
            }
            if (bo != null) {
                bo.close();
            }
        }
    }

    private static String replaceSingleQuote(String str) {
        if (str == null) {
            return str;
        }
        str = str.replaceAll("\r", " ");
        str = str.replaceAll("\n", " ");
        return str.replaceAll("'", "''");
    }

    private static String toUtf8(String str) {
        if (str == null) {
            return str;
        }
        return new String(str.getBytes());
    }

    private static String transformStr(String str) {
        return SqlGenerator.toUtf8(SqlGenerator.replaceSingleQuote(str));
    }

    private String getNotInSql(Map map) {
        Set set = map.entrySet();
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append("FProject not in ");
        sb.append("(");
        boolean isFirst = true;
        for (Map.Entry entry : set) {
            String id = entry.getKey().toString();
            if (!isFirst) {
                sb.append(",");
            }
            sb.append("'").append(id).append("'");
            isFirst = false;
        }
        sb.append(")");
        sb.append(" or FProject is null");
        sb.append(")");
        return sb.toString();
    }

    private void generateCreateXml() {
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql");
        if (!dir.exists()) {
            return;
        }
        try {
            Map map = this.getDomain();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!f.isDirectory()) continue;
            String string = f.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGenerateFile() throws Exception {
        Map map;
        String[] resArr = new String[]{"t_res_UIResource", "t_res_ResResource", "t_res_EnumResource", "t_res_EntityResource", "t_res_QueryResource", "T_RES_MdbviewResource"};
        String[] resMlArr = new String[]{"t_res_UIMultiLan", "t_res_ResMultiLan", "t_res_EnumMultiLan", "t_res_EntityMultiLan", "t_res_QueryMultiLan", "T_RES_MdbviewMultiLan"};
        String temp_Sql = "select fid,fkey,fpackage,FFileName,FProject,FIsValid,FmetaType,FISPatch,FRes,FRes2,FMD5,FDomainId from ";
        StringBuilder ins_sql = new StringBuilder();
        Connection conn = Helper.getInitDBConn();
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((map = this.getDomain()) == null || map.size() <= 0) {
            return;
        }
        String notInSQL = this.getNotInSql(map);
        EASDomain otherDomain = new EASDomain();
        otherDomain.setId("other");
        otherDomain.setProject("other");
        otherDomain.setName1("other");
        otherDomain.setName2("\u5176\u5b83");
        otherDomain.setName3("\u5176\u5b83");
        map.put("other", otherDomain);
        Set set = map.entrySet();
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        for (Map.Entry entry : set) {
            String lineSep;
            BufferedWriter bw;
            FilterOutputStream bo;
            FileOutputStream fo;
            File f;
            ResultSet rs;
            String quy_sql;
            int i;
            String projectId = entry.getKey().toString();
            EASDomain dmInfo = (EASDomain)entry.getValue();
            File d = new File(dir.getPath() + System.getProperty("file.separator") + dmInfo.getProject());
            if (!d.exists()) {
                d.mkdirs();
            }
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("System");
            root.addAttribute("name", dmInfo.getProject());
            Element element = null;
            for (i = 0; i < resArr.length; ++i) {
                String fMD5;
                String fkey;
                String ffileName;
                String fpackage;
                sqlFileSeq = 1;
                recordIndex = 0;
                quy_sql = projectId.equals("other") ? temp_Sql + resArr[i] + " where " + notInSQL : temp_Sql + resArr[i] + " where FProject = '" + projectId + "'";
                rs = conn.createStatement().executeQuery(quy_sql);
                if (!rs.next()) continue;
                f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                if (!f.exists()) {
                    f.createNewFile();
                }
                fo = null;
                bo = null;
                bw = null;
                try {
                    fo = new FileOutputStream(f);
                    bo = new BufferedOutputStream(fo);
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                    lineSep = System.getProperty("line.separator");
                    fpackage = null;
                    ffileName = null;
                    fkey = null;
                    fMD5 = null;
                    do {
                        if (recordIndex % sqlFileMaxRecord == 0) {
                            if (sqlFileSeq != 1) {
                                bw.write("</item>");
                                bw.write(lineSep);
                                bw.write("</doc>");
                                bw.flush();
                            }
                            recordIndex = 0;
                            f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                            if (!f.exists()) {
                                f.createNewFile();
                            }
                            fo = new FileOutputStream(f);
                            bo = new BufferedOutputStream(fo);
                            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                            element = root.addElement("xml");
                            element.addText("./" + dmInfo.getProject() + "/" + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                            ++sqlFileSeq;
                            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                            bw.write(lineSep);
                            bw.write("<doc>");
                            bw.write(lineSep);
                            ins_sql.append("<item>").append(lineSep);
                            ins_sql.append("<sql> insert into ").append(resArr[i]).append("(fid,fkey,fpackage,FFileName,FProject,FIsValid,FmetaType,FISPatch,FRes,FMD5,FDomainId) values");
                            ins_sql.append("(?,?,?,?,?,?,?,?,?,?,?)</sql>").append(lineSep);
                        }
                        ++recordIndex;
                        fpackage = rs.getString("fpackage");
                        ffileName = rs.getString("FFileName");
                        fkey = rs.getString("fkey");
                        fMD5 = rs.getString("FMD5");
                        ins_sql.append("<para>").append(lineSep);
                        ins_sql.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                        ins_sql.append("<fkey dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fkey")).append("]]></fkey>").append(lineSep);
                        ins_sql.append("<fpackage dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fpackage")).append("]]></fpackage>").append(lineSep);
                        ins_sql.append("<FFileName dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFileName")).append("]]></FFileName>").append(lineSep);
                        ins_sql.append("<FProject dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FProject")).append("]]></FProject>").append(lineSep);
                        ins_sql.append("<FIsValid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FIsValid")).append("]]></FIsValid>").append(lineSep);
                        ins_sql.append("<FmetaType dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FmetaType")).append("]]></FmetaType>").append(lineSep);
                        ins_sql.append("<FISPatch dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FISPatch")).append("]]></FISPatch>").append(lineSep);
                        ins_sql.append("<FRes dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FRes") == null ? "" : rs.getString("FRes")).append("]]></FRes>").append(lineSep);
                        ins_sql.append("<FMD5 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FMD5")).append("]]></FMD5>").append(lineSep);
                        if (StringUtils.isEmpty((String)rs.getString("FDomainId"))) {
                            ins_sql.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[]]></FDomainId>").append(lineSep);
                        } else {
                            ins_sql.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FDomainId")).append("]]></FDomainId>").append(lineSep);
                        }
                        ins_sql.append("</para>").append(lineSep);
                        bw.write(ins_sql.toString());
                        ins_sql.delete(0, ins_sql.length());
                    } while (rs.next());
                    bw.write("</item>");
                    bw.write(lineSep);
                    bw.write("</doc>");
                    bw.flush();
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (bo != null) {
                        bo.close();
                    }
                }
                try {
                    bo = new BufferedOutputStream(fo);
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                    lineSep = System.getProperty("line.separator");
                    fpackage = null;
                    ffileName = null;
                    fkey = null;
                    fMD5 = null;
                    do {
                        if (recordIndex % sqlFileMaxRecord == 0) {
                            if (sqlFileSeq != 1) {
                                bw.write("</item>");
                                bw.write(lineSep);
                                bw.write("</doc>");
                                bw.flush();
                            }
                            recordIndex = 0;
                            f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                            if (!f.exists()) {
                                f.createNewFile();
                            }
                            fo = new FileOutputStream(f);
                            bo = new BufferedOutputStream(fo);
                            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                            element = root.addElement("xml");
                            element.addText("./" + dmInfo.getProject() + "/" + dmInfo.getProject() + "_" + resArr[i] + "_" + sqlFileSeq + ".xml");
                            ++sqlFileSeq;
                            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                            bw.write(lineSep);
                            bw.write("<doc>");
                            bw.write(lineSep);
                            ins_sql.append("<item>").append(lineSep);
                            ins_sql.append("<sql> insert into ").append(resArr[i]).append("(fid,fkey,fpackage,FFileName,FProject,FIsValid,FmetaType,FISPatch,FRes,FMD5,FDomainId) values");
                            ins_sql.append("(?,?,?,?,?,?,?,?,?,?,?)</sql>").append(lineSep);
                        }
                        ++recordIndex;
                        fpackage = rs.getString("fpackage");
                        ffileName = rs.getString("FFileName");
                        fkey = rs.getString("fkey");
                        fMD5 = rs.getString("FMD5");
                        ins_sql.append("<para>").append(lineSep);
                        ins_sql.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                        ins_sql.append("<fkey dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fkey")).append("]]></fkey>").append(lineSep);
                        ins_sql.append("<fpackage dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fpackage")).append("]]></fpackage>").append(lineSep);
                        ins_sql.append("<FFileName dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFileName")).append("]]></FFileName>").append(lineSep);
                        ins_sql.append("<FProject dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FProject")).append("]]></FProject>").append(lineSep);
                        ins_sql.append("<FIsValid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FIsValid")).append("]]></FIsValid>").append(lineSep);
                        ins_sql.append("<FmetaType dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FmetaType")).append("]]></FmetaType>").append(lineSep);
                        ins_sql.append("<FISPatch dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FISPatch")).append("]]></FISPatch>").append(lineSep);
                        ins_sql.append("<FRes dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FRes") == null ? "" : rs.getString("FRes")).append("]]></FRes>").append(lineSep);
                        ins_sql.append("<FMD5 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FMD5")).append("]]></FMD5>").append(lineSep);
                        if (StringUtils.isEmpty((String)rs.getString("FDomainId"))) {
                            ins_sql.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[]]></FDomainId>").append(lineSep);
                        } else {
                            ins_sql.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FDomainId")).append("]]></FDomainId>").append(lineSep);
                        }
                        ins_sql.append("</para>").append(lineSep);
                        bw.write(ins_sql.toString());
                        ins_sql.delete(0, ins_sql.length());
                    } while (rs.next());
                    bw.write("</item>");
                    bw.write(lineSep);
                    bw.write("</doc>");
                    bw.flush();
                    continue;
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (fo != null) {
                        fo.close();
                    }
                }
            }
            for (i = 0; i < resMlArr.length; ++i) {
                sqlFileSeq = 1;
                recordIndex = 0;
                quy_sql = projectId.equals("other") ? " select ml.fid fid, ml.fresid fresId,ml.flanguage flanguage, ml.fmlRes fmlRes, ml.fmlRes2 fmlRes2, ml.fcnmd5 fcnmd5, ml.FForbidSysUpd FForbidSysUpd from " + resMlArr[i] + " ml left join " + resArr[i] + " res on res.fid = ml.fresId where ml.flanguage = '" + this.language + "' and " + notInSQL : " select ml.fid fid, ml.fresid fresId,ml.flanguage flanguage, ml.fmlRes fmlRes, ml.fmlRes2 fmlRes2, ml.fcnmd5 fcnmd5, ml.FForbidSysUpd FForbidSysUpd from " + resMlArr[i] + " ml left join " + resArr[i] + " res on res.fid = ml.fresId where ml.flanguage = '" + this.language + "' and FProject = '" + projectId + "'";
                rs = conn.createStatement().executeQuery(quy_sql);
                if (!rs.next()) continue;
                d = new File(dir.getPath() + System.getProperty("file.separator") + dmInfo.getProject());
                if (!d.exists()) {
                    d.mkdir();
                }
                if (!(f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resMlArr[i] + "_" + sqlFileSeq + ".xml")).exists()) {
                    f.createNewFile();
                }
                fo = null;
                bo = null;
                bw = null;
                try {
                    fo = new FileOutputStream(f);
                    bo = new BufferedOutputStream(fo);
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                    lineSep = System.getProperty("line.separator");
                    do {
                        if (recordIndex % sqlFileMaxRecord == 0) {
                            if (sqlFileSeq != 1) {
                                bw.write("</item>");
                                bw.write(lineSep);
                                bw.write("</doc>");
                                bw.flush();
                            }
                            recordIndex = 0;
                            d = new File(dir.getPath() + System.getProperty("file.separator") + dmInfo.getProject());
                            if (!d.exists()) {
                                d.mkdir();
                            }
                            if (!(f = new File(d.getPath() + System.getProperty("file.separator") + dmInfo.getProject() + "_" + resMlArr[i] + "_" + sqlFileSeq + ".xml")).exists()) {
                                f.createNewFile();
                            }
                            fo = new FileOutputStream(f);
                            bo = new BufferedOutputStream(fo);
                            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                            element = root.addElement("xml");
                            element.addText("./" + dmInfo.getProject() + "/" + dmInfo.getProject() + "_" + resMlArr[i] + "_" + sqlFileSeq + ".xml");
                            ++sqlFileSeq;
                            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                            bw.write(lineSep);
                            bw.write("<doc>");
                            bw.write(lineSep);
                            ins_sql.append("<item>").append(lineSep);
                            ins_sql.append("<sql> insert into ").append(resMlArr[i]).append("(fid,fresid,flanguage,fmlRes,fcnmd5,FForbidSysUpd) values");
                            ins_sql.append("(?,?,?,?,?,?)</sql>").append(lineSep);
                        }
                        ++recordIndex;
                        ins_sql.append("<para>").append(lineSep);
                        ins_sql.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                        ins_sql.append("<fresid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fresid")).append("]]></fresid>").append(lineSep);
                        ins_sql.append("<flanguage dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("flanguage")).append("]]></flanguage>").append(lineSep);
                        ins_sql.append("<fmlRes dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fmlRes2") == null ? "" : rs.getString("fmlRes2")).append("]]></fmlRes>").append(lineSep);
                        ins_sql.append("<fcnmd5 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fcnmd5")).append("]]></fcnmd5>").append(lineSep);
                        ins_sql.append("<FForbidSysUpd dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FForbidSysUpd")).append("]]></FForbidSysUpd>").append(lineSep);
                        ins_sql.append("</para>").append(lineSep);
                        bw.write(ins_sql.toString());
                        ins_sql.delete(0, ins_sql.length());
                    } while (rs.next());
                    bw.write("</item>");
                    bw.write(lineSep);
                    bw.write("</doc>");
                    bw.flush();
                    continue;
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (bo != null) {
                        bo.close();
                    }
                    if (fo != null) {
                        fo.close();
                    }
                }
            }
            FileOutputStream fo2 = null;
            FilterOutputStream bo2 = null;
            BufferedWriter out = null;
            try {
                String sqlCreateFileName = d.getPath() + System.getProperty("file.separator") + "create.xml";
                File f2 = new File(sqlCreateFileName);
                if (!f2.exists()) {
                    f2.createNewFile();
                }
                fo2 = new FileOutputStream(f2);
                bo2 = new BufferedOutputStream(fo2);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)bo2, "UTF-8"));
                document.write((Writer)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (bo2 != null) {
                    bo2.close();
                }
                if (fo2 == null) continue;
                fo2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGenerateTransResourseInsSql(Element root) throws Exception {
        File file;
        Connection conn = Helper.getInitDBConn();
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        sqlFileSeq = 1;
        recordIndex = 0;
        ResultSet rs = conn.createStatement().executeQuery(Sql.EASResource_quy);
        if (!rs.next()) {
            return;
        }
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/ml");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_EASResource_" + sqlFileSeq + ".xml")).exists()) {
            file.createNewFile();
        }
        Element element = null;
        FileOutputStream fo = null;
        BufferedOutputStream bo = null;
        BufferedWriter bw = null;
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        String fMD5Code = null;
        try {
            fo = new FileOutputStream(file);
            bo = new BufferedOutputStream(fo);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
            while (rs.next()) {
                if (recordIndex % sqlFileMaxRecord == 0) {
                    if (sqlFileSeq != 1) {
                        bw.write("</item>");
                        bw.write(lineSep);
                        bw.write("</doc>");
                        bw.flush();
                    }
                    recordIndex = 0;
                    file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_EASResource_" + sqlFileSeq + ".xml");
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    fo = new FileOutputStream(file);
                    bo = new BufferedOutputStream(fo);
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                    element = root.addElement("xml");
                    element.addText("./ml/t_res_EASResource_" + sqlFileSeq + ".xml");
                    ++sqlFileSeq;
                    bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    bw.write(lineSep);
                    bw.write("<doc>");
                    bw.write(lineSep);
                    bw.write("<item>");
                    bw.write(lineSep);
                    sb.append("<sql> ").append(Sql.EASResource_ins).append("(?,?,?,?,?) </sql>").append(lineSep);
                    bw.write(sb.toString());
                    sb.delete(0, sb.length());
                }
                fMD5Code = rs.getString("FMD5Code");
                sb.append("<para>").append(lineSep);
                sb.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
                sb.append("<FRes dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FRes") == null ? "" : rs.getString("FRes")).append("]]></FRes>").append(lineSep);
                sb.append("<FISInvalid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISInvalid")).append("]]></FISInvalid>").append(lineSep);
                sb.append("<fMD5Code dataInFile=\"false\" type=\"9\"><![CDATA[").append(fMD5Code).append("]]></fMD5Code>").append(lineSep);
                if (StringUtils.isEmpty((String)rs.getString("FDomainId"))) {
                    sb.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[]]]></FDomainId>").append(lineSep);
                } else {
                    sb.append("<FDomainId dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FDomainId")).append("]]></FDomainId>").append(lineSep);
                }
                sb.append("</para>").append(lineSep);
                bw.write(sb.toString());
                bw.write(lineSep);
                sb.delete(0, sb.length());
                ++recordIndex;
            }
            bw.write("</item>");
            bw.write(lineSep);
            bw.write("</doc>");
            bw.flush();
            rs.close();
            bw.close();
            sqlFileSeq = 1;
            recordIndex = 0;
            rs = conn.createStatement().executeQuery(Sql.EasMultilan_quy + " where FLanguageId = '" + this.language + "'");
            if (!rs.next()) {
                return;
            }
            sb.delete(0, sb.length());
            while (rs.next()) {
                if (recordIndex % sqlFileMaxRecord == 0) {
                    if (sqlFileSeq != 1) {
                        bw.write("</item>");
                        bw.write(lineSep);
                        bw.write("</doc>");
                        bw.flush();
                    }
                    recordIndex = 0;
                    file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_EASMultiLanRes_" + sqlFileSeq + ".xml");
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    fo = new FileOutputStream(file);
                    bo = new BufferedOutputStream(fo);
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                    element = root.addElement("xml");
                    element.addText("./ml/t_res_EASMultiLanRes_" + sqlFileSeq + ".xml");
                    ++sqlFileSeq;
                    bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    bw.write(lineSep);
                    bw.write("<doc>");
                    bw.write(lineSep);
                    bw.write("<item>");
                    bw.write(lineSep);
                    sb.append("<sql> ").append(Sql.EasMultilan_ins).append("(?,?,?,?,?,?) </sql>").append(lineSep);
                    bw.write(sb.toString());
                    sb.delete(0, sb.length());
                }
                sb.append("<para>").append(lineSep);
                sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FID")).append("]]></FID>").append(lineSep);
                sb.append("<fparentID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fparentID")).append("]]></fparentID>").append(lineSep);
                sb.append("<FLanguageId dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FLanguageId")).append("]]></FLanguageId>").append(lineSep);
                sb.append("<Fcontent dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("Fcontent")).append("]]></Fcontent>").append(lineSep);
                sb.append("<FISTranslated dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISTranslated")).append("]]></FISTranslated>").append(lineSep);
                sb.append("<FCNMD5Code dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FCNMD5Code")).append("]]></FCNMD5Code>").append(lineSep);
                sb.append("</para>").append(lineSep);
                bw.write(sb.toString());
                bw.write(lineSep);
                sb.delete(0, sb.length());
                ++recordIndex;
            }
            bw.write("</item>");
            bw.write(lineSep);
            bw.write("</doc>");
            bw.flush();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (bw != null) {
                bw.close();
            }
            if (fo != null) {
                fo.close();
            }
            if (bo != null) {
                bo.close();
            }
            conn.close();
        }
    }

    private void testGenerateMultiFieldSql(Element root) throws Exception {
        File file;
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        Connection conn = Helper.getInitDBConn();
        ResultSet rs = conn.createStatement().executeQuery(Sql.MultiFieldMeta_quy);
        if (!rs.next()) {
            rs.close();
            return;
        }
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        BufferedWriter bw = null;
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/ml");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_MultiFieldMeta_" + sqlFileSeq + ".xml")).exists()) {
            file.createNewFile();
        }
        Element element = null;
        FileOutputStream fo = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(fo);
        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
        while (rs.next()) {
            if (recordIndex % sqlFileMaxRecord == 0) {
                if (sqlFileSeq != 1) {
                    bw.write("</item>");
                    bw.write(lineSep);
                    bw.write("</doc>");
                    bw.flush();
                }
                recordIndex = 0;
                file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_MultiFieldMeta_" + sqlFileSeq + ".xml");
                if (!file.exists()) {
                    file.createNewFile();
                }
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                element = root.addElement("xml");
                element.addText("./ml/t_res_MultiFieldMeta_" + sqlFileSeq + ".xml");
                ++sqlFileSeq;
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                sb.append("<item>").append(lineSep);
                sb.append("<sql> ").append(Sql.MultiFieldMeta_ins);
                sb.append("(?,?,?,?,?,?,?,?,?,?,?)</sql>").append(lineSep);
            }
            sb.append("<para>").append(lineSep);
            sb.append("<fid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("fid")).append("]]></fid>").append(lineSep);
            sb.append("<FTableName dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FTableName")).append("]]></FTableName>").append(lineSep);
            sb.append("<FProject dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FProject")).append("]]></FProject>").append(lineSep);
            sb.append("<FFieldName_l1 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFieldName_l1") == null ? "" : rs.getString("FFieldName_l1")).append("]]></FFieldName_l1>").append(lineSep);
            sb.append("<FFieldName_l2 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFieldName_l2") == null ? "" : rs.getString("FFieldName_l2")).append("]]></FFieldName_l2>").append(lineSep);
            sb.append("<FFieldName_l3 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FFieldName_l3") == null ? "" : rs.getString("FFieldName_l3")).append("]]></FFieldName_l3>").append(lineSep);
            sb.append("<FISBigField dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISBigField")).append("]]></FISBigField>").append(lineSep);
            sb.append("<FFieldLen dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FFieldLen")).append("]]></FFieldLen>").append(lineSep);
            sb.append("<FISInvalid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FISInvalid")).append("]]></FISInvalid>").append(lineSep);
            sb.append("<FType dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getInt("FType")).append("]]></FType>").append(lineSep);
            sb.append("<FPrimeryKey dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FPrimeryKey")).append("]]></FPrimeryKey>").append(lineSep);
            sb.append("</para>").append(lineSep);
            bw.write(sb.toString());
            bw.write(lineSep);
            sb.delete(0, sb.length());
            ++recordIndex;
        }
        bw.write("</item>");
        bw.write(lineSep);
        bw.write("</doc>");
        if (bw != null) {
            bw.flush();
        }
        rs.close();
    }

    private void testGeneratePresetDataResourseInsSql(Element root) throws Exception {
        File file;
        int sqlFileSeq = 1;
        int sqlFileMaxRecord = 1000;
        int recordIndex = 0;
        Connection conn = Helper.getInitDBConn();
        ResultSet rs = conn.createStatement().executeQuery(Sql.PresetDataRes_quy);
        if (!rs.next()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        BufferedWriter bw = null;
        File dir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "/easSql/ml");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_PresetDataRes_" + sqlFileSeq + ".xml")).exists()) {
            file.createNewFile();
        }
        Element element = null;
        FileOutputStream fo = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(fo);
        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "utf-8"));
        while (rs.next()) {
            if (recordIndex % sqlFileMaxRecord == 0) {
                if (sqlFileSeq != 1) {
                    bw.write("</item>");
                    bw.write(lineSep);
                    bw.write("</doc>");
                    bw.flush();
                }
                recordIndex = 0;
                file = new File(dir.getPath() + System.getProperty("file.separator") + "t_res_PresetDataRes_" + sqlFileSeq + ".xml");
                if (!file.exists()) {
                    file.createNewFile();
                }
                fo = new FileOutputStream(file);
                bo = new BufferedOutputStream(fo);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)bo, "UTF-8"));
                element = root.addElement("xml");
                element.addText("./ml/t_res_PresetDataRes_" + sqlFileSeq + ".xml");
                ++sqlFileSeq;
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.write(lineSep);
                bw.write("<doc>");
                bw.write(lineSep);
                sb.append("<item>").append(lineSep);
                sb.append("<sql> ").append(Sql.PresetDataRes_ins).append("(?,?,?,?,?,?,?,?) </sql>").append(lineSep);
                bw.write(sb.toString());
                sb.delete(0, sb.length());
            }
            sb.append("<para>").append(lineSep);
            sb.append("<FID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FID")).append("]]></FID>").append(lineSep);
            sb.append("<FParentID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FParentID")).append("]]></FParentID>").append(lineSep);
            sb.append("<FSourceID dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FSourceID")).append("]]></FSourceID>").append(lineSep);
            sb.append("<FText_zh_CN dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FText_zh_CN") == null ? "" : (rs.getString("FText_zh_CN").length() > 250 ? rs.getString("FText_zh_CN").substring(0, 250) : rs.getString("FText_zh_CN"))).append("]]></FText_zh_CN>").append(lineSep);
            sb.append("<FText_zh_TW dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FText_zh_TW") == null ? "" : (rs.getString("FText_zh_TW").length() > 250 ? rs.getString("FText_zh_TW").substring(0, 250) : rs.getString("FText_zh_TW"))).append("]]></FText_zh_TW>").append(lineSep);
            sb.append("<FText_en_US dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FText_en_US") == null ? "" : (rs.getString("FText_en_US").length() > 250 ? rs.getString("FText_en_US").substring(0, 250) : rs.getString("FText_en_US"))).append("]]></FText_en_US>").append(lineSep);
            sb.append("<FISInvalid dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FISInvalid")).append("]]></FISInvalid>").append(lineSep);
            sb.append("<FMD5 dataInFile=\"false\" type=\"9\"><![CDATA[").append(rs.getString("FMD5")).append("]]></FMD5>").append(lineSep);
            sb.append("</para>").append(lineSep);
            bw.write(sb.toString());
            sb.delete(0, sb.length());
            ++recordIndex;
        }
        bw.write("</item>");
        bw.write(lineSep);
        bw.write("</doc>");
        bw.flush();
        rs.close();
    }

    private static final class EASDomain {
        private String id;
        private String project;
        private String name1;
        private String name2;
        private String name3;

        private EASDomain() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getName1() {
            return this.name1;
        }

        public void setName1(String name1) {
            this.name1 = name1;
        }

        public String getName2() {
            return this.name2;
        }

        public void setName2(String name2) {
            this.name2 = name2;
        }

        public String getName3() {
            return this.name3;
        }

        public void setName3(String name3) {
            this.name3 = name3;
        }
    }

    private static class Sql {
        public static String EASResource_quy = " select fid,FRes,FType,FISInvalid,FMD5Code,FDomainId from t_res_easresource ";
        public static String EASResource_ins = " insert into t_res_easresource(fid,FRes,FISInvalid,FMD5Code,FDomainId) values ";
        public static String EasMultilan_quy = " Select FID,fparentID,FLanguageId,Fcontent,FISTranslated,FCNMD5Code from t_res_easMultiLanRes ";
        public static String EasMultilan_ins = " insert into t_res_easMultiLanRes(FID,fparentID,FLanguageId,Fcontent,FISTranslated,FCNMD5Code) values";
        public static String MultiFieldMeta_quy = "select fid,FTableName,FProject,FFieldName_l1,FFieldName_l2,FFieldName_l3,FISBigField,FFieldLen,FISInvalid,FType,FPrimeryKey from t_res_multiFieldMeta";
        public static String MultiFieldMeta_ins = "insert into t_res_multiFieldMeta(fid,FTableName,FProject,FFieldName_l1,FFieldName_l2,FFieldName_l3,FISBigField,FFieldLen,FISInvalid,FType,FPrimeryKey) values";
        public static String PresetDataRes_quy = "select FID,FParentID,FSourceID,FText_zh_CN,FText_zh_TW,FText_en_US,FISInvalid,FMD5 from t_res_presetDataRes ";
        public static String PresetDataRes_ins = "insert into t_res_presetDataRes(FID,FParentID,FSourceID,FText_zh_CN,FText_zh_TW,FText_en_US,FISInvalid,FMD5) values";

        private Sql() {
        }
    }
}

