/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.AssistantWorkCategoryCollection;
import com.kingdee.eas.mm.basedata.AssistantWorkCategoryFactory;
import com.kingdee.eas.mm.basedata.AssistantWorkCategoryInfo;
import com.kingdee.eas.mm.basedata.IAssistantWorkCategory;
import com.kingdee.eas.mm.basedata.LaborCostUnitEnum;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.client.AbstractAssistantWorkCategoryUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AssistantWorkCategoryUI
extends AbstractAssistantWorkCategoryUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistantWorkCategoryUI.class);
    private static final String TB_ID = "id";
    private static final String TB_NAME = "name";
    private static final String TB_NUMBER = "number";
    private static final String TB_LABORCOST = "laborCost";
    private static final String TB_LABORCOSTUNIT = "laborCostUnit";
    private static final String TB_CURRENCY = "currency";
    private static final String TB_REMARK = "remark";
    private static final String TB_STATUS = "status";
    private static final String TB_CREATOR = "creator";
    private static final String TB_CREATORID = "creatorId";
    private static final String TB_CREATETIME = "creatTime";
    private static final String TB_MENDER = "updator";
    private static final String TB_MENDERTIME = "updateTime";
    private List editRowList = new ArrayList();
    private boolean editable = true;
    private List newAddRowList = new ArrayList();
    private boolean isChanged = false;
    private UserInfo currentUser = null;
    private List mutexLineIds = new ArrayList();
    private List mutexEditLineIds = new ArrayList();
    private KDTEditAdapter tableChangeListener = null;
    private DataChangeListener storageDataChangeListener = null;
    private SelectorListener storageSelectListener = null;
    private String[] editColumns = new String[]{"name", "number", "laborCost", "remark"};
    private String[] copyColumns = new String[]{"name", "laborCost", "laborCostUnit", "currency", "remark"};
    private static final String[] KDT_DATES = new String[]{"creatTime", "updateTime"};
    private CurrencyInfo currencyInfo = null;
    private CurrencyInfo defaultCurrencyInfo = new CurrencyInfo();

    public AssistantWorkCategoryUI() throws Exception {
        this.kDTable.checkParsed();
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.initStorageUnitOrgF7();
        this.kDTable.checkParsed();
        this.kDTable.getStyleAttributes().setLocked(true);
        this.setTableFormattedTextField(TB_LABORCOST);
        KDTextField txtInput = new KDTextField();
        txtInput.setMaxLength(255);
        this.kDTable.getColumn(TB_REMARK).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInput));
        this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            String orgId = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
            this.currencyInfo = MMUtils.getBaseCurrencyByCompanyOrg((String)orgId);
        }
        this.dataBinding();
        this.addListener();
        EditTableUtil.formatColDate((KDTable)this.kDTable, (String[])KDT_DATES);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEdit.setEnabled(true);
        this.menuItemEdit.setEnabled(true);
        this.btnSave.setEnabled(false);
        this.menuItemSave.setEnabled(false);
        this.btnAddLine.setEnabled(false);
        this.menuItemAddLine.setEnabled(false);
        this.btnInsertLine.setEnabled(false);
        this.menuItemInsertLine.setEnabled(false);
        this.btnCopyLine.setEnabled(false);
        this.menuItemCopyLine.setEnabled(false);
        this.btnRemoveLine.setEnabled(false);
        this.menuItemRemoveLine.setEnabled(false);
        this.btnCancelCancel.setEnabled(true);
        this.menuItemCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.menuItemCancel.setEnabled(true);
    }

    private void setEditWorkButton() {
        this.btnEdit.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.btnSave.setEnabled(true);
        this.menuItemSave.setEnabled(true);
        this.btnAddLine.setEnabled(true);
        this.menuItemAddLine.setEnabled(true);
        this.btnInsertLine.setEnabled(true);
        this.menuItemInsertLine.setEnabled(true);
        this.btnCopyLine.setEnabled(true);
        this.menuItemCopyLine.setEnabled(true);
        this.btnRemoveLine.setEnabled(true);
        this.menuItemRemoveLine.setEnabled(true);
        this.menuItemCancelCancel.setEnabled(true);
        this.menuItemCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private void initStorageUnitOrgF7() {
        OrgUnitInfo orgInfo = MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_assiscategory_view");
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_assiscategory_view");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public OrgType getMainType() {
        return OrgType.Storage;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AssistantWorkCategoryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private void initNewAddLineData(IRow row) {
        for (int i = 0; i < this.editColumns.length; ++i) {
            row.getCell(this.editColumns[i]).getStyleAttributes().setLocked(false);
        }
        StorageOrgUnitInfo storageUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        try {
            AssistantWorkCategoryInfo ruleInfo = ((IAssistantWorkCategory)this.getBizInterface()).initLineNumberAndDate(storageUnitInfo);
            if (ruleInfo.getNumber() == null) {
                row.getCell(TB_NUMBER).getStyleAttributes().setLocked(false);
            } else {
                if (!ruleInfo.getNumber().equals("NewAddWhenSave")) {
                    row.getCell(TB_NUMBER).setValue((Object)ruleInfo.getNumber());
                }
                row.getCell(TB_NUMBER).getStyleAttributes().setLocked(true);
            }
            row.getCell(TB_STATUS).setValue((Object)MMBasedataStatusEnum.ADDNEW);
            row.getCell(TB_LABORCOSTUNIT).setValue((Object)LaborCostUnitEnum.RMB_HOUR);
            if (this.currencyInfo != null) {
                row.getCell(TB_CURRENCY).setValue((Object)this.currencyInfo);
            }
            row.getCell(TB_CREATOR).setValue((Object)this.currentUser.getName());
            row.getCell(TB_CREATORID).setValue((Object)this.currentUser.getId().toString());
            row.getCell(TB_CREATETIME).setValue((Object)ruleInfo.getCreateTime());
            row.getCell(TB_ID).setValue((Object)BOSUuid.create((String)"8F409A89"));
            this.newAddRowList.add(row);
            this.isChanged = true;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void dataBinding() throws BOSException, Exception {
        this.kDTable.repaint();
        this.kDTable.removeRows();
        AssistantWorkCategoryCollection categoryColls = this.queryAssistantWorkCategory();
        if (categoryColls == null || categoryColls.size() == 0) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                this.actionEdit.setEnabled(false);
            }
            return;
        }
        for (int i = 0; i < categoryColls.size(); ++i) {
            AssistantWorkCategoryInfo info = categoryColls.get(i);
            IRow row = this.kDTable.addRow();
            row.getCell(TB_ID).setValue((Object)info.getId());
            row.getCell(TB_NUMBER).setValue((Object)info.getNumber());
            row.getCell(TB_NAME).setValue((Object)info.getName());
            row.getCell(TB_LABORCOST).setValue((Object)info.getLaborCost());
            row.getCell(TB_STATUS).setValue((Object)info.getStatus());
            row.getCell(TB_LABORCOSTUNIT).setValue((Object)info.getLaborCostUnit());
            row.getCell(TB_CURRENCY).setValue((Object)info.getCurrency());
            row.getCell(TB_REMARK).setValue((Object)info.getRemark());
            row.getCell(TB_CREATOR).setValue((Object)info.getCreator().getName());
            row.getCell(TB_CREATORID).setValue((Object)info.getCreator().getId());
            row.getCell(TB_CREATETIME).setValue((Object)info.getCreateTime());
            row.getCell(TB_MENDER).setValue((Object)info.getLastUpdateUser().getName());
            row.getCell(TB_MENDERTIME).setValue((Object)info.getLastUpdateTime());
        }
    }

    private AssistantWorkCategoryCollection queryAssistantWorkCategory() throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (storageOrgUnit == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo(TB_STATUS));
        view.getSelector().add(new SelectorItemInfo("creator.name"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        view.getSelector().add(new SelectorItemInfo("lastUpdateUser.name"));
        SorterItemInfo aSorterItemInfo = new SorterItemInfo(TB_NUMBER);
        aSorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(aSorterItemInfo);
        return ((IAssistantWorkCategory)this.getBizInterface()).getAssistantWorkCategoryCollection(view);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        CoreBaseCollection saveCollection = new CoreBaseCollection();
        IRow row = null;
        for (int j = 0; j < this.newAddRowList.size(); ++j) {
            row = (IRow)this.newAddRowList.get(j);
            saveCollection.add((CoreBaseInfo)this.setInfoByRow(row));
        }
        for (int i = 0; i < this.editRowList.size(); ++i) {
            saveCollection.add((CoreBaseInfo)this.setInfoByRow((IRow)this.editRowList.get(i)));
        }
        ArrayList<List> saveList = new ArrayList<List>();
        saveList.add(this.newAddRowList);
        saveList.add(this.editRowList);
        if (saveCollection.size() > 0) {
            try {
                ((IAssistantWorkCategory)this.getBizInterface()).save(saveCollection);
                this.newAddRowList.clear();
                this.editRowList.clear();
                this.isChanged = false;
                this.dataBinding();
                this.setEditTableCell(this.editable);
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
                this.setNextMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
                this.setShowMessagePolicy(2);
                this.setIsShowTextOnly(false);
                this.showMessage();
            }
            catch (EASBizException exc) {
                this.handleException((Exception)((Object)exc));
            }
        }
    }

    private void setEditTableCell(boolean editable) {
        IRow row = null;
        MMBasedataStatusEnum status = MMBasedataStatusEnum.ADDNEW;
        for (int j = 0; j < this.kDTable.getRowCount(); ++j) {
            status = (MMBasedataStatusEnum)this.kDTable.getCell(j, TB_STATUS).getValue();
            row = this.kDTable.getRow(j);
            if (status.getValue() != 20) {
                for (int i = 0; i < this.editColumns.length; ++i) {
                    row.getCell(this.editColumns[i]).getStyleAttributes().setLocked(editable);
                }
                if (status.getValue() == 40) continue;
                row.getCell(TB_NUMBER).getStyleAttributes().setLocked(true);
                continue;
            }
            row.getStyleAttributes().setLocked(true);
        }
    }

    private void releaseMutex(String fid) {
        try {
            this.setOprtState("RELEASEALL");
            this.pubFireVOChangeListener(fid);
        }
        catch (Throwable e) {
            this.handUIException(e);
        }
    }

    private void releaseEditMutex(List mutexList) {
        Iterator it = mutexList.iterator();
        String fid = null;
        while (it.hasNext()) {
            fid = (String)it.next();
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(fid);
            }
            catch (Throwable e) {
                this.handUIException(e);
            }
        }
    }

    private AssistantWorkCategoryInfo setInfoByRow(IRow row) {
        UserInfo creator;
        AssistantWorkCategoryInfo ruleInfo = new AssistantWorkCategoryInfo();
        ruleInfo.setStorageOrgUnit((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        String ruleNumber = (String)row.getCell(TB_NUMBER).getValue();
        String ruleName = (String)row.getCell(TB_NAME).getValue();
        MMBasedataStatusEnum status = (MMBasedataStatusEnum)row.getCell(TB_STATUS).getValue();
        ruleInfo.setNumber(ruleNumber);
        ruleInfo.setName(ruleName);
        ruleInfo.setRemark((String)row.getCell(TB_REMARK).getValue());
        if (row.getCell(TB_LABORCOST).getValue() instanceof String) {
            ruleInfo.setLaborCost(new BigDecimal((String)row.getCell(TB_LABORCOST).getValue()));
        } else {
            ruleInfo.setLaborCost((BigDecimal)row.getCell(TB_LABORCOST).getValue());
        }
        ruleInfo.setLaborCostUnit((LaborCostUnitEnum)((Object)row.getCell(TB_LABORCOSTUNIT).getValue()));
        ruleInfo.setCurrency((CurrencyInfo)row.getCell(TB_CURRENCY).getValue());
        Date date = (Date)row.getCell(TB_CREATETIME).getValue();
        Date lastUpdateTime = new Date();
        if (status.equals((Object)MMBasedataStatusEnum.ADDNEW)) {
            creator = new UserInfo();
            creator.setId(BOSUuid.read((String)row.getCell(TB_CREATORID).getValue().toString()));
            creator.setName(row.getCell(TB_CREATOR).getValue().toString());
            ruleInfo.setCreator(creator);
            ruleInfo.setCreateTime(new Timestamp(date.getTime()));
            ruleInfo.setLastUpdateUser(this.currentUser);
            ruleInfo.setLastUpdateTime(new Timestamp(lastUpdateTime.getTime()));
            ruleInfo.setStatus(MMBasedataStatusEnum.ADDNEW);
        } else {
            creator = new UserInfo();
            creator.setId(BOSUuid.read((String)row.getCell(TB_CREATORID).getValue().toString()));
            creator.setName(row.getCell(TB_CREATOR).getValue().toString());
            ruleInfo.setCreator(creator);
            ruleInfo.setCreateTime(new Timestamp(date.getTime()));
            ruleInfo.setLastUpdateUser(this.currentUser);
            ruleInfo.setLastUpdateTime(new Timestamp(lastUpdateTime.getTime()));
            ruleInfo.setStatus((MMBasedataStatusEnum)row.getCell(TB_STATUS).getValue());
        }
        Object fid = row.getCell(TB_ID).getValue();
        if (fid != null) {
            ruleInfo.setId(BOSUuid.read((String)fid.toString()));
        }
        return ruleInfo;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String tempStatus = this.getOprtState();
        String id = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        String storageId = this.currentUser.getId().toString();
        try {
            this.setOprtState("EDIT");
            this.pubFireVOChangeListener(id);
            this.mutexLineIds.add(storageId + id);
            this.editable = false;
            this.setEditWorkButton();
            this.setEditTableCell(this.editable);
        }
        catch (Throwable e1) {
            this.setOprtState("VIEW");
            this.handUIException(e1);
            return;
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kDTable.addRow();
        this.initNewAddLineData(row);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        int top;
        super.actionInsertLine_actionPerformed(e);
        IRow row = null;
        row = this.kDTable.getSelectManager().size() > 0 ? ((top = this.kDTable.getSelectManager().get().getTop()) == -1 ? this.kDTable.addRow() : this.kDTable.addRow(top)) : this.kDTable.addRow();
        this.initNewAddLineData(row);
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        if (selectRows.length != 1) {
            MsgBox.showInfo((String)this.getResource("should_choose_one_row"));
            SysUtil.abort();
        }
        IRow selectRow = this.kDTable.getRow(selectRows[0]);
        IRow row = this.kDTable.addRow(selectRows[0] + 1);
        this.initCopyLineData(row, selectRow);
    }

    private void initCopyLineData(IRow row, IRow selectRow) {
        for (int i = 0; i < this.editColumns.length; ++i) {
            row.getCell(this.editColumns[i]).getStyleAttributes().setLocked(false);
        }
        StorageOrgUnitInfo storageUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        try {
            AssistantWorkCategoryInfo ruleInfo = ((IAssistantWorkCategory)this.getBizInterface()).initLineNumberAndDate(storageUnitInfo);
            if (ruleInfo.getNumber() == null) {
                row.getCell(TB_NUMBER).getStyleAttributes().setLocked(false);
            } else {
                if (!ruleInfo.getNumber().equals("NewAddWhenSave")) {
                    row.getCell(TB_NUMBER).setValue((Object)ruleInfo.getNumber());
                }
                row.getCell(TB_NUMBER).getStyleAttributes().setLocked(true);
            }
            row.getCell(TB_STATUS).setValue((Object)MMBasedataStatusEnum.ADDNEW);
            row.getCell(TB_CREATOR).setValue((Object)this.currentUser.getName());
            row.getCell(TB_CREATORID).setValue((Object)this.currentUser.getId().toString());
            row.getCell(TB_CREATETIME).setValue((Object)ruleInfo.getCreateTime());
            row.getCell(TB_ID).setValue((Object)BOSUuid.create((String)"8F409A89"));
            for (int i = 0; i < this.copyColumns.length; ++i) {
                if (selectRow.getCell(this.copyColumns[i]).getValue() == null) continue;
                row.getCell(this.copyColumns[i]).setValue(selectRow.getCell(this.copyColumns[i]).getValue());
            }
            this.newAddRowList.add(row);
            this.isChanged = true;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        IRow[] selectRowObject = new IRow[selectRows.length];
        ArrayList<String> removeRowID = new ArrayList<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            selectRowObject[i] = this.kDTable.getRow(selectRows[i]);
        }
        boolean isYes = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
        if (!isYes) {
            return;
        }
        StringBuffer exceptionMessage = new StringBuffer();
        for (int j = 0; j < selectRowObject.length; ++j) {
            MMBasedataStatusEnum status = (MMBasedataStatusEnum)selectRowObject[j].getCell(TB_STATUS).getValue();
            IRow currRow = null;
            String id = null;
            if (status.getValue() == 40) {
                for (int i = 0; i < this.newAddRowList.size(); ++i) {
                    currRow = (IRow)this.newAddRowList.get(i);
                    id = selectRowObject[j].getCell(TB_ID).getValue().toString();
                    if (!currRow.getCell(TB_ID).getValue().toString().equalsIgnoreCase(id)) continue;
                    this.newAddRowList.remove(currRow);
                    removeRowID.add(id);
                }
                continue;
            }
            String fid = selectRowObject[j].getCell(TB_ID).getValue().toString();
            for (int i = 0; i < this.editRowList.size(); ++i) {
                currRow = (IRow)this.editRowList.get(i);
                if (!currRow.getCell(TB_ID).getValue().toString().equalsIgnoreCase(fid)) continue;
                this.editRowList.remove(currRow);
            }
            ObjectUuidPK uuidPk = new ObjectUuidPK(fid);
            try {
                this.getBizInterface().delete((IObjectPK)uuidPk);
                removeRowID.add(fid);
                continue;
            }
            catch (Exception ex) {
                exceptionMessage.append(ex.getMessage().substring(6, ex.getMessage().length()) + "\n");
            }
        }
        if (removeRowID.size() > 0) {
            int rowCount = this.kDTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String id = this.kDTable.getRow(i).getCell(TB_ID).getValue().toString();
                if (!removeRowID.contains(id)) continue;
                this.kDTable.removeRow(i);
                --i;
                --rowCount;
            }
        }
        if (this.newAddRowList.size() == 0 && this.editRowList.size() == 0) {
            this.isChanged = false;
        }
        if (exceptionMessage.length() > 0) {
            MsgBox.showInfo((String)exceptionMessage.toString());
        }
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)cancelMsg))) {
            if (this.isChanged) {
                MsgBox.showInfo((String)this.getResource("Save_before_Cancel"));
                SysUtil.abort();
            }
            this.doCancelOrCancelCancel(false);
            this.dataBinding();
            this.setEditTableCell(this.editable);
        }
    }

    public void checkSelected() {
        if (this.kDTable.getRowCount() == 0 || this.kDTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void doCancelOrCancelCancel(boolean isCancel) throws Exception {
        IAssistantWorkCategory iAssistantWorkCategory = (IAssistantWorkCategory)this.getBizInterface();
        ArrayList ids = this.getSelectedIdValues();
        String message = null;
        StringBuffer errors = new StringBuffer();
        String forbidError = null;
        if (!isCancel) {
            errors = iAssistantWorkCategory.setCancelCancel(ids);
            message = this.getResource("assistantworkcategory_cancelCancel_succ");
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Start_Error");
        } else {
            errors = iAssistantWorkCategory.setCancel(ids);
            message = this.getResource("assistantworkcategory_cancel_succ");
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Forbid_Error");
        }
        if (errors.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)forbidError, (String)errors.toString(), (int)8188);
        } else {
            this.setMessageText(message);
            this.showMessage();
        }
    }

    protected ArrayList getSelectedIdValues() {
        int[] selectRows = KDTableUtils.getSelectedRows((KDTable)this.kDTable);
        ArrayList<String> selectIds = new ArrayList<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            selectIds.add(this.kDTable.getCell(selectRows[i], TB_ID).getValue().toString());
        }
        return selectIds;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)cancelMsg))) {
            if (this.isChanged) {
                MsgBox.showInfo((String)this.getResource("Save_bef_Cancel"));
                SysUtil.abort();
            }
            this.doCancelOrCancelCancel(true);
            this.dataBinding();
            this.setEditTableCell(this.editable);
        }
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.AssistantWorkCategoryResource", (String)sKey);
    }

    private void removeListener() {
        if (this.tableChangeListener != null) {
            this.kDTable.removeKDTEditListener((KDTEditListener)this.tableChangeListener);
        }
        if (this.storageSelectListener != null) {
            this.prmtStorageOrgUnit.removeSelectorListener(this.storageSelectListener);
        }
        if (this.storageDataChangeListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageDataChangeListener);
        }
    }

    private void tblMain_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        boolean isDiffrent = false;
        if (this.kDTable.getColumnKey(colIndex).equalsIgnoreCase(TB_LABORCOST)) {
            if (oldValue == null && newValue != null || oldValue != null && newValue == null) {
                isDiffrent = true;
            } else if (oldValue == null && newValue == null) {
                isDiffrent = false;
            } else if (((BigDecimal)oldValue).compareTo((BigDecimal)newValue) != 0) {
                isDiffrent = true;
            }
        } else {
            isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        }
        String fid = null;
        if (isDiffrent) {
            IRow row = this.kDTable.getRow(rowIndex);
            MMBasedataStatusEnum status = (MMBasedataStatusEnum)row.getCell(TB_STATUS).getValue();
            if (status.getValue() != 40) {
                this.editRowList.add(row);
                fid = row.getCell(TB_ID).getValue().toString();
                try {
                    this.setOprtState("EDIT");
                    this.pubFireVOChangeListener(fid);
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    row.getCell(colIndex).setValue(oldValue);
                    return;
                }
                this.mutexEditLineIds.add(fid);
            }
            this.isChanged = true;
        }
    }

    private void addListener() {
        this.tableChangeListener = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    AssistantWorkCategoryUI.this.tblMain_Changed(e);
                }
                catch (Exception exc) {
                    AssistantWorkCategoryUI.this.handUIException(exc);
                }
            }
        };
        this.kDTable.addKDTEditListener((KDTEditListener)this.tableChangeListener);
        this.storageSelectListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    AssistantWorkCategoryUI.this.beforeStorageChange();
                }
                catch (Exception e1) {
                    e.setCanceled(true);
                    AssistantWorkCategoryUI.this.handUIException(e1);
                }
            }
        };
        this.prmtStorageOrgUnit.addSelectorListener(this.storageSelectListener);
        this.storageDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    AssistantWorkCategoryUI.this.handleStorageChanged(e);
                }
                catch (Exception exc) {
                    AssistantWorkCategoryUI.this.handUIException(exc);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageDataChangeListener);
    }

    private void handleStorageChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (newValue == null) {
            MsgBox.showError((String)this.getResource("assistantWorkCategoryStorageOrg_IsNotNull"));
            this.prmtStorageOrgUnit.setValue(oldValue);
            return;
        }
        if (newValue.equals(oldValue)) {
            return;
        }
        if (oldValue != null && this.oprtState != null && this.oprtState.equals("EDIT")) {
            String oldStorageId = ((StorageOrgUnitInfo)oldValue).getId().toString();
            String currentUserId = this.currentUser.getId().toString();
            if (this.mutexLineIds.contains(currentUserId + oldStorageId)) {
                this.releaseMutex(oldStorageId);
                this.releaseEditMutex(this.mutexEditLineIds);
            }
        }
        this.initWorkButton();
        this.isChanged = false;
        this.newAddRowList.clear();
        this.editRowList.clear();
        this.kDTable.getStyleAttributes().setLocked(true);
        String orgId = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        this.currencyInfo = MMUtils.getBaseCurrencyByCompanyOrg((String)orgId);
        this.dataBinding();
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isChanged) {
            b = true;
            b = this.checkSaveChange();
        }
        return b;
    }

    private boolean checkSaveChange() {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)"Confirm_Save_Exit"));
        if (result == 0) {
            try {
                this.actionSave_actionPerformed(null);
                return true;
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        return result != 2;
    }

    private CurrencyInfo getDefaultCurrencyInfo(String storageOrgUnitID) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getDelegateCompanyOrgUnitInfo(4, storageOrgUnitID);
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getBaseCurrency() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId());
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk);
        }
        return currencyInfo;
    }

    private CompanyOrgUnitInfo getDelegateCompanyOrgUnitInfo(int fromType, String orgUnitID) throws BOSException, EASBizException {
        OrgUnitCollection orgUnitCollection;
        IOrgUnitRelation orgUnitRelation;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (orgUnitID != null && (companyOrgUnitInfo = (CompanyOrgUnitInfo)(orgUnitRelation = OrgUnitRelationFactory.getRemoteInstance()).getDefaultToUnit(orgUnitID, fromType, 4)) == null && (orgUnitCollection = orgUnitRelation.getToUnit(orgUnitID, fromType, 4)) != null && orgUnitCollection.size() > 0) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        return companyOrgUnitInfo;
    }

    private void beforeStorageChange() throws Exception {
        int result;
        if (this.isChanged && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)ResourceManage.getResource((String)"cs_dataCHG"))) == 0) {
            this.actionSave_actionPerformed(null);
        }
    }

    private void setTableFormattedTextField(String columnName) {
        MMUtils.changeTableColPrecisionByCol((int)8, (KDTable)this.kDTable, (String[])new String[]{columnName}, (boolean)false);
    }

    public boolean destroyWindow() {
        if (this.oprtState != null && this.oprtState.equals("EDIT")) {
            String mutexId = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
            String currentUserId = this.currentUser.getId().toString();
            if (this.mutexLineIds.contains(currentUserId + mutexId)) {
                this.releaseMutex(mutexId);
                this.releaseEditMutex(this.mutexEditLineIds);
            }
        }
        boolean status = super.destroyWindow();
        return status;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        OrgType orgType;
        ObjectUuidPK orgPK = null;
        OrgUnitInfo orgUnit = null;
        orgUnit = (OrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (orgUnit != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(orgUnit.getId());
            return orgPk;
        }
        if (this.getMainBizOrgType() != null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        if (this.orgContextManager != null && (orgType = this.orgContextManager.getMainOrgType()) != null && this.getUIContext().get(orgType) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(orgType)).getId());
        }
        return orgPK;
    }
}

