/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.mm.basedata.BOMAssignLogFactory;
import com.kingdee.eas.mm.basedata.IBOMAssignLog;
import com.kingdee.eas.mm.basedata.client.AbstractBOMAssignLogUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;

public class BOMAssignLogUI
extends AbstractBOMAssignLogUI {
    private static final long serialVersionUID = 5465944743376895132L;
    private static String BOM_Assign_Resource = "com.kingdee.eas.mm.basedata.BOMAssignResource";
    private boolean selectedAll = false;
    private Set bomIDSet = null;
    private int sort = 1;
    private boolean isFristSortTable = true;
    private ISortManager sm = null;
    private SorterItemInfo pre_order = null;
    private SorterItemInfo current_order = null;
    private int order_count = 0;
    private static final String[] KDT_DATES = new String[]{"assignedDate"};

    public BOMAssignLogUI() throws Exception {
        this.kdtEntry.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BOMAssignLogUI.this.onAfterDataFillForKdTable(e.getFirstRow(), e.getLastRow());
            }
        });
        this.kdtEntry.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                Boolean b = (Boolean)e.getValue();
                BOMAssignLogUI.this.kdtEntry.getRow(e.getRowIndex()).getCell("selected").setValue((Object)b);
            }
        });
    }

    protected void onAfterDataFillForKdTable(int firstRow, int lastRow) {
        boolean flag = false;
        if (this.selectedAll) {
            flag = true;
        }
        if (this.kdtEntry.getRowCount() == 0) {
            return;
        }
        for (int i = firstRow; i <= lastRow; ++i) {
            this.kdtEntry.getCell(i, "selected").setValue((Object)flag);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bomIDSet = (Set)this.getUIContext().get("bomIDs");
        this.kdtEntry.checkParsed(false);
        this.kdtEntry.getColumn("selected").getStyleAttributes().setLocked(false);
        this.kdtEntry.getActionMap().remove("Delete");
        if (null != this.getUIContext().get("orderBomTitle")) {
            this.setUITitle((String)this.getUIContext().get("orderBomTitle"));
            this.kdtEntry.getHeadRow(0).getCell("assignedDate").setValue((Object)ResourceUtils.getMessage((String)BOM_Assign_Resource, (String)"ORDERBOM_ASSIGNLOG_ASSIGNDATE"));
            this.kdtEntry.getHeadRow(0).getCell("assigner").setValue((Object)ResourceUtils.getMessage((String)BOM_Assign_Resource, (String)"ORDERBOM_ASSIGNLOG_ASSIGNER"));
        }
        EditTableUtil.formatColDate((KDTable)this.kdtEntry, (String[])KDT_DATES);
    }

    @Override
    protected void kdtEntry_doRequestRowSet(RequestRowSetEvent e) {
        if (this.isFristSortTable) {
            this.bomAssignLogQuery = this.getEntityViewInfoForKdTable();
        }
        super.kdtEntry_doRequestRowSet(e);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isIgnoreOrder = true;
        exec.setObjectView(viewInfo);
        return exec;
    }

    private EntityViewInfo getEntityViewInfoForKdTable() {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bom.id", (Object)this.bomIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SorterItemInfo sortName = new SorterItemInfo("assignedDate");
        sortName.setSortType(SortType.DESCEND);
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(sortName);
        evi.setSorter(sic);
        return evi;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.selectedAll = false;
        this.kdtEntry.removeRows();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int count = this.kdtEntry.getRowCount3();
        for (int i = 0; i < count; ++i) {
            this.kdtEntry.getCell(i, "selected").setValue((Object)true);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.selectedAll = false;
        int count = this.kdtEntry.getRowCount3();
        for (int i = 0; i < count; ++i) {
            this.kdtEntry.getCell(i, "selected").setValue((Object)false);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo fi;
        super.actionRemove_actionPerformed(e);
        EntityViewInfo view = new EntityViewInfo();
        view = this.getEntityViewInfoForKdTable();
        Set idSet = null;
        if (this.selectedAll) {
            idSet = this.getIds(false);
            if (!idSet.isEmpty()) {
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.NOTINCLUDE));
                view.getFilter().mergeFilter(fi, "and");
            }
        } else {
            idSet = this.getIds(true);
            if (idSet.isEmpty()) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceUtils.getMessage((String)BOM_Assign_Resource, (String)"res_24"));
                return;
            }
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(fi);
        }
        IBOMAssignLog ib = BOMAssignLogFactory.getRemoteInstance();
        ib.delete(view.getFilter());
        this.kdtEntry.removeRows();
    }

    private Set getIds(boolean flag) {
        HashSet<String> set = new HashSet<String>();
        int count = this.kdtEntry.getRowCount3();
        for (int i = 0; i < count; ++i) {
            if (!this.kdtEntry.getCell(i, "selected").getValue().equals(flag)) continue;
            set.add((String)this.kdtEntry.getCell(i, "id").getValue());
        }
        return set;
    }

    @Override
    protected void kdtEntry_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.OrderByForTable(e);
            return;
        }
    }

    private void OrderByForTable(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            String columnName;
            if (this.isFristSortTable) {
                this.sm = new KDTSortManager(this.kdtEntry);
                if (this.bomAssignLogQuery == null) {
                    return;
                }
                if (this.bomAssignLogQuery.getSorter() != null) {
                    this.isFristSortTable = false;
                }
            }
            if ((columnName = this.kdtEntry.getColumn(e.getColIndex()).getFieldName()) == null) {
                return;
            }
            this.sort = this.sort == 0 ? 1 : 0;
            this.sm.sort(e.getColIndex(), this.sort);
            if (this.sort == 0) {
                SorterItemInfo sortName = new SorterItemInfo(this.kdtEntry.getColumn(e.getColIndex()).getFieldName());
                sortName.setSortType(SortType.ASCEND);
                sortName.setNLSSortType(null);
                if (this.pre_order == null) {
                    this.pre_order = (SorterItemInfo)sortName.clone();
                    this.current_order = (SorterItemInfo)sortName.clone();
                } else if (this.current_order != null && !this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    ++this.order_count;
                    if (this.order_count > 0) {
                        this.pre_order = (SorterItemInfo)this.current_order.clone();
                        this.order_count = 0;
                        this.current_order = (SorterItemInfo)sortName.clone();
                    }
                } else if (this.current_order != null && this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    this.current_order = (SorterItemInfo)sortName.clone();
                }
                this.setSortForQuery(sortName, this.pre_order);
            } else {
                SorterItemInfo sortName = new SorterItemInfo(this.kdtEntry.getColumn(e.getColIndex()).getFieldName());
                sortName.setSortType(SortType.DESCEND);
                sortName.setNLSSortType(null);
                if (this.pre_order == null) {
                    this.pre_order = (SorterItemInfo)sortName.clone();
                    this.current_order = (SorterItemInfo)sortName.clone();
                } else if (this.current_order != null && !this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    ++this.order_count;
                    if (this.order_count > 0) {
                        this.pre_order = (SorterItemInfo)this.current_order.clone();
                        this.order_count = 0;
                        this.current_order = (SorterItemInfo)sortName.clone();
                    }
                } else if (this.current_order != null && this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    this.current_order = (SorterItemInfo)sortName.clone();
                }
                this.setSortForQuery(this.current_order, this.pre_order);
            }
        }
    }

    protected void setSortForQuery(SorterItemInfo sortItem, SorterItemInfo oldSortItem) throws Exception {
        if (this.bomAssignLogQuery.getSorter() != null) {
            this.bomAssignLogQuery.getSorter().clear();
        }
        if (sortItem.getPropertyName() != "id") {
            this.bomAssignLogQuery.getSorter().add(sortItem);
        }
        if (oldSortItem != null && !oldSortItem.getPropertyName().equals(sortItem.getPropertyName())) {
            this.bomAssignLogQuery.getSorter().add(oldSortItem);
        }
        this.refreshListForOrder();
    }

    public void refreshListForOrder() throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.bomAssignLogQueryPK);
        this.kdtEntry.removeRows();
    }
}

