/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BOMFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.IBOMFacade;
import com.kingdee.eas.mm.basedata.client.AbstractBOMCycleVerifyUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;

public class BOMCycleVerifyUI
extends AbstractBOMCycleVerifyUI {
    private static final long serialVersionUID = -3376726940963233087L;
    private static final String TB_STORAGEORGUNIT = "storageOrgUnit";
    private static final String TB_BOMID = "BOMId";
    private static final String TB_PARENTMATERIALNUMBER = "parentMaterialNumber";
    private static final String TB_BOMPATH = "BOMPath";
    private static final String TB_BOMTYPE = "BOMType";
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";

    public BOMCycleVerifyUI() throws Exception {
        this.btnExport.setText(this.resHelper.getString("btnExport.toolTipText"));
        this.btnPrint.setText(this.resHelper.getString("btnPrint.toolTipText"));
        this.btnPreview.setText(this.resHelper.getString("btnPreview.toolTipText"));
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPreview);
        this.setButtonDefaultStyl(this.btnExport);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTable getTableForCommon() {
        return this.kdtEntrys;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.showSuccessMsg(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"bomCheckStart"));
        this.kdtEntrys.removeRows();
        super.actionConfirm_actionPerformed(e);
        ArrayList retErrorPathList = new ArrayList();
        StorageOrgUnitInfo storageOrgUnit = null;
        IBOMFacade iBomFacade = BOMFacadeFactory.getRemoteInstance();
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            int i;
            ArrayList rst = null;
            StorageOrgUnitInfo[] storages = null;
            Object storageObj = this.prmtStorageOrgUnit.getValue();
            if (storageObj instanceof StorageOrgUnitInfo) {
                storages = new StorageOrgUnitInfo[]{(StorageOrgUnitInfo)storageObj};
            } else if (storageObj instanceof StorageOrgUnitInfo[]) {
                storages = (StorageOrgUnitInfo[])storageObj;
            } else if (storageObj instanceof Object[]) {
                Object[] objs = (Object[])storageObj;
                storages = new StorageOrgUnitInfo[objs.length];
                for (i = 0; i < objs.length; ++i) {
                    storages[i] = (StorageOrgUnitInfo)objs[i];
                }
            }
            if (storages == null || storages.length == 0) {
                return;
            }
            for (int i2 = 0; i2 < storages.length; ++i2) {
                storageOrgUnit = storages[i2];
                if (storageOrgUnit == null || (rst = iBomFacade.bomCycleVerifyWithReplaceMaterial(storageOrgUnit)) == null || rst.size() <= 0) continue;
                retErrorPathList.addAll(rst);
            }
            int maxlevel = 0;
            for (i = 0; i < retErrorPathList.size(); ++i) {
                HashMap cycleVerifyMap = (HashMap)retErrorPathList.get(i);
                int tmp = (Integer)cycleVerifyMap.get("MAXLEVEL");
                if (maxlevel < tmp) {
                    maxlevel = tmp;
                }
                IRow row = this.kdtEntrys.addRow();
                row.getCell(TB_STORAGEORGUNIT).setValue((Object)((String)cycleVerifyMap.get("FSTORAGEORGUNITID")));
                if (cycleVerifyMap.get("FBOMID") != null) {
                    row.getCell(TB_BOMID).setValue((Object)((String)cycleVerifyMap.get("FBOMID")));
                } else {
                    row.getCell(TB_BOMID).setValue((Object)"");
                }
                if (cycleVerifyMap.get("FBOMTYPE") != null && !cycleVerifyMap.get("FBOMTYPE").toString().trim().equals("")) {
                    row.getCell(TB_BOMTYPE).setValue((Object)((BOMTypeEnum)((Object)cycleVerifyMap.get("FBOMTYPE"))));
                }
                row.getCell(TB_PARENTMATERIALNUMBER).setValue((Object)((String)cycleVerifyMap.get("FParentMaterialID")));
                row.getCell(TB_BOMPATH).setValue((Object)((String)cycleVerifyMap.get("FBOMPATH")));
            }
            this.showSuccessMsg(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"bomCycleEnd"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)BOM_RESOURCE_PATH, (String)"checkStorageOrgUnit"));
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_cycleverify");
        StorageOrgUnitInfo foi = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_bom_cycleverify");
        this.prmtStorageOrgUnit.setValue((Object)foi);
        this.prmtStorageOrgUnit.setEnabledMultiSelection(false);
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtStorageOrgUnit.setEditFormat("$number$");
        this.prmtStorageOrgUnit.setCommitFormat("$number$");
        this.kdtEntrys.getStyleAttributes().setLocked(true);
        this.kdtEntrys.getSelectManager().setSelectMode(10);
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreview_actionPerformed(e);
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().print();
    }

    protected String getOnloadPermItemName() {
        return "mm_bom_cycleverify";
    }
}

