/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class BOMGROUPLNTreeAntiBuilder
implements ITreeBuilder {
    private ILNTreeNodeCtrl ctrl;
    private int initalLevel;
    private int expandLevel;
    private Map nodeMap;
    private FilterInfo filter;
    private SelectorItemCollection selector;

    public BOMGROUPLNTreeAntiBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
    }

    public BOMGROUPLNTreeAntiBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
    }

    public BOMGROUPLNTreeAntiBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector, Map node) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.selector = selector;
        this.nodeMap = node;
    }

    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    public KDTree buildTree(KDTree tree) throws Exception {
        if (tree == null) {
            tree = new KDTree(false);
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(false);
        }
        AbstractObjectCollection colGroup = rootNode.getUserObject() != null && rootNode.getUserObject() instanceof TreeBaseInfo ? this.ctrl.getChildren((TreeBaseInfo)rootNode.getUserObject(), this.initalLevel, this.filter, this.selector) : this.ctrl.getChildren(null, 5, this.filter, this.selector);
        tree.setShowsRootHandles(true);
        this.buildChildren(tree, rootNode, colGroup, this.initalLevel);
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        return tree;
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) {
        KDTreeNode beforeTreeNode = parentNode;
        TreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof TreeBaseInfo) {
            parentNodeInfo = (TreeBaseInfo)parentNode.getUserObject();
        }
        for (TreeBaseInfo treeNodeInfo : col) {
            if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
                parentNode.setUserObject((Object)treeNodeInfo);
                continue;
            }
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            String longNumber = treeNodeInfo.getLongNumber();
            if (this.nodeMap.containsKey(longNumber)) {
                ArrayList materials = (ArrayList)this.nodeMap.get(longNumber);
                for (int i = 0; i < materials.size(); ++i) {
                    MaterialInfo material = (MaterialInfo)materials.get(i);
                    KDTreeNode treeNodeChild = new KDTreeNode((Object)material);
                    int index = treeNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)treeNodeChild, (MutableTreeNode)treeNode, index);
                }
            }
            if (treeNodeInfo.isIsLeaf() || treeNodeInfo.getLevel() < parentNode.getLevel() + level) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
            }
            if (beforeTreeNode.getLevel() == 0) {
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((TreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            }
            beforeTreeNode = treeNode;
        }
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filter);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filter);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }
}

