/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.BOMSearchFlagEnum;
import com.kingdee.eas.mm.basedata.BomGroupstandardFactory;
import com.kingdee.eas.mm.basedata.BomGroupstandardInfo;
import com.kingdee.eas.mm.basedata.BomTreeInfo;
import com.kingdee.eas.mm.basedata.client.LNBom4QueryTreeNodeCtrl;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class BOMGROUPLNTreeBuilder
implements ITreeBuilder {
    private ILNTreeNodeCtrl[] ctrl;
    private int initalLevel;
    private int expandLevel;
    private FilterInfo filter;
    private SelectorItemCollection selector;

    public BOMGROUPLNTreeBuilder(ILNTreeNodeCtrl[] ctrl, int initalLevel, int expandLevel) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
    }

    public BOMGROUPLNTreeBuilder(ILNTreeNodeCtrl[] ctrl, int initalLevel, int expandLevel, FilterInfo filter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
    }

    public BOMGROUPLNTreeBuilder(ILNTreeNodeCtrl[] ctrl, int initalLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.selector = selector;
    }

    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    public KDTree buildTree(KDTree tree) throws Exception {
        if (tree == null) {
            tree = new KDTree(false);
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(false);
        }
        AbstractObjectCollection col = rootNode.getUserObject() != null && rootNode.getUserObject() instanceof TreeBaseInfo ? this.ctrl[0].getChildren((TreeBaseInfo)rootNode.getUserObject(), this.initalLevel, this.filter, this.selector) : this.ctrl[0].getChildren(null, this.initalLevel, this.filter, this.selector);
        tree.setShowsRootHandles(true);
        this.buildChildren(tree, rootNode, col, this.initalLevel);
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                block5: {
                    KDTree tree = (KDTree)event.getSource();
                    try {
                        KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                        if (BOMGROUPLNTreeBuilder.this.filter != null) {
                            BOMGROUPLNTreeBuilder.this.getChildren(tree, treeNode, BOMGROUPLNTreeBuilder.this.filter);
                            break block5;
                        }
                        if (treeNode.getUserObject() instanceof BomGroupstandardInfo) {
                            return;
                        }
                        BOMSearchFlagEnum searchType = ((LNBom4QueryTreeNodeCtrl)BOMGROUPLNTreeBuilder.this.ctrl[0]).getQueryType();
                        if (searchType == BOMSearchFlagEnum.ManySearch) {
                            BOMGROUPLNTreeBuilder.this.getChildren(tree, treeNode);
                            break block5;
                        }
                        return;
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Component)tree, (Throwable)exc);
                    }
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                block6: {
                    KDTree tree = (KDTree)e.getSource();
                    try {
                        KDTreeNode treeNode = (KDTreeNode)e.getPath().getLastPathComponent();
                        if (BOMGROUPLNTreeBuilder.this.filter != null) {
                            BOMGROUPLNTreeBuilder.this.getChildren(tree, treeNode, BOMGROUPLNTreeBuilder.this.filter);
                            break block6;
                        }
                        if (treeNode.getUserObject() instanceof BomGroupstandardInfo) {
                            return;
                        }
                        BOMSearchFlagEnum searchType = ((LNBom4QueryTreeNodeCtrl)BOMGROUPLNTreeBuilder.this.ctrl[0]).getQueryType();
                        if (searchType == BOMSearchFlagEnum.ManySearch) {
                            BOMGROUPLNTreeBuilder.this.getChildren(tree, treeNode);
                            break block6;
                        }
                        if (treeNode.isVirtual()) {
                            treeNode.setVirtual(false);
                            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
                        }
                        return;
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Component)tree, (Throwable)exc);
                    }
                }
            }
        });
        return tree;
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl[0].getChildren(treeNodeInfo, this.expandLevel);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) {
        KDTreeNode beforeTreeNode = parentNode;
        TreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof TreeBaseInfo) {
            parentNodeInfo = (TreeBaseInfo)parentNode.getUserObject();
        }
        Iterator iter = col.iterator();
        ArrayList treeGroupNotes = new ArrayList();
        while (iter.hasNext()) {
            TreeBaseInfo treeNodeInfo = (TreeBaseInfo)iter.next();
            if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
                parentNode.setUserObject((Object)treeNodeInfo);
                continue;
            }
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            KDTreeNode treeNodeGroup = null;
            if (treeNodeInfo.isIsLeaf() || treeNodeInfo.getLevel() < parentNode.getLevel() + level) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            }
            if (beforeTreeNode.getLevel() == 0) {
                String groupid = ((BomTreeInfo)treeNodeInfo).getBomGroupID();
                this.getBomGroupNote(tree, groupid, treeGroupNotes);
                for (int i = 0; i < treeGroupNotes.size(); ++i) {
                    BomGroupstandardInfo group = (BomGroupstandardInfo)treeGroupNotes.get(i);
                    treeNodeGroup = new KDTreeNode((Object)group);
                    treeNodeGroup.setVirtual(true);
                    beforeTreeNode.add((MutableTreeNode)treeNodeGroup);
                    beforeTreeNode = treeNodeGroup;
                }
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            } else {
                int beforeLevel;
                int curLevel = treeNodeInfo.getLevel();
                for (beforeLevel = ((TreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                if (beforeLevel == 0) {
                    String groupid = ((BomTreeInfo)treeNodeInfo).getBomGroupID();
                    this.updateBomGroupNode(tree, groupid, treeNode);
                } else {
                    int index = beforeTreeNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
                }
            }
            beforeTreeNode = treeNode;
        }
    }

    private boolean circleBomTree(KDTree tree, KDTreeNode note, BomGroupstandardInfo group, KDTreeNode treeNode) {
        for (int i = 0; i < note.getChildCount(); ++i) {
            KDTreeNode note1 = (KDTreeNode)note.getChildAt(i);
            if (!(note1.getUserObject() instanceof BomGroupstandardInfo)) continue;
            BomGroupstandardInfo groupStandard = (BomGroupstandardInfo)note1.getUserObject();
            if (groupStandard.getId().toString().equals(group.getId().toString())) {
                int index = note1.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)note1, index);
                return true;
            }
            boolean result = this.circleBomTree(tree, note1, group, treeNode);
            if (!result) continue;
            return result;
        }
        return false;
    }

    private void getBomGroupNote(KDTree tree, String groupid, List treeGroupNotes) {
        if (MMUtils.isEmptyString((String)groupid)) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(groupid);
        try {
            BomGroupstandardInfo group = BomGroupstandardFactory.getRemoteInstance().getBomGroupstandardInfo((IObjectPK)pk);
            treeGroupNotes.add(0, group);
            if (group.getParent() != null) {
                String parentId = group.getParent().getId().toString();
                this.getBomGroupNote(tree, parentId, treeGroupNotes);
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    private void updateBomGroupNode(KDTree tree, String groupid, KDTreeNode treeNode) {
        ObjectUuidPK pk = new ObjectUuidPK(groupid);
        try {
            BomGroupstandardInfo group = BomGroupstandardFactory.getRemoteInstance().getBomGroupstandardInfo((IObjectPK)pk);
            KDTreeNode note = (KDTreeNode)tree.getModel().getRoot();
            if (!this.circleBomTree(tree, note, group, treeNode)) {
                KDTreeNode treeNodeGroup = new KDTreeNode((Object)group);
                treeNodeGroup.add((MutableTreeNode)treeNode);
                if (group.getParent() != null) {
                    String parentId = group.getParent().getId().toString();
                    this.updateBomGroupNode(tree, parentId, treeNodeGroup);
                } else {
                    int index = note.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)treeNodeGroup, (MutableTreeNode)note, index);
                }
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filter);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl[0].getChildren(treeNodeInfo, this.expandLevel, filter);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }
}

