/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.BomTreeCollection;
import com.kingdee.eas.mm.basedata.BomTreeInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.basedata.client.IBOMTreeBuilder;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BOMLNTreeBuilder
implements IBOMTreeBuilder {
    private ILNTreeNodeCtrl ctrl = null;
    private int initalLevel = 2;
    private int expandLevel = 2;
    private boolean isOrderBomTree = false;
    private boolean isShowProjectName = false;
    private Map param;
    public FilterInfo filter;
    private SelectorItemCollection selector;

    public BOMLNTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector, boolean flag) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.selector = selector;
        this.isOrderBomTree = flag;
    }

    public BOMLNTreeBuilder(ILNTreeNodeCtrl ctrl, Map param) {
        this.ctrl = ctrl;
        this.param = param;
        Object obj = param.get("initalLevel");
        if (obj != null) {
            this.initalLevel = Integer.parseInt(obj.toString());
        }
        if ((obj = param.get("expandLevel")) != null) {
            this.expandLevel = Integer.parseInt(obj.toString());
        }
        this.filter = (FilterInfo)param.get("filter");
        this.selector = (SelectorItemCollection)param.get("selector");
        obj = param.get("isOrderBomTree");
        if (obj != null) {
            this.isOrderBomTree = Boolean.valueOf(obj.toString());
        }
        if ((obj = param.get("isShowProjectName")) != null) {
            this.isShowProjectName = Boolean.valueOf(obj.toString());
        }
    }

    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    public KDTree buildTree(KDTree tree) throws Exception {
        if (tree == null) {
            tree = new KDTree(true);
        } else {
            tree.setShowCheckBox(true);
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
            rootNode.removeAllChildren();
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(false);
        }
        AbstractObjectCollection col = rootNode.getUserObject() != null && rootNode.getUserObject() instanceof TreeBaseInfo ? this.ctrl.getChildren((TreeBaseInfo)rootNode.getUserObject(), this.initalLevel, this.filter, this.selector) : this.ctrl.getChildren(null, this.initalLevel, this.filter, this.selector);
        tree.setShowsRootHandles(true);
        HashMap<KDTreeNode, BomTreeCollection> map = new HashMap<KDTreeNode, BomTreeCollection>();
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        BomTreeInfo bomTreeInfo = null;
        BomTreeInfo nodeObject = null;
        KDTreeNode usageNode = null;
        KDTreeNode ptNode = null;
        KDTreeNode node2 = null;
        BomTreeCollection newCol = null;
        String longNumber = null;
        String nodeText = null;
        HashMap trackFilter = new HashMap();
        if (this.isOrderBomTree) {
            ProjectInfo projectInfo = null;
            TrackNumberCollection trackNumbers = null;
            String[] trackRang = null;
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                nodeText = null;
                bomTreeInfo = (BomTreeInfo)col.getObject(i);
                if (i == 0) {
                    trackRang = (String[])bomTreeInfo.get("TrackNumRang");
                }
                projectInfo = bomTreeInfo.getProject();
                trackNumbers = bomTreeInfo.getTrackNumbers();
                longNumber = "1@" + bomTreeInfo.getBomUsage().getName();
                if (!nodeMap.containsKey(longNumber)) {
                    usageNode = new KDTreeNode(null);
                    usageNode.setText(bomTreeInfo.getBomUsage().getAlias());
                    usageNode.setCheckBoxVisible(false);
                    nodeObject = new BomTreeInfo();
                    nodeObject.setLongNumber(longNumber);
                    nodeObject.setLevel(1);
                    nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                    usageNode.setUserObject((Object)nodeObject);
                    tree.addNodeInto((MutableTreeNode)usageNode, (MutableTreeNode)rootNode);
                    nodeMap.put(longNumber, usageNode);
                    if (projectInfo != null) {
                        longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                        nodeText = this.getProjectNodeText(projectInfo);
                    } else {
                        longNumber = longNumber + "!2@999999999";
                    }
                    nodeText = this.setLongNumberTrack(longNumber, trackFilter, nodeText);
                    if (trackRang != null && trackRang.length > 0) {
                        nodeText = nodeText != null && nodeText.length() > 0 ? nodeText + " & " + trackRang[0] + "~" + trackRang[trackRang.length - 1] : trackRang[0] + "~" + trackRang[trackRang.length - 1];
                    }
                    ptNode = new KDTreeNode(null);
                    ptNode.setCheckBoxVisible(false);
                    ptNode.setText(nodeText);
                    nodeObject = new BomTreeInfo();
                    nodeObject.setLongNumber(longNumber);
                    nodeObject.setLevel(2);
                    nodeObject.setProject(projectInfo);
                    nodeObject.setTrackNumbers(trackNumbers);
                    nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                    ptNode.setUserObject((Object)nodeObject);
                    tree.addNodeInto((MutableTreeNode)ptNode, (MutableTreeNode)usageNode);
                    nodeMap.put(longNumber, ptNode);
                    newCol = new BomTreeCollection();
                    newCol.add(bomTreeInfo);
                    map.put(ptNode, newCol);
                    continue;
                }
                usageNode = (KDTreeNode)nodeMap.get(longNumber);
                nodeObject = (BomTreeInfo)usageNode.getUserObject();
                longNumber = nodeObject.getLongNumber();
                if (projectInfo != null) {
                    longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                    nodeText = this.getProjectNodeText(projectInfo);
                } else {
                    longNumber = longNumber + "!2@999999999";
                }
                nodeText = this.setLongNumberTrack(longNumber, trackFilter, nodeText);
                if (!nodeMap.containsKey(longNumber)) {
                    ptNode = new KDTreeNode(null);
                    ptNode.setText(nodeText);
                    ptNode.setCheckBoxVisible(false);
                    nodeObject = new BomTreeInfo();
                    nodeObject.setLongNumber(longNumber);
                    nodeObject.setLevel(2);
                    nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                    nodeObject.setProject(projectInfo);
                    nodeObject.setTrackNumbers(trackNumbers);
                    nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                    ptNode.setUserObject((Object)nodeObject);
                    tree.addNodeInto((MutableTreeNode)ptNode, (MutableTreeNode)usageNode);
                    nodeMap.put(longNumber, ptNode);
                    newCol = new BomTreeCollection();
                    newCol.add(bomTreeInfo);
                    map.put(ptNode, newCol);
                    continue;
                }
                ptNode = (KDTreeNode)nodeMap.get(longNumber);
                ((BomTreeCollection)((Object)map.get(ptNode))).add(bomTreeInfo);
            }
            for (KDTreeNode node2 : map.keySet()) {
                newCol = (BomTreeCollection)((Object)map.get(node2));
                this.buildChildren(tree, node2, (AbstractObjectCollection)newCol, this.initalLevel);
            }
        } else {
            ProjectInfo projectInfo = null;
            KDTreeNode treeNode = null;
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                bomTreeInfo = (BomTreeInfo)col.getObject(i);
                longNumber = "1@" + bomTreeInfo.getBomUsage().getName();
                projectInfo = bomTreeInfo.getProject();
                if (!nodeMap.containsKey(longNumber)) {
                    usageNode = new KDTreeNode(null);
                    usageNode.setText(bomTreeInfo.getBomUsage().getAlias());
                    usageNode.setCheckBoxVisible(false);
                    nodeObject = new BomTreeInfo();
                    nodeObject.setLongNumber(longNumber);
                    nodeObject.setLevel(1);
                    nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                    usageNode.setUserObject((Object)nodeObject);
                    tree.addNodeInto((MutableTreeNode)usageNode, (MutableTreeNode)rootNode);
                    nodeMap.put(longNumber, usageNode);
                    if (projectInfo != null) {
                        longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                        nodeText = this.getProjectNodeText(projectInfo);
                        ptNode = new KDTreeNode(null);
                        ptNode.setText(nodeText);
                        ptNode.setCheckBoxVisible(false);
                        nodeObject = new BomTreeInfo();
                        nodeObject.setLongNumber(longNumber);
                        nodeObject.setLevel(2);
                        nodeObject.setProject(projectInfo);
                        nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                        ptNode.setUserObject((Object)nodeObject);
                        tree.addNodeInto((MutableTreeNode)ptNode, (MutableTreeNode)usageNode);
                        nodeMap.put(longNumber, ptNode);
                        nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, ptNode, bomTreeInfo));
                        continue;
                    }
                    bomTreeInfo.setLevel(2);
                    nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, usageNode, bomTreeInfo));
                    continue;
                }
                usageNode = (KDTreeNode)nodeMap.get(longNumber);
                nodeObject = (BomTreeInfo)usageNode.getUserObject();
                longNumber = nodeObject.getLongNumber();
                if (projectInfo != null) {
                    longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                    nodeText = this.getProjectNodeText(projectInfo);
                    if (!nodeMap.containsKey(longNumber)) {
                        ptNode = new KDTreeNode(null);
                        ptNode.setText(nodeText);
                        ptNode.setCheckBoxVisible(false);
                        nodeObject = new BomTreeInfo();
                        nodeObject.setLongNumber(longNumber);
                        nodeObject.setLevel(2);
                        nodeObject.setProject(projectInfo);
                        nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                        ptNode.setUserObject((Object)nodeObject);
                        tree.addNodeInto((MutableTreeNode)ptNode, (MutableTreeNode)usageNode);
                        nodeMap.put(longNumber, ptNode);
                        bomTreeInfo.setLevel(3);
                        nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, ptNode, bomTreeInfo));
                        continue;
                    }
                    treeNode = this.getParentNode(nodeMap, bomTreeInfo.getLongNumber());
                    if (treeNode == null) {
                        ptNode = (KDTreeNode)nodeMap.get(longNumber);
                        nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, ptNode, bomTreeInfo));
                        continue;
                    }
                    nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, treeNode, bomTreeInfo));
                    continue;
                }
                treeNode = this.getParentNode(nodeMap, bomTreeInfo.getLongNumber());
                if (treeNode == null) {
                    bomTreeInfo.setLevel(2);
                    nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, usageNode, bomTreeInfo));
                    continue;
                }
                nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, treeNode, bomTreeInfo));
            }
        }
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    if (BOMLNTreeBuilder.this.param == null) {
                        BOMLNTreeBuilder.this.param = new HashMap();
                    }
                    BOMLNTreeBuilder.this.param.clear();
                    BOMLNTreeBuilder.this.param.put("filter", BOMLNTreeBuilder.this.filter);
                    BOMLNTreeBuilder.this.param.put("level", new Integer(BOMLNTreeBuilder.this.expandLevel));
                    BOMLNTreeBuilder.this.param.put("parentNodeInfo", treeNode.getUserObject());
                    BOMLNTreeBuilder.this.getChildren(tree, treeNode, BOMLNTreeBuilder.this.filter);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    private String setLongNumberTrack(String longNumber, Map trackFilter, String nodeText) {
        String leafText = "";
        int filterSize = this.filter.getFilterItems().size();
        FilterItemCollection items = this.filter.getFilterItems();
        for (int j = 0; j < filterSize; ++j) {
            FilterItemInfo item = items.get(j);
            if (!item.getPropertyName().equalsIgnoreCase("trackNumber.number")) continue;
            if (item.getCompareExpression().equalsIgnoreCase(">=")) {
                trackFilter.put("TrackF", item.getCompareValue());
                continue;
            }
            trackFilter.put("TrackT", item.getCompareValue());
        }
        if (trackFilter.get("TrackF") != null) {
            nodeText = nodeText != null && nodeText.length() > 0 ? nodeText + " & " + trackFilter.get("TrackF") + "~" : trackFilter.get("TrackF") + "~";
        }
        if (trackFilter.get("TrackT") != null) {
            nodeText = nodeText != null && nodeText.length() > 0 ? (trackFilter.get("TrackF") != null ? nodeText + trackFilter.get("TrackT") : nodeText + " & ~" + trackFilter.get("TrackT")) : "~" + trackFilter.get("TrackT");
        }
        leafText = nodeText;
        return leafText;
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filterInfo) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filterInfo);
            if (this.isOrderBomTree && treeNode.getLevel() == 1) {
                ProjectInfo projectInfo = null;
                TrackNumberInfo trackNumberInfo = null;
                BomTreeInfo bomTreeInfo = null;
                HashMap<KDTreeNode, BomTreeCollection> map = new HashMap<KDTreeNode, BomTreeCollection>();
                HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
                BomTreeInfo nodeObject = null;
                KDTreeNode node2 = null;
                BomTreeCollection newCol = null;
                String longNumber = null;
                String nodeText = null;
                HashMap trackFilter = new HashMap();
                int n = col.size();
                for (int i = 0; i < n; ++i) {
                    longNumber = treeNodeInfo == null ? "" : treeNodeInfo.getLongNumber();
                    nodeText = null;
                    bomTreeInfo = (BomTreeInfo)col.getObject(i);
                    projectInfo = bomTreeInfo.getProject();
                    trackNumberInfo = bomTreeInfo.getTrackNumber();
                    if (projectInfo != null) {
                        longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                        nodeText = projectInfo.getNumber();
                    } else {
                        longNumber = longNumber + "!2@999999999";
                    }
                    this.setLongNumberTrack(longNumber, trackFilter, nodeText);
                    projectInfo = bomTreeInfo.getProject();
                    trackNumberInfo = bomTreeInfo.getTrackNumber();
                    if (!nodeMap.containsKey(longNumber)) {
                        node2 = new KDTreeNode(null);
                        node2.setText(nodeText);
                        node2.setCheckBoxVisible(false);
                        nodeObject = new BomTreeInfo();
                        nodeObject.setLongNumber(longNumber);
                        nodeObject.setLevel(2);
                        nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                        nodeObject.setProject(projectInfo);
                        nodeObject.setTrackNumber(trackNumberInfo);
                        node2.setUserObject((Object)nodeObject);
                        tree.addNodeInto((MutableTreeNode)node2, (MutableTreeNode)treeNode);
                        nodeMap.put(longNumber, node2);
                        newCol = new BomTreeCollection();
                        newCol.add(bomTreeInfo);
                        map.put(node2, newCol);
                        continue;
                    }
                    node2 = (KDTreeNode)nodeMap.get(longNumber);
                    ((BomTreeCollection)((Object)map.get(node2))).add(bomTreeInfo);
                }
                for (KDTreeNode node2 : map.keySet()) {
                    newCol = (BomTreeCollection)((Object)map.get(node2));
                    this.buildChildren(tree, node2, (AbstractObjectCollection)newCol, this.expandLevel);
                }
            } else if (treeNode.getLevel() == 1) {
                ProjectInfo projectInfo = null;
                BomTreeInfo bomTreeInfo = null;
                HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
                BomTreeInfo nodeObject = null;
                KDTreeNode ptNode = null;
                KDTreeNode node = null;
                String longNumber = null;
                String nodeText = null;
                int n = col.size();
                for (int i = 0; i < n; ++i) {
                    longNumber = treeNodeInfo == null ? "" : treeNodeInfo.getLongNumber();
                    nodeText = null;
                    bomTreeInfo = (BomTreeInfo)col.getObject(i);
                    projectInfo = bomTreeInfo.getProject();
                    if (projectInfo != null) {
                        longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                        nodeText = projectInfo.getNumber();
                        if (!nodeMap.containsKey(longNumber)) {
                            ptNode = new KDTreeNode(null);
                            ptNode.setText(nodeText);
                            ptNode.setCheckBoxVisible(false);
                            nodeObject = new BomTreeInfo();
                            nodeObject.setLongNumber(longNumber);
                            nodeObject.setLevel(2);
                            nodeObject.setProject(projectInfo);
                            nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                            ptNode.setUserObject((Object)nodeObject);
                            tree.addNodeInto((MutableTreeNode)ptNode, (MutableTreeNode)treeNode);
                            nodeMap.put(longNumber, ptNode);
                            bomTreeInfo.setLevel(3);
                            nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, ptNode, bomTreeInfo));
                            continue;
                        }
                        node = this.getParentNode(nodeMap, bomTreeInfo.getLongNumber());
                        if (node == null) {
                            ptNode = (KDTreeNode)nodeMap.get(longNumber);
                            nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, ptNode, bomTreeInfo));
                            continue;
                        }
                        nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, node, bomTreeInfo));
                        continue;
                    }
                    node = this.getParentNode(nodeMap, bomTreeInfo.getLongNumber());
                    if (node == null) {
                        bomTreeInfo.setLevel(2);
                        nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, treeNode, bomTreeInfo));
                        continue;
                    }
                    nodeMap.put(bomTreeInfo.getLongNumber(), this.buildChildren(tree, node, bomTreeInfo));
                }
            } else {
                this.buildChildren(tree, treeNode, col, this.expandLevel);
            }
        }
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) {
        KDTreeNode beforeTreeNode = parentNode;
        TreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof TreeBaseInfo) {
            parentNodeInfo = (TreeBaseInfo)parentNode.getUserObject();
        }
        for (BomTreeInfo treeNodeInfo : col) {
            if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
                parentNode.setUserObject((Object)treeNodeInfo);
                if (!parentNode.isCheckBoxVisible()) {
                    parentNode.setCheckBoxVisible(true);
                }
                if (!treeNodeInfo.isIsAssign() || treeNodeInfo.getBomID() == null) continue;
                parentNode.setTextBold(true);
                parentNode.setTextColor(Color.BLUE);
                continue;
            }
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            if (this.isOrderBomTree) {
                if (treeNodeInfo.isIsLeaf()) {
                    if (parentNodeInfo != null) {
                        treeNodeInfo.setProject(((BomTreeInfo)parentNodeInfo).getProject());
                        treeNodeInfo.setTrackNumbers(((BomTreeInfo)parentNodeInfo).getTrackNumbers());
                    }
                    treeNode.setVirtual(false);
                    if (treeNodeInfo.isIsLeaf()) {
                        treeNode.setCheckBoxVisible(false);
                    }
                } else {
                    treeNode.setVirtual(true);
                    treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
                }
            } else if (treeNodeInfo.isIsLeaf()) {
                treeNode.setVirtual(false);
                if (treeNodeInfo.isIsLeaf()) {
                    treeNode.setCheckBoxVisible(false);
                }
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            }
            if (treeNodeInfo.isIsAssign() && treeNodeInfo.getBomID() != null) {
                treeNode.setTextBold(true);
                treeNode.setTextColor(Color.BLUE);
            }
            if (beforeTreeNode.getLevel() == 0) {
                tree.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((TreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                tree.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode);
            }
            beforeTreeNode = treeNode;
        }
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filterInfo) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filterInfo);
    }

    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, null);
    }

    @Override
    public void addNewTreeNode(KDTree tree, KDTreeNode parentNode, KDTreeNode treeNode) throws Exception {
        if (tree == null) {
            tree = new KDTree(true);
        } else {
            tree.setShowCheckBox(true);
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(false);
        }
        if (parentNode == null) {
            parentNode = rootNode;
        }
        this.insertTreeNode(tree, parentNode, treeNode);
    }

    private void insertTreeNode(KDTree tree, KDTreeNode parentNode, KDTreeNode treeNode) throws Exception {
        String longNumber = "";
        String nodeText = "";
        BomTreeInfo nodeObject = null;
        KDTreeNode ptNode = null;
        KDTreeNode usageNode = null;
        BomTreeInfo bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
        if (this.isOrderBomTree) {
            longNumber = longNumber + "1@" + bomTreeInfo.getBomUsage().getName();
            Object o = null;
            if (parentNode.isRoot()) {
                boolean isFound = false;
                Enumeration e = parentNode.children();
                while (e.hasMoreElements()) {
                    o = e.nextElement();
                    if (o == null || !(o instanceof KDTreeNode) || (usageNode = (KDTreeNode)o).getUserObject() == null || !(usageNode.getUserObject() instanceof BomTreeInfo) || !longNumber.equals((nodeObject = (BomTreeInfo)usageNode.getUserObject()).getLongNumber())) continue;
                    isFound = true;
                    break;
                }
                if (!isFound) {
                    usageNode = new KDTreeNode(null);
                    usageNode.setCheckBoxVisible(false);
                    usageNode.setText(bomTreeInfo.getBomUsage().getAlias());
                    nodeObject = new BomTreeInfo();
                    nodeObject.setLongNumber(longNumber);
                    nodeObject.setLevel(1);
                    usageNode.setUserObject((Object)nodeObject);
                    tree.addNodeInto((MutableTreeNode)usageNode, (MutableTreeNode)parentNode);
                }
            } else {
                if (parentNode.getLevel() == 1) {
                    usageNode = parentNode;
                    longNumber = ((BomTreeInfo)usageNode.getUserObject()).getLongNumber();
                }
                if (parentNode.getLevel() == 2) {
                    usageNode = (KDTreeNode)parentNode.getParent();
                    ptNode = parentNode;
                    longNumber = ((BomTreeInfo)ptNode.getUserObject()).getLongNumber();
                }
            }
            if (ptNode == null) {
                String tracksRang;
                ProjectInfo projectInfo = bomTreeInfo.getProject();
                TrackNumberCollection trackNumbers = bomTreeInfo.getTrackNumbers();
                int trackSize = 0;
                if (trackNumbers != null) {
                    trackSize = trackNumbers.size();
                }
                if (projectInfo != null) {
                    longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                    nodeText = projectInfo.getNumber();
                    if (trackSize > 0) {
                        nodeText = nodeText + "&";
                    }
                } else {
                    longNumber = longNumber + "!2@999999999";
                }
                if ((tracksRang = BOMUIHelper.trackNumbersToStrRang(trackNumbers)) != null) {
                    nodeText = nodeText + tracksRang;
                }
                boolean isFound = false;
                if (usageNode != null && usageNode.children() != null) {
                    Enumeration en = usageNode.children();
                    while (en.hasMoreElements()) {
                        o = en.nextElement();
                        if (o == null || !(o instanceof KDTreeNode) || (ptNode = (KDTreeNode)o).getUserObject() == null || !(ptNode.getUserObject() instanceof BomTreeInfo) || !longNumber.equals((nodeObject = (BomTreeInfo)ptNode.getUserObject()).getLongNumber())) continue;
                        isFound = true;
                        break;
                    }
                }
                if (!isFound) {
                    ptNode = new KDTreeNode(null);
                    ptNode.setText(nodeText);
                    ptNode.setCheckBoxVisible(false);
                    nodeObject = new BomTreeInfo();
                    nodeObject.setLongNumber(longNumber);
                    nodeObject.setLevel(2);
                    nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                    nodeObject.setProject(projectInfo);
                    nodeObject.setTrackNumbers(trackNumbers);
                    ptNode.setUserObject((Object)nodeObject);
                    tree.addNodeInto((MutableTreeNode)ptNode, (MutableTreeNode)usageNode);
                }
            }
            longNumber = longNumber + "!3@" + bomTreeInfo.getMaterialInfo().getId().toString() + "@" + bomTreeInfo.getBomID();
            bomTreeInfo.setLongNumber(longNumber);
            tree.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)ptNode);
            this.refreshTreeNode(tree, treeNode);
            if (usageNode != null) {
                tree.expandPath(new TreePath(usageNode.getPath()));
            }
            if (ptNode != null) {
                tree.expandPath(new TreePath(ptNode.getPath()));
            }
        } else {
            longNumber = "1@" + bomTreeInfo.getBomUsage().getName();
            Object o = null;
            if (parentNode.isRoot()) {
                boolean isFound = false;
                Enumeration e = parentNode.children();
                while (e.hasMoreElements()) {
                    o = e.nextElement();
                    if (o == null || !(o instanceof KDTreeNode) || (usageNode = (KDTreeNode)o).getUserObject() == null || !(usageNode.getUserObject() instanceof BomTreeInfo) || !longNumber.equals((nodeObject = (BomTreeInfo)usageNode.getUserObject()).getLongNumber())) continue;
                    isFound = true;
                    break;
                }
                if (!isFound) {
                    usageNode = new KDTreeNode(null);
                    usageNode.setText(bomTreeInfo.getBomUsage().getAlias());
                    usageNode.setCheckBoxVisible(false);
                    nodeObject = new BomTreeInfo();
                    nodeObject.setLongNumber(longNumber);
                    nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                    nodeObject.setLevel(1);
                    usageNode.setUserObject((Object)nodeObject);
                    tree.addNodeInto((MutableTreeNode)usageNode, (MutableTreeNode)parentNode);
                }
            } else {
                if (parentNode.getLevel() == 1) {
                    usageNode = parentNode;
                    longNumber = ((BomTreeInfo)usageNode.getUserObject()).getLongNumber();
                }
                if (parentNode.getLevel() == 2) {
                    usageNode = (KDTreeNode)parentNode.getParent();
                    ptNode = parentNode;
                    longNumber = ((BomTreeInfo)ptNode.getUserObject()).getLongNumber();
                }
            }
            if (ptNode == null) {
                ProjectInfo projectInfo = bomTreeInfo.getProject();
                boolean isFound = false;
                if (projectInfo != null) {
                    longNumber = longNumber + "!2@" + projectInfo.getId().toString();
                    nodeText = projectInfo.getNumber();
                    if (usageNode != null && usageNode.children() != null) {
                        Enumeration en = usageNode.children();
                        while (en.hasMoreElements()) {
                            o = en.nextElement();
                            if (o == null || !(o instanceof KDTreeNode) || (ptNode = (KDTreeNode)o).getUserObject() == null || !(ptNode.getUserObject() instanceof BomTreeInfo) || !longNumber.equals((nodeObject = (BomTreeInfo)ptNode.getUserObject()).getLongNumber())) continue;
                            isFound = true;
                            break;
                        }
                    }
                } else {
                    longNumber = longNumber + "!2@999999999";
                }
                if (!isFound) {
                    if (projectInfo != null) {
                        ptNode = new KDTreeNode(null);
                        ptNode.setText(nodeText);
                        ptNode.setCheckBoxVisible(false);
                        nodeObject = new BomTreeInfo();
                        nodeObject.setLongNumber(longNumber);
                        nodeObject.setLevel(2);
                        nodeObject.setBomUsage(bomTreeInfo.getBomUsage());
                        nodeObject.setProject(projectInfo);
                        ptNode.setUserObject((Object)nodeObject);
                        tree.addNodeInto((MutableTreeNode)ptNode, (MutableTreeNode)usageNode);
                    } else {
                        ptNode = usageNode;
                    }
                }
            }
            longNumber = longNumber + "!3@" + bomTreeInfo.getMaterialInfo().getId().toString() + "@" + bomTreeInfo.getBomID();
            bomTreeInfo.setLongNumber(longNumber);
            tree.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)ptNode);
            this.refreshTreeNode(tree, treeNode);
            if (usageNode != null) {
                tree.expandPath(new TreePath(usageNode.getPath()));
            }
        }
    }

    private KDTreeNode buildChildren(KDTree tree, KDTreeNode parentNode, BomTreeInfo treeNodeInfo) {
        KDTreeNode beforeTreeNode = parentNode;
        TreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof TreeBaseInfo) {
            parentNodeInfo = (TreeBaseInfo)parentNode.getUserObject();
        }
        if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
            parentNode.setUserObject((Object)treeNodeInfo);
            if (!parentNode.isCheckBoxVisible()) {
                parentNode.setCheckBoxVisible(true);
            }
            if (treeNodeInfo.isIsAssign() && treeNodeInfo.getBomID() != null) {
                parentNode.setTextBold(true);
                parentNode.setTextColor(Color.BLUE);
            }
        }
        KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
        if (treeNodeInfo.isIsLeaf()) {
            treeNode.setVirtual(false);
            if (treeNodeInfo.isIsLeaf()) {
                treeNode.setCheckBoxVisible(false);
            }
        } else {
            treeNode.setVirtual(true);
            treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
        }
        if (treeNodeInfo.isIsAssign() && treeNodeInfo.getBomID() != null) {
            treeNode.setTextBold(true);
            treeNode.setTextColor(Color.BLUE);
        }
        tree.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode);
        return treeNode;
    }

    private KDTreeNode getParentNode(Map nodeMap, String insertLongNumber) {
        KDTreeNode treeNode = null;
        int index = insertLongNumber.lastIndexOf("!");
        String levelStr = insertLongNumber.substring(index + 1, index + 2);
        int insertLevel = Integer.parseInt(levelStr);
        if (insertLevel < 3) {
            return null;
        }
        String tmp = insertLongNumber;
        String str = "!" + insertLevel;
        if (tmp.indexOf(str) == -1) {
            return null;
        }
        if (nodeMap.containsKey(tmp = tmp.substring(0, tmp.indexOf(str)))) {
            treeNode = (KDTreeNode)nodeMap.get(tmp);
        }
        return treeNode;
    }

    private String getProjectNodeText(ProjectInfo projectInfo) {
        String nodeText = null;
        nodeText = this.isShowProjectName ? projectInfo.getNumber() + "&" + projectInfo.getName() : projectInfo.getNumber();
        return nodeText;
    }
}

