/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.mm.basedata.SubMaterialProcessModeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractBomBatchFilterUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;

public class BomBatchFilterUI
extends AbstractBomBatchFilterUI {
    private static final long serialVersionUID = 6786365928013629629L;
    private static final String STORAGEORGUNITID = "storageOrgUnit.id";
    private static final String PERMISSION_BOM_BATCHEDIT = "mm_bom_batchEdit";
    private Set materialAttrs = new HashSet();
    private Set bomTypes = new HashSet();
    private Set bomUsages = new HashSet();
    private Set bomStatuses = new HashSet();
    private CustomerParams customerParam = null;
    private DataChangeListener storageOrgUnitChanged = null;
    private DataChangeListener mterialGroupStandardTypeListener = null;
    private ItemListener processModeChangeListener = null;
    private MaterialGroupStandardInfo basicMaterialGroup = null;

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)PERMISSION_BOM_BATCHEDIT);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, BomBatchFilterUI.getResource("storageOrgUnit_Required")));
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new MMRangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("materialGroupStandardType", (Component)this.prmtMaterialGroupStandardType));
        elements.add((FilterElement)new MMRangeFilterElement("materialGroup", (Component)this.prmtMaterialGroupFrom, (Component)this.prmtMaterialGroupTo));
        elements.add((FilterElement)new SingleFilterElement("materialGroupSelectType", (Component)this.comboSelectType));
        elements.add((FilterElement)new SingleFilterElement("materialGroupOther", (Component)this.prmtMaterialGroupOther));
        elements.add((FilterElement)new SingleFilterElement("subMaterial", (Component)this.prmtSubMaterial));
        elements.add((FilterElement)new SingleFilterElement("processMode", (Component)this.cmbProcessMode));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)com.kingdee.eas.mm.common.client.MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)PERMISSION_BOM_BATCHEDIT);
        if (orgInfo == null) {
            this.initF7Material(null);
        }
    }

    private KDCheckBox[] getAllCheckBox() {
        return new KDCheckBox[]{this.checkboxOtherPart, this.checkboxExternalProcessInPart, this.checkboxPhantomPart, this.checkboxPurchasedPart, this.checkboxFabricatedPart, this.checkboxMfgBom, this.checkboxCfgBom, this.checkboxOrderBom, this.checkboxPBom, this.checkboxUsageMaster, this.checkboxUsageOther, this.checkboxUsageBackingOut, this.checkboxUsageMaintain, this.checkboxStatusSave, this.checkboxStatusSubmit, this.checkboxStatusAudit};
    }

    protected void initListener() {
        super.initListener();
        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        this.storageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object orgOld;
                Object orgNew = e.getNewValue();
                if (SCMGroupClientUtils.isDiffrent((Object)orgNew, (Object)(orgOld = e.getOldValue()))) {
                    BomBatchFilterUI.this.prmtMaterialFrom.setValue(null);
                    BomBatchFilterUI.this.prmtMaterialTo.setValue(null);
                    BomBatchFilterUI.this.prmtSubMaterial.setValue(null);
                    if (orgNew != null) {
                        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)orgNew;
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgInfo.getCU().getId().toString(), CompareType.EQUALS));
                        view.setFilter(filterInfo);
                        try {
                            CtrlUnitCollection cuCol = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(view);
                            if (cuCol != null && cuCol.size() > 0) {
                                BomBatchFilterUI.this.prmtMaterialGroupFrom.setCurrentCtrlUnit(cuCol.get(0));
                                BomBatchFilterUI.this.prmtMaterialGroupTo.setCurrentCtrlUnit(cuCol.get(0));
                                BomBatchFilterUI.this.prmtMaterialGroupOther.setCurrentCtrlUnit(cuCol.get(0));
                            }
                        }
                        catch (BOSException e1) {
                            BomBatchFilterUI.this.handUIException(e1);
                        }
                    }
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.prmtMaterialGroupStandardType.removeDataChangeListener(this.mterialGroupStandardTypeListener);
        this.mterialGroupStandardTypeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object orgOld;
                Object orgNew = e.getNewValue();
                if (SCMGroupClientUtils.isDiffrent((Object)orgNew, (Object)(orgOld = e.getOldValue()))) {
                    BomBatchFilterUI.this.prmtMaterialGroupFrom.setValue(null);
                    BomBatchFilterUI.this.prmtMaterialGroupTo.setValue(null);
                    BomBatchFilterUI.this.prmtMaterialGroupOther.setValue(null);
                }
            }
        };
        this.prmtMaterialGroupStandardType.addDataChangeListener(this.mterialGroupStandardTypeListener);
        this.prmtMaterialFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BomBatchFilterUI.this.materialSelectOrCommit();
            }
        });
        this.prmtMaterialFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                BomBatchFilterUI.this.materialSelectOrCommit();
            }
        });
        this.prmtMaterialTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BomBatchFilterUI.this.materialSelectOrCommit();
            }
        });
        this.prmtMaterialTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                BomBatchFilterUI.this.materialSelectOrCommit();
            }
        });
        this.prmtSubMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BomBatchFilterUI.this.materialSelectOrCommit();
            }
        });
        this.prmtSubMaterial.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                BomBatchFilterUI.this.materialSelectOrCommit();
            }
        });
        this.prmtMaterialGroupStandardType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                BomBatchFilterUI.this.materialGroupStandardTypeChanged(e);
            }
        });
        if (this.processModeChangeListener == null) {
            this.processModeChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BomBatchFilterUI.this.prmtSubMaterial.setValue(null);
                }
            };
        }
        this.cmbProcessMode.addItemListener(this.processModeChangeListener);
    }

    private void materialSelectOrCommit() {
        if (null == this.prmtStorageOrgUnit.getValue()) {
            return;
        }
        OrgUnitInfo orgUnitInfo = null;
        if (this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
            Object[] objValues = (Object[])this.prmtStorageOrgUnit.getValue();
            orgUnitInfo = (OrgUnitInfo)objValues[0];
        } else if (this.prmtStorageOrgUnit.getValue() instanceof Object) {
            Object objValue = this.prmtStorageOrgUnit.getValue();
            orgUnitInfo = (OrgUnitInfo)objValue;
        }
        this.initF7Material(orgUnitInfo);
    }

    private void initF7Material(OrgUnitInfo orgInfo) {
        this.entityViewInfo = new EntityViewInfo();
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
        String queryInfo = QueryInfoConstants.getMaterialQueryInfo((OrgType)OrgType.Storage);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterialFrom, null, materialPlanQuery, orgInfo, false);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterialTo, null, materialPlanQuery, orgInfo, false);
        SubMaterialProcessModeEnum selectEnum = (SubMaterialProcessModeEnum)((Object)this.cmbProcessMode.getSelectedItem());
        if (selectEnum.equals((Object)SubMaterialProcessModeEnum.ADDNEW)) {
            this.f7Manager.registerBizMaterialF7(this.prmtSubMaterial, null, materialPlanQuery, orgInfo, false);
        } else {
            this.f7Manager.registerBizMaterialF7(this.prmtSubMaterial, null, queryInfo, orgInfo, false);
        }
        FilterInfo filterInfo = new FilterInfo();
        String orgId = null;
        if (orgInfo != null) {
            orgId = orgInfo.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo(STORAGEORGUNITID, (Object)orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        this.entityViewInfo.setFilter(filterInfo);
        this.prmtMaterialFrom.setEntityViewInfo(this.entityViewInfo);
        this.prmtMaterialTo.setEntityViewInfo(this.entityViewInfo);
        this.initF7SubMaterial(orgId);
    }

    private void initF7SubMaterial(String storageOrgUnitId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SubMaterialProcessModeEnum mode = (SubMaterialProcessModeEnum)((Object)this.cmbProcessMode.getSelectedItem());
        String sMask = null;
        if (SubMaterialProcessModeEnum.ADDNEW.equals((Object)mode)) {
            Integer status = new Integer(1);
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)status, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)status, CompareType.EQUALS));
            Integer materialAttr = new Integer(10020);
            filter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)materialAttr, CompareType.EQUALS));
            sMask = "#0 and #1 and (#2 or #3)";
        } else {
            Integer status = new Integer(1);
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)status, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
            sMask = "#0 and #1";
        }
        filter.setMaskString(sMask);
        view.setFilter(filter);
        this.prmtSubMaterial.setEntityViewInfo(view);
    }

    private void materialGroupStandardTypeChanged(DataChangeEvent e) {
        MaterialGroupStandardInfo groupStandard = (MaterialGroupStandardInfo)e.getNewValue();
        MaterialGroupStandardInfo groupStandardOld = (MaterialGroupStandardInfo)e.getOldValue();
        if (SCMGroupClientUtils.isDiffrent((Object)groupStandardOld, (Object)groupStandard) && groupStandard != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)groupStandard.getId().toString(), CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            this.prmtMaterialGroupFrom.setEntityViewInfo(viewInfo);
            this.prmtMaterialGroupTo.setEntityViewInfo(viewInfo);
            this.prmtMaterialGroupOther.setEntityViewInfo(viewInfo);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            return filterInfo;
        }
        try {
            FilterInfo filter;
            if (this.materialAttrs.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("materialAttr", (Object)this.materialAttrs, CompareType.INCLUDE));
                filterInfo.mergeFilter(filter, "AND");
            }
            if (this.bomTypes.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bomType", (Object)this.bomTypes, CompareType.INCLUDE));
                filterInfo.mergeFilter(filter, "AND");
            }
            if (this.bomUsages.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bomUsage", (Object)this.bomUsages, CompareType.INCLUDE));
                filterInfo.mergeFilter(filter, "AND");
            }
            if (this.bomStatuses.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)this.bomStatuses, CompareType.INCLUDE));
                filterInfo.mergeFilter(filter, "AND");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.customerParam = cp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.checkboxFabricatedPart.isSelected()) {
                pp.addCustomerParam("materialAttrFabricatedPart", String.valueOf(10030));
            }
            if (this.checkboxExternalProcessInPart.isSelected()) {
                pp.addCustomerParam("materialAttrExternalProcessInPart", String.valueOf(10050));
            }
            if (this.checkboxPhantomPart.isSelected()) {
                pp.addCustomerParam("materialAttrPhantomPart", String.valueOf(10020));
            }
            if (this.checkboxPurchasedPart.isSelected()) {
                pp.addCustomerParam("materialAttrPurchasedPart", String.valueOf(10040));
            }
            if (this.checkboxOtherPart.isSelected()) {
                pp.addCustomerParam("materialAttrOtherPart", String.valueOf(10060));
            }
            if (this.checkboxMfgBom.isSelected()) {
                pp.addCustomerParam("bomTypeMfgBom", String.valueOf(40));
            }
            if (this.checkboxCfgBom.isSelected()) {
                pp.addCustomerParam("bomTypeCfgBom", String.valueOf(50));
            }
            if (this.checkboxOrderBom.isSelected()) {
                pp.addCustomerParam("bomTypeOrderBom", String.valueOf(45));
            }
            if (this.checkboxPBom.isSelected()) {
                pp.addCustomerParam("bomTypePBom", String.valueOf(55));
            }
            if (this.checkboxStatusSave.isSelected()) {
                pp.addCustomerParam("baseStatusSave", String.valueOf(1));
            }
            if (this.checkboxStatusSubmit.isSelected()) {
                pp.addCustomerParam("baseStatusSubmit", String.valueOf(2));
            }
            if (this.checkboxStatusAudit.isSelected()) {
                pp.addCustomerParam("baseStatusAudit", String.valueOf(4));
            }
            if (this.checkboxUsageMaster.isSelected()) {
                pp.addCustomerParam("bomUsageMaster", String.valueOf(10));
            }
            if (this.checkboxUsageOther.isSelected()) {
                pp.addCustomerParam("bomUsageOther", String.valueOf(40));
            }
            if (this.checkboxUsageBackingOut.isSelected()) {
                pp.addCustomerParam("bomUsageBackingOut", String.valueOf(20));
            }
            if (this.checkboxUsageMaintain.isSelected()) {
                pp.addCustomerParam("bomUsageMaintain", String.valueOf(30));
            }
            pp.addCustomerParam("materialGroupStandardType.id", ((MaterialGroupStandardInfo)this.prmtMaterialGroupStandardType.getValue()).getId().toString());
            if (this.prmtMaterialGroupFrom.getValue() != null) {
                pp.addCustomerParam("materialGroupFrom.id", ((MaterialGroupInfo)this.prmtMaterialGroupFrom.getValue()).getId().toString());
            }
            if (this.prmtMaterialGroupTo.getValue() != null) {
                pp.addCustomerParam("materialGroupTo.id", ((MaterialGroupInfo)this.prmtMaterialGroupTo.getValue()).getId().toString());
            }
            if (this.prmtMaterialGroupOther.getValue() != null) {
                Object[] objects = (Object[])this.prmtMaterialGroupOther.getValue();
                MaterialGroupInfo[] materialGroups = new MaterialGroupInfo[objects.length];
                System.arraycopy(objects, 0, materialGroups, 0, materialGroups.length);
                StringBuffer sb = new StringBuffer();
                MaterialGroupInfo obj = null;
                if (materialGroups != null && materialGroups.length > 0) {
                    for (int i = 0; i < materialGroups.length; ++i) {
                        obj = materialGroups[i];
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        if (!(obj instanceof ObjectBaseInfo)) continue;
                        sb.append(((ObjectBaseInfo)obj).getId().toString());
                    }
                }
                pp.addCustomerParam("materialGroupOther.ids", sb.toString());
            }
            if (this.prmtMaterialFrom.getValue() != null) {
                pp.addCustomerParam("materialFrom.id", ((MaterialInfo)this.prmtMaterialFrom.getValue()).getId().toString());
            }
            if (this.prmtMaterialTo.getValue() != null) {
                pp.addCustomerParam("materialTo.id", ((MaterialInfo)this.prmtMaterialTo.getValue()).getId().toString());
            }
            if (this.prmtSubMaterial.getValue() != null) {
                MaterialInfo material = (MaterialInfo)this.prmtSubMaterial.getValue();
                pp.addCustomerParam("subMaterial.id", material.getId().toString());
            }
            if (this.cmbProcessMode.getSelectedItem() != null) {
                SubMaterialProcessModeEnum mode = (SubMaterialProcessModeEnum)((Object)this.cmbProcessMode.getSelectedItem());
                pp.addCustomerParam("processMode", String.valueOf(mode.getValue()));
            }
        }
        return pp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        KDCheckBox[] checkboxs = this.getAllCheckBox();
        for (int i = 0; i < checkboxs.length; ++i) {
            checkboxs[i].setSelected(false);
        }
        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        super.loadData(entityViewInfo);
        if (this.customerParam.getCustomerParam("materialAttrFabricatedPart") != null && this.customerParam.getCustomerParam("materialAttrFabricatedPart").length() > 0) {
            this.checkboxFabricatedPart.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("materialAttrExternalProcessInPart") != null && this.customerParam.getCustomerParam("materialAttrExternalProcessInPart").length() > 0) {
            this.checkboxExternalProcessInPart.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("materialAttrPhantomPart") != null && this.customerParam.getCustomerParam("materialAttrPhantomPart").length() > 0) {
            this.checkboxPhantomPart.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("materialAttrPurchasedPart") != null && this.customerParam.getCustomerParam("materialAttrPurchasedPart").length() > 0) {
            this.checkboxPurchasedPart.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("materialAttrOtherPart") != null && this.customerParam.getCustomerParam("materialAttrOtherPart").length() > 0) {
            this.checkboxOtherPart.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomTypeMfgBom") != null && this.customerParam.getCustomerParam("bomTypeMfgBom").length() > 0) {
            this.checkboxMfgBom.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomTypeCfgBom") != null && this.customerParam.getCustomerParam("bomTypeCfgBom").length() > 0) {
            this.checkboxCfgBom.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomTypeOrderBom") != null && this.customerParam.getCustomerParam("bomTypeOrderBom").length() > 0) {
            this.checkboxOrderBom.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomTypePBom") != null && this.customerParam.getCustomerParam("bomTypePBom").length() > 0) {
            this.checkboxPBom.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("baseStatusSave") != null && this.customerParam.getCustomerParam("baseStatusSave").length() > 0) {
            this.checkboxStatusSave.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("baseStatusSubmit") != null && this.customerParam.getCustomerParam("baseStatusSubmit").length() > 0) {
            this.checkboxStatusSubmit.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("baseStatusAudit") != null && this.customerParam.getCustomerParam("baseStatusAudit").length() > 0) {
            this.checkboxStatusAudit.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomUsageMaster") != null && this.customerParam.getCustomerParam("bomUsageMaster").length() > 0) {
            this.checkboxUsageMaster.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomUsageOther") != null && this.customerParam.getCustomerParam("bomUsageOther").length() > 0) {
            this.checkboxUsageOther.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomUsageBackingOut") != null && this.customerParam.getCustomerParam("bomUsageBackingOut").length() > 0) {
            this.checkboxUsageBackingOut.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("bomUsageMaintain") != null && this.customerParam.getCustomerParam("bomUsageMaintain").length() > 0) {
            this.checkboxUsageMaintain.setSelected(true);
        }
        if (this.customerParam.getCustomerParam("processMode") != null && this.customerParam.getCustomerParam("processMode").length() > 0) {
            String modeStr = this.customerParam.getCustomerParam("processMode");
            Integer modeInteger = new Integer(modeStr);
            SubMaterialProcessModeEnum mode = SubMaterialProcessModeEnum.getEnum(modeInteger);
            this.cmbProcessMode.setSelectedItem((Object)mode);
        }
        if (this.prmtStorageOrgUnit.getValue() != null) {
            FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            try {
                CtrlUnitCollection cuCol = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(view);
                if (cuCol != null && cuCol.size() > 0) {
                    this.prmtMaterialGroupFrom.setCurrentCtrlUnit(cuCol.get(0));
                    this.prmtMaterialGroupTo.setCurrentCtrlUnit(cuCol.get(0));
                    this.prmtMaterialGroupOther.setCurrentCtrlUnit(cuCol.get(0));
                }
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String materialGroupStandardTypeId = this.customerParam.getCustomerParam("materialGroupStandardType.id");
        if (materialGroupStandardTypeId != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)materialGroupStandardTypeId, CompareType.EQUALS));
            view.setFilter(filter);
            try {
                MaterialGroupStandardCollection coll = MaterialGroupStandardFactory.getRemoteInstance().getMaterialGroupStandardCollection(view);
                this.prmtMaterialGroupStandardType.setValue((Object)coll.get(0));
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        String materialGroupFrom = this.customerParam.getCustomerParam("materialGroupFrom.id");
        String materialGroupTo = this.customerParam.getCustomerParam("materialGroupTo.id");
        String materialGroupOther = this.customerParam.getCustomerParam("materialGroupOther.ids");
        HashSet<String> materialGroupIds = new HashSet<String>();
        if (materialGroupFrom != null) {
            materialGroupIds.add(materialGroupFrom);
        }
        if (materialGroupTo != null) {
            materialGroupIds.add(materialGroupTo);
        }
        String[] materialGroupOtherIds = null;
        if (materialGroupOther != null) {
            materialGroupOtherIds = materialGroupOther.replaceAll("\\s*|\t|\r|\n", "").split(";");
            for (int i = 0; i < materialGroupOtherIds.length; ++i) {
                materialGroupIds.add(materialGroupOtherIds[i]);
            }
        }
        if (materialGroupIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", materialGroupIds, CompareType.INCLUDE));
            view.setFilter(filter);
            try {
                MaterialGroupCollection coll = MaterialGroupFactory.getRemoteInstance().getMaterialGroupCollection(view);
                if (materialGroupFrom != null) {
                    this.prmtMaterialGroupFrom.setValue((Object)coll.get((Object)BOSUuid.read((String)materialGroupFrom)));
                }
                if (materialGroupTo != null) {
                    this.prmtMaterialGroupTo.setValue((Object)coll.get((Object)BOSUuid.read((String)materialGroupTo)));
                }
                if (materialGroupOtherIds != null) {
                    MaterialGroupCollection collTemp = new MaterialGroupCollection();
                    for (int i = 0; i < materialGroupOtherIds.length; ++i) {
                        if (materialGroupOtherIds[i] == null || "".equals(materialGroupOtherIds[i]) || coll.get((Object)BOSUuid.read((String)materialGroupOtherIds[i])) == null) continue;
                        collTemp.add(coll.get((Object)BOSUuid.read((String)materialGroupOtherIds[i])));
                    }
                    if (collTemp.size() > 0) {
                        MaterialGroupInfo[] materialGroups = new MaterialGroupInfo[collTemp.size()];
                        System.arraycopy(collTemp.toArray(), 0, materialGroups, 0, materialGroups.length);
                        this.prmtMaterialGroupOther.setValue((Object)materialGroups);
                    }
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        String materialFrom = this.customerParam.getCustomerParam("materialFrom.id");
        String materialTo = this.customerParam.getCustomerParam("materialTo.id");
        String subMaterialId = this.customerParam.getCustomerParam("subMaterial.id");
        HashSet<String> materialIds = new HashSet<String>();
        if (materialFrom != null) {
            materialIds.add(materialFrom);
        }
        if (materialTo != null) {
            materialIds.add(materialTo);
        }
        if (MMUtils.isNotEmptyString((String)subMaterialId)) {
            materialIds.add(subMaterialId);
        }
        if (materialIds.size() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", materialIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add("id");
            selectorColl.add("name");
            selectorColl.add("number");
            view.setSelector(selectorColl);
            try {
                MaterialCollection coll = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                if (materialFrom != null) {
                    this.prmtMaterialFrom.setValue((Object)coll.get((Object)BOSUuid.read((String)materialFrom)));
                }
                if (materialTo != null) {
                    this.prmtMaterialTo.setValue((Object)coll.get((Object)BOSUuid.read((String)materialTo)));
                }
                if (MMUtils.isNotEmptyString((String)subMaterialId)) {
                    this.prmtSubMaterial.setValue((Object)coll.get((Object)BOSUuid.read((String)subMaterialId)));
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (!flag) {
            return flag;
        }
        if (this.prmtMaterialGroupStandardType.getValue() == null) {
            MsgBox.showInfo((String)BomBatchFilterUI.getResource("materialGroupStandardType_not_null"));
            this.prmtMaterialGroupStandardType.requestFocus(true);
            return false;
        }
        this.materialAttrs.clear();
        if (this.checkboxFabricatedPart.isSelected()) {
            this.materialAttrs.add(new Integer(10030));
        }
        if (this.checkboxExternalProcessInPart.isSelected()) {
            this.materialAttrs.add(new Integer(10050));
        }
        if (this.checkboxPhantomPart.isSelected()) {
            this.materialAttrs.add(new Integer(10020));
        }
        if (this.checkboxPurchasedPart.isSelected()) {
            this.materialAttrs.add(new Integer(10040));
        }
        if (this.checkboxOtherPart.isSelected()) {
            this.materialAttrs.add(new Integer(10060));
        }
        if (this.materialAttrs.size() <= 0) {
            MsgBox.showInfo((String)BomBatchFilterUI.getResource("materialAttr_required"));
            return false;
        }
        this.bomTypes.clear();
        if (this.checkboxMfgBom.isSelected()) {
            this.bomTypes.add(new Integer(40));
        }
        if (this.checkboxCfgBom.isSelected()) {
            this.bomTypes.add(new Integer(50));
        }
        if (this.checkboxOrderBom.isSelected()) {
            this.bomTypes.add(new Integer(45));
        }
        if (this.checkboxPBom.isSelected()) {
            this.bomTypes.add(new Integer(55));
        }
        if (this.bomTypes.size() <= 0) {
            MsgBox.showInfo((String)BomBatchFilterUI.getResource("batchEdit_bomType_required"));
            return false;
        }
        this.bomStatuses.clear();
        if (this.checkboxStatusSave.isSelected()) {
            this.bomStatuses.add(new Integer(1));
        }
        if (this.checkboxStatusSubmit.isSelected()) {
            this.bomStatuses.add(new Integer(2));
        }
        if (this.checkboxStatusAudit.isSelected()) {
            this.bomStatuses.add(new Integer(4));
        }
        if (this.bomStatuses.size() <= 0) {
            MsgBox.showInfo((String)BomBatchFilterUI.getResource("bomStatus_required"));
            return false;
        }
        this.bomUsages.clear();
        if (this.checkboxUsageMaster.isSelected()) {
            this.bomUsages.add(new Integer(10));
        }
        if (this.checkboxUsageOther.isSelected()) {
            this.bomUsages.add(new Integer(40));
        }
        if (this.checkboxUsageBackingOut.isSelected()) {
            this.bomUsages.add(new Integer(20));
        }
        if (this.checkboxUsageMaintain.isSelected()) {
            this.bomUsages.add(new Integer(30));
        }
        if (this.bomUsages.size() <= 0) {
            MsgBox.showInfo((String)BomBatchFilterUI.getResource("bomUsage_required"));
            return false;
        }
        return true;
    }

    protected String getViewPermission() {
        return PERMISSION_BOM_BATCHEDIT;
    }

    public void clear() {
        super.clear();
        KDCheckBox[] checkboxs = this.getAllCheckBox();
        for (int i = 0; i < checkboxs.length; ++i) {
            checkboxs[i].setSelected(true);
        }
        this.comboSelectType.setSelectedIndex(0);
        try {
            SysContext ctx = SysContext.getSysContext();
            ObjectUuidPK userPK = new ObjectUuidPK(ctx.getCurrentUserInfo().getId());
            ObjectUuidPK cuPK = new ObjectUuidPK(ctx.getCurrentCtrlUnit().getId());
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)cuPK, (String)"materialgroupstd_view");
            if (this.basicMaterialGroup == null) {
                MaterialGroupStandardCollection groupColls = MaterialGroupStandardFactory.getRemoteInstance().getBaseMaterialGroupStandardColl();
                this.basicMaterialGroup = groupColls.get(0);
            }
            this.prmtMaterialGroupStandardType.setValue((Object)this.basicMaterialGroup);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.prmtMaterialGroupStandardType.setValue(null);
        }
        this.cmbProcessMode.setSelectedItem((Object)SubMaterialProcessModeEnum.MODIFY);
    }

    protected String getPropertyOfMainBizOrg() {
        return STORAGEORGUNITID;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMResource", (String)strKey);
    }
}

