/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BomCompareEnum;
import com.kingdee.eas.mm.basedata.client.AbstractBomCompareFilterUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.basedata.client.BomCompareUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BomCompareFilterUI
extends AbstractBomCompareFilterUI {
    private static final String SELECTED = "selected";
    private static final Logger logger = CoreUIObject.getLogger(BomCompareFilterUI.class);
    private DataChangeListener prmtStorageOrgUnitListener = null;
    private ItemListener comQueryTypeListener = null;
    private DataChangeListener datePickerQueryListener = null;
    protected F7ContextManager f7Manager = null;
    protected List bomResultIDs = new ArrayList();
    protected List materialIDs = new ArrayList();
    private String storageOrgUnitName = null;
    private static final int MaxCompareCount = 10;
    protected String compareType = BomCompareEnum.SingleLevel.getName();
    private static final String RESOURCEE_BOM_COMPARE = "com.kingdee.eas.mm.basedata.BOMCompareResource";
    private static final BigDecimal ZERO = new BigDecimal("0");

    public BomCompareFilterUI() throws Exception {
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void addListener() {
        if (this.prmtStorageOrgUnitListener == null) {
            this.prmtStorageOrgUnitListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    try {
                        BomCompareFilterUI.this.prmtStorageOrgUnit_dataChange(event);
                    }
                    catch (Exception e) {
                        BomCompareFilterUI.this.handUIExceptionAndAbort(e);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.prmtStorageOrgUnitListener);
        if (this.comQueryTypeListener == null) {
            this.comQueryTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    try {
                        BomCompareFilterUI.this.cmbQueryType_itemStateChanged(event);
                    }
                    catch (Exception e) {
                        BomCompareFilterUI.this.handUIException(e);
                    }
                }
            };
        }
        this.comQueryType.addItemListener(this.comQueryTypeListener);
        if (this.datePickerQueryListener == null) {
            this.datePickerQueryListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    try {
                        BomCompareFilterUI.this.datePickerQuery_dataChange(event);
                    }
                    catch (Exception e) {
                        BomCompareFilterUI.this.handUIExceptionAndAbort(e);
                    }
                }
            };
        }
        this.datePickerQuery.addDataChangeListener(this.datePickerQueryListener);
    }

    private void datePickerQuery_dataChange(DataChangeEvent event) {
        if (this.datePickerQuery.getValue() == null) {
            return;
        }
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)event.getNewValue(), (Object)event.getOldValue());
        if (isDiffrent) {
            this.resetBOMSelectAndResultList();
        }
    }

    private void resetBOMSelectAndResultList() {
        this.kdtBomSelectList.removeRows();
        this.kdtBomResultList.removeRows();
        this.bomResultIDs.clear();
        this.materialIDs.clear();
        this.actionSelectAll();
    }

    private void cmbQueryType_itemStateChanged(ItemEvent e) {
        if (this.comQueryType.getSelectedItem() == null) {
            return;
        }
        if (((BomCompareEnum)((Object)this.comQueryType.getSelectedItem())).getName().equalsIgnoreCase(this.compareType)) {
            return;
        }
        this.compareType = ((BomCompareEnum)((Object)this.comQueryType.getSelectedItem())).getName();
        this.resetBOMSelectAndResultList();
    }

    private void prmtStorageOrgUnit_dataChange(DataChangeEvent event) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)event.getNewValue(), (Object)event.getOldValue());
        if (isDiffrent) {
            this.prmtMaterial.setValue(null);
            this.initNeedMainOrgF7s();
            this.kdtBomSelectList.removeRows();
        }
    }

    private void removeListener() {
        if (this.prmtStorageOrgUnitListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.prmtStorageOrgUnitListener);
        }
        if (this.comQueryTypeListener != null) {
            this.comQueryType.removeItemListener(this.comQueryTypeListener);
        }
        if (this.datePickerQueryListener != null) {
            this.datePickerQuery.removeDataChangeListener(this.datePickerQueryListener);
        }
    }

    protected void initNeedMainOrgF7s() {
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, materialPlanQuery, orgInfo, OrgType.Storage, true, true);
        EntityViewInfo view = this.prmtMaterial.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (orgInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)new Integer(10020), CompareType.EQUALS));
        String sMask = "#0 and #1 and (#2 or #3)";
        filter.setMaskString(sMask);
        view.setFilter(filter);
        this.prmtMaterial.setEntityViewInfo(view);
        this.prmtMaterial.getEntityViewInfo().setFilter(filter);
        this.prmtMaterial.setDisplayFormat("$name$");
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        StorageOrgUnitInfo souInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        Object[] materialInfos = (Object[])this.prmtMaterial.getValue();
        this.isEmptyStorageOrgUnitAndMaterial(souInfo, materialInfos);
        FilterInfo filterInfo = this.getBomQueryFilterInfo(souInfo, materialInfos);
        this.queryBomCompareQuery.setFilter(filterInfo);
        this.kdtBomSelectList.removeRows();
        int size = this.kdtBomSelectList.getBody().getRows().size();
        for (int i = 0; i < size; ++i) {
            if (this.kdtBomSelectList.getRow(i).getCell("productQty").getValue() == null) continue;
            this.kdtBomSelectList.getRow(i).getCell("productQty").setValue((Object)this.formatZero(this.kdtBomSelectList.getRow(i).getCell("productQty").getValue().toString()));
        }
        this.actionSelectAll();
    }

    private FilterInfo getBomQueryFilterInfo(StorageOrgUnitInfo souInfo, Object[] materialInfos) {
        FilterInfo filterInfo = new FilterInfo();
        if (souInfo.getId().toString() != null && souInfo.getId().toString().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)souInfo.getId().toString(), CompareType.EQUALS));
            this.storageOrgUnitName = souInfo.getName(BomCompareFilterUI.getDefaultLocale());
        }
        StringBuffer materialIDsSB = new StringBuffer();
        for (int i = 0; i < materialInfos.length; ++i) {
            if (i != 0) {
                materialIDsSB.append(",");
            }
            materialIDsSB.append(((MaterialInfo)materialInfos[i]).getId().toString());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIDsSB.toString(), CompareType.INCLUDE));
        if (this.datePickerQuery.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entrys.effectiveDate", this.datePickerQuery.getValue(), CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("entrys.disableDate", this.datePickerQuery.getValue(), CompareType.GREATER_EQUALS));
        }
        this.comQueryType.getSelectedIndex();
        if (((BomCompareEnum)((Object)this.comQueryType.getSelectedItem())).getName().equalsIgnoreCase(BomCompareEnum.MultiLevel.getName())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bomUsage", (Object)new Integer(10), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bomtype", (Object)new Integer(40), CompareType.EQUALS));
        return filterInfo;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.actionSelectAll();
    }

    private void actionSelectAll() {
        int count = this.kdtBomSelectList.getRowCount3();
        for (int i = 0; i < count; ++i) {
            this.kdtBomSelectList.getCell(i, SELECTED).setValue((Object)true);
        }
        this.kdtBomSelectList.getColumn(SELECTED).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
    }

    @Override
    public void actionUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.actionUnselectAll();
    }

    private void actionUnselectAll() {
        int count = this.kdtBomSelectList.getRowCount3();
        for (int i = 0; i < count; ++i) {
            this.kdtBomSelectList.getCell(i, SELECTED).setValue((Object)false);
        }
        this.kdtBomSelectList.getColumn(SELECTED).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        int i;
        StringBuffer errorMessage = new StringBuffer();
        String message = null;
        int selectCount = 0;
        int count = this.kdtBomSelectList.getRowCount3();
        for (i = 0; i < count; ++i) {
            if (!this.kdtBomSelectList.getCell(i, SELECTED).getValue().equals(Boolean.TRUE)) continue;
            ++selectCount;
        }
        if (selectCount + this.bomResultIDs.size() > 10) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_Reselect"));
            SysUtil.abort();
        }
        count = this.kdtBomSelectList.getRowCount3();
        for (i = 0; i < count; ++i) {
            if (!this.kdtBomSelectList.getCell(i, SELECTED).getValue().equals(Boolean.TRUE)) continue;
            errorMessage = this.addBomResultList(this.kdtBomSelectList.getRow(i), errorMessage);
        }
        message = errorMessage.toString();
        if (message != null && message.trim().length() > 0) {
            MsgBox.showInfo((String)message);
            SysUtil.abort();
        }
    }

    private StringBuffer addBomResultList(IRow row, StringBuffer errorMessage) {
        String bomID = (String)row.getCell("bomID").getValue();
        String materialID = (String)row.getCell("material.id").getValue();
        if (this.bomResultIDs.size() < 10) {
            if (!this.bomResultIDs.contains(bomID)) {
                this.bomResultIDs.add(bomID);
                this.materialIDs.add(materialID);
                this.addBomResultRow(row);
            } else {
                errorMessage.append((String)row.getCell("bomNumber").getValue());
                errorMessage.append(EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_AlreadySelected"));
                errorMessage.append("\r\n");
            }
        } else {
            errorMessage.append(EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_Reselect"));
            MsgBox.showInfo((String)errorMessage.toString());
            SysUtil.abort();
        }
        return errorMessage;
    }

    protected void addBomResultRow(IRow row) {
        IRow addRow = this.kdtBomResultList.addRow();
        addRow.getCell(0).setValue((Object)this.storageOrgUnitName);
        addRow.getCell(1).setValue(row.getCell("bomNumber").getValue());
        addRow.getCell(2).setValue(row.getCell("bomName").getValue());
        addRow.getCell(3).setValue(row.getCell("bomType").getValue());
        addRow.getCell(4).setValue(row.getCell("bomUsage").getValue());
        addRow.getCell(5).setValue(row.getCell("materialNum").getValue());
        addRow.getCell(6).setValue(row.getCell("materialName").getValue());
        addRow.getCell(7).setValue(row.getCell("material.model").getValue());
        addRow.getCell(8).setValue(row.getCell("productQty").getValue());
        addRow.getCell(9).setValue(row.getCell("measureUnit").getValue());
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtBomResultList);
        if (selectRows != null && selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                this.kdtBomResultList.removeRow(selectRows[i]);
                this.bomResultIDs.remove(selectRows[i]);
                this.materialIDs.remove(selectRows[i]);
            }
        }
    }

    @Override
    public void actionCompare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCompare_actionPerformed(e);
        if (this.bomResultIDs == null || this.bomResultIDs.size() < 2) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_SelectOverTwo"));
            SysUtil.abort();
        }
        this.setFilterParam();
        this.disposeUIWindow();
    }

    private void setFilterParam() {
        this.getUIContext().remove("filterMap");
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("actionName", "actionCompare_actionPerformed");
        filterMap.put("bomResultIDs", this.bomResultIDs);
        filterMap.put("kdtBomResultList", this.kdtBomResultList);
        filterMap.put("queryType", ((BomCompareEnum)((Object)this.comQueryType.getSelectedItem())).getName());
        filterMap.put("queryDate", this.datePickerQuery.getValue());
        filterMap.put("materialIDs", this.materialIDs);
        filterMap.put("storageOrgUnit", (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        this.getUIContext().put("filterMap", filterMap);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.queryBomCompareQuery = new EntityViewInfo();
        this.kdtBomResultList.checkParsed();
        this.kdtBomSelectList.checkParsed();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_compare");
        StorageOrgUnitInfo foi = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_bom_compare");
        if (foi == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtMaterial.setEntityViewInfo(view);
            return;
        }
        this.prmtStorageOrgUnit.setValue((Object)foi);
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtStorageOrgUnit.setEditFormat("$number$");
        this.prmtStorageOrgUnit.setCommitFormat("$number$");
        this.initNeedMainOrgF7s();
        this.kdtBomResultList.getSelectManager().setSelectMode(10);
        this.prmtStorageOrgUnit.setEditable(false);
        this.recallCompareCondition();
        this.addListener();
        this.kdtBomSelectList.getActionMap().remove("Delete");
        this.kdtBomResultList.getActionMap().remove("Delete");
        this.kdtBomSelectList.removeRows();
        this.kdtBomResultList.removeRows();
        this.bomResultIDs.clear();
        this.materialIDs.clear();
    }

    private void recallCompareCondition() {
        if (this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof BomCompareUI) {
            BomCompareUI bcUI = (BomCompareUI)((Object)this.getUIContext().get("Owner"));
            if (bcUI.filter_bomResultIDs != null) {
                this.bomResultIDs.addAll(bcUI.filter_bomResultIDs);
            }
            if (bcUI.filter_queryType != null) {
                this.comQueryType.setSelectedItem((Object)BomCompareEnum.getEnum(bcUI.filter_queryType));
                this.compareType = bcUI.filter_queryType;
            }
            if (bcUI.filter_queryDate != null) {
                this.datePickerQuery.setValue(bcUI.filter_queryDate);
            }
            if (bcUI.filter_materialIDs != null) {
                this.materialIDs.addAll(bcUI.filter_materialIDs);
            }
            if (bcUI.kdtBomList != null && bcUI.kdtBomList.getBody().getRows().size() > 0) {
                int size = bcUI.kdtBomList.getBody().getRows().size();
                for (int i = 0; i < size; ++i) {
                    IRow row = bcUI.kdtBomList.getRow(i);
                    this.setBOMResultRowFromHistory(row);
                }
            }
        }
    }

    private void setBOMResultRowFromHistory(IRow row) {
        IRow addRow = this.kdtBomResultList.addRow();
        addRow.getCell(0).setValue(row.getCell("storageOrg").getValue());
        addRow.getCell(1).setValue(row.getCell("number").getValue());
        addRow.getCell(2).setValue(row.getCell("name").getValue());
        addRow.getCell(3).setValue(row.getCell("bomType").getValue());
        addRow.getCell(4).setValue(row.getCell("bomUsage").getValue());
        addRow.getCell(5).setValue(row.getCell("materialNum").getValue());
        addRow.getCell(6).setValue(row.getCell("materialName").getValue());
        addRow.getCell(7).setValue(row.getCell("materialModel").getValue());
        addRow.getCell(8).setValue(row.getCell("parentQty").getValue());
        addRow.getCell(9).setValue(row.getCell("measureUnit").getValue());
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected void kdtBomSelectList_doRequestRowSet(RequestRowSetEvent e) {
        if (this.prmtStorageOrgUnit.getValue() == null || this.prmtMaterial.getValue() == null || ((Object[])this.prmtMaterial.getValue()).length == 0 || ((Object[])this.prmtMaterial.getValue())[0] == null) {
            return;
        }
        StorageOrgUnitInfo souInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        Object[] materialInfos = (Object[])this.prmtMaterial.getValue();
        this.isEmptyStorageOrgUnitAndMaterial(souInfo, materialInfos);
        FilterInfo filterInfo = this.getBomQueryFilterInfo(souInfo, materialInfos);
        if (filterInfo == null) {
            return;
        }
        this.queryBomCompareQuery.setFilter(filterInfo);
        if (this.queryBomCompareQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.queryBomCompareQueryPK, this.queryBomCompareQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    private void isEmptyStorageOrgUnitAndMaterial(StorageOrgUnitInfo souInfo, Object[] materialInfos) {
        if (souInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_NullSOU"));
            SysUtil.abort();
        }
        if (materialInfos == null || materialInfos.length == 0 || materialInfos[0] == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_NullMaterial"));
            SysUtil.abort();
        }
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(viewInfo);
        return exec;
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }
}

