/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgContextHelper;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import com.kingdee.eas.mm.basedata.BomCompareEnum;
import com.kingdee.eas.mm.basedata.BomCompareFacadeFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBomCompareFacade;
import com.kingdee.eas.mm.basedata.client.AbstractBomCompareUI;
import com.kingdee.eas.mm.basedata.client.BomCompareDataProvider;
import com.kingdee.eas.mm.basedata.client.BomCompareFilterUI;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;

public class BomCompareUI
extends AbstractBomCompareUI {
    private static final long serialVersionUID = 3864726006707263251L;
    private static final String BOM_NUM = "bomNum";
    private static final String IS_SAME = "isSame";
    private static final String MM_BASEDATA_BOM_BOMCOMPARE_PRINT_R1_PRINT = "/MM/basedata/BOM/BOMComparePrint.r1-print";
    private static final String FILTER_MAP = "filterMap";
    private static final String RESOURCEE_BOM_COMPARE = "com.kingdee.eas.mm.basedata.BOMCompareResource";
    protected String filter_actionName = null;
    protected List filter_bomResultIDs = new ArrayList();
    protected List filter_materialIDs = new ArrayList();
    protected KDTable filter_kdtBomResultList = null;
    protected String filter_queryType = null;
    protected Object filter_queryDate = null;
    private Set materialIdSet = new HashSet();
    private static final BigDecimal ZERO = new BigDecimal("0");

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void initOrgContextManager() {
        super.initOrgContextManager();
        if (this instanceof IMultiOrgSupport) {
            try {
                OrgContextHelper helper = new OrgContextHelper(this.dataBinder, new BomInfo().getBOSType());
                this.getUIContext().put("CONTEXT_INMAINTAINING_STATE", this.getOprtState());
                if (this.orgContextManager != null) {
                    return;
                }
                this.orgContextManager = new OrgContextManager((IMultiOrgSupport)this, ContextTypeEnum.INMAINTAINING, helper);
                this.orgContextManager.init(this.getUIContext());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 996, 200));
        this.contBOMList.setBounds(new Rectangle(0, 0, 996, 200));
        this.kDPanel3.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 996, 370));
        this.contResult.setBounds(new Rectangle(0, 0, 996, 370));
    }

    @Override
    public void actionQueryByMaterial_actionPerformed(ActionEvent e) throws Exception {
        Object[] materialInfos = (Object[])this.prmtMaterial.getValue();
        StringBuffer materialIDsSB = new StringBuffer();
        if (materialInfos != null && materialInfos.length > 0 && materialInfos[0] != null) {
            materialIDsSB.append(" '");
            for (int i = 0; i < materialInfos.length; ++i) {
                if (i != 0) {
                    materialIDsSB.append("', '");
                }
                materialIDsSB.append(((MaterialInfo)materialInfos[i]).getId().toString());
            }
        } else {
            return;
        }
        materialIDsSB.append("' ");
        this.kdtResult.removeRows();
        this.prmtMaterial.setAccessAuthority(2);
        this.btnConfirm.setEnabled(false);
        IRowSet rowSet = null;
        IBomCompareFacade bomCompareFacade = BomCompareFacadeFactory.getRemoteInstance();
        String[] bomIDs = this.filter_bomResultIDs.toArray(new String[0]);
        if (this.filter_queryType.equalsIgnoreCase(BomCompareEnum.SingleLevel.getName())) {
            rowSet = bomCompareFacade.getBomSingleCompareResult(bomIDs, (Date)this.filter_queryDate, LocaleUtils.getDefaultLocale().getLanguage(), materialIDsSB.toString());
        } else if (this.filter_queryType.equalsIgnoreCase(BomCompareEnum.MultiLevel.getName())) {
            try {
                rowSet = bomCompareFacade.getBomMultiCompareResult(bomIDs, (Date)this.filter_queryDate, LocaleUtils.getDefaultLocale().getLanguage(), materialIDsSB.toString());
            }
            catch (BOSException e1) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_PleaseCheckBOMData"));
                SysUtil.abort();
            }
        }
        this.processResultData(rowSet);
        this.prmtMaterial.setAccessAuthority(0);
        this.btnConfirm.setEnabled(true);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        HashMap filterMap = this.showBomCompareFilterUI();
        if (filterMap == null) {
            SysUtil.abort();
        }
        this.kdtBomList.removeRows();
        this.kdtResult.removeRows();
        this.getFilterParamValue(filterMap);
        this.fillBomCompareList(this.filter_kdtBomResultList);
        this.materialIdSet.clear();
        this.setBomCompareCols(this.filter_bomResultIDs);
        this.prmtMaterial.setAccessAuthority(2);
        this.btnConfirm.setEnabled(false);
        this.setBomCompareResult();
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)filterMap.get("storageOrgUnit");
        if (this.getMainOrgContext() != null) {
            this.getMainOrgContext().put((Object)this.getMainBizOrgType(), (Object)orgInfo);
        }
        this.prmtMaterial.setAccessAuthority(0);
        this.btnConfirm.setEnabled(true);
    }

    private HashMap showBomCompareFilterUI() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BomCompareFilterUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        BomCompareFilterUI bomCFUI = (BomCompareFilterUI)uiWindow.getUIObject();
        return (HashMap)bomCFUI.getUIContext().get(FILTER_MAP);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        BomCompareDataProvider data = new BomCompareDataProvider(this.kdtBomList, this.kdtResult);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(MM_BASEDATA_BOM_BOMCOMPARE_PRINT_R1_PRINT, (Object)data, true, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        BomCompareDataProvider data = new BomCompareDataProvider(this.kdtBomList, this.kdtResult);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(MM_BASEDATA_BOM_BOMCOMPARE_PRINT_R1_PRINT, (Object)data, false, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtBomList.checkParsed();
        this.kdtResult.checkParsed();
        HashMap filterMap = this.showBomCompareFilterUI();
        if (filterMap == null) {
            SysUtil.abort();
        } else {
            this.getFilterParamValue(filterMap);
        }
        this.fillBomCompareList(this.filter_kdtBomResultList);
        this.setBomCompareCols(this.filter_bomResultIDs);
        this.prmtMaterial.setAccessAuthority(2);
        this.btnConfirm.setEnabled(false);
        this.setBomCompareResult();
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)filterMap.get("storageOrgUnit");
        if (this.getMainOrgContext() != null) {
            this.getMainOrgContext().put((Object)this.getMainBizOrgType(), (Object)orgInfo);
        }
        this.prmtMaterial.setEditable(false);
        this.prmtMaterial.setAccessAuthority(0);
        this.btnConfirm.setEnabled(true);
    }

    protected void initListener() {
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                StorageOrgUnitInfo orgInfo;
                String cuId = null;
                if (BomCompareUI.this.getMainOrgContext() != null && (orgInfo = (StorageOrgUnitInfo)BomCompareUI.this.getMainOrgContext().get((Object)BomCompareUI.this.getMainBizOrgType())).getCU() != null) {
                    cuId = orgInfo.getCU().getId().toString();
                }
                BomCompareUI.this.setMaterialConstraint(cuId);
            }
        });
        this.prmtMaterial.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                StorageOrgUnitInfo orgInfo;
                String cuId = null;
                if (BomCompareUI.this.getMainOrgContext() != null && (orgInfo = (StorageOrgUnitInfo)BomCompareUI.this.getMainOrgContext().get((Object)BomCompareUI.this.getMainBizOrgType())).getCU() != null) {
                    cuId = orgInfo.getCU().getId().toString();
                }
                BomCompareUI.this.setMaterialConstraint(cuId);
            }
        });
    }

    private void setMaterialConstraint(String cuId) {
        this.prmtMaterial.setValue(null);
        EntityViewInfo mEVI = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.materialIdSet, CompareType.INCLUDE));
        mEVI.setFilter(filterInfo);
        this.prmtMaterial.setEntityViewInfo(mEVI);
        this.prmtMaterial.setFilterInfoProducer(null);
        this.prmtMaterial.getQueryAgent().setDefaultFilterInfo(null);
        this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
    }

    private void setBomCompareResult() throws Exception {
        if (this.filter_queryType == null || this.filter_queryType.trim().length() == 0) {
            return;
        }
        this.kdtResult.removeRows();
        IBomCompareFacade bomCompareFacade = BomCompareFacadeFactory.getRemoteInstance();
        String[] bomIDs = this.filter_bomResultIDs.toArray(new String[0]);
        IRowSet rowSet = null;
        if (this.filter_queryType.equalsIgnoreCase(BomCompareEnum.SingleLevel.getName())) {
            rowSet = bomCompareFacade.getBomSingleCompareResult(bomIDs, (Date)this.filter_queryDate, LocaleUtils.getDefaultLocale().getLanguage(), null);
        } else if (this.filter_queryType.equalsIgnoreCase(BomCompareEnum.MultiLevel.getName())) {
            try {
                rowSet = bomCompareFacade.getBomMultiCompareResult(bomIDs, (Date)this.filter_queryDate, LocaleUtils.getDefaultLocale().getLanguage(), null);
            }
            catch (BOSException e) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"Info_PleaseCheckBOMData"));
                SysUtil.abort();
            }
        }
        this.processResultData(rowSet);
    }

    private void processResultData(IRowSet rowSet) throws SQLException {
        if (rowSet != null) {
            String tempPreMtl = "999999999";
            String tempCrtMtl = "999999999";
            String tempBomID = "999999999";
            String tempPreUnit = "999999999";
            String tempCrtUnit = "999999999";
            IRow row = null;
            int index = 0;
            int precision = 0;
            while (rowSet.next()) {
                tempCrtMtl = rowSet.getString(2);
                if (tempCrtMtl == null) {
                    tempCrtMtl = "999999999";
                }
                if ((tempCrtUnit = rowSet.getString(6)) == null) {
                    tempCrtUnit = "999999999";
                }
                if ((tempBomID = rowSet.getString(1)) == null) {
                    tempBomID = "999999999";
                }
                if ((index = this.filter_bomResultIDs.indexOf(tempBomID)) == -1) continue;
                if (!(!tempPreMtl.equalsIgnoreCase("999999999") && (tempCrtMtl.equalsIgnoreCase("999999999") || tempPreMtl.equalsIgnoreCase("999999999") || tempCrtMtl.equalsIgnoreCase(tempPreMtl) && tempCrtUnit.equalsIgnoreCase(tempPreUnit)))) {
                    row = this.kdtResult.addRow();
                    this.materialIdSet.add(rowSet.getString(2));
                    row.getCell(0).setValue((Object)rowSet.getString(3));
                    row.getCell(1).setValue((Object)rowSet.getString(4));
                    row.getCell(2).setValue((Object)rowSet.getString(5));
                    precision = rowSet.getInt(9);
                    if (rowSet.getBigDecimal(8) != null && row.getCell(3 + index) != null) {
                        row.getCell(3 + index).setValue((Object)this.formatZero(rowSet.getBigDecimal(8).setScale(precision, 4).toString()));
                    }
                    row.getCell("measureUnit").setValue((Object)rowSet.getString(7));
                    row.getCell(IS_SAME).setValue((Object)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"IsSame_YES"));
                } else {
                    precision = rowSet.getInt(9);
                    row.getCell(3 + index).setValue((Object)this.formatZero(rowSet.getBigDecimal(8).setScale(precision, 4).toString()));
                }
                tempPreMtl = rowSet.getString(2);
                if (tempPreMtl == null) {
                    tempPreMtl = "999999999";
                }
                if ((tempPreUnit = rowSet.getString(6)) != null) continue;
                tempPreUnit = "999999999";
            }
        }
        this.setColumnIsSame();
    }

    private void setColumnIsSame() {
        block0: for (int i = 0; i < this.kdtResult.getBody().getRows().size(); ++i) {
            IRow row = this.kdtResult.getRow(i);
            if (row == null) {
                return;
            }
            String preTemp = null;
            String crtTemp = null;
            for (int k = 3; k < 3 + this.filter_bomResultIDs.size(); ++k) {
                crtTemp = (String)row.getCell(k).getValue();
                if (crtTemp == null) {
                    row.getCell(IS_SAME).setValue((Object)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"IsSame_NO"));
                    continue block0;
                }
                if (crtTemp != null && preTemp != null && !crtTemp.equalsIgnoreCase(preTemp)) {
                    row.getCell(IS_SAME).setValue((Object)EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"IsSame_NO"));
                    continue block0;
                }
                preTemp = (String)row.getCell(k).getValue();
            }
        }
    }

    private void getFilterParamValue(HashMap filterMap) {
        this.filter_actionName = (String)filterMap.get("actionName");
        this.filter_bomResultIDs = (ArrayList)filterMap.get("bomResultIDs");
        this.filter_kdtBomResultList = (KDTable)filterMap.get("kdtBomResultList");
        this.filter_queryDate = filterMap.get("queryDate");
        this.filter_queryType = (String)filterMap.get("queryType");
        this.filter_materialIDs = (ArrayList)filterMap.get("materialIDs");
    }

    private void fillBomCompareList(KDTable kdtBomResultList) {
        if (kdtBomResultList != null) {
            this.kdtBomList.removeRows();
            for (int i = 0; i < kdtBomResultList.getRowCount(); ++i) {
                IRow newRow = this.kdtBomList.addRow();
                this.addRow2kdtBomList(kdtBomResultList.getRow(i), newRow);
            }
        }
    }

    private void setBomCompareCols(List bomResultIDs) {
        this.kdtResult.checkParsed(true);
        if (bomResultIDs != null && bomResultIDs.size() > 0) {
            for (int i = 1; i <= 10; ++i) {
                if (i > bomResultIDs.size()) {
                    this.kdtResult.getColumn(BOM_NUM + i).setWidth(0);
                    this.kdtResult.getColumn(BOM_NUM + i).setResizeable(false);
                    this.kdtResult.getColumn(BOM_NUM + i).setRequired(false);
                    this.kdtResult.getColumn(BOM_NUM + i).getStyleAttributes().setHided(true);
                    continue;
                }
                this.kdtResult.getColumn(BOM_NUM + i).setWidth(100);
                this.kdtResult.getColumn(BOM_NUM + i).setRequired(false);
                this.kdtResult.getColumn(BOM_NUM + i).setResizeable(false);
                this.kdtResult.getColumn(BOM_NUM + i).getStyleAttributes().setHided(false);
            }
        }
    }

    private void addRow2kdtBomList(IRow row, IRow newRow) {
        for (int i = 0; i < 10; ++i) {
            if (row.getCell(i).getValue() instanceof BigDecimal) {
                newRow.getCell(i).setValue((Object)this.formatZero(((BigDecimal)row.getCell(i).getValue()).toString()));
                continue;
            }
            newRow.getCell(i).setValue(row.getCell(i).getValue());
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        int count = this.kdtBomList.getBody().getRows().size();
        int resultCount = this.kdtResult.getBody().getRows().size();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotExport"));
            return;
        }
        ArrayList headList = this.kdtBomList.getHead().getRow(0).getCells();
        ArrayList resultHeadList = this.kdtResult.getHead().getRow(0).getCells();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Sheet1");
        int curRowIndex = 0;
        HSSFRow row = null;
        HSSFCell hcell = null;
        HSSFCellStyle style = null;
        HSSFPalette palette = wb.getCustomPalette();
        palette.setColorAtIndex(IndexedColors.BLUE_GREY.index, (byte)-52, (byte)-52, (byte)-1);
        row = sheet.createRow(curRowIndex++);
        row.setHeight((short)300);
        hcell = row.createCell(5);
        hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"BOMCompare")));
        style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
        hcell.setCellStyle(style);
        curRowIndex = this.exportTableTitle2Excel(sheet, curRowIndex, style, EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"BOMList"));
        curRowIndex = this.exportTableHead2Excel(headList, sheet, curRowIndex, style, this.kdtBomList);
        curRowIndex = this.exportTableBody2Excel(count, sheet, curRowIndex, this.kdtBomList);
        row = sheet.createRow(curRowIndex++);
        curRowIndex = this.exportTableTitle2Excel(sheet, curRowIndex, style, EASResource.getString((String)RESOURCEE_BOM_COMPARE, (String)"CompareResult"));
        curRowIndex = this.exportTableHead2Excel(resultHeadList, sheet, curRowIndex, style, this.kdtResult);
        curRowIndex = this.exportTableBody2Excel(resultCount, sheet, curRowIndex, this.kdtResult);
        File tempFile = File.createTempFile("tmp", ".xls");
        FileOutputStream fileOut = new FileOutputStream(tempFile);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        try {
            KDTMenuManager.openFileInExcel((String)tempFile.getPath());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            tempFile.deleteOnExit();
        }
    }

    private int exportTableBody2Excel(int count, HSSFSheet sheet, int curRowIndex, KDTable table) {
        for (int i = 0; i < count; ++i) {
            IRow currentRow = table.getRow(i);
            HSSFRow row = sheet.createRow(curRowIndex++);
            int loop = 0;
            int resultColCount = table.getColumnCount();
            for (int k = 0; k < resultColCount; ++k) {
                if (table.getColumn(k).getStyleAttributes().isHided()) continue;
                HSSFCell hcell = row.createCell((int)((short)loop++));
                if (currentRow.getCell(k).getValue() == null) continue;
                if (currentRow.getCell(k).getValue() instanceof BizEnumValueDTO) {
                    hcell.setCellValue((RichTextString)new HSSFRichTextString(((BizEnumValueDTO)currentRow.getCell(k).getValue()).getAlias()));
                    continue;
                }
                if (currentRow.getCell(k).getValue() instanceof BigDecimal) {
                    hcell.setCellValue((RichTextString)new HSSFRichTextString(((BigDecimal)currentRow.getCell(k).getValue()).toString()));
                    continue;
                }
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)currentRow.getCell(k).getValue()));
            }
        }
        return curRowIndex;
    }

    private int exportTableHead2Excel(List headeadList, HSSFSheet sheet, int curRowIndex, HSSFCellStyle style, KDTable table) {
        int loop = 0;
        HSSFRow row = sheet.createRow(curRowIndex++);
        row.setHeight((short)300);
        int resultListHeadcount = headeadList.size();
        for (int i = 0; i < resultListHeadcount; ++i) {
            if (table.getColumn(i).getStyleAttributes().isHided()) continue;
            HSSFCell hcell = row.createCell((int)((short)loop++));
            if (((KDTCell)headeadList.get(i)).getValue() == null) continue;
            hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)headeadList.get(i)).getValue()));
            hcell.setCellStyle(style);
        }
        return curRowIndex;
    }

    private int exportTableTitle2Excel(HSSFSheet sheet, int curRowIndex, HSSFCellStyle style, String head) {
        HSSFRow row = sheet.createRow(curRowIndex++);
        row.setHeight((short)300);
        HSSFCell hcell = row.createCell(0);
        hcell.setCellValue((RichTextString)new HSSFRichTextString(head));
        hcell.setCellStyle(style);
        return curRowIndex;
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnExport);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.setButtonDefaultStyl(this.btnQuery);
    }

    public void addCommonMenusToTable(KDTable table) {
        if (table == this.kdtResult) {
            return;
        }
        super.addCommonMenusToTable(table);
    }
}

