/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BomCompleteCheckFacadeFactory;
import com.kingdee.eas.mm.basedata.IBomCompleteCheckFacade;
import com.kingdee.eas.mm.basedata.client.AbstractBomCompleteCheckUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;

public class BomCompleteCheckUI
extends AbstractBomCompleteCheckUI {
    private static final long serialVersionUID = -5909856245853334140L;
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";
    private DataChangeListener prmtStorageOrgUnitListener = null;
    private DataChangeListener prmtMaterialListener = null;
    protected F7ContextManager f7Manager = null;
    private static final String COL_STORAGEORGUNIT = "storageOrgUnit";
    private static final String COL_MATERIALID = "materialId";
    private static final String COL_MATERIALNUMBER = "materialNum";
    private static final String COL_MATERIALNAME = "materialName";
    private static final String COL_MODELTYPE = "modelType";
    private static final String COL_MATERIALATTR = "materialArr";
    private static final String COL_ERRMESSAGE = "errMessage";
    private static final String COL_PROJECTID = "projectId";

    private void removeListener() {
        if (this.prmtStorageOrgUnitListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.prmtStorageOrgUnitListener);
        }
        if (this.prmtMaterialListener != null) {
            this.prmtMaterial.removeDataChangeListener(this.prmtMaterialListener);
        }
    }

    private void addListener() {
        if (this.prmtStorageOrgUnitListener == null) {
            this.prmtStorageOrgUnitListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    try {
                        BomCompleteCheckUI.this.prmtStorageOrgUnit_dataChange(event);
                    }
                    catch (Exception e) {
                        BomCompleteCheckUI.this.handUIExceptionAndAbort(e);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.prmtStorageOrgUnitListener);
        if (this.prmtMaterialListener == null) {
            this.prmtMaterialListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    try {
                        BomCompleteCheckUI.this.prmtMaterial_dataChange(event);
                    }
                    catch (Exception e) {
                        BomCompleteCheckUI.this.handUIExceptionAndAbort(e);
                    }
                }
            };
        }
        this.prmtMaterial.addDataChangeListener(this.prmtMaterialListener);
    }

    private void prmtStorageOrgUnit_dataChange(DataChangeEvent event) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)event.getNewValue(), (Object)event.getOldValue());
        if (isDiffrent) {
            this.errBomList.removeRows();
            String orgId = null;
            if (this.prmtStorageOrgUnit.getValue() != null) {
                orgId = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
            }
            String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
            this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, materialPlanQuery, (OrgUnitInfo)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()), OrgType.Storage, true, true);
            EntityViewInfo entityViewInfo = this.prmtMaterial.getEntityViewInfo();
            FilterInfo filterInfo = entityViewInfo.getFilter();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
        }
    }

    private void prmtMaterial_dataChange(DataChangeEvent event) {
        Object[] newValue = (Object[])event.getNewValue();
        Object[] oldValue = (Object[])event.getOldValue();
        boolean isChanged = false;
        if (newValue == null && oldValue != null) {
            isChanged = oldValue.length > 0;
        } else if (newValue != null && oldValue == null) {
            isChanged = newValue.length > 0;
        } else if (newValue != null && oldValue != null) {
            if (newValue.length != oldValue.length) {
                isChanged = true;
            } else {
                int i;
                ArrayList<String> list = new ArrayList<String>();
                for (i = 0; i < newValue.length; ++i) {
                    list.add(((MaterialInfo)newValue[i]).getId().toString());
                }
                for (i = 0; i < oldValue.length; ++i) {
                    if (oldValue[i] == null) {
                        isChanged = true;
                        break;
                    }
                    if (list.contains(((MaterialInfo)oldValue[i]).getId().toString())) continue;
                    isChanged = true;
                    break;
                }
            }
        }
        if (isChanged) {
            if (newValue == null) {
                this.checkboxInclude.setEnabled(false);
                this.checkboxInclude.setSelected(true);
            } else if (newValue.length > 5) {
                MsgBox.showWarning((String)EASResource.getString((String)BOM_RESOURCE_PATH, (String)"bomcheck_materialmax"));
            }
            this.errBomList.removeRows();
        }
    }

    private boolean isExistRow(String materialId, String projectId) {
        boolean ret = false;
        String materialId2 = null;
        String project2 = null;
        String project1 = projectId;
        if (project1 == null) {
            project1 = "999999999";
        }
        for (int i = 0; i < this.errBomList.getRowCount(); ++i) {
            materialId2 = (String)this.errBomList.getRow(i).getCell(COL_MATERIALID).getValue();
            project2 = (String)this.errBomList.getRow(i).getCell(COL_PROJECTID).getValue();
            if (project2 == null) {
                project2 = "999999999";
            }
            if (!materialId.equals(materialId2) || !project1.equals(project2)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void matetialCheckErrBomFillTable(IRowSet errRowSet, StorageOrgUnitInfo storageOrgUnit) throws NumberFormatException, SQLException {
        String projectNumber = null;
        while (errRowSet.next()) {
            String projectId = null;
            projectId = errRowSet.getInt("FISCONFIGABLE") == 1 ? errRowSet.getString("FPROJECTID") : null;
            if (this.isExistRow(errRowSet.getString("FMATERIALID"), projectId)) continue;
            IRow row = this.errBomList.addRow();
            row.getCell(COL_STORAGEORGUNIT).setValue((Object)storageOrgUnit.getName(BomCompleteCheckUI.getDefaultLocale()));
            row.getCell(COL_MATERIALNUMBER).setValue((Object)errRowSet.getString("FMATERIALNUMBER"));
            row.getCell(COL_MATERIALNAME).setValue((Object)errRowSet.getString("FMATERIALNAME"));
            row.getCell(COL_MODELTYPE).setValue((Object)errRowSet.getString("FMATERIALMODEL"));
            String materialArr = MaterialAttributeEnum.getEnum((int)Integer.parseInt(errRowSet.getString("FMATERIALATTR"))).getAlias(BomCompleteCheckUI.getDefaultLocale());
            row.getCell(COL_MATERIALATTR).setValue((Object)materialArr);
            row.getCell(COL_MATERIALID).setValue((Object)errRowSet.getString("FMATERIALID"));
            row.getCell(COL_PROJECTID).setValue((Object)projectId);
            if (errRowSet.getInt("CYCLEFLAG") == 1) {
                row.getCell(COL_ERRMESSAGE).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"completeCheck.errorMessage3", (String[])new String[]{errRowSet.getString("FMATERIALNUMBER") == null ? "" : errRowSet.getString("FMATERIALNUMBER")}));
                continue;
            }
            if (errRowSet.getInt("FISCONFIGABLE") == 0) {
                row.getCell(COL_ERRMESSAGE).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"completeCheck.errorMessage", (String[])new String[]{materialArr, errRowSet.getString("FMATERIALNUMBER") == null ? "" : errRowSet.getString("FMATERIALNUMBER")}));
                continue;
            }
            if (errRowSet.getInt("FISCONFIGABLE") != 1) continue;
            if (errRowSet.getInt("FLAG") == 1) {
                projectNumber = errRowSet.getString("FPROJECTNUMBER");
                if (projectNumber == null) {
                    projectNumber = ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderBomcompleteCheck.null");
                }
                row.getCell(COL_ERRMESSAGE).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"completeCheck.errorMessage2", (String[])new String[]{materialArr, errRowSet.getString("FMATERIALNUMBER") == null ? "" : errRowSet.getString("FMATERIALNUMBER"), projectNumber}));
                continue;
            }
            row.getCell(COL_ERRMESSAGE).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"completeCheck.CfgErrorMessage", (String[])new String[]{materialArr, errRowSet.getString("FMATERIALNUMBER") == null ? "" : errRowSet.getString("FMATERIALNUMBER")}));
        }
    }

    @Override
    public void actionCompleteCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionCompleteCheck_actionPerformed(e);
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)BOM_RESOURCE_PATH, (String)"storageOrgUnit_Required"));
            this.prmtStorageOrgUnit.requestFocus(true);
            SysUtil.abort();
            return;
        }
        this.errBomList.removeRows();
        this.setMessageText(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"completeCheck.checking"));
        this.showMessage();
        IBomCompleteCheckFacade iBomCC = BomCompleteCheckFacadeFactory.getRemoteInstance();
        IRowSet errRowSet = null;
        IRowSet errRowSet2 = null;
        StorageOrgUnitInfo storageOrgUnit = null;
        boolean isMaterialCheck = false;
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            String strStorageOrgUnitId = storageOrgUnit.getId().toString();
            Object[] materials = (Object[])this.prmtMaterial.getValue();
            if (materials != null && materials.length > 0 && materials[0] != null) {
                boolean isIncMultiStorageMaterial = this.checkboxInclude.isSelected();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < materials.length; ++i) {
                    String id = ((MaterialInfo)materials[i]).getId().toString();
                    list.add(id);
                }
                errRowSet = iBomCC.getBomCompleteCheckForMaterials(strStorageOrgUnitId, list, isIncMultiStorageMaterial, this.chbCheckOtherStoragelMaterial.isSelected());
                isMaterialCheck = true;
            } else {
                errRowSet = iBomCC.getBomCompleteCheckList(strStorageOrgUnitId, this.chbCheckOtherStoragelMaterial.isSelected());
                errRowSet2 = iBomCC.getBomCompleteCheckForCfgMaterials(strStorageOrgUnitId, this.chbCheckOtherStoragelMaterial.isSelected());
            }
        }
        this.setMessageText(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"completeCheck.checked"));
        this.showMessage();
        this.errBomList.setColumnMoveable(false);
        if (errRowSet != null) {
            if (isMaterialCheck) {
                this.matetialCheckErrBomFillTable(errRowSet, storageOrgUnit);
            } else {
                this.matetialCheckErrBomFillTable(errRowSet, storageOrgUnit);
                this.matetialCheckErrBomFillTable(errRowSet2, storageOrgUnit);
            }
        }
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_completecheck");
        StorageOrgUnitInfo foi = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_bom_completecheck");
        this.prmtStorageOrgUnit.setValue((Object)foi);
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 0);
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, materialPlanQuery, (OrgUnitInfo)foi, OrgType.Storage, true, true);
        String orgId = null;
        if (this.prmtStorageOrgUnit.getValue() != null) {
            orgId = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        }
        EntityViewInfo entityViewInfo = this.prmtMaterial.getEntityViewInfo();
        FilterInfo filterInfo = entityViewInfo.getFilter();
        FilterInfo mergeFilter = new FilterInfo();
        mergeFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        mergeFilter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)10030, CompareType.EQUALS));
        mergeFilter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)10050, CompareType.EQUALS));
        mergeFilter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)10020, CompareType.EQUALS));
        mergeFilter.setMaskString("#0 and (#1 or #2 or #3)");
        filterInfo.mergeFilter(mergeFilter, "and");
        entityViewInfo.setFilter(filterInfo);
        this.addListener();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public KDTable getTableForCommon() {
        return this.errBomList;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getOnloadPermItemName() {
        return "mm_bom_completecheck";
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.errBomList);
        this.errBomList.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.errBomList);
        this.errBomList.getPrintManager().printPreview();
    }
}

