/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.job.YesOrNoEnum;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.BOMAntiExtendCondition;
import com.kingdee.eas.mm.basedata.BOMAntiExtendLevelEnum;
import com.kingdee.eas.mm.basedata.BOMExtendFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFilterCondition;
import com.kingdee.eas.mm.basedata.BOMSearchBackFlagEnum;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomAntiSearchCondition;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractBomExtendSearchBackListUI;
import com.kingdee.eas.mm.basedata.client.BOMTreeBuilderFactory;
import com.kingdee.eas.mm.basedata.client.BomAntiExtendSearchPrintDataProvider;
import com.kingdee.eas.mm.basedata.client.BomExtendSearchBackQueryUI;
import com.kingdee.eas.mm.basedata.client.BomExtendSearchListUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;

public class BomExtendSearchBackListUI
extends AbstractBomExtendSearchBackListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BomExtendSearchListUI.class);
    private static final String RESOURCE_BOM = "com.kingdee.eas.mm.basedata.BOMResource";
    protected BomExtendSearchBackQueryUI bomExtendSearchBackQueryUI;
    protected CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    private CommonQueryDialog commonQueryDialog;
    BomAntiSearchCondition condition = null;
    protected IMetaDataPK mainQueryPK;
    private boolean showDialogOnLoad = true;
    private String materialNumFrom = null;
    private String materialNumTo = null;
    protected ITreeBuilder treeBuilder;
    private String[] materialGroupIds = null;
    private int qtyPrecision1 = 4;
    private StorageOrgUnitInfo souQuery = null;
    private MaterialInfo miQueryFrom = null;
    private MaterialInfo miQueryTo = null;
    private BOMUsageEnum bueQuery = null;
    private BOMSearchBackFlagEnum queryType = null;
    private Date queryDate = null;
    private List materialIds = new ArrayList();
    private int currentLocation = -1;
    private boolean materialIsConfigable = false;
    private String projectNumIDs = null;
    private static final String[] DTE_DATES = new String[]{"effectiveDate", "disableDate"};
    private static final String[] KDT_DATES = new String[]{"queryDate"};
    private TreeSelectionListener treeSelectionListener;
    private int freezeColIndex = 3;

    public BomExtendSearchBackListUI() throws Exception {
        this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.base.message", (String)"MsgQuery");
        this.kDTreeView1.setShowButton(false);
        this.kDTreeBOM.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    BomExtendSearchBackListUI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    BomExtendSearchBackListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) {
        if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getUserObject() == null) {
            return;
        }
        if (this.getSelectedTreeNode().getUserObject() instanceof MaterialGroupInfo) {
            MaterialGroupInfo treeNode = (MaterialGroupInfo)this.getSelectedTreeNode().getUserObject();
            String[] materialGroupIds = new String[]{treeNode.getId().toString()};
            this.condition.setMaterialGroupIds(materialGroupIds);
            this.condition.setMaterialNumFrom(this.materialNumFrom);
            this.condition.setMaterialNumTo(this.materialNumTo);
            this.loadBomList(this.condition, true);
        } else if (this.getSelectedTreeNode().getLevel() == 0) {
            this.condition.setMaterialNumFrom(this.materialNumFrom);
            this.condition.setMaterialNumTo(this.materialNumTo);
            this.condition.setMaterialGroupIds(this.materialGroupIds);
            this.loadBomList(this.condition, true);
        } else {
            MaterialInfo treeNode = (MaterialInfo)this.getSelectedTreeNode().getUserObject();
            this.condition.setMaterialNumFrom(treeNode.getNumber());
            this.condition.setMaterialNumTo(treeNode.getNumber());
            KDTreeNode parent = (KDTreeNode)this.getSelectedTreeNode().getParent();
            String[] materialGroupIds = new String[]{((MaterialGroupInfo)parent.getUserObject()).getId().toString()};
            this.condition.setMaterialGroupIds(materialGroupIds);
            this.loadBomList(this.condition, true);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.kDTreeBOM.getLastSelectedPathComponent();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanelTop.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 998, 200));
        this.kDPanelRBottom.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 998, 390));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnUpQuery.setIcon(MMUtils.getNewIcon((String)"imgTbtn_topviewbom"));
        this.menuItemQueryUp.setIcon(MMUtils.getNewIcon((String)"imgTbtn_topviewbom"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrintPre);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPre);
        this.setButtonDefaultStyl(this.btnFirst);
        this.setButtonDefaultStyl(this.btnExport);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getUIContext().put("CUInfo", this.currentCtrlUnit);
        this.kDTable1.checkParsed(true);
        this.dtEntry.checkParsed(true);
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
        this.dtEntry.getStyleAttributes().setLocked(true);
        EditTableUtil.formatColDate((KDTable)this.dtEntry, (String[])DTE_DATES);
        EditTableUtil.formatColDate((KDTable)this.kDTable1, (String[])KDT_DATES);
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.dtEntry.getColumn("feture").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("canSelected").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("firstCfg").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("isProjectManu").setEditor((ICellEditor)checkBoxEditor);
        if (this.showDialogOnLoad && !this.showQueryDialog()) {
            SysUtil.abort();
        }
    }

    protected boolean showQueryDialog() {
        try {
            this.initCommonQueryDialog();
            this.bomExtendSearchBackQueryUI.getUIContext().clear();
            this.bomExtendSearchBackQueryUI.getUIContext().putAll(this.getUIContext());
            if (this.commonQueryDialog.show()) {
                Object[] materialGroups;
                this.kDTable1.removeRows();
                this.dtEntry.removeRows();
                BomExtendSearchBackQueryUI potq = (BomExtendSearchBackQueryUI)this.commonQueryDialog.getUserPanel(0);
                this.souQuery = (StorageOrgUnitInfo)potq.prmtStorageOrgUnit.getValue();
                this.miQueryFrom = null != potq.prmtMaterial.getValue() ? (MaterialInfo)potq.prmtMaterial.getValue() : null;
                this.miQueryTo = null != potq.prmtMaterialTo.getValue() ? (MaterialInfo)potq.prmtMaterialTo.getValue() : null;
                this.queryType = (BOMSearchBackFlagEnum)((Object)potq.cmbSearchType.getSelectedItem());
                this.queryDate = (Date)potq.kDDate.getValue();
                this.bueQuery = (BOMUsageEnum)((Object)potq.cmbBomUsage.getSelectedItem());
                this.condition = new BomAntiSearchCondition();
                this.condition.setBomUsage(this.bueQuery);
                this.condition.setFlag(true);
                if (this.miQueryFrom != null) {
                    this.condition.setMaterialNumFrom(this.miQueryFrom.getNumber());
                    this.materialNumFrom = this.miQueryFrom.getNumber();
                }
                if (this.miQueryTo != null) {
                    this.condition.setMaterialNumTo(this.miQueryTo.getNumber());
                    this.materialNumTo = this.miQueryTo.getNumber();
                }
                if ((materialGroups = (Object[])potq.prmtMaterialGroup.getValue()) == null || materialGroups.length == 1 && materialGroups[0] == null) {
                    this.materialGroupIds = null;
                } else if (materialGroups.length > 0) {
                    String[] materialGIds = new String[materialGroups.length];
                    for (int i = 0; i < materialGroups.length; ++i) {
                        MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)materialGroups[i];
                        if (materialGroupInfo == null) continue;
                        materialGIds[i] = materialGroupInfo.getId().toString();
                    }
                    this.condition.setMaterialGroupIds(materialGIds);
                    this.materialGroupIds = materialGIds;
                }
                this.condition.setOnlyAuditStatus(true);
                this.condition.setQueryDate(this.queryDate);
                this.condition.setQueryType(this.queryType);
                this.condition.setOnlyAuditStatus(true);
                this.condition.setStorageOrgUnitID(this.souQuery.getId().toString());
                this.actionUpQuery.setEnabled(false);
                this.actionFirst.setEnabled(false);
                this.actionPre.setEnabled(false);
                Object[] project = null;
                if (null != potq.prmtProjectNumber.getValue()) {
                    Object obj = potq.prmtProjectNumber.getValue();
                    if (obj instanceof ProjectInfo) {
                        project = new Object[]{(ProjectInfo)obj};
                    } else if (obj instanceof ProjectInfo[]) {
                        project = (ProjectInfo[])obj;
                    } else if (obj instanceof Object[]) {
                        project = (Object[])obj;
                    }
                } else {
                    project = null;
                }
                StringBuffer projctStr = new StringBuffer();
                for (int i = 0; project != null && i < project.length && project[0] != null; ++i) {
                    if (i == project.length - 1) {
                        projctStr.append("'" + project[i].getId().toString() + "'");
                        continue;
                    }
                    projctStr.append("'" + project[i].getId().toString() + "',");
                }
                if (project != null && project[0] != null) {
                    this.condition.setProjectNumIDs(projctStr.toString());
                    this.projectNumIDs = projctStr.toString();
                } else {
                    this.condition.setProjectNumIDs(null);
                    this.projectNumIDs = null;
                }
                MaterialInfo materialInfo = (MaterialInfo)potq.prmtMaterial.getValue();
                if (materialInfo != null) {
                    MaterialInfo[] materialInfos = new MaterialInfo[]{materialInfo};
                    SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)this.souQuery, (MaterialInfo[])materialInfos);
                    String key1 = materialInfo.getId().toString() + this.souQuery.getId().toString();
                    MaterialPlanInfo materialPlan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key1);
                    if (materialPlan == null) {
                        this.condition.setBomtype(BOMTypeEnum.MfgBOM);
                    } else {
                        this.materialIsConfigable = materialPlan.isIsConfigable();
                        if (materialPlan.isIsConfigable()) {
                            this.condition.setBomtype(BOMTypeEnum.CfgBOM);
                        } else {
                            this.condition.setBomtype(BOMTypeEnum.MfgBOM);
                        }
                    }
                }
                this.searchResult(this.condition);
                return true;
            }
            return false;
        }
        catch (BomException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)((Object)e));
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handUIException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handUIException(e);
        }
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        Object filterCondition = this.getUIContext().get("BOMExtendSearchFilterCondition");
        if (this.getUIContext().get("IsFromTree") != null && ((Boolean)this.getUIContext().get("IsFromTree")).booleanValue() && this.commonQueryDialog != null && filterCondition != null && filterCondition instanceof BOMExtendSearchFilterCondition) {
            this.commonQueryDialog = null;
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setUiObject((IUIObject)this);
            String classFullName = this.getMetaDataPK().getFullName();
            this.commonQueryDialog.setParentUIClassName(classFullName);
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setTitle(EASResource.getString((String)RESOURCE_BOM, (String)"bomBackSearchWindowTitle"));
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.commonQueryDialog.setShowShareType(16);
            try {
                this.bomExtendSearchBackQueryUI = new BomExtendSearchBackQueryUI();
                this.commonQueryDialog.addUserPanel((KDPanel)this.bomExtendSearchBackQueryUI);
                this.commonQueryDialog.setWidth(580);
                this.commonQueryDialog.setHeight(435);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    private void refreshTable(String topInfo, IRowSet rowSet) {
        try {
            this.fillTableRow(rowSet);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.repaint();
        this.btnQuery.setEnabled(true);
    }

    private String getAlias(Object enumObj, int val) {
        MaterialIssueModeEnum miEnum;
        String name = null;
        if (enumObj.equals(MaterialAttributeEnum.class)) {
            MaterialAttributeEnum maEnum = MaterialAttributeEnum.getEnum((int)val);
            if (maEnum != null) {
                name = maEnum.getAlias();
            }
        } else if (enumObj.equals(ConsumeTypeEnum.class)) {
            ConsumeTypeEnum ctEnum = ConsumeTypeEnum.getEnum(val);
            if (ctEnum != null) {
                name = ctEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialProductEnum.class)) {
            MaterialProductEnum mpEnum = MaterialProductEnum.getEnum((int)val);
            if (mpEnum != null) {
                name = mpEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialCharEnum.class)) {
            MaterialCharEnum mtEnum = MaterialCharEnum.getEnum((int)val);
            if (mtEnum != null) {
                name = mtEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialIssueModeEnum.class) && (miEnum = MaterialIssueModeEnum.getEnum((int)val)) != null) {
            name = miEnum.getAlias();
        }
        return name;
    }

    private void fillTableRow(RowValue rowValue, int levelNo) {
        IRow row = this.dtEntry.addRow();
        row.getCell("model").setValue((Object)rowValue.model);
        row.getCell("unit").setValue((Object)rowValue.unit);
        if ("0".equals(this.queryType.getValue())) {
            row.getCell("parentMaterialNumber").setValue((Object)rowValue.parentMaterialNumber);
            row.getCell("parentMaterialName").setValue((Object)rowValue.parentMaterialName);
            row.getCell("parentProductQty").setValue((Object)this.formatZero(rowValue.parentProductQty));
            row.getCell("yield").setValue((Object)this.formatZero(rowValue.yield));
            String enumName = this.getAlias(ConsumeTypeEnum.class, Integer.parseInt(rowValue.consumeType));
            row.getCell("consumeType").setValue((Object)enumName);
            row.getCell("proportion").setValue((Object)this.formatZero(rowValue.proportion));
            row.getCell("scrapRatio").setValue((Object)this.formatZero(rowValue.scrapRatio));
            row.getCell("effectiveDate").setValue((Object)rowValue.effectiveDate);
            row.getCell("consumeFixQty").setValue((Object)this.formatZero(rowValue.baseQty.toString()));
            row.getCell("disableDate").setValue((Object)rowValue.disableDate);
            enumName = this.getAlias(MaterialAttributeEnum.class, Integer.parseInt(rowValue.materialAttr));
            row.getCell("materialAttr").setValue((Object)enumName);
            enumName = this.getAlias(MaterialProductEnum.class, rowValue.outputType);
            row.getCell("outputType").setValue((Object)enumName);
            enumName = this.getAlias(MaterialCharEnum.class, rowValue.materialChar);
            row.getCell("materialChar").setValue((Object)enumName);
            enumName = this.getAlias(MaterialIssueModeEnum.class, rowValue.issMode);
            row.getCell("issMode").setValue((Object)enumName);
            row.getCell("defaultWarehouseName").setValue((Object)rowValue.defaultWarehouseName);
            row.getCell("bomNumber").setValue((Object)rowValue.bomNumber);
            row.getCell("bomName").setValue((Object)rowValue.bomName);
            enumName = BOMTypeEnum.getEnum(rowValue.bomType).getAlias();
            row.getCell("bomType").setValue((Object)enumName);
            row.getCell("projectNum").setValue((Object)rowValue.projectNum);
            row.getCell("showTrack").setValue((Object)rowValue.showTrack);
            row.getCell("netWeight").setValue((Object)this.formatZero(rowValue.netWeight));
            row.getCell("blkSize").setValue((Object)rowValue.blkSize);
            row.getCell("specifiedLength").setValue((Object)rowValue.specifiedLength);
            row.getCell("usedUnit").setValue((Object)rowValue.usedUnit);
            row.getCell("designUnit").setValue((Object)rowValue.designUnit);
            row.getCell("designRemark").setValue((Object)rowValue.designRemark);
            row.getCell("feture").setValue((Object)Boolean.valueOf(rowValue.feture));
            row.getCell("canSelected").setValue((Object)Boolean.valueOf(rowValue.canSelected));
            row.getCell("firstCfg").setValue((Object)Boolean.valueOf(rowValue.firstCfg));
            row.getCell("blueprint").setValue((Object)rowValue.blueprint);
            row.getCell("pictureNumber").setValue((Object)rowValue.pictureNumber);
            row.getCell("location").setValue((Object)rowValue.location);
            row.getCell("isProjectManu").setValue((Object)Boolean.valueOf(rowValue.isProjectManu));
            row.getCell("bomGroup").setValue((Object)rowValue.bomGroup);
        } else if ("1".equals(this.queryType.getValue())) {
            row.getCell("parentMaterialNumber").setValue((Object)rowValue.parentMaterialNumber);
            row.getCell("parentMaterialName").setValue((Object)rowValue.parentMaterialName);
            row.getCell("parentProductQty").setValue((Object)this.formatZero(rowValue.parentProductQty));
            row.getCell("yield").setValue((Object)this.formatZero(rowValue.yield));
            String enumName = this.getAlias(ConsumeTypeEnum.class, Integer.parseInt(rowValue.consumeType));
            row.getCell("consumeType").setValue((Object)enumName);
            row.getCell("proportion").setValue((Object)this.formatZero(rowValue.proportion));
            row.getCell("scrapRatio").setValue((Object)this.formatZero(rowValue.scrapRatio));
            row.getCell("effectiveDate").setValue((Object)rowValue.effectiveDate);
            row.getCell("consumeFixQty").setValue((Object)this.formatZero(rowValue.baseQty.toString()));
            row.getCell("levelNo").setValue((Object)this.getLevelStr(String.valueOf(levelNo)));
            row.getCell("disableDate").setValue((Object)rowValue.disableDate);
            enumName = this.getAlias(MaterialAttributeEnum.class, Integer.parseInt(rowValue.materialAttr));
            row.getCell("materialAttr").setValue((Object)enumName);
            enumName = this.getAlias(MaterialProductEnum.class, rowValue.outputType);
            row.getCell("outputType").setValue((Object)enumName);
            enumName = this.getAlias(MaterialCharEnum.class, rowValue.materialChar);
            row.getCell("materialChar").setValue((Object)enumName);
            enumName = this.getAlias(MaterialIssueModeEnum.class, rowValue.issMode);
            row.getCell("issMode").setValue((Object)enumName);
            row.getCell("defaultWarehouseName").setValue((Object)rowValue.defaultWarehouseName);
            row.getCell("bomNumber").setValue((Object)rowValue.bomNumber);
            row.getCell("bomName").setValue((Object)rowValue.bomName);
            enumName = BOMTypeEnum.getEnum(rowValue.bomType).getAlias();
            row.getCell("bomType").setValue((Object)enumName);
            row.getCell("bomUsage").setValue((Object)BOMUsageEnum.Master.getAlias());
            row.getCell("blueprint").setValue((Object)rowValue.blueprint);
            row.getCell("projectNum").setValue((Object)rowValue.projectNum);
            row.getCell("showTrack").setValue((Object)rowValue.showTrack);
            row.getCell("netWeight").setValue((Object)this.formatZero(rowValue.netWeight));
            row.getCell("blkSize").setValue((Object)rowValue.blkSize);
            row.getCell("specifiedLength").setValue((Object)rowValue.specifiedLength);
            row.getCell("usedUnit").setValue((Object)rowValue.usedUnit);
            row.getCell("designUnit").setValue((Object)rowValue.designUnit);
            row.getCell("designRemark").setValue((Object)rowValue.designRemark);
            row.getCell("feture").setValue((Object)Boolean.valueOf(rowValue.feture));
            row.getCell("canSelected").setValue((Object)Boolean.valueOf(rowValue.canSelected));
            row.getCell("firstCfg").setValue((Object)Boolean.valueOf(rowValue.firstCfg));
            row.getCell("pictureNumber").setValue((Object)rowValue.pictureNumber);
            row.getCell("location").setValue((Object)rowValue.location);
            row.getCell("isProjectManu").setValue((Object)Boolean.valueOf(rowValue.isProjectManu));
            row.getCell("bomGroup").setValue((Object)rowValue.bomGroup);
        } else if ("2".equals(this.queryType.getValue())) {
            row.getCell("parentMaterialNumber").setValue((Object)rowValue.parentMaterialNumber);
            row.getCell("parentMaterialName").setValue((Object)rowValue.parentMaterialName);
            row.getCell("parentProductQty").setValue((Object)this.formatZero(rowValue.parentProductQty));
            row.getCell("consumeQtyChild").setValue((Object)rowValue.baseQty.setScale(rowValue.qtyPrecision, 4));
            row.getCell("model").setValue((Object)rowValue.model);
            row.getCell("bomUsage").setValue((Object)BOMUsageEnum.Master.getAlias());
            row.getCell("blueprint").setValue((Object)rowValue.blueprint);
        }
    }

    private void processPriorLevelExtend(List bomList) {
        Iterator it = bomList.iterator();
        while (it.hasNext()) {
            this.fillTableRow((RowValue)it.next(), 1);
        }
    }

    private void processBeginLevelExtend(Map bomId2BOMMap, List bomList) {
        Iterator it = bomList.iterator();
        while (it.hasNext()) {
            this.fillTableRow((RowValue)it.next(), 1);
        }
    }

    private void processAllLevelExtend(Map bomId2BOMMap, List bottonList) {
        block20: {
            RowValue top2;
            List[] results;
            block19: {
                ArrayList<RowValue> topList = new ArrayList<RowValue>();
                HashMap<String, RowValue> child2ParentMap = new HashMap<String, RowValue>();
                for (RowValue parent : bomId2BOMMap.values()) {
                    RowValue child = (RowValue)bomId2BOMMap.get(parent.childId);
                    if (child == null) continue;
                    child2ParentMap.put(child.id, parent);
                }
                for (RowValue bom : bomId2BOMMap.values()) {
                    boolean isTop = true;
                    if (child2ParentMap.get(bom.id) != null) {
                        isTop = false;
                    }
                    if (!isTop) continue;
                    topList.add(bom);
                }
                results = new List[topList.size()];
                if (!this.queryType.getValue().equals("0")) {
                    Iterator<Object> it = topList.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        ArrayList<RowValue> oneList;
                        results[i] = oneList = new ArrayList<RowValue>();
                        try {
                            RowValue child;
                            RowValue parent = top2 = (RowValue)((RowValue)it.next()).clone();
                            oneList.add(parent);
                            RowValue orgChild = (RowValue)bomId2BOMMap.get(parent.childId);
                            RowValue rowValue = child = orgChild == null ? null : (RowValue)orgChild.clone();
                            while (child != null) {
                                oneList.add(child);
                                if (this.queryType.getValue().equals("2")) {
                                    if (child.consumeType.equals("20")) {
                                        child.baseQty = new BigDecimal(parent.baseQty.floatValue() * child.baseQty.floatValue() / child.productQty.floatValue());
                                    } else if (child.consumeType.equals("30")) {
                                        child.baseQty = new BigDecimal((double)(parent.baseQty.floatValue() * (child.productQty.floatValue() / child.baseQty.floatValue()) * child.productQty.floatValue()) * 0.01);
                                    }
                                }
                                parent = child;
                                if (parent.childId != null) {
                                    child = (RowValue)((RowValue)bomId2BOMMap.get(parent.childId)).clone();
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (CloneNotSupportedException top2) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                if (!this.queryType.getValue().equals("1")) break block19;
                for (int i = 0; i < results.length; ++i) {
                    for (int j = results[i].size() - 1; j >= 0; --j) {
                        RowValue bom = (RowValue)results[i].get(j);
                        this.fillTableRow(bom, results[i].size() - j);
                    }
                }
                break block20;
            }
            if (!this.queryType.getValue().equals("2")) break block20;
            HashMap<String, RowValue> resultTopMap = new HashMap<String, RowValue>();
            for (int i = 0; i < results.length; ++i) {
                RowValue botton;
                top2 = (RowValue)results[i].get(0);
                if (resultTopMap.containsKey(top2.parentMaterialId)) {
                    botton = (RowValue)results[i].get(results[i].size() - 1);
                    RowValue oldTop = (RowValue)resultTopMap.get(top2.parentMaterialId);
                    oldTop.baseQty = oldTop.baseQty.add(new BigDecimal(botton.baseQty.floatValue()));
                    continue;
                }
                botton = (RowValue)results[i].get(results[i].size() - 1);
                top2.baseQty = botton.baseQty;
                resultTopMap.put(top2.parentMaterialId, top2);
            }
            for (RowValue top3 : resultTopMap.values()) {
                this.fillTableRow(top3, 1);
            }
        }
    }

    private void fillTableRow(IRowSet rowSet) throws SQLException {
        if (rowSet == null || rowSet.size() == 0) {
            return;
        }
        HashMap<String, RowValue> bomId2BOMMap = new HashMap<String, RowValue>();
        ArrayList<RowValue> bottonList = new ArrayList<RowValue>();
        ArrayList<RowValue> topList = new ArrayList<RowValue>();
        while (rowSet.next()) {
            RowValue row = new RowValue();
            if (this.queryType.getValue().equals("0") || this.queryType.getValue().equals("1")) {
                row.model = rowSet.getString("FModel");
                row.unit = rowSet.getString("FParentUnitName");
                row.id = rowSet.getString("fid");
                row.childId = rowSet.getString("fchildid");
                row.parentMaterialNumber = rowSet.getString("FParentMaterialNumber");
                row.parentMaterialName = rowSet.getString("FParentMaterialName");
                row.parentMaterialId = rowSet.getString("FParentMaterialID");
                row.parentProductQty = this.formatZero(rowSet.getString("FPRODUCTQTY"));
                row.childMaterialId = rowSet.getString("FChildMaterialID");
                row.childMaterialNumber = rowSet.getString("FMaterialNumber");
                row.childMaterialName = rowSet.getString("FMaterialName");
                row.baseQty = rowSet.getBigDecimal("FBaseQty");
                row.yield = this.formatZero(rowSet.getString("FYIELD"));
                row.materialAttr = rowSet.getString("FMaterialAttr");
                row.consumeType = rowSet.getString("FConsumeType");
                row.proportion = this.formatZero(rowSet.getString("FProportion"));
                row.scrapRatio = this.formatZero(rowSet.getString("FScrapRatio"));
                row.effectiveDate = rowSet.getString("FEffectiveDate");
                row.disableDate = rowSet.getString("FDisableDate");
                row.outputType = rowSet.getInt("FOutputType");
                row.materialChar = rowSet.getInt("FMaterialChar");
                row.issMode = rowSet.getInt("FIssMode");
                row.defaultWarehouseName = rowSet.getString("FDefaultWarehouseName");
                row.level = rowSet.getString("FLevel");
                row.bomId = rowSet.getString("FBomId");
                row.parentBomId = rowSet.getString("FParentBomId");
                row.bomName = rowSet.getString("FBomName");
                row.bomEntryId = rowSet.getString("FBomEntryID");
                row.scraprateExpression = rowSet.getInt("fscraprateexpression");
                row.productQty = rowSet.getBigDecimal("FProductQty");
                row.bomType = rowSet.getInt("FBomType");
                row.bomNumber = rowSet.getString("Fnumber");
                row.materialAttr = rowSet.getString("fmaterialAttr");
                row.projectNum = rowSet.getString("projectNum");
                row.showTrack = rowSet.getString("showTrack");
                row.netWeight = this.formatZero(rowSet.getString("netWeight"));
                row.blkSize = rowSet.getString("blkSize");
                row.specifiedLength = rowSet.getString("specifiedLength");
                row.usedUnit = rowSet.getString("usedUnit");
                row.designUnit = rowSet.getString("designUnit");
                row.designRemark = rowSet.getString("designRemark");
                row.feture = Boolean.toString(rowSet.getBoolean("feture"));
                row.canSelected = Boolean.toString(rowSet.getBoolean("canSelected"));
                row.firstCfg = Boolean.toString(rowSet.getBoolean("firstCfg"));
                row.bomGroup = rowSet.getString("bomGroup");
                row.isProjectManu = Boolean.toString(rowSet.getBoolean("isProjectManu"));
                row.pictureNumber = rowSet.getString("pictureNumber");
                row.location = rowSet.getString("location");
                row.blueprint = rowSet.getString("Fblueprint");
            } else if (this.queryType.getValue().equals("2")) {
                row.model = rowSet.getString("FModel");
                row.unit = rowSet.getString("FParentUnitname");
                row.parentMaterialNumber = rowSet.getString("FParentMaterialNumber");
                row.parentMaterialName = rowSet.getString("FParentMaterialName");
                row.parentProductQty = this.formatZero(rowSet.getString("FPRODUCTQTY"));
                row.baseQty = rowSet.getBigDecimal("FBaseQty");
                row.qtyPrecision = this.qtyPrecision1;
            }
            if (row.childId == null) {
                bottonList.add(row);
            }
            if (this.queryType.getValue().equals("2")) {
                topList.add(row);
            }
            bomId2BOMMap.put(row.id, row);
        }
        if (this.queryType.getValue().equals("0")) {
            this.processPriorLevelExtend(bottonList);
        } else if (this.queryType.getValue().equals("1")) {
            this.processAllLevelExtend(bomId2BOMMap, bottonList);
        } else {
            this.processBeginLevelExtend(bomId2BOMMap, topList);
        }
    }

    public void searchResult(BomAntiSearchCondition condition) throws BOSException, EASBizException {
        this.setDynamicResultCol(this.queryType, condition);
        this.kDTable1.removeRows();
        this.dtEntry.removeRows();
        IRowSet result = this.loadBomList(condition, true);
        ArrayList<String> longNums = new ArrayList<String>();
        HashMap<String, ArrayList> nodeMap = new HashMap<String, ArrayList>();
        String materialId = null;
        if (null != result) {
            try {
                result.beforeFirst();
                while (null != result && result.next()) {
                    ArrayList collection;
                    String longNum = result.getString("FLongNumber");
                    String number = result.getString("MATERIALNUMBER");
                    String name = result.getString("MATERIALNAME");
                    String model = result.getString("MATERIALMODE");
                    String id = result.getString("MATERIALID");
                    MaterialInfo material = new MaterialInfo();
                    material.setName(number + "(" + name + ")");
                    material.setNumber(number);
                    material.setId(BOSUuid.read((String)id));
                    material.setModel(model);
                    if (!longNums.contains(longNum)) {
                        longNums.add(longNum);
                    }
                    if (nodeMap.containsKey(longNum)) {
                        collection = (ArrayList)nodeMap.get(longNum);
                        collection.add(material);
                    } else {
                        collection = new ArrayList();
                        collection.add(material);
                        nodeMap.put(longNum, collection);
                    }
                    if (materialId != null) continue;
                    materialId = id;
                }
            }
            catch (SQLException e1) {
                this.handUIException(e1);
            }
        }
        if (longNums.size() > 0) {
            condition.setLongNums(longNums.toArray(condition.getLongNums()));
            condition.setNoteMap(nodeMap);
        }
        this.materialIds.clear();
        this.materialIds.add(materialId);
        this.currentLocation = 0;
        if (this.currentLocation == 0) {
            this.actionPre.setEnabled(false);
            this.actionFirst.setEnabled(false);
        } else {
            this.actionPre.setEnabled(true);
            this.actionFirst.setEnabled(true);
        }
        this.actionUpQuery.setEnabled(false);
        try {
            this.initTree(condition);
        }
        catch (Exception e) {
            logger.error((Object)"error:initTree() ", (Throwable)e);
            this.handleException(e);
        }
    }

    public void initTree(BomAntiSearchCondition condition) throws Exception {
        this.kDTreeBOM.setRootVisible(true);
        TreeSelectionListener[] listeners = this.kDTreeBOM.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = this.treeSelectionListener = listeners.length > 0 ? listeners[0] : null;
        if (this.treeSelectionListener != null) {
            this.kDTreeBOM.removeTreeSelectionListener(this.treeSelectionListener);
        }
        FilterInfo tempFilter = this.genarateFilterForTree(condition);
        this.treeBuilder = BOMTreeBuilderFactory.createTreeBuilder(this.getLNTreeNodeCtrl(condition), this.getTreeInitialLevel(), this.getTreeExpandLevel(), tempFilter, this.getSelectorForTree(), condition.getNoteMap());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.kDTreeBOM.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.kDTreeBOM.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.kDTreeBOM);
        if (this.treeSelectionListener != null) {
            this.kDTreeBOM.addTreeSelectionListener(this.treeSelectionListener);
        }
        this.kDTreeBOM.setShowPopMenuDefaultItem(true);
        this.kDTreeBOM.expandOnLevel(2);
        if (((KDTreeNode)((DefaultTreeModel)this.kDTreeBOM.getModel()).getRoot()).getChildCount() > 0) {
            this.kDTreeBOM.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)((DefaultTreeModel)this.kDTreeBOM.getModel()).getRoot()));
        } else {
            ((DefaultTreeModel)this.kDTreeBOM.getModel()).getRoot();
        }
    }

    private FilterInfo genarateFilterForTree(BomAntiSearchCondition condition) {
        FilterInfo tempFilter = this.getDefaultFilterForTree();
        ArrayList longNumSet = new ArrayList();
        if (condition.getLongNums().length > 0) {
            tempFilter = new FilterInfo();
            for (int i = 0; i < condition.getLongNums().length; ++i) {
                String longNumber = condition.getLongNums()[i];
                this.getLongNumSet(longNumSet, longNumber);
            }
        }
        StringBuffer mask = new StringBuffer();
        for (int i = 0; i < longNumSet.size(); ++i) {
            String longNumber = (String)longNumSet.get(i);
            if (tempFilter == null) {
                tempFilter = new FilterInfo();
            }
            tempFilter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)longNumber, CompareType.EQUALS));
            if (i == 0) {
                mask.append("#" + i);
                continue;
            }
            mask.append(" or #" + i);
        }
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.currentCtrlUnit.getId().toString(), (String)this.currentCtrlUnit.getLongNumber());
        if (tempFilter != null) {
            tempFilter.setMaskString(mask.toString());
            try {
                tempFilter.mergeFilter(filterInfoCU, "and");
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        } else {
            tempFilter = filterInfoCU;
        }
        FilterInfo idFilter = new FilterInfo();
        if (condition.getMaterialGroupIds() != null && condition.getMaterialGroupIds().length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < condition.getMaterialGroupIds().length; ++i) {
                idSet.add(condition.getMaterialGroupIds()[i]);
            }
            idFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        try {
            tempFilter.mergeFilter(idFilter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return tempFilter;
    }

    private void getLongNumSet(List longNumSet, String longNumber) {
        if (!longNumSet.contains(longNumber)) {
            longNumSet.add(longNumber);
            int index = longNumber.lastIndexOf("!");
            if (index > 0) {
                longNumber = longNumber.substring(0, index);
                this.getLongNumSet(longNumSet, longNumber);
            }
        }
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl(BomAntiSearchCondition condition) throws Exception {
        DefaultLNTreeNodeCtrl array = new DefaultLNTreeNodeCtrl(this.getTreeInterface());
        return array;
    }

    private IRowSet loadBomList(BomAntiSearchCondition condition, boolean isSelectFirstRow) {
        IRowSet rowSet = null;
        try {
            rowSet = BOMExtendFacadeFactory.getRemoteInstance().getBomAntiList4Query(condition);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (null != rowSet) {
            this.kDTable1.removeRows();
            IRow row = null;
            try {
                while (null != rowSet && rowSet.next()) {
                    row = this.kDTable1.addRow();
                    this.fillupTableRow(row, rowSet);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (isSelectFirstRow) {
            if (this.kDTable1.getRowCount() > 0) {
                this.kDTable1.getSelectManager().select(0, 0, 2);
            } else {
                this.dtEntry.removeRows();
            }
        } else {
            this.dtEntry.removeRows();
        }
        return rowSet;
    }

    private boolean fillupTableRow(IRow row, IRowSet rowSet) {
        boolean flag = true;
        String enumName = null;
        try {
            row.getCell("storageOrgUnitNumber").setValue((Object)rowSet.getString("ORGNAME"));
            row.getCell("queryDate").setValue((Object)this.queryDate);
            row.getCell("searchType").setValue((Object)this.queryType.getAlias());
            row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
            row.getCell("childMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
            row.getCell("childMaterialModel").setValue((Object)rowSet.getString("MATERIALMODE"));
            row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("UNITNAME"));
            enumName = this.getAlias(MaterialAttributeEnum.class, rowSet.getInt("MATERIALATTR"));
            row.getCell("childMaterialAttr").setValue((Object)enumName);
            row.getCell("childMaterialID").setValue((Object)rowSet.getString("MATERIALID"));
        }
        catch (SQLException e) {
            logger.error((Object)"error:fillupTableRow ", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    private void setDynamicResultCol(BOMSearchBackFlagEnum type, BomAntiSearchCondition condition) {
        if (type == BOMSearchBackFlagEnum.S) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else if (type == BOMSearchBackFlagEnum.ManySearch) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else if (this.bueQuery != BOMUsageEnum.Master) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("projectNum").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("pictureNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("location").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("isProjectManu").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("bomGroup").getStyleAttributes().setHided(true);
        }
    }

    private void setColumnByBOMType(BomAntiSearchCondition condition) {
        this.dtEntry.getColumn("projectNum").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("feture").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(false);
    }

    @Override
    public void actionUpQuery_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        ICell cell;
        String materialId;
        super.actionUpQuery_actionPerformed(e);
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (selectedIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            this.actionUpQuery.setEnabled(false);
            SysUtil.abort();
        }
        if (null != (materialId = (String)(cell = (row = this.dtEntry.getRow(selectedIndex)).getCell("parentMaterialId")).getValue())) {
            BomAntiSearchCondition condition = new BomAntiSearchCondition();
            condition.setBomUsage(this.bueQuery);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setOnlyAuditStatus(true);
            this.loadBomList(condition, true);
            this.materialIds.add(materialId);
            ++this.currentLocation;
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
                this.clearMaterials();
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    protected void dtEntry_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.queryType == BOMSearchBackFlagEnum.ManySearch || this.queryType == BOMSearchBackFlagEnum.MutliSraech) {
            return;
        }
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (-1 == selectedIndex) {
            return;
        }
        IRow row = this.dtEntry.getRow(selectedIndex);
        ICell cell = row.getCell("parentMaterialId");
        String materialId = (String)cell.getValue();
        if (null != materialId) {
            this.actionUpQuery.setEnabled(true);
        } else {
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    protected void kDTable1_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int selectedIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow row = this.kDTable1.getRow(selectedIndex);
        ICell cell = row.getCell("childMaterialID");
        String materialId = (String)cell.getValue();
        if (null != materialId) {
            this.loadResultList(materialId);
        }
    }

    private void loadResultList(String materialId) throws Exception {
        this.dtEntry.removeRows();
        BomAntiSearchCondition condition = new BomAntiSearchCondition();
        condition.setQueryType(this.queryType);
        if (this.queryType == BOMSearchBackFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            condition.setQueryType(BOMSearchBackFlagEnum.S);
        }
        condition.setQueryDate(this.queryDate);
        condition.setMaterialID(materialId);
        condition.setProjectNumIDs(this.projectNumIDs);
        condition.setStorageOrgUnitID(this.souQuery.getId().toString());
        condition.setBomUsage(this.bueQuery);
        IRowSet rowSet = null;
        if (condition.getQueryType() == BOMSearchBackFlagEnum.S) {
            try {
                rowSet = BOMExtendFacadeFactory.getRemoteInstance().getAntiResultList4Query(condition);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            String topInfo = BOMExtendSearchFacadeFactory.getRemoteInstance().getBOMTopDataBack(this.souQuery.getId().toString(), materialId, this.queryDate, this.queryType.getValue());
            ArrayList<String> returnFieldList = new ArrayList<String>();
            returnFieldList.add("FMODEL");
            returnFieldList.add("FUnitName");
            returnFieldList.add("FParentUnitName");
            returnFieldList.add("FID");
            returnFieldList.add("FChildID");
            returnFieldList.add("FParentMaterialNumber");
            returnFieldList.add("FParentMaterialName");
            returnFieldList.add("FPARENTMATERIALID");
            returnFieldList.add("FProductQty");
            returnFieldList.add("FCHILDMATERIALID");
            returnFieldList.add("FMaterialNumber");
            returnFieldList.add("FMaterialName");
            returnFieldList.add("FBaseQty");
            returnFieldList.add("FYIELD");
            returnFieldList.add("FMaterialAttr");
            returnFieldList.add("FConsumeType");
            returnFieldList.add("FProportion");
            returnFieldList.add("FScrapRatio");
            returnFieldList.add("FScrapRatio");
            returnFieldList.add("FEffectiveDate");
            returnFieldList.add("FDisableDate");
            returnFieldList.add("FOutputType");
            returnFieldList.add("FMaterialChar");
            returnFieldList.add("FIssMode");
            returnFieldList.add("FDefaultWarehouseName");
            returnFieldList.add("FLevel");
            returnFieldList.add("FBomId");
            returnFieldList.add("FParentBomId");
            returnFieldList.add("FBomName");
            returnFieldList.add("FBomEntryID");
            returnFieldList.add("FScraprateExpression");
            returnFieldList.add("FProductQty");
            returnFieldList.add("FBomType");
            returnFieldList.add("Fnumber");
            returnFieldList.add("Fblueprint");
            String[] returnFields = returnFieldList.toArray(new String[0]);
            if (condition.getQueryType() == BOMSearchBackFlagEnum.ManySearch) {
                BOMAntiExtendCondition condition1 = new BOMAntiExtendCondition();
                condition1.setAntiExtendLevel(BOMAntiExtendLevelEnum.AllLevelExtend);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(false);
                condition1.setReturnFields(returnFields);
                condition1.setMaterialIsConfigable(this.materialIsConfigable);
                condition1.setProjectNumIDs(this.projectNumIDs);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getAntiExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
                }
                catch (BOSException e) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                }
            } else {
                returnFieldList = new ArrayList();
                returnFieldList.add("FMODEL");
                returnFieldList.add("FParentUnitName");
                returnFieldList.add("FParentMaterialNumber");
                returnFieldList.add("FParentMaterialName");
                returnFieldList.add("FProductQty");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFields = returnFieldList.toArray(new String[0]);
                BOMAntiExtendCondition condition1 = new BOMAntiExtendCondition();
                condition1.setAntiExtendLevel(BOMAntiExtendLevelEnum.BeginLevelExtend);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(true);
                condition1.setOnlyExtendConfig(false);
                condition1.setComputeYieldAndScrapRatio(false);
                condition1.setReturnFields(returnFields);
                condition1.setProjectNumIDs(this.projectNumIDs);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getAntiExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
                }
                catch (BOSException e) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                }
            }
            this.refreshTable(topInfo, rowSet);
            return;
        }
        if (null != rowSet) {
            this.dtEntry.removeRows();
            IRow row = null;
            try {
                while (null != rowSet && rowSet.next()) {
                    row = this.dtEntry.addRow();
                    String enumName = null;
                    row.getCell("parentMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
                    row.getCell("parentMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
                    row.getCell("model").setValue((Object)rowSet.getString("MATERIALMODE"));
                    enumName = this.getAlias(MaterialAttributeEnum.class, rowSet.getInt("MATERIALATTR"));
                    row.getCell("materialAttr").setValue((Object)enumName);
                    enumName = this.getAlias(ConsumeTypeEnum.class, rowSet.getInt("CONSUMETYPE"));
                    row.getCell("consumeType").setValue((Object)enumName);
                    row.getCell("consumeFixQty").setValue((Object)this.formatZero(rowSet.getString("CONSUMEFIXQTY")));
                    row.getCell("yield").setValue((Object)this.formatZero(rowSet.getString("YIELD")));
                    row.getCell("proportion").setValue((Object)this.formatZero(rowSet.getString("PROPORTION")));
                    row.getCell("parentProductQty").setValue((Object)this.formatZero(rowSet.getString("PRODUCTQTY")));
                    row.getCell("unit").setValue((Object)rowSet.getString("UNITNAME"));
                    row.getCell("scrapRatio").setValue((Object)this.formatZero(rowSet.getString("SCRAPRATIO")));
                    row.getCell("effectiveDate").setValue((Object)rowSet.getString("EFFECTIVEDATE"));
                    row.getCell("disableDate").setValue((Object)rowSet.getString("DISABLEDATE"));
                    enumName = this.getAlias(MaterialProductEnum.class, rowSet.getInt("OUTPUTTYPE"));
                    row.getCell("outputType").setValue((Object)enumName);
                    enumName = this.getAlias(MaterialCharEnum.class, rowSet.getInt("MATERIALCHAR"));
                    row.getCell("materialChar").setValue((Object)enumName);
                    enumName = this.getAlias(MaterialIssueModeEnum.class, rowSet.getInt("ISSMODE"));
                    row.getCell("issMode").setValue((Object)enumName);
                    row.getCell("defaultWarehouseName").setValue((Object)rowSet.getString("DEFAULTWAREHOUSENAME"));
                    row.getCell("bomNumber").setValue((Object)rowSet.getString("BOMNUMBER"));
                    row.getCell("bomName").setValue((Object)rowSet.getString("BOMNAME"));
                    row.getCell("parentMaterialId").setValue((Object)rowSet.getString("MATERIALID"));
                    enumName = BOMTypeEnum.getEnum(Integer.parseInt(rowSet.getString("BOMTYPE"))).getAlias();
                    row.getCell("bomType").setValue((Object)enumName);
                    enumName = BOMUsageEnum.getEnum(Integer.parseInt(rowSet.getString("BOMUSAGETYPE"))).getAlias();
                    row.getCell("bomUsage").setValue((Object)enumName);
                    row.getCell("projectNum").setValue((Object)rowSet.getString("projectNum"));
                    row.getCell("showTrack").setValue((Object)rowSet.getString("showTrack"));
                    row.getCell("netWeight").setValue((Object)this.formatZero(rowSet.getString("netWeight")));
                    row.getCell("blkSize").setValue((Object)rowSet.getString("blkSize"));
                    row.getCell("specifiedLength").setValue((Object)rowSet.getString("specifiedLength"));
                    row.getCell("usedUnit").setValue((Object)rowSet.getString("usedUnit"));
                    row.getCell("designUnit").setValue((Object)rowSet.getString("designUnit"));
                    row.getCell("designRemark").setValue((Object)rowSet.getString("designRemark"));
                    row.getCell("feture").setValue((Object)rowSet.getBoolean("feture"));
                    row.getCell("canSelected").setValue((Object)rowSet.getBoolean("canSelected"));
                    row.getCell("firstCfg").setValue((Object)rowSet.getBoolean("firstCfg"));
                    row.getCell("bomGroup").setValue((Object)rowSet.getString("bomGroup"));
                    row.getCell("isProjectManu").setValue((Object)rowSet.getBoolean("isProjectManu"));
                    row.getCell("pictureNumber").setValue((Object)rowSet.getString("pictureNumber"));
                    row.getCell("blueprint").setValue((Object)rowSet.getString("blueprint"));
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().containsKey("IsFromTree")) {
            this.getUIContext().put("IsFromTree", Boolean.FALSE);
            this.getUIContext().put("BOMExtendSearchFilterCondition", new BOMExtendSearchFilterCondition());
        }
        this.showQueryDialog();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        int loop = 0;
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotExport"));
            return;
        }
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        IRow bomRow = null;
        KDTHead head = this.kDTable1.getHead();
        ArrayList headList = head.getRow(0).getCells();
        IRow resultRow = null;
        head = this.dtEntry.getHead();
        ArrayList resultHeadList = head.getRow(0).getCells();
        File tempFile = File.createTempFile("tmp", ".xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Sheet1");
        int curRowIndex = 0;
        HSSFRow row = null;
        HSSFCell hcell = null;
        HSSFCellStyle style = null;
        HSSFPalette palette = wb.getCustomPalette();
        palette.setColorAtIndex(IndexedColors.BLUE_GREY.index, (byte)this.kDTable1.getHeadSSA().getBackground().getRed(), (byte)this.kDTable1.getHeadSSA().getBackground().getGreen(), (byte)this.kDTable1.getHeadSSA().getBackground().getBlue());
        row = sheet.createRow(curRowIndex++);
        hcell = row.createCell(5);
        hcell.setCellValue((RichTextString)new HSSFRichTextString(this.queryType.getAlias()));
        style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
        hcell.setCellStyle(style);
        Object obj = null;
        Boolean tmpBoolean = Boolean.FALSE;
        for (int i = 0; i < count; ++i) {
            int k;
            this.kDTable1.getSelectManager().select(i, 0);
            bomRow = this.kDTable1.getRow(i);
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.childMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            int count1 = headList.size();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)headList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = this.kDTable1.getColumnCount();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                if (this.kDTable1.getColumn(k).getKey().equalsIgnoreCase("queryDate")) {
                    if (null != (Date)bomRow.getCell(k).getValue()) {
                        row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString(dtformat.format((Date)bomRow.getCell(k).getValue())));
                        continue;
                    }
                    row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString((String)bomRow.getCell(k).getValue()));
                    continue;
                }
                row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString((String)bomRow.getCell(k).getValue()));
            }
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.parentMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = resultHeadList.size();
            for (k = 0; k < count1; ++k) {
                if (this.dtEntry.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)resultHeadList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            int n = 0;
            int count11 = this.dtEntry.getRowCount();
            for (int j = 0; j < count11; ++j) {
                n = 0;
                row = sheet.createRow(curRowIndex++);
                resultRow = this.dtEntry.getRow(j);
                int count3 = resultHeadList.size();
                for (int m = 0; m < count3; ++m) {
                    if (resultRow.getCell(m).getStyleAttributes().isHided()) continue;
                    if (resultRow.getCell(m).getFormattedValue() != null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(resultRow.getCell(m).getFormattedValue().toString()));
                        continue;
                    }
                    obj = resultRow.getCell(m).getValue();
                    if (obj == null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(""));
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        tmpBoolean = (Boolean)obj;
                        if (tmpBoolean.equals(Boolean.TRUE)) {
                            row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.YES.getAlias());
                            continue;
                        }
                        row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.NO.getAlias());
                        continue;
                    }
                    row.createCell((int)((short)n++)).setCellValue(obj.toString());
                }
            }
            ++curRowIndex;
        }
        FileOutputStream fileOut = new FileOutputStream(tempFile);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        try {
            KDTMenuManager.openFileInExcel((String)tempFile.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempFile.deleteOnExit();
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.currentLocation = 0;
        String materialId = (String)this.materialIds.get(this.currentLocation);
        if (null != materialId) {
            BomAntiSearchCondition condition = new BomAntiSearchCondition();
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setOnlyAuditStatus(true);
            this.loadBomList(condition, true);
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
                this.clearMaterials();
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        --this.currentLocation;
        String materialId = (String)this.materialIds.get(this.currentLocation);
        if (null != materialId) {
            BomAntiSearchCondition condition = new BomAntiSearchCondition();
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setOnlyAuditStatus(true);
            this.loadBomList(condition, true);
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
                this.clearMaterials();
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = null;
        BOMSearchBackFlagEnum tmp = this.queryType;
        if (tmp == BOMSearchBackFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchBackFlagEnum.S;
        }
        BomAntiExtendSearchPrintDataProvider data = new BomAntiExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, false, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = null;
        BOMSearchBackFlagEnum tmp = this.queryType;
        if (tmp == BOMSearchBackFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchBackFlagEnum.S;
        }
        BomAntiExtendSearchPrintDataProvider data = new BomAntiExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, true, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private String getTemplatePath(BOMSearchBackFlagEnum queryType) {
        String templatePath = null;
        templatePath = BOMSearchBackFlagEnum.S == queryType ? "/MM/basedata/BOM/BOMANTIEXTENDSEARCH_SINGLE.r1-print" : (BOMSearchBackFlagEnum.ManySearch == queryType ? "/MM/basedata/BOM/BOMANTIEXTENDSEARCH_MANY.r1-print" : "/MM/basedata/BOM/BOMANTIEXTENDSEARCH_MULTI.r1-print");
        return templatePath;
    }

    private String getLevelStr(String level) {
        if (level.equals("1")) {
            return "*" + level;
        }
        if (level.equals("2")) {
            return "**" + level;
        }
        if (level.equals("3")) {
            return "***" + level;
        }
        if (level.equals("4")) {
            return "****" + level;
        }
        if (level.equals("5")) {
            return "*****" + level;
        }
        if (level.equals("6")) {
            return "******" + level;
        }
        if (level.equals("7")) {
            return "*******" + level;
        }
        return "********" + level;
    }

    private void clearMaterials() {
        if (this.materialIds == null || this.materialIds.size() == 0) {
            return;
        }
        String ids = (String)this.materialIds.get(0);
        this.currentLocation = 0;
        this.materialIds.clear();
        this.materialIds.add(ids);
    }

    protected String getOnloadPermItemName() {
        return "mm_bom_searchBack";
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = MMConstant.BIGDECIMAL_ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }

    private ITreeBase getTreeInterface() throws Exception {
        return MaterialGroupFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
    }

    private String getRootName() {
        String name = EASResource.getString((String)RESOURCE_BOM, (String)"materials");
        return name;
    }

    private Object getRootObject() {
        return this.getRootName();
    }

    private int getTreeInitialLevel() {
        return 1;
    }

    private int getTreeExpandLevel() {
        return 1;
    }

    private FilterInfo getDefaultFilterForTree() {
        return null;
    }

    private SelectorItemCollection getSelectorForTree() {
        return null;
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.dtEntry, (int)this.freezeColIndex);
    }

    class Tree {
        Map resultMap = null;
        List topLevelList = null;

        Tree() {
        }
    }

    class RowValue
    implements Cloneable {
        String id = "";
        String childId = "";
        String parentMaterialId = "";
        String parentMaterialNumber = "";
        String parentMaterialName = "";
        String parentProductQty = "";
        String yield = "";
        String childMaterialNumber = "";
        String childMaterialName = "";
        String childMaterialId = "";
        String model = "";
        String unit = "";
        String materialAttr = "";
        String consumeType = "";
        BigDecimal baseQty = null;
        String proportion = "";
        String scrapRatio = "";
        String effectiveDate = "";
        String disableDate = "";
        int outputType = 0;
        int materialChar = 0;
        int issMode = 0;
        String defaultWarehouseName = "";
        String level = "";
        String bomId = "";
        String parentBomId = "";
        String bomName = "";
        String bomEntryId = "";
        int scraprateExpression = -1;
        BigDecimal productQty = null;
        String bomNumber = "";
        int bomType = 0;
        int qtyPrecision = 4;
        String showTrack = "";
        String netWeight = "";
        String blkSize = "";
        String specifiedLength = "";
        String usedUnit = "";
        String designUnit = "";
        String designRemark = "";
        String feture = "";
        String canSelected = "";
        String firstCfg = "";
        String projectNum = "";
        String pictureNumber = "";
        String location = "";
        String isProjectManu = "";
        String bomGroup = "";
        String blueprint = "";

        RowValue() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

