/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.autoupdate.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFilterCondition;
import com.kingdee.eas.mm.basedata.BOMSearchBackFlagEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.client.AbstractBomExtendSearchBackQueryUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class BomExtendSearchBackQueryUI
extends AbstractBomExtendSearchBackQueryUI {
    private static final long serialVersionUID = 1223465074007266481L;
    private static final String RESOURCE_BOM = "com.kingdee.eas.mm.basedata.BOMResource";
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    private Map materialGMap = null;

    public BomExtendSearchBackQueryUI() throws Exception {
        this.prmtStorageOrgUnit.setRequired(true);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtStorageOrgUnit.setValue(null);
        this.prmtMaterial.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtMaterialGroup.setValue(null);
        this.prmtProjectNumber.setValue(null);
        try {
            if (entityViewInfo != null) {
                this.kDDate.setValue(null);
                FilterInfo filterInfo = entityViewInfo.getFilter();
                if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                    for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                        MaterialInfo material;
                        String materialID;
                        IMaterial factory;
                        FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                        if ("storageOrgUnitID".equals(filterItemInfo.getPropertyName())) {
                            String orgID = filterItemInfo.getCompareValue().toString();
                            orgID = orgID.substring(1, orgID.length() - 1);
                            factory = StorageOrgUnitFactory.getRemoteInstance();
                            StorageOrgUnitInfo org = factory.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
                            this.prmtStorageOrgUnit.setValue((Object)org);
                            continue;
                        }
                        if ("materialIDFrom".equals(filterItemInfo.getPropertyName())) {
                            materialID = filterItemInfo.getCompareValue().toString();
                            factory = MaterialFactory.getRemoteInstance();
                            material = factory.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                            this.prmtMaterial.setValue((Object)material);
                            continue;
                        }
                        if ("materialIDTo".equals(filterItemInfo.getPropertyName())) {
                            materialID = filterItemInfo.getCompareValue().toString();
                            factory = MaterialFactory.getRemoteInstance();
                            material = factory.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                            this.prmtMaterialTo.setValue((Object)material);
                            continue;
                        }
                        if (filterItemInfo.getPropertyName().equals("materialGi")) {
                            if (filterItemInfo.getCompareValue() == null || ((Set)filterItemInfo.getCompareValue()).size() <= 0) continue;
                            this.prmtMaterialGroup.setValue((Object)this.getMaterialGs(((Set)filterItemInfo.getCompareValue()).toArray()));
                            continue;
                        }
                        if ("searchType".equals(filterItemInfo.getPropertyName())) {
                            this.cmbSearchType.removeAllItems();
                            this.cmbSearchType.addItems(BOMSearchBackFlagEnum.getEnumList().toArray());
                            this.cmbSearchType.setSelectedIndex(new Integer(filterItemInfo.getCompareValue().toString()).intValue());
                            continue;
                        }
                        if ("date".equals(filterItemInfo.getPropertyName())) {
                            this.kDDate.setValue(filterItemInfo.getCompareValue());
                            continue;
                        }
                        if ("ProjectId".equals(filterItemInfo.getPropertyName())) {
                            String projectIDs = filterItemInfo.getCompareValue().toString();
                            String[] proID = StringUtil.split((String)projectIDs, (String)";");
                            ArrayList<String> ids = new ArrayList<String>();
                            for (int j = 0; j < proID.length; ++j) {
                                ids.add(proID[j]);
                            }
                            EntityViewInfo evi = new EntityViewInfo();
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
                            evi.setFilter(filter);
                            ProjectCollection project = ProjectFactory.getRemoteInstance().getProjectCollection(evi);
                            this.prmtProjectNumber.setValue((Object)project.toArray());
                            continue;
                        }
                        if (!"usageType".equals(filterItemInfo.getPropertyName())) continue;
                        this.cmbBomUsage.setSelectedIndex(new Integer(filterItemInfo.getCompareValue().toString()).intValue());
                    }
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private Object[] getMaterialGs(Object[] materialGIDs) throws EASBizException, BOSException, UuidException {
        if (this.materialGMap == null) {
            this.materialGMap = new HashMap();
        }
        Object[] materialGs = new Object[materialGIDs.length];
        for (int i = 0; i < materialGIDs.length; ++i) {
            if (this.materialGMap.containsKey(materialGIDs[i])) {
                materialGs[i] = this.materialGMap.get(materialGIDs[i]);
                continue;
            }
            MaterialGroupInfo materialG = MaterialGroupFactory.getRemoteInstance().getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)materialGIDs[i]))));
            if (materialG == null) continue;
            materialGs[i] = materialG;
            this.materialGMap.put(materialG.getId().toString(), materialG);
        }
        return materialGs;
    }

    public FilterInfo getFilterInfo() {
        SysContext.getSysContext().getCurrentCtrlUnit();
        this.filterInfo.getFilterItems().clear();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            StringBuffer ids = new StringBuffer();
            StringBuffer numbers = new StringBuffer();
            StringBuffer names = new StringBuffer();
            if (this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo) {
                ids.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
                numbers.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getNumber());
                names.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getName());
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString()));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString(), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)names.toString(), CompareType.INCLUDE));
            } else if (this.prmtStorageOrgUnit.getValue() instanceof LinkedHashSet) {
                LinkedHashSet set = (LinkedHashSet)this.prmtStorageOrgUnit.getValue();
                for (String id : set) {
                    ids.append(id + ";");
                }
            } else if (this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
                Object[] storages = (Object[])this.prmtStorageOrgUnit.getValue();
                if (storages.length > 0) {
                    for (int i = 0; i < storages.length; ++i) {
                        ids.append(((StorageOrgUnitInfo)storages[i]).getId() + ";");
                        numbers.append(((StorageOrgUnitInfo)storages[i]).getNumber() + ";");
                    }
                }
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)numbers.toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString(), CompareType.EQUALS));
            }
        }
        if (this.prmtMaterial.getValue() != null && this.prmtMaterial.getText() != null && this.prmtMaterial.getText().length() > 0) {
            if (this.prmtMaterial.getValue() instanceof MaterialInfo) {
                itemCollection.add(new FilterItemInfo("materialIDFrom", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("materialNumberFrom", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getNumber().toString()));
            } else if (this.prmtMaterial.getValue() instanceof LinkedHashSet) {
                for (String id : (LinkedHashSet)this.prmtMaterial.getValue()) {
                    itemCollection.add(new FilterItemInfo("materialIDFrom", (Object)id, CompareType.EQUALS));
                }
            }
        }
        if (this.prmtMaterialTo.getValue() != null && this.prmtMaterialTo.getText() != null && this.prmtMaterialTo.getText().length() > 0) {
            if (this.prmtMaterialTo.getValue() instanceof MaterialInfo) {
                itemCollection.add(new FilterItemInfo("materialIDTo", (Object)((MaterialInfo)this.prmtMaterialTo.getValue()).getId().toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("materialNumberTo", (Object)((MaterialInfo)this.prmtMaterialTo.getValue()).getNumber().toString()));
            } else if (this.prmtMaterialTo.getValue() instanceof LinkedHashSet) {
                for (String id : (LinkedHashSet)this.prmtMaterialTo.getValue()) {
                    itemCollection.add(new FilterItemInfo("materialIDTo", (Object)id, CompareType.EQUALS));
                }
            }
        }
        if (this.prmtMaterialGroup.getValue() != null && this.prmtMaterialGroup.getText() != null && this.prmtMaterialGroup.getText().length() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ((Object[])this.prmtMaterialGroup.getValue()).length; ++i) {
                MaterialGroupInfo materialGi = (MaterialGroupInfo)((Object[])this.prmtMaterialGroup.getValue())[i];
                set.add(materialGi.getId().toString());
            }
            itemCollection.add(new FilterItemInfo("materialGi", set, CompareType.INCLUDE));
        }
        if (this.prmtProjectNumber.getValue() != null && this.prmtProjectNumber.getText() != null && this.prmtProjectNumber.getText().length() > 0) {
            if (this.prmtProjectNumber.getValue() instanceof ProjectInfo) {
                itemCollection.add(new FilterItemInfo("ProjectId", (Object)((ProjectInfo)this.prmtProjectNumber.getValue()).getId().toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("ProjectNumber", (Object)((ProjectInfo)this.prmtProjectNumber.getValue()).getNumber().toString()));
            } else if (this.prmtProjectNumber.getValue() instanceof LinkedHashSet) {
                for (String id : (LinkedHashSet)this.prmtProjectNumber.getValue()) {
                    itemCollection.add(new FilterItemInfo("ProjectId", (Object)id, CompareType.EQUALS));
                }
            } else if (this.prmtProjectNumber.getValue() instanceof Object[]) {
                Object[] bg = (Object[])this.prmtProjectNumber.getValue();
                StringBuffer projectIDs = new StringBuffer();
                for (int i = 0; i < bg.length; ++i) {
                    projectIDs.append(((ProjectInfo)bg[i]).getId().toString()).append(";");
                }
                itemCollection.add(new FilterItemInfo("ProjectId", (Object)projectIDs.toString(), CompareType.EQUALS));
            }
        }
        if (this.kDDate.getValue() != null) {
            itemCollection.add(new FilterItemInfo("date", (Object)new Timestamp(((Date)this.kDDate.getValue()).getTime()), CompareType.EQUALS));
        }
        if (this.cmbSearchType.getSelectedIndex() >= 0) {
            itemCollection.add(new FilterItemInfo("searchType", (Object)new Integer(this.cmbSearchType.getSelectedIndex())));
        }
        if (this.cmbBomUsage.getSelectedIndex() >= 0) {
            itemCollection.add(new FilterItemInfo("usageType", (Object)new Integer(this.cmbBomUsage.getSelectedIndex())));
        }
        return this.filterInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_searchBack");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_bom_searchBack");
        if (orgInfo == null) {
            this.initF7(orgInfo);
            return;
        }
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.prmtStorageOrgUnit.setRequired(true);
        this.cmbSearchType.setRequired(true);
        this.initF7(orgInfo);
        this.initBomUsage(false);
        String order = (String)this.getUIContext().get("orderBomExtendBack");
        if (order != null && "1".equals(order)) {
            this.initOrderUIContentLayout();
        }
        this.prmtProjectNumber.setEnabledMultiSelection(true);
        this.kDLabelContainer6.setVisible(true);
        this.prmtMaterial.setRequired(true);
        this.prmtMaterialTo.setRequired(true);
        MMUtils.filterRangF7Helper((Component)this.prmtMaterial, (Component)this.prmtMaterialTo);
    }

    private void initMaterialGroup() {
        CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuId = currentCtrlUnit.getId().toString();
        String longNumber = currentCtrlUnit.getLongNumber();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cuId, (String)longNumber);
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filterInfoCU);
        this.prmtMaterialGroup.setEntityViewInfo(entityView);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        Map map;
        StringBuffer msg = new StringBuffer();
        if (this.prmtStorageOrgUnit.getText() == null || this.prmtStorageOrgUnit.getText().trim().length() == 0) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"storageOrgUnit_Required"));
        } else if (this.prmtStorageOrgUnit.getValue() == null) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"storageOrgUnit_CodeError"));
        }
        if (this.prmtMaterial.getValue() == null && this.prmtMaterialTo.getValue() == null) {
            this.ensureChangeLine(msg, EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BasedataResource", (String)"PLC_Msg_Material_Not_Null"));
        }
        if ((map = this.getUIContext()).get("orderBomExtendBack") != null && "1".equals(map.get("orderBomExtendBack").toString()) && this.prmtProjectNumber.getValue() == null && this.prmtTrackNumber.getValue() == null) {
            msg.append(ResourceUtils.getMessage((String)RESOURCE_BOM, (String)"pt_notnull"));
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            return false;
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_searchBack");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_bom_searchBack");
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.kDDate.setValue((Object)new Date());
        this.cmbSearchType.setSelectedIndex(0);
        this.prmtMaterial.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtProjectNumber.setValue(null);
        this.prmtProjectNumber.setValue(null);
        this.prmtMaterialGroup.setValue(null);
        this.cmbBomUsage.setSelectedItem((Object)BOMUsageEnum.Master);
    }

    private void ensureChangeLine(StringBuffer msg, String info) {
        if (msg.length() > 0) {
            msg.append("\n\r");
        }
        msg.append(info);
    }

    private void initF7(StorageOrgUnitInfo orgInfo) {
        this.initMaterialGroup();
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterialTo, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        FilterInfo filterInfo = new FilterInfo();
        if (orgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
        }
        if (this.prmtMaterialGroup.getValue() != null) {
            Object[] materialGroups = (Object[])this.prmtMaterialGroup.getValue();
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < materialGroups.length; ++i) {
                MaterialGroupInfo mgi = (MaterialGroupInfo)materialGroups[i];
                if (mgi == null) continue;
                set.add(mgi.getId().toString());
            }
            if (set.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.id", set, CompareType.INCLUDE));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filterInfo);
        this.prmtMaterial.setEntityViewInfo(entityView);
        this.prmtMaterialTo.setEntityViewInfo(entityView);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNumber);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumber);
    }

    @Override
    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            this.initF7((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        } else if (newObject == null) {
            this.initF7(null);
        }
        this.prmtMaterial.setValue(null);
        this.prmtMaterialTo.setValue(null);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected void cmbBomUsage_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 2) {
            int i;
            int count;
            BOMUsageEnum usageEnum = (BOMUsageEnum)((Object)e.getItem());
            ItemListener[] listener = this.cmbSearchType.getItemListeners();
            if (null != listener) {
                count = listener.length;
                for (i = 0; i < count; ++i) {
                    this.cmbSearchType.removeItemListener(listener[i]);
                }
            }
            this.cmbSearchType.removeAllItems();
            this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.S);
            if (usageEnum == BOMUsageEnum.Master) {
                this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.ManySearch);
                this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.MutliSraech);
            }
            if (null != listener) {
                count = listener.length;
                for (i = 0; i < count; ++i) {
                    this.cmbSearchType.addItemListener(listener[i]);
                }
            }
        }
    }

    @Override
    protected void cmbSearchType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 2) {
            BOMSearchBackFlagEnum searchTypeEnum = (BOMSearchBackFlagEnum)((Object)e.getItem());
            if (searchTypeEnum == BOMSearchBackFlagEnum.ManySearch) {
                this.initBomUsage(true);
            } else if (searchTypeEnum == BOMSearchBackFlagEnum.MutliSraech) {
                this.initBomUsage(true);
            } else {
                this.initBomUsage(false);
            }
        }
    }

    private void initBomUsage(boolean onlyMasterBom) {
        int i;
        int count;
        ItemListener[] listener = this.cmbBomUsage.getItemListeners();
        BOMUsageEnum pre = (BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem());
        if (null != listener) {
            count = listener.length;
            for (i = 0; i < count; ++i) {
                this.cmbBomUsage.removeItemListener(listener[i]);
            }
        }
        this.cmbBomUsage.removeAllItems();
        this.cmbBomUsage.addItem((Object)BOMUsageEnum.Master);
        if (!onlyMasterBom) {
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.Other);
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.BackingOut);
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.maintaining);
        }
        this.cmbBomUsage.setSelectedItem((Object)pre);
        if (null != listener) {
            count = listener.length;
            for (i = 0; i < count; ++i) {
                this.cmbBomUsage.addItemListener(listener[i]);
            }
        }
    }

    public void initOrderUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 580, 261));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 580, 261));
        this.kDLabelContainer1.setBounds(new Rectangle(10, 10, 270, 19));
        this.add((Component)this.kDLabelContainer1, new KDLayout.Constraints(10, 10, 270, 19, 0));
        this.kDLabelContainer2.setBounds(new Rectangle(301, 10, 270, 19));
        this.add((Component)this.kDLabelContainer2, new KDLayout.Constraints(301, 10, 270, 19, 0));
        this.kDLabelContainer3.setBounds(new Rectangle(301, 54, 270, 19));
        this.add((Component)this.kDLabelContainer3, new KDLayout.Constraints(301, 54, 270, 19, 0));
        this.kDLabelContainer4.setBounds(new Rectangle(10, 78, 270, 19));
        this.add((Component)this.kDLabelContainer4, new KDLayout.Constraints(10, 78, 270, 19, 0));
        this.kDLabelContainer5.setBounds(new Rectangle(10, 54, 270, 19));
        this.add((Component)this.kDLabelContainer5, new KDLayout.Constraints(10, 54, 270, 19, 0));
        this.kDLabelContainer6.setBounds(new Rectangle(10, 32, 270, 19));
        this.add((Component)this.kDLabelContainer6, new KDLayout.Constraints(10, 32, 270, 19, 0));
        this.kDLabelContainer7.setBounds(new Rectangle(301, 32, 270, 19));
        this.add((Component)this.kDLabelContainer7, new KDLayout.Constraints(301, 32, 270, 19, 0));
        this.kDLabelContainer1.setBoundEditor((JComponent)this.prmtStorageOrgUnit);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.prmtMaterial);
        this.kDLabelContainer3.setBoundEditor((JComponent)this.kDDate);
        this.kDLabelContainer4.setBoundEditor((JComponent)this.cmbSearchType);
        this.kDLabelContainer5.setBoundEditor((JComponent)this.cmbBomUsage);
        this.kDLabelContainer6.setBoundEditor((JComponent)this.prmtProjectNumber);
        this.kDLabelContainer7.setBoundEditor((JComponent)this.prmtTrackNumber);
        this.kDLabelContainer8.setBoundEditor((JComponent)this.prmtMaterialTo);
    }

    public void show() {
        if (this.getUIContext().get("IsFromTree") != null && ((Boolean)this.getUIContext().get("IsFromTree")).booleanValue()) {
            int i;
            Object filterCondition;
            ItemListener[] bomUsageListener;
            int i2;
            int count;
            DataChangeListener[] souListener = (DataChangeListener[])this.prmtStorageOrgUnit.getListeners(DataChangeListener.class);
            if (null != souListener) {
                int count2 = souListener.length;
                for (int i3 = 0; i3 < count2; ++i3) {
                    this.prmtStorageOrgUnit.removeDataChangeListener(souListener[i3]);
                }
            }
            DataChangeListener[] materiallistenerFrom = (DataChangeListener[])this.prmtMaterial.getListeners(DataChangeListener.class);
            DataChangeListener[] materiallistenerTo = (DataChangeListener[])this.prmtMaterialTo.getListeners(DataChangeListener.class);
            if (null != materiallistenerFrom) {
                count = materiallistenerFrom.length;
                for (i2 = 0; i2 < count; ++i2) {
                    this.prmtMaterial.removeDataChangeListener(materiallistenerFrom[i2]);
                }
            }
            if (null != materiallistenerTo) {
                count = materiallistenerTo.length;
                for (i2 = 0; i2 < count; ++i2) {
                    this.prmtMaterialTo.removeDataChangeListener(materiallistenerTo[i2]);
                }
            }
            if (null != (bomUsageListener = (ItemListener[])this.cmbBomUsage.getListeners(ItemListener.class))) {
                int count3 = bomUsageListener.length;
                for (int i4 = 0; i4 < count3; ++i4) {
                    this.cmbBomUsage.removeItemListener(bomUsageListener[i4]);
                }
            }
            if ((filterCondition = this.getUIContext().get("BOMExtendSearchFilterCondition")) != null && filterCondition instanceof BOMExtendSearchFilterCondition) {
                BOMExtendSearchFilterCondition condition = (BOMExtendSearchFilterCondition)filterCondition;
                BomInfo bomInfo = condition.getBomInfo();
                MaterialInfo material = bomInfo.getMaterial();
                String materialNumber = null;
                if (material != null) {
                    materialNumber = material.getNumber();
                }
                StorageOrgUnitInfo orgUnit = condition.getOrgInfo();
                String orgUnitNumber = null;
                if (orgUnit != null) {
                    orgUnitNumber = orgUnit.getNumber();
                }
                this.prmtStorageOrgUnit.setValue((Object)orgUnit);
                this.initF7(orgUnit);
                this.prmtMaterial.setValue((Object)condition.getBomInfo().getMaterial());
                this.prmtMaterialTo.setValue((Object)condition.getBomInfo().getMaterial());
                this.prmtProjectNumber.setValue((Object)condition.getBomInfo().getProject());
                this.cmbBomUsage.setSelectedItem((Object)condition.getBomUsage());
                this.cmbSearchType.removeAllItems();
                this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.S);
                if (this.cmbBomUsage.getSelectedItem() == BOMUsageEnum.Master) {
                    this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.ManySearch);
                    this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.MutliSraech);
                }
                this.prmtStorageOrgUnit.setText(orgUnitNumber);
                this.prmtMaterial.setText(materialNumber);
                this.prmtMaterialTo.setText(materialNumber);
            }
            if (null != souListener) {
                int count4 = souListener.length;
                for (i = 0; i < count4; ++i) {
                    this.prmtStorageOrgUnit.addDataChangeListener(souListener[i]);
                }
            }
            if (null != materiallistenerFrom) {
                int count5 = materiallistenerFrom.length;
                for (i = 0; i < count5; ++i) {
                    this.prmtMaterial.addDataChangeListener(materiallistenerFrom[i]);
                }
            }
            if (null != materiallistenerTo) {
                int count6 = materiallistenerTo.length;
                for (i = 0; i < count6; ++i) {
                    this.prmtMaterialTo.addDataChangeListener(materiallistenerTo[i]);
                }
            }
            if (null != bomUsageListener) {
                int count7 = bomUsageListener.length;
                for (i = 0; i < count7; ++i) {
                    this.cmbBomUsage.addItemListener(bomUsageListener[i]);
                }
            }
        }
        super.show();
    }
}

