/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.BOMExtendCondition;
import com.kingdee.eas.mm.basedata.BOMExtendFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMExtendLevelEnum;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFilterCondition;
import com.kingdee.eas.mm.basedata.BOMSearchFlagEnum;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomGroupstandardFactory;
import com.kingdee.eas.mm.basedata.BomGroupstandardInfo;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.BomTreeCondition;
import com.kingdee.eas.mm.basedata.BomTreeInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractBomExtendSearchListUI;
import com.kingdee.eas.mm.basedata.client.BOMTreeBuilderFactory;
import com.kingdee.eas.mm.basedata.client.BomExtendSearchPrintDataProvider;
import com.kingdee.eas.mm.basedata.client.BomExtendSearchQueryUI;
import com.kingdee.eas.mm.basedata.client.LNBom4QueryTreeNodeCtrl;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.YesOrNoEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;

public class BomExtendSearchListUI
extends AbstractBomExtendSearchListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BomExtendSearchListUI.class);
    private static final String RESOURCE_BOM = "com.kingdee.eas.mm.basedata.BOMResource";
    protected BomExtendSearchQueryUI bomExtendSearchQueryUi;
    private CommonQueryDialog commonQueryDialog;
    protected IMetaDataPK mainQueryPK;
    private boolean showDialogOnLoad = true;
    private static final BigDecimal ZERO = new BigDecimal("0");
    protected ITreeBuilder treeBuilder;
    private BomTreeInfo sourceTreeNode = null;
    private StorageOrgUnitInfo souQuery = null;
    private MaterialInfo[] miQuery = null;
    private Object[] bgQuery = null;
    private String bomNumberQuery = null;
    private BOMUsageEnum bueQuery = null;
    private BOMSearchFlagEnum queryType = null;
    private BOMTypeEnum bomType = null;
    private Date queryDate = null;
    private String projectNumber = null;
    private Set projectIdSet = null;
    private String pjQuery = null;
    private String pjNumber = "";
    private String tkQuery = null;
    private String tkNumber = "";
    private boolean orderQuery = false;
    private ProjectInfo pinfo = null;
    private TrackNumberInfo tinfo = null;
    private List materialIds = new ArrayList();
    private List projectList = new ArrayList();
    private List bomIDs = new ArrayList();
    private int currentLocation = -1;
    private boolean materialIsConfigable = false;
    private static final String[] DTE_DATES = new String[]{"effectiveDate", "disableDate"};
    private static final String[] KDT_DATES = new String[]{"queryDate"};
    private TreeSelectionListener treeSelectionListener;
    private int freezeColIndex = 5;

    public BomExtendSearchListUI() throws Exception {
        this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.mm.basedata.app", (String)"BOMExtendFilterQuery");
        this.kDTreeView1.setShowButton(false);
        this.kDTreeBOM.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    BomExtendSearchListUI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    BomExtendSearchListUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanelRTop.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 746, 200));
        this.kDPanelRBottom.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 746, 368));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDownQuery.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_downviewbom", (Locale)this.getLocale()));
        this.menuItemQueryDown.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_downviewbom", (Locale)this.getLocale()));
        this.menuItemPrintPre.setEnabled(true);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrintPre);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPre);
        this.setButtonDefaultStyl(this.btnFirst);
        this.setButtonDefaultStyl(this.btnExport);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) {
        TreePath treePath = e.getNewLeadSelectionPath();
        if (treePath == null) {
            return;
        }
        KDTreeNode treeNode = (KDTreeNode)treePath.getLastPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            boolean expendFlag = true;
            if (treeNode.getUserObject() instanceof BomGroupstandardInfo) {
                return;
            }
            this.sourceTreeNode = (BomTreeInfo)treeNode.getUserObject();
            String bomId = "";
            bomId = this.sourceTreeNode.getBomID();
            if (null == bomId || "".equals(bomId.trim())) {
                expendFlag = false;
                this.kDTable1.removeRows();
                this.dtEntry.removeRows();
            } else {
                BomTreeCondition condition = new BomTreeCondition();
                condition.setBomID(bomId);
                condition.setBomUsage(this.bueQuery);
                condition.setFlag(true);
                condition.setMaterialID(this.sourceTreeNode.getMaterialInfo().getId().toString());
                condition.setOnlyAuditStatus(true);
                condition.setQueryDate(this.queryDate);
                condition.setQueryType(this.queryType);
                condition.setStorageOrgUnitID(this.souQuery.getId().toString());
                if (this.sourceTreeNode.getProject() != null) {
                    String projectId = this.sourceTreeNode.getProject().getId().toString();
                    condition.setProjectNumIDs("'" + projectId + "'");
                    HashSet<String> projectSet = new HashSet<String>();
                    projectSet.add(projectId);
                    condition.setProjectIdSet(projectSet);
                } else {
                    condition.setProjectNumIDs(null);
                    condition.setProjectIdSet(null);
                }
                condition.setBomtype(this.sourceTreeNode.getBomType());
                condition.setOnlyAuditStatus(true);
                this.loadBomList(condition, true);
            }
            if (expendFlag) {
                try {
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                    logger.error((Object)"error treeMain_valueChanged: get expend result", (Throwable)e1);
                }
            }
            this.kDTreeBOM.expandAllNodes(true, (TreeNode)treeNode);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed(true);
        this.dtEntry.checkParsed(true);
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
        String numberFormatString = CtrlFormatUtilities.getDecimalFormatString();
        this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("proportion").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setNumberFormat(numberFormatString);
        this.kDTable1.getColumn("productQty").getStyleAttributes().setNumberFormat(numberFormatString);
        EditTableUtil.formatColDate((KDTable)this.dtEntry, (String[])DTE_DATES);
        EditTableUtil.formatColDate((KDTable)this.kDTable1, (String[])KDT_DATES);
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.dtEntry.getColumn("feture").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("canSelected").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("firstCfg").setEditor((ICellEditor)checkBoxEditor);
        this.kDTable1.getColumn("isProjectManu").setEditor((ICellEditor)checkBoxEditor);
        String strParam = (String)this.getUIContext().get("UIClassParam");
        if (strParam != null && strParam.equals("1")) {
            this.kDTable1.getColumn("trackNumber").getStyleAttributes().setHided(false);
            this.setUITitle(EASResource.getString((String)RESOURCE_BOM, (String)"orderbom_title"));
        }
        if (this.showDialogOnLoad && !this.showQueryDialog()) {
            SysUtil.abort();
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().containsKey("IsFromTree")) {
            this.getUIContext().put("IsFromTree", Boolean.FALSE);
            this.getUIContext().put("BOMExtendSearchFilterCondition", new BOMExtendSearchFilterCondition());
        }
        this.showQueryDialog();
    }

    protected boolean showQueryDialog() {
        try {
            this.initCommonQueryDialog();
            this.bomExtendSearchQueryUi.getUIContext().clear();
            this.bomExtendSearchQueryUi.getUIContext().putAll(this.getUIContext());
            if (this.commonQueryDialog.show()) {
                this.kDTable1.removeRows();
                this.dtEntry.removeRows();
                BomExtendSearchQueryUI potq = (BomExtendSearchQueryUI)this.commonQueryDialog.getUserPanel(0);
                FilterInfo commonFI = this.commonQueryDialog.getCommonFilter();
                this.souQuery = (StorageOrgUnitInfo)potq.prmtStorageOrgUnit.getValue();
                this.miQuery = null != potq.prmtMaterial.getValue() ? (MaterialInfo[])potq.prmtMaterial.getValue() : null;
                this.bgQuery = null != potq.prmtBomGroup.getValue() ? (Object[])potq.prmtBomGroup.getValue() : null;
                this.bueQuery = (BOMUsageEnum)((Object)potq.cmbBomUsage.getSelectedItem());
                this.bomNumberQuery = null != potq.prmtBom.getValue() ? ((BomInfo)potq.prmtBom.getValue()).getId().toString() : null;
                this.queryType = (BOMSearchFlagEnum)((Object)potq.cmbSearchType.getSelectedItem());
                this.queryDate = (Date)potq.kDDate.getValue();
                Object[] project = null != potq.prmtProjectNumber.getValue() ? (Object[])potq.prmtProjectNumber.getValue() : null;
                BomTreeCondition condition = new BomTreeCondition();
                condition.setBomID(this.bomNumberQuery);
                condition.setBomUsage(this.bueQuery);
                condition.setFlag(true);
                StringBuffer materialStr = new StringBuffer();
                HashSet<String> materialIdSet = new HashSet<String>();
                materialStr.append("(");
                if (this.miQuery != null) {
                    for (int i = 0; i < this.miQuery.length; ++i) {
                        materialIdSet.add(this.miQuery[i].getId().toString());
                        if (i == this.miQuery.length - 1) {
                            materialStr.append("'" + this.miQuery[i].getId().toString() + "'");
                            continue;
                        }
                        materialStr.append("'" + this.miQuery[i].getId().toString() + "',");
                    }
                }
                materialStr.append(")");
                StringBuffer bomGroupStr = new StringBuffer();
                HashSet<String> bomGroupIdSet = new HashSet<String>();
                bomGroupStr.append("(");
                for (int i = 0; this.bgQuery != null && i < this.bgQuery.length; ++i) {
                    bomGroupIdSet.add(((BomGroupstandardInfo)this.bgQuery[i]).getId().toString());
                    if (i == this.bgQuery.length - 1) {
                        bomGroupStr.append("'" + ((BomGroupstandardInfo)this.bgQuery[i]).getId().toString() + "'");
                        continue;
                    }
                    bomGroupStr.append("'" + ((BomGroupstandardInfo)this.bgQuery[i]).getId().toString() + "',");
                }
                bomGroupStr.append(")");
                StringBuffer projctStr = new StringBuffer();
                HashSet<String> projectIdsSet = new HashSet<String>();
                for (int i = 0; project != null && i < project.length && project[0] != null; ++i) {
                    projectIdsSet.add(((ProjectInfo)project[i]).getId().toString());
                    if (i == project.length - 1) {
                        projctStr.append("'" + ((ProjectInfo)project[i]).getId().toString() + "'");
                        continue;
                    }
                    projctStr.append("'" + ((ProjectInfo)project[i]).getId().toString() + "',");
                }
                if (project != null && project[0] != null) {
                    condition.setProjectNumIDs(projctStr.toString());
                    condition.setProjectIdSet(projectIdsSet);
                    this.projectNumber = projctStr.toString();
                    this.projectIdSet = projectIdsSet;
                } else {
                    condition.setProjectNumIDs(null);
                    condition.setProjectIdSet(null);
                    this.projectNumber = null;
                    this.projectIdSet = null;
                }
                condition.setMultiTree(true);
                condition.setMultMaterialIDs(materialStr.toString());
                condition.setMultMaterialIDSet(materialIdSet);
                condition.setBomGroupId(bomGroupStr.toString());
                condition.setBomGroupIdSet(bomGroupIdSet);
                condition.setOnlyAuditStatus(true);
                condition.setQueryDate(this.queryDate);
                condition.setQueryType(this.queryType);
                condition.setOnlyAuditStatus(true);
                condition.setStorageOrgUnitID(this.souQuery.getId().toString());
                condition.setProjectNumID(this.pjQuery);
                condition.setTrackNumID(this.tkQuery);
                condition.setSearchType(this.queryType);
                condition.setBomExtendFilterInfo(commonFI);
                this.bomType = (BOMTypeEnum)((Object)potq.cmbBOMType.getSelectedItem());
                condition.setBomtype(this.bomType);
                this.actionDownQuery.setEnabled(false);
                this.actionFirst.setEnabled(false);
                this.actionPre.setEnabled(false);
                this.searchResult(condition);
                return true;
            }
            return false;
        }
        catch (BomException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)((Object)e));
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handUIException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handUIException(e);
        }
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        Object filterCondition = this.getUIContext().get("BOMExtendSearchFilterCondition");
        if (this.getUIContext().get("IsFromTree") != null && ((Boolean)this.getUIContext().get("IsFromTree")).booleanValue() && this.commonQueryDialog != null && filterCondition != null && filterCondition instanceof BOMExtendSearchFilterCondition) {
            this.commonQueryDialog = null;
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setUiObject((IUIObject)this);
            String classFullName = this.getMetaDataPK().getFullName();
            this.commonQueryDialog.setParentUIClassName(classFullName);
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setTitle(EASResource.getString((String)RESOURCE_BOM, (String)"bomSearchWindowTitle"));
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.commonQueryDialog.setShowShareType(16);
            try {
                this.bomExtendSearchQueryUi = new BomExtendSearchQueryUI();
                this.commonQueryDialog.addUserPanel((KDPanel)this.bomExtendSearchQueryUi);
                this.commonQueryDialog.setWidth(580);
                this.commonQueryDialog.setHeight(435);
                String strParam = (String)this.getUIContext().get("UIClassParam");
                if (strParam != null && strParam.equals("1")) {
                    this.bomExtendSearchQueryUi.kDLabelContainer6.setVisible(true);
                    this.bomExtendSearchQueryUi.prmtProjectNumber.setVisible(true);
                    this.bomExtendSearchQueryUi.kDLabelContainer7.setVisible(true);
                    this.bomExtendSearchQueryUi.prmtTrackNumber.setVisible(true);
                    this.commonQueryDialog.setTitle(EASResource.getString((String)RESOURCE_BOM, (String)"orderbom_search_filter"));
                    this.getUIContext().put("orderBomExtend", "1");
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    private String getLevelStr(String level) {
        if (level.equals("1")) {
            return "*" + level;
        }
        if (level.equals("2")) {
            return "**" + level;
        }
        if (level.equals("3")) {
            return "***" + level;
        }
        if (level.equals("4")) {
            return "****" + level;
        }
        if (level.equals("5")) {
            return "*****" + level;
        }
        if (level.equals("6")) {
            return "******" + level;
        }
        if (level.equals("7")) {
            return "*******" + level;
        }
        return "********" + level;
    }

    public void searchResult(BomTreeCondition condition) throws BOSException, EASBizException {
        this.materialIds.clear();
        this.projectList.clear();
        this.bomIDs.clear();
        this.currentLocation = 0;
        this.kDTable1.removeRows();
        this.dtEntry.removeRows();
        if (condition.getBomtype().equals((Object)BOMTypeEnum.MfgBOM)) {
            this.kDTable1.getColumn("projectNum").getStyleAttributes().setHided(true);
            this.kDTable1.getColumn("isProjectManu").getStyleAttributes().setHided(true);
            this.materialIsConfigable = false;
        } else if (condition.getBomtype().equals((Object)BOMTypeEnum.CfgBOM)) {
            this.materialIsConfigable = true;
            this.kDTable1.getColumn("projectNum").getStyleAttributes().setHided(false);
            this.kDTable1.getColumn("isProjectManu").getStyleAttributes().setHided(false);
        }
        if (this.queryType.equals((Object)BOMSearchFlagEnum.ManySearch)) {
            this.kDSplitPaneLeft.setDividerSize(10);
            this.kDSplitPaneLeft.setDividerLocation(240);
            try {
                this.initTree(condition);
            }
            catch (Exception e) {
                logger.error((Object)"error:initTree() ", (Throwable)e);
            }
        } else {
            this.kDSplitPaneLeft.setDividerSize(10);
            this.kDSplitPaneLeft.setDividerLocation(240);
            try {
                this.initTree(condition);
            }
            catch (Exception e) {
                logger.error((Object)"error:initTree() ", (Throwable)e);
            }
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionDownQuery.setEnabled(false);
        }
        this.loadBomList(condition, true);
        BOMTypeEnum bomType = (BOMTypeEnum)((Object)this.bomExtendSearchQueryUi.cmbBOMType.getSelectedItem());
        if (BOMTypeEnum.MfgBOM.equals((Object)bomType)) {
            // empty if block
        }
    }

    private void setDynamicResultCol(BOMSearchFlagEnum type, BOMTypeEnum bomType) {
        if (bomType.equals((Object)BOMTypeEnum.MfgBOM)) {
            this.kDTable1.getColumn("projectNum").getStyleAttributes().setHided(true);
            this.kDTable1.getColumn("isProjectManu").getStyleAttributes().setHided(true);
        } else if (bomType.equals((Object)BOMTypeEnum.CfgBOM)) {
            this.kDTable1.getColumn("projectNum").getStyleAttributes().setHided(false);
            this.kDTable1.getColumn("isProjectManu").getStyleAttributes().setHided(false);
        }
        if (type.equals((Object)BOMSearchFlagEnum.ManySearch)) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blueprint").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(bomType);
        } else if (type.equals((Object)BOMSearchFlagEnum.SampleSearch)) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("location").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("blueprint").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(bomType);
        } else if (type.equals((Object)BOMSearchFlagEnum.MutliSraech)) {
            if (this.bueQuery != BOMUsageEnum.Master) {
                this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("blueprint").getStyleAttributes().setHided(true);
                this.setColumnByBOMType(bomType);
            } else {
                this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("location").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("blueprint").getStyleAttributes().setHided(false);
            }
        } else if (type.equals((Object)BOMSearchFlagEnum.IntegratedSearch)) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("location").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blueprint").getStyleAttributes().setHided(true);
        } else if (type.equals((Object)BOMSearchFlagEnum.MultilevelSearch)) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(bomType);
            this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("location").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("blueprint").getStyleAttributes().setHided(false);
        } else {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("location").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blueprint").getStyleAttributes().setHided(true);
        }
        this.dtEntry.setColumnMoveable(false);
        this.dtEntry.setEditable(false);
    }

    private void setColumnByBOMType(BOMTypeEnum bomType) {
        if (bomType.equals((Object)BOMTypeEnum.MfgBOM)) {
            this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
        } else if (bomType.equals((Object)BOMTypeEnum.CfgBOM)) {
            this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(false);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.kDTreeBOM.getLastSelectedPathComponent();
    }

    public void initTree(BomTreeCondition condition) throws Exception {
        this.kDTreeBOM.setRootVisible(false);
        TreeSelectionListener[] listeners = this.kDTreeBOM.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = this.treeSelectionListener = listeners.length > 0 ? listeners[0] : null;
        if (this.treeSelectionListener != null) {
            this.kDTreeBOM.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeBuilder = BOMTreeBuilderFactory.createTreeBuilder(this.getLNTreeNodeCtrl(condition), this.getTreeInitialLevel(), this.getTreeExpandLevel(), this.getDefaultFilterForTree(), this.getSelectorForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.kDTreeBOM.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.kDTreeBOM.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.kDTreeBOM);
        if (this.treeSelectionListener != null) {
            this.kDTreeBOM.addTreeSelectionListener(this.treeSelectionListener);
        }
        this.kDTreeBOM.setShowPopMenuDefaultItem(true);
        this.kDTreeBOM.expandOnLevel(3);
        if (((KDTreeNode)((DefaultTreeModel)this.kDTreeBOM.getModel()).getRoot()).getChildCount() > 0) {
            KDTreeNode note = (KDTreeNode)this.kDTreeBOM.getModel().getRoot();
            KDTreeNode selectctionNode = this.getFirstleaf(note);
            this.kDTreeBOM.setSelectionNode((DefaultKingdeeTreeNode)selectctionNode);
        }
    }

    private KDTreeNode getFirstleaf(KDTreeNode note) {
        KDTreeNode note1 = (KDTreeNode)note.getChildAt(0);
        if (note1.getUserObject() instanceof BomGroupstandardInfo) {
            return this.getFirstleaf(note1);
        }
        return note1;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return null;
    }

    protected int getTreeExpandLevel() {
        return 1;
    }

    protected SelectorItemCollection getSelectorForTree() {
        return null;
    }

    protected ILNTreeNodeCtrl[] getLNTreeNodeCtrl(BomTreeCondition condition) throws Exception {
        ILNTreeNodeCtrl[] array = new ILNTreeNodeCtrl[2];
        String strParam = (String)this.getUIContext().get("UIClassParam");
        if (strParam != null && strParam.equals("1")) {
            array[0] = new LNBom4QueryTreeNodeCtrl(this.souQuery, this.miQuery[0], this.bomNumberQuery, this.bueQuery, this.queryDate, this.queryType, BOMTypeEnum.OrderBOM, true, this.pinfo, this.tinfo, condition);
            array[1] = new DefaultLNTreeNodeCtrl(this.getTreeInterface());
            return array;
        }
        array[0] = new LNBom4QueryTreeNodeCtrl(this.souQuery, this.miQuery, this.bgQuery, this.bomNumberQuery, this.bueQuery, this.queryDate, this.queryType, condition);
        array[1] = new DefaultLNTreeNodeCtrl(this.getTreeInterface());
        return array;
    }

    protected int getTreeInitialLevel() {
        return 1;
    }

    protected String getRootName() {
        return "BOM ROOT";
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    @Override
    protected void dtEntry_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.queryType.equals((Object)BOMSearchFlagEnum.ManySearch) || this.queryType.equals((Object)BOMSearchFlagEnum.MutliSraech) || this.queryType.equals((Object)BOMSearchFlagEnum.IntegratedSearch)) {
            return;
        }
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (-1 == selectedIndex) {
            return;
        }
        IRow row = this.dtEntry.getRow(selectedIndex);
        ICell cell = row.getCell("childMaterialID");
        String materialId = (String)cell.getValue();
        if (null != materialId) {
            this.actionDownQuery.setEnabled(true);
        } else {
            this.actionDownQuery.setEnabled(false);
        }
    }

    @Override
    protected void kDTable1_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.kDTable1_tableSelectChanged(e);
        int selectedIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow row = this.kDTable1.getRow(selectedIndex);
        ICell cell = row.getCell("BOMID");
        String value = (String)cell.getValue();
        cell = row.getCell("parentMaterialID");
        String materialId = (String)cell.getValue();
        if (this.materialIds == null || this.materialIds.size() == 0 || this.materialIds.size() == 1) {
            if (this.materialIds != null) {
                this.materialIds.clear();
                this.materialIds.add(materialId);
            }
            if (this.projectList != null) {
                this.projectList.clear();
                IRow headRow = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
                String projectNum = (String)headRow.getCell("projectNum").getValue();
                ProjectInfo pInfo = null;
                if (MMUtils.isNotEmptyString((String)projectNum)) {
                    pInfo = ProjectFactory.getRemoteInstance().getProjectInfo(" where number = '" + projectNum + "'");
                }
                this.projectList.add(pInfo);
            }
            this.bomIDs.clear();
            this.bomIDs.add(value);
            this.currentLocation = 0;
        }
        cell = row.getCell("productQty");
        BigDecimal bd = new BigDecimal((String)cell.getValue());
        if (null != value) {
            this.loadResultList(value, materialId, bd);
        }
    }

    @Override
    public void actionDownQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionDownQuery_actionPerformed(e);
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (selectedIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            this.actionDownQuery.setEnabled(false);
            SysUtil.abort();
        }
        IRow row = this.dtEntry.getRow(selectedIndex);
        ICell cell = row.getCell("childMaterialID");
        String materialId = (String)cell.getValue();
        IRow headRow = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        String bomType = (String)headRow.getCell("BOMType").getValue();
        String projectNum = null;
        ProjectInfo pInfo = null;
        if (headRow.getCell("projectNum").getValue() != null) {
            projectNum = (String)headRow.getCell("projectNum").getValue();
            pInfo = ProjectFactory.getRemoteInstance().getProjectInfo(" where number = '" + projectNum + "'");
        }
        if (null != materialId) {
            BomTreeCondition condition = new BomTreeCondition();
            condition.setBomID(null);
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setBomtype(BOMTypeEnum.MfgBOM);
            if (BOMTypeEnum.MfgBOM.getAlias(this.getLocale()).equals(bomType)) {
                condition.setBomtype(BOMTypeEnum.MfgBOM);
            } else if (BOMTypeEnum.CfgBOM.getAlias(this.getLocale()).equals(bomType)) {
                condition.setBomtype(BOMTypeEnum.CfgBOM);
            } else if (BOMTypeEnum.ScheduleBOM.getAlias(this.getLocale()).equals(bomType)) {
                condition.setBomtype(BOMTypeEnum.ScheduleBOM);
            } else if (BOMTypeEnum.BudgetBOM.getAlias(this.getLocale()).equals(bomType)) {
                condition.setBomtype(BOMTypeEnum.BudgetBOM);
            }
            if (pInfo != null) {
                condition.setProjectNumIDs("'" + pInfo.getId().toString() + "'");
                HashSet<String> projectIdSet = new HashSet<String>();
                projectIdSet.add(pInfo.getId().toString());
                condition.setProjectIdSet(projectIdSet);
            }
            condition.setDownQuery(true);
            condition.setOnlyAuditStatus(true);
            this.materialIds.add(materialId);
            this.projectList.add(pInfo);
            ++this.currentLocation;
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionDownQuery.setEnabled(false);
            this.loadBomList(condition, true);
        }
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.currentLocation = 0;
        String materialId = (String)this.materialIds.get(this.currentLocation);
        String bomID = (String)this.bomIDs.get(this.currentLocation);
        if (null != materialId) {
            BomTreeCondition condition = new BomTreeCondition();
            condition.setBomID(bomID);
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setBomtype(this.bomType);
            condition.setProjectNumIDs(this.projectNumber);
            condition.setProjectIdSet(this.projectIdSet);
            condition.setOnlyAuditStatus(true);
            condition.setMultiTree(true);
            StringBuffer materialStr = new StringBuffer();
            HashSet<String> materialIdSet = new HashSet<String>();
            materialStr.append("(");
            for (int i = 0; i < this.miQuery.length; ++i) {
                materialIdSet.add(this.miQuery[i].getId().toString());
                if (i == this.miQuery.length - 1) {
                    materialStr.append("'" + this.miQuery[i].getId().toString() + "'");
                    continue;
                }
                materialStr.append("'" + this.miQuery[i].getId().toString() + "',");
            }
            materialStr.append(")");
            condition.setMultiTree(true);
            condition.setMultMaterialIDs(materialStr.toString());
            condition.setMultMaterialIDSet(materialIdSet);
            this.materialIds.clear();
            this.projectList.clear();
            this.bomIDs.clear();
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionDownQuery.setEnabled(false);
            this.loadBomList(condition, true);
        }
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        --this.currentLocation;
        String materialId = (String)this.materialIds.get(this.currentLocation);
        if (null != materialId) {
            BomTreeCondition condition = new BomTreeCondition();
            if (this.currentLocation == 0) {
                this.actionFirst_actionPerformed(e);
                return;
            }
            condition.setBomID(null);
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setBomtype(this.bomType);
            ProjectInfo proInfo = (ProjectInfo)this.projectList.get(this.currentLocation);
            if (proInfo == null) {
                condition.setProjectNumIDs(null);
                condition.setProjectIdSet(null);
            } else {
                condition.setProjectNumIDs("'" + proInfo.getId().toString() + "'");
                HashSet<String> pSet = new HashSet<String>();
                pSet.add(proInfo.getId().toString());
                condition.setProjectIdSet(pSet);
            }
            condition.setOnlyAuditStatus(true);
            this.loadBomList(condition, true);
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionDownQuery.setEnabled(false);
        }
    }

    private void loadBomList(BomTreeCondition condition, boolean isSelectFirstRow) {
        IRowSet rowSet = null;
        try {
            rowSet = BOMExtendFacadeFactory.getRemoteInstance().getBomList4Query(condition);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (null != rowSet) {
            this.kDTable1.removeRows();
            IRow row = null;
            try {
                while (null != rowSet && rowSet.next()) {
                    row = this.kDTable1.addRow();
                    this.fillupTableRow(row, rowSet);
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
        if (isSelectFirstRow) {
            if (this.kDTable1.getRowCount() > 0) {
                this.kDTable1.getSelectManager().select(0, 0, 2);
                String currentBOMType = (String)this.kDTable1.getCell(0, "BOMType").getValue();
                BOMTypeEnum bomType = null;
                bomType = !StringUtil.isEmptyString((String)currentBOMType) && currentBOMType.equals(BOMTypeEnum.getEnum(50).getAlias()) ? BOMTypeEnum.CfgBOM : BOMTypeEnum.MfgBOM;
                this.setDynamicResultCol(this.queryType, bomType);
            } else {
                this.dtEntry.removeRows();
            }
        } else {
            this.dtEntry.removeRows();
        }
    }

    private boolean fillupTableRow(IRow row, IRowSet rowSet) {
        boolean flag = true;
        String enumName = null;
        try {
            row.getCell("storageOrgUnitNumber").setValue((Object)rowSet.getString("ORGNAME"));
            row.getCell("queryDate").setValue((Object)this.queryDate);
            row.getCell("searchType").setValue((Object)this.queryType.getAlias());
            row.getCell("parentMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
            row.getCell("parentMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
            row.getCell("parentMaterialModel").setValue((Object)rowSet.getString("MATERIALMODE"));
            row.getCell("productQty").setValue((Object)rowSet.getString("PRODUCTQTY"));
            row.getCell("parentMaterialUnit").setValue((Object)rowSet.getString("UNITNAME"));
            enumName = this.getAlias(MaterialAttributeEnum.class, rowSet.getInt("MATERIALATTR"));
            row.getCell("parentMaterialAttr").setValue((Object)enumName);
            row.getCell("BOMNumber").setValue((Object)rowSet.getString("BOMNUMBER"));
            enumName = BOMTypeEnum.getEnum(Integer.parseInt(rowSet.getString("BOMTYPE"))).getAlias();
            row.getCell("BOMType").setValue((Object)enumName);
            enumName = BOMUsageEnum.getEnum(Integer.parseInt(rowSet.getString("BOMUSAGETYPE"))).getAlias();
            row.getCell("BOMUsage").setValue((Object)enumName);
            row.getCell("BOMID").setValue((Object)rowSet.getString("BOMID"));
            row.getCell("parentMaterialID").setValue((Object)rowSet.getString("MATERIALID"));
            if (this.orderQuery) {
                row.getCell("trackNumber").setValue((Object)this.tkNumber);
            }
            row.getCell("bomGroup").setValue((Object)rowSet.getString("bomGroup"));
            row.getCell("pictureNumber").setValue((Object)rowSet.getString("pictureNumber"));
            if (rowSet.getInt("BOMTYPE") == 50) {
                row.getCell("isProjectManu").setValue((Object)rowSet.getBoolean("isProjectManu"));
                row.getCell("projectNum").setValue((Object)rowSet.getString("projectNum"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error:fillupTableRow ", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    private String getAlias(Object enumObj, int val) {
        MaterialIssueModeEnum miEnum;
        String name = null;
        if (enumObj.equals(MaterialAttributeEnum.class)) {
            MaterialAttributeEnum maEnum = MaterialAttributeEnum.getEnum((int)val);
            if (maEnum != null) {
                name = maEnum.getAlias();
            }
        } else if (enumObj.equals(ConsumeTypeEnum.class)) {
            ConsumeTypeEnum ctEnum = ConsumeTypeEnum.getEnum(val);
            if (ctEnum != null) {
                name = ctEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialProductEnum.class)) {
            MaterialProductEnum mpEnum = MaterialProductEnum.getEnum((int)val);
            if (mpEnum != null) {
                name = mpEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialCharEnum.class)) {
            MaterialCharEnum mtEnum = MaterialCharEnum.getEnum((int)val);
            if (mtEnum != null) {
                name = mtEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialIssueModeEnum.class) && (miEnum = MaterialIssueModeEnum.getEnum((int)val)) != null) {
            name = miEnum.getAlias();
        }
        return name;
    }

    private void loadResultList(String bomId, String materialId, BigDecimal productQty) throws Exception {
        if (null != bomId) {
            BOMExtendCondition conditionForIntegratedSearch;
            String[] returnFields;
            ArrayList<String> returnFieldList;
            this.dtEntry.removeRows();
            BomTreeCondition condition = new BomTreeCondition();
            condition.setBomID(bomId);
            condition.setQueryType(this.queryType);
            if (this.queryType.equals((Object)BOMSearchFlagEnum.MutliSraech) && !this.bueQuery.equals((Object)BOMUsageEnum.Master)) {
                condition.setQueryType(BOMSearchFlagEnum.SampleSearch);
            }
            condition.setQueryDate(this.queryDate);
            condition.setProjectNumID(this.pjQuery);
            condition.setTrackNumID(this.tkQuery);
            BOMTypeEnum bomType = null;
            String currentBOMType = (String)this.kDTable1.getCell(this.kDTable1.getSelectManager().getActiveRowIndex(), "BOMType").getValue();
            bomType = StringUtil.isEmptyString((String)currentBOMType) ? BOMTypeEnum.MfgBOM : (currentBOMType.equals(BOMTypeEnum.getEnum(50).getAlias()) ? BOMTypeEnum.CfgBOM : (currentBOMType.equals(BOMTypeEnum.getEnum(60).getAlias()) ? BOMTypeEnum.ScheduleBOM : (currentBOMType.equals(BOMTypeEnum.getEnum(40).getAlias()) ? BOMTypeEnum.MfgBOM : (currentBOMType.equals(BOMTypeEnum.getEnum(70).getAlias()) ? BOMTypeEnum.BudgetBOM : BOMTypeEnum.MfgBOM))));
            IRow headRow = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
            String projectNum = null;
            ProjectInfo pInfo = null;
            String projectID = null;
            if (headRow.getCell("projectNum").getValue() != null) {
                projectNum = (String)headRow.getCell("projectNum").getValue();
                pInfo = ProjectFactory.getRemoteInstance().getProjectInfo(" where number = '" + projectNum + "'");
                if (pInfo != null) {
                    projectID = "'" + pInfo.getId().toString() + "'";
                }
            }
            this.setDynamicResultCol(this.queryType, bomType);
            IRowSet rowSet = null;
            if (condition.getQueryType() != BOMSearchFlagEnum.MutliSraech && condition.getQueryType() != BOMSearchFlagEnum.IntegratedSearch && condition.getQueryType() != BOMSearchFlagEnum.MultilevelSearch) {
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getResultList4Query(condition);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else if (condition.getQueryType().equals((Object)BOMSearchFlagEnum.MutliSraech)) {
                returnFieldList = new ArrayList<String>();
                returnFieldList.add("FID");
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFields = returnFieldList.toArray(new String[0]);
                BOMExtendCondition condition1 = new BOMExtendCondition();
                condition1.setExtendLevel(BOMExtendLevelEnum.EndLevelExtend);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(true);
                condition1.setOnlyExtendConfig(false);
                condition1.setOnlyExtendVirtual(false);
                condition1.setReturnFields(returnFields);
                condition1.setBomId(bomId);
                condition1.setBomType(bomType);
                condition1.setProjectNumID(projectID);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                    SysUtil.abort();
                }
            } else if (condition.getQueryType().equals((Object)BOMSearchFlagEnum.IntegratedSearch)) {
                returnFieldList = new ArrayList();
                returnFieldList.add("FID");
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFieldList.add("Fblueprint");
                returnFields = returnFieldList.toArray(new String[0]);
                conditionForIntegratedSearch = new BOMExtendCondition();
                conditionForIntegratedSearch.setExtendLevel(BOMExtendLevelEnum.IntegratedExtend);
                conditionForIntegratedSearch.setStorateOrgID(this.souQuery.getId().toString());
                conditionForIntegratedSearch.setGroupByMaterial(true);
                conditionForIntegratedSearch.setOnlyExtendConfig(false);
                conditionForIntegratedSearch.setOnlyExtendVirtual(false);
                conditionForIntegratedSearch.setReturnFields(returnFields);
                conditionForIntegratedSearch.setBomId(bomId);
                conditionForIntegratedSearch.setBomType(bomType);
                conditionForIntegratedSearch.setProjectNumID(projectID);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, conditionForIntegratedSearch);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                    SysUtil.abort();
                }
            }
            if (BOMSearchFlagEnum.MultilevelSearch.equals((Object)condition.getQueryType())) {
                returnFieldList = new ArrayList();
                returnFieldList.add("FID");
                returnFieldList.add("FLevel");
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFieldList.add("FBomId");
                returnFieldList.add("FParentBomId");
                returnFieldList.add("FProportion");
                returnFieldList.add("FParentComsumeQty");
                returnFieldList.add("FScrapRatio");
                returnFieldList.add("FEffectiveDate");
                returnFieldList.add("FDisableDate");
                returnFieldList.add("FOutputType");
                returnFieldList.add("FMaterialChar");
                returnFieldList.add("FIssMode");
                returnFieldList.add("FDefaultWarehouseName");
                returnFieldList.add("Fnumber");
                returnFieldList.add("FBomName");
                returnFieldList.add("FConsumeType");
                returnFieldList.add("Fblueprint");
                returnFields = returnFieldList.toArray(new String[0]);
                conditionForIntegratedSearch = new BOMExtendCondition();
                conditionForIntegratedSearch.setExtendLevel(BOMExtendLevelEnum.AllLevelExtend);
                conditionForIntegratedSearch.setStorateOrgID(this.souQuery.getId().toString());
                conditionForIntegratedSearch.setGroupByMaterial(false);
                conditionForIntegratedSearch.setOnlyExtendConfig(false);
                conditionForIntegratedSearch.setOnlyExtendVirtual(false);
                conditionForIntegratedSearch.setReturnFields(returnFields);
                conditionForIntegratedSearch.setBomId(bomId);
                conditionForIntegratedSearch.setBomType(bomType);
                conditionForIntegratedSearch.setProjectNumID(projectID);
                this.materialIsConfigable = bomType.equals((Object)BOMTypeEnum.CfgBOM);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, conditionForIntegratedSearch);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                    SysUtil.abort();
                }
            }
            this.loadResultList(rowSet, condition);
        }
    }

    private void loadResultList(IRowSet rowSet, BomTreeCondition condition) throws BOSException, EASBizException, SQLException {
        if (rowSet == null) {
            return;
        }
        BOMSearchFlagEnum flag = condition.getQueryType();
        String enumName = null;
        if (BOMSearchFlagEnum.MutliSraech.equals((Object)flag) || BOMSearchFlagEnum.IntegratedSearch.equals((Object)flag)) {
            this.dtEntry.removeRows();
            IRow row = null;
            BigDecimal bd = null;
            while (null != rowSet && rowSet.next()) {
                row = this.dtEntry.addRow();
                row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("FMaterialNumber"));
                row.getCell("childMaterialName").setValue((Object)rowSet.getString("FMaterialName"));
                row.getCell("childMaterialModel").setValue((Object)rowSet.getString("FModel"));
                enumName = this.getAlias(MaterialAttributeEnum.class, rowSet.getInt("FMATERIALATTR"));
                row.getCell("childMaterialAttr").setValue((Object)enumName);
                row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("FUnitname"));
                bd = rowSet.getBigDecimal("FBaseQty");
                bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
                row.getCell("childConsumeQty").setValue((Object)bd);
                row.getCell("blueprint").setValue((Object)rowSet.getString("Fblueprint"));
            }
        } else if (BOMSearchFlagEnum.SampleSearch.equals((Object)flag) || BOMSearchFlagEnum.ManySearch.equals((Object)flag)) {
            this.dtEntry.removeRows();
            IRow row = null;
            IBom bom = BomFactory.getRemoteInstance();
            String bomId = condition.getBomID();
            HashSet<String> bomIdSet = new HashSet<String>();
            bomIdSet.add(bomId);
            Map map = bom.getCfgBomTracks(bomIdSet);
            List traList = null;
            while (null != rowSet && rowSet.next()) {
                row = this.dtEntry.addRow();
                row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
                row.getCell("childMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
                row.getCell("childMaterialModel").setValue((Object)rowSet.getString("MATERIALMODE"));
                enumName = this.getAlias(MaterialAttributeEnum.class, rowSet.getInt("MATERIALATTR"));
                row.getCell("childMaterialAttr").setValue((Object)enumName);
                enumName = this.getAlias(ConsumeTypeEnum.class, rowSet.getInt("CONSUMETYPE"));
                row.getCell("consumeType").setValue((Object)enumName);
                row.getCell("consumeFixQty").setValue((Object)rowSet.getString("CONSUMEFIXQTY"));
                row.getCell("proportion").setValue((Object)rowSet.getString("PROPORTION"));
                row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("UNITNAME"));
                row.getCell("scrapRatio").setValue((Object)rowSet.getString("SCRAPRATIO"));
                row.getCell("effectiveDate").setValue((Object)rowSet.getString("EFFECTIVEDATE"));
                row.getCell("disableDate").setValue((Object)rowSet.getString("DISABLEDATE"));
                enumName = this.getAlias(MaterialProductEnum.class, rowSet.getInt("OUTPUTTYPE"));
                row.getCell("outputType").setValue((Object)enumName);
                enumName = this.getAlias(MaterialCharEnum.class, rowSet.getInt("MATERIALCHAR"));
                row.getCell("materialChara").setValue((Object)enumName);
                enumName = this.getAlias(MaterialIssueModeEnum.class, rowSet.getInt("ISSMODE"));
                row.getCell("pickingMode").setValue((Object)enumName);
                row.getCell("defaultWarehouseName").setValue((Object)rowSet.getString("DEFAULTWAREHOUSENAME"));
                row.getCell("childMaterialID").setValue((Object)rowSet.getString("MATERIALID"));
                if (map.containsKey(rowSet.getString("entryid"))) {
                    traList = (List)map.get(rowSet.getString("entryid"));
                    row.getCell("showTrack").setValue((Object)traList.toString());
                } else {
                    row.getCell("showTrack").setValue((Object)"");
                }
                row.getCell("netWeight").setValue((Object)this.formatZero(rowSet.getString("netWeight")));
                row.getCell("blkSize").setValue((Object)rowSet.getString("blkSize"));
                row.getCell("specifiedLength").setValue((Object)rowSet.getString("specifiedLength"));
                row.getCell("usedUnit").setValue((Object)rowSet.getString("usedUnit"));
                row.getCell("designUnit").setValue((Object)rowSet.getString("designUnit"));
                row.getCell("designRemark").setValue((Object)rowSet.getString("designRemark"));
                row.getCell("feture").setValue((Object)rowSet.getBoolean("feture"));
                row.getCell("canSelected").setValue((Object)rowSet.getBoolean("canSelected"));
                row.getCell("firstCfg").setValue((Object)rowSet.getBoolean("firstCfg"));
                row.getCell("location").setValue((Object)rowSet.getString("location"));
                row.getCell("blueprint").setValue((Object)rowSet.getString("blueprint"));
            }
        } else if (BOMSearchFlagEnum.MultilevelSearch.equals((Object)flag)) {
            this.fillTableRow4MultiLevelSearch(rowSet);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = this.preparePrintDate();
        BOMSearchFlagEnum tmp = this.queryType;
        if (tmp.equals((Object)BOMSearchFlagEnum.MutliSraech) && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchFlagEnum.SampleSearch;
        }
        this.setDtEntryDefaultView(tmp);
        BomExtendSearchPrintDataProvider data = new BomExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, false, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        BOMSearchFlagEnum tmp;
        super.actionPrintPreview_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = this.preparePrintDate();
        if (this.queryType.equals((Object)BOMSearchFlagEnum.MultilevelSearch)) {
            resultMap.put("BomList", this.kDTable1);
            resultMap.put("BomList", this.kDTable1);
        }
        if ((tmp = this.queryType).equals((Object)BOMSearchFlagEnum.MultilevelSearch) && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchFlagEnum.SampleSearch;
        }
        this.setDtEntryDefaultView(tmp);
        BomExtendSearchPrintDataProvider data = new BomExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, true, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private String getTemplatePath(BOMSearchFlagEnum queryType) {
        String templatePath = null;
        if (BOMSearchFlagEnum.SampleSearch.equals((Object)queryType)) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_SINGLE.r1-print";
        } else if (BOMSearchFlagEnum.ManySearch.equals((Object)queryType)) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_TREE.r1-print";
        } else if (queryType.equals((Object)BOMSearchFlagEnum.MultilevelSearch)) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_MANY.r1-print";
        } else if (BOMSearchFlagEnum.MutliSraech.equals((Object)queryType)) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_MULTI.r1-print";
        } else if (BOMSearchFlagEnum.IntegratedSearch.equals((Object)queryType)) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_INTEGRATED.r1-print";
        }
        return templatePath;
    }

    private void setDtEntryDefaultView(BOMSearchFlagEnum searchFlag) {
        int rowIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        String currentBOMType = (String)this.kDTable1.getCell(rowIndex, "BOMType").getValue();
        BOMTypeEnum bomType = null;
        bomType = !StringUtil.isEmptyString((String)currentBOMType) && currentBOMType.equals(BOMTypeEnum.getEnum(50).getAlias()) ? BOMTypeEnum.CfgBOM : BOMTypeEnum.MfgBOM;
        this.setDynamicResultCol(searchFlag, bomType);
    }

    private Map preparePrintDate() throws Exception {
        HashMap<Integer, IRowSet> map = new HashMap<Integer, IRowSet>();
        String bomId = null;
        String materialId = null;
        IRow bomRow = null;
        ICell cell = null;
        int count = this.kDTable1.getRowCount();
        for (int i = 0; i < count; ++i) {
            BOMExtendCondition condition1;
            String[] returnFields;
            ArrayList<String> returnFieldList;
            bomRow = this.kDTable1.getRow(i);
            cell = bomRow.getCell("BOMID");
            bomId = (String)cell.getValue();
            cell = bomRow.getCell("parentMaterialID");
            materialId = (String)cell.getValue();
            BomTreeCondition condition = new BomTreeCondition();
            condition.setBomID(bomId);
            condition.setQueryType(this.queryType);
            condition.setProjectNumID(this.pjQuery);
            condition.setTrackNumID(this.tkQuery);
            String projectNum = null;
            ProjectInfo pInfo = null;
            String projectID = null;
            if (bomRow.getCell("projectNum").getValue() != null) {
                projectNum = (String)bomRow.getCell("projectNum").getValue();
                pInfo = ProjectFactory.getRemoteInstance().getProjectInfo(" where number = '" + projectNum + "'");
                if (pInfo != null) {
                    projectID = "'" + pInfo.getId().toString() + "'";
                }
            }
            if (this.queryType.equals((Object)BOMSearchFlagEnum.MultilevelSearch) && this.bueQuery != BOMUsageEnum.Master) {
                condition.setQueryType(BOMSearchFlagEnum.SampleSearch);
            }
            condition.setQueryDate(this.queryDate);
            IRowSet rowSet = null;
            if (condition.getQueryType().equals((Object)BOMSearchFlagEnum.SampleSearch) || condition.getQueryType().equals((Object)BOMSearchFlagEnum.ManySearch)) {
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getResultList4Query(condition);
                }
                catch (EASBizException e1) {
                    this.handUIException(e1);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            } else if (condition.getQueryType().equals((Object)BOMSearchFlagEnum.MultilevelSearch)) {
                returnFieldList = new ArrayList<String>();
                returnFieldList.add("FID");
                returnFieldList.add("FLevel");
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFieldList.add("FBomId");
                returnFieldList.add("FParentBomId");
                returnFieldList.add("FProportion");
                returnFieldList.add("FParentComsumeQty");
                returnFieldList.add("FScrapRatio");
                returnFieldList.add("FEffectiveDate");
                returnFieldList.add("FDisableDate");
                returnFieldList.add("FOutputType");
                returnFieldList.add("FMaterialChar");
                returnFieldList.add("FIssMode");
                returnFieldList.add("FDefaultWarehouseName");
                returnFieldList.add("Fnumber");
                returnFieldList.add("FBomName");
                returnFieldList.add("FConsumeType");
                returnFieldList.add("Fblueprint");
                returnFieldList.add("Fblueprint");
                returnFields = returnFieldList.toArray(new String[0]);
                BOMExtendCondition conditionForIntegratedSearch = new BOMExtendCondition();
                conditionForIntegratedSearch.setExtendLevel(BOMExtendLevelEnum.AllLevelExtend);
                conditionForIntegratedSearch.setStorateOrgID(this.souQuery.getId().toString());
                conditionForIntegratedSearch.setGroupByMaterial(false);
                conditionForIntegratedSearch.setOnlyExtendConfig(false);
                conditionForIntegratedSearch.setOnlyExtendVirtual(false);
                conditionForIntegratedSearch.setReturnFields(returnFields);
                conditionForIntegratedSearch.setBomId(bomId);
                conditionForIntegratedSearch.setBomType(this.bomType);
                conditionForIntegratedSearch.setProjectNumID(projectID);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, conditionForIntegratedSearch);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                    SysUtil.abort();
                }
            } else if (condition.getQueryType().equals((Object)BOMSearchFlagEnum.MutliSraech)) {
                returnFieldList = new ArrayList();
                returnFieldList.add("FID");
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFieldList.add("Fblueprint");
                returnFields = returnFieldList.toArray(new String[0]);
                condition1 = new BOMExtendCondition();
                condition1.setExtendLevel(BOMExtendLevelEnum.EndLevelExtend);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(true);
                condition1.setOnlyExtendConfig(false);
                condition1.setOnlyExtendVirtual(false);
                condition1.setReturnFields(returnFields);
                condition1.setBomId(bomId);
                condition1.setBomType(this.bomType);
                condition1.setProjectNumID(projectID);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                    SysUtil.abort();
                }
            } else if (condition.getQueryType().equals((Object)BOMSearchFlagEnum.IntegratedSearch)) {
                returnFieldList = new ArrayList();
                returnFieldList.add("FID");
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFields = returnFieldList.toArray(new String[0]);
                condition1 = new BOMExtendCondition();
                condition1.setExtendLevel(BOMExtendLevelEnum.IntegratedExtend);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(true);
                condition1.setOnlyExtendConfig(false);
                condition1.setOnlyExtendVirtual(false);
                condition1.setReturnFields(returnFields);
                condition1.setBomId(bomId);
                condition1.setBomType(this.bomType);
                condition1.setProjectNumID(projectID);
                try {
                    rowSet = BOMExtendFacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                    SysUtil.abort();
                }
            }
            if (null == rowSet) continue;
            map.put(new Integer(i), rowSet);
        }
        return map;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        int loop = 0;
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotExport"));
            return;
        }
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        IRow headRow = this.kDTable1.getRow(this.kDTable1.getSelectManager().getActiveRowIndex());
        ProjectInfo pInfo = null;
        if (headRow.getCell("projectNum").getValue() == null || (pInfo = ProjectFactory.getRemoteInstance().getProjectInfo(" where number = '" + (String)headRow.getCell("projectNum").getValue() + "'")) != null) {
            // empty if block
        }
        IRow bomRow = null;
        KDTHead head = this.kDTable1.getHead();
        ArrayList headList = head.getRow(0).getCells();
        head = this.dtEntry.getHead();
        ArrayList resultHeadList = head.getRow(0).getCells();
        IRow resultRow = null;
        Object obj = null;
        Boolean tmpBoolean = Boolean.FALSE;
        File tempFile = File.createTempFile("tmp", ".xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Sheet1");
        int curRowIndex = 0;
        HSSFRow row = null;
        HSSFCell hcell = null;
        HSSFCellStyle style = null;
        HSSFPalette palette = wb.getCustomPalette();
        palette.setColorAtIndex(IndexedColors.BLUE_GREY.index, (byte)this.kDTable1.getHeadSSA().getBackground().getRed(), (byte)this.kDTable1.getHeadSSA().getBackground().getGreen(), (byte)this.kDTable1.getHeadSSA().getBackground().getBlue());
        row = sheet.createRow(curRowIndex++);
        hcell = row.createCell(5);
        if (this.queryType.equals((Object)BOMSearchFlagEnum.MutliSraech)) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.multiSearch")));
        } else if (this.queryType.equals((Object)BOMSearchFlagEnum.ManySearch)) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.manySearch")));
        } else if (this.queryType.equals((Object)BOMSearchFlagEnum.SampleSearch)) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.simpleSearch")));
        } else if (this.queryType.equals((Object)BOMSearchFlagEnum.IntegratedSearch)) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.integratedSearch")));
        } else if (this.queryType.equals((Object)BOMSearchFlagEnum.MultilevelSearch)) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.multiLevelSearch")));
        }
        style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
        hcell.setCellStyle(style);
        for (int i = 0; i < count; ++i) {
            int k;
            this.kDTable1.getSelectManager().select(i, 0);
            bomRow = this.kDTable1.getRow(i);
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.parentMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            int count1 = headList.size();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)headList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = this.kDTable1.getColumnCount();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                obj = bomRow.getCell(k).getValue();
                if (this.kDTable1.getColumn(k).getKey().equalsIgnoreCase("queryDate")) {
                    if (null != (Date)bomRow.getCell(k).getValue()) {
                        row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString(dtformat.format((Date)bomRow.getCell(k).getValue())));
                        continue;
                    }
                    row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString((String)bomRow.getCell(k).getValue()));
                    continue;
                }
                if (obj == null) {
                    row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString(""));
                    continue;
                }
                if (obj instanceof Boolean) {
                    tmpBoolean = (Boolean)obj;
                    if (tmpBoolean.equals(Boolean.TRUE)) {
                        row.createCell((int)((short)loop++)).setCellValue(YesOrNoEnum.YES.getAlias());
                        continue;
                    }
                    row.createCell((int)((short)loop++)).setCellValue(YesOrNoEnum.NO.getAlias());
                    continue;
                }
                row.createCell((int)((short)loop++)).setCellValue(obj.toString());
            }
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.childMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = resultHeadList.size();
            for (k = 0; k < count1; ++k) {
                if (this.dtEntry.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)resultHeadList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            int n = 0;
            int count11 = this.dtEntry.getRowCount();
            for (int j = 0; j < count11; ++j) {
                n = 0;
                row = sheet.createRow(curRowIndex++);
                resultRow = this.dtEntry.getRow(j);
                int count3 = resultHeadList.size();
                for (int m = 0; m < count3; ++m) {
                    if (resultRow.getCell(m).getStyleAttributes().isHided()) continue;
                    if (resultRow.getCell(m).getFormattedValue() != null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(resultRow.getCell(m).getFormattedValue().toString()));
                        continue;
                    }
                    obj = resultRow.getCell(m).getValue();
                    if (obj == null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(""));
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        tmpBoolean = (Boolean)obj;
                        if (tmpBoolean.equals(Boolean.TRUE)) {
                            row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.YES.getAlias());
                            continue;
                        }
                        row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.NO.getAlias());
                        continue;
                    }
                    row.createCell((int)((short)n++)).setCellValue(obj.toString());
                }
            }
            ++curRowIndex;
        }
        FileOutputStream fileOut = new FileOutputStream(tempFile);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        try {
            KDTMenuManager.openFileInExcel((String)tempFile.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempFile.deleteOnExit();
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }

    protected String getOnloadPermItemName() {
        return "mm_bom_search";
    }

    private List getRowValue4ManySearchList(IRowSet rowSet) throws SQLException {
        ArrayList<RowValue4ManySearch> rst = new ArrayList<RowValue4ManySearch>();
        RowValue4ManySearch row = null;
        BigDecimal bd = null;
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        while (rowSet.next()) {
            row = new RowValue4ManySearch();
            row.fid = rowSet.getString("fid");
            row.FMaterialNumber = rowSet.getString("FMaterialNumber");
            row.FMaterialName = rowSet.getString("FMaterialName");
            row.FModel = rowSet.getString("FModel");
            row.FUnitname = rowSet.getString("FUnitname");
            row.FMaterialAttr = rowSet.getString("FMaterialAttr");
            bd = rowSet.getBigDecimal("FBaseQty");
            bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
            row.FBaseQty = bd.toString();
            row.FLevel = rowSet.getString("FLevel");
            row.FProportion = rowSet.getString("FProportion");
            row.FParentComsumeQty = rowSet.getString("FParentComsumeQty");
            row.FScrapRatio = rowSet.getString("FScrapRatio");
            row.FEffectiveDate = dtformat.format(rowSet.getDate("FEffectiveDate"));
            row.FDisableDate = dtformat.format(rowSet.getDate("FDisableDate"));
            row.FMaterialChar = rowSet.getString("FMaterialChar");
            row.FIssMode = rowSet.getString("FIssMode");
            row.FOutputType = rowSet.getString("FOutputType");
            row.FDEFAULTWAREHOUSENAME = rowSet.getString("FDEFAULTWAREHOUSENAME");
            row.Fnumber = rowSet.getString("Fnumber");
            row.FBomName = rowSet.getString("FBomName");
            row.bomId = rowSet.getString("FBomId");
            row.parentBomId = rowSet.getString("FParentBomId");
            row.FConsumeType = rowSet.getString("FConsumeType");
            row.netWeight = rowSet.getString("netWeight");
            row.blkSize = rowSet.getString("blkSize");
            row.specifiedLength = rowSet.getString("specifiedLength");
            row.usedUnit = rowSet.getString("usedUnit");
            row.designUnit = rowSet.getString("designUnit");
            row.designRemark = rowSet.getString("designRemark");
            row.blueprint = rowSet.getString("fblueprint");
            if (this.materialIsConfigable) {
                row.showTrack = rowSet.getString("showTrack");
                row.feture = Boolean.toString(rowSet.getBoolean("feture"));
                row.canSelected = Boolean.toString(rowSet.getBoolean("canSelected"));
                row.firstCfg = Boolean.toString(rowSet.getBoolean("firstCfg"));
            }
            row.location = rowSet.getString("location");
            rst.add(row);
        }
        return rst;
    }

    private void fillTableRow4MultiLevelSearch(IRowSet rowSet) throws SQLException {
        IRow row = null;
        String enumName = null;
        List list = this.getRowValue4ManySearchList(rowSet);
        if (list == null || list.size() == 0) {
            return;
        }
        RowValue4ManySearch rowValue = null;
        for (int i = 0; i < list.size(); ++i) {
            rowValue = (RowValue4ManySearch)list.get(i);
            row = this.dtEntry.addRow();
            row.getCell("levelNo").setValue((Object)this.getLevelStr(rowValue.FLevel));
            row.getCell("childMaterialNumber").setValue((Object)rowValue.FMaterialNumber);
            row.getCell("childMaterialName").setValue((Object)rowValue.FMaterialName);
            row.getCell("childMaterialModel").setValue((Object)rowValue.FModel);
            enumName = this.getAlias(MaterialAttributeEnum.class, Integer.parseInt(rowValue.FMaterialAttr));
            row.getCell("childMaterialAttr").setValue((Object)enumName);
            row.getCell("childMaterialUnit").setValue((Object)rowValue.FUnitname);
            row.getCell("childConsumeQty").setValue((Object)rowValue.FBaseQty);
            enumName = this.getAlias(ConsumeTypeEnum.class, Integer.parseInt(rowValue.FConsumeType));
            row.getCell("consumeType").setValue((Object)enumName);
            row.getCell("consumeFixQty").setValue((Object)this.formatZero(rowValue.FBaseQty));
            row.getCell("proportion").setValue((Object)this.formatZero(rowValue.FProportion));
            row.getCell("scrapRatio").setValue((Object)this.formatZero(rowValue.FScrapRatio));
            row.getCell("effectiveDate").setValue((Object)rowValue.FEffectiveDate);
            row.getCell("disableDate").setValue((Object)rowValue.FDisableDate);
            enumName = this.getAlias(MaterialProductEnum.class, Integer.parseInt(rowValue.FOutputType));
            row.getCell("outputType").setValue((Object)enumName);
            enumName = this.getAlias(MaterialCharEnum.class, Integer.parseInt(rowValue.FMaterialChar));
            row.getCell("materialChara").setValue((Object)enumName);
            enumName = this.getAlias(MaterialIssueModeEnum.class, Integer.parseInt(rowValue.FIssMode));
            row.getCell("pickingMode").setValue((Object)enumName);
            row.getCell("defaultWarehouseName").setValue((Object)rowValue.FDEFAULTWAREHOUSENAME);
            row.getCell("location").setValue((Object)rowValue.location);
            row.getCell("parentProductQty").setValue((Object)rowValue.FParentComsumeQty);
            row.getCell("BOMNumber").setValue((Object)rowValue.Fnumber);
            row.getCell("BOMName").setValue((Object)rowValue.FBomName);
            row.getCell("showTrack").setValue((Object)rowValue.showTrack);
            row.getCell("netWeight").setValue((Object)this.formatZero(rowValue.netWeight));
            row.getCell("blkSize").setValue((Object)rowValue.blkSize);
            row.getCell("specifiedLength").setValue((Object)rowValue.specifiedLength);
            row.getCell("usedUnit").setValue((Object)rowValue.usedUnit);
            row.getCell("designUnit").setValue((Object)rowValue.designUnit);
            row.getCell("designRemark").setValue((Object)rowValue.designRemark);
            row.getCell("feture").setValue((Object)Boolean.valueOf(rowValue.feture));
            row.getCell("canSelected").setValue((Object)Boolean.valueOf(rowValue.canSelected));
            row.getCell("firstCfg").setValue((Object)Boolean.valueOf(rowValue.firstCfg));
            row.getCell("blueprint").setValue((Object)rowValue.blueprint);
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BomGroupstandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kDTable1, (int)this.freezeColIndex);
    }

    class RowValue4ManySearch {
        String fid = "";
        String FLevel = "";
        String FMaterialNumber = "";
        String FMaterialName = "";
        String FModel = "";
        String FMaterialAttr = "";
        String FConsumeType = "";
        String FBaseQty = "";
        String FProportion = "";
        String FParentComsumeQty = "";
        String FUnitname = "";
        String FScrapRatio = "";
        String FEffectiveDate = "";
        String FDisableDate = "";
        String FMaterialChar = "";
        String FIssMode = "";
        String FOutputType = "";
        String FDEFAULTWAREHOUSENAME = "";
        String Fnumber = "";
        String FBomName = "";
        String bomId = "";
        String parentBomId = "";
        String showTrack = "";
        String netWeight = "";
        String blkSize = "";
        String specifiedLength = "";
        String usedUnit = "";
        String designUnit = "";
        String designRemark = "";
        String feture = "";
        String canSelected = "";
        String firstCfg = "";
        String location = "";
        String blueprint = "";

        RowValue4ManySearch() {
        }

        public boolean equals(Object anotherRow) {
            RowValue4ManySearch bRow = (RowValue4ManySearch)anotherRow;
            if (bRow == null) {
                return false;
            }
            return this.FMaterialNumber.equals(bRow.FMaterialNumber) && this.parentBomId.equals(bRow.parentBomId) && this.FLevel.equals(bRow.FLevel);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    class Tree {
        Map parentChildrenMap = null;
        Map bomMap = null;
        List topLevelList = null;

        Tree() {
        }
    }

    class RowValue {
        String materialNumber = "";
        String materialName = "";
        String model = "";
        String unit = "";
        String materialAttr = "";
        String consumeType = "";
        BigDecimal baseQty = null;
        String proportion = "";
        String scrapRatio = "";
        String effectiveDate = "";
        String disableDate = "";
        int outputType = 0;
        int materialChar = 0;
        int issMode = 0;
        String defaultWarehouseName = "";
        String level = "";
        String bomId = "";
        String parentBomId = "";
        String bomName = "";
        String parentComsumeQty = "";
        String bomNumber = "";
        int qtyPrecision = 4;

        RowValue() {
        }

        public boolean equals(Object anatherRow) {
            RowValue bRow = (RowValue)anatherRow;
            if (bRow == null) {
                return false;
            }
            return this.materialNumber.equals(bRow.materialNumber) && this.parentBomId.equals(bRow.parentBomId);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

