/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.mm.basedata.BOMSearchFlagEnum;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BomExtendSearchPrintDataProvider
extends AbstractPrintDataProvider {
    private Map resultMap = null;
    private BOMSearchFlagEnum queryType = null;
    private KDTable bomListTable = null;
    private KDTable resultTable = null;
    private static final BigDecimal ZERO = new BigDecimal("0");

    public BomExtendSearchPrintDataProvider(Map resultMap, BOMSearchFlagEnum queryType, KDTable bomListTable, KDTable resultTable) {
        this.resultMap = resultMap;
        this.queryType = queryType;
        this.bomListTable = bomListTable;
        this.resultTable = resultTable;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        int k;
        DynamicRowSet dynamicRowSet = null;
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        int loop = 0;
        KDTHead head = this.bomListTable.getHead();
        ArrayList headList = head.getRow(0).getCells();
        head = this.resultTable.getHead();
        ArrayList resultHeadList = head.getRow(0).getCells();
        ArrayList<String> cellKeyList = new ArrayList<String>();
        int count1 = headList.size();
        for (k = 0; k < count1; ++k) {
            cellKeyList.add(this.bomListTable.getColumn(k).getKey());
            ++loop;
        }
        count1 = resultHeadList.size();
        for (k = 0; k < count1; ++k) {
            if (BOMSearchFlagEnum.MultilevelSearch == this.queryType && (!this.resultTable.getColumn(k).getStyleAttributes().isHided() || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("levelNo") || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMNumber") || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMName") || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("parentProductQty"))) {
                if (this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMNumber")) {
                    cellKeyList.add("childBOMNumber");
                } else if (this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMName")) {
                    cellKeyList.add("childBOMName");
                } else {
                    cellKeyList.add(this.resultTable.getColumn(k).getKey());
                }
                ++loop;
                continue;
            }
            if (this.resultTable.getColumn(k).getStyleAttributes().isHided()) continue;
            cellKeyList.add(this.resultTable.getColumn(k).getKey());
            ++loop;
        }
        int columnCount = loop;
        dynamicRowSet = new DynamicRowSet(loop);
        ColInfo ciId = null;
        for (int i = 0; i < loop; ++i) {
            ciId = new ColInfo((String)cellKeyList.get(i), (String)cellKeyList.get(i), 12, null);
            dynamicRowSet.setColInfo(i + 1, ciId);
        }
        IRow bomRow = null;
        List bomList = null;
        int count = this.bomListTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            bomRow = this.bomListTable.getRow(i);
            IRowSet rowSet = (IRowSet)this.resultMap.get(new Integer(i));
            if (null == rowSet || 0 == rowSet.size()) {
                int ii;
                dynamicRowSet.moveToInsertRow();
                loop = 0;
                int count12 = this.bomListTable.getColumnCount();
                for (int k2 = 0; k2 < count12; ++k2) {
                    if (this.bomListTable.getColumn(k2).getStyleAttributes().isHided() && !this.bomListTable.getColumn(k2).getKey().equalsIgnoreCase("bomid")) continue;
                    if (bomRow.getCell(k2).getValue() instanceof Date) {
                        dynamicRowSet.updateString(++loop, dtformat.format((Date)bomRow.getCell(k2).getValue()));
                        continue;
                    }
                    dynamicRowSet.updateString(++loop, (String)bomRow.getCell(k2).getValue());
                }
                if (BOMSearchFlagEnum.SampleSearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 15) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.ManySearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 19) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.MutliSraech == this.queryType) {
                    ii = 0;
                    while (ii++ < 6) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.IntegratedSearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 6) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.MultilevelSearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 19) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                }
                dynamicRowSet.insertRow();
                continue;
            }
            if (BOMSearchFlagEnum.MultilevelSearch == this.queryType) {
                bomList = this.getRowValue4ManySearchList(rowSet);
                this.fillTableRow4ManySearch(bomList, dynamicRowSet, bomRow, columnCount);
                continue;
            }
            String enumName = null;
            while (rowSet.next()) {
                BigDecimal bd;
                dynamicRowSet.moveToInsertRow();
                loop = 0;
                while (loop < columnCount) {
                    dynamicRowSet.updateString(++loop, null);
                }
                dynamicRowSet.updateString("storageOrgUnitNumber", (String)bomRow.getCell("storageOrgUnitNumber").getValue());
                if (bomRow.getCell("queryDate").getValue() != null) {
                    dynamicRowSet.updateString("queryDate", dtformat.format((Date)bomRow.getCell("queryDate").getValue()));
                } else {
                    dynamicRowSet.updateString("queryDate", null);
                }
                dynamicRowSet.updateString("searchType", (String)bomRow.getCell("searchType").getValue());
                dynamicRowSet.updateString("parentMaterialNumber", (String)bomRow.getCell("parentMaterialNumber").getValue());
                dynamicRowSet.updateString("parentMaterialName", (String)bomRow.getCell("parentMaterialName").getValue());
                dynamicRowSet.updateString("parentMaterialModel", (String)bomRow.getCell("parentMaterialModel").getValue());
                dynamicRowSet.updateString("productQty", this.formatZero((String)bomRow.getCell("productQty").getValue()));
                dynamicRowSet.updateString("parentMaterialUnit", (String)bomRow.getCell("parentMaterialUnit").getValue());
                dynamicRowSet.updateString("parentMaterialAttr", (String)bomRow.getCell("parentMaterialAttr").getValue());
                dynamicRowSet.updateString("bomGroup", (String)bomRow.getCell("bomGroup").getValue());
                dynamicRowSet.updateString("BOMNumber", (String)bomRow.getCell("BOMNumber").getValue());
                dynamicRowSet.updateString("BOMType", (String)bomRow.getCell("BOMType").getValue());
                dynamicRowSet.updateString("BOMUsage", (String)bomRow.getCell("BOMUsage").getValue());
                dynamicRowSet.updateString("BOMID", (String)bomRow.getCell("BOMID").getValue());
                if (BOMSearchFlagEnum.SampleSearch == this.queryType) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("MATERIALNUMBER"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("MATERIALNAME"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("MATERIALMODE"));
                    enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("MATERIALATTR"));
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    enumName = UIHelper.getAlias(ConsumeTypeEnum.class, (int)rowSet.getInt("CONSUMETYPE"));
                    dynamicRowSet.updateString("consumeType", enumName);
                    dynamicRowSet.updateString("consumeFixQty", this.formatZero(rowSet.getString("CONSUMEFIXQTY")));
                    dynamicRowSet.updateString("proportion", this.formatZero(rowSet.getString("PROPORTION")));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("UNITNAME"));
                    dynamicRowSet.updateString("scrapRatio", this.formatZero(rowSet.getString("SCRAPRATIO")));
                    dynamicRowSet.updateString("effectiveDate", rowSet.getString("EFFECTIVEDATE"));
                    dynamicRowSet.updateString("disableDate", rowSet.getString("DISABLEDATE"));
                    enumName = UIHelper.getAlias(MaterialProductEnum.class, (int)rowSet.getInt("OUTPUTTYPE"));
                    dynamicRowSet.updateString("outputType", enumName);
                    enumName = UIHelper.getAlias(MaterialCharEnum.class, (int)rowSet.getInt("MATERIALCHAR"));
                    dynamicRowSet.updateString("materialChara", enumName);
                    enumName = UIHelper.getAlias(MaterialIssueModeEnum.class, (int)rowSet.getInt("ISSMODE"));
                    dynamicRowSet.updateString("pickingMode", enumName);
                    dynamicRowSet.updateString("defaultWarehouseName", rowSet.getString("DEFAULTWAREHOUSENAME"));
                } else if (BOMSearchFlagEnum.ManySearch.equals((Object)this.queryType)) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("MATERIALNUMBER"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("MaterialName"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("MATERIALMODE"));
                    enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("MATERIALATTR"));
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    enumName = UIHelper.getAlias(ConsumeTypeEnum.class, (int)rowSet.getInt("ConsumeType"));
                    dynamicRowSet.updateString("consumeType", enumName);
                    dynamicRowSet.updateString("consumeFixQty", this.formatZero(rowSet.getString("CONSUMEFIXQTY")));
                    dynamicRowSet.updateString("proportion", this.formatZero(rowSet.getString("proportion")));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("UNITNAME"));
                    dynamicRowSet.updateString("scrapRatio", this.formatZero(rowSet.getString("ScrapRatio")));
                    dynamicRowSet.updateString("effectiveDate", rowSet.getString("EffectiveDate"));
                    dynamicRowSet.updateString("disableDate", rowSet.getString("DisableDate"));
                    enumName = UIHelper.getAlias(MaterialProductEnum.class, (int)rowSet.getInt("OutputType"));
                    dynamicRowSet.updateString("outputType", enumName);
                    enumName = UIHelper.getAlias(MaterialCharEnum.class, (int)rowSet.getInt("MaterialChar"));
                    dynamicRowSet.updateString("materialChara", enumName);
                    enumName = UIHelper.getAlias(MaterialIssueModeEnum.class, (int)rowSet.getInt("IssMode"));
                    dynamicRowSet.updateString("pickingMode", enumName);
                    dynamicRowSet.updateString("defaultWarehouseName", rowSet.getString("DefaultWarehouseName"));
                } else if (BOMSearchFlagEnum.MutliSraech == this.queryType) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("FMaterialNumber"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("FMaterialName"));
                    dynamicRowSet.updateString("blueprint", rowSet.getString("FBlueprint"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("FModel"));
                    enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("FMaterialAttr"));
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    bd = rowSet.getBigDecimal("FBaseQty");
                    bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
                    dynamicRowSet.updateString("childConsumeQty", this.formatZero(bd.toString()));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("FUnitname"));
                } else if (BOMSearchFlagEnum.IntegratedSearch == this.queryType) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("FMaterialNumber"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("FMaterialName"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("FModel"));
                    enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("FMaterialAttr"));
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    bd = rowSet.getBigDecimal("FBaseQty");
                    bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
                    dynamicRowSet.updateString("childConsumeQty", this.formatZero(bd.toString()));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("FUnitname"));
                }
                dynamicRowSet.insertRow();
            }
        }
        return dynamicRowSet;
    }

    private String getLevelStr(String level) {
        if (level.equals("1")) {
            return "*" + level;
        }
        if (level.equals("2")) {
            return "**" + level;
        }
        if (level.equals("3")) {
            return "***" + level;
        }
        if (level.equals("4")) {
            return "****" + level;
        }
        if (level.equals("5")) {
            return "*****" + level;
        }
        if (level.equals("6")) {
            return "******" + level;
        }
        if (level.equals("7")) {
            return "*******" + level;
        }
        return "********" + level;
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }

    private List getRowValue4ManySearchList(IRowSet rowSet) throws SQLException {
        ArrayList<RowValue4ManySearch> rst = new ArrayList<RowValue4ManySearch>();
        RowValue4ManySearch row = null;
        while (rowSet.next()) {
            row = new RowValue4ManySearch();
            row.Fid = rowSet.getString("fid");
            row.FMaterialNumber = rowSet.getString("FMaterialNumber");
            row.FMaterialName = rowSet.getString("FMaterialName");
            row.FModel = rowSet.getString("FModel");
            row.FUnitname = rowSet.getString("FUnitname");
            row.FMaterialAttr = rowSet.getString("FMaterialAttr");
            row.FBaseQty = rowSet.getString("FBaseQty");
            row.FLevel = rowSet.getString("FLevel");
            row.FConsumeType = rowSet.getString("FConsumeType");
            row.FProportion = rowSet.getString("FProportion");
            row.FParentComsumeQty = rowSet.getString("FParentComsumeQty");
            row.FScrapRatio = rowSet.getString("FScrapRatio");
            row.FEffectiveDate = rowSet.getString("FEffectiveDate");
            row.FDisableDate = rowSet.getString("FDisableDate");
            row.FMaterialChar = rowSet.getString("FMaterialChar");
            row.FIssMode = rowSet.getString("FIssMode");
            row.FOutputType = rowSet.getString("FOutputType");
            row.FDEFAULTWAREHOUSENAME = rowSet.getString("FDEFAULTWAREHOUSENAME");
            row.location = rowSet.getString("location");
            row.Fnumber = rowSet.getString("Fnumber");
            row.FBomName = rowSet.getString("FBomName");
            row.bomId = rowSet.getString("FBomId");
            row.parentBomId = rowSet.getString("FParentBomId");
            row.FBlueprint = rowSet.getString("FBlueprint");
            rst.add(row);
        }
        return rst;
    }

    private void fillTableRow4ManySearch(List bomList, DynamicRowSet dynamicRowSet, IRow bomRow, int columnCount) throws Exception {
        Iterator it = bomList.iterator();
        String enumName = null;
        int loop = 0;
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        while (it.hasNext()) {
            dynamicRowSet.moveToInsertRow();
            loop = 0;
            while (loop < columnCount) {
                dynamicRowSet.updateString(++loop, null);
            }
            dynamicRowSet.updateString("storageOrgUnitNumber", (String)bomRow.getCell("storageOrgUnitNumber").getValue());
            dynamicRowSet.updateString("queryDate", dtformat.format((Date)bomRow.getCell("queryDate").getValue()));
            dynamicRowSet.updateString("searchType", (String)bomRow.getCell("searchType").getValue());
            dynamicRowSet.updateString("parentMaterialNumber", (String)bomRow.getCell("parentMaterialNumber").getValue());
            dynamicRowSet.updateString("parentMaterialName", (String)bomRow.getCell("parentMaterialName").getValue());
            dynamicRowSet.updateString("parentMaterialModel", (String)bomRow.getCell("parentMaterialModel").getValue());
            dynamicRowSet.updateString("productQty", this.formatZero((String)bomRow.getCell("productQty").getValue()));
            dynamicRowSet.updateString("parentMaterialUnit", (String)bomRow.getCell("parentMaterialUnit").getValue());
            dynamicRowSet.updateString("parentMaterialAttr", (String)bomRow.getCell("parentMaterialAttr").getValue());
            dynamicRowSet.updateString("bomGroup", (String)bomRow.getCell("bomGroup").getValue());
            dynamicRowSet.updateString("BOMNumber", (String)bomRow.getCell("BOMNumber").getValue());
            dynamicRowSet.updateString("BOMType", (String)bomRow.getCell("BOMType").getValue());
            dynamicRowSet.updateString("BOMUsage", (String)bomRow.getCell("BOMUsage").getValue());
            dynamicRowSet.updateString("BOMID", (String)bomRow.getCell("BOMID").getValue());
            RowValue4ManySearch rowValue = (RowValue4ManySearch)it.next();
            dynamicRowSet.updateString("levelNo", this.getLevelStr(rowValue.FLevel));
            dynamicRowSet.updateString("childMaterialNumber", rowValue.FMaterialNumber);
            dynamicRowSet.updateString("childMaterialName", rowValue.FMaterialName);
            dynamicRowSet.updateString("childMaterialModel", rowValue.FModel);
            enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)Integer.parseInt(rowValue.FMaterialAttr));
            dynamicRowSet.updateString("childMaterialAttr", enumName);
            enumName = UIHelper.getAlias(ConsumeTypeEnum.class, (int)Integer.parseInt(rowValue.FConsumeType));
            dynamicRowSet.updateString("consumeType", enumName);
            dynamicRowSet.updateString("consumeFixQty", this.formatZero(rowValue.FBaseQty));
            dynamicRowSet.updateString("proportion", this.formatZero(rowValue.FProportion));
            dynamicRowSet.updateString("parentProductQty", this.formatZero(rowValue.FParentComsumeQty));
            dynamicRowSet.updateString("childMaterialUnit", rowValue.FUnitname);
            dynamicRowSet.updateString("scrapRatio", this.formatZero(rowValue.FScrapRatio));
            dynamicRowSet.updateString("effectiveDate", rowValue.FEffectiveDate);
            dynamicRowSet.updateString("disableDate", rowValue.FDisableDate);
            enumName = UIHelper.getAlias(MaterialProductEnum.class, (int)Integer.parseInt(rowValue.FOutputType));
            dynamicRowSet.updateString("outputType", enumName);
            enumName = UIHelper.getAlias(MaterialCharEnum.class, (int)Integer.parseInt(rowValue.FMaterialChar));
            dynamicRowSet.updateString("materialChara", enumName);
            enumName = UIHelper.getAlias(MaterialIssueModeEnum.class, (int)Integer.parseInt(rowValue.FIssMode));
            dynamicRowSet.updateString("pickingMode", enumName);
            dynamicRowSet.updateString("defaultWarehouseName", rowValue.FDEFAULTWAREHOUSENAME);
            dynamicRowSet.updateString("location", rowValue.location);
            dynamicRowSet.updateString("childBOMNumber", rowValue.Fnumber);
            dynamicRowSet.updateString("childBOMName", rowValue.FBomName);
            dynamicRowSet.updateString("blueprint", rowValue.FBlueprint);
            dynamicRowSet.insertRow();
        }
    }

    class Tree {
        Map parentChildrenMap = null;
        Map bomMap = null;
        List topLevelList = null;

        Tree() {
        }
    }

    class RowValue4ManySearch {
        String Fid = "";
        String FLevel = "";
        String FMaterialNumber = "";
        String FMaterialName = "";
        String FModel = "";
        String FMaterialAttr = "";
        String FConsumeType = "";
        String FBaseQty = "";
        String FProportion = "";
        String FParentComsumeQty = "";
        String FUnitname = "";
        String FScrapRatio = "";
        String FEffectiveDate = "";
        String FDisableDate = "";
        String FMaterialChar = "";
        String FIssMode = "";
        String FOutputType = "";
        String FDEFAULTWAREHOUSENAME = "";
        String location = "";
        String Fnumber = "";
        String FBomName = "";
        String bomId = "";
        String parentBomId = "";
        String FBlueprint = "";

        RowValue4ManySearch() {
        }

        public boolean equals(Object anotherRow) {
            RowValue4ManySearch bRow = (RowValue4ManySearch)anotherRow;
            if (bRow == null) {
                return false;
            }
            return this.FMaterialNumber.equals(bRow.FMaterialNumber) && this.parentBomId.equals(bRow.parentBomId) && this.FLevel.equals(bRow.FLevel);
        }
    }
}

