/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.scm.common.util.SCMCommonDataProvider;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BomPrintDataProvider
extends SCMCommonDataProvider {
    public BomPrintDataProvider(List id, IMetaDataPK qpk) {
        super(id, qpk);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = super.execute(ds);
        try {
            IBom bom = BomFactory.getRemoteInstance();
            Map resultMap = null;
            boolean flag = true;
            while (iRowSet.next()) {
                String bomType = iRowSet.getString("bomType");
                if (BOMTypeEnum.MfgBOM.getAlias().equals(bomType)) {
                    return iRowSet;
                }
                if (flag) {
                    String bomId = iRowSet.getString("id");
                    HashSet<String> bomIdSet = new HashSet<String>();
                    bomIdSet.add(bomId);
                    resultMap = bom.getCfgBomTracks(bomIdSet);
                }
                String entryId = iRowSet.getString("entrys.id");
                iRowSet.updateObject("entrys.showTrack", (Object)this.getTrackNumbers(resultMap, entryId));
                flag = false;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
        }
        return iRowSet;
    }

    private String getTrackNumbers(Map map, String entryId) {
        if (map == null || entryId == null) {
            return null;
        }
        List trackNumberList = (List)map.get(entryId);
        if (trackNumberList == null || trackNumberList.size() == 0) {
            return null;
        }
        HashSet<String> trackNumberSet = new HashSet<String>();
        TrackNumberInfo trackNumberInfo = null;
        for (int i = 0; i < trackNumberList.size(); ++i) {
            trackNumberInfo = (TrackNumberInfo)trackNumberList.get(i);
            if (trackNumberInfo == null || !MMUtils.isNotEmptyString((String)trackNumberInfo.getNumber())) continue;
            trackNumberSet.add(trackNumberInfo.getNumber());
        }
        return MMUtils.setToString(trackNumberSet, (String)";");
    }
}

