/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.invokecounter.RPCInvokeCounter;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMFacadeFactory;
import com.kingdee.eas.mm.basedata.BomSubstituteCollection;
import com.kingdee.eas.mm.basedata.BomSubstituteInfo;
import com.kingdee.eas.mm.basedata.IMaterialReplaceEntry;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryFactory;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryInfo;
import com.kingdee.eas.mm.basedata.client.AbstractBomSubstituteEditUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.LongtimeIndicator;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BomSubstituteEditUI
extends AbstractBomSubstituteEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BomSubstituteEditUI.class);
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";
    private static final String TB_SUBSTITUTESEQ = "substituteSeq";
    private static final String TB_SUBSTITUTEMATERIAL = "substituteMaterial";
    private static final String TB_SUBSTITUTEMATERIALNAME = "substituteMaterialName";
    private static final String TB_SUBSTITUTEMEATERIALMODE = "substituteMaterialMode";
    private static final String TB_SUBSTITUTEUNIT = "substituteUnit";
    private static final String TB_SUBSTITUTEQTY = "substituteQty";
    private static final String TB_SUBSTITUTEPROPORTION = "substituteProportion";
    private static final String TB_EFFECTIVEDATE = "effectiveDate";
    private static final String TB_INVALIDDATE = "invalidDate";
    private Timestamp serverDate = null;
    private StorageOrgUnitInfo sou = null;
    private DataChangeListener prmtMaterialListener = null;
    private KDTEditAdapter entryTableChange = null;
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
    KDBizPromptBox bizMaterialBox = null;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private String materialID = "";
    private static final String[] KDT_DATES = new String[]{"effectiveDate", "invalidDate"};

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        IRow row = null;
        row = this.kdtSubstituteEntry.addRow();
        BomSubstituteInfo info = new BomSubstituteInfo();
        info.setSubstituteSeq(1);
        this.fillupTableRow(row, info);
        this.set2Dates(row);
    }

    public void onLoad() throws Exception {
        Boolean canedit;
        super.onLoad();
        this.kdtSubstituteEntry.getActionMap().remove("Paste");
        this.kdtSubstituteEntry.getActionMap().remove("Cut");
        if (this.isFirstOnload()) {
            this.serverDate = SCMClientUtils.getServerDate();
            this.sou = (StorageOrgUnitInfo)this.getUIContext().get("sou");
            this.materialID = (String)this.getUIContext().get("materialID");
        }
        this.kdtSubstituteEntry.getColumn(TB_INVALIDDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtSubstituteEntry.getColumn(TB_EFFECTIVEDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        BomSubstituteCollection oldCollection = (BomSubstituteCollection)((Object)this.getUIContext().get("oldCollection"));
        if (null != oldCollection) {
            ArrayList list = new ArrayList();
            StringBuffer sqlWhere = new StringBuffer();
            BomSubstituteInfo info = null;
            IRow row = null;
            int size = oldCollection.size();
            for (int i = 0; i < size; ++i) {
                info = oldCollection.get(i);
                row = this.kdtSubstituteEntry.addRow();
                row.setUserObject((Object)info);
                this.fillupTableRow(row, info);
                if (null == info.getSubstituteMaterial() || null == info.getSubstituteMaterial().getId() || null == info.getSubstituteUnit() || null == info.getSubstituteUnit().getId()) continue;
                if (sqlWhere.length() > 0) {
                    sqlWhere.append(" or ");
                }
                sqlWhere.append(" (material.id = '").append(info.getSubstituteMaterial().getId().toString()).append("' and measureUnit.id = '").append(info.getSubstituteUnit().getId().toString()).append("' ) ");
            }
            if (sqlWhere.length() > 0) {
                MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(" where " + sqlWhere.toString());
                String materialId = null;
                String unitId = null;
                int precision = 0;
                int count = mmuc.size();
                for (int i = 0; i < count; ++i) {
                    materialId = mmuc.get(i).getMaterial().getId().toString();
                    unitId = mmuc.get(i).getMeasureUnit().getId().toString();
                    precision = mmuc.get(i).getQtyPrecision();
                    if (null == materialId || null == unitId) continue;
                    int count1 = this.kdtSubstituteEntry.getRowCount();
                    for (int k = 0; k < count1; ++k) {
                        row = this.kdtSubstituteEntry.getRow(k);
                        if (null == (MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue() || null == (MeasureUnitInfo)row.getCell(TB_SUBSTITUTEUNIT).getValue() || !materialId.equals(((MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue()).getId().toString()) || !unitId.equals(((MeasureUnitInfo)row.getCell(TB_SUBSTITUTEUNIT).getValue()).getId().toString())) continue;
                        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.kdtSubstituteEntry, (String[])new String[]{TB_SUBSTITUTEQTY}, (int)k);
                    }
                }
            }
        }
        if (!(canedit = (Boolean)this.getUIContext().get("canedit")).booleanValue()) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionDeleteLine.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.kdtSubstituteEntry.setEditable(false);
            this.actionFindSubstituteMaterial.setEnabled(false);
            return;
        }
        this.actionAddLine.setEnabled(true);
        this.actionInsertLine.setEnabled(true);
        this.actionDeleteLine.setEnabled(true);
        this.actionSave.setEnabled(true);
        this.kdtSubstituteEntry.setEditable(true);
        this.actionFindSubstituteMaterial.setEnabled(true);
        this.initF7MaterialBox(this.sou);
        this.f7Manager.registerMeasureUnitF7(this.kdtSubstituteEntry, TB_SUBSTITUTEMATERIAL, TB_SUBSTITUTEUNIT);
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BomSubstituteEditUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    BomSubstituteEditUI.this.handUIException(exc);
                }
            }
        };
        this.kdtSubstituteEntry.addKDTEditListener((KDTEditListener)this.entryTableChange);
        EditTableUtil.formatColDate((KDTable)this.kdtSubstituteEntry, (String[])KDT_DATES);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        BigDecimal qty;
        BigDecimal proportion;
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtSubstituteEntry.getColumnKey(colIndex);
        if (TB_SUBSTITUTEUNIT.equalsIgnoreCase(fieldName)) {
            if (null != this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEMATERIAL)) {
                this.measureUnitChange(rowIndex, (MaterialInfo)this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEMATERIAL).getValue(), (MeasureUnitInfo)newValue);
            }
        } else if (TB_EFFECTIVEDATE.equalsIgnoreCase(fieldName) || TB_INVALIDDATE.equalsIgnoreCase(fieldName)) {
            Date effectiveDate = (Date)this.kdtSubstituteEntry.getCell(rowIndex, TB_EFFECTIVEDATE).getValue();
            Date disableDate = (Date)this.kdtSubstituteEntry.getCell(rowIndex, TB_INVALIDDATE).getValue();
            if (effectiveDate != null && disableDate != null && effectiveDate.compareTo(disableDate) >= 0) {
                MsgBox.showError((String)EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.sub2date.bigger"));
                return;
            }
        } else if (TB_SUBSTITUTEQTY.equalsIgnoreCase(fieldName)) {
            BigDecimal proportion2;
            BigDecimal qty2 = (BigDecimal)this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEQTY).getValue();
            if (null != qty2 && null != (proportion2 = (BigDecimal)this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEPROPORTION).getValue())) {
                MsgBox.showError((String)EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subcontent.onlyone"));
                this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEQTY).setValue(null);
                this.kdtSubstituteEntry.getEditManager().editCellAt(rowIndex, colIndex);
            }
        } else if (TB_SUBSTITUTEPROPORTION.equalsIgnoreCase(fieldName) && null != (proportion = (BigDecimal)this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEPROPORTION).getValue()) && null != (qty = (BigDecimal)this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEQTY).getValue())) {
            MsgBox.showError((String)EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subcontent.onlyone"));
            this.kdtSubstituteEntry.getCell(rowIndex, TB_SUBSTITUTEPROPORTION).setValue(null);
            this.kdtSubstituteEntry.getEditManager().editCellAt(rowIndex, colIndex);
        }
    }

    private void measureUnitChange(int rowIndex, MaterialInfo matInfo, MeasureUnitInfo unitInfo) {
        if (matInfo != null && unitInfo != null) {
            int precision = 2;
            MultiMeasureUnitInfo measureUnitInfo = null;
            try {
                measureUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(matInfo.getId().toString(), unitInfo.getId().toString());
            }
            catch (EASBizException e) {
                logger.error((Object)("error in set precision " + (Object)((Object)e)));
            }
            catch (BOSException e) {
                logger.error((Object)("error in set precision " + (Object)((Object)e)));
            }
            if (measureUnitInfo != null) {
                precision = measureUnitInfo.getQtyPrecision();
            }
            SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.kdtSubstituteEntry, (String[])new String[]{TB_SUBSTITUTEQTY}, (int)rowIndex);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kdtSubstituteEntry.checkParsed();
        KDBizPromptBox bizPromptMeasureUnit = new KDBizPromptBox();
        bizPromptMeasureUnit.setEditable(true);
        bizPromptMeasureUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        bizPromptMeasureUnit.setDisplayFormat("$name$");
        bizPromptMeasureUnit.setEditFormat("$number$");
        bizPromptMeasureUnit.setCommitFormat("$number$");
        this.kdtSubstituteEntry.getColumn(TB_SUBSTITUTEUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptMeasureUnit));
        KDFormattedTextField kdtEntrys_substituteSeq_TextField = new KDFormattedTextField();
        kdtEntrys_substituteSeq_TextField.setName("kdtEntrys_substituteSeq_TextField");
        kdtEntrys_substituteSeq_TextField.setVisible(true);
        kdtEntrys_substituteSeq_TextField.setEditable(true);
        kdtEntrys_substituteSeq_TextField.setHorizontalAlignment(2);
        kdtEntrys_substituteSeq_TextField.setDataType(0);
        kdtEntrys_substituteSeq_TextField.setMinimumValue((Comparable)new Integer(1));
        KDTDefaultCellEditor kdtEntrys_leadtime_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_substituteSeq_TextField);
        this.kdtSubstituteEntry.getColumn(TB_SUBSTITUTESEQ).setEditor((ICellEditor)kdtEntrys_leadtime_CellEditor);
        KDFormattedTextField kdtEntrys_substituteQty_TextField = new KDFormattedTextField();
        kdtEntrys_substituteQty_TextField.setName("kdtEntrys_substituteQty_TextField");
        kdtEntrys_substituteQty_TextField.setVisible(true);
        kdtEntrys_substituteQty_TextField.setEditable(true);
        kdtEntrys_substituteQty_TextField.setHorizontalAlignment(2);
        kdtEntrys_substituteQty_TextField.setDataType(1);
        kdtEntrys_substituteQty_TextField.setMinimumValue((Comparable)new BigDecimal("-9999999999999.99999999"));
        kdtEntrys_substituteQty_TextField.setMaximumValue((Comparable)new BigDecimal("9999999999999.99999999"));
        kdtEntrys_substituteQty_TextField.setPrecision(8);
        kdtEntrys_substituteQty_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_consumeFixBaseQty_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_substituteQty_TextField);
        this.kdtSubstituteEntry.getColumn(TB_SUBSTITUTEQTY).setEditor((ICellEditor)kdtEntrys_consumeFixBaseQty_CellEditor);
        KDFormattedTextField kdtEntrys_substituteProportion_TextField = new KDFormattedTextField();
        kdtEntrys_substituteProportion_TextField.setName("kdtEntrys_substituteProportion_TextField");
        kdtEntrys_substituteProportion_TextField.setVisible(true);
        kdtEntrys_substituteProportion_TextField.setEditable(true);
        kdtEntrys_substituteProportion_TextField.setHorizontalAlignment(2);
        kdtEntrys_substituteProportion_TextField.setDataType(1);
        kdtEntrys_substituteProportion_TextField.setMinimumValue((Comparable)new BigDecimal("0"));
        kdtEntrys_substituteProportion_TextField.setPrecision(2);
        kdtEntrys_substituteProportion_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor kdtEntrys_proportion_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_substituteProportion_TextField);
        this.kdtSubstituteEntry.getColumn(TB_SUBSTITUTEPROPORTION).setEditor((ICellEditor)kdtEntrys_proportion_CellEditor);
        KDDatePicker kdtEntrys_effectiveDate_DatePicker = new KDDatePicker();
        kdtEntrys_effectiveDate_DatePicker.setName("kdtSubstituteEntry_effectiveDate_DatePicker");
        kdtEntrys_effectiveDate_DatePicker.setVisible(true);
        kdtEntrys_effectiveDate_DatePicker.setEditable(true);
        KDTDefaultCellEditor kdtEntrys_effectiveDate_CellEditor = new KDTDefaultCellEditor(kdtEntrys_effectiveDate_DatePicker);
        this.kdtSubstituteEntry.getColumn(TB_EFFECTIVEDATE).setEditor((ICellEditor)kdtEntrys_effectiveDate_CellEditor);
        KDDatePicker kdtEntrys_disableDate_DatePicker = new KDDatePicker();
        kdtEntrys_disableDate_DatePicker.setName("kdtSubstituteEntry_invalidDate_DatePicker");
        kdtEntrys_disableDate_DatePicker.setVisible(true);
        kdtEntrys_disableDate_DatePicker.setEditable(true);
        KDTDefaultCellEditor kdtEntrys_disableDate_CellEditor = new KDTDefaultCellEditor(kdtEntrys_disableDate_DatePicker);
        this.kdtSubstituteEntry.getColumn(TB_INVALIDDATE).setEditor((ICellEditor)kdtEntrys_disableDate_CellEditor);
        ObjectValueRender kdtEntrys_materialNumber_OVR = new ObjectValueRender();
        kdtEntrys_materialNumber_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtSubstituteEntry.getColumn(TB_SUBSTITUTEMATERIAL).setRenderer((IBasicRender)kdtEntrys_materialNumber_OVR);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.findSubstituteMaterial.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_takedisplacemateriel", (Locale)this.getLocale()));
    }

    private void initF7MaterialBox(StorageOrgUnitInfo orgInfo) {
        IColumn col = this.kdtSubstituteEntry.getColumn(TB_SUBSTITUTEMATERIAL);
        this.bizMaterialBox = new KDBizPromptBox();
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.prmtMaterialListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BomSubstituteEditUI.this.materialChanged(eventObj);
            }
        };
        this.bizMaterialBox.addDataChangeListener(this.prmtMaterialListener);
        this.f7Manager.registerBizMaterialF7(this.bizMaterialBox, col, materialPlanQuery, (OrgUnitInfo)orgInfo, true);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.materialID, CompareType.NOTEQUALS));
        this.bizMaterialBox.getEntityViewInfo().setFilter(filterInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void materialChanged(DataChangeEvent e) {
        block15: {
            try {
                final KDBizPromptBox bizMaterialBox = (KDBizPromptBox)e.getSource();
                KDTable tb = this.kdtSubstituteEntry;
                KDTSelectBlock selected = tb.getSelectManager().get();
                if (selected == null) {
                    return;
                }
                final int selectedRow = selected.getBeginRow();
                if (bizMaterialBox.getValue() == null) {
                    return;
                }
                MaterialInfo[] materialInfos = null;
                if (bizMaterialBox.getValue() instanceof MaterialInfo[]) {
                    materialInfos = (MaterialInfo[])bizMaterialBox.getValue();
                } else if (bizMaterialBox.getValue() instanceof MaterialInfo) {
                    Object o;
                    ICell cell;
                    materialInfos = new MaterialInfo[]{(MaterialInfo)bizMaterialBox.getValue()};
                    if (selected != null && selectedRow >= 0 && (cell = tb.getRow(selectedRow).getCell(TB_SUBSTITUTEMATERIAL)) != null && (o = cell.getValue()) != null && o instanceof MaterialInfo && materialInfos[0].getId().toString().equals(((MaterialInfo)o).getId().toString())) {
                        return;
                    }
                } else if (bizMaterialBox.getValue() instanceof Object[]) {
                    Object[] objects = (Object[])bizMaterialBox.getValue();
                    if (objects.length == 0) {
                        return;
                    }
                    materialInfos = new MaterialInfo[objects.length];
                    System.arraycopy(objects, 0, materialInfos, 0, objects.length);
                } else {
                    return;
                }
                if (materialInfos.length >= 5) {
                    LongtimeIndicator waiting = new LongtimeIndicator();
                    final MaterialInfo[] materialInfosFinal = materialInfos;
                    waiting.letMeDo(new ILongTimeTask(){

                        public Object exec() throws Exception {
                            String classFullName = BomSubstituteEditUI.this.getMetaDataPK().getFullName();
                            RPCInvokeCounter.startActionCount((String)classFullName, (String)EASResource.getString((String)BomSubstituteEditUI.BOM_RESOURCE_PATH, (String)"subsentry.submaterial.select"));
                            LowTimer timer = new LowTimer();
                            BomSubstituteEditUI.this.doMaterialChanged(bizMaterialBox, materialInfosFinal, selectedRow, BomSubstituteEditUI.TB_SUBSTITUTEMATERIAL);
                            RPCInvokeCounter.endActionCount((String)classFullName, (String)EASResource.getString((String)BomSubstituteEditUI.BOM_RESOURCE_PATH, (String)"subsentry.submaterial.select"), (long)timer.msValue());
                            return new Boolean(true);
                        }

                        public void afterExec(Object result) throws Exception {
                        }
                    });
                    waiting.doJob();
                    break block15;
                }
                this.doMaterialChanged(bizMaterialBox, materialInfos, selectedRow, TB_SUBSTITUTEMATERIAL);
            }
            catch (Exception exc) {
                this.handUIException(exc);
            }
        }
    }

    private void doMaterialChanged(KDBizPromptBox bizMaterialBox, MaterialInfo[] materialInfos, int selectedRow, String materialFieldname) throws Exception {
        KDTable table = this.kdtSubstituteEntry;
        KDTSelectBlock ksb = table.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow curRow = table.getRow(beginRow);
        int curCol = table.getColumnIndex(materialFieldname);
        bizMaterialBox.removeDataChangeListener(this.prmtMaterialListener);
        int length = materialInfos.length;
        SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)this.sou, (MaterialInfo[])materialInfos);
        if (length > 0) {
            IRow curRow2 = null;
            MaterialInfo mi = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.insertLine(beginRow + insertedRowCount);
                    needInsert = false;
                }
                mi = materialInfos[i];
                curRow2 = table.getRow(beginRow + insertedRowCount);
                if (materialInfos[i] == null) {
                    curRow2.getCell(curCol).setValue((Object)mi);
                    curRow2.getCell(curCol).setValue(null);
                    return;
                }
                curRow2.getCell(curCol).setValue(null);
                curRow2.getCell(curCol).setValue((Object)mi);
                this.kdtSubstituteEntry.getCell(beginRow + i, TB_SUBSTITUTEUNIT).setValue((Object)voResult.getMeasureUnitInfos()[i]);
                SCMClientUtils.changeTableColPrecision((Map)voResult.getMmuPrecisions(), (MaterialInfo)materialInfos[i], (MeasureUnitInfo)voResult.getMeasureUnitInfos()[i], (KDTable)this.kdtSubstituteEntry, (String[])new String[]{TB_SUBSTITUTEQTY}, (int)(beginRow + i));
                this.kdtSubstituteEntry.getCell(beginRow + i, TB_SUBSTITUTEMATERIALNAME).setValue((Object)materialInfos[i].getName());
                this.kdtSubstituteEntry.getCell(beginRow + i, TB_SUBSTITUTEMEATERIALMODE).setValue((Object)materialInfos[i].getModel());
                needInsert = true;
                ++insertedRowCount;
            }
            if (!needInsert && insertedRowCount > 0) {
                this.kdtSubstituteEntry.removeRow(beginRow + insertedRowCount);
            }
        } else {
            curRow.getCell(curCol).setValue((Object)new MaterialInfo());
            curRow.getCell(curCol).setValue(null);
        }
        bizMaterialBox.addDataChangeListener(this.prmtMaterialListener);
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteLine_actionPerformed(e);
        if (this.kdtSubstituteEntry.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = this.kdtSubstituteEntry.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.kdtSubstituteEntry.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                this.kdtSubstituteEntry.removeRow(rowIndex);
            }
            if (this.kdtSubstituteEntry.getRow(0) != null) {
                this.kdtSubstituteEntry.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        this.insertLine(-1);
    }

    private void insertLine(int i) {
        IRow row = null;
        if (i == -1) {
            if (this.kdtSubstituteEntry.getSelectManager().size() > 0) {
                int top = this.kdtSubstituteEntry.getSelectManager().get().getTop();
                row = this.isTableColumnSelected(this.kdtSubstituteEntry) ? this.kdtSubstituteEntry.addRow() : this.kdtSubstituteEntry.addRow(top);
            } else {
                row = this.kdtSubstituteEntry.addRow();
            }
        } else {
            row = this.kdtSubstituteEntry.addRow(i);
        }
        BomSubstituteInfo info = new BomSubstituteInfo();
        info.setSubstituteSeq(1);
        this.fillupTableRow(row, info);
        this.set2Dates(row);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (!this.checkBeforeSubmit()) {
            return;
        }
        int rowCount = this.kdtSubstituteEntry.getRowCount();
        if (0 == rowCount) {
            // empty if block
        }
        IRow row = null;
        BomSubstituteCollection collection = new BomSubstituteCollection();
        BomSubstituteInfo info = null;
        int seq = 1;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtSubstituteEntry.getRow(i);
            info = (BomSubstituteInfo)row.getUserObject();
            info.setSeq(seq);
            info.setSubstituteSeq((Integer)row.getCell(TB_SUBSTITUTESEQ).getValue());
            info.setSubstituteMaterial((MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue());
            info.setSubstituteUnit((MeasureUnitInfo)row.getCell(TB_SUBSTITUTEUNIT).getValue());
            info.setSubstituteQty(null == (BigDecimal)row.getCell(TB_SUBSTITUTEQTY).getValue() ? ZERO : (BigDecimal)row.getCell(TB_SUBSTITUTEQTY).getValue());
            info.setSubstituteProportion(null == (BigDecimal)row.getCell(TB_SUBSTITUTEPROPORTION).getValue() ? ZERO : (BigDecimal)row.getCell(TB_SUBSTITUTEPROPORTION).getValue());
            info.setEffectiveDate((Date)row.getCell(TB_EFFECTIVEDATE).getValue());
            info.setInvalidDate((Date)row.getCell(TB_INVALIDDATE).getValue());
            info.setIsSubstituteQty(info.getSubstituteQty().compareTo(ZERO) != 0);
            collection.add(info);
        }
        this.getUIContext().put("substituteCollection", collection);
        this.getUIContext().put("flag", "T");
        this.getUIWindow().close();
    }

    private boolean checkBeforeSubmit() {
        boolean flag = true;
        IRow row = null;
        Object info = null;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbNull = new StringBuffer();
        HashMap childMaterialsMap = new HashMap();
        HashMap<Integer, Integer> substituteSeqMap = new HashMap<Integer, Integer>();
        HashMap substituteEffectiveDateMap = new HashMap();
        HashMap substituteInvalidDateMap = new HashMap();
        HashMap substituteMaterialMap = new HashMap();
        String strNo = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_No");
        String strRow = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_Row");
        int count = this.kdtSubstituteEntry.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtSubstituteEntry.getRow(i);
            sbNull.setLength(0);
            if (null == row.getCell(TB_SUBSTITUTESEQ).getValue()) {
                this.appendStringBuffer(sbNull, EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subseq.notnull"));
            }
            if (null == row.getCell(TB_SUBSTITUTEMATERIAL).getValue()) {
                this.appendStringBuffer(sbNull, EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.submaterial.notnull"));
            }
            if (null == row.getCell(TB_SUBSTITUTEUNIT).getValue()) {
                this.appendStringBuffer(sbNull, EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subunit.notnull"));
            }
            if (null == row.getCell(TB_SUBSTITUTEQTY).getValue() && null == row.getCell(TB_SUBSTITUTEPROPORTION).getValue()) {
                this.appendStringBuffer(sbNull, EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subcontent.notnull"));
            }
            if (null == row.getCell(TB_EFFECTIVEDATE).getValue()) {
                this.appendStringBuffer(sbNull, EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subeffectivedate.notnull"));
            }
            if (null == row.getCell(TB_INVALIDDATE).getValue()) {
                this.appendStringBuffer(sbNull, EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subinvaliddate.notnull"));
            }
            if (sbNull.length() <= 0) continue;
            sb.append(strNo).append(i + 1).append(strRow).append(" ");
            sb.append(sbNull.substring(0, sbNull.length() - 1));
            sb.append(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"entrys.null"));
        }
        if (sb.length() > 0) {
            MsgBox.showWarning((String)sb.toString());
            flag = false;
        } else {
            int i;
            Integer substituteSeq = null;
            MaterialInfo mi = null;
            sb.setLength(0);
            int count2 = this.kdtSubstituteEntry.getRowCount();
            for (int i2 = 0; i2 < count2; ++i2) {
                HashSet<Object> set;
                row = this.kdtSubstituteEntry.getRow(i2);
                substituteSeq = (Integer)row.getCell(TB_SUBSTITUTESEQ).getValue();
                mi = (MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue();
                if (substituteSeqMap.containsKey(substituteSeq)) {
                    substituteSeqMap.put(substituteSeq, new Integer((Integer)substituteSeqMap.get(substituteSeq) + 1));
                } else {
                    substituteSeqMap.put(substituteSeq, new Integer(1));
                }
                if (substituteMaterialMap.containsKey(substituteSeq)) {
                    ((Set)substituteMaterialMap.get(substituteSeq)).add(mi.getId().toString());
                } else {
                    set = new HashSet<Object>();
                    set.add(mi.getId().toString());
                    substituteMaterialMap.put(substituteSeq, set);
                    set = null;
                }
                if (substituteEffectiveDateMap.containsKey(substituteSeq)) {
                    ((Set)substituteEffectiveDateMap.get(substituteSeq)).add(row.getCell(TB_EFFECTIVEDATE).getValue());
                } else {
                    set = new HashSet();
                    set.add(row.getCell(TB_EFFECTIVEDATE).getValue());
                    substituteEffectiveDateMap.put(substituteSeq, set);
                    set = null;
                }
                if (substituteInvalidDateMap.containsKey(substituteSeq)) {
                    ((Set)substituteInvalidDateMap.get(substituteSeq)).add(row.getCell(TB_INVALIDDATE).getValue());
                } else {
                    set = new HashSet();
                    set.add(row.getCell(TB_INVALIDDATE).getValue());
                    substituteInvalidDateMap.put(substituteSeq, set);
                    set = null;
                }
                if (null == (BigDecimal)row.getCell(TB_SUBSTITUTEPROPORTION).getValue()) continue;
                childMaterialsMap.put(((MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue()).getId().toString(), null);
            }
            String[] childMaterials = childMaterialsMap.keySet().toArray(new String[0]);
            String[] invalidMaterials = null;
            try {
                invalidMaterials = BOMFacadeFactory.getRemoteInstance().findChildMaterialIdNoSameGroupWithParent(this.materialID, childMaterials);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (Exception e) {
                this.handleException(e);
            }
            childMaterialsMap.clear();
            for (i = 0; i < invalidMaterials.length; ++i) {
                childMaterialsMap.put(invalidMaterials[i], null);
            }
            int count3 = this.kdtSubstituteEntry.getRowCount();
            for (i = 0; i < count3; ++i) {
                row = this.kdtSubstituteEntry.getRow(i);
                if (null != (BigDecimal)row.getCell(TB_SUBSTITUTEPROPORTION).getValue() && childMaterialsMap.containsKey(((MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue()).getId().toString())) {
                    sb.append(strNo).append(i + 1).append(strRow).append(" ");
                    sb.append(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.subunit.notinsamegroup")).append("\r\n");
                }
                if (((Date)row.getCell(TB_EFFECTIVEDATE).getValue()).compareTo((Date)row.getCell(TB_INVALIDDATE).getValue()) < 0) continue;
                sb.append(strNo).append(i + 1).append(strRow).append(" ");
                sb.append(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"subsentry.sub2date.bigger")).append("\r\n");
            }
            Integer[] seq = substituteSeqMap.keySet().toArray(new Integer[0]);
            Integer temp = null;
            int seqCount = 0;
            int tmpCount = 0;
            for (int i3 = 0; i3 < seq.length; ++i3) {
                temp = seq[i3];
                seqCount = (Integer)substituteSeqMap.get(temp);
                if (seqCount != (tmpCount = ((Set)substituteMaterialMap.get(temp)).size())) {
                    sb.append(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"subsentry.subseqcheck.materialRepeat", (String[])new String[]{temp.toString()})).append("\r\n");
                }
                if ((tmpCount = ((Set)substituteEffectiveDateMap.get(temp)).size()) > 1) {
                    sb.append(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"subsentry.subseqcheck.effectivedatediff", (String[])new String[]{temp.toString()})).append("\r\n");
                }
                if ((tmpCount = ((Set)substituteInvalidDateMap.get(temp)).size()) <= 1) continue;
                sb.append(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"subsentry.subseqcheck.invaliddatediff", (String[])new String[]{temp.toString()})).append("\r\n");
            }
            if (sb.length() > 0) {
                MsgBox.showWarning((String)sb.toString());
                flag = false;
            }
        }
        return flag;
    }

    private void appendStringBuffer(StringBuffer errorSbuffer, String error) {
        if (errorSbuffer.length() > 0) {
            errorSbuffer.append(error);
        } else {
            errorSbuffer.append(error);
        }
    }

    private boolean fillupTableRow(IRow row, BomSubstituteInfo info) {
        boolean flag = true;
        row.setUserObject((Object)info);
        row.getCell(TB_SUBSTITUTESEQ).setValue((Object)new Integer(info.getSubstituteSeq()));
        row.getCell(TB_SUBSTITUTEMATERIAL).setValue((Object)info.getSubstituteMaterial());
        row.getCell(TB_SUBSTITUTEUNIT).setValue((Object)info.getSubstituteUnit());
        if (null != info.getSubstituteQty() && info.getSubstituteQty().compareTo(ZERO) == 0) {
            row.getCell(TB_SUBSTITUTEQTY).setValue(null);
        } else {
            row.getCell(TB_SUBSTITUTEQTY).setValue((Object)info.getSubstituteQty());
        }
        if (null != info.getSubstituteProportion() && info.getSubstituteProportion().compareTo(ZERO) == 0) {
            row.getCell(TB_SUBSTITUTEPROPORTION).setValue(null);
        } else {
            row.getCell(TB_SUBSTITUTEPROPORTION).setValue((Object)info.getSubstituteProportion());
        }
        row.getCell(TB_EFFECTIVEDATE).setValue((Object)info.getEffectiveDate());
        row.getCell(TB_INVALIDDATE).setValue((Object)info.getInvalidDate());
        row.getCell(TB_SUBSTITUTEMATERIALNAME).setValue(null == info.getSubstituteMaterial() ? null : info.getSubstituteMaterial().getName());
        row.getCell(TB_SUBSTITUTEMEATERIALMODE).setValue(null == info.getSubstituteMaterial() ? null : info.getSubstituteMaterial().getModel());
        return flag;
    }

    private void set2Dates(IRow row) {
        Calendar effectiveDate = Calendar.getInstance();
        effectiveDate.setTime(this.serverDate);
        effectiveDate.set(11, 0);
        effectiveDate.set(12, 0);
        effectiveDate.set(13, 0);
        effectiveDate.set(14, 0);
        Calendar disableDate = Calendar.getInstance();
        disableDate.set(2099, 11, 31);
        disableDate.set(11, 0);
        disableDate.set(12, 0);
        disableDate.set(13, 0);
        disableDate.set(14, 0);
        row.getCell(TB_EFFECTIVEDATE).setValue((Object)effectiveDate.getTime());
        row.getCell(TB_INVALIDDATE).setValue((Object)disableDate.getTime());
    }

    @Override
    public void actionFindSubstituteMaterial_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.material.id", (Object)this.materialID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)this.sou.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.status", (Object)new Integer(20), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        viewInfo.setSelector(sic);
        SorterItemCollection soic = new SorterItemCollection();
        SorterItemInfo sii = new SorterItemInfo("replaceSeq");
        sii.setSortType(SortType.ASCEND);
        soic.add(sii);
        viewInfo.setSorter(soic);
        IMaterialReplaceEntry imre = MaterialReplaceEntryFactory.getRemoteInstance();
        MaterialReplaceEntryCollection mrc = imre.getMaterialReplaceEntryCollection(viewInfo);
        IRow row = null;
        BomSubstituteInfo info = new BomSubstituteInfo();
        MaterialReplaceEntryInfo mrei = null;
        Calendar effectiveDate = Calendar.getInstance();
        Calendar invalidDate = Calendar.getInstance();
        Date tmpDate = null;
        StringBuffer sqlWhere = new StringBuffer();
        int count = mrc.size();
        for (int i = 0; i < count; ++i) {
            mrei = mrc.get(i);
            info = new BomSubstituteInfo();
            info.setSubstituteMaterial(mrei.getMaterial());
            info.setSubstituteSeq(mrei.getReplaceSeq());
            info.setSubstituteUnit(mrei.getMeasureUnit());
            info.setSubstituteQty(mrei.getReplaceQty());
            info.setSubstituteProportion(mrei.getReplacePercent());
            tmpDate = mrei.getValidDate();
            if (null == tmpDate) {
                info.setEffectiveDate(tmpDate);
            } else {
                effectiveDate.setTime(tmpDate);
                effectiveDate.set(11, 0);
                effectiveDate.set(12, 0);
                effectiveDate.set(13, 0);
                effectiveDate.set(14, 0);
                info.setEffectiveDate(effectiveDate.getTime());
            }
            tmpDate = mrei.getInvalidDate();
            if (null == tmpDate) {
                info.setInvalidDate(tmpDate);
            } else {
                invalidDate.setTime(tmpDate);
                invalidDate.set(11, 0);
                invalidDate.set(12, 0);
                invalidDate.set(13, 0);
                invalidDate.set(14, 0);
                info.setInvalidDate(invalidDate.getTime());
            }
            row = this.kdtSubstituteEntry.addRow();
            this.fillupTableRow(row, info);
            if (null == info.getSubstituteMaterial() || null == info.getSubstituteMaterial().getId() || null == info.getSubstituteUnit() || null == info.getSubstituteUnit().getId()) continue;
            if (sqlWhere.length() > 0) {
                sqlWhere.append(" or ");
            }
            sqlWhere.append(" (material.id = '").append(info.getSubstituteMaterial().getId().toString()).append("' and measureUnit.id = '").append(info.getSubstituteUnit().getId().toString()).append("' ) ");
        }
        if (sqlWhere.length() > 0) {
            MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(" where " + sqlWhere.toString());
            String materialId = null;
            String unitId = null;
            int precision = 0;
            int count2 = mmuc.size();
            for (int i = 0; i < count2; ++i) {
                materialId = mmuc.get(i).getMaterial().getId().toString();
                unitId = mmuc.get(i).getMeasureUnit().getId().toString();
                precision = mmuc.get(i).getQtyPrecision();
                if (null == materialId || null == unitId) continue;
                int count1 = this.kdtSubstituteEntry.getRowCount();
                for (int k = 0; k < count1; ++k) {
                    row = this.kdtSubstituteEntry.getRow(k);
                    if (null == (MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue() || null == (MeasureUnitInfo)row.getCell(TB_SUBSTITUTEUNIT).getValue() || !materialId.equals(((MaterialInfo)row.getCell(TB_SUBSTITUTEMATERIAL).getValue()).getId().toString()) || !unitId.equals(((MeasureUnitInfo)row.getCell(TB_SUBSTITUTEUNIT).getValue()).getId().toString())) continue;
                    SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.kdtSubstituteEntry, (String[])new String[]{TB_SUBSTITUTEQTY}, (int)k);
                }
            }
        }
    }
}

