/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.BomTreeInfo;
import com.kingdee.eas.mm.basedata.BomViewOptionEnum;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractBomTreeUI;
import com.kingdee.eas.mm.basedata.client.BOMLNTreeNodeCtrl;
import com.kingdee.eas.mm.basedata.client.BOMTreeBuilderFactory;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.basedata.client.BomEditUI;
import com.kingdee.eas.mm.basedata.client.BomTreeQueryUI;
import com.kingdee.eas.mm.basedata.client.IBOMTreeBuilder;
import com.kingdee.eas.mm.basedata.client.IObserver;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BomTreeUI
extends AbstractBomTreeUI
implements IObserver {
    private static final long serialVersionUID = -4050150864140209636L;
    private static final Logger logger = CoreUIObject.getLogger(BomTreeUI.class);
    private BomEditUI bomEditUI = null;
    protected IBOMTreeBuilder treeBuilder;
    private boolean isOrderBomTree = false;
    private boolean isFromMenuItem = false;
    private boolean isShowProjectName = false;
    private CommonQueryDialog commonQueryDialog = null;
    private BomTreeQueryUI bomTeeeQueryUI = null;
    private FilterInfo filter = null;
    private Set newIdSet = null;
    private SelectorItemCollection selector = null;
    protected IMetaDataPK mainQueryPK = null;
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";
    protected KDWorkButton btnCustomerQuery = new KDWorkButton();
    protected KDMenuItem menuCustomerQuery;
    protected KDWorkButton btnRefresh;
    protected KDWorkButton btnRebuildTree;
    private TreeSelectionListener treeSelectionListener;
    protected TreePath refreshPath = null;
    private boolean mustshowDiaglog = false;
    private Map paramsMap;
    boolean isUpdate = false;
    boolean isInit = false;
    IObjectPK prePk = null;
    private boolean isAddSave = false;

    public BomTreeUI() throws Exception {
        this.btnCustomerQuery.setName("btnCustomerQuery");
        this.menuCustomerQuery = new KDMenuItem();
        this.menuCustomerQuery.setName("menuCustomerQuery");
        this.btnCustomerQuery.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCustomerQuery), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnCustomerQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnCustomerQuery.setText(EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"34_BomTreeUI"));
        this.btnCustomerQuery.setToolTipText(EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"34_BomTreeUI"));
        this.menuCustomerQuery.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCustomerQuery), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuCustomerQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuCustomerQuery.setText(EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"34_BomTreeUI") + "(F)");
        this.menuCustomerQuery.setMnemonic(70);
        this.actionCustomerQuery.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl F"));
        this.menuCustomerQuery.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String isCopyOrder = (String)this.getUIContext().get("isCopyOrderbomTree");
        if (!StringUtils.isEmpty((String)isCopyOrder) && isCopyOrder.equals("TRUE")) {
            Object[] objects;
            this.isOrderBomTree = true;
            StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
            ProjectInfo projectInfo = (ProjectInfo)this.getUIContext().get("projectNumber");
            TrackNumberInfo[] trackNumberInfos = null;
            if (this.getUIContext().get("trackNumbers") instanceof TrackNumberInfo[]) {
                trackNumberInfos = (TrackNumberInfo[])this.getUIContext().get("trackNumbers");
            } else if (this.getUIContext().get("trackNumbers") instanceof TrackNumberInfo) {
                trackNumberInfos = new TrackNumberInfo[]{(TrackNumberInfo)this.getUIContext().get("trackNumbers")};
            } else if (this.getUIContext().get("trackNumbers") instanceof Object[] && (objects = (Object[])this.getUIContext().get("trackNumbers")).length != 0) {
                trackNumberInfos = new TrackNumberInfo[objects.length];
                System.arraycopy(objects, 0, trackNumberInfos, 0, objects.length);
            }
            MaterialInfo materialInfo = (MaterialInfo)this.getUIContext().get("material");
            BOMTypeEnum bomType = (BOMTypeEnum)((Object)this.getUIContext().get("bomType"));
            BOMUsageEnum usageType = (BOMUsageEnum)((Object)this.getUIContext().get("bomUsage"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
            if (projectInfo == null) {
                fi.getFilterItems().add(new FilterItemInfo("project.id", null, CompareType.IS));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectInfo.getId().toString(), CompareType.EQUALS));
            }
            if (trackNumberInfos == null) {
                fi.getFilterItems().add(new FilterItemInfo("trackNumber.id", null, CompareType.IS));
            } else {
                HashSet<String> trackIdSet = new HashSet<String>();
                for (int i = 0; i < trackNumberInfos.length; ++i) {
                    trackIdSet.add(trackNumberInfos[i].getId().toString());
                }
                fi.getFilterItems().add(new FilterItemInfo("trackNumber.id", trackIdSet, CompareType.INCLUDE));
            }
            fi.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(bomType.getValue()), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(usageType.getValue()), CompareType.EQUALS));
            this.filter = fi;
        } else {
            this.initDiaglog();
        }
        this.initTree();
        this.initLister();
        if (this.isFirstOnload()) {
            this.loadBomEditUI();
            this.bomEditUI.getUIToolBar().add((Component)this.btnCustomerQuery, 3);
            this.bomEditUI.getUIMenuBar().getMenu(2).add((Component)this.menuCustomerQuery, 4);
        }
        this.setStatusBar(this.bomEditUI.getStatusBar());
    }

    private void loadBomEditUI() throws Exception {
        KDTreeNode node;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isUICache", (Object)"true");
        if (this.bomTeeeQueryUI != null) {
            uiContext.put((Object)"queryDate", (Object)this.bomTeeeQueryUI.getQueryDate());
        } else {
            uiContext.put((Object)"queryDate", (Object)new Date());
        }
        uiContext.put((Object)"fromTreeUI", (Object)"true");
        if (this.isOrderBomTree) {
            this.setUITitle(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderbom_tree"));
            uiContext.put((Object)"UIClassParam", (Object)"1");
            uiContext.put((Object)"IsOrderBomTree", (Object)"1");
        }
        String bomId = null;
        StorageOrgUnitInfo storageOrgUnit = null;
        if (this.refreshPath != null && (node = this.getSelectedTreeNode()) != null && node.getUserObject() instanceof BomTreeInfo) {
            BomTreeInfo info = (BomTreeInfo)node.getUserObject();
            bomId = info.getBomID();
            storageOrgUnit = info.getStorageOrgUnitInfo();
        }
        IUIWindow win = null;
        if (bomId != null) {
            uiContext.put((Object)"ID", bomId);
            uiContext.put((Object)OrgType.Storage, storageOrgUnit);
            win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.basedata.client.BomEditUI", (Map)uiContext, null, OprtState.VIEW);
        } else {
            win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.basedata.client.BomEditUI", (Map)uiContext, null, OprtState.ADDNEW);
            this.bomEditUI = (BomEditUI)win.getUIObject();
        }
        if (win != null) {
            this.bomEditUI = (BomEditUI)win.getUIObject();
            this.bomEditUI.setIObserver(this);
            this.bomEditUI.setFromTree(true);
            this.bomEditUI.setOrderBomTree(this.isOrderBomTree);
            this.setUIToolBar(this.bomEditUI.getUIToolBar());
            this.setUIMenuBar(this.bomEditUI.getUIMenuBar());
            this.mainPanel.add((Component)((Object)this.bomEditUI), (Object)"Center");
            this.mainPanel.repaint();
        }
    }

    public KDToolBar getUIToolBar() {
        return this.bomEditUI == null ? super.getUIToolBar() : this.bomEditUI.getUIToolBar();
    }

    public KDMenuBar getUIMenuBar() {
        return this.bomEditUI == null ? super.getUIMenuBar() : this.bomEditUI.getUIMenuBar();
    }

    private FilterInfo getFilterInfo() throws BOSException {
        FilterInfo filter = this.getDefaultFilterForTree();
        Object trackObj = this.getUIContext().get("trackNumbers");
        if (trackObj != null) {
            FilterInfo trackFilterInfo = new FilterInfo();
            String trackNumberKey = "trackNumber.number";
            if (trackObj instanceof Object[]) {
                Object[] trackObjs = (Object[])trackObj;
                Object[] trackNumbers = new String[trackObjs.length];
                for (int i = 0; i < trackObjs.length; ++i) {
                    trackNumbers[i] = ((TrackNumberInfo)trackObjs[i]).getNumber();
                }
                Arrays.sort(trackNumbers);
                Object startTrackNumber = trackNumbers[0];
                Object endTrackNumber = trackNumbers[trackObjs.length - 1];
                trackFilterInfo.getFilterItems().add(new FilterItemInfo(trackNumberKey, startTrackNumber, CompareType.GREATER_EQUALS));
                trackFilterInfo.getFilterItems().add(new FilterItemInfo(trackNumberKey, endTrackNumber, CompareType.LESS_EQUALS));
                filter.mergeFilter(trackFilterInfo, "and");
            }
        }
        BomViewOptionEnum viewOption = this.getBomViewOptionEnum();
        Date queryDate = null;
        if (BomViewOptionEnum.QUERY_DATE_MATERIAL.equals((Object)viewOption) && this.bomTeeeQueryUI != null) {
            queryDate = this.bomTeeeQueryUI.getQueryDate();
        } else {
            try {
                queryDate = SCMClientUtils.getServerDate();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        FilterItemCollection filterColl = filter.getFilterItems();
        FilterItemInfo item = null;
        for (int i = 0; i < filterColl.size(); ++i) {
            item = filterColl.get(i);
            if (item.getPropertyName().equalsIgnoreCase("queryDate") || item.getPropertyName().equalsIgnoreCase("queryType")) {
                filterColl.remove(item);
                --i;
                continue;
            }
            if (!item.getPropertyName().equalsIgnoreCase("queryType")) continue;
            filterColl.remove(item);
            --i;
        }
        filter.getFilterItems().add(new FilterItemInfo("queryDate", (Object)queryDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("queryType", (Object)viewOption, CompareType.EQUALS));
        return filter;
    }

    public void initTree() throws Exception {
        this.paramsMap = new HashMap();
        this.paramsMap.put("initalLevel", String.valueOf(this.getTreeInitialLevel()));
        this.paramsMap.put("expandLevel", String.valueOf(this.getTreeExpandLevel()));
        FilterInfo filterInfo = this.getFilterInfo();
        this.paramsMap.put("filter", filterInfo);
        this.paramsMap.put("selector", this.getSelectorForTree());
        this.paramsMap.put("isOrderBomTree", this.isOrderBomTree);
        this.paramsMap.put("isShowProjectName", this.isShowProjectName);
        this.treeBuilder = BOMTreeBuilderFactory.createTreeBuilder(this.getLNTreeNodeCtrl(), this.paramsMap);
        this.treeBuilder.buildTree(this.kDTreeBOM);
        this.kDTreeBOM.setShowPopMenuDefaultItem(true);
        KDTreeNode rootNode = (KDTreeNode)this.kDTreeBOM.getModel().getRoot();
        this.kDTreeBOM.expandOnLevel(4);
        if (rootNode.getChildCount() > 0) {
            KDTreeNode firstNode = null;
            if (this.isOrderBomTree) {
                KDTreeNode ptNode = (KDTreeNode)rootNode.getChildAt(0);
                KDTreeNode usageNode = (KDTreeNode)ptNode.getChildAt(0);
                firstNode = (KDTreeNode)usageNode.getChildAt(0);
            } else {
                KDTreeNode usageNode = (KDTreeNode)rootNode.getChildAt(0);
                firstNode = (KDTreeNode)usageNode.getChildAt(0);
            }
            this.refreshPath = new TreePath(firstNode.getPath());
            this.kDTreeBOM.setSelectionPath(this.refreshPath);
        } else {
            FilterInfo filter = this.getDefaultFilterForTree();
            int filterSize = filter.getFilterItems().size();
            FilterItemCollection items = filter.getFilterItems();
            String usageTypeStr = null;
            for (int i = 0; i < filterSize; ++i) {
                FilterItemInfo item = items.get(i);
                if (!item.getPropertyName().equalsIgnoreCase("usageType")) continue;
                usageTypeStr = item.getCompareValue().toString();
                break;
            }
            BOMUsageEnum usageType = null;
            if (usageTypeStr != null) {
                usageType = BOMUsageEnum.getEnum(Integer.parseInt(usageTypeStr));
            }
            if (this.bomEditUI != null) {
                this.bomEditUI.setOprtState(OprtState.ADDNEW);
                this.bomEditUI.loadBomInfoForTree(null, null, usageType, null, null, true);
            }
        }
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new BOMLNTreeNodeCtrl(this.isOrderBomTree);
    }

    protected int getTreeInitialLevel() {
        return 2;
    }

    protected int getTreeExpandLevel() {
        return 2;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return this.filter;
    }

    protected SelectorItemCollection getSelectorForTree() {
        return this.selector;
    }

    @Override
    public void actionCustomerQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mustshowDiaglog = true;
        if (this.showQueryDialog()) {
            Date queryDate = this.bomTeeeQueryUI.getQueryDate();
            this.bomEditUI.setQueryDate(queryDate);
            if (queryDate == null) {
                this.setFromMenuItem(true);
                this.bomEditUI.setViewOptionValue();
            } else {
                this.setFromMenuItem(false);
            }
            this.initTree();
        }
        this.newIdSet = new HashSet();
    }

    private QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    private boolean showQueryDialog() throws EASBizException {
        try {
            this.initCommonQueryDialog();
            this.bomTeeeQueryUI.getUIContext().clear();
            this.bomTeeeQueryUI.getUIContext().putAll(this.getUIContext());
            if (!this.mustshowDiaglog) {
                QuerySolutionInfo currSolution = this.commonQueryDialog.getCurrentSolutionInfo();
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String uiName = null;
                String name = this.getQueryInfo(this.mainQueryPK).getFullName();
                uiName = StringUtils.replace((String)this.getMetaDataPK().toString(), (String)"\\", (String)".");
                if (iQuery == null || name == null) {
                    return false;
                }
                currSolution = iQuery.getDefaultSolution(uiName, name);
                if (null != currSolution && currSolution.isIsUserDefaultSolu() && null != currSolution.getEntityViewInfo()) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    this.filter = entityViewInfo.getFilter();
                    this.selector = entityViewInfo.getSelector();
                    return true;
                }
            }
            if (this.commonQueryDialog.show()) {
                this.filter = this.bomTeeeQueryUI.getFilterInfo();
                this.filter.mergeFilter(this.commonQueryDialog.getCommonFilter(), "and");
                this.selector = this.bomTeeeQueryUI.getSelectors();
                this.isShowProjectName = this.bomTeeeQueryUI.isShowProjectName();
                this.mustshowDiaglog = false;
                return true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.mustshowDiaglog = false;
        return false;
    }

    private void initCommonQueryDialog() throws EASBizException {
        if (this.commonQueryDialog == null) {
            try {
                MessageFormat format;
                this.commonQueryDialog = new CommonQueryDialog();
                if (this.getUIWindow() == null) {
                    this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
                } else {
                    this.commonQueryDialog.setOwner((Component)((Object)this));
                }
                this.commonQueryDialog.setUiObject((IUIObject)this);
                String classFullName = this.getMetaDataPK().getFullName();
                this.commonQueryDialog.setParentUIClassName(classFullName);
                this.mainQueryPK = !this.isOrderBomTree ? MetaDataPK.create((String)"com.kingdee.eas.mm.basedata.app", (String)"Bom4TreeQuery") : MetaDataPK.create((String)"com.kingdee.eas.mm.basedata.app", (String)"OrderBom4TreeQuery");
                this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
                String strParam = (String)this.getUIContext().get("UIClassParam");
                if (strParam != null) {
                    if (strParam.equals("OrderBomTreeUI")) {
                        format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
                        String title = format.format(new Object[]{ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderbom_tree"), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
                        this.commonQueryDialog.setTitle(title);
                    }
                } else {
                    format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
                    String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
                    this.commonQueryDialog.setTitle(title);
                }
                this.commonQueryDialog.setShowSorter(false);
                this.bomTeeeQueryUI = new BomTreeQueryUI();
                Dimension size = new Dimension();
                size.width = 580;
                size.height = 345;
                this.bomTeeeQueryUI.setSize(size);
                this.commonQueryDialog.addUserPanel((KDPanel)this.bomTeeeQueryUI);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONINITDIALOG", e.getMessage()), e.getCause(), null);
            }
        }
    }

    private void initLister() {
        if (this.treeSelectionListener == null) {
            this.treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        BomTreeUI.this.treeMain_valueChanged(e);
                    }
                    catch (Exception exc) {
                        BomTreeUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kDTreeBOM.addTreeSelectionListener(this.treeSelectionListener);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo) {
            KDTreeNode treeNode;
            BomTreeInfo oldBomTreeInfo;
            KDTreeNode oldTreeNode;
            if (!this.checkSaveChange()) {
                this.kDTreeBOM.removeTreeSelectionListener(this.treeSelectionListener);
                this.kDTreeBOM.setSelectionPath(this.refreshPath);
                this.kDTreeBOM.addTreeSelectionListener(this.treeSelectionListener);
                this.bomEditUI.resetFlag();
                return;
            }
            if (e.getOldLeadSelectionPath() != null && (oldTreeNode = (KDTreeNode)e.getOldLeadSelectionPath().getLastPathComponent()) != null && oldTreeNode.getUserObject() instanceof BomTreeInfo && (oldBomTreeInfo = (BomTreeInfo)oldTreeNode.getUserObject()) != null && oldBomTreeInfo.getBomID() != null) {
                this.prePk = new ObjectUuidPK(oldBomTreeInfo.getBomID().toString());
            }
            if ((treeNode = this.getSelectedTreeNode()) != null) {
                BomTreeInfo bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
                ProjectInfo project = bomTreeInfo.getProject();
                TrackNumberCollection trackNumbers = bomTreeInfo.getTrackNumbers();
                TrackNumberCollection newTrackNums = new TrackNumberCollection();
                ManufactureStrategyInfo manufactureStrategy = bomTreeInfo.getManufactureStrategy();
                boolean isAddNewOrderBom = true;
                String pkManufature = null;
                pkManufature = manufactureStrategy == null ? "NUnM+gEcEADgAA3cwKgL09g0uEU=" : manufactureStrategy.getId().toString();
                Set noOrderBomStrategySet = ManufactureStrategyGroup.getNoOrderBomStrategyIdSet();
                if (noOrderBomStrategySet.contains(pkManufature)) {
                    isAddNewOrderBom = false;
                }
                if (project != null && !project.getBaseStatus().equals((Object)MMBaseStatusEnum.AUDIT)) {
                    project = null;
                }
                if (trackNumbers != null) {
                    for (int i = 0; i < trackNumbers.size(); ++i) {
                        if (MMBasedataStatusEnum.CLOSED.equals((Object)trackNumbers.get(i).getStatus())) continue;
                        newTrackNums.add(trackNumbers.get(i));
                    }
                }
                BOMUsageEnum usageType = bomTreeInfo.getBomUsage();
                if (bomTreeInfo.getBomID() != null || bomTreeInfo.getMaterialInfo() != null) {
                    String bomId = bomTreeInfo.getBomID();
                    if (MMUtils.isEmptyString((String)bomId)) {
                        try {
                            MaterialInfo material = bomTreeInfo.getMaterialInfo();
                            this.bomEditUI.setOprtState(OprtState.ADDNEW);
                            this.bomEditUI.loadBomInfoForTree(null, material, usageType, null, null, isAddNewOrderBom);
                        }
                        catch (Exception e1) {
                            logger.error((Object)e1);
                        }
                    } else {
                        IObjectValue objValue = null;
                        ObjectUuidPK pk = new ObjectUuidPK(bomId);
                        try {
                            objValue = this.bomEditUI.getBOMInfoByID((IObjectPK)pk);
                        }
                        catch (Exception e1) {
                            logger.error((Object)e1);
                        }
                        if (null != objValue) {
                            if (!this.isInit) {
                                if (OprtState.EDIT.equals(this.bomEditUI.getOprtState())) {
                                    try {
                                        this.setOprtState("RELEASEALL");
                                        this.pubFireVOChangeListener(this.prePk.toString());
                                    }
                                    catch (Throwable ex) {
                                        this.handUIException(ex);
                                    }
                                }
                                this.bomEditUI.setOprtState(OprtState.VIEW);
                                BomInfo bom = (BomInfo)objValue;
                                isAddNewOrderBom = BOMTypeEnum.OrderBOM.equals((Object)bom.getBomType());
                                this.bomEditUI.loadBomInfoForTree(objValue, null, null, null, null, this.isAddSave);
                                this.isAddSave = false;
                            } else {
                                this.isInit = false;
                            }
                        }
                    }
                } else {
                    try {
                        this.bomEditUI.setOprtState(OprtState.ADDNEW);
                        this.bomEditUI.loadBomInfoForTree(null, null, usageType, null, null, true);
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                    }
                }
            }
            this.bomEditUI.setActionEnabled();
            this.refreshPath = e.getNewLeadSelectionPath();
        } else {
            this.refreshPath = null;
            if (this.isUpdate && this.bomEditUI.getEditData().getId() != null) {
                this.isInit = true;
                String bomId = this.bomEditUI.getEditData().getId().toString();
                this.prePk = new ObjectUuidPK(bomId);
            }
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.kDTreeBOM.getLastSelectedPathComponent();
    }

    private void initDiaglog() throws EASBizException {
        String strParam = (String)this.getUIContext().get("UIClassParam");
        if (strParam != null) {
            if (strParam.equals("OrderBomTreeUI")) {
                this.isOrderBomTree = true;
            }
        } else {
            this.isOrderBomTree = false;
        }
        if (!this.showQueryDialog()) {
            this.abort();
        }
    }

    public void onShow() throws Exception {
        if (this.isFirstOnload()) {
            this.btnRefresh = new KDWorkButton();
            this.btnRefresh.setName("btnRefresh");
            this.btnRefresh.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionRefresh), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
            this.btnRefresh.setToolTipText(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"btnRefresh"));
            this.btnRebuildTree = new KDWorkButton();
            this.btnRebuildTree.setName("btnRebuildTree");
            this.btnRebuildTree.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionRebuildTree), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            this.btnRebuildTree.setIcon(EASResource.getIcon((String)"imgTbtn_prolinedistribute"));
            this.btnRebuildTree.setToolTipText(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"btnRebuildTree"));
            this.btnClearAll.setTextIconDisStyle((short)2);
            this.btnSelectAll.setTextIconDisStyle((short)2);
            this.kDTreeView1.getControlPane().add((Component)this.btnRefresh);
            this.kDTreeView1.getControlPane().add((Component)this.btnRebuildTree);
            this.kDTreeView1.getControlPane().add((Component)this.btnClearAll);
            this.kDTreeView1.getControlPane().add((Component)this.btnSelectAll);
            if (this.isOrderBomTree) {
                this.btnSelectAll.setVisible(true);
                this.btnClearAll.setVisible(true);
            } else {
                this.btnSelectAll.setVisible(false);
                this.btnClearAll.setVisible(false);
            }
            this.kDTreeView1.setShowButton(false);
        }
        this.btnCustomerQuery.setEnabled(true);
        this.menuCustomerQuery.setEnabled(true);
        super.onShow();
    }

    @Override
    public void actionCleartAll_actionPerformed(ActionEvent e1) throws Exception {
        KDTreeNode node = (KDTreeNode)this.kDTreeBOM.getModel().getRoot();
        if (node.getChildCount() <= 0) {
            return;
        }
        this.setslected(node, false);
        this.kDTreeView1.repaint();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e1) throws Exception {
        KDTreeNode node = (KDTreeNode)this.kDTreeBOM.getModel().getRoot();
        if (node.getChildCount() <= 0) {
            return;
        }
        this.setslected(node, true);
        this.kDTreeView1.repaint();
    }

    private void setslected(KDTreeNode treeNode, boolean isSelect) {
        Enumeration e = treeNode.children();
        while (e.hasMoreElements()) {
            KDTreeNode node;
            Object o = e.nextElement();
            if (o == null || !(o instanceof KDTreeNode) || (node = (KDTreeNode)o).getUserObject() == null || !(node.getUserObject() instanceof BomTreeInfo)) continue;
            node.setChecked(isSelect);
            if (node.getChildCount() <= 0) continue;
            this.setslected(node, isSelect);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initTree(BomInfo bom, boolean isAddNew, boolean isUpdate, boolean isDel) throws Exception {
        this.isUpdate = isUpdate;
        if (isAddNew) {
            if (bom == null || bom.getId() == null) return;
            this.addNewBOMTreeNode(null, bom);
            this.isAddSave = true;
            if (this.newIdSet == null) {
                this.newIdSet = new HashSet();
            }
            this.newIdSet.add(bom.getId().toString());
            return;
        } else if (isUpdate) {
            this.isAddSave = false;
            if (bom == null || bom.getId() == null) return;
            if (this.refreshPath == null) {
                this.addNewBOMTreeNode(null, bom);
                this.isInit = true;
                String bomId = bom.getId().toString();
                this.prePk = new ObjectUuidPK(bomId);
                if (this.newIdSet == null) {
                    this.newIdSet = new HashSet();
                }
                this.newIdSet.add(bom.getId().toString());
                this.initTree();
                return;
            } else {
                KDTreeNode currNode = (KDTreeNode)this.refreshPath.getLastPathComponent();
                if (currNode == null || !(currNode.getUserObject() instanceof BomTreeInfo)) return;
                BomTreeInfo bomTreeInfo = (BomTreeInfo)currNode.getUserObject();
                if (bomTreeInfo.getBomID() != null) {
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, currNode, this.getQueryTypeAndDateFilter());
                    return;
                } else {
                    if (currNode.isLeaf() && bomTreeInfo.getMaterialInfo() != null) {
                        KDTreeNode parent = (KDTreeNode)currNode.getParent();
                        this.refreshPath = new TreePath(parent.getPath());
                        this.treeBuilder.refreshTreeNode(this.kDTreeBOM, parent, this.getQueryTypeAndDateFilter());
                        int childCount = parent.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            KDTreeNode treeNode = (KDTreeNode)parent.getChildAt(i);
                            BomTreeInfo treeInfo = (BomTreeInfo)treeNode.getUserObject();
                            if (!bom.getId().toString().equalsIgnoreCase(treeInfo.getBomID())) continue;
                            this.refreshPath = new TreePath(treeNode.getPath());
                            return;
                        }
                        return;
                    }
                    this.addNewBOMTreeNode(currNode, bom);
                    this.initTree();
                }
            }
            return;
        } else {
            if (!isDel) return;
            this.isAddSave = false;
            if (this.getSelectedTreeNode() == null || !(this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo)) return;
            BomTreeInfo bomTreeInfo = (BomTreeInfo)this.getSelectedTreeNode().getUserObject();
            if (this.newIdSet != null) {
                this.newIdSet.remove(bomTreeInfo.getBomID());
            }
            KDTreeNode treeNode = (KDTreeNode)this.getSelectedTreeNode().getParent();
            KDTreeNode ptNode = null;
            KDTreeNode firstNode = null;
            KDTreeNode usageNode = null;
            if (this.isOrderBomTree) {
                if (treeNode.getLevel() == 2) {
                    bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
                    FilterInfo newFilter = new FilterInfo();
                    if (this.newIdSet != null && this.newIdSet.size() > 0) {
                        newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.newIdSet, CompareType.INCLUDE));
                        newFilter.mergeFilter(this.filter, "or");
                    } else {
                        newFilter = (FilterInfo)this.filter.clone();
                    }
                    FilterInfo ptFilter = new FilterInfo();
                    ptFilter.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(bomTreeInfo.getBomUsage().getValue()), CompareType.EQUALS));
                    newFilter.mergeFilter(ptFilter, "and");
                    FilterInfo queryFilter = this.getQueryTypeAndDateFilter();
                    newFilter.mergeFilter(queryFilter, "and");
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                    if (treeNode.getChildCount() == 0) {
                        usageNode = (KDTreeNode)treeNode.getParent();
                        if (usageNode.getChildCount() == 0) {
                            usageNode = (KDTreeNode)((KDTreeNode)this.kDTreeBOM.getModel().getRoot()).getChildAt(0);
                        }
                        if ((ptNode = (KDTreeNode)usageNode.getChildAt(0)).getChildCount() > 0) {
                            firstNode = (KDTreeNode)ptNode.getChildAt(0);
                        }
                    } else {
                        firstNode = (KDTreeNode)treeNode.getChildAt(0);
                    }
                    if (firstNode != null) {
                        this.refreshPath = new TreePath(firstNode.getPath());
                        return;
                    } else {
                        if (ptNode == null) return;
                        this.refreshPath = new TreePath(ptNode.getPath());
                    }
                    return;
                } else {
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode);
                    this.refreshPath = new TreePath(treeNode.getPath());
                }
                return;
            } else if (treeNode.getLevel() <= 2) {
                bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
                if (bomTreeInfo == null) {
                    return;
                }
                FilterInfo newFilter = new FilterInfo();
                if (this.newIdSet != null && this.newIdSet.size() > 0) {
                    newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.newIdSet, CompareType.INCLUDE));
                    newFilter.mergeFilter(this.filter, "or");
                } else {
                    newFilter = (FilterInfo)this.filter.clone();
                }
                FilterInfo usageFilter = new FilterInfo();
                usageFilter.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(bomTreeInfo.getBomUsage().getValue()), CompareType.EQUALS));
                newFilter.mergeFilter(usageFilter, "and");
                FilterInfo queryFilter = this.getQueryTypeAndDateFilter();
                newFilter.mergeFilter(queryFilter, "and");
                this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                if (treeNode.getChildCount() == 0) {
                    usageNode = (KDTreeNode)treeNode.getParent();
                    if (usageNode.getChildCount() == 0) {
                        usageNode = (KDTreeNode)((KDTreeNode)this.kDTreeBOM.getModel().getRoot()).getChildAt(0);
                    }
                    if ((ptNode = (KDTreeNode)usageNode.getChildAt(0)).getChildCount() > 0) {
                        firstNode = (KDTreeNode)ptNode.getChildAt(0);
                    }
                } else {
                    firstNode = (KDTreeNode)treeNode.getChildAt(0);
                }
                if (firstNode != null) {
                    this.refreshPath = new TreePath(firstNode.getPath());
                    return;
                } else {
                    if (ptNode == null) return;
                    this.refreshPath = new TreePath(ptNode.getPath());
                }
                return;
            } else {
                this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, this.getQueryTypeAndDateFilter());
                this.refreshPath = new TreePath(treeNode.getPath());
            }
        }
    }

    private void addNewBOMTreeNode(KDTreeNode parentNode, BomInfo bom) throws Exception {
        BomTreeInfo bomTreeInfo = new BomTreeInfo();
        bomTreeInfo.setBomID(bom.getId().toString());
        bomTreeInfo.setMaterialInfo(bom.getMaterial());
        bomTreeInfo.setBomUsage(bom.getUsageType());
        bomTreeInfo.setBomType(bom.getBomType());
        bomTreeInfo.setStorageOrgUnitInfo(bom.getStorageOrgUnit());
        bomTreeInfo.setIsLeaf(false);
        if (bom.getMaterial() == null) {
            return;
        }
        String nodeText = bom.getMaterial().getNumber() + "(" + bom.getMaterial().getName() + ")&" + bom.getNumber();
        if (this.isOrderBomTree) {
            BOMTypeEnum bomType = bom.getBomType();
            if (BOMTypeEnum.MfgBOM.equals((Object)bomType)) {
                KDTreeNode currNode = (KDTreeNode)this.refreshPath.getLastPathComponent();
                parentNode = (KDTreeNode)currNode.getParent();
                KDTreeNode treeNode = new KDTreeNode(null);
                treeNode.setText(nodeText);
                treeNode.setCheckBoxVisible(true);
                treeNode.setUserObject((Object)bomTreeInfo);
                this.treeBuilder.refreshTreeNode(this.kDTreeBOM, parentNode);
                this.refreshPath = new TreePath(parentNode.getPath());
                return;
            }
            bomTreeInfo.setProject(this.bomEditUI.getProjectInfo());
            bomTreeInfo.setTrackNumbers(this.bomEditUI.getTrackNumberCollection());
            TrackNumberCollection trackNumbers = this.bomEditUI.getTrackNumberCollection();
            if (trackNumbers != null && trackNumbers.size() != 0) {
                String tracksRang;
                int trackSize = bomTreeInfo.getTrackNumbers().size();
                if (trackSize > 0) {
                    nodeText = nodeText + "&";
                }
                if ((tracksRang = BOMUIHelper.trackNumbersToStrRang(bomTreeInfo.getTrackNumbers())) != null) {
                    nodeText = nodeText + tracksRang;
                }
            }
        } else {
            bomTreeInfo.setProject(this.bomEditUI.getProjectInfo());
        }
        KDTreeNode treeNode = new KDTreeNode(null);
        treeNode.setText(nodeText);
        treeNode.setCheckBoxVisible(true);
        treeNode.setUserObject((Object)bomTreeInfo);
        this.treeBuilder.addNewTreeNode(this.kDTreeBOM, parentNode, treeNode);
        this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, this.getQueryTypeAndDateFilter());
        this.refreshPath = new TreePath(treeNode.getPath());
    }

    @Override
    public void reset(boolean isInited) {
        this.kDTreeBOM.setSelectionPath(this.refreshPath);
        this.kDTreeBOM.expandPath(this.refreshPath);
    }

    public boolean checkBeforeWindowClosing() {
        return this.checkSaveChange();
    }

    private boolean checkSaveChange() {
        if (this.bomEditUI != null && this.bomEditUI.isModify()) {
            String message = null;
            message = !this.bomEditUI.isModifySave() ? EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit") : EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    if (!this.bomEditUI.isModifySave()) {
                        this.bomEditUI.actionSubmit_actionPerformed(null);
                    } else {
                        this.bomEditUI.actionSave_actionPerformed(null);
                    }
                    return this.bomEditUI.isSaved();
                }
                catch (Exception e) {
                    this.handleException(e);
                    return false;
                }
            }
            if (result == 1) {
                return true;
            }
            if (result == 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionRebuildTree_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode rootNode = (KDTreeNode)this.kDTreeBOM.getModel().getRoot();
        this.refreshPath = null;
        if (rootNode.getChildCount() >= 0) {
            HashSet<String> set = new HashSet<String>();
            List list = this.getCheckedTreeNodes(rootNode);
            if (list != null && list.size() > 0) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    BomTreeInfo info = (BomTreeInfo)list.get(i);
                    set.add(info.getBomID());
                }
                this.filter = new FilterInfo();
                this.filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                this.initTree();
            }
        }
    }

    protected List getCheckedTreeNodes(KDTreeNode treeNode) throws Exception {
        ArrayList<BomTreeInfo> list = new ArrayList<BomTreeInfo>();
        Enumeration e = treeNode.children();
        while (e.hasMoreElements()) {
            List subList;
            Object o = e.nextElement();
            if (o == null || !(o instanceof KDTreeNode)) continue;
            KDTreeNode node = (KDTreeNode)o;
            BomTreeInfo bomTreeInfo = null;
            if (node.getUserObject() == null || !(node.getUserObject() instanceof BomTreeInfo)) continue;
            bomTreeInfo = (BomTreeInfo)node.getUserObject();
            if (bomTreeInfo.getBomID() != null && !bomTreeInfo.getBomID().trim().equals("") && node.isChecked()) {
                list.add(bomTreeInfo);
            }
            if (node.getChildCount() <= 0 || (subList = this.getCheckedTreeNodes(node)) == null || subList.size() <= 0) continue;
            list.addAll(subList);
        }
        return list;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null || treeNode.getLevel() == 0) {
            return;
        }
        if (this.isOrderBomTree) {
            BomTreeInfo bomTreeInfo;
            if (treeNode.getLevel() == 1 && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo) {
                bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
                if (bomTreeInfo == null) {
                    return;
                }
                FilterInfo newFilter = new FilterInfo();
                if (this.newIdSet != null && this.newIdSet.size() > 0) {
                    newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.newIdSet, CompareType.INCLUDE));
                    newFilter.mergeFilter(this.filter, "or");
                } else {
                    newFilter = (FilterInfo)this.filter.clone();
                }
                if (bomTreeInfo.getLongNumber() != null) {
                    BOMUsageEnum bomUsage = BOMUsageEnum.getEnum(bomTreeInfo.getLongNumber().substring(2));
                    FilterInfo typeFilter = new FilterInfo();
                    typeFilter.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(bomUsage.getValue()), CompareType.EQUALS));
                    newFilter.mergeFilter(typeFilter, "and");
                }
                this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
            }
            if (treeNode.getLevel() == 2 && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo) {
                FilterInfo newFilter = new FilterInfo();
                if (this.newIdSet != null && this.newIdSet.size() > 0) {
                    newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.newIdSet, CompareType.INCLUDE));
                    newFilter.mergeFilter(this.filter, "or");
                } else {
                    newFilter = (FilterInfo)this.filter.clone();
                }
                this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
            }
            if (treeNode.getLevel() >= 3 && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo) {
                bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
                String bomId = bomTreeInfo.getBomID();
                if (bomId != null && !bomId.trim().equals("")) {
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode);
                    this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
                } else {
                    FilterInfo newFilter = new FilterInfo();
                    if (bomTreeInfo.getMaterialInfo() != null && bomTreeInfo.getMaterialInfo().getId() != null) {
                        newFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)bomTreeInfo.getMaterialInfo().getId().toString(), CompareType.EQUALS));
                    }
                    if (bomTreeInfo.getBomUsage() != null) {
                        newFilter.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(bomTreeInfo.getBomUsage().getValue()), CompareType.EQUALS));
                    }
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                    this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
                }
            }
        } else {
            BomTreeInfo bomTreeInfo;
            if (treeNode.getLevel() == 1 && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo) {
                bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
                FilterInfo newFilter = new FilterInfo();
                if (bomTreeInfo != null) {
                    if (this.newIdSet != null && this.newIdSet.size() > 0) {
                        newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.newIdSet, CompareType.INCLUDE));
                        newFilter.mergeFilter(this.filter, "or");
                    } else {
                        newFilter = (FilterInfo)this.filter.clone();
                    }
                    FilterInfo usageFilter = new FilterInfo();
                    usageFilter.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(bomTreeInfo.getBomUsage().getValue()), CompareType.EQUALS));
                    newFilter.mergeFilter(usageFilter, "and");
                }
                this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
            }
            if (treeNode.getLevel() == 2 && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo) {
                FilterInfo newFilter = new FilterInfo();
                if (this.newIdSet != null && this.newIdSet.size() > 0) {
                    newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.newIdSet, CompareType.INCLUDE));
                    newFilter.mergeFilter(this.filter, "or");
                } else {
                    newFilter = (FilterInfo)this.filter.clone();
                }
                this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
            }
            if (treeNode.getLevel() >= 3 && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof BomTreeInfo) {
                bomTreeInfo = (BomTreeInfo)treeNode.getUserObject();
                String bomId = bomTreeInfo.getBomID();
                if (bomId != null && !bomId.trim().equals("")) {
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode);
                    this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
                } else {
                    FilterInfo newFilter = new FilterInfo();
                    if (bomTreeInfo.getMaterialInfo() != null && bomTreeInfo.getMaterialInfo().getId() != null) {
                        newFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)bomTreeInfo.getMaterialInfo().getId().toString(), CompareType.EQUALS));
                    }
                    if (bomTreeInfo.getBomUsage() != null) {
                        newFilter.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(bomTreeInfo.getBomUsage().getValue()), CompareType.EQUALS));
                    }
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, treeNode, newFilter);
                    this.kDTreeBOM.expandPath(new TreePath(treeNode.getPath()));
                }
            }
        }
    }

    @Override
    public void actionExitCurrent(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean destroyWindow() {
        if (this.bomEditUI != null && OprtState.EDIT.equals(this.bomEditUI.getOprtState()) && this.bomEditUI.getEditData().getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.bomEditUI.getEditData().getId());
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(pk.toString());
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
        }
        return super.destroyWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnCustomerQuery);
    }

    public boolean isBatchAssign() {
        return this.bomEditUI.isBatchAssign();
    }

    private BomViewOptionEnum getBomViewOptionEnum() {
        if (this.isFromMenuItem) {
            if (this.bomEditUI != null) {
                if (this.bomEditUI.chkMenuItemAllMaterial.isSelected()) {
                    return BomViewOptionEnum.ALL_MATERIAL;
                }
                if (this.bomEditUI.chkMenuItemDisableMaterial.isSelected()) {
                    return BomViewOptionEnum.DISABLE_MATERIAL;
                }
                if (this.bomEditUI.chkMenuItemWillMaterial.isSelected()) {
                    return BomViewOptionEnum.WILL_MATERIAL;
                }
                if (this.bomEditUI.chkMenuItemQueryDate.isSelected()) {
                    return BomViewOptionEnum.QUERY_DATE_MATERIAL;
                }
            }
            return BomViewOptionEnum.CURRENT_MATERIAL;
        }
        if (this.bomTeeeQueryUI != null && this.bomTeeeQueryUI.getQueryDate() != null) {
            return BomViewOptionEnum.QUERY_DATE_MATERIAL;
        }
        return this.getSaveViewOption();
    }

    private BomViewOptionEnum getSaveViewOption() {
        HashMap<String, BomViewOptionEnum> map = new HashMap<String, BomViewOptionEnum>();
        map.put("chkMenuItemAllMaterial", BomViewOptionEnum.ALL_MATERIAL);
        map.put("chkMenuItemCurrentMaterial", BomViewOptionEnum.CURRENT_MATERIAL);
        map.put("chkMenuItemDisableMaterial", BomViewOptionEnum.DISABLE_MATERIAL);
        map.put("chkMenuItemWillMaterial", BomViewOptionEnum.WILL_MATERIAL);
        Iterator it = map.entrySet().iterator();
        Map.Entry mapEntry = null;
        BomViewOptionEnum viewOption = null;
        String value = null;
        try {
            while (it.hasNext()) {
                mapEntry = it.next();
                value = ConfigServiceUtils.getUserConfigData((String)(mapEntry.getKey() + this.getOptionKeySuffix()), (CoreUI)new BomEditUI());
                if (!Boolean.TRUE.toString().equalsIgnoreCase(value)) continue;
                viewOption = (BomViewOptionEnum)((Object)mapEntry.getValue());
                break;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return viewOption;
    }

    private String getOptionKeySuffix() {
        String suffixStr = "";
        suffixStr = this.isOrderBomTree ? "orderBomTree" : "bomTree";
        return suffixStr;
    }

    public void setFromMenuItem(boolean isFromMenuItem) {
        this.isFromMenuItem = isFromMenuItem;
    }

    private FilterInfo getQueryTypeAndDateFilter() {
        BomViewOptionEnum viewOption = null;
        Date queryDate = null;
        if (this.bomEditUI.chkMenuItemAllMaterial.isSelected()) {
            viewOption = BomViewOptionEnum.ALL_MATERIAL;
        } else if (this.bomEditUI.chkMenuItemCurrentMaterial.isSelected()) {
            viewOption = BomViewOptionEnum.CURRENT_MATERIAL;
        } else if (this.bomEditUI.chkMenuItemDisableMaterial.isSelected()) {
            viewOption = BomViewOptionEnum.DISABLE_MATERIAL;
        } else if (this.bomEditUI.chkMenuItemWillMaterial.isSelected()) {
            viewOption = BomViewOptionEnum.WILL_MATERIAL;
        } else if (this.bomEditUI.chkMenuItemQueryDate.isSelected()) {
            viewOption = BomViewOptionEnum.QUERY_DATE_MATERIAL;
            if (this.bomTeeeQueryUI != null) {
                queryDate = this.bomTeeeQueryUI.getQueryDate();
            }
        }
        if (queryDate == null) {
            try {
                queryDate = SCMClientUtils.getServerDate();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryType", (Object)viewOption, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("queryDate", (Object)queryDate, CompareType.EQUALS));
        return filter;
    }
}

