/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.mm.basedata.ClassGroupFactory;
import com.kingdee.eas.mm.basedata.ClassGroupInfo;
import com.kingdee.eas.mm.basedata.IClassGroup;
import com.kingdee.eas.mm.basedata.client.AbstractClassGroupListUI;
import com.kingdee.eas.mm.basedata.client.ClassGroupEditUI;
import com.kingdee.eas.mm.common.CoreTableSelectionHelper;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.action.ITableSelectionHelper;
import com.kingdee.eas.scm.common.action.SCMActionManager;
import com.kingdee.eas.scm.common.action.TableSelectionHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class ClassGroupListUI
extends AbstractClassGroupListUI
implements ISupportBatchAction {
    private static final long serialVersionUID = 2060139902792136048L;
    private static final Logger logger = CoreUIObject.getLogger(ClassGroupListUI.class);
    protected SCMActionManager actionManager = null;
    private TableSelectionHelper tableSelectionHelper;

    @Override
    protected String getEditUIName() {
        return ClassGroupEditUI.class.getName();
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        for (int r = firstIndex; r <= lastIndex; ++r) {
            if (this.tblMain.getRow(r).getCell("total").getValue() == null || !((Integer)this.tblMain.getRow(r).getCell("total").getValue()).equals(new Integer(0))) continue;
            this.tblMain.getRow(r).getCell("total").setValue(null);
        }
    }

    public void onLoad() throws Exception {
        this.getActionManager();
        if (this.isFirstOnload() && this.isSupportedBatchActions()) {
            this.initBatchActions();
        }
        super.onLoad();
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ClassGroupFactory.class);
        this.getTableSelectionHelper().setTableProperty(null, this.mainQueryPK, this.tblMain, "id", "storageOrgUnit.name", "number", "entry.seq", "storageOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.DELETE, (ItemAction)this.actionRemove, (String)"delete");
        this.actionManager.registerBatchAction(actionProxy, "actionRemove");
        actionProxy.bindTo((AbstractButton)this.btnRemove);
        actionProxy.bindTo((AbstractButton)this.menuItemRemove);
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new SCMActionManager((CoreUIObject)this, ContextTypeEnum.INQUERYING);
            this.actionManager.setTableSelectionHelper((ITableSelectionHelper)this.getTableSelectionHelper());
            this.actionManager.setServiceContext(this.getServiceContext());
        }
        return this.actionManager;
    }

    public TableSelectionHelper getTableSelectionHelper() {
        if (this.tableSelectionHelper == null) {
            this.tableSelectionHelper = new CoreTableSelectionHelper((ListUI)this);
        }
        return this.tableSelectionHelper;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ClassGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        ClassGroupInfo objectValue = new ClassGroupInfo();
        return objectValue;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_classGroup_view");
        try {
            filter.mergeFilter(storageOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        IClassGroup iClassGroup = (IClassGroup)this.getBizInterface();
        int index = 0;
        IObjectPK[] pks = new IObjectPK[ids.size()];
        for (String id : ids) {
            pks[index++] = new ObjectUuidPK(id);
        }
        try {
            iClassGroup.pubFireVOChangeListener(ids, true);
            ((IClassGroup)this.getBizInterface()).approve(pks);
            String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgApproveSuccee");
            MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
            this.refresh(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            iClassGroup.pubFireVOChangeListener(ids, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int index = 0;
        IObjectPK[] pks = new IObjectPK[ids.size()];
        IClassGroup iClassGroup = (IClassGroup)this.getBizInterface();
        for (String id : ids) {
            pks[index++] = new ObjectUuidPK(id);
        }
        try {
            iClassGroup.pubFireVOChangeListener(ids, true);
            ((IClassGroup)this.getBizInterface()).unApprove(pks);
            String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgUnApproveSuccee");
            MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
            this.refresh(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            try {
                iClassGroup.pubFireVOChangeListener(ids, false);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ClassGroupInfo classGroupInfo = (ClassGroupInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (null != classGroupInfo && null != classGroupInfo.getStatus() && classGroupInfo.getStatus().getValue() == 20) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"Msg_ApprovedCannotEdit"));
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = null;
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && actoinName.equals("ActionEdit")) {
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return super.getOrgPK(action);
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            ClassGroupInfo classGroupInfo = null;
            try {
                classGroupInfo = (ClassGroupInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (classGroupInfo != null && classGroupInfo.getStorageOrgUnit() != null) {
                orgPK = new ObjectUuidPK(classGroupInfo.getStorageOrgUnit().getId());
            }
        } else {
            orgPK = super.getOrgPK(action);
        }
        return orgPK;
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        this.btnRefresh.doClick();
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return true;
    }

    public void doActionPerformed(BatchActionEnum bizAction, BatchSelectionEntries selectionEntry) {
    }

    public void handleBatchException(ActionProxy actionProxy, BatchSelectionEntries selectionEntry) throws Exception {
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
    }
}

