/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.ClassTeamFactory;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.mm.basedata.IClassTeam;
import com.kingdee.eas.mm.basedata.client.AbstractClassTeamListUI;
import com.kingdee.eas.mm.basedata.client.ClassTeamEditUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ClassTeamListUI
extends AbstractClassTeamListUI {
    private static final long serialVersionUID = 7940691346088766659L;
    private static final Logger logger = CoreUIObject.getLogger(ClassTeamListUI.class);
    private static final String[] KDT_TIMES = new String[]{"entrys.startTime", "entrys.endTime", "entrys.startRestTime", "entrys.endRestTime"};
    private String SETDEFCLASSTEAM_NAME = EASResource.getString((String)"com.kingdee.eas.mm.basedata.ClassTeamResource", (String)"SetDefClassTeam");

    public void onLoad() throws Exception {
        this.mergeColumns();
        super.onLoad();
        EditTableUtil.formatColTime((KDTable)this.tblMain, (String[])KDT_TIMES);
    }

    @Override
    public void actionSetDefault_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids.size() > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.ClassTeamResource", (String)"SetDefClassTeam"));
            SysUtil.abort();
        } else if (ids.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"OneCanSetDefault"));
            SysUtil.abort();
        } else {
            Object obj = ids.toArray()[0];
            ObjectUuidPK pk = new ObjectUuidPK(obj.toString());
            ((IClassTeam)this.getBizInterface()).setDefault((IObjectPK)pk);
            this.refresh(e);
        }
    }

    @Override
    protected String getEditUIName() {
        return ClassTeamEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ClassTeamFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ClassTeamInfo objectValue = new ClassTeamInfo();
        return objectValue;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void mergeColumns() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "storageOrgUnit.name", "name", "number", "status"};
        return columns;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_classTeam_view");
        try {
            filter.mergeFilter(storageOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int index = 0;
        IObjectPK[] pks = new IObjectPK[ids.size()];
        for (String id : ids) {
            pks[index++] = new ObjectUuidPK(id);
        }
        try {
            ((IClassTeam)this.getBizInterface()).pubFireVOChangeListener(ids, true);
            ((IClassTeam)this.getBizInterface()).approve(pks);
            String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgApproveSuccee");
            MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
            this.refresh(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            ((IClassTeam)this.getBizInterface()).pubFireVOChangeListener(ids, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int index = 0;
        IObjectPK[] pks = new IObjectPK[ids.size()];
        for (String id : ids) {
            pks[index++] = new ObjectUuidPK(id);
        }
        try {
            ((IClassTeam)this.getBizInterface()).pubFireVOChangeListener(ids, true);
            ((IClassTeam)this.getBizInterface()).unApprove(pks);
            String msg = ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"MsgUnApproveSuccee");
            MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
            this.refresh(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            ((IClassTeam)this.getBizInterface()).pubFireVOChangeListener(ids, true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ClassTeamInfo classTeamInfo = (ClassTeamInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (null != classTeamInfo && null != classTeamInfo.getStatus() && classTeamInfo.getStatus().getValue() == 20) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"Msg_ApprovedCannotEdit"));
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = null;
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && actoinName.equals("ActionEdit")) {
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return super.getOrgPK(action);
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            ClassTeamInfo classTeamInfo = null;
            try {
                classTeamInfo = (ClassTeamInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (classTeamInfo != null && classTeamInfo.getStorageOrgUnit() != null) {
                orgPK = new ObjectUuidPK(classTeamInfo.getStorageOrgUnit().getId());
            }
        } else {
            orgPK = super.getOrgPK(action);
        }
        return orgPK;
    }
}

