/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.mm.basedata.BasedataException;
import com.kingdee.eas.mm.basedata.CSReportEnum;
import com.kingdee.eas.mm.basedata.ControlStrategyCollection;
import com.kingdee.eas.mm.basedata.ControlStrategyFactory;
import com.kingdee.eas.mm.basedata.ControlStrategyInfo;
import com.kingdee.eas.mm.basedata.GenerateTypeEnum;
import com.kingdee.eas.mm.basedata.IControlStrategy;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.client.AbstractControlStrategyUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.STConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;

public class ControlStrategyUI
extends AbstractControlStrategyUI {
    private static final long serialVersionUID = 8576357173736240236L;
    private final String TB_ID = "id";
    private final String TB_NUMBER = "number";
    private final String TB_NAME = "name";
    private final String TB_DESCRIPTION = "description";
    private final String TB_STORAGEORGUNIT = "storageOrgUnit";
    private final String TB_STATUS = "status";
    private final String TB_OPCHECKGENTYPE = "opCheckGenType";
    private final String TB_OPTRANSFERGENTYPE = "opTransferGenType";
    private final String TB_INWAREHSGENTYPE = "inWareHsGenType";
    private final String TB_CREATOR = "creator.name";
    private final String TB_CREATETIME = "createTime";
    private final String TB_UPDATEUSER = "lastUpdateUser.name";
    private final String TB_UPDATETIME = "lastUpdateTime";
    private String UI_STATUS = "VIEW";
    private Color lockedColor = new Color(232, 232, 227);
    private RuleStatus ruleStatus;
    private ICodingRuleManager codingRuleManager;
    private KDTEditAdapter entryTableChange = null;
    private KDTActiveCellListener activeCellListener = null;
    private Integer rowId = new Integer(0);
    private StorageOrgUnitInfo currStorageInfo = null;
    private boolean isMutex = false;
    private boolean isChanged = false;
    private String[] copyColumns = new String[]{"name", "description", "opCheckGenType", "opTransferGenType", "inWareHsGenType"};
    private String[] columns = new String[]{"opTransferGenType", "opCheckGenType", "inWareHsGenType"};
    private final String[] KDT_DATES = new String[]{"createTime", "lastUpdateTime"};
    private Set newRows = new HashSet();
    private Set editRows = new HashSet();
    private Map userMap = new HashMap();
    KDBizMultiLangBox box = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.addSQLLogMenu((CoreUIObject)this, this.menuEdit);
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        Map uiContext = this.getUIContext();
        if (uiContext.get("sourceID") != null && uiContext.get("sourceID").equals("InitMmParamsUI")) {
            this.prmtStorageOrgUnit.setValue(uiContext.get("storageOrgUnitInfo"));
        } else {
            StorageOrgUnitInfo info = null;
            StorageOrgUnitInfo tempInfo = SysContext.getSysContext().getCurrentStorageUnit();
            if (tempInfo != null && tempInfo.isIsBizUnit()) {
                info = SysContext.getSysContext().getCurrentStorageUnit();
            } else if (tempInfo != null && tempInfo.isIsAdminOrgUnit()) {
                OrgUnitInfo[] mainOrgs = null;
                if (mainOrgs == null) {
                    try {
                        mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), "mm_controlStrategy_view");
                        if (mainOrgs.length > 0) {
                            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
                        }
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                    }
                }
                if (mainOrgs != null && mainOrgs.length > 0 && mainOrgs[0] != null) {
                    info = (StorageOrgUnitInfo)mainOrgs[0];
                }
            }
            this.prmtStorageOrgUnit.setValue((Object)info);
            this.currStorageInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        }
        this.currStorageInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_controlStrategy_view");
        this.initControls();
        this.dataBinding();
        this.lockTableColumn();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])this.KDT_DATES);
    }

    private void addSQLLogMenu(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift L"){
            private static final long serialVersionUID = 1L;

            public void action_actionPerformed() {
                try {
                    IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = factory.create("com.kingdee.eas.mm.common.client.SQLLogParamUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ControlStrategyFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getEditUIName() {
        return null;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public OrgType getMainType() {
        return OrgType.Storage;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.requestMutex("EDIT");
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            return;
        }
        this.setUIStatus("EDIT");
        this.actionEdit.setEnabled(false);
        this.actionSave.setEnabled(true);
        this.addRow.setEnabled(true);
        this.copyRow.setEnabled(true);
        this.deleteRow.setEnabled(true);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.lockTableColumn();
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            if (this.isChanged) {
                MsgBox.showInfo((String)this.getControlStrategyResource("Save_bef_Cancel"));
                SysUtil.abort();
            }
            try {
                this.requestMutex("CANCEL");
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                return;
            }
            this.doCancelOrCancelCancel(false, e);
            try {
                this.requestMutex("RELEASEALL");
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
            if (!this.isChanged) {
                this.dataBinding();
                this.lockTableColumn();
            }
        }
    }

    private void requestMutex(String opState) throws Throwable {
        if (this.currStorageInfo != null) {
            String lockObject = this.currStorageInfo.getId().toString();
            this.setOprtState(opState);
            this.pubFireVOChangeListener(lockObject);
            this.isMutex = !opState.equalsIgnoreCase("RELEASEALL");
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (this.isChanged) {
                MsgBox.showInfo((String)this.getControlStrategyResource("Save_bef_Cancel"));
                SysUtil.abort();
            }
            try {
                this.requestMutex("CANCELCANCEL");
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                return;
            }
            this.doCancelOrCancelCancel(true, e);
            try {
                this.requestMutex("RELEASEALL");
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
            if (!this.isChanged) {
                this.dataBinding();
                this.lockTableColumn();
            }
        }
    }

    private void doCancelOrCancelCancel(boolean active, ActionEvent e) throws Exception {
        IControlStrategy iControlStrategy = (IControlStrategy)this.getBizInterface();
        ArrayList ids = this.getSelectedIdValues();
        String message = null;
        ArrayList errors = null;
        StringBuffer errMsg = new StringBuffer();
        String forbidError = null;
        if (active) {
            errors = iControlStrategy.setCancelCancel(ids);
            message = this.getControlStrategyResource("cs_cancelcancel_succ");
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Start_Error");
        } else {
            errors = iControlStrategy.setCancel(ids);
            message = this.getControlStrategyResource("cs_cancel_succ");
            forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Forbid_Error");
        }
        if (errors != null && errors.size() > 0) {
            int index = errors.size();
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex != null) {
                    errMsg.append(ex.getMessage());
                    errMsg.append("\n");
                }
                --index;
            }
            message = "";
        }
        if (errMsg.toString().length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)forbidError, (String)errMsg.toString(), (int)8188);
        }
        this.setMessageText(message);
        this.showMessage();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.addRow_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.deleteRow_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionSave.setEnabled(false);
        this.actionEdit.setEnabled(true);
        this.addRow.setEnabled(false);
        this.copyRow.setEnabled(false);
        this.deleteRow.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuView.setVisible(false);
        this.btnView.setVisible(false);
        this.menuItemView.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.btnQuery.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.menuItemRefresh.setVisible(false);
        this.btnLocate.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.btnPrint.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.menuBiz.setVisible(true);
        this.menuBiz.setEnabled(true);
        this.menuItemCancel.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
        this.prmtStorageOrgUnit.setEnabled(true);
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isChanged) {
            b = true;
            b = this.checkSaveChange();
        }
        if (this.isMutex) {
            try {
                this.requestMutex("RELEASEALL");
            }
            catch (Throwable e) {
                this.handUIException(e);
            }
        }
        return b;
    }

    private boolean checkSaveChange() {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)"Confirm_Save_Exit"));
        if (result == 0) {
            try {
                this.actionSave_actionPerformed(null);
                return true;
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        return result != 2;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void addRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtStorageOrgUnit.getValue() != null) {
            Integer idValue;
            ICodingRuleManager codingRuleManager = this.getCodingRuleManager();
            StorageOrgUnitInfo storage = null;
            String newNum = null;
            if (this.prmtStorageOrgUnit.getValue() != null) {
                storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                this.ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new ControlStrategyInfo(), storage.getId().toString());
            }
            this.tblMain.checkParsed();
            IRow newRow = this.tblMain.addRow();
            this.rowId = idValue = new Integer(this.rowId + 1);
            newRow.getCell("id").setValue((Object)idValue);
            if (this.ruleStatus.isExist()) {
                if (this.ruleStatus.isAddView() && storage != null) {
                    newNum = this.getNewNumberByUnit(storage.getId().toString());
                    newRow.getCell("number").setValue((Object)newNum);
                }
            } else {
                this.tblMain.getCell(newRow.getRowIndex(), "number").getStyleAttributes().setLocked(false);
                this.tblMain.getCell(newRow.getRowIndex(), "number").getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            }
            newRow.getCell("storageOrgUnit").setValue(this.prmtStorageOrgUnit.getValue());
            newRow.getCell("status").setValue((Object)MMBasedataStatusEnum.ADDNEW);
            newRow.getCell("creator.name").setValue((Object)this.getUserInfo().getName());
            if (!this.userMap.containsKey(this.getUserInfo().getName())) {
                this.userMap.put(this.getUserInfo().getName(), this.getUserInfo());
            }
            newRow.getCell("createTime").setValue((Object)new Date());
            newRow.getCell("opCheckGenType").setValue((Object)GenerateTypeEnum.AutoGenarete);
            newRow.getCell("inWareHsGenType").setValue((Object)GenerateTypeEnum.HandGenerate);
            newRow.getCell("opTransferGenType").setValue((Object)GenerateTypeEnum.AutoGenarete);
            this.newRows.add(newRow);
            this.isChanged = true;
        }
    }

    @Override
    public void copyRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length != 1) {
            MsgBox.showInfo((String)this.getControlStrategyResource("choose_Row"));
            SysUtil.abort();
        }
        ICodingRuleManager codingRuleManager = this.getCodingRuleManager();
        StorageOrgUnitInfo storage = null;
        String newNum = null;
        if (this.prmtStorageOrgUnit.getValue() != null) {
            storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            this.ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new ControlStrategyInfo(), storage.getId().toString());
        }
        this.tblMain.checkParsed();
        IRow newRow = this.tblMain.addRow();
        Integer idValue = new Integer(this.newRows.size() + 1);
        newRow.getCell("id").setValue((Object)idValue);
        if (this.ruleStatus.isExist()) {
            if (this.ruleStatus.isAddView() && storage != null) {
                newNum = this.getNewNumberByUnit(storage.getId().toString());
                newRow.getCell("number").setValue((Object)newNum);
            }
        } else {
            this.tblMain.getColumn("number").getStyleAttributes().setLocked(false);
            this.tblMain.getColumn("number").getStyleAttributes().setBackground(new Color(255, 255, 255));
        }
        if (this.prmtStorageOrgUnit.getValue() != null) {
            newRow.getCell("storageOrgUnit").setValue(this.prmtStorageOrgUnit.getValue());
        }
        newRow.getCell("status").setValue((Object)MMBasedataStatusEnum.ADDNEW);
        newRow.getCell("creator.name").setValue((Object)this.getUserInfo().getName());
        if (!this.userMap.containsKey(this.getUserInfo().getName())) {
            this.userMap.put(this.getUserInfo().getName(), this.getUserInfo());
        }
        newRow.getCell("createTime").setValue((Object)new Date());
        IRow selectedRow = this.tblMain.getRow(selectRows[0]);
        this.coypRow(newRow, selectedRow);
        this.newRows.add(newRow);
        this.isChanged = true;
    }

    private void coypRow(IRow newRow, IRow oldRow) {
        for (int i = 0; i < this.copyColumns.length; ++i) {
            if (oldRow.getCell(this.copyColumns[i]).getValue() == null || this.copyColumns[i].equals("name")) continue;
            newRow.getCell(this.copyColumns[i]).setValue(oldRow.getCell(this.copyColumns[i]).getValue());
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isChanged) {
            return;
        }
        Iterator itc = this.newRows.iterator();
        CoreBaseCollection newColls = new CoreBaseCollection();
        CoreBaseCollection editColls = new CoreBaseCollection();
        while (itc.hasNext()) {
            IRow currRow = (IRow)itc.next();
            ControlStrategyInfo info = this.prepareData(currRow);
            newColls.add((CoreBaseInfo)info);
        }
        for (IRow currRow : this.editRows) {
            ControlStrategyInfo info = this.prepareData(currRow);
            editColls.add((CoreBaseInfo)info);
        }
        if (newColls.size() > 0) {
            try {
                ((IControlStrategy)this.getBizInterface()).save(newColls);
            }
            catch (EASBizException bizE) {
                this.handleNumberDupErr(bizE, this.newRows);
            }
        }
        if (editColls.size() > 0 && newColls.size() != editColls.size()) {
            try {
                ((IControlStrategy)this.getBizInterface()).update(editColls);
            }
            catch (EASBizException bizE) {
                this.handleNumberDupErr(bizE, this.editRows);
            }
        }
        this.btnCancel.setEnabled(true);
        this.menuItemCancel.setEnabled(true);
        this.menuItemCancelCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.newRows.clear();
        this.editRows.clear();
        this.isChanged = false;
        this.dataBinding();
        this.lockTableColumn();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setNextMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setShowMessagePolicy(2);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    private void handleNumberDupErr(EASBizException e, Set rows) throws EASBizException {
        String excMsg = e.getMessage();
        if (excMsg.startsWith("NAME")) {
            int errIndex = this.rowDataError("name", excMsg.substring(4), rows);
            this.tblMain.getEditManager().editCellAt(errIndex, this.tblMain.getColumnIndex("name"));
            throw new BasedataException(BasedataException.NAMEDUP, new Object[]{excMsg.substring(4)});
        }
        if (excMsg.startsWith("NUMBER")) {
            int errIndex = this.rowDataError("number", excMsg.substring(6), rows);
            this.tblMain.getEditManager().editCellAt(errIndex, this.tblMain.getColumnIndex("number"));
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{excMsg.substring(6)});
        }
        throw e;
    }

    @Override
    public void deleteRow_actionPerformed(ActionEvent e) throws Exception {
        boolean isYes;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length != 1) {
            MsgBox.showInfo((String)this.getControlStrategyResource("choose_Row"));
            SysUtil.abort();
        }
        if (!(isYes = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete"))))) {
            return;
        }
        if ((String)this.tblMain.getCell(selectRows[0], "number").getValue() != null && ((String)this.tblMain.getCell(selectRows[0], "number").getValue()).equals("0000")) {
            MsgBox.showInfo((String)this.getControlStrategyResource("IsDefaultControlStrategy_NotDelete"));
            SysUtil.abort();
        }
        if (!(this.tblMain.getCell(selectRows[0], "id").getValue() instanceof Integer)) {
            try {
                this.requestMutex("DELETE");
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.tblMain.getCell(selectRows[0], "id").getValue().toString()));
            try {
                this.requestMutex("RELEASEALL");
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
            this.tblMain.removeRow(selectRows[0]);
        } else {
            for (IRow currRow : this.newRows) {
                if (currRow.getCell("id").getValue() != this.tblMain.getRow(selectRows[0]).getCell("id").getValue()) continue;
                this.newRows.remove(currRow);
                break;
            }
            this.tblMain.removeRow(selectRows[0]);
        }
        if (this.newRows.size() <= 0 && this.editRows.size() <= 0) {
            this.isChanged = false;
        }
    }

    private ControlStrategyCollection queryControlStrategy() throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (storageOrgUnit == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("status"));
        view.getSelector().add(new SelectorItemInfo("cooStorageOrgUnit.*"));
        view.getSelector().add(new SelectorItemInfo("creator.*"));
        view.getSelector().add(new SelectorItemInfo("lastUpdateUser.*"));
        view.getSelector().add(new SelectorItemInfo("entrustSupplier.*"));
        SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
        aSorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(aSorterItemInfo);
        return ((IControlStrategy)this.getBizInterface()).getControlStrategyCollection(view);
    }

    private void initControls() {
        KDComboBox comStatus = new KDComboBox();
        comStatus.removeAllItems();
        comStatus.addItems(new Object[]{MMBasedataStatusEnum.ADDNEW, MMBasedataStatusEnum.SAVED, MMBasedataStatusEnum.CLOSE, MMBasedataStatusEnum.OPEN});
        KDComboBox comGenType = new KDComboBox();
        comGenType.removeAllItems();
        comGenType.addItems(new Object[]{GenerateTypeEnum.AutoGenarete, GenerateTypeEnum.HandGenerate});
        KDComboBox comReport = new KDComboBox();
        comReport.removeAllItems();
        comReport.addItems(new Object[]{CSReportEnum.ALLOWED, CSReportEnum.NOTALLOWED});
        KDComboBox comEntrustType = new KDComboBox();
        comEntrustType.removeAllItems();
        KDBizPromptBox user = new KDBizPromptBox();
        user.setDisplayFormat("$name$");
        user.setEditable(false);
        KDDatePicker startDate = new KDDatePicker();
        KDDatePicker endDate = new KDDatePicker();
        startDate.setBackground(SCMClientUtils.necessaryColor);
        endDate.setBackground(SCMClientUtils.necessaryColor);
        if (this.box == null) {
            this.box = new KDBizMultiLangBox();
            this.box.setMaxLength(255);
            this.box.selectedDefaultLangItem();
        }
        this.tblMain.getColumn(this.TB_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.box));
        this.tblMain.getColumn(this.TB_DESCRIPTION).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.box));
        this.tblMain.getColumn("status").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comStatus));
        this.tblMain.getColumn("opCheckGenType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comGenType));
        this.tblMain.getColumn("opTransferGenType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comGenType));
        this.tblMain.getColumn("inWareHsGenType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comGenType));
        this.tblMain.getColumn("creator.name").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)user));
        this.tblMain.getColumn("lastUpdateUser.name").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)user));
        this.tblMain.getColumn("createTime").setEditor((ICellEditor)new KDTDefaultCellEditor(startDate));
        this.tblMain.getColumn("lastUpdateTime").setEditor((ICellEditor)new KDTDefaultCellEditor(endDate));
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ControlStrategyUI.this.handleStorageChanged(eventObj);
                }
                catch (Exception e) {
                    ControlStrategyUI.this.handUIException(e);
                }
            }
        });
        this.prmtStorageOrgUnit.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ControlStrategyUI.this.beforeStorageChange();
                }
                catch (Exception e1) {
                    e.setCanceled(true);
                    ControlStrategyUI.this.handUIException(e1);
                }
            }
        });
    }

    private void beforeStorageChange() throws Exception {
        int result;
        if (this.isChanged && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)ResourceManage.getResource((String)"cs_dataCHG"))) == 0) {
            this.actionSave_actionPerformed(null);
        }
    }

    private void handleStorageChanged(DataChangeEvent eventObj) throws BOSException, Exception {
        Object newValue = eventObj.getNewValue();
        Object oldValue = eventObj.getOldValue();
        if (newValue == null) {
            MsgBox.showError((String)this.getControlStrategyResource("ControlStrategyStorageOrg_IsNotNull"));
            this.prmtStorageOrgUnit.setValue(oldValue);
            return;
        }
        if (newValue.equals(oldValue)) {
            return;
        }
        if (this.isMutex) {
            try {
                this.requestMutex("RELEASEALL");
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
        }
        this.currStorageInfo = (StorageOrgUnitInfo)newValue;
        this.getUIContext().put(this.getMainBizOrgType(), this.currStorageInfo);
        this.getMainOrgContext().put((Object)this.getMainBizOrgType(), (Object)this.currStorageInfo);
        this.setUIStatus("VIEW");
        this.initWorkButton();
        this.isChanged = false;
        this.newRows.clear();
        this.editRows.clear();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.dataBinding();
        this.lockTableColumn();
    }

    private void dataBinding() throws BOSException, Exception {
        this.tblMain.repaint();
        this.tblMain.removeRows();
        ControlStrategyCollection csColls = this.queryControlStrategy();
        if (csColls == null || csColls.size() == 0) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                this.actionEdit.setEnabled(false);
            }
            return;
        }
        for (int i = 0; i < csColls.size(); ++i) {
            ControlStrategyInfo info = csColls.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("description").setValue((Object)info.getDescription());
            row.getCell("status").setValue((Object)info.getStatus());
            row.getCell("opCheckGenType").setValue((Object)info.getOpCheckGenType());
            row.getCell("opTransferGenType").setValue((Object)info.getOpTransferGenType());
            row.getCell("inWareHsGenType").setValue((Object)info.getInWareHsGenType());
            if (info.getCreator() != null) {
                row.getCell("creator.name").setValue((Object)info.getCreator().getName());
                if (!this.userMap.containsKey(info.getCreator().getName())) {
                    this.userMap.put(info.getCreator().getName(), info.getCreator());
                }
            }
            row.getCell("createTime").setValue((Object)info.getCreateTime());
            if (info.getLastUpdateUser() != null) {
                row.getCell("lastUpdateUser.name").setValue((Object)info.getLastUpdateUser().getName());
                if (!this.userMap.containsKey(info.getLastUpdateUser().getName())) {
                    this.userMap.put(info.getLastUpdateUser().getName(), info.getLastUpdateUser());
                }
            }
            row.getCell("lastUpdateTime").setValue((Object)info.getLastUpdateTime());
            row.getCell("storageOrgUnit").setValue((Object)info.getStorageOrgUnit());
            if (info.getStatus().getValue() == 20) {
                row.getStyleAttributes().setBackground(this.lockedColor);
            }
            row.getCell("number").getStyleAttributes().setBackground(this.lockedColor);
            row.getCell("number").getStyleAttributes().setLocked(true);
        }
    }

    protected void initListener() {
        super.initListener();
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    try {
                        ControlStrategyUI.this.kdtMain_editStarting(e);
                    }
                    catch (Exception exc) {
                        ControlStrategyUI.this.handUIException(exc);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        ControlStrategyUI.this.kdtMain_Changed(e);
                    }
                    catch (Exception exc) {
                        ControlStrategyUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.activeCellListener == null) {
            this.activeCellListener = new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    try {
                        ControlStrategyUI.this.tableCellActived(e);
                    }
                    catch (Exception exc) {
                        ControlStrategyUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTActiveCellListener(this.activeCellListener);
    }

    private void hideColumns(String[] hideColumns, String[] showColumns) {
        int i;
        for (i = 0; i < showColumns.length; ++i) {
            this.tblMain.getColumn(showColumns[i]).getStyleAttributes().setHided(false);
        }
        for (i = 0; i < hideColumns.length; ++i) {
            this.tblMain.getColumn(hideColumns[i]).getStyleAttributes().setHided(true);
        }
    }

    private void lockTableColumn() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("status").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creator.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("createTime").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("lastUpdateUser.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("status").getStyleAttributes().setBackground(this.lockedColor);
        this.tblMain.getColumn("creator.name").getStyleAttributes().setBackground(this.lockedColor);
        this.tblMain.getColumn("createTime").getStyleAttributes().setBackground(this.lockedColor);
        this.tblMain.getColumn("lastUpdateUser.name").getStyleAttributes().setBackground(this.lockedColor);
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setBackground(this.lockedColor);
        this.tblMain.getColumn("number").getStyleAttributes().setBackground(this.lockedColor);
        this.tblMain.getColumn("name").getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            MMBasedataStatusEnum status = MMBasedataStatusEnum.ADDNEW;
            if (this.tblMain.getCell(i, "status").getValue() != null) {
                status = (MMBasedataStatusEnum)this.tblMain.getCell(i, "status").getValue();
            }
            if (status.getValue() != 30) {
                if (status.getValue() == 20) {
                    this.tblMain.getRow(i).getStyleAttributes().setLocked(true);
                } else if (status.getValue() == 10) {
                    // empty if block
                }
            }
            if (this.getUIStatus().equalsIgnoreCase("VIEW")) {
                // empty if block
            }
            if (this.getUIStatus().equalsIgnoreCase("EDIT")) {
                // empty if block
            }
            this.tblMain.getRow(i).getCell("number").getStyleAttributes().setLocked(true);
            if (!((String)this.tblMain.getRow(i).getCell("number").getValue()).equals("0000")) continue;
            this.tblMain.getCell(i, "number").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "number").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "name").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "name").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "description").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "description").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "storageOrgUnit").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "storageOrgUnit").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "status").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "status").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "opCheckGenType").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "opCheckGenType").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "opTransferGenType").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "opTransferGenType").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "inWareHsGenType").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "inWareHsGenType").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "creator.name").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "creator.name").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "createTime").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "createTime").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "lastUpdateUser.name").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "lastUpdateUser.name").getStyleAttributes().setBackground(this.lockedColor);
            this.tblMain.getCell(i, "lastUpdateTime").getStyleAttributes().setLocked(true);
            this.tblMain.getCell(i, "lastUpdateTime").getStyleAttributes().setBackground(this.lockedColor);
        }
    }

    public void kdtMain_editStarting(KDTEditEvent e) throws Exception {
    }

    public void kdtMain_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (isDiffrent) {
            if (this.tblMain.getColumnKey(colIndex).equalsIgnoreCase("number")) {
                this.tblMain.getRow(rowIndex).getCell("number").setValue(newValue);
            }
            if (this.tblMain.getColumnKey(colIndex).equalsIgnoreCase("name")) {
                this.tblMain.getRow(rowIndex).getCell("name").setValue(newValue);
            }
            if (this.tblMain.getRow(rowIndex).getCell("id").getValue() instanceof BOSUuid) {
                Iterator it = this.editRows.iterator();
                String currRowId = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
                boolean isExist = false;
                while (it.hasNext()) {
                    IRow row = (IRow)it.next();
                    String id = row.getCell("id").getValue().toString();
                    if (!currRowId.equalsIgnoreCase(id)) continue;
                    isExist = true;
                }
                if (!isExist) {
                    this.editRows.add(this.tblMain.getRow(rowIndex));
                }
            }
            this.isChanged = true;
        }
    }

    protected void tableCellActived(KDTActiveCellEvent e) {
    }

    protected ControlStrategyInfo prepareData(IRow row) throws EASBizException, BOSException {
        ControlStrategyInfo info = new ControlStrategyInfo();
        String number = null;
        if (!(row.getCell("id").getValue() instanceof Integer)) {
            info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        }
        if (row.getCell("number").getValue() != null) {
            number = (String)row.getCell("number").getValue();
        } else if (null == row.getCell("number").getValue() || "".equals(row.getCell("number").getValue())) {
            number = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
            row.getCell("number").setValue((Object)number);
        }
        String name = null;
        if (row.getCell("name").getValue() != null && !StringUtil.isEmpty((String)((String)row.getCell("name").getValue()))) {
            name = (String)row.getCell("name").getValue();
        } else {
            String messageFormatString = this.getControlStrategyResource("ControlStrategyName_IsNotNull");
            MessageFormat messageFormat = new MessageFormat(messageFormatString);
            String msg = messageFormat.format(new String[]{" " + (row.getRowIndex() + 1) + " "});
            MsgBox.showInfo((String)msg);
            this.tblMain.getEditManager().editCellAt(row.getRowIndex(), this.tblMain.getColumnIndex("name"));
            SysUtil.abort();
        }
        info.setNumber(number);
        info.setName(name);
        if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L2")) {
            info.setName(STConverter.sc2tc((String)info.getName(new Locale("L2"))), new Locale("L3"));
        } else if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L3")) {
            info.setName(STConverter.tc2sc((String)info.getName(new Locale("L3"))), new Locale("L2"));
        }
        if (row.getCell("storageOrgUnit").getValue() != null) {
            info.setStorageOrgUnit((StorageOrgUnitInfo)row.getCell("storageOrgUnit").getValue());
        }
        if (row.getCell("description").getValue() != null) {
            info.setDescription((String)row.getCell("description").getValue());
        }
        if (!StringUtil.isEmpty((String)info.getDescription())) {
            if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L2")) {
                info.setDescription(STConverter.sc2tc((String)info.getDescription(new Locale("L2"))), new Locale("L3"));
            } else if (SysContext.getSysContext().getLocale().toString().equalsIgnoreCase("L3")) {
                info.setDescription(STConverter.tc2sc((String)info.getDescription(new Locale("L3"))), new Locale("L2"));
            }
        }
        if (row.getCell("status").getValue() != null) {
            MMBasedataStatusEnum status = (MMBasedataStatusEnum)row.getCell("status").getValue();
            if (status.getValue() == 40) {
                info.setStatus(MMBasedataStatusEnum.SAVED);
            } else {
                info.setStatus(status);
            }
        }
        if (row.getCell("opCheckGenType").getValue() != null) {
            info.setOpCheckGenType((GenerateTypeEnum)((Object)row.getCell("opCheckGenType").getValue()));
        }
        if (row.getCell("opTransferGenType").getValue() != null) {
            info.setOpTransferGenType((GenerateTypeEnum)((Object)row.getCell("opTransferGenType").getValue()));
        }
        if (row.getCell("inWareHsGenType").getValue() != null) {
            info.setInWareHsGenType((GenerateTypeEnum)((Object)row.getCell("inWareHsGenType").getValue()));
        }
        if (row.getCell("creator.name").getValue() != null) {
            info.setCreator((UserInfo)this.userMap.get((String)row.getCell("creator.name").getValue()));
        }
        info.setLastUpdateUser(this.getUserInfo());
        return info;
    }

    private int rowDataError(String col, String value, Set rows) {
        for (IRow row : rows) {
            if (!row.getCell(col).getValue().toString().equalsIgnoreCase(value)) continue;
            return row.getRowIndex();
        }
        return -1;
    }

    private String getControlStrategyResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)sKey);
    }

    public String getUIStatus() {
        return this.UI_STATUS;
    }

    public void setUIStatus(String ui_status) {
        this.UI_STATUS = ui_status;
    }

    private ICodingRuleManager getCodingRuleManager() throws BOSException {
        if (this.codingRuleManager == null) {
            this.codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        return this.codingRuleManager;
    }

    private String getNewNumberByUnit(String bizOrgUnitID) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = this.getCodingRuleManager();
        return codingRuleManager.getNumber((IObjectValue)new ControlStrategyInfo(), bizOrgUnitID);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        return orgPK;
    }
}

