/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.client.AbstractDesignModeListUI;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DesignModeListUI
extends AbstractDesignModeListUI {
    private static final Logger logger = CoreUIObject.getLogger(DesignModeListUI.class);
    private String RESOURCE_NAME = "com.kingdee.eas.mm.basedata.DesignModeResource";

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DesignModeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DesignModeInfo objectValue = new DesignModeInfo();
        return objectValue;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnUpdateInit.setEnabled(true);
        this.btnAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
    }

    public boolean verifyCtrlid(String billID) throws Exception {
        if (billID == null || "".equals(billID)) {
            return true;
        }
        String controlunitid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU.id"));
        DesignModeInfo dsInfo = DesignModeFactory.getRemoteInstance().getDesignModeInfo((IObjectPK)new ObjectUuidPK(billID), sic);
        if (dsInfo.getCU() != null && !dsInfo.getCU().getId().toString().equals(controlunitid)) {
            MsgBox.showWarning((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"CUNOSame"));
            return false;
        }
        return true;
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("checkLicense", "false");
        this.setMergeColumn();
        super.onLoad();
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "name", "project", "trackNumber", "bomType", "status", "description"};
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemAddNew});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemRemove});
    }

    protected String getKeyFieldNmae() {
        return "id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (!this.verifyCtrlid(id)) {
            return;
        }
        DesignModeInfo info = DesignModeFactory.getRemoteInstance().getDesignModeInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getStatus() != null && info.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUsed_NoEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String errorString = "";
        for (int i = 0; i < idList.size(); ++i) {
            String id = idList.get(i).toString();
            DesignModeInfo info = DesignModeFactory.getRemoteInstance().getDesignModeInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getStatus() == null || !info.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                errorString = errorString + EASResource.getString((String)this.RESOURCE_NAME, (String)"Rows_isUnEnabled", (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            if (!this.verifyCtrlid(id)) continue;
            DesignModeFactory.getRemoteInstance().cancel((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        }
        if (errorString != null && !errorString.equals("")) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"ErrorInfo"), (String)errorString, (int)0);
        }
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String errorString = "";
        for (int i = 0; i < idList.size(); ++i) {
            String id = idList.get(i).toString();
            DesignModeInfo info = DesignModeFactory.getRemoteInstance().getDesignModeInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getStatus() != null && info.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                errorString = errorString + EASResource.getString((String)this.RESOURCE_NAME, (String)"Rows_isEnabled", (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            if (!this.verifyCtrlid(id)) continue;
            DesignModeFactory.getRemoteInstance().cancelCancel((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        }
        if (errorString != null && !errorString.equals("")) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"ErrorInfo"), (String)errorString, (int)0);
        }
        this.refreshList();
    }

    @Override
    public void actionUpdateInit_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESOURCE_NAME, (String)"updateInit_Affirm")) == 2) {
            SysUtil.abort();
        }
        DesignModeFactory.getRemoteInstance().updateByinit(null);
        this.refreshList();
    }
}

