/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.mm.basedata.EquipmentCalendarInfo;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.client.AbstractEquipmentCalendarDayPropertyEditUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class EquipmentCalendarDayPropertyEditUI
extends AbstractEquipmentCalendarDayPropertyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentCalendarDayPropertyEditUI.class);
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.basedata.EquipmentCalendarResource";
    private EquipmentCalendarInfo calendarInfo = null;
    private ProductLineCollection productLineCollection = null;
    private boolean OK;
    private boolean allProductLine;
    private boolean workDayResult;
    private HashMap result = null;
    private static final String TABLE_HEAD_ISWORKDAY = "IsWorkDay";
    private static final String TABLE_HEAD_PRODUCTLINE_CODE = "ProductLineCode";
    private static final String TABLE_HEAD_PRODUCTLINE_NAME = "ProductLineName";
    private static final String TABLE_HEAD_PRODUCTLINE_REMARK = "ProductLineRemark";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void buildProductLineTable() {
        this.clearTableView();
        this.buildProductLineTableHead();
        this.buildProductLineTableBody();
    }

    private void buildProductLineTableHead() {
        String[] tableHeaders = new String[]{TABLE_HEAD_ISWORKDAY, TABLE_HEAD_PRODUCTLINE_CODE, TABLE_HEAD_PRODUCTLINE_NAME, TABLE_HEAD_PRODUCTLINE_REMARK};
        IRow headerRow = this.tableProductLine.addHeadRow();
        for (int nIndex = 0; nIndex < tableHeaders.length; ++nIndex) {
            String curHeaderKey = tableHeaders[nIndex];
            IColumn headerCol = this.tableProductLine.addColumn();
            headerCol.setKey(curHeaderKey);
            headerRow.getCell(curHeaderKey).setValue((Object)this.getResource(curHeaderKey));
            if (curHeaderKey.equals(TABLE_HEAD_ISWORKDAY)) {
                KDCheckBox checkBox = new KDCheckBox();
                KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
                headerCol.setEditor((ICellEditor)checkBoxEditor);
                headerCol.setWidth(50);
                continue;
            }
            headerCol.getStyleAttributes().setLocked(true);
            headerCol.setWidth(90);
        }
    }

    private void clearTableView() {
        this.tableProductLine.removeHeadRows();
        this.tableProductLine.removeColumns();
        this.tableProductLine.removeRows();
        this.tableProductLine.removeColumns();
    }

    private void buildProductLineTableBody() {
        if (this.calendarInfo == null || this.productLineCollection == null || this.productLineCollection.size() <= 0) {
            return;
        }
        for (int nIndex = 0; nIndex < this.productLineCollection.size(); ++nIndex) {
            ProductLineInfo productLineInfo = this.productLineCollection.get(nIndex);
            IRow curRow = this.tableProductLine.addRow();
            curRow.setUserObject((Object)productLineInfo);
            if (this.calendarInfo.getWorkDay() == WorkDateTypeEnum.WORKDAY) {
                curRow.getCell(TABLE_HEAD_ISWORKDAY).setValue((Object)new Boolean(false));
            } else {
                curRow.getCell(TABLE_HEAD_ISWORKDAY).setValue((Object)new Boolean(true));
            }
            curRow.getCell(TABLE_HEAD_PRODUCTLINE_CODE).setValue((Object)productLineInfo.getNumber());
            curRow.getCell(TABLE_HEAD_PRODUCTLINE_NAME).setValue((Object)productLineInfo.getName());
            curRow.getCell(TABLE_HEAD_PRODUCTLINE_REMARK).setValue((Object)productLineInfo.getDescription());
        }
    }

    public EquipmentCalendarInfo getCalendarInfo() {
        return this.calendarInfo;
    }

    public void setCalendarInfo(EquipmentCalendarInfo calendarInfo) {
        this.calendarInfo = calendarInfo;
    }

    public ProductLineCollection getProductLineCollection() {
        return this.productLineCollection;
    }

    public void setProductLineCollection(ProductLineCollection productLineCollection) {
        this.productLineCollection = productLineCollection;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void actionSelAll_actionPerformed(ActionEvent e) throws Exception {
        for (int nIndex = 0; nIndex < this.tableProductLine.getRowCount(); ++nIndex) {
            this.tableProductLine.getRow(nIndex).getCell(TABLE_HEAD_ISWORKDAY).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionClrAll_actionPerformed(ActionEvent e) throws Exception {
        for (int nIndex = 0; nIndex < this.tableProductLine.getRowCount(); ++nIndex) {
            this.tableProductLine.getRow(nIndex).getCell(TABLE_HEAD_ISWORKDAY).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.result = new HashMap();
        this.setWorkDayResult(false);
        for (int nIndex = 0; nIndex < this.tableProductLine.getRowCount(); ++nIndex) {
            IRow curRow = this.tableProductLine.getRow(nIndex);
            Boolean curWorkDay = (Boolean)curRow.getCell(TABLE_HEAD_ISWORKDAY).getValue();
            ProductLineInfo productLineInfo = (ProductLineInfo)curRow.getUserObject();
            this.result.put(productLineInfo.getId().toString(), curWorkDay);
            if (!curWorkDay.equals(Boolean.TRUE)) continue;
            this.setWorkDayResult(true);
        }
        if (this.calendarInfo.getWorkDay().equals((Object)WorkDateTypeEnum.WORKDAY) && !this.isWorkDayResult() && !this.isAllProductLine()) {
            this.setWorkDayResult(true);
        }
        this.setOK(true);
        this.destroyWindow();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.setOK(false);
        this.destroyWindow();
    }

    public boolean isOK() {
        return this.OK;
    }

    public void setOK(boolean ok) {
        this.OK = ok;
    }

    private String getResource(String key) {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)key);
    }

    public boolean isWorkDayResult() {
        return this.workDayResult;
    }

    public void setWorkDayResult(boolean workDayResult) {
        this.workDayResult = workDayResult;
    }

    public HashMap getResult() {
        return this.result;
    }

    public void setResult(HashMap result) {
        this.result = result;
    }

    public boolean isAllProductLine() {
        return this.allProductLine;
    }

    public void setAllProductLine(boolean allProductLine) {
        this.allProductLine = allProductLine;
    }
}

