/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.ClassTeamEntryCollection;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.mm.basedata.EquipmentCalendarCollection;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryCollection;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryInfo;
import com.kingdee.eas.mm.basedata.EquipmentCalendarException;
import com.kingdee.eas.mm.basedata.EquipmentCalendarFactory;
import com.kingdee.eas.mm.basedata.EquipmentCalendarInfo;
import com.kingdee.eas.mm.basedata.EquipmentCalendarPeriodInfo;
import com.kingdee.eas.mm.basedata.IEquipmentCalendar;
import com.kingdee.eas.mm.basedata.OprStatusEnum;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.client.AbstractEquipmentCalendarEditUI;
import com.kingdee.eas.mm.basedata.client.EquipmentCalendarDayPropertyEditUI;
import com.kingdee.eas.mm.basedata.client.EquipmentCalendarDynamicColObject;
import com.kingdee.eas.mm.basedata.client.EquipmentCalendarGenCondUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class EquipmentCalendarEditUI
extends AbstractEquipmentCalendarEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentCalendarEditUI.class);
    private KDTEditAdapter tableMainChange;
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.basedata.EquipmentCalendarResource";
    private static final String TABLE_HEAD_ID = "ID";
    private static final String TABLE_HEAD_WORKDATE = "WorkDate";
    private static final String TABLE_HEAD_ISWORKDAY = "IsWorkDay";
    private static final String TABLE_HEAD_ABILITYTOTAL = "TotalAbility";
    private static final int TABLE_HEAD_COLUMN_NUM = 3;
    private static final int TABLE_HEAD_PRODUCTLINE = 0;
    private static final int TABLE_HEAD_CLASSTEAMENTRY = 1;
    private static final int TABLE_HEAD_EQUIPMENTCALENDAR = 2;
    private static final int EQUIPMENTCALENDAR_COLUMN_NUM = 6;
    private static final int TABLE_HEAD_EQUIPMENTCALENDAR_TOTALABILITY = 0;
    private static final int TABLE_HEAD_EQUIPMENTCALENDAR_STARTTIME = 1;
    private static final int TABLE_HEAD_EQUIPMENTCALENDAR_ENDTIME = 2;
    private static final int TABLE_HEAD_EQUIPMENTCALENDAR_STARTRESTTIME = 3;
    private static final int TABLE_HEAD_EQUIPMENTCALENDAR_ENDRESTTIME = 4;
    private static final int TABLE_HEAD_EQUIPMENTCALENDAR_ABILITY = 5;
    private static final Color COLOR_WORK = Color.WHITE;
    private static final Color COLOR_REST = new Color(255, 255, 155);
    private ProductLineCollection productLineCollection = null;
    private ProductLineCollection tableHead = null;
    private EquipmentCalendarCollection tableBody = null;
    EquipmentCalendarPeriodInfo period = null;
    private boolean modified = false;
    private HashMap hmDynamicColumn = null;
    private static final String DYNAMIC_COLUMN_SPLIT_PREFIX = "-";
    private static final float CALC_TIME_SPACE_NUM = 3600000.0f;
    private static final float CALC_DAY_SPACE_NUM = 8.64E7f;
    private static final int DAY_UP_ENJOIN = 31;
    private static final int ABILITY_SCALE = 2;

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.actionSaveEquipmentCalendar.setEnabled(modified);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setModified(false);
        this.btnRemoveEquipmentCalendar.setIcon(EASResource.getIcon((String)"imgTbtn_distributedeletcalog"));
        this.menuItemBizRemove.setIcon(EASResource.getIcon((String)"imgTbtn_distributedeletcalog"));
        this.tableMainChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    EquipmentCalendarEditUI.this.tableMain_OnChange(e);
                }
                catch (Exception ex) {
                    EquipmentCalendarEditUI.this.handUIException(ex);
                }
                super.editValueChanged(e);
            }

            public void editStarting(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                if ((colIndex - 3) % 6 == 0) {
                    e.setCancel(true);
                }
            }

            public void editValueChanged(KDTEditEvent e) {
            }
        };
        this.tblMain.addKDTEditListener((KDTEditListener)this.tableMainChange);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.pmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_equipmentcalendar_search");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_equipmentcalendar_search");
        this.pmptStorageOrgUnit.setValue((Object)orgInfo);
        Date startDate = null;
        Date endDate = null;
        Date currentDate = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.set(5, 1);
        startDate = calendar.getTime();
        calendar.add(2, 1);
        calendar.add(5, -1);
        endDate = calendar.getTime();
        this.dateStartDate.setValue((Object)startDate);
        this.dateEndDate.setValue((Object)endDate);
        if (orgInfo == null) {
            this.lblECPeriod.setVisible(false);
        }
        this.tblMain.getActionMap().put("Delete", null);
        this.menuItemWorkDaySet.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.tblMain, (KeyStroke)KeyStroke.getKeyStroke(32, 0));
    }

    @Override
    public void actionWorkDaySet_actionPerformed(ActionEvent e) throws Exception {
        int nRow = this.tblMain.getSelectManager().getActiveRowIndex();
        int nCol = this.tblMain.getColumnIndex(TABLE_HEAD_ISWORKDAY);
        if (nRow < 0 || nRow >= this.tblMain.getRowCount()) {
            return;
        }
        this.setCalendarWorkDay(nRow, nCol);
    }

    private void setCalendarWorkDay(int nRow, int nCol) {
        try {
            IRow curRow = this.tblMain.getRow(nRow);
            ICell cell = curRow.getCell(TABLE_HEAD_ISWORKDAY);
            cell.setRenderer(null);
            EquipmentCalendarInfo equipmentCalendarInfo = (EquipmentCalendarInfo)curRow.getUserObject();
            EquipmentCalendarDayPropertyEditUI uiObject = this.showDayPropertyEditDlg(equipmentCalendarInfo, this.tableHead);
            if (uiObject.isOK()) {
                this.tblMain.getCell(nRow, nCol).setValue((Object)new Boolean(uiObject.isWorkDayResult()));
                if (uiObject.isWorkDayResult()) {
                    equipmentCalendarInfo.setWorkDay(WorkDateTypeEnum.WORKDAY);
                } else {
                    equipmentCalendarInfo.setWorkDay(WorkDateTypeEnum.RESTDAY);
                }
                equipmentCalendarInfo.setStatus(OprStatusEnum.MODIFIED);
                this.replaceWorkDay(curRow, uiObject.isWorkDayResult() ? WorkDateTypeEnum.WORKDAY : WorkDateTypeEnum.RESTDAY, uiObject.getResult(), false);
                this.setModified(true);
                this.tblMain.getSelectManager().select(0, 0);
            }
        }
        catch (Exception exception) {
            this.handUIException(exception);
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0 || this.tblMain.getColumnKey(e.getColIndex()) == null) {
            return;
        }
        if (e.getColIndex() == this.tblMain.getColumnIndex(TABLE_HEAD_ISWORKDAY)) {
            this.setCalendarWorkDay(e.getRowIndex(), e.getColIndex());
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"Storage");
    }

    public boolean destroyWindow() {
        try {
            this.promptSaveOperation();
            return super.destroyWindow();
        }
        catch (Exception e) {
            this.handUIException(e);
            return false;
        }
    }

    private void promptSaveOperation() throws Exception {
        if (this.isModified()) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"AskWantSave")) == 0) {
                this.saveEquipmentCalendar();
            } else {
                this.setModified(false);
            }
        }
    }

    private void fireTableHeader(ProductLineCollection productLineCollection) throws Exception {
        int nIndex;
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        int nHeadRows = 3;
        IColumn curCol = null;
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_ID);
        curCol.getStyleAttributes().setHided(true);
        curCol = this.tblMain.addColumn();
        curCol.getStyleAttributes().setLocked(true);
        curCol.setKey(TABLE_HEAD_WORKDATE);
        curCol.setWidth(80);
        KDDatePicker dataPicker = new KDDatePicker();
        KDTDefaultCellEditor dataPickerEditor = new KDTDefaultCellEditor(dataPicker);
        curCol.setEditor((ICellEditor)dataPickerEditor);
        int workDateColIndex = curCol.getColumnIndex();
        curCol = this.tblMain.addColumn();
        curCol.setKey(TABLE_HEAD_ISWORKDAY);
        curCol.setWidth(50);
        KDCheckBox checkBox = new KDCheckBox();
        checkBox.setEnabled(false);
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        curCol.setEditor((ICellEditor)checkBoxEditor);
        int isWorkDateColIndex = curCol.getColumnIndex();
        this.tblMain.addHeadRows(nHeadRows);
        for (nIndex = 0; nIndex < nHeadRows; ++nIndex) {
            this.tblMain.getHeadRow(nIndex).getCell(TABLE_HEAD_WORKDATE).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)TABLE_HEAD_WORKDATE));
            this.tblMain.getHeadRow(nIndex).getCell(TABLE_HEAD_ISWORKDAY).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)TABLE_HEAD_ISWORKDAY));
        }
        this.tblMain.getHeadMergeManager().mergeBlock(0, workDateColIndex, nHeadRows - 1, workDateColIndex);
        this.tblMain.getHeadMergeManager().mergeBlock(0, isWorkDateColIndex, nHeadRows - 1, isWorkDateColIndex);
        this.hmDynamicColumn = null;
        for (nIndex = 0; productLineCollection != null && nIndex < productLineCollection.size(); ++nIndex) {
            ProductLineInfo productLineInfo = productLineCollection.get(nIndex);
            ProductLineInfo selProductLineInfo = (ProductLineInfo)this.cmbProductLine.getSelectedItem();
            if (selProductLineInfo != null && selProductLineInfo.getName() != null && !productLineInfo.getId().equals((Object)selProductLineInfo.getId()) || productLineInfo.getClassTeam() == null) continue;
            ClassTeamInfo classTeamInfo = productLineInfo.getClassTeam();
            ClassTeamEntryCollection classTeamEntryCollection = classTeamInfo.getEntrys();
            boolean isExist = false;
            if (classTeamEntryCollection == null) continue;
            for (int nClassTeamIndex = 0; nClassTeamIndex < classTeamEntryCollection.size(); ++nClassTeamIndex) {
                ClassTeamEntryInfo classTeamEntryInfo = classTeamEntryCollection.get(nClassTeamIndex);
                int nOldColumnNum = this.tblMain.getColumnCount();
                this.tblMain.addColumns(6);
                this.putDynamicColumnNum(productLineInfo, classTeamInfo, classTeamEntryInfo, nOldColumnNum);
                KDTimePicker timePicker = new KDTimePicker();
                KDTDefaultCellEditor timePickerEditor = new KDTDefaultCellEditor((IKDEditor)timePicker);
                IColumn curColumn = null;
                curColumn = this.tblMain.getColumn(nOldColumnNum + 1);
                curColumn.setEditor((ICellEditor)timePickerEditor);
                curColumn.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getTimeFormatString());
                curColumn.getStyleAttributes().setLocked(true);
                curColumn.setWidth(80);
                curColumn = this.tblMain.getColumn(nOldColumnNum + 2);
                curColumn.setEditor((ICellEditor)timePickerEditor);
                curColumn.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getTimeFormatString());
                curColumn.getStyleAttributes().setLocked(true);
                curColumn.setWidth(80);
                curColumn = this.tblMain.getColumn(nOldColumnNum + 3);
                curColumn.setEditor((ICellEditor)timePickerEditor);
                curColumn.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getTimeFormatString());
                curColumn.getStyleAttributes().setLocked(true);
                curColumn = this.tblMain.getColumn(nOldColumnNum + 4);
                curColumn.setEditor((ICellEditor)timePickerEditor);
                curColumn.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getTimeFormatString());
                curColumn.getStyleAttributes().setLocked(true);
                KDNumberTextField numberField = new KDNumberTextField();
                numberField.setDataType(6);
                numberField.setColumns(7);
                numberField.setPrecision(2);
                KDTDefaultCellEditor numberFieldEditor = new KDTDefaultCellEditor((JTextField)numberField);
                curColumn = this.tblMain.getColumn(nOldColumnNum + 5);
                curColumn.setEditor((ICellEditor)numberFieldEditor);
                curColumn.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                curColumn.getStyleAttributes().setLocked(true);
                curColumn.setWidth(50);
                numberField = new KDNumberTextField();
                numberField.setDataType(6);
                numberField.setColumns(7);
                numberField.setPrecision(2);
                numberField.setEditable(false);
                numberField.setEnabled(false);
                numberFieldEditor = new KDTDefaultCellEditor((JTextField)numberField);
                curColumn = this.tblMain.getColumn(nOldColumnNum + 0);
                curColumn.setEditor((ICellEditor)numberFieldEditor);
                curColumn.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                curColumn.getStyleAttributes().setLocked(true);
                curColumn.setWidth(80);
                this.tblMain.getHeadRow(0).getCell(nOldColumnNum + 0).setValue((Object)productLineInfo.getName());
                this.tblMain.getHeadRow(0).getCell(nOldColumnNum + 1).setValue((Object)productLineInfo.getName());
                this.tblMain.getHeadRow(0).getCell(nOldColumnNum + 2).setValue((Object)productLineInfo.getName());
                this.tblMain.getHeadRow(0).getCell(nOldColumnNum + 3).setValue((Object)productLineInfo.getName());
                this.tblMain.getHeadRow(0).getCell(nOldColumnNum + 4).setValue((Object)productLineInfo.getName());
                this.tblMain.getHeadRow(0).getCell(nOldColumnNum + 5).setValue((Object)productLineInfo.getName());
                this.tblMain.getHeadRow(1).getCell(nOldColumnNum + 0).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)TABLE_HEAD_ABILITYTOTAL));
                this.tblMain.getHeadRow(2).getCell(nOldColumnNum + 0).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)TABLE_HEAD_ABILITYTOTAL));
                if (!isExist) {
                    isExist = true;
                } else {
                    this.tblMain.getColumn(nOldColumnNum + 0).getStyleAttributes().setHided(true);
                }
                this.tblMain.getHeadRow(1).getCell(nOldColumnNum + 1).setValue((Object)classTeamEntryInfo.getName());
                this.tblMain.getHeadRow(1).getCell(nOldColumnNum + 2).setValue((Object)classTeamEntryInfo.getName());
                this.tblMain.getHeadRow(1).getCell(nOldColumnNum + 3).setValue((Object)classTeamEntryInfo.getName());
                this.tblMain.getHeadRow(1).getCell(nOldColumnNum + 4).setValue((Object)classTeamEntryInfo.getName());
                this.tblMain.getHeadRow(1).getCell(nOldColumnNum + 5).setValue((Object)classTeamEntryInfo.getName());
                this.tblMain.getHeadRow(2).getCell(nOldColumnNum + 1).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)"StartTime"));
                this.tblMain.getHeadRow(2).getCell(nOldColumnNum + 2).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)"EndTime"));
                this.tblMain.getHeadRow(2).getCell(nOldColumnNum + 3).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)"StartRestTime"));
                this.tblMain.getHeadRow(2).getCell(nOldColumnNum + 4).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)"EndRestTime"));
                this.tblMain.getHeadRow(2).getCell(nOldColumnNum + 5).setValue((Object)EASResource.getString((String)RESOURCE_FULLNAME, (String)"Ability"));
            }
        }
        this.tblMain.getViewManager().freeze(-1, this.tblMain.getColumn(TABLE_HEAD_ISWORKDAY).getColumnIndex() + 1);
        this.tblMain.refresh();
    }

    private void fireTableBody(EquipmentCalendarCollection equipmentCalendarCollection) throws Exception {
        EquipmentCalendarInfo equipmentCalendarInfo = null;
        for (int nIndex = 0; equipmentCalendarCollection != null && nIndex < equipmentCalendarCollection.size(); ++nIndex) {
            equipmentCalendarInfo = equipmentCalendarCollection.get(nIndex);
            equipmentCalendarInfo.setStatus(OprStatusEnum.DEFAULT);
            IRow curRow = this.tblMain.addRow();
            curRow.getCell(TABLE_HEAD_ID).setValue((Object)equipmentCalendarInfo.getId().toString());
            curRow.getCell(TABLE_HEAD_WORKDATE).setValue((Object)equipmentCalendarInfo.getWorkDate());
            curRow.getCell(TABLE_HEAD_ISWORKDAY).setValue((Object)(equipmentCalendarInfo.getWorkDay().getValue() == 1 ? Boolean.TRUE : Boolean.FALSE));
            curRow.setUserObject((Object)equipmentCalendarInfo);
            EquipmentCalendarEntryCollection equipmentCalendarEntryCollection = equipmentCalendarInfo.getEntrys();
            if (equipmentCalendarEntryCollection == null) continue;
            Map productlineMap = this.getTotalAbility(equipmentCalendarEntryCollection);
            for (int nEntryIndex = 0; nEntryIndex < equipmentCalendarEntryCollection.size(); ++nEntryIndex) {
                EquipmentCalendarEntryInfo equipmentCalendarEntry = equipmentCalendarEntryCollection.get(nEntryIndex);
                ProductLineInfo selProductLineInfo = (ProductLineInfo)this.cmbProductLine.getSelectedItem();
                if (selProductLineInfo != null && selProductLineInfo.getName() != null && !equipmentCalendarEntry.getProductLine().getId().equals((Object)selProductLineInfo.getId())) continue;
                equipmentCalendarEntry.setStatus(OprStatusEnum.DEFAULT);
                this.fireCurrentRow(curRow, equipmentCalendarInfo.getWorkDay().getValue() == 1, equipmentCalendarEntry);
                this.addTotalAbility(curRow, equipmentCalendarInfo.getWorkDay().getValue() == 1, equipmentCalendarEntry, productlineMap);
            }
            this.replaceWorkDay(curRow, equipmentCalendarInfo.getWorkDay(), null, true);
        }
    }

    private Map getTotalAbility(EquipmentCalendarEntryCollection equipmentCalendarEntryCollection) {
        HashMap<String, BigDecimal> productlineMap = new HashMap<String, BigDecimal>();
        String preProductLineId = null;
        BigDecimal abilityCount = BigDecimal.ZERO;
        for (int nEntryIndex = 0; equipmentCalendarEntryCollection != null && nEntryIndex < equipmentCalendarEntryCollection.size(); ++nEntryIndex) {
            String currentProductLineId = equipmentCalendarEntryCollection.get(nEntryIndex).getProductLine().getId().toString();
            if (preProductLineId == null || !preProductLineId.equals(currentProductLineId)) {
                abilityCount = new BigDecimal(0);
            }
            if (equipmentCalendarEntryCollection.get(nEntryIndex).getAbility() != null) {
                abilityCount = abilityCount.add(equipmentCalendarEntryCollection.get(nEntryIndex).getAbility());
                productlineMap.remove(currentProductLineId);
                productlineMap.put(currentProductLineId, abilityCount);
            }
            preProductLineId = currentProductLineId;
        }
        return productlineMap;
    }

    private void addTotalAbility(IRow row, boolean isWorkDay, EquipmentCalendarEntryInfo equipmentCalendarEntry, Map productlineAbility) {
        String nDynamicKey = equipmentCalendarEntry.getProductLine().getId().toString() + DYNAMIC_COLUMN_SPLIT_PREFIX + equipmentCalendarEntry.getClassTeam().getId() + DYNAMIC_COLUMN_SPLIT_PREFIX + equipmentCalendarEntry.getClassTeamEntry().getId();
        if (this.hmDynamicColumn == null) {
            return;
        }
        if (!this.hmDynamicColumn.containsKey(nDynamicKey)) {
            return;
        }
        int nStartCol = (Integer)this.hmDynamicColumn.get(nDynamicKey);
        int nAbilityColIndex = nStartCol + 0;
        ICell abilityCell = row.getCell(nAbilityColIndex);
        Object total = productlineAbility.get(equipmentCalendarEntry.getProductLine().getId().toString());
        abilityCell.setValue(isWorkDay && productlineAbility.get(equipmentCalendarEntry.getProductLine().getId().toString()) != null ? productlineAbility.get(equipmentCalendarEntry.getProductLine().getId().toString()).toString() : null);
        if (equipmentCalendarEntry.getStartTime() == null && equipmentCalendarEntry.getEndTime() == null && equipmentCalendarEntry.getStartRestTime() == null && equipmentCalendarEntry.getEndRestTime() == null) {
            abilityCell.setValue(null);
            abilityCell.getStyleAttributes().setBackground(COLOR_REST);
            abilityCell.getStyleAttributes().setLocked(true);
        } else {
            abilityCell.getStyleAttributes().setBackground(COLOR_WORK);
            abilityCell.getStyleAttributes().setLocked(false);
        }
    }

    private void replaceWorkDay(IRow row, WorkDateTypeEnum workDayType, HashMap productLineWorkDay, boolean isInit) throws Exception {
        if (row == null) {
            return;
        }
        EquipmentCalendarInfo equipmentCalendarInfo = (EquipmentCalendarInfo)row.getUserObject();
        if (equipmentCalendarInfo == null) {
            return;
        }
        boolean isWorkDay = false;
        switch (workDayType.getValue()) {
            case 1: {
                isWorkDay = true;
                row.getCell(TABLE_HEAD_WORKDATE).getStyleAttributes().setBackground(COLOR_WORK);
                row.getCell(TABLE_HEAD_ISWORKDAY).getStyleAttributes().setBackground(COLOR_WORK);
                break;
            }
            case 3: {
                isWorkDay = false;
                row.getCell(TABLE_HEAD_WORKDATE).getStyleAttributes().setBackground(COLOR_REST);
                row.getCell(TABLE_HEAD_ISWORKDAY).getStyleAttributes().setBackground(COLOR_REST);
                row.getStyleAttributes().setBackground(COLOR_REST);
                row.getStyleAttributes().setLocked(true);
                break;
            }
            default: {
                isWorkDay = false;
                row.getStyleAttributes().setBackground(COLOR_REST);
            }
        }
        if (isInit) {
            return;
        }
        IEquipmentCalendar iEquipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
        EquipmentCalendarEntryCollection entryCollection = iEquipmentCalendar.getDefaultEquipmentCalendarEntry(equipmentCalendarInfo.getId().toString(), workDayType, equipmentCalendarInfo.getWorkDate());
        Map productlineMap = this.getTotalAbility(entryCollection);
        for (int nIndex = 0; entryCollection != null && nIndex < entryCollection.size(); ++nIndex) {
            EquipmentCalendarEntryInfo entryInfo = entryCollection.get(nIndex);
            if (productLineWorkDay != null && productLineWorkDay.containsKey(entryInfo.getProductLine().getId().toString()) && isWorkDay) {
                EquipmentCalendarEntryInfo defaultEntryInfo = entryCollection.get(entryInfo.getId());
                if (productLineWorkDay.get(entryInfo.getProductLine().getId().toString()).equals(Boolean.FALSE)) {
                    entryInfo.setStartTime(null);
                    entryInfo.setEndTime(null);
                    entryInfo.setStartRestTime(null);
                    entryInfo.setEndRestTime(null);
                    entryInfo.setAbility(null);
                    productlineMap.remove(entryInfo.getProductLine().getId().toString());
                } else if (defaultEntryInfo != null) {
                    entryInfo.setStartTime(defaultEntryInfo.getStartTime());
                    entryInfo.setEndTime(defaultEntryInfo.getEndTime());
                    entryInfo.setStartRestTime(defaultEntryInfo.getStartRestTime());
                    entryInfo.setEndRestTime(defaultEntryInfo.getEndRestTime());
                    entryInfo.setAbility(defaultEntryInfo.getAbility());
                }
            }
            this.updateUIEquipmentInfo(equipmentCalendarInfo.getEntrys(), entryInfo);
            entryInfo.setStatus(OprStatusEnum.MODIFIED);
            this.fireCurrentRow(row, isWorkDay, entryInfo);
            this.addTotalAbility(row, equipmentCalendarInfo.getWorkDay().getValue() == 1, entryInfo, productlineMap);
        }
        this.synchronizedTableBody(equipmentCalendarInfo, entryCollection);
    }

    private void synchronizedTableBody(EquipmentCalendarInfo equipmentCalendarInfo, EquipmentCalendarEntryCollection entryCollection) {
        for (int i = 0; i < this.tableBody.size(); ++i) {
            if (!this.tableBody.get(i).getId().toString().equals(equipmentCalendarInfo.getId().toString())) continue;
            for (int j = this.tableBody.get(i).getEntrys().size() - 1; j >= 0; --j) {
                this.tableBody.get(i).getEntrys().removeObject(j);
            }
            this.tableBody.get(i).getEntrys().addCollection(entryCollection);
            break;
        }
    }

    private void updateUIEquipmentInfo(EquipmentCalendarEntryCollection uiCollection, EquipmentCalendarEntryInfo entryInfo) {
        if (uiCollection == null || entryInfo == null) {
            return;
        }
        for (int i = uiCollection.size() - 1; i >= 0; --i) {
            String productLineID = uiCollection.get(i).getProductLine().getId().toString();
            if (!productLineID.equals(entryInfo.getProductLine().getId().toString())) continue;
            uiCollection.set(i, entryInfo);
            break;
        }
    }

    private void fireCurrentRow(IRow row, boolean isWorkDay, EquipmentCalendarEntryInfo equipmentCalendarEntry) {
        String nDynamicKey = equipmentCalendarEntry.getProductLine().getId().toString() + DYNAMIC_COLUMN_SPLIT_PREFIX + equipmentCalendarEntry.getClassTeam().getId() + DYNAMIC_COLUMN_SPLIT_PREFIX + equipmentCalendarEntry.getClassTeamEntry().getId();
        if (this.hmDynamicColumn == null) {
            return;
        }
        if (!this.hmDynamicColumn.containsKey(nDynamicKey)) {
            return;
        }
        int nStartCol = (Integer)this.hmDynamicColumn.get(nDynamicKey);
        int nStartTimeColIndex = nStartCol + 1;
        ICell startTimeCell = row.getCell(nStartTimeColIndex);
        startTimeCell.setUserObject((Object)new EquipmentCalendarDynamicColObject(1, equipmentCalendarEntry));
        startTimeCell.setValue((Object)(isWorkDay ? equipmentCalendarEntry.getStartTime() : null));
        int nEndTimeColIndex = nStartCol + 2;
        ICell endTimeCell = row.getCell(nEndTimeColIndex);
        endTimeCell.setUserObject((Object)new EquipmentCalendarDynamicColObject(2, equipmentCalendarEntry));
        endTimeCell.setValue((Object)(isWorkDay ? equipmentCalendarEntry.getEndTime() : null));
        int nStartRestTimeColIndex = nStartCol + 3;
        ICell startRestTimeCell = row.getCell(nStartRestTimeColIndex);
        startRestTimeCell.setUserObject((Object)new EquipmentCalendarDynamicColObject(3, equipmentCalendarEntry));
        startRestTimeCell.setValue((Object)(isWorkDay ? equipmentCalendarEntry.getStartRestTime() : null));
        int nEndRestTimeColIndex = nStartCol + 4;
        ICell endRestTimeCell = row.getCell(nEndRestTimeColIndex);
        endRestTimeCell.setUserObject((Object)new EquipmentCalendarDynamicColObject(4, equipmentCalendarEntry));
        endRestTimeCell.setValue((Object)(isWorkDay ? equipmentCalendarEntry.getEndRestTime() : null));
        int nAbilityColIndex = nStartCol + 5;
        ICell abilityCell = row.getCell(nAbilityColIndex);
        KDFormattedTextField numberTextField = new KDFormattedTextField();
        numberTextField.setDataType(1);
        numberTextField.setNegatived(false);
        numberTextField.setPrecision(2);
        KDTDefaultCellEditor numberFieldEditor = new KDTDefaultCellEditor((JTextField)numberTextField);
        abilityCell.setEditor((ICellEditor)numberFieldEditor);
        abilityCell.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        abilityCell.getStyleAttributes().setLocked(true);
        abilityCell.setUserObject((Object)new EquipmentCalendarDynamicColObject(5, equipmentCalendarEntry));
        abilityCell.setValue(isWorkDay && equipmentCalendarEntry.getAbility() != null ? equipmentCalendarEntry.getAbility() : null);
        if (equipmentCalendarEntry.getStartTime() == null && equipmentCalendarEntry.getEndTime() == null && equipmentCalendarEntry.getStartRestTime() == null && equipmentCalendarEntry.getEndRestTime() == null) {
            startTimeCell.getStyleAttributes().setLocked(true);
            endTimeCell.getStyleAttributes().setLocked(true);
            startRestTimeCell.getStyleAttributes().setLocked(true);
            endRestTimeCell.getStyleAttributes().setLocked(true);
            abilityCell.setValue(null);
            startTimeCell.getStyleAttributes().setBackground(COLOR_REST);
            endTimeCell.getStyleAttributes().setBackground(COLOR_REST);
            startRestTimeCell.getStyleAttributes().setBackground(COLOR_REST);
            endRestTimeCell.getStyleAttributes().setBackground(COLOR_REST);
            abilityCell.getStyleAttributes().setBackground(COLOR_REST);
        } else {
            startTimeCell.getStyleAttributes().setLocked(false);
            endTimeCell.getStyleAttributes().setLocked(false);
            startRestTimeCell.getStyleAttributes().setLocked(false);
            endRestTimeCell.getStyleAttributes().setLocked(false);
            startTimeCell.getStyleAttributes().setBackground(COLOR_WORK);
            endTimeCell.getStyleAttributes().setBackground(COLOR_WORK);
            startRestTimeCell.getStyleAttributes().setBackground(COLOR_WORK);
            endRestTimeCell.getStyleAttributes().setBackground(COLOR_WORK);
            abilityCell.getStyleAttributes().setBackground(COLOR_WORK);
        }
    }

    private void putDynamicColumnNum(ProductLineInfo productLine, ClassTeamInfo classTeam, ClassTeamEntryInfo classTeamEntry, int colIndex) throws Exception {
        if (this.hmDynamicColumn == null) {
            this.hmDynamicColumn = new HashMap();
        }
        String key = productLine.getId().toString() + DYNAMIC_COLUMN_SPLIT_PREFIX + classTeam.getId().toString() + DYNAMIC_COLUMN_SPLIT_PREFIX + classTeamEntry.getId().toString();
        this.hmDynamicColumn.put(key, new Integer(colIndex));
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.promptSaveOperation();
            if (this.pmptStorageOrgUnit.getData() == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"StorageOrgIsNull"));
                this.pmptStorageOrgUnit.requestFocusInWindow();
                return;
            }
            if (this.dateStartDate.getValue() == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"StartDateIsNull"));
                this.dateStartDate.requestFocusInWindow();
                return;
            }
            if (this.dateEndDate.getValue() == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"EndDateIsNull"));
                this.dateEndDate.requestFocusInWindow();
                return;
            }
            this.showEquipmentCalendar();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void showEquipmentCalendar() throws Exception {
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.pmptStorageOrgUnit.getData();
        String storageOrgUnitID = null;
        if (storageOrgUnitInfo != null) {
            storageOrgUnitID = storageOrgUnitInfo.getId().toString();
        }
        ProductLineInfo productLine = (ProductLineInfo)this.cmbProductLine.getSelectedItem();
        String productLineID = null;
        if (productLine != null && productLine.getName() != null) {
            productLineID = productLine.getId().toString();
        }
        Date startDate = (Date)this.dateStartDate.getValue();
        Date endDate = (Date)this.dateEndDate.getValue();
        Map result = null;
        IEquipmentCalendar iEquipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
        result = iEquipmentCalendar.getEquipmentCalendar(storageOrgUnitID, productLineID, startDate, endDate);
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.pmptStorageOrgUnit.getValue();
        Map hmResult = null;
        IEquipmentCalendar equipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
        hmResult = equipmentCalendar.getInfoOfStorageOrgUnit(orgUnitInfo.getId().toString());
        if (hmResult != null) {
            this.productLineCollection = (ProductLineCollection)((Object)hmResult.get("productLine"));
        }
        this.tableHead = (ProductLineCollection)((Object)result.get("tableHead"));
        this.initProductLineComboList(this.tableHead, productLineID == null ? null : productLine);
        this.buildTableHeadBuffer(productLine);
        this.tableBody = (EquipmentCalendarCollection)((Object)result.get("tableBody"));
        this.period = (EquipmentCalendarPeriodInfo)((Object)result.get("period"));
        if (this.tableBody == null || this.tableBody.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"NoDate"));
        }
        this.fireResultView();
    }

    private void buildTableHeadBuffer(ProductLineInfo singleProductLine) {
        if (singleProductLine == null || singleProductLine.getName() == null) {
            this.tableHead = this.productLineCollection;
        } else {
            ProductLineCollection header = new ProductLineCollection();
            header.add(singleProductLine);
            this.tableHead = header;
        }
    }

    private void fireResultView() throws Exception {
        this.clearTableView();
        this.refreshECPeriod(this.period);
        this.fireTableHeader(this.tableHead);
        this.fireTableBody(this.tableBody);
        this.setModified(false);
    }

    private void initProductLineComboList(ProductLineCollection productLineCollection, ProductLineInfo defaultOption) {
        this.cmbProductLine.removeAllItems();
        if (productLineCollection == null) {
            this.cmbProductLine.setEnabled(false);
        } else {
            this.cmbProductLine.setEnabled(true);
            this.cmbProductLine.addItem((Object)new ProductLineInfo());
            for (int nIndex = 0; productLineCollection != null && nIndex < productLineCollection.size(); ++nIndex) {
                ProductLineInfo productLine = productLineCollection.get(nIndex);
                this.cmbProductLine.addItem((Object)productLine);
                if (productLine == null || defaultOption == null || !productLine.getId().toString().equals(defaultOption.getId().toString())) continue;
                this.cmbProductLine.setSelectedItem((Object)productLine);
            }
        }
    }

    private void clearTableView() {
        this.tblMain.removeHeadRows();
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
    }

    private void tableMain_OnChange(KDTEditEvent e) throws Exception {
        Object newValue;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object oldValue = e.getOldValue();
        if (oldValue == (newValue = e.getValue())) {
            return;
        }
        IRow curRow = this.tblMain.getRow(rowIndex);
        IColumn curCol = this.tblMain.getColumn(colIndex);
        ICell curCell = this.tblMain.getCell(rowIndex, colIndex);
        EquipmentCalendarInfo equipmentCalendarInfo = (EquipmentCalendarInfo)curRow.getUserObject();
        if (curCell.getUserObject() == null) {
            if (equipmentCalendarInfo == null) {
                return;
            }
            if (curCol.getKey() == null) {
                return;
            }
            if (curCol.getKey().equals(TABLE_HEAD_WORKDATE)) {
                DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
                curCell.setValue((Object)dtformat.format((Date)newValue));
                if (newValue == null) {
                    equipmentCalendarInfo.setWorkDate(null);
                } else {
                    equipmentCalendarInfo.setWorkDate((Date)newValue);
                }
            } else if (curCol.getKey().equals(TABLE_HEAD_ISWORKDAY)) {
                // empty if block
            }
            equipmentCalendarInfo.setStatus(OprStatusEnum.MODIFIED);
        } else {
            EquipmentCalendarDynamicColObject colObject = (EquipmentCalendarDynamicColObject)curCell.getUserObject();
            if (colObject == null) {
                return;
            }
            int curColKey = colObject.getKey();
            EquipmentCalendarEntryInfo equipmentCalendarEntryInfo = colObject.getObject();
            switch (curColKey) {
                case 1: {
                    Date dateStart = this.fillCalendarDateOfWorkTime(equipmentCalendarInfo, (Date)newValue);
                    Timestamp timeStart = null;
                    if (dateStart != null) {
                        timeStart = new Timestamp(dateStart.getTime());
                    }
                    curCell.setValue(timeStart);
                    equipmentCalendarEntryInfo.setStartTime(timeStart);
                    break;
                }
                case 2: {
                    Date dateEnd = this.fillCalendarDateOfWorkTime(equipmentCalendarInfo, (Date)newValue);
                    Timestamp timeEnd = null;
                    if (dateEnd != null) {
                        timeEnd = new Timestamp(dateEnd.getTime());
                    }
                    curCell.setValue(timeEnd);
                    equipmentCalendarEntryInfo.setEndTime(timeEnd);
                    break;
                }
                case 3: {
                    Date dateStartRest = this.fillCalendarDateOfWorkTime(equipmentCalendarInfo, (Date)newValue);
                    Timestamp timeStartRest = null;
                    if (dateStartRest != null) {
                        timeStartRest = new Timestamp(dateStartRest.getTime());
                    }
                    curCell.setValue(timeStartRest);
                    equipmentCalendarEntryInfo.setStartRestTime(timeStartRest);
                    break;
                }
                case 4: {
                    Date dateEndRest = this.fillCalendarDateOfWorkTime(equipmentCalendarInfo, (Date)newValue);
                    Timestamp timeEndRest = null;
                    if (dateEndRest != null) {
                        timeEndRest = new Timestamp(dateEndRest.getTime());
                    }
                    curCell.setValue(timeEndRest);
                    equipmentCalendarEntryInfo.setEndRestTime(timeEndRest);
                    break;
                }
                case 5: {
                    BigDecimal oldVal = (BigDecimal)oldValue;
                    BigDecimal newVal = null;
                    if (newValue != null && newValue.toString().length() > 0) {
                        equipmentCalendarEntryInfo.setAbility((BigDecimal)newValue);
                        curCell.setValue(newValue);
                        newVal = (BigDecimal)newValue;
                    } else {
                        equipmentCalendarEntryInfo.setAbility(new BigDecimal(0));
                        curCell.setValue((Object)new BigDecimal(0));
                        newVal = new BigDecimal(0);
                    }
                    int i = 1;
                    while (this.tblMain.getCell(rowIndex, colIndex - i * 5).getStyleAttributes().isHided()) {
                        ++i;
                    }
                    int col = colIndex - i * 5 - (i - 1);
                    ICell cell = this.tblMain.getCell(rowIndex, col);
                    BigDecimal total = null;
                    if (cell.getValue() instanceof BigDecimal) {
                        total = (BigDecimal)cell.getValue();
                    } else {
                        if (cell.getValue() == null || cell.getValue().toString() == null || cell.getValue().toString().equals("")) {
                            return;
                        }
                        total = new BigDecimal(cell.getValue().toString());
                    }
                    BigDecimal totalVal = this.count(total, oldVal, newVal);
                    this.tblMain.getCell(rowIndex, col).setValue((Object)totalVal);
                    break;
                }
            }
            if (curColKey != 5) {
                this.calcMultDateAndAbility(curCell);
            }
            equipmentCalendarEntryInfo.setStatus(OprStatusEnum.MODIFIED);
        }
        this.setModified(true);
    }

    private BigDecimal count(BigDecimal total, BigDecimal oldValue, BigDecimal newValue) {
        BigDecimal result = total.subtract(oldValue);
        result = result.add(newValue);
        return result;
    }

    private void calcMultDateAndAbility(ICell changeCell) {
        if (changeCell == null) {
            return;
        }
        IRow row = this.tblMain.getRow(changeCell.getRowIndex());
        EquipmentCalendarInfo calendarInfo = (EquipmentCalendarInfo)row.getUserObject();
        EquipmentCalendarDynamicColObject colObject = (EquipmentCalendarDynamicColObject)changeCell.getUserObject();
        if (colObject == null) {
            return;
        }
        EquipmentCalendarEntryInfo calendarEntryInfo = colObject.getObject();
        String strKey = calendarEntryInfo.getProductLine().getId().toString() + DYNAMIC_COLUMN_SPLIT_PREFIX + calendarEntryInfo.getClassTeam().getId().toString() + DYNAMIC_COLUMN_SPLIT_PREFIX + calendarEntryInfo.getClassTeamEntry().getId().toString();
        int startColIndex = (Integer)this.hmDynamicColumn.get(strKey);
        Date startTime = this.fillCalendarDateOfWorkTime(calendarInfo, (Date)this.tblMain.getCell(row.getRowIndex(), startColIndex + 1).getValue());
        Date endTime = this.fillCalendarDateOfWorkTime(calendarInfo, (Date)this.tblMain.getCell(row.getRowIndex(), startColIndex + 2).getValue());
        Date startRestTime = this.fillCalendarDateOfWorkTime(calendarInfo, (Date)this.tblMain.getCell(row.getRowIndex(), startColIndex + 3).getValue());
        Date endRestTime = this.fillCalendarDateOfWorkTime(calendarInfo, (Date)this.tblMain.getCell(row.getRowIndex(), startColIndex + 4).getValue());
        if (startTime != null && endTime == null) {
            endTime = startTime;
            calendarEntryInfo.setEndTime(new Timestamp(endTime.getTime()));
            this.tblMain.getCell(row.getRowIndex(), startColIndex + 2).setValue((Object)endTime);
        }
        if (startTime == null && endTime != null) {
            startTime = endTime;
            calendarEntryInfo.setStartTime(new Timestamp(startTime.getTime()));
            this.tblMain.getCell(row.getRowIndex(), startColIndex + 1).setValue((Object)startTime);
        }
        if (startRestTime != null && endRestTime == null) {
            endRestTime = startRestTime;
            calendarEntryInfo.setEndRestTime(new Timestamp(endRestTime.getTime()));
            this.tblMain.getCell(row.getRowIndex(), startColIndex + 4).setValue((Object)startRestTime);
        }
        if (startRestTime == null && endRestTime != null) {
            startRestTime = endRestTime;
            calendarEntryInfo.setStartTime(new Timestamp(startRestTime.getTime()));
            this.tblMain.getCell(row.getRowIndex(), startColIndex + 3).setValue((Object)startRestTime);
        }
        if ((endTime = this.calcMultDate(true, calendarInfo.getWorkDate(), startTime, endTime)) == null) {
            calendarEntryInfo.setEndTime(null);
        } else {
            calendarEntryInfo.setEndTime(new Timestamp(endTime.getTime()));
        }
        this.tblMain.getCell(row.getRowIndex(), startColIndex + 2).setValue((Object)endTime);
        startRestTime = this.calcMultDate(false, calendarInfo.getWorkDate(), startTime, startRestTime);
        if (startRestTime == null) {
            calendarEntryInfo.setStartRestTime(null);
        } else {
            calendarEntryInfo.setStartRestTime(new Timestamp(startRestTime.getTime()));
        }
        this.tblMain.getCell(row.getRowIndex(), startColIndex + 3).setValue((Object)startRestTime);
        endRestTime = this.calcMultDate(false, calendarInfo.getWorkDate(), startTime, endRestTime);
        if (endRestTime == null) {
            calendarEntryInfo.setEndRestTime(null);
        } else {
            calendarEntryInfo.setEndRestTime(new Timestamp(endRestTime.getTime()));
        }
        if (startRestTime != null && endRestTime != null) {
            if ((startRestTime.after(startTime) || startRestTime.equals(startTime)) && (startRestTime.before(endTime) || startRestTime.equals(endTime))) {
                if (!endRestTime.after(startRestTime) && !endRestTime.equals(startRestTime) || !endRestTime.before(endTime) && !endRestTime.equals(endTime)) {
                    MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.ClassTeamResource", (String)"EndRestTimeError"));
                } else {
                    this.tblMain.getCell(row.getRowIndex(), startColIndex + 4).setValue((Object)endRestTime);
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.basedata.ClassTeamResource", (String)"StartRestTimeError"));
            }
        }
        float workHour = startTime == null || endTime == null ? 0.0f : (float)Math.abs(endTime.getTime() - startTime.getTime()) / 3600000.0f;
        float restHour = startRestTime == null || endRestTime == null ? 0.0f : (float)Math.abs(endRestTime.getTime() - startRestTime.getTime()) / 3600000.0f;
        BigDecimal bdAbility = new BigDecimal(workHour - restHour);
        if (startTime != null && endTime != null && startRestTime != null && endRestTime != null) {
            DateFormat dtformat = CtrlFormatUtilities.getTimeFormat();
            String start = dtformat.format(startTime);
            String end = dtformat.format(endTime);
            String startRest = dtformat.format(startRestTime);
            String endRest = dtformat.format(endRestTime);
            if (start.equals(startRest) && end.equals(endRest)) {
                bdAbility = new BigDecimal(0);
            }
        }
        bdAbility = bdAbility.setScale(2, 4);
        ICell cell = this.tblMain.getCell(row.getRowIndex(), startColIndex + 5);
        BigDecimal oldValue = new BigDecimal(0);
        if (cell.getValue() != null) {
            oldValue = (BigDecimal)cell.getValue();
        }
        int i = 1;
        while (this.tblMain.getCell(row.getRowIndex(), startColIndex + 5 - i * 5).getStyleAttributes().isHided()) {
            ++i;
        }
        int col = startColIndex + 5 - i * 5 - (i - 1);
        ICell cellAbilityTotal = this.tblMain.getCell(row.getRowIndex(), col);
        BigDecimal total = null;
        total = cellAbilityTotal.getValue() instanceof BigDecimal ? (BigDecimal)cellAbilityTotal.getValue() : (cell.getValue() == null || cell.getValue().toString() == null || cell.getValue().toString().equals("") ? new BigDecimal(0) : new BigDecimal(cellAbilityTotal.getValue().toString()));
        BigDecimal totalVal = this.count(total, oldValue, bdAbility);
        this.tblMain.getCell(row.getRowIndex(), col).setValue((Object)totalVal);
        this.tblMain.getCell(row.getRowIndex(), startColIndex + 5).setValue((Object)bdAbility);
        calendarEntryInfo.setAbility(bdAbility);
    }

    private Date fillCalendarDateOfWorkTime(EquipmentCalendarInfo calendarInfo, Date date) {
        Date workDate = calendarInfo.getWorkDate();
        if (workDate == null || date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(workDate);
        calendar.set(11, date.getHours());
        calendar.set(12, date.getMinutes());
        calendar.set(13, date.getSeconds());
        return calendar.getTime();
    }

    private Date calcMultDate(boolean isAllowEqual, Date workDate, Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(workDate);
        calendar.set(11, endTime.getHours());
        calendar.set(12, endTime.getMinutes());
        calendar.set(13, endTime.getSeconds());
        boolean isAllowAddDay = false;
        if (endTime.before(startTime)) {
            isAllowAddDay = true;
        }
        if (isAllowEqual && endTime.equals(startTime)) {
            isAllowAddDay = true;
        }
        if (isAllowAddDay) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    private EquipmentCalendarGenCondUI showConditionEditDlg(String title) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", SysContext.getSysContext().getCurrentUser());
        uiContext.put((Object)"openModel", (Object)"frame");
        UIModelDialog uiWindow = (UIModelDialog)UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EquipmentCalendarGenCondUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        if (title != null) {
            uiWindow.setTitle(title);
        }
        EquipmentCalendarGenCondUI uiObject = (EquipmentCalendarGenCondUI)uiWindow.getUIObject();
        this.fillCondUIFields(uiObject, title);
        uiWindow.show();
        return uiObject;
    }

    private EquipmentCalendarDayPropertyEditUI showDayPropertyEditDlg(EquipmentCalendarInfo calendarInfo, ProductLineCollection productLineCollection) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", SysContext.getSysContext().getCurrentUser());
        uiContext.put((Object)"openModel", (Object)"frame");
        UIModelDialog uiWindow = (UIModelDialog)UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EquipmentCalendarDayPropertyEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        EquipmentCalendarDayPropertyEditUI uiObject = (EquipmentCalendarDayPropertyEditUI)uiWindow.getUIObject();
        this.fillDayPropertyUIFields(uiObject, calendarInfo, productLineCollection);
        uiWindow.show();
        return uiObject;
    }

    private void fillDayPropertyUIFields(EquipmentCalendarDayPropertyEditUI uiObject, EquipmentCalendarInfo calendarInfo, ProductLineCollection productLineCollection) {
        uiObject.setCalendarInfo(calendarInfo);
        uiObject.setProductLineCollection(productLineCollection);
        if (this.cmbProductLine.getSelectedItem() == null || this.cmbProductLine.getSelectedItem().toString() == null) {
            uiObject.setAllProductLine(true);
        } else {
            uiObject.setAllProductLine(false);
        }
        uiObject.buildProductLineTable();
    }

    @Override
    public void actionRemoveEquipmentCalendar_actionPerformed(ActionEvent e) throws Exception {
        this.promptSaveOperation();
        EquipmentCalendarGenCondUI uiObject = this.showConditionEditDlg(EASResource.getString((String)RESOURCE_FULLNAME, (String)"Title"));
        if (!uiObject.isOK()) {
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"AskContinueDelete")) == 2) {
            return;
        }
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)uiObject.pmptStorageOrgUnit.getData();
        Date startDate = (Date)uiObject.dateStartDate.getValue();
        Date endDate = (Date)uiObject.dateEndDate.getValue();
        IEquipmentCalendar iEquipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
        this.period = iEquipmentCalendar.removeEquipmentCalendar(storageOrgUnit.getId().toString(), startDate, endDate);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"DeleteSuccessFul"));
        if (this.tableBody != null && this.tableBody.size() > 0) {
            this.removeEquipmentCalendarInBuff(storageOrgUnit, startDate, endDate);
        }
        this.fireResultView();
    }

    private void removeEquipmentCalendarInBuff(StorageOrgUnitInfo orgUnitInfo, Date startDate, Date endDate) {
        ArrayList<EquipmentCalendarInfo> list = new ArrayList<EquipmentCalendarInfo>();
        startDate = this.getZeroTimeOfDate(startDate);
        endDate = this.getZeroTimeOfDate(endDate);
        EquipmentCalendarInfo calendarInfo2 = null;
        for (int nIndex = 0; nIndex < this.tableBody.size(); ++nIndex) {
            calendarInfo2 = this.tableBody.get(nIndex);
            if (!calendarInfo2.getStorageOrgUnit().getId().equals((Object)orgUnitInfo.getId()) || calendarInfo2.getWorkDate().getTime() < startDate.getTime() || calendarInfo2.getWorkDate().getTime() > endDate.getTime()) continue;
            list.add(calendarInfo2);
        }
        for (EquipmentCalendarInfo calendarInfo2 : list) {
            this.tableBody.remove(calendarInfo2);
        }
    }

    private void fillCondUIFields(EquipmentCalendarGenCondUI uiObject, String title) {
        if (title != null) {
            SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)uiObject.pmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_equipmentcalendar_remove");
        } else {
            SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)uiObject.pmptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_equipmentcalendar_gen");
        }
        uiObject.pmptStorageOrgUnit.setValue(this.pmptStorageOrgUnit.getValue());
        uiObject.dateStartDate.setValue(this.dateStartDate.getValue());
        uiObject.dateEndDate.setValue(this.dateEndDate.getValue());
    }

    @Override
    public void actionGenEquipmentCalendar_actionPerformed(ActionEvent e) throws Exception {
        this.promptSaveOperation();
        EquipmentCalendarGenCondUI uiObject = this.showConditionEditDlg(null);
        if (!uiObject.isOK()) {
            return;
        }
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)uiObject.pmptStorageOrgUnit.getData();
        Date startDate = (Date)uiObject.dateStartDate.getValue();
        Date endDate = (Date)uiObject.dateEndDate.getValue();
        IEquipmentCalendar iEquipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
        boolean dataExists = iEquipmentCalendar.checkExistDate(storageOrgUnit.getId().toString(), startDate, endDate);
        int decision = 0;
        if (dataExists) {
            decision = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"AskExistEquipmentCalendar"));
        }
        EquipmentCalendarPeriodInfo periodInfo = null;
        switch (decision) {
            case 0: {
                periodInfo = iEquipmentCalendar.genEquipmentCalendar(storageOrgUnit.getId().toString(), startDate, endDate, true);
                break;
            }
            case 1: {
                periodInfo = iEquipmentCalendar.genEquipmentCalendar(storageOrgUnit.getId().toString(), startDate, endDate, false);
                break;
            }
            case 2: {
                return;
            }
            default: {
                return;
            }
        }
        if (storageOrgUnit != null && this.pmptStorageOrgUnit.getValue() != null && storageOrgUnit.getId().equals((Object)((StorageOrgUnitInfo)this.pmptStorageOrgUnit.getValue()).getId())) {
            this.period = periodInfo;
            this.refreshECPeriod(this.period);
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"GenCalendarSuccessful")) == 0) {
            this.pmptStorageOrgUnit.setValue((Object)storageOrgUnit);
            this.dateStartDate.setValue((Object)startDate);
            this.dateEndDate.setValue((Object)endDate);
            this.actionRefreshECView_actionPerformed(e);
        }
    }

    @Override
    public void actionRefreshECView_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getColumnCount() == 0) {
            return;
        }
        this.btnSearch_actionPerformed(e);
    }

    @Override
    protected void pmptStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.pmptStorageOrgUnit.getValue();
        if (orgUnitInfo == null) {
            this.clearTableView();
            this.cmbProductLine.removeAllItems();
            this.cmbProductLine.setEnabled(false);
            this.lblECPeriod.setVisible(false);
        } else {
            this.clearTableView();
            Map hmResult = null;
            IEquipmentCalendar equipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
            hmResult = equipmentCalendar.getInfoOfStorageOrgUnit(orgUnitInfo.getId().toString());
            if (hmResult == null) {
                return;
            }
            this.productLineCollection = (ProductLineCollection)((Object)hmResult.get("productLine"));
            this.period = (EquipmentCalendarPeriodInfo)((Object)hmResult.get("period"));
            this.initProductLineComboList((ProductLineCollection)((Object)hmResult.get("productLine")), null);
            this.fireTableHeader(this.productLineCollection);
            this.lblECPeriod.setVisible(true);
            this.refreshECPeriod(this.period);
        }
    }

    private void refreshECPeriod(EquipmentCalendarPeriodInfo periodInfo) {
        if (periodInfo == null) {
            this.txtECPeriod.setText(EASResource.getString((String)RESOURCE_FULLNAME, (String)"NoDate"));
        } else {
            this.txtECPeriod.setText(periodInfo.getDownPeriod() + "----" + periodInfo.getUpPeriod());
        }
    }

    @Override
    protected void cmbProductLine_itemStateChanged(ItemEvent e) throws Exception {
    }

    private void saveEquipmentCalendar() throws Exception {
        int nIndex;
        if (!this.isModified()) {
            return;
        }
        EquipmentCalendarCollection updateHeadCollection = new EquipmentCalendarCollection();
        EquipmentCalendarEntryCollection updateEntryCollection = new EquipmentCalendarEntryCollection();
        for (int nEquipmentCalendarIndex = 0; this.tableBody != null && nEquipmentCalendarIndex < this.tableBody.size(); ++nEquipmentCalendarIndex) {
            EquipmentCalendarInfo equipmentCalendar = this.tableBody.get(nEquipmentCalendarIndex);
            if (equipmentCalendar.getStatus() == OprStatusEnum.MODIFIED) {
                EquipmentCalendarInfo calendarInfo = new EquipmentCalendarInfo();
                calendarInfo.setId(equipmentCalendar.getId());
                calendarInfo.setWorkDate(equipmentCalendar.getWorkDate());
                calendarInfo.setWorkDay(equipmentCalendar.getWorkDay());
                updateHeadCollection.add(equipmentCalendar);
            }
            for (int nEquipmentCalendarEntryIndex = 0; equipmentCalendar.getEntrys() != null && nEquipmentCalendarEntryIndex < equipmentCalendar.getEntrys().size(); ++nEquipmentCalendarEntryIndex) {
                EquipmentCalendarEntryInfo equipmentCalendarEntry = equipmentCalendar.getEntrys().get(nEquipmentCalendarEntryIndex);
                if (equipmentCalendarEntry.getEndTime() != null && equipmentCalendarEntry.getStartTime() != null && equipmentCalendarEntry.getEndRestTime() != null && equipmentCalendarEntry.getStartRestTime() != null) {
                    boolean blnRestEndTime;
                    boolean blnRestStartTime = equipmentCalendarEntry.getStartRestTime().getTime() >= equipmentCalendarEntry.getStartTime().getTime() && equipmentCalendarEntry.getStartRestTime().getTime() <= equipmentCalendarEntry.getEndTime().getTime();
                    boolean bl = blnRestEndTime = equipmentCalendarEntry.getEndRestTime().getTime() >= equipmentCalendarEntry.getStartRestTime().getTime() && equipmentCalendarEntry.getEndRestTime().getTime() <= equipmentCalendarEntry.getEndTime().getTime();
                    if (!blnRestStartTime || !blnRestEndTime) {
                        ArrayList<String> throwObject = new ArrayList<String>();
                        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
                        throwObject.add(dtformat.format(equipmentCalendar.getWorkDate()));
                        throw new EquipmentCalendarException(EquipmentCalendarException.RESTTIMEMUSTINWORKTIME, throwObject.toArray());
                    }
                }
                if (equipmentCalendarEntry.getStatus() != OprStatusEnum.MODIFIED) continue;
                updateEntryCollection.add(equipmentCalendarEntry);
            }
        }
        IEquipmentCalendar iEquipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
        iEquipmentCalendar.updateEquipmentCalendar(updateHeadCollection, updateEntryCollection);
        for (nIndex = 0; nIndex < updateHeadCollection.size(); ++nIndex) {
            EquipmentCalendarInfo calendarInfo = updateHeadCollection.get(nIndex);
            if (calendarInfo == null) continue;
            calendarInfo.setStatus(OprStatusEnum.DEFAULT);
        }
        for (nIndex = 0; nIndex < updateEntryCollection.size(); ++nIndex) {
            EquipmentCalendarEntryInfo calendarEntryInfo = updateEntryCollection.get(nIndex);
            if (calendarEntryInfo == null) continue;
            calendarEntryInfo.setStatus(OprStatusEnum.DEFAULT);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"SaveSuccessful"));
        this.setModified(false);
    }

    @Override
    public void actionSaveEquipmentCalendar_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.saveEquipmentCalendar();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionRemoveAllEquipmentCalendar_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"AskWantRemoveAllDate")) == 2) {
            return;
        }
        IEquipmentCalendar iEquipmentCalendar = EquipmentCalendarFactory.getRemoteInstance();
        iEquipmentCalendar.removeAllEquipmentCalendar();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"DeleteSuccessFul"));
        if (this.tableBody != null && this.tableBody.size() > 0) {
            this.tableBody = new EquipmentCalendarCollection();
            this.fireResultView();
        }
    }

    private Date getZeroTimeOfDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private long cutDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        long minutes = calendar.get(11) * 60 + calendar.get(12);
        return minutes;
    }
}

