/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.BomGroupstandardFactory;
import com.kingdee.eas.mm.basedata.client.AbstractF7BomGroupTreeListUI;
import com.kingdee.eas.mm.basedata.client.BomGroupstandardEditUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class F7BomGroupTreeListUI
extends AbstractF7BomGroupTreeListUI {
    private static final Logger logger = CoreUIObject.getLogger(F7BomGroupTreeListUI.class);
    private Object data;
    private boolean isCanceled = false;
    private boolean isSelected = false;
    private boolean isCapitalSensitiveQuery = false;
    private QueryInfo queryInfo = null;
    private EntityViewInfo customerViewInfo = null;
    private String allFilterFieldName = null;
    private String numberAndName = "number+name";
    private final String[] KDT_DATES = new String[]{"createTime", "lastUpdateTime"};

    public Object getData() {
        return this.data;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.addListeners();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])this.KDT_DATES);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (KDTableUtil.getSelectedRow((KDTable)this.tblMain) == null) {
            return;
        }
        String id = (String)KDTableUtil.getSelectedRow((KDTable)this.tblMain).getCell("id").getValue();
        this.data = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id));
        this.isSelected = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionCanceled_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            String selectID = null;
            try {
                this.setOprtState("REMOVE");
                selectID = this.getSelectedNodeKeyValue();
                this.pubFireVOChangeListener(selectID);
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                this.abort();
            }
            this.Remove();
            this.refresh(e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
            return;
        }
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.actionConfirm_actionPerformed(null);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        if (!this.isSelected) {
            this.isCanceled = true;
        }
        return super.checkBeforeWindowClosing();
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BomGroupstandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getRootName() {
        return this.getResource("BOM_GROUP");
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"createOrg", this.getUIContext().get("storageOrgUnitInfo"));
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        uiContext.put((Object)"createOrg", this.getUIContext().get("storageOrgUnitInfo"));
    }

    protected String getEditUIName() {
        return BomGroupstandardEditUI.class.getName();
    }

    protected String getGroupEditUIName() {
        return this.getEditUIName();
    }

    protected String getQueryFieldName() {
        return "id";
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        String id = (String)KDTableUtil.getSelectedRow((KDTable)this.tblMain).getCell("id").getValue();
        if (id == null || id.equals("")) {
            return null;
        }
        return new ObjectUuidPK(id);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BomGroupstandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected FilterInfo getDefaultFilterForTree() {
        if (this.customerViewInfo == null) {
            this.initCustomerData();
        }
        return this.customerViewInfo.getFilter();
    }

    protected void refresh(ActionEvent e) throws Exception {
        ItemAction action = null;
        if (e != null) {
            action = this.getActionFromActionEvent(e);
        }
        if (action == null) {
            return;
        }
        if (action.equals(this.actionRemove)) {
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
            if (treeNode != null && treeNode.getParent() != null) {
                TreePath parentPath = this.treeMain.getSelectionPath().getParentPath();
                KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
                parentNode.remove((MutableTreeNode)treeNode);
                this.treeMain.updateUI();
                this.treeMain.setSelectionPath(parentPath);
                this.treeBuilder.refreshTreeNode(this.treeMain, parentNode, this.getDefaultFilterForTree());
                this.treeMain.expandPath(parentPath);
            }
        } else if (action.equals(this.actionRefresh)) {
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
        } else if (action.equals(this.actionView) && this.isModify) {
            this.initTree();
            this.treeMain.setSelectionRow(0);
            this.isModify = false;
        } else if (action.equals(this.actionAddNew)) {
            TreePath oldPath;
            UIActionMonitor.startAction((String)this.getMetaDataPK().getFullName(), (String)"refresh");
            this.handleNodeChange("ActionGroupAddNew");
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
            if (treeNode != null && treeNode.getParent() == null) {
                oldPath = this.treeMain.getSelectionPath();
                this.treeBuilder.refreshTreeNode(this.treeMain, treeNode, this.getDefaultFilterForTree());
                this.treeMain.setSelectionPath(oldPath);
                this.treeMain.expandPath(oldPath);
            }
            if (treeNode != null && treeNode.getParent() != null) {
                oldPath = this.treeMain.getSelectionPath();
                KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
                TreeSelectionListener[] listeners = this.removeAllTreeSelectionListener();
                this.treeBuilder.refreshTreeNode(this.treeMain, parentNode, this.getDefaultFilterForTree());
                this.addAllTreeSelectionListener(listeners);
                this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
                this.treeMain.expandPath(oldPath);
            }
            UIActionMonitor.endAction((String)this.getMetaDataPK().getFullName(), (String)"refresh", (long)0L);
        } else if (action.equals(this.actionEdit)) {
            UIActionMonitor.startAction((String)this.getMetaDataPK().getFullName(), (String)"refresh");
            this.handleNodeChange("ActionGroupEdit");
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
            if (treeNode != null && treeNode.getParent() != null) {
                TreePath oldPath = this.treeMain.getSelectionPath();
                KDTreeNode parentNode = (KDTreeNode)treeNode.getParent();
                TreeSelectionListener[] listeners = this.removeAllTreeSelectionListener();
                this.treeBuilder.refreshTreeNode(this.treeMain, parentNode, this.getDefaultFilterForTree());
                this.addAllTreeSelectionListener(listeners);
                this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
            }
            UIActionMonitor.endAction((String)this.getMetaDataPK().getFullName(), (String)"refresh", (long)0L);
        } else {
            this.execQuery();
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void addListeners() {
        this.cmbQuickFilterType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                F7BomGroupTreeListUI.this.quickFilterTypeChange(e);
            }
        });
        this.btnQuickQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                F7BomGroupTreeListUI.this.launchQuickFilter();
            }
        });
        this.txtQuickFilterValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                F7BomGroupTreeListUI.this.launchQuickFilter();
            }
        });
        this.txtQiuckFilterNumberValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                F7BomGroupTreeListUI.this.launchQuickFilter();
            }
        });
    }

    private void quickFilterTypeChange(ItemEvent e) {
        FilterFieldItem ffi = (FilterFieldItem)e.getItem();
        if (ffi != null) {
            if (ffi.getType().equals((Object)ConstDataType.INT) || ffi.getType().equals((Object)ConstDataType.NUMBER)) {
                this.chkVagueQuery.setEnabled(false);
                this.chkVagueQuery.setSelected(false);
                this.txtQiuckFilterNumberValue.setVisible(true);
                this.txtQiuckFilterNumberValue.requestFocus();
                this.txtQiuckFilterNumberValue.selectAll();
                this.txtQuickFilterValue.setVisible(false);
            } else {
                this.chkVagueQuery.setEnabled(true);
                this.chkVagueQuery.setSelected(true);
                this.txtQuickFilterValue.setVisible(true);
                this.txtQuickFilterValue.requestFocus();
                this.txtQuickFilterValue.selectAll();
                this.txtQiuckFilterNumberValue.setVisible(false);
            }
        }
    }

    private void initData() {
        this.initComponent();
        this.initCapitalSensitiveQuery();
        this.getUIContext().remove("InitDataObject");
    }

    private void initCustomerData() {
        KDBizPromptBox prmtBox = (KDBizPromptBox)this.getUIContext().get("prmtBox");
        String queryInfoName = prmtBox.getQueryInfo();
        MetaDataPK pk = MetaDataPK.create((String)queryInfoName.replaceAll("\\\\", "."));
        this.queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        this.customerViewInfo = prmtBox.getEntityViewInfo();
    }

    private void initComponent() {
        this.cmbQuickFilterType.addItems((Object[])this.getFilterFields());
        this.treeView.getControlPane().removeAll();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtQuickFilterValue, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtQiuckFilterNumberValue, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlPlainDocument cpd = new CtrlPlainDocument();
        cpd.setCtrTextDocumentFilter((ICtrTextDocumentFilter)new NumberTextDocumentFilter(this.txtQiuckFilterNumberValue));
        this.txtQiuckFilterNumberValue.setDocument((Document)cpd);
    }

    private TreeSelectionListener[] removeAllTreeSelectionListener() {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.treeMain.removeTreeSelectionListener(listeners[i]);
        }
        return listeners;
    }

    private void addAllTreeSelectionListener(TreeSelectionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.treeMain.addTreeSelectionListener(listeners[i]);
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMResource", (String)key);
    }

    private void initCapitalSensitiveQuery() {
        String capitalSensitiveQuery = ParamHelper.getCapitalSensitiveQuery();
        if (capitalSensitiveQuery != null && capitalSensitiveQuery.equalsIgnoreCase("true")) {
            this.isCapitalSensitiveQuery = true;
        }
    }

    private void launchQuickFilter() {
        EntityViewInfo evi = this.getQuickFilterEntityViewInfo();
        if (evi == null) {
            evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
        }
        FilterInfo customerFiilterInfo = this.customerViewInfo.getFilter();
        try {
            evi.getFilter().mergeFilter(customerFiilterInfo, "AND");
            this.mainQuery = evi;
            this.execQuery();
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
            this.setSelectFirstRow(this.tblMain);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private EntityViewInfo getQuickFilterEntityViewInfo() {
        String theValue = "";
        theValue = this.txtQuickFilterValue.getText().trim();
        if (theValue.length() == 0) {
            return null;
        }
        if (this.cmbQuickFilterType.getSelectedItem() == null || this.cmbQuickFilterType.getItemCount() == 0) {
            return null;
        }
        String theCompareString = "=";
        if (this.chkVagueQuery.isSelected()) {
            theCompareString = "like";
        }
        FilterFieldItem selffi = (FilterFieldItem)this.cmbQuickFilterType.getSelectedItem();
        String theFieldName = selffi.getName();
        ConstDataType theFieldType = selffi.getType();
        StringBuffer oql = new StringBuffer("where ");
        if (this.numberAndName.equals(theFieldName)) {
            oql.append(this.getQuickFilterOql("number", theFieldType, theCompareString, theValue));
            oql.append(" or ");
            oql.append(this.getQuickFilterOql("name", theFieldType, theCompareString, theValue));
        } else if (this.allFilterFieldName != null && theFieldName.equals(this.allFilterFieldName)) {
            String[] all = this.allFilterFieldName.split("[+]");
            if (all.length > 0) {
                oql.append(this.getQuickFilterOql(all[0], theFieldType, theCompareString, theValue));
                for (int i = 1; i < all.length; ++i) {
                    oql.append(" or ");
                    oql.append(this.getQuickFilterOql(all[i], theFieldType, theCompareString, theValue));
                }
            }
        } else {
            oql.append(this.getQuickFilterOql(theFieldName, theFieldType, theCompareString, theValue));
        }
        EntityViewInfo evi = null;
        try {
            evi = new EntityViewInfo(oql.toString());
        }
        catch (Exception e) {
            evi = null;
        }
        return evi;
    }

    private String getQuickFilterOql(String fieldName, ConstDataType theFieldType, String compareStr, String value) {
        String theValue = value;
        if (this.chkVagueQuery.isSelected()) {
            theValue = ParamHelper.getMatchString((String)fieldName, (String)theValue, (String)this.queryInfo.getFullName());
        }
        if (theFieldType.equals((Object)ConstDataType.STRING)) {
            theValue = "'" + theValue + "'";
        }
        if (this.isCapitalSensitiveQuery) {
            return fieldName + " " + compareStr + " " + theValue;
        }
        return "upper(" + fieldName + ") " + compareStr + " " + theValue.toUpperCase();
    }

    private FilterFieldItem[] getFilterFields() {
        SelectorInfo si = this.queryInfo.getSelector();
        ArrayList<FilterFieldItem> al = new ArrayList<FilterFieldItem>();
        int sizeOfSI = si.size();
        for (int i = 0; i < sizeOfSI; ++i) {
            QueryFieldInfo qfi = si.get(i);
            String theExtendPropertyValue = qfi.getExtendedProperty("isCommonQueryFilter");
            if (theExtendPropertyValue == null || !theExtendPropertyValue.equals("true")) continue;
            ConstDataType cdt = null;
            try {
                cdt = qfi.getReturnType();
            }
            catch (Exception e) {
                cdt = ConstDataType.STRING;
            }
            if (cdt.equals((Object)ConstDataType.DATE) || cdt.equals((Object)ConstDataType.BOOLEAN) || cdt.equals((Object)ConstDataType.TIME) || cdt.equals((Object)ConstDataType.TIMESTAMP) || this.isEnumField(qfi)) continue;
            al.add(new FilterFieldItem(qfi.getName(), qfi.getDisplayName(), cdt));
        }
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        for (int i = 0; i < sizeOfAL; ++i) {
            ffis[i] = (FilterFieldItem)al.get(i);
        }
        if (ffis.length == 0) {
            ffis = new FilterFieldItem[]{new FilterFieldItem("number", this.getMLS("number", "Number"), ConstDataType.STRING), new FilterFieldItem("name", this.getMLS("name", "Name"), ConstDataType.STRING)};
        }
        ffis = this.addNumberNameCompFilter(ffis);
        this.allFilterFieldName = this.queryInfo.getExtendedProperty("allFilterFieldName");
        if (this.allFilterFieldName != null) {
            String allFilterFieldDesc = this.getMLS("numbernamehelpcode", "number+name+helpcode");
            FilterFieldItem ffisall = new FilterFieldItem(this.allFilterFieldName, allFilterFieldDesc, ConstDataType.STRING);
            FilterFieldItem[] rtFf = new FilterFieldItem[ffis.length + 1];
            rtFf[0] = ffisall;
            System.arraycopy(ffis, 0, rtFf, 1, ffis.length);
            ffis = rtFf;
        }
        return ffis;
    }

    private FilterFieldItem[] addNumberNameCompFilter(FilterFieldItem[] ff) {
        if (ff != null) {
            int count = 0;
            for (int i = 0; i < ff.length; ++i) {
                if (ff[i] != null && "number".equals(ff[i].getName())) {
                    ++count;
                    continue;
                }
                if (ff[i] == null || !"name".equals(ff[i].getName())) continue;
                ++count;
            }
            if (count == 2) {
                FilterFieldItem ffis = new FilterFieldItem(this.numberAndName, this.getMLS("number", "Number") + "+" + this.getMLS("name", "Name"), ConstDataType.STRING);
                FilterFieldItem[] rtFf = new FilterFieldItem[ff.length + 1];
                rtFf[0] = ffis;
                System.arraycopy(ff, 0, rtFf, 1, ff.length);
                ff = rtFf;
            }
        }
        return ff;
    }

    private boolean isEnumField(QueryFieldInfo qfi) {
        OwnPropertyInfo opi;
        boolean isEnum = false;
        PropertyRefCollection pfc = qfi.getPropertyRefs();
        PropertyRefInfo pri = pfc.get(0);
        PropertyInfo pi = pri.getRefProperty();
        if (pi instanceof OwnPropertyInfo && (opi = (OwnPropertyInfo)pi).getDataType().equals((Object)DataType.ENUM)) {
            isEnum = true;
        }
        return isEnum;
    }

    private String getMLS(String key, String defaultValue) {
        Locale local = Locale.getDefault();
        if (local.toString().toLowerCase().indexOf("l") >= 0) {
            local = this.shortToLong(local);
        }
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog", (Locale)local, (String)defaultValue);
    }

    private Locale shortToLong(Locale local) {
        if (local != null) {
            if (StringUtils.equalsIgnoreCase((String)local.toString(), (String)"12")) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (StringUtils.equalsIgnoreCase((String)local.toString(), (String)"13")) {
                return Locale.TRADITIONAL_CHINESE;
            }
            if (StringUtils.equalsIgnoreCase((String)local.toString(), (String)"11")) {
                return Locale.ENGLISH;
            }
        }
        return local;
    }

    private class NumberTextDocumentFilter
    implements ICtrTextDocumentFilter {
        private String validStr = ".";
        private KDTextField field = null;
        private String value = null;

        public NumberTextDocumentFilter(KDTextField txtField) {
            this.field = txtField;
        }

        public boolean isValidateStr(String str) {
            int length = str.length();
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (Character.isDigit(c) || this.validStr.indexOf(str) >= 0) continue;
                return false;
            }
            String oldStr = this.field.getText();
            String newStr = oldStr + str;
            try {
                new BigDecimal(newStr);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public void setValidateStr(String newValue) {
            this.value = newValue;
        }

        public String getValidateStr() {
            return this.value;
        }

        public boolean isValidLength(Document doc) {
            return true;
        }

        public void setValidLength(int len) {
        }
    }

    private class FilterFieldItem {
        private String ffiName;
        private String ffiDisplayName;
        private ConstDataType fficdt;

        FilterFieldItem(String name, String displayName, ConstDataType cdt) {
            this.ffiName = name;
            this.ffiDisplayName = displayName;
            this.fficdt = cdt;
        }

        public String toString() {
            return this.ffiDisplayName;
        }

        public String getName() {
            return this.ffiName;
        }

        public ConstDataType getType() {
            return this.fficdt;
        }
    }
}

