/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.client.AbstractF7BomParentEntryFilterUI;
import com.kingdee.eas.mm.basedata.client.F7BomSelectProcessor;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import java.awt.Component;
import org.apache.log4j.Logger;

public class F7BomParentEntryFilterUI
extends AbstractF7BomParentEntryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(F7BomParentEntryFilterUI.class);
    private static final String parentMaterialNumber = "material.number";
    private StorageOrgUnitInfo storageOrgUnit = null;
    private static final String entryMaterialNumber = "material1.number";
    private static final String status = "material.status";
    private static final String bomNum = "parent.number";
    private BomInfo bomInfo = null;
    private boolean ddBom = true;
    private boolean zzBom = true;
    private boolean pzBom = true;

    public F7BomParentEntryFilterUI() throws Exception {
    }

    public F7BomParentEntryFilterUI(boolean ddBom, boolean pzBom, boolean zzBom, BomInfo bomInfo) throws Exception {
        this.ddBom = ddBom;
        this.pzBom = pzBom;
        this.zzBom = zzBom;
        this.bomInfo = bomInfo;
    }

    public F7BomParentEntryFilterUI(StorageOrgUnitInfo storageOrgUnit, boolean ddBom, boolean pzBom, boolean zzBom, BomInfo bomInfo) throws Exception {
        this.storageOrgUnit = storageOrgUnit;
        this.ddBom = ddBom;
        this.pzBom = pzBom;
        this.zzBom = zzBom;
        this.bomInfo = bomInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MMRangeFilterElement material1Element = new MMRangeFilterElement(parentMaterialNumber, (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo);
        elements.add((FilterElement)material1Element);
        MMRangeFilterElement materialElement = new MMRangeFilterElement(entryMaterialNumber, (Component)this.prmtChildMaterialFrom, (Component)this.prmtChildMaterialTo);
        elements.add((FilterElement)materialElement);
        MMRangeFilterElement bomElement = new MMRangeFilterElement(bomNum, (Component)this.prmtBomFrom, (Component)this.prmtBomTo);
        elements.add((FilterElement)bomElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setBizMaterialF7();
        this.initF7();
        this.initProjectTrackF7();
        this.kDLabelContainer10.setVisible(false);
        this.kDLabelContainer8.setVisible(false);
        this.kDLabelContainer9.setVisible(false);
    }

    protected void setBizMaterialF7() {
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtMaterialFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtMaterialTo, false, queryInfo);
        this.setBizMaterialF7(this.prmtChildMaterialFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtChildMaterialTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Integer materialStatus = new Integer(1);
        filter.getFilterItems().add(new FilterItemInfo(status, (Object)materialStatus, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtMaterialFrom.setEntityViewInfo(view);
        this.prmtMaterialTo.setEntityViewInfo(view);
        this.prmtChildMaterialFrom.setEntityViewInfo(view);
        this.prmtChildMaterialTo.setEntityViewInfo(view);
    }

    private void initBomF7(KDBizPromptBox prmtBom) {
        F7BomSelectProcessor selectProcessor = new F7BomSelectProcessor(prmtBom);
        prmtBom.setSelector((KDPromptSelector)selectProcessor);
        prmtBom.setCommitParser((IParser)selectProcessor);
        prmtBom.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7BomSelectQuery");
        prmtBom.setDisplayFormat("$number$");
        prmtBom.setEditFormat("$number$");
        prmtBom.setCommitFormat("$number$");
        prmtBom.setEnabledMultiSelection(false);
    }

    protected void initF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        Integer bomStatus = new Integer(4);
        filterInfo.getFilterItems().add(new FilterItemInfo("bom.basestatus", (Object)bomStatus, CompareType.EQUALS));
        if (!(this.ddBom || this.pzBom || this.zzBom)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bom.bomType", (Object)new Integer(20), CompareType.EQUALS));
        } else {
            if (this.ddBom) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bom.bomType", (Object)new Integer(45), CompareType.EQUALS));
            }
            if (this.pzBom) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bom.bomType", (Object)new Integer(50), CompareType.EQUALS));
            }
            if (this.zzBom) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bom.bomType", (Object)new Integer(40), CompareType.EQUALS));
            }
        }
        sb.append("#0 and #1 ");
        int tempMaskNum = 0;
        sb.append(" and (");
        for (int i = tempMaskNum = 2; i < filterInfo.getFilterItems().size(); ++i) {
            if (i == tempMaskNum) {
                sb.append("#" + i);
                continue;
            }
            sb.append(" or #" + i);
        }
        sb.append(")");
        filterInfo.setMaskString(sb.toString());
        viewInfo.setFilter(filterInfo);
        this.prmtBomFrom.setEntityViewInfo(viewInfo);
        this.prmtBomTo.setEntityViewInfo(viewInfo);
        this.initBomF7(this.prmtBomFrom);
        this.initBomF7(this.prmtBomTo);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void clear() {
        super.clear();
        if (this.storageOrgUnit != null) {
            this.prmtStorageOrgUnit.setData((Object)this.storageOrgUnit);
            this.initF7();
        }
    }

    protected EntityViewInfo setEntityViewInfo(FilterInfo userFilterInfo, String property, String values) {
        EntityViewInfo view = super.setEntityViewInfo(userFilterInfo, property, values);
        return view;
    }

    private void initProjectTrackF7() {
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNum);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNum, (KDBizPromptBox)this.prmtTractNumFrom, (boolean)false);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNum, (KDBizPromptBox)this.prmtTractNumTo, (boolean)false);
    }
}

