/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.mm.basedata.BOMFacadeFactory;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.BomViewOptionEnum;
import com.kingdee.eas.mm.basedata.client.AbstractF7BomParentEntryListUI;
import com.kingdee.eas.mm.basedata.client.F7BomParentEntryFilterUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class F7BomParentEntryListUI
extends AbstractF7BomParentEntryListUI {
    private static final Logger logger = CoreUIObject.getLogger(F7BomParentEntryListUI.class);
    private KDTDataFillListener kdtableDataFillListener = null;
    private ActionListener subMaterialListener = null;
    public CommonQueryDialog commonQueryDialog = null;
    private boolean isCancel = false;
    private Object data = null;
    private KDTable kdt;
    private FilterInfo dialogFilter = null;
    protected static final Object DEFAULTVALUE = new Object();
    protected static final Object BADVALUE = new Object();
    private final String[] KDT_DATES = new String[]{"effectiveDate", "disabledDate"};

    public boolean isCancel() {
        return this.isCancel;
    }

    public void onLoad() throws Exception {
        if (this.kdtableDataFillListener != null) {
            this.tblMain.removeKDTDataFillListener(this.kdtableDataFillListener);
        }
        this.kdtableDataFillListener = new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                F7BomParentEntryListUI.this.kdtable_afterDataFill(e);
            }
        };
        this.tblMain.addKDTDataFillListener(this.kdtableDataFillListener);
        this.subMaterialListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BomViewOptionEnum bomViewOption = (BomViewOptionEnum)((Object)F7BomParentEntryListUI.this.comBomViewOption.getSelectedItem());
                F7BomParentEntryListUI.this.saveBomViewOption(bomViewOption);
                F7BomParentEntryListUI.this.mainQuery.setFilter(F7BomParentEntryListUI.this.getCustomFilter());
                F7BomParentEntryListUI.this.tblMain.removeRows();
            }
        };
        this.comBomViewOption.addActionListener(this.subMaterialListener);
        super.onLoad();
        this.getMainPanel().setPreferredSize(new Dimension(660, 380));
        this.comBomViewOption.setEnabled(true);
        this.comBomViewOption.removeItem((Object)BomViewOptionEnum.QUERY_DATE_MATERIAL);
        this.initWorkButton();
        this.setViewOptionValue();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])this.KDT_DATES);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public OrgType getBizOrgType() {
        return OrgType.Storage;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected String getEditUIName() {
        return CoreBillEditUI.class.getName();
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        boolean isBomType;
        Map map = null;
        map = this.getUIContext();
        boolean ddBom = (Boolean)map.get("ORDERBOM");
        boolean pzBom = (Boolean)map.get("CFGBom");
        boolean zzBom = (Boolean)map.get("MFGBOM");
        BomInfo bomInfo = (BomInfo)map.get("BOMINFO");
        boolean bl = isBomType = ddBom && pzBom && zzBom;
        if (map.get("StorageOrgUnitInfo") == null && isBomType) {
            return new F7BomParentEntryFilterUI();
        }
        if (map.get("StorageOrgUnitInfo") == null) {
            return new F7BomParentEntryFilterUI(ddBom, pzBom, zzBom, bomInfo);
        }
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)map.get("StorageOrgUnitInfo");
        return new F7BomParentEntryFilterUI(orgInfo, ddBom, pzBom, zzBom, bomInfo);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(500);
            this.commonQueryDialog.setHeight(380);
            try {
                this.commonQueryDialog.setShowFilter(false);
                this.commonQueryDialog.setShowSorter(false);
                this.commonQueryDialog.setUiObject(null);
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BomFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initWorkButton() {
        this.toolBar.setVisible(true);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        } else if (e.getType() == 1 && e.getClickCount() == 2) {
            this.selectDataProcess(null);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                F7BomParentEntryListUI.this.selectDataProcess(e);
            }
        });
    }

    private void selectDataProcess(ActionEvent e) {
        try {
            this.getSelectData();
            this.isCancel = false;
            super.destroyWindow();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    @Override
    protected void btnCanncel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        super.destroyWindow();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.data == null) {
            this.getSelectData();
        }
        this.isCancel = false;
        super.destroyWindow();
    }

    public boolean destroyWindow() {
        this.isCancel = true;
        return super.destroyWindow();
    }

    private void getSelectData() throws Exception {
        BomInfo[] ret;
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList == null || blockList.size() == 0) {
            return;
        }
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblMain.setRowCount(this.getRowCountFromDB());
        }
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length == 0) {
            return;
        }
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        ArrayList selectList = new ArrayList();
        ArrayList ids = ListUiHelper.getSelectedIdValues((KDTable)this.tblMain, (String)this.getKeyFieldName(), selectList, (List)selectKeyIdFields);
        HashMap<String, BomInfo> bomMap = new HashMap<String, BomInfo>();
        String id = null;
        String entryId = null;
        BomInfo bomInfo = null;
        BomEntryInfo bomEntryInfo = null;
        BomEntryCollection collection = null;
        for (int i = 0; i < selectList.size(); ++i) {
            int rowIndex = Integer.parseInt(selectList.get(i).toString());
            if (this.tblMain.getCell(rowIndex, "entrys.id") == null) continue;
            entryId = (String)this.tblMain.getCell(rowIndex, "entrys.id").getValue();
            id = (String)this.tblMain.getCell(rowIndex, "id").getValue();
            if (!id.equals(ids.get(ids.indexOf(id)))) continue;
            if (bomMap.get(id) != null) {
                bomInfo = (BomInfo)bomMap.get(id);
                bomEntryInfo = new BomEntryInfo();
                bomEntryInfo.setId(BOSUuid.read((String)entryId));
                if (bomInfo.getEntrys() != null) {
                    bomInfo.getEntrys().add(bomEntryInfo);
                    continue;
                }
                collection = new BomEntryCollection();
                collection.add(bomEntryInfo);
                bomInfo.put("entrys", (Object)collection);
                continue;
            }
            bomInfo = new BomInfo();
            bomInfo.setId(BOSUuid.read((String)id));
            bomEntryInfo = new BomEntryInfo();
            bomEntryInfo.setId(BOSUuid.read((String)entryId));
            collection = new BomEntryCollection();
            collection.add(bomEntryInfo);
            bomInfo.put("entrys", (Object)collection);
            bomMap.put(id, bomInfo);
        }
        this.data = ret = BOMFacadeFactory.getRemoteInstance().getBomParentEntryProjectTrackForF7(bomMap);
    }

    public Object getData() {
        return this.data;
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    public int getRowsCount() {
        int count = 0;
        count = this.tblMain.getRowCount();
        return count;
    }

    public KDTable getKdt() {
        this.kdt = this.tblMain;
        return this.kdt;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getDefaultCUFilter(true);
    }

    protected FilterInfo getCustomFilter() {
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.getUIContext().get("StorageOrgUnitInfo");
        boolean ddBom = (Boolean)this.getUIContext().get("ORDERBOM");
        boolean pzBom = (Boolean)this.getUIContext().get("CFGBom");
        boolean zzBom = (Boolean)this.getUIContext().get("MFGBOM");
        BomInfo bomInfo = (BomInfo)this.getUIContext().get("BOMINFO");
        String queryString = this.getUIContext().get("QUERYSTRING") == null ? null : this.getUIContext().get("QUERYSTRING").toString();
        String orgId = null;
        if (orgInfo != null) {
            orgId = orgInfo.getId().toString();
        }
        Integer bomStatus = new Integer(4);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)bomStatus, CompareType.EQUALS));
        if (bomInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)bomInfo.getId().toString(), CompareType.EQUALS));
        }
        if (queryString != null) {
            if (this.getUIContext().get("FIELDKEY") != null && this.getUIContext().get("FIELDKEY").toString().equals("bomNo")) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.number", (Object)("%" + queryString + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("material1.number", (Object)("%" + queryString + "%"), CompareType.LIKE));
            }
        }
        if (!(ddBom || pzBom || zzBom)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.bomType", (Object)new Integer(20), CompareType.EQUALS));
        } else {
            if (ddBom) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.bomType", (Object)new Integer(45), CompareType.EQUALS));
            }
            if (pzBom) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.bomType", (Object)new Integer(50), CompareType.EQUALS));
            }
            if (zzBom) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.bomType", (Object)new Integer(40), CompareType.EQUALS));
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("#0 and #1 ");
        int tempMaskNum = 2;
        if (bomInfo != null) {
            sb.append(" and #2 ");
            ++tempMaskNum;
        }
        if (queryString != null) {
            sb.append(" and #" + tempMaskNum);
            ++tempMaskNum;
        }
        sb.append(" and (");
        for (int i = tempMaskNum; i < filterInfo.getFilterItems().size(); ++i) {
            if (i == tempMaskNum) {
                sb.append("#" + i);
                continue;
            }
            sb.append(" or #" + i);
        }
        sb.append(")");
        filterInfo.setMaskString(sb.toString());
        filterInfo = this.getSubMaterialFilterInfo(filterInfo);
        return filterInfo;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isIgnorePermissionCheck = true;
        if (viewInfo.getSorter() != null && viewInfo.getSorter().size() > 0 && !viewInfo.getSorter().toString().equals("")) {
            SorterItemCollection sorters = new SorterItemCollection();
            boolean hasNumberSorter = false;
            boolean hasBomTypeSorter = false;
            for (int i = 0; i < sorters.size(); ++i) {
                if (viewInfo.getSorter().get(i).getPropertyName().equals("parent.bomType")) {
                    hasBomTypeSorter = true;
                }
                if (!viewInfo.getSorter().get(i).getPropertyName().equals("parent.number")) continue;
                hasNumberSorter = true;
            }
            if (!hasBomTypeSorter) {
                SorterItemInfo aSorterItemInfo = new SorterItemInfo("parent.bomType");
                aSorterItemInfo.setSortType(SortType.ASCEND);
                sorters.add(aSorterItemInfo);
            }
            if (!hasNumberSorter) {
                SorterItemInfo aSorterItemInfo = new SorterItemInfo("parent.number");
                aSorterItemInfo.setSortType(SortType.ASCEND);
                sorters.add(aSorterItemInfo);
            }
            viewInfo.setSorter(sorters);
        } else {
            SorterItemInfo aSorterItemInfo = new SorterItemInfo("parent.bomType");
            aSorterItemInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(aSorterItemInfo);
            aSorterItemInfo = new SorterItemInfo("project.number");
            aSorterItemInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(aSorterItemInfo);
        }
        return exec;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        this.setFilterForQuery(this.getCustomFilter());
        super.beforeExcutQuery(ev);
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    public void kdtable_afterDataFill(KDTDataRequestEvent e) {
        KDTable table = this.getMainTable();
        int currRowCount = table.getRowCount3();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        HashSet<String> orderBomIdSet = new HashSet<String>();
        HashSet<String> cfgBomEntryIdSet = new HashSet<String>();
        String orderBomId = null;
        String cfgBomEntryId = null;
        String projectNumber = null;
        try {
            BizEnumValueDTO bomType;
            for (int i = start; i <= end && i <= currRowCount - 1; ++i) {
                bomType = (BizEnumValueDTO)table.getCell(i, "bomType").getValue();
                projectNumber = (String)table.getCell(i, "project.number").getValue();
                if (bomType.getInt() == 50) {
                    table.getCell(i, "projectNumber").setValue((Object)projectNumber);
                    cfgBomEntryId = (String)table.getCell(i, "entrys.id").getValue();
                    if (cfgBomEntryId == null) continue;
                    cfgBomEntryIdSet.add(cfgBomEntryId);
                    continue;
                }
                if (bomType.getInt() != 45 || (orderBomId = (String)table.getCell(i, "id").getValue()) == null) continue;
                orderBomIdSet.add(orderBomId);
            }
            if (orderBomIdSet.size() > 0) {
                Map ret = BOMFacadeFactory.getRemoteInstance().getBomProjectNumberTrackNumber(orderBomIdSet);
                for (int i = start; i <= end && i <= currRowCount; ++i) {
                    bomType = (BizEnumValueDTO)table.getCell(i, "bomType").getValue();
                    if (bomType.getInt() != 45 || (orderBomId = (String)table.getCell(i, "id").getValue()) == null) continue;
                    List list = (List)ret.get(orderBomId);
                    table.getCell(i, "projectNumber").setValue((Object)this.converSetToString((Set)list.get(0)));
                    table.getCell(i, "trackNumber").setValue((Object)this.converSetToString((Set)list.get(1)));
                }
            }
            if (cfgBomEntryIdSet.size() > 0) {
                String bomEntryId = null;
                Set tackSet = null;
                Map ret = BOMFacadeFactory.getRemoteInstance().getBomEntryTrackNumber(cfgBomEntryIdSet);
                for (int i = start; i <= end && i <= currRowCount; ++i) {
                    bomType = (BizEnumValueDTO)table.getCell(i, "bomType").getValue();
                    if (bomType.getInt() != 50 || (bomEntryId = (String)table.getCell(i, "entrys.id").getValue()) == null) continue;
                    tackSet = (Set)ret.get(bomEntryId);
                    table.getCell(i, "cfgTrackNumber").setValue((Object)this.converSetToString(tackSet));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Get project and trackNumber error:" + ex));
        }
    }

    private String converSetToString(Set set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        StringBuffer numbers = new StringBuffer();
        Iterator it = set.iterator();
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null) continue;
            if (numbers.length() > 0) {
                numbers.append(";");
            }
            numbers.append((Object)obj);
        }
        return numbers.toString();
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    public void actionViewOption_actionPerformed(ActionEvent e) throws Exception {
        this.getOptionKeySuffix();
        this.mainQuery.setFilter(this.getCustomFilter());
        this.tblMain.removeRows();
    }

    private String getOptionKeySuffix() {
        String suffixStr = "";
        if (this.getUIContext().get("isUICache") != null && this.getUIContext().get("isUICache").toString().equals("true")) {
            suffixStr = "f7bomTree";
            if (this.getUIContext().get("UIClassParam") != null && this.getUIContext().get("UIClassParam").toString().equals("1")) {
                suffixStr = "f7orderBomTree";
            }
        }
        return suffixStr;
    }

    private FilterInfo getSubMaterialFilterInfo(FilterInfo filter) {
        int index = filter.getFilterItems().size();
        BomViewOptionEnum bomViewOption = (BomViewOptionEnum)((Object)this.comBomViewOption.getSelectedItem());
        StringBuffer sb = new StringBuffer(filter.getMaskString());
        Date date = new Date();
        if (this.getDialog() != null && this.getDialog().getEntityViewInfoResult() != null && this.getDialog().getEntityViewInfoResult().getFilter() != null && this.getDialog().getEntityViewInfoResult().getFilter().getFilterItems().size() > 0) {
            this.dialogFilter = this.getDialog().getEntityViewInfoResult().getFilter();
        }
        if (this.dialogFilter != null) {
            int size = this.dialogFilter.getFilterItems().size();
            FilterItemCollection col = this.dialogFilter.getFilterItems();
            Object[] items = col.toArray();
            for (int i = 0; i < size; ++i) {
                filter.getFilterItems().add((FilterItemInfo)items[i]);
                sb.append(" and #" + index);
                ++index;
            }
        }
        if (!bomViewOption.equals((Object)BomViewOptionEnum.ALL_MATERIAL)) {
            if (bomViewOption.equals((Object)BomViewOptionEnum.CURRENT_MATERIAL)) {
                sb.append(" and #" + index);
                sb.append(" and #" + ++index);
                filter.setMaskString(sb.toString());
                filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)date, CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("disableDate", (Object)date, CompareType.GREATER));
            } else if (bomViewOption.equals((Object)BomViewOptionEnum.DISABLE_MATERIAL)) {
                FilterItemInfo itemInfo = new FilterItemInfo("effectiveDate", (Object)"disableDate", CompareType.EQUALS);
                itemInfo.setCompareValueIsProperty(true);
                filter.getFilterItems().add(itemInfo);
                filter.getFilterItems().add(new FilterItemInfo("disableDate", (Object)date, CompareType.LESS_EQUALS));
                sb.append(" and (#" + index);
                sb.append(" or #" + ++index + ")");
                filter.setMaskString(sb.toString());
            } else if (bomViewOption.equals((Object)BomViewOptionEnum.WILL_MATERIAL)) {
                FilterItemInfo itemInfo = new FilterItemInfo("effectiveDate", (Object)"disableDate", CompareType.NOTEQUALS);
                itemInfo.setCompareValueIsProperty(true);
                filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)date, CompareType.GREATER));
                filter.getFilterItems().add(itemInfo);
                sb.append(" and #" + index);
                sb.append(" and #" + ++index);
                filter.setMaskString(sb.toString());
            }
        }
        return filter;
    }

    protected void setViewOptionValue() {
        HashSet<BomViewOptionEnum> menuItemSet = new HashSet<BomViewOptionEnum>();
        menuItemSet.add(BomViewOptionEnum.ALL_MATERIAL);
        menuItemSet.add(BomViewOptionEnum.CURRENT_MATERIAL);
        menuItemSet.add(BomViewOptionEnum.DISABLE_MATERIAL);
        menuItemSet.add(BomViewOptionEnum.WILL_MATERIAL);
        Iterator it = menuItemSet.iterator();
        BomViewOptionEnum item = null;
        String value = null;
        boolean isSeletct = false;
        while (it.hasNext()) {
            item = (BomViewOptionEnum)((Object)it.next());
            value = ConfigServiceUtils.getUserConfigData((String)item.getName(), (CoreUI)this);
            if (!Boolean.TRUE.toString().equalsIgnoreCase(value)) continue;
            this.comBomViewOption.setSelectedItem((Object)item);
            isSeletct = true;
            break;
        }
        if (!isSeletct) {
            this.comBomViewOption.setSelectedItem((Object)BomViewOptionEnum.ALL_MATERIAL);
        }
    }

    private void saveBomViewOption(BomViewOptionEnum bomViewOption) {
        HashSet<BomViewOptionEnum> menuItemSet = new HashSet<BomViewOptionEnum>();
        menuItemSet.add(BomViewOptionEnum.ALL_MATERIAL);
        menuItemSet.add(BomViewOptionEnum.CURRENT_MATERIAL);
        menuItemSet.add(BomViewOptionEnum.DISABLE_MATERIAL);
        menuItemSet.add(BomViewOptionEnum.WILL_MATERIAL);
        Iterator it = menuItemSet.iterator();
        BomViewOptionEnum item = null;
        String value = null;
        boolean isSeletct = false;
        while (it.hasNext()) {
            item = (BomViewOptionEnum)((Object)it.next());
            value = Boolean.FALSE.toString();
            if (item.equals((Object)bomViewOption)) {
                value = Boolean.TRUE.toString();
            }
            ConfigServiceUtils.saveUserConfigData((String)item.getName(), (CoreUI)this, (String)value);
        }
    }
}

