/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.eas.mm.basedata.BOMFacadeFactory;
import com.kingdee.eas.mm.basedata.client.F7BomSelectProcessor;
import com.kingdee.eas.mm.common.client.F7CustomProcessor;
import com.kingdee.eas.mm.common.client.F7CustomSelectUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class F7BomSelectUI
extends F7CustomSelectUI {
    private static Logger logger = Logger.getLogger(F7BomSelectUI.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BasedataResource";

    public F7BomSelectUI(KDBizPromptBox bizPromtBox, F7BomSelectProcessor bomSelectProcessor) {
        super((Frame)null, bizPromtBox, (F7CustomProcessor)bomSelectProcessor);
    }

    public F7BomSelectUI(Dialog owner, KDBizPromptBox bizPromtBox, F7BomSelectProcessor bomSelectProcessor) {
        super(owner, null, bizPromtBox, (F7CustomProcessor)bomSelectProcessor);
    }

    public F7BomSelectUI(Frame owner, KDBizPromptBox bizPromtBox, F7BomSelectProcessor bomSelectProcessor) {
        super(owner, null, bizPromtBox, (F7CustomProcessor)bomSelectProcessor);
    }

    public F7BomSelectUI(Dialog owner, String title, KDBizPromptBox bizPromtBox, F7BomSelectProcessor bomSelectProcessor) {
        super(owner, title, bizPromtBox, (F7CustomProcessor)bomSelectProcessor);
    }

    public F7BomSelectUI(Frame owner, String title, KDBizPromptBox bizPromtBox, F7BomSelectProcessor bomSelectProcessor) {
        super(owner, title, bizPromtBox, (F7CustomProcessor)bomSelectProcessor);
    }

    protected void kdtTable_doRequestRowSet(RequestRowSetEvent e) {
        super.kdtTable_doRequestRowSet(e);
    }

    public void kdtable_afterDataFill(KDTDataRequestEvent e) {
        super.kdtable_afterDataFill(e);
        int currRowCount = this.table.getRowCount3();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        HashSet<String> set = new HashSet<String>();
        String bomId = null;
        String projectNumber = null;
        try {
            BizEnumValueDTO bomType;
            for (int i = start; i <= end && i <= currRowCount - 1; ++i) {
                bomType = (BizEnumValueDTO)this.table.getCell(i, "bomType").getValue();
                projectNumber = (String)this.table.getCell(i, "project.number").getValue();
                if (bomType.getInt() == 50) {
                    this.table.getCell(i, "projectNumber").setValue((Object)projectNumber);
                    continue;
                }
                if (bomType.getInt() != 45 || (bomId = (String)this.table.getCell(i, "id").getValue()) == null) continue;
                set.add(bomId);
            }
            if (set.size() <= 0) {
                return;
            }
            Map ret = BOMFacadeFactory.getRemoteInstance().getBomProjectNumberTrackNumber(set);
            for (int i = start; i <= end && i <= currRowCount; ++i) {
                bomType = (BizEnumValueDTO)this.table.getCell(i, "bomType").getValue();
                if (bomType.getInt() != 45 || (bomId = (String)this.table.getCell(i, "id").getValue()) == null) continue;
                List list = (List)ret.get(bomId);
                this.table.getCell(i, "projectNumber").setValue((Object)this.converSetToString((Set)list.get(0)));
                this.table.getCell(i, "trackNumber").setValue((Object)this.converSetToString((Set)list.get(1)));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Get project and trackNumber error:" + ex));
        }
    }

    private String converSetToString(Set set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        StringBuffer numbers = new StringBuffer();
        Iterator it = set.iterator();
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null) continue;
            if (numbers.length() > 0) {
                numbers.append(";");
            }
            numbers.append((Object)obj);
        }
        return numbers.toString();
    }

    protected void fillTable() {
        super.fillTable();
        IColumn col = this.table.addColumn();
        col.setKey("projectNumber");
        IRow row = this.table.getHeadRow(0);
        row.getCell(col.getColumnIndex()).setValue((Object)F7BomSelectUI.getResource("PROJECTNUMBER"));
        col = this.table.addColumn();
        col.setKey("trackNumber");
        row = this.table.getHeadRow(0);
        row.getCell(col.getColumnIndex()).setValue((Object)F7BomSelectUI.getResource("TRACKNUMBER"));
    }

    protected static String getResource(String strKey) {
        return EASResource.getString((String)RESOURCE_PATH, (String)strKey);
    }
}

