/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BOMFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractF7ChangeMaterialEntryUI;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class F7ChangeMaterialEntryUI
extends AbstractF7ChangeMaterialEntryUI {
    private static final Logger logger = CoreUIObject.getLogger(F7ChangeMaterialEntryUI.class);
    private boolean isCancel = false;
    MaterialInfo matinfo = null;
    private KDTable kdt;
    private final String[] KDT_DATES = new String[]{"bomentry.effectiveDate", "bomentry.disableDate"};

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        } else if (e.getClickCount() == 1) {
            this.getSelectData(e);
        } else if (e.getType() == 1 && e.getClickCount() == 2) {
            this.getSelectData(e);
            this.isCancel = false;
            this.destroyWindow();
        }
    }

    private void getSelectData(KDTMouseEvent e) throws Exception {
        Object ordertrack = null;
        ArrayList ids = this.getSelectedIdValues();
        MaterialInfo materialInfo = null;
        materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids.get(0).toString())));
        if (e.getRowIndex() == -1) {
            return;
        }
        if (null != this.tblMain.getCell(e.getRowIndex(), "entrytracknumber").getValue()) {
            ordertrack = this.tblMain.getCell(e.getRowIndex(), "entrytracknumber").getValue();
        }
        materialInfo.put("entryTrack", ordertrack);
        materialInfo.put("effectvieDate", this.tblMain.getCell(e.getRowIndex(), "bomentry.effectiveDate").getValue());
        materialInfo.put("disableDate", this.tblMain.getCell(e.getRowIndex(), "bomentry.disableDate").getValue());
        materialInfo.put("scrapRatio", this.tblMain.getCell(e.getRowIndex(), "scrapRatio").getValue());
        materialInfo.put("consumeFixQty", this.tblMain.getCell(e.getRowIndex(), "bomentry.consumeFixQty").getValue());
        materialInfo.put("consumeType", this.tblMain.getCell(e.getRowIndex(), "bomentry.consumeType").getValue());
        materialInfo.put("proportion", this.tblMain.getCell(e.getRowIndex(), "bomentry.proportion").getValue());
        materialInfo.put("bomEntryid", this.tblMain.getCell(e.getRowIndex(), "bomentry.id").getValue());
        this.matinfo = materialInfo;
    }

    private void getSelectData() throws Exception {
        Object ordertrack = null;
        ArrayList ids = this.getSelectedIdValues();
        MaterialInfo materialInfo = null;
        materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids.get(0).toString())));
        int curRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (null != this.tblMain.getCell(curRowIndex, "entrytracknumber").getValue()) {
            ordertrack = this.tblMain.getCell(curRowIndex, "entrytracknumber").getValue();
        }
        materialInfo.put("entryTrack", ordertrack);
        materialInfo.put("effectvieDate", this.tblMain.getCell(curRowIndex, "bomentry.effectiveDate").getValue());
        materialInfo.put("disableDate", this.tblMain.getCell(curRowIndex, "bomentry.disableDate").getValue());
        materialInfo.put("scrapRatio", this.tblMain.getCell(curRowIndex, "scrapRatio").getValue());
        materialInfo.put("consumeFixQty", this.tblMain.getCell(curRowIndex, "bomentry.consumeFixQty").getValue());
        materialInfo.put("consumeType", this.tblMain.getCell(curRowIndex, "bomentry.consumeType").getValue());
        materialInfo.put("proportion", this.tblMain.getCell(curRowIndex, "bomentry.proportion").getValue());
        materialInfo.put("bomEntryid", this.tblMain.getCell(curRowIndex, "bomentry.id").getValue());
        this.matinfo = materialInfo;
    }

    public void kdtable_afterDataFill(KDTDataRequestEvent e) {
        int currRowCount = this.tblMain.getRowCount3();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        String bomEntryId = null;
        HashSet<String> set = new HashSet<String>();
        for (int i = start; i <= end && i <= currRowCount - 1; ++i) {
            bomEntryId = (String)this.tblMain.getCell(i, "bomentry.id").getValue();
            if (bomEntryId == null) continue;
            set.add(bomEntryId);
        }
        if (set.size() <= 0) {
            return;
        }
        try {
            Map ret = BOMFacadeFactory.getRemoteInstance().getBomEntryTrackNumber(set);
            for (int i = start; i <= end && i <= currRowCount; ++i) {
                bomEntryId = (String)this.tblMain.getCell(i, "bomentry.id").getValue();
                if (bomEntryId == null) continue;
                this.tblMain.getCell(i, "entrytracknumber").setValue((Object)this.converTrackNumberSetToArray((Set)ret.get(bomEntryId)));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private TrackNumberInfo[] converTrackNumberSetToArray(Set set) {
        TrackNumberInfo[] trackNumberInfos = null;
        if (set == null || set.size() <= 0) {
            return trackNumberInfos;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        try {
            TrackNumberCollection collection = TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(view);
            trackNumberInfos = new TrackNumberInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                trackNumberInfos[i] = collection.get(i);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return trackNumberInfos;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                F7ChangeMaterialEntryUI.this.kdtable_afterDataFill(e);
            }
        });
        ObjectValueRender kdtEntry_newTailNo_OVR = new ObjectValueRender();
        kdtEntry_newTailNo_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn("entrytracknumber").setRenderer((IBasicRender)kdtEntry_newTailNo_OVR);
        String bomid = null;
        EntityViewInfo entity = this.getMainQuery();
        FilterInfo filter = new FilterInfo();
        String materialNumber = null;
        Map map = null;
        map = this.getUIContext();
        if (null != map.get("bominfonew")) {
            bomid = map.get("bominfonew").toString();
        }
        materialNumber = (String)map.get("MATERIALNUMBER");
        if (null != bomid) {
            filter.getFilterItems().add(new FilterItemInfo("bom.id", (Object)bomid, CompareType.EQUALS));
            if (null != materialNumber) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + materialNumber + "%"), CompareType.LIKE));
            }
            entity.setFilter(filter);
            this.mainQuery = entity;
            try {
                this.refreshList();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])this.KDT_DATES);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void btnCanncel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCanncel_actionPerformed(e);
        this.isCancel = true;
        this.destroyWindow();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.matinfo == null) {
            this.getSelectData();
        }
        this.isCancel = false;
        this.destroyWindow();
    }

    public MaterialInfo getData() {
        return this.matinfo;
    }

    public KDTable getKdt() {
        this.kdt = this.tblMain;
        return this.kdt;
    }
}

