/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.calendar.extendcontrols.KDWorkCalendar;
import com.kingdee.eas.base.calendar.extendcontrols.KDWorkCalendarEvent;
import com.kingdee.eas.base.calendar.extendcontrols.KDWorkCalendarEventListener;
import com.kingdee.eas.base.calendar.plaf.KingdeeWorkCalendarUI;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.basedata.assistant.client.OrgUnitSltUI;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.FactoryCalendarCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.FactoryCalendarInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarRuleCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarRuleEntryCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarRuleEntryInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarRuleFactory;
import com.kingdee.eas.mm.basedata.FactoryCalendarRuleInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarUtils;
import com.kingdee.eas.mm.basedata.IFactoryCalendar;
import com.kingdee.eas.mm.basedata.IFactoryCalendarRule;
import com.kingdee.eas.mm.basedata.client.AbstractFactoryCalendarEditUI;
import com.kingdee.eas.mm.basedata.client.FactoryCalendarRuleEditUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class FactoryCalendarEditUI
extends AbstractFactoryCalendarEditUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(FactoryCalendarEditUI.class);
    private boolean hasWorkCalendar = false;
    private OrgUnitInfo sltOrgUnitInfo = null;
    private KDWorkCalendar kdWorkCalendar = new KDWorkCalendar();
    private Map myUIContext = null;
    private String workCalendarRes = "com.kingdee.eas.mm.basedata.FactoryCalendarResource";
    private int[] weeksCommand = new int[]{1, 2, 3, 4, 5, 6, 7};
    private KDCheckBox[] weeksBox = new KDCheckBox[]{this.chkSun, this.chkMon, this.chkTue, this.chkWed, this.chkThu, this.chkFri, this.chkSat};
    private int monthsPerPage = 12;
    private int monthsPerRow = 4;
    private int step = 1;
    private Color[] dateTypeColor = new Color[]{new Color(155, 206, 161), new Color(255, 255, 255), new Color(255, 188, 74), new Color(215, 233, 217)};
    private JLabel[] dateTypeLabel = new JLabel[]{this.lblHalfWorkday, this.lblWorkday, this.lblHoliday, this.lblWeekend};
    private Border border = new LineBorder(new Color(180, 180, 180));
    private FactoryCalendarInfo oldData = null;
    private HashMap hasRule = new HashMap();
    private IFactoryCalendarRule iFactoryCalendarRule = FactoryCalendarRuleFactory.getRemoteInstance();
    int genYear = 1900;
    java.util.Date initStartDate;
    java.util.Date initEndDate;
    java.util.Date factStartDate;
    java.util.Date factEndDate;
    private boolean isInitEnd = false;
    IFactoryCalendar iFactoryCalendar = FactoryCalendarFactory.getRemoteInstance();
    private boolean isExist = true;
    private boolean isGen = false;
    private FactoryCalendarRuleInfo genRuleInfo = null;
    private boolean isSubmit = false;
    private boolean isOrgChange = false;
    private boolean isDelOk = false;
    private boolean isReused = false;

    public FactoryCalendarEditUI() throws Exception {
        this.initUI();
        this.actionSubmit.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl S"));
        this.menuItemSubmit.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState() == "VIEW") {
            this.actionSetRule.setEnabled(false);
        } else {
            this.actionSetRule.setEnabled(true);
        }
        if (this.editData.getId() == null) {
            this.actionSetDefault.setEnabled(false);
        } else {
            this.actionSetDefault.setEnabled(true);
        }
        if (this.getOprtState() != "ADDNEW") {
            this.prmtstorageOrgUnit.setEnabled(false);
        }
        if (this.editData.getEntrys().size() > 0) {
            this.actionSubmit.setEnabled(true);
        } else {
            this.actionSubmit.setEnabled(false);
        }
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(false);
        this.txtNumber.setText(this.editData.getNumber());
        this.kDIsDefault.setSelected(this.editData.isIsDefault());
        this.prmtstorageOrgUnit.setReadOnly(false);
        this.prmtstorageOrgUnit.setAccessAuthority(0);
        this.pkStartWorkDate.setAccessAuthority(0);
        this.pkEndWorkDate.setAccessAuthority(0);
        this.calCulateFactStarAndEndDate();
        this.viewWorkCalendarByTime(this.factStartDate);
        this.putEditaDatToWeeksBox();
        this.putEditDataToCalendar();
        if (this.editData != null && this.editData.getEntrys().size() > 0) {
            java.util.Date preMonth = this.preMonth();
            this.setPreMonthBtnStatus(preMonth, false);
            java.util.Date nextMonth = this.nextMonth();
            this.setNextMonthBtnStatus(nextMonth, false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.putCalendarToEditData();
        this.putWeeksBoxToEditData();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.sltOrgUnitInfo == null) {
            return;
        }
        this.validateBeforeSubmit();
        if (this.isReused) {
            FactoryCalendarInfo infoSelf = this.getFactoryCalendarByOrgUnitId(this.sltOrgUnitInfo.getId().toString());
            BOSUuid workCalendarID = null;
            if (infoSelf != null) {
                workCalendarID = infoSelf.getId();
            }
            this.editData.setId(workCalendarID);
            this.isReused = false;
        }
        this.editData.setStorageOrgUnit((StorageOrgUnitInfo)this.sltOrgUnitInfo);
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setStartDate((java.util.Date)this.pkStartWorkDate.getValue());
        this.editData.setEndDate((java.util.Date)this.pkEndWorkDate.getValue());
        this.setDataObject((IObjectValue)this.editData);
        this.setOprtState(OprtState.VIEW);
        try {
            FactoryCalendarEntryInfo startEntryInfo;
            this.isSubmit = true;
            super.actionSubmit_actionPerformed(e);
            FactoryCalendarEntryCollection entrys = this.editData.getEntrys();
            if (entrys != null && entrys.size() > 0 && (startEntryInfo = entrys.get(0)).getId() == null) {
                java.util.Date startDate = startEntryInfo.getWorkDate();
                FactoryCalendarEntryInfo endEntryInfo = entrys.get(entrys.size() - 1);
                java.util.Date endDate = endEntryInfo.getWorkDate();
                entrys = this.iFactoryCalendar.getEntrysById(this.editData.getId().toString(), startDate, endDate);
                this.editData.put("entrys", (Object)entrys);
            }
        }
        catch (Exception ex) {
            this.hasWorkCalendar = false;
            this.oprtStateChanged(OprtState.EDIT);
            throw ex;
        }
        this.hasWorkCalendar = true;
        if (this.editData.getId() != null) {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.oprtStateChanged(OprtState.VIEW);
        this.setOprtState(OprtState.VIEW);
        this.actionSetDefault.setEnabled(true);
        this.isSubmit = false;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.sltOrgUnitInfo = null;
        this.prmtstorageOrgUnit.setData(null);
        this.viewSltWorkCalendarForId(null, null, this.initStartDate, this.initEndDate);
        this.oprtStateChanged(OprtState.ADDNEW);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.sltOrgUnitInfo == null) {
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.oprtStateChanged(OprtState.EDIT);
        this.actionSetRule.setEnabled(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsDefault()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"defaultNotDelete"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        if (this.isDelOk) {
            this.prmtstorageOrgUnit.setData(null);
            this.sltOrgUnitInfo = null;
            this.initStartDate = this.pkStartWorkDate.getSqlDate();
            this.initEndDate = this.pkEndWorkDate.getSqlDate();
            this.viewSltWorkCalendarForId(null, null, this.initStartDate, this.initEndDate);
            this.setOprtState(OprtState.ADDNEW);
            this.oprtStateChanged(OprtState.ADDNEW);
            String msg = EASResource.getString((String)this.workCalendarRes, (String)"delSuccess");
            MMUtils.showInformation((CoreUI)this, (String)msg, (int)2);
        }
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        if (this.sltOrgUnitInfo == null) {
            return;
        }
        if (this.isReused) {
            FactoryCalendarInfo infoSelf = this.getFactoryCalendarByOrgUnitId(this.sltOrgUnitInfo.getId().toString());
            BOSUuid workCalendarID = null;
            if (infoSelf != null) {
                workCalendarID = infoSelf.getId();
            }
            this.editData.setId(workCalendarID);
            this.isReused = false;
        }
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_FactoryCalendar_addNew");
        this.editData.setStorageOrgUnit(info);
        this.setDataObject((IObjectValue)this.editData);
        this.setOprtState(OprtState.VIEW);
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception ex) {
            this.hasWorkCalendar = false;
            this.oprtStateChanged(OprtState.EDIT);
            throw ex;
        }
        this.hasWorkCalendar = true;
        this.oprtStateChanged(OprtState.VIEW);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return this.iFactoryCalendar;
    }

    @Override
    protected IObjectValue createNewData() {
        FactoryCalendarInfo info = new FactoryCalendarInfo();
        info.setName("");
        info.setNumber("");
        info.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return info;
    }

    private void initUI() {
        int i;
        this.menuView.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.btnPreMonths.setEnabled(true);
        this.btnNextMonths.setEnabled(true);
        this.btnEdit.setToolTipText(this.btnEdit.getText());
        this.setButtonDefaultStyl(this.btnEdit);
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top"));
        this.btnPreMonths.setPressedIcon(EASResource.getIcon((String)"imgDate_button_top_1"));
        this.btnPreMonths.setText("");
        this.btnPreMonths.setBorder(this.border);
        this.btnNextMonths.setText("");
        this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down"));
        this.btnNextMonths.setPressedIcon(EASResource.getIcon((String)"imgDate_button_down_1"));
        CheckWeekListener listener = new CheckWeekListener();
        for (i = 0; i < this.weeksBox.length; ++i) {
            this.weeksBox[i].setActionCommand(String.valueOf(this.weeksCommand[i]));
            this.weeksBox[i].addActionListener((ActionListener)listener);
        }
        for (i = 0; i < this.dateTypeLabel.length; ++i) {
            this.dateTypeLabel[i].setBackground(this.dateTypeColor[i]);
            this.dateTypeLabel[i].setBorder(this.border);
        }
        this.pkStartWorkDate.addDataChangeListener((DataChangeListener)this);
        this.pkEndWorkDate.addDataChangeListener((DataChangeListener)this);
        this.kdWorkCalendar.addWorkCalendarEventListener(new KDWorkCalendarEventListener(){

            public void backToDefault(KDWorkCalendarEvent arg0) {
                FactoryCalendarEditUI.this.backToDefault1();
            }
        });
        this.kdWorkCalendar.setActiveDayTypes(new int[]{1, 3});
        this.kdWorkCalendar.setResetToDefaultMenuEnabled(false);
        this.kdWorkCalendar.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FactoryCalendarEditUI.this.totalValidWorkDate();
            }
        });
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.kdWorkCalendar.setOpaque(false);
        this.kDNumberTextFieldValidDay.setEnabled(false);
        this.kDNumberTextFieldValidDay.setHorizontalAlignment(4);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_FactoryCalendar_addNew");
        this.kDButtonDelYear.setPreferredSize(new Dimension(73, 54));
        this.kDButtonDelYear.setMaximumSize(new Dimension(73, 54));
        this.kDButtonDelYear.setMinimumSize(new Dimension(73, 54));
        this.kDButtonDelYear.setSize(new Dimension(73, 54));
    }

    private void backToDefault1() {
        this.initWeekBox();
        this.chkSat.setSelected(true);
        this.chkSun.setSelected(true);
    }

    public void dataChanged(DataChangeEvent event) {
        Calendar cal;
        if (this.isSubmit) {
            return;
        }
        if (!this.isInitEnd) {
            return;
        }
        Object newObj = event.getNewValue();
        if (newObj instanceof java.util.Date) {
            java.util.Date newDate = (java.util.Date)newObj;
            java.util.Date oldDate = (java.util.Date)event.getOldValue();
            cal = Calendar.getInstance();
            cal.setTime(newDate);
            int yyNew = cal.get(1);
            int mmNew = cal.get(2);
            int ddNew = cal.get(5);
            cal.setTime(oldDate);
            int yyOld = cal.get(1);
            int mmOld = cal.get(2);
            int ddOld = cal.get(5);
            if (yyNew == yyOld && mmNew == mmOld && ddNew == ddOld) {
                return;
            }
        }
        if (this.pkStartWorkDate != event.getSource() && this.pkEndWorkDate != event.getSource()) {
            return;
        }
        if (this.pkStartWorkDate.getSqlDate() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"startDateIsNull"));
            this.pkStartWorkDate.setValue(event.getOldValue());
            return;
        }
        if (this.pkEndWorkDate.getSqlDate() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"endDateIsNull"));
            this.pkEndWorkDate.setValue(event.getOldValue());
            return;
        }
        if (!this.isValidDate(this.pkStartWorkDate.getSqlDate(), this.pkEndWorkDate.getSqlDate())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"startDateTooLarge"));
            if (this.pkStartWorkDate == event.getSource()) {
                if (this.isValidDate((java.util.Date)event.getOldValue(), this.pkEndWorkDate.getSqlDate())) {
                    this.pkStartWorkDate.setValue(event.getOldValue());
                } else {
                    this.pkStartWorkDate.setValue((Object)this.pkEndWorkDate.getSqlDate());
                }
            } else if (this.isValidDate(this.pkStartWorkDate.getSqlDate(), (java.util.Date)event.getOldValue())) {
                this.pkEndWorkDate.setValue(event.getOldValue());
            } else {
                this.pkEndWorkDate.setValue((Object)this.pkStartWorkDate.getSqlDate());
            }
            return;
        }
        java.util.Date startDate = this.pkStartWorkDate.getSqlDate();
        if (startDate.getDate() != 1) {
            startDate.setDate(1);
        }
        java.util.Date endDate = this.pkEndWorkDate.getSqlDate();
        cal = Calendar.getInstance();
        cal.setTime(endDate);
        int month = cal.get(2);
        if (month == 11) {
            cal.set(5, 31);
            endDate = cal.getTime();
        } else {
            int yy = cal.get(1);
            cal.set(yy, month + 1, 1);
            cal.roll(6, -1);
            endDate = cal.getTime();
        }
        String strOrgId = null;
        if (this.sltOrgUnitInfo != null) {
            strOrgId = this.sltOrgUnitInfo.getId().toString();
        }
        startDate = FactoryCalendarUtils.clearTime(startDate);
        endDate = FactoryCalendarUtils.clearTime(endDate);
        this.initStartDate = startDate;
        this.initEndDate = endDate;
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            if (strOrgId == null) {
                return;
            }
            FactoryCalendarRuleInfo ruleInfo = (FactoryCalendarRuleInfo)this.hasRule.get(strOrgId);
            FactoryCalendarEntryCollection fCEntryColl = this.genFCEntryCollByDate(this.initStartDate, this.initEndDate);
            this.setEntrysWorkDateType(ruleInfo, this.editData, fCEntryColl);
            this.editData.put("entrys", (Object)fCEntryColl);
        } else if (this.oprtState.equals(OprtState.VIEW) && this.isExist) {
            try {
                FactoryCalendarEntryCollection entrys = this.iFactoryCalendar.getEntrysById(this.editData.getId().toString(), this.initStartDate, this.initEndDate);
                this.editData.put("entrys", (Object)entrys);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.pkStartWorkDate.setValue((Object)this.initStartDate);
        this.pkEndWorkDate.setValue((Object)this.initEndDate);
        this.putData();
    }

    private void putData() {
        this.calCulateFactStarAndEndDate();
        this.viewWorkCalendarByTime(this.factStartDate);
        this.putEditDataToCalendar();
        this.totalValidWorkDate();
        this.putDelYear();
        java.util.Date preMonth = this.preMonth();
        this.setPreMonthBtnStatus(preMonth, false);
        java.util.Date nextMonth = this.nextMonth();
        this.setNextMonthBtnStatus(nextMonth, false);
    }

    private boolean isValidDate(java.util.Date startDate, java.util.Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(startDate);
        int startYear = cl.get(1);
        int startMonth = cl.get(2);
        cl.setTime(endDate);
        int endYear = cl.get(1);
        int endMonth = cl.get(2);
        return startYear <= endYear && (startYear != endYear || startMonth <= endMonth);
    }

    private int checkEditDataChanged() {
        if (this.isEditDataChanged()) {
            String strErr = EASResource.getString((String)this.workCalendarRes, (String)"hadChangeIsSave");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)strErr);
            if (result == 0) {
                this.btnSubmit.doClick();
                return 1;
            }
            if (result == 1) {
                return 2;
            }
            return 3;
        }
        return 4;
    }

    private boolean isEditDataChanged() {
        if (this.oprtState == null || OprtState.VIEW.equals(this.oprtState) || this.oldData == null || this.editData == null) {
            return false;
        }
        this.storeFields();
        return !this.oldData.getEntrys().equals((Object)this.editData.getEntrys());
    }

    private boolean isSameDate(java.util.Date d1, java.util.Date d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(d1);
        int year = cl.get(1);
        int month = cl.get(2);
        int day = cl.get(5);
        cl.setTime(d2);
        return year == cl.get(1) && month == cl.get(2) && day == cl.get(5);
    }

    private FactoryCalendarInfo getWorkCalendarForId(String id, String orgUnitID, java.util.Date startDate, java.util.Date endDate) {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        FactoryCalendarInfo info = null;
        try {
            info = this.iFactoryCalendar.getWorkCalendar(id, startDate, endDate);
        }
        catch (ObjectNotFoundException e) {
            info = null;
        }
        catch (Exception e) {
            this.handleException(e);
            logger.error((Object)e);
            return null;
        }
        return info;
    }

    private void viewSltWorkCalendarForId(String id, String orgUnitID, java.util.Date startDate, java.util.Date endDate) {
        FactoryCalendarInfo info = this.getWorkCalendarForId(id, orgUnitID, startDate, endDate);
        if (info == null) {
            this.hasWorkCalendar = false;
            FactoryCalendarRuleInfo ruleInfo = null;
            if (this.isGen) {
                ruleInfo = this.genRuleInfo;
                info = this.genCalendarByRule(startDate, endDate, ruleInfo);
                this.setOprtState(OprtState.ADDNEW);
                this.oprtStateChanged(OprtState.ADDNEW);
            } else {
                ruleInfo = this.getFactoryCalendarRuleInfo(orgUnitID);
                info = new FactoryCalendarInfo();
            }
            info.setStorageOrgUnit((StorageOrgUnitInfo)this.sltOrgUnitInfo);
            info.setNumber(this.txtNumber.getText());
            info.setName(this.txtName.getText());
            info.setStartDate((java.util.Date)this.pkStartWorkDate.getValue());
            info.setEndDate((java.util.Date)this.pkEndWorkDate.getValue());
            this.setDataObject((IObjectValue)info);
        } else {
            this.hasWorkCalendar = true;
            if (this.isGen) {
                if (info.getEntrys().size() > 0) {
                    int sel = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"CalExistIsClover"));
                    if (sel == 2) {
                        this.sltOrgUnitInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getData();
                        return;
                    }
                    this.setOprtState(OprtState.EDIT);
                    this.oprtStateChanged(OprtState.EDIT);
                } else {
                    this.setOprtState(OprtState.ADDNEW);
                    this.oprtStateChanged(OprtState.ADDNEW);
                }
            }
            this.addNotFactDataEntry(info);
            this.setDataObject((IObjectValue)info);
        }
        this.oldData = (FactoryCalendarInfo)info.clone();
        this.initWorkCalendarCtrl();
        this.putEditDataToCalendar();
        this.loadFields();
        this.totalValidWorkDate();
        this.showMyMessage();
    }

    private void showMyMessage() {
        if (this.hasWorkCalendar) {
            this.setMessageText(EASResource.getString((String)this.workCalendarRes, (String)"hasWorkCalendar"));
        } else {
            this.setMessageText(EASResource.getString((String)this.workCalendarRes, (String)"addNewHint"));
        }
        this.showMessage();
    }

    private void oprtStateChanged(String state) {
        if (OprtState.VIEW.equals(state)) {
            if (this.hasWorkCalendar) {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
                this.prmtstorageOrgUnit.setEnabled(true);
                this.kdWorkCalendar.setEditable(false);
                this.kDComboBoxDelYear.setEnabled(true);
                this.kDButtonDelYear.setEnabled(true);
            } else {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.prmtstorageOrgUnit.setEnabled(true);
                this.kdWorkCalendar.setEditable(true);
            }
            this.actionAddNew.setEnabled(true);
            this.actionSubmit.setEnabled(false);
            this.chkSun.setEnabled(false);
            this.chkMon.setEnabled(false);
            this.chkTue.setEnabled(false);
            this.chkWed.setEnabled(false);
            this.chkThu.setEnabled(false);
            this.chkFri.setEnabled(false);
            this.chkSat.setEnabled(false);
            this.setComponentEditable(false);
            this.pkStartWorkDate.setEnabled(true);
            this.pkEndWorkDate.setEnabled(true);
        } else if (OprtState.ADDNEW.equals(state)) {
            this.actionAddNew.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(true);
            this.chkSun.setEnabled(true);
            this.chkMon.setEnabled(true);
            this.chkTue.setEnabled(true);
            this.chkWed.setEnabled(true);
            this.chkThu.setEnabled(true);
            this.chkFri.setEnabled(true);
            this.chkSat.setEnabled(true);
            this.kdWorkCalendar.setEditable(true);
            this.actionRemove.setEnabled(false);
            this.setComponentEditable(true);
            if (this.isGen) {
                this.prmtstorageOrgUnit.setEnabled(false);
            } else {
                this.prmtstorageOrgUnit.setEnabled(true);
            }
            this.pkStartWorkDate.setEnabled(false);
            this.pkEndWorkDate.setEnabled(false);
            this.kDButtonDelYear.setEnabled(false);
            this.kDComboBoxDelYear.setEnabled(false);
        } else if (OprtState.EDIT.equals(state)) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(true);
            this.chkSun.setEnabled(true);
            this.chkMon.setEnabled(true);
            this.chkTue.setEnabled(true);
            this.chkWed.setEnabled(true);
            this.chkThu.setEnabled(true);
            this.chkFri.setEnabled(true);
            this.chkSat.setEnabled(true);
            this.kdWorkCalendar.setEditable(true);
            this.actionRemove.setEnabled(false);
            this.setComponentEditable(true);
            this.prmtstorageOrgUnit.setEnabled(false);
            this.pkStartWorkDate.setEnabled(false);
            this.pkEndWorkDate.setEnabled(false);
            this.kDButtonDelYear.setEnabled(false);
            this.kDComboBoxDelYear.setEnabled(false);
        }
    }

    private void setComponentEditable(boolean editable) {
        this.pkEndWorkDate.setEditable(editable);
        this.pkStartWorkDate.setEditable(editable);
    }

    protected void inOnload() throws Exception {
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDScrollPane1.getViewport().add((Component)this.kdWorkCalendar, new KDLayout.Constraints(10, 10, 900, 460, 15));
        this.kdWorkCalendar.setBounds(new Rectangle(10, 10, 900, 460));
    }

    private void initWorkCalendarCtrl() {
        this.kdWorkCalendar.clearYearMonth();
        this.kdWorkCalendar.clearSettedDays();
    }

    private void viewWorkCalendarByTime(java.util.Date startDate) {
        this.initWorkCalendarCtrl();
        if (this.editData.getEntrys().size() == 0) {
            this.btnNextMonths.setEnabled(false);
            this.btnPreMonths.setEnabled(false);
            return;
        }
        java.util.Date endDate = this.getBeforOrAfterDate(startDate, this.monthsPerPage - 1);
        if (endDate.after(this.factEndDate)) {
            endDate = this.factEndDate;
        }
        if (!this.isInitEnd) {
            this.kdWorkCalendar.addYearMonth(startDate, this.factEndDate);
        } else if (this.isOrgChange) {
            this.kdWorkCalendar.addYearMonth(startDate, this.factEndDate);
        } else {
            this.kdWorkCalendar.addYearMonth(startDate, endDate);
        }
        this.kdWorkCalendar.setNumberPerRow(this.monthsPerRow);
    }

    private void initWeekBox() {
        for (int i = 0; i < this.weeksBox.length; ++i) {
            this.weeksBox[i].setSelected(false);
        }
    }

    protected void showSubmitSuccess() {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0} {1}");
        String messageText = format.format(new Object[]{EASResource.getString((String)this.workCalendarRes, (String)"workCalendar"), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK")});
        this.setMessageText(messageText);
        this.showMessage();
    }

    public void actionReUse_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(OrgUnitSltUI.class.getName(), this.getOrgUnitUIContext(), null, this.getOprtState());
        window.show();
    }

    private Map getOrgUnitUIContext() {
        if (this.myUIContext != null) {
            return this.myUIContext;
        }
        this.myUIContext = new HashMap();
        this.myUIContext.put("Owner", this.getUIWindow());
        return this.myUIContext;
    }

    @Override
    public void actionPreMonths_actionPerformed(ActionEvent e) throws Exception {
        java.util.Date preMonth = this.preMonth();
        this.setPreMonthBtnStatus(preMonth, true);
        this.calCulateFactStarAndEndDate();
        if (preMonth.before(this.factStartDate)) {
            return;
        }
        this.kdWorkCalendar.clearYearMonth();
        this.kdWorkCalendar.addYearMonth(preMonth, this.getBeforOrAfterDate(preMonth, this.monthsPerPage - 1));
        java.util.Date nextMonth = this.nextMonth();
        this.setNextMonthBtnStatus(nextMonth, false);
    }

    @Override
    public void actionNextMonths_actionPerformed(ActionEvent e) throws Exception {
        java.util.Date nextMonth = this.nextMonth();
        this.setNextMonthBtnStatus(nextMonth, true);
        this.calCulateFactStarAndEndDate();
        if (nextMonth.after(this.factEndDate)) {
            return;
        }
        this.kdWorkCalendar.clearYearMonth();
        java.util.Date d = this.getBeforOrAfterDate(nextMonth, -this.monthsPerPage + 1);
        this.kdWorkCalendar.addYearMonth(d, nextMonth);
        java.util.Date preMonth = this.preMonth();
        this.setPreMonthBtnStatus(preMonth, false);
    }

    private java.util.Date preMonth() {
        List ymList = this.kdWorkCalendar.getYearMonthList();
        java.util.Date minD = null;
        java.util.Date preMonth = null;
        if (ymList != null) {
            java.util.Date d = null;
            for (int i = 0; i < ymList.size(); ++i) {
                d = (java.util.Date)ymList.get(i);
                minD = minD == null ? d : (minD.before(d) ? minD : d);
            }
            preMonth = this.getBeforOrAfterDate(minD, -this.step);
        }
        return preMonth;
    }

    private java.util.Date nextMonth() {
        List ymList = this.kdWorkCalendar.getYearMonthList();
        java.util.Date maxD = null;
        java.util.Date nextMonth = null;
        if (ymList != null) {
            java.util.Date d = null;
            for (int i = 0; i < ymList.size(); ++i) {
                d = (java.util.Date)ymList.get(i);
                maxD = maxD == null ? d : (maxD.after(d) ? maxD : d);
            }
            nextMonth = this.getBeforOrAfterDate(maxD, this.step);
        }
        return nextMonth;
    }

    private void setPreMonthBtnStatus(java.util.Date preMonth, boolean preOperate) {
        if (preMonth == null) {
            return;
        }
        if (this.editData.getEntrys().size() == 0) {
            this.btnPreMonths.setEnabled(false);
            return;
        }
        java.util.Date dStartDate = this.pkStartWorkDate.getSqlDate();
        if (dStartDate == null) {
            dStartDate = this.initStartDate;
        }
        if (preOperate) {
            if (preMonth.getYear() < dStartDate.getYear() || preMonth.getYear() == dStartDate.getYear() && preMonth.getMonth() <= dStartDate.getMonth()) {
                this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top_2"));
                this.btnPreMonths.setEnabled(false);
            } else {
                this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top"));
                this.btnPreMonths.setEnabled(true);
            }
        } else if (preMonth.getYear() < dStartDate.getYear() || preMonth.getYear() == dStartDate.getYear() && preMonth.getMonth() < dStartDate.getMonth()) {
            this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top_2"));
            this.btnPreMonths.setEnabled(false);
        } else {
            this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top"));
            this.btnPreMonths.setEnabled(true);
        }
    }

    private void setNextMonthBtnStatus(java.util.Date nextMonth, boolean nextOpreate) {
        if (this.editData.getEntrys().size() == 0) {
            this.btnNextMonths.setEnabled(false);
            return;
        }
        java.util.Date dEndDate = this.pkEndWorkDate.getSqlDate();
        if (dEndDate == null) {
            dEndDate = this.initEndDate;
        }
        if (nextOpreate) {
            if (nextMonth.getYear() > dEndDate.getYear() || nextMonth.getYear() == dEndDate.getYear() && nextMonth.getMonth() >= dEndDate.getMonth()) {
                this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down_2"));
                this.btnNextMonths.setEnabled(false);
            } else {
                this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down"));
                this.btnNextMonths.setEnabled(true);
            }
        } else if (nextMonth.getYear() > dEndDate.getYear() || nextMonth.getYear() == dEndDate.getYear() && nextMonth.getMonth() > dEndDate.getMonth()) {
            this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down_2"));
            this.btnNextMonths.setEnabled(false);
        } else {
            this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down"));
            this.btnNextMonths.setEnabled(true);
        }
    }

    private java.util.Date getBeforOrAfterDate(java.util.Date d, int pad) {
        if (d == null) {
            d = new java.util.Date();
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        int year = cl.get(1);
        int month = cl.get(2) + pad;
        if (month > 11) {
            month -= 12;
            year = cl.get(1) + 1;
        } else if (month < 0) {
            month = 12 + month;
            year = cl.get(1) - 1;
        }
        cl.set(year, month, 1);
        return cl.getTime();
    }

    public void setSltOrgUnitID(String orgUnitID) {
        this.isReused = true;
        StorageOrgUnitInfo foi = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), null);
        this.editData.setStorageOrgUnit(foi);
        this.setDataObject((IObjectValue)this.editData);
        try {
            super.actionEdit_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.oprtStateChanged(OprtState.EDIT);
    }

    private void putEditDataToCalendar() {
        FactoryCalendarEntryCollection workDays = this.editData.getEntrys();
        if (workDays != null && workDays.size() >= 0) {
            for (int i = 0; i < workDays.size(); ++i) {
                FactoryCalendarEntryInfo info = workDays.get(i);
                this.kdWorkCalendar.setDayType(info.getWorkDate(), info.getDateType().getValue());
            }
        }
    }

    private void putCalendarToEditData() {
        Map workDays = this.kdWorkCalendar.getSettedDays();
        FactoryCalendarEntryCollection days = this.editData.getEntrys();
        Calendar cl = Calendar.getInstance();
        if (workDays != null && workDays.size() > 0) {
            Set keys = workDays.keySet();
            for (KingdeeWorkCalendarUI.CustomDate d : keys) {
                KingdeeWorkCalendarUI.DayType dt = (KingdeeWorkCalendarUI.DayType)workDays.get(d);
                cl.set(d.getYear(), d.getMonth(), d.getDate());
                java.util.Date date = cl.getTime();
                FactoryCalendarUtils.setDateTypeByFCalendarEntry(date, dt.getType(), days);
            }
        }
        this.editData.put("entrys", (Object)days);
    }

    private boolean isSameDayType(Calendar cl, int type) {
        int iweek = cl.get(7);
        return (iweek == 7 || iweek == 1) && type == 2 || iweek != 7 && iweek != 1 && type == 1;
    }

    private void putWeeksBoxToEditData() {
        String value = "";
        for (int i = 0; i < this.weeksBox.length; ++i) {
            if (!this.weeksBox[i].isSelected()) continue;
            value = value + "!" + this.weeksBox[i].getActionCommand();
        }
    }

    private void putEditaDatToWeeksBox() {
        this.initWeekBox();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (!this.isValidDate(this.pkStartWorkDate.getSqlDate(), this.pkEndWorkDate.getSqlDate())) {
            this.pkStartWorkDate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"startDateTooLarge"));
            this.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isDefault"));
        sic.add(new SelectorItemInfo("storageOrgUnit"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("defaultWeekend"));
        sic.add(new SelectorItemInfo("entrys.workDate"));
        sic.add(new SelectorItemInfo("entrys.dateType"));
        return sic;
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuEdit);
        this.menuBar.add((JMenu)this.menuView);
        this.menuBar.add((JMenu)this.menuBiz);
        this.menuBar.add((JMenu)this.menuTool);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((JMenuItem)this.menuItemAddNew);
        this.menuFile.addSeparator("kDSeparator3");
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuEdit.add((JMenuItem)this.menuItemEdit);
        this.menuEdit.add((JMenuItem)this.menuItemSubmit);
        this.menuEdit.add((JMenuItem)this.menuItemRemove);
        this.menuBiz.add((JMenuItem)this.menuItemDefault);
        this.menuTool.add((JMenuItem)this.menuItemSendMessage);
        this.menuTool.add((JMenuItem)this.menuItemCalculator);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemRegPro);
        this.menuHelp.add((Component)this.kDSeparatorProduct);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
        this.menuHelp.add((JMenuItem)this.menuItemPersonalSite);
        this.menuHelp.add((Component)this.helpseparatorDiv);
        this.menuHelp.add((JMenuItem)this.menuitemProductval);
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnAddNew);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnSubmit);
        this.toolBar.add((Component)this.btnRemove);
        this.toolBar.add((Component)this.btnSetDefault);
    }

    public boolean isModify() {
        return this.isEditDataChanged();
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"Storage");
    }

    @Override
    protected void storageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isInitEnd) {
            return;
        }
        StorageOrgUnitInfo stInfo = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getData();
        String strNewId = "";
        String strOidId = "";
        if (stInfo != null && stInfo.getId() != null) {
            strNewId = stInfo.getId().toString();
        }
        if (this.sltOrgUnitInfo != null && this.sltOrgUnitInfo.getId() != null) {
            strOidId = this.sltOrgUnitInfo.getId().toString();
        }
        if (!strNewId.equals(strOidId) && this.getOprtState() == "ADDNEW") {
            this.sltOrgUnitInfo = stInfo;
            this.isOrgChange = true;
            this.initDate();
            Date startDate = this.pkStartWorkDate.getSqlDate();
            Date endDate = this.pkEndWorkDate.getSqlDate();
            this.viewSltWorkCalendarForId(null, strNewId, startDate, endDate);
            this.isOrgChange = false;
        }
    }

    public void onLoad() throws Exception {
        this.initDate();
        super.onLoad();
        String strPerssion = "mm_FactoryCalendar_addNew";
        String storageid = null;
        if (this.oprtState == null || this.oprtState.equals(OprtState.ADDNEW)) {
            this.sltOrgUnitInfo = MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)strPerssion);
        }
        if (this.sltOrgUnitInfo != null) {
            storageid = this.sltOrgUnitInfo.getId().toString();
        }
        String id = (String)this.getUIContext().get("ID");
        this.viewSltWorkCalendarForId(id, storageid, this.initStartDate, this.initEndDate);
        if (this.sltOrgUnitInfo == null) {
            this.sltOrgUnitInfo = this.editData.getStorageOrgUnit();
        }
        this.isInitEnd = true;
    }

    public void resetUI() throws Exception {
        this.initDate();
        String strPerssion = "mm_FactoryCalendar_addNew";
        if (this.sltOrgUnitInfo == null) {
            this.sltOrgUnitInfo = MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)strPerssion);
        }
        if (this.sltOrgUnitInfo != null) {
            String id = (String)this.getUIContext().get("ID");
            this.viewSltWorkCalendarForId(id, this.sltOrgUnitInfo.getId().toString(), this.initStartDate, this.initEndDate);
        }
        this.isInitEnd = true;
    }

    private void initDate() {
        Calendar cl = Calendar.getInstance();
        if (this.genYear == 1900) {
            cl.set(cl.get(1), cl.get(2), 1);
            this.initStartDate = cl.getTime();
            int month = 1;
            int year = 2008;
            if (cl.get(2) == 0) {
                month = 11;
                year = cl.get(1);
            } else {
                month = cl.get(2) - 1;
                year = cl.get(1) + 1;
            }
            cl.set(year, month, 1);
            cl.set(year, month, cl.getActualMaximum(5));
            this.initEndDate = cl.getTime();
        } else {
            cl.set(this.genYear, 0, 1);
            this.initStartDate = cl.getTime();
            cl.set(this.genYear, 11, 31);
            this.initEndDate = cl.getTime();
        }
        this.initStartDate = FactoryCalendarUtils.clearTime(this.initStartDate);
        this.initEndDate = FactoryCalendarUtils.clearTime(this.initEndDate);
        this.pkStartWorkDate.setValue((Object)this.initStartDate);
        this.pkEndWorkDate.setValue((Object)this.initEndDate);
    }

    private FactoryCalendarInfo genCalendarByRule(java.util.Date startDate, java.util.Date endDate, FactoryCalendarRuleInfo ruleInfo) {
        if (startDate == null || endDate == null) {
            return null;
        }
        if (startDate.after(endDate)) {
            return null;
        }
        FactoryCalendarInfo cInfo = (FactoryCalendarInfo)this.createNewData();
        FactoryCalendarEntryCollection fCEntryColl = this.genFCEntryCollByDate(startDate, endDate);
        this.setEntrysWorkDateType(ruleInfo, cInfo, fCEntryColl);
        cInfo.put("entrys", (Object)fCEntryColl);
        return cInfo;
    }

    private void setEntrysWorkDateType(FactoryCalendarRuleInfo ruleInfo, FactoryCalendarInfo cInfo, FactoryCalendarEntryCollection fCEntryColl) {
        if (ruleInfo != null) {
            FactoryCalendarRuleEntryCollection ruleEntryColl = ruleInfo.getEntrys();
            if (ruleEntryColl.size() > 0) {
                Iterator itEntry = ruleEntryColl.iterator();
                while (itEntry.hasNext()) {
                    FactoryCalendarRuleEntryInfo ruleEntryInfo = (FactoryCalendarRuleEntryInfo)itEntry.next();
                    this.setWorkDateType(ruleEntryInfo, fCEntryColl);
                }
            }
        } else {
            this.setWorkDateType(null, fCEntryColl);
        }
    }

    private FactoryCalendarEntryCollection genFCEntryCollByDate(java.util.Date startDate, java.util.Date endDate) {
        FactoryCalendarEntryCollection fCEntryColl = new FactoryCalendarEntryCollection();
        if (startDate.before(endDate)) {
            FactoryCalendarEntryInfo entryInfo;
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            int seq = 1;
            while (startDate.before(endDate)) {
                entryInfo = new FactoryCalendarEntryInfo();
                entryInfo.setWorkDate(cal.getTime());
                entryInfo.setDateType(WorkDateTypeEnum.WORKDAY);
                entryInfo.setSeq(seq++);
                fCEntryColl.add(entryInfo);
                int month = cal.get(2);
                int day = cal.get(5);
                if (month == 11 && day == 31) {
                    int year = cal.get(1) + 1;
                    cal.set(year, 0, 1);
                } else {
                    cal.roll(6, 1);
                }
                startDate = cal.getTime();
            }
            entryInfo = new FactoryCalendarEntryInfo();
            entryInfo.setWorkDate(cal.getTime());
            entryInfo.setDateType(WorkDateTypeEnum.WORKDAY);
            entryInfo.setSeq(seq++);
            fCEntryColl.add(entryInfo);
        }
        return fCEntryColl;
    }

    private void setWorkDateType(FactoryCalendarRuleEntryInfo ruleEntryInfo, FactoryCalendarEntryCollection fCEntryColl) {
        if (ruleEntryInfo == null) {
            for (int i = 0; i < fCEntryColl.size(); ++i) {
                FactoryCalendarEntryInfo entryInfo = fCEntryColl.get(i);
                Calendar cal = Calendar.getInstance();
                cal.setTime(entryInfo.getWorkDate());
                int weekOfDay = cal.get(7);
                if (7 != weekOfDay && 1 != weekOfDay) continue;
                entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
            }
        } else {
            int monthRule = ruleEntryInfo.getMonth();
            int dayRule = ruleEntryInfo.getDay();
            int seriesDay = ruleEntryInfo.getSeriesDays() - 1;
            switch (ruleEntryInfo.getCycSign().getValue()) {
                case 40: {
                    for (int i = 0; i < fCEntryColl.size(); ++i) {
                        FactoryCalendarEntryInfo entryInfo = fCEntryColl.get(i);
                        FactoryCalendarUtils.setFCEInfoWorkDateType(monthRule, dayRule, seriesDay, entryInfo, fCEntryColl);
                    }
                    break;
                }
                case 20: {
                    for (int i = 0; i < fCEntryColl.size(); ++i) {
                        FactoryCalendarEntryInfo entryInfo = fCEntryColl.get(i);
                        FactoryCalendarUtils.setFCEInfoWorkDateType(monthRule, dayRule, seriesDay, entryInfo, fCEntryColl);
                    }
                    break;
                }
                case 30: {
                    FactoryCalendarEntryCollection sFCCntryColl = FactoryCalendarUtils.getFCEntrysBySean(monthRule, dayRule, fCEntryColl);
                    for (int i = 0; i < sFCCntryColl.size(); ++i) {
                        FactoryCalendarEntryInfo entryInfo = sFCCntryColl.get(i);
                        entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                        int seq = entryInfo.getSeq();
                        FactoryCalendarUtils.setSeriesDayWorkDateType(seq, seriesDay, fCEntryColl);
                    }
                    break;
                }
                case 10: {
                    FactoryCalendarEntryCollection sFCCntryColl = FactoryCalendarUtils.getFCEntrysByWeek(monthRule, dayRule, fCEntryColl);
                    for (int i = 0; i < sFCCntryColl.size(); ++i) {
                        FactoryCalendarEntryInfo entryInfo = sFCCntryColl.get(i);
                        entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                        int seq = entryInfo.getSeq();
                        FactoryCalendarUtils.setSeriesDayWorkDateType(seq, seriesDay, fCEntryColl);
                    }
                    break;
                }
            }
        }
    }

    private FactoryCalendarRuleInfo getFactoryCalendarRuleInfo(String strStorageOrgId) {
        FactoryCalendarRuleInfo ruleInfo = null;
        if (strStorageOrgId == null) {
            return ruleInfo;
        }
        if (this.hasRule.containsKey(strStorageOrgId)) {
            ruleInfo = (FactoryCalendarRuleInfo)this.hasRule.get(strStorageOrgId);
        } else if (this.hasRule.containsKey(strStorageOrgId)) {
            ruleInfo = (FactoryCalendarRuleInfo)this.hasRule.get(strStorageOrgId);
        } else {
            try {
                FactoryCalendarRuleCollection factoryCalendarCollection = this.iFactoryCalendarRule.getValueByStorageOrgUnit(strStorageOrgId);
                if (factoryCalendarCollection.size() > 0) {
                    ruleInfo = factoryCalendarCollection.get(0);
                    this.hasRule.put(strStorageOrgId, ruleInfo);
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return ruleInfo;
    }

    public void totalValidWorkDate() {
        Map daysMap = this.kdWorkCalendar.getSettedDays();
        int count = 0;
        for (KingdeeWorkCalendarUI.DayType dayType : daysMap.values()) {
            if (dayType.getType() != 1) continue;
            ++count;
        }
        this.kDNumberTextFieldValidDay.setValue((Object)new Integer(count));
    }

    private FactoryCalendarInfo getFactoryCalendarByOrgUnitId(String orgUnitId) {
        FactoryCalendarInfo fcInfo = null;
        if (orgUnitId == null) {
            return null;
        }
        FactoryCalendarCollection factoryCalendarCollection = new FactoryCalendarCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        try {
            factoryCalendarCollection = this.iFactoryCalendar.getFactoryCalendarCollection(entityViewInfo);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (factoryCalendarCollection.size() > 0) {
            fcInfo = factoryCalendarCollection.get(0);
        }
        return fcInfo;
    }

    @Override
    public void actionSetRule_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", SysContext.getSysContext().getCurrentUser());
        uiContext.put((Object)"openModel", (Object)"frame");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FactoryCalendarRuleEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        FactoryCalendarRuleEditUI ruleUi = (FactoryCalendarRuleEditUI)uiWindow.getUIObject();
        Integer yy = (Integer)ruleUi.getUIContext().get("YEAR");
        if (yy == null) {
            return;
        }
        this.genYear = yy;
        this.sltOrgUnitInfo = (StorageOrgUnitInfo)ruleUi.getUIContext().get("STORAGEORGUNIT");
        this.genRuleInfo = (FactoryCalendarRuleInfo)ruleUi.getUIContext().get("RULE");
        Object strOrgId = null;
        if (this.sltOrgUnitInfo != null && !this.hasRule.containsKey(strOrgId)) {
            this.hasRule.put(strOrgId, this.sltOrgUnitInfo);
        }
        this.editData = null;
        this.isInitEnd = false;
        this.isGen = true;
        this.resetUI();
        this.isGen = false;
        this.genRuleInfo = null;
    }

    @Override
    public void actonDelYear_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.kDComboBoxDelYear.getSelectedItem();
        int year = 0;
        if (obj != null) {
            year = (Integer)obj;
            this.delEntrys(year);
        }
    }

    private void calCulateFactStarAndEndDate() {
        if (this.editData != null && this.editData.getEntrys().size() > 0) {
            FactoryCalendarEntryCollection entrys = this.editData.getEntrys();
            int size = entrys.size();
            FactoryCalendarEntryInfo entryInfo = entrys.get(0);
            this.factStartDate = entryInfo.getWorkDate();
            entryInfo = entrys.get(size - 1);
            this.factEndDate = entryInfo.getWorkDate();
        } else {
            this.factStartDate = this.initStartDate;
            this.factEndDate = this.initEndDate;
        }
    }

    private void addNotFactDataEntry(FactoryCalendarInfo info) {
        FactoryCalendarEntryCollection fCEntryColl;
        int size;
        FactoryCalendarEntryCollection entrys;
        if (info == null) {
            return;
        }
        String strOrgId = null;
        if (info.getStorageOrgUnit() != null) {
            strOrgId = info.getStorageOrgUnit().getId().toString();
        }
        FactoryCalendarRuleInfo ruleInfo = null;
        if (this.isGen) {
            ruleInfo = this.genRuleInfo;
            entrys = info.getEntrys();
            size = entrys.size();
            if (size > 0) {
                FactoryCalendarUtils.reGenEntrySeq(entrys);
                FactoryCalendarUtils.setWorkDateType(WorkDateTypeEnum.WORKDAY, entrys);
                this.setEntrysWorkDateType(ruleInfo, info, entrys);
            } else {
                fCEntryColl = this.genFCEntryCollByDate(this.initStartDate, this.initEndDate);
                this.setEntrysWorkDateType(ruleInfo, info, fCEntryColl);
                info.put("entrys", (Object)fCEntryColl);
            }
        } else {
            ruleInfo = this.getFactoryCalendarRuleInfo(strOrgId);
        }
        if (this.oprtState == null) {
            entrys = info.getEntrys();
            size = entrys.size();
            if (size == 0) {
                this.isExist = false;
                fCEntryColl = this.genFCEntryCollByDate(this.initStartDate, this.initEndDate);
                this.setEntrysWorkDateType(ruleInfo, info, fCEntryColl);
                info.put("entrys", (Object)fCEntryColl);
            }
            this.factStartDate = this.initStartDate;
            this.factEndDate = this.initEndDate;
            return;
        }
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            entrys = info.getEntrys();
            size = entrys.size();
            if (size > 0) {
                this.isExist = true;
                FactoryCalendarEntryInfo enInfo = entrys.get(0);
                java.util.Date startDate = enInfo.getWorkDate();
                enInfo = entrys.get(size - 1);
                java.util.Date endDate = enInfo.getWorkDate();
                startDate = FactoryCalendarUtils.clearTime(startDate);
                endDate = FactoryCalendarUtils.clearTime(endDate);
                if (startDate.after(this.initStartDate)) {
                    FactoryCalendarEntryCollection fCEntryColl2 = this.genFCEntryCollByDate(this.initStartDate, startDate);
                    size = fCEntryColl2.size();
                    for (int i = 0; i < size - 1; ++i) {
                        FactoryCalendarEntryInfo entryInfo = fCEntryColl2.get(i);
                        entrys.insertObject(i, (IObjectValue)entryInfo);
                    }
                } else if (endDate.before(this.initEndDate)) {
                    FactoryCalendarEntryCollection fCEntryColl3 = this.genFCEntryCollByDate(endDate, this.initEndDate);
                    size = fCEntryColl3.size();
                    for (int i = 1; i < size; ++i) {
                        FactoryCalendarEntryInfo entryInfo = fCEntryColl3.get(i);
                        entrys.add(entryInfo);
                    }
                }
                FactoryCalendarUtils.reGenEntrySeq(entrys);
                FactoryCalendarUtils.setWorkDateType(WorkDateTypeEnum.WORKDAY, entrys);
                this.setEntrysWorkDateType(ruleInfo, info, entrys);
            } else {
                fCEntryColl = this.genFCEntryCollByDate(this.initStartDate, this.initEndDate);
                this.setEntrysWorkDateType(ruleInfo, info, fCEntryColl);
                info.put("entrys", (Object)fCEntryColl);
            }
        }
    }

    private void putDelYear() {
        if (this.factStartDate != null) {
            Calendar cal = Calendar.getInstance();
            int currYear = cal.get(1);
            cal.setTime(this.factStartDate);
            int yy = cal.get(1);
            Vector<Integer> vecList = new Vector<Integer>(10);
            while (yy < currYear) {
                vecList.add(new Integer(yy++));
            }
            this.kDComboBoxDelYear.setModel(new DefaultComboBoxModel(vecList));
        }
    }

    private void delEntrys(int year) {
        String orgUnitId = null;
        if (this.editData.getStorageOrgUnit() != null) {
            orgUnitId = this.editData.getStorageOrgUnit().getId().toString();
        }
        try {
            this.iFactoryCalendar.delEntrysByYear(this.editData.getId().toString(), orgUnitId, year);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        FactoryCalendarEntryCollection entrys = this.editData.getEntrys();
        int size = entrys.size();
        Calendar cal = Calendar.getInstance();
        for (int i = size - 1; i >= 0; --i) {
            FactoryCalendarEntryInfo entryInfo = entrys.get(i);
            cal.setTime(entryInfo.getWorkDate());
            int yy = cal.get(1);
            if (yy > year) continue;
            entrys.removeObject(i);
        }
        this.putData();
    }

    protected void initWorkButton() {
        if (this.isGen) {
            return;
        }
        super.initWorkButton();
        this.btnSetRule.setEnabled(true);
        this.btnSetRule.setIcon(EASResource.getIcon((String)"imgTbtn_rulesetting"));
        this.getUIToolBar().add((Component)this.separatorFW1);
        this.getUIToolBar().add((Component)this.btnSetRule);
        this.kDMenuItemSetRule.setIcon(EASResource.getIcon((String)"imgTbtn_rulesetting"));
        this.kDMenuItemSetRule.setEnabled(true);
        this.actionSetRule.setEnabled(true);
        this.menuEdit.add((JMenuItem)this.kDMenuItemSetRule);
        this.btnSetDefault.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemDefault.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
    }

    protected void afterSubmitEdit(IObjectPK pk) {
        if (this.editData.getId() == null) {
            this.editData.setId(BOSUuid.read((String)pk.toString()));
        }
        this.setOprtState(OprtState.EDIT);
    }

    @Override
    protected void removeByPK(IObjectPK pk) throws Exception {
        super.removeByPK(pk);
        this.isDelOk = true;
    }

    public void validateBeforeSubmit() {
        String number = this.txtNumber.getText();
        if (number == null || number.trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.workCalendarRes, (String)"numberIsNotNull"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        try {
            FactoryCalendarCollection factoryEntryColl = FactoryCalendarFactory.getRemoteInstance().getFactoryCalendarCollection("Where storageOrgUnit.id = '" + this.sltOrgUnitInfo.getId().toString() + "' and number = '" + number + "'");
            if (factoryEntryColl.size() > 0) {
                for (int i = 0; i < factoryEntryColl.size(); ++i) {
                    if (factoryEntryColl.get(i).getId().toString().equals(this.editData.getId() == null ? "" : this.editData.getId().toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)this.workCalendarRes, (String)"repeatNumber"));
                    this.txtNumber.requestFocus();
                    SysUtil.abort();
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    @Override
    public void actionSetDefault_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsDefault()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"isDefault"));
            SysUtil.abort();
        }
        this.editData.setIsDefault(true);
        this.kDIsDefault.setSelected(this.editData.isIsDefault());
        FactoryCalendarFactory.getRemoteInstance().setFactoryCalendar(this.editData);
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        IObjectValue object = (IObjectValue)this.getUIContext().get("InitDataObject");
        this.kDIsDefault.setSelected(object.getBoolean("isDefault"));
    }

    private class CheckWeekListener
    implements ActionListener {
        private CheckWeekListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof KDCheckBox) {
                String comm = e.getActionCommand();
                for (int i = 0; i < FactoryCalendarEditUI.this.weeksCommand.length; ++i) {
                    if (FactoryCalendarEditUI.this.weeksCommand[i] != Integer.parseInt(e.getActionCommand())) continue;
                    ArrayList<java.util.Date> d = new ArrayList<java.util.Date>();
                    Calendar cl = Calendar.getInstance();
                    java.util.Date endDate = FactoryCalendarEditUI.this.pkEndWorkDate.getSqlDate();
                    cl.setTime(endDate);
                    cl.set(cl.get(1), cl.get(2), cl.getActualMaximum(5));
                    endDate = cl.getTime();
                    java.util.Date startDate = FactoryCalendarEditUI.this.pkStartWorkDate.getSqlDate();
                    cl.setTime(startDate);
                    cl.set(cl.get(1), cl.get(2), 1);
                    startDate = cl.getTime();
                    while (FactoryCalendarEditUI.this.isValidDate(cl.getTime(), endDate)) {
                        int dw = cl.get(7);
                        if (dw == FactoryCalendarEditUI.this.weeksCommand[i]) {
                            d.add(cl.getTime());
                            cl.add(5, 7);
                            continue;
                        }
                        cl.add(5, 1);
                    }
                    KDCheckBox tmp = (KDCheckBox)e.getSource();
                    if (tmp.isSelected()) {
                        FactoryCalendarEditUI.this.kdWorkCalendar.setDayType(d.toArray(new java.util.Date[0]), 3);
                    } else {
                        FactoryCalendarEditUI.this.kdWorkCalendar.setDayType(d.toArray(new java.util.Date[0]), 1);
                    }
                    FactoryCalendarEditUI.this.totalValidWorkDate();
                    FactoryCalendarEditUI.this.kdWorkCalendar.repaint();
                    break;
                }
            }
        }
    }

    private class DateType {
        private java.util.Date date = null;
        private int dateType = 1;

        private DateType() {
        }

        public void setDate(java.util.Date d) {
            this.date = d;
        }

        public java.util.Date getDate() {
            return this.date;
        }

        public void setDateType(int type) {
            this.dateType = type;
        }

        public int getDateType() {
            return this.dateType;
        }
    }
}

