/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.mm.basedata.BOMExtendFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMSearchFlagEnum;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomGroupstandardInfo;
import com.kingdee.eas.mm.basedata.BomTreeCollection;
import com.kingdee.eas.mm.basedata.BomTreeCondition;
import com.kingdee.eas.mm.basedata.BomTreeInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.LNBomTreeNodeCtrl;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class LNBom4QueryTreeNodeCtrl
extends LNBomTreeNodeCtrl {
    private Date queryDate = null;
    private BOMSearchFlagEnum queryType = null;
    protected MaterialInfo[] materialInfoArray = null;
    protected Object[] bomGroupstandardInfoArray = null;
    protected BomTreeCondition treeCondition = null;

    public BOMSearchFlagEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(BOMSearchFlagEnum queryType) {
        this.queryType = queryType;
    }

    public LNBom4QueryTreeNodeCtrl(StorageOrgUnitInfo storageOrgUnitInfo, MaterialInfo materialInfo, String bomNumber, BOMUsageEnum bomUsage, Date queryDate, BOMSearchFlagEnum queryType) {
        super(storageOrgUnitInfo, materialInfo, bomNumber, bomUsage);
        this.queryDate = queryDate;
        this.queryType = queryType;
    }

    public LNBom4QueryTreeNodeCtrl(StorageOrgUnitInfo storageOrgUnitInfo, MaterialInfo materialInfo, String bomNumber, BOMUsageEnum bomUsage, Date queryDate, BOMSearchFlagEnum queryType, BOMTypeEnum bomType, boolean bflag, ProjectInfo pprjno, TrackNumberInfo ptrackno, BomTreeCondition condition) {
        super(storageOrgUnitInfo, materialInfo, bomNumber, bomUsage, bomType, bflag, pprjno, ptrackno);
        this.queryDate = queryDate;
        this.queryType = queryType;
        this.treeCondition = condition;
    }

    public LNBom4QueryTreeNodeCtrl(StorageOrgUnitInfo souQuery, MaterialInfo[] miQuery, String bomNumberQuery, BOMUsageEnum bueQuery, Date queryDate, BOMSearchFlagEnum queryType, BomTreeCondition condition) {
        super(souQuery, miQuery[0], bomNumberQuery, bueQuery);
        this.materialInfoArray = miQuery;
        this.queryDate = queryDate;
        this.queryType = queryType;
        this.treeCondition = condition;
    }

    public LNBom4QueryTreeNodeCtrl(StorageOrgUnitInfo souQuery, MaterialInfo[] miQuery, Object[] bgQuery, String bomNumberQuery, BOMUsageEnum bueQuery, Date queryDate, BOMSearchFlagEnum queryType, BomTreeCondition condition) {
        super(souQuery, miQuery[0], bomNumberQuery, bueQuery);
        this.materialInfoArray = miQuery;
        this.queryDate = queryDate;
        this.queryType = queryType;
        this.bomGroupstandardInfoArray = bgQuery;
        this.treeCondition = condition;
    }

    @Override
    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level, FilterInfo filter, SelectorItemCollection selector) throws Exception {
        BomTreeCollection result = new BomTreeCollection();
        if (null == parentNodeInfo) {
            int i;
            BomTreeCondition condition = new BomTreeCondition();
            condition.setStorageOrgUnitID(null == this.storageOrgUnitInfo ? null : this.storageOrgUnitInfo.getId().toString());
            if (this.materialInfoArray != null && this.materialInfoArray.length > 0 && this.materialInfoArray[0] != null) {
                StringBuffer materialStr = new StringBuffer();
                HashSet<String> materialIdSet = new HashSet<String>();
                materialStr.append("(");
                for (i = 0; i < this.materialInfoArray.length; ++i) {
                    materialIdSet.add(this.materialInfoArray[i].getId().toString());
                    if (i == this.materialInfoArray.length - 1) {
                        materialStr.append("'" + this.materialInfoArray[i].getId().toString() + "'");
                        continue;
                    }
                    materialStr.append("'" + this.materialInfoArray[i].getId().toString() + "',");
                }
                materialStr.append(")");
                condition.setMultMaterialIDs(materialStr.toString());
                condition.setMultMaterialIDSet(materialIdSet);
                condition.setMultiTree(true);
            } else {
                condition.setMaterialID(null == this.materialInfo ? null : this.materialInfo.getId().toString());
            }
            HashSet<String> bomGroupIdSet = null;
            if (this.bomGroupstandardInfoArray != null && this.bomGroupstandardInfoArray.length > 1 && this.bomGroupstandardInfoArray[0] != null) {
                StringBuffer bomGroupStr = new StringBuffer();
                bomGroupIdSet = new HashSet<String>();
                bomGroupStr.append("(");
                for (i = 0; i < this.bomGroupstandardInfoArray.length; ++i) {
                    bomGroupIdSet.add(((BomGroupstandardInfo)this.bomGroupstandardInfoArray[i]).getId().toString());
                    if (i == this.bomGroupstandardInfoArray.length - 1) {
                        bomGroupStr.append("'" + ((BomGroupstandardInfo)this.bomGroupstandardInfoArray[i]).getId().toString() + "'");
                        continue;
                    }
                    bomGroupStr.append("'" + ((BomGroupstandardInfo)this.bomGroupstandardInfoArray[i]).getId().toString() + "',");
                }
                bomGroupStr.append(")");
                condition.setBomGroupId(bomGroupStr.toString());
            } else if (this.bomGroupstandardInfoArray != null && this.bomGroupstandardInfoArray.length == 1 && this.bomGroupstandardInfoArray[0] != null) {
                condition.setBomGroupId(((BomGroupstandardInfo)this.bomGroupstandardInfoArray[0]).getId().toString());
                bomGroupIdSet = new HashSet();
                bomGroupIdSet.add(((BomGroupstandardInfo)this.bomGroupstandardInfoArray[0]).getId().toString());
            } else {
                condition.setBomGroupId(null);
            }
            condition.setBomGroupIdSet(bomGroupIdSet);
            condition.setBomUsage(this.bomUsage);
            condition.setBomID(this.bomNumber);
            condition.setLevel(1);
            condition.setId4Tree(null);
            condition.setFlag(true);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setSearchType(this.queryType);
            condition.setBorderflag(this.bflag);
            condition.setProjectNumID(null == this.pprjectinfo ? null : this.pprjectinfo.getId().toString());
            condition.setTrackNumID(null == this.ptrackinfo ? null : this.ptrackinfo.getId().toString());
            condition.setBomExtendFilterInfo(this.treeCondition.getBomExtendFilterInfo());
            condition.setBomtype(this.treeCondition.getBomtype());
            condition.setProjectNumIDs(this.treeCondition.getProjectNumIDs());
            condition.setProjectIdSet(this.treeCondition.getProjectIdSet());
            IRowSet rowSet = BOMExtendFacadeFactory.getRemoteInstance().bomExtend4MultiTree(condition);
            result = this.getNodeCollection(rowSet, null);
        }
        return result;
    }

    @Override
    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level) throws Exception {
        BomTreeCollection result = new BomTreeCollection();
        if (parentNodeInfo == null) {
            return result;
        }
        BomTreeInfo tmpBti = (BomTreeInfo)parentNodeInfo;
        BomTreeCondition condition = new BomTreeCondition();
        condition.setStorageOrgUnitID(tmpBti.getStorageOrgUnitInfo().getId().toString());
        condition.setMaterialID(tmpBti.getMaterialInfo().getId().toString());
        condition.setBomUsage(tmpBti.getBomUsage());
        condition.setBomID(tmpBti.getBomID());
        condition.setLevel(tmpBti.getLevel());
        condition.setId4Tree(tmpBti.getId4Tree());
        condition.setLongNumber(tmpBti.getLongNumber());
        condition.setOnlyAuditStatus(true);
        condition.setQueryDate(this.queryDate);
        condition.setQueryType(this.queryType);
        condition.setFlag(true);
        condition.setBorderflag(this.bflag);
        condition.setProjectNumID(this.treeCondition.getProjectNumID());
        condition.setTrackNumID(this.treeCondition.getTrackNumID());
        condition.setBomtype(tmpBti.getBomType());
        condition.setSerchMFGBOM(this.treeCondition.isSerchMFGBOM());
        String projectNumber = "";
        HashSet<String> pSet = null;
        if (tmpBti.getProject() != null) {
            projectNumber = projectNumber + "(";
            projectNumber = projectNumber + tmpBti.getProject().getNumber();
            projectNumber = projectNumber + ")";
            pSet = new HashSet<String>();
            pSet.add(tmpBti.getProject().getId().toString());
        }
        condition.setProjectNumIDs(projectNumber);
        condition.setProjectIdSet(pSet);
        condition.setParentNode(parentNodeInfo);
        IRowSet rowSet = BOMExtendFacadeFactory.getRemoteInstance().bomExtend4MultiTree(condition);
        result = this.getNodeCollection(rowSet, tmpBti.getLongNumber());
        return result;
    }

    private AbstractObjectCollection getNodeCollection(IRowSet rowSet, String parentLongNumber) throws SQLException {
        BomTreeCollection result = new BomTreeCollection();
        BomTreeInfo bti = null;
        String tmp = "";
        int usageType = 0;
        BOMUsageEnum bue = null;
        ProjectInfo pInfo = null;
        TrackNumberInfo trackInfo = null;
        HashMap<String, String> longNumberMap = new HashMap<String, String>();
        String parentId = null;
        String longNumber = null;
        while (null != rowSet && rowSet.next()) {
            bti = new BomTreeInfo();
            bti.setStorageOrgUnitInfo(new StorageOrgUnitInfo());
            bti.getStorageOrgUnitInfo().setId(this.storageOrgUnitInfo.getId());
            bti.setMaterialInfo(new MaterialInfo());
            bti.getMaterialInfo().setId(BOSUuid.read((String)rowSet.getString("MATERIALID")));
            bti.setBomID(rowSet.getString("BOMID"));
            usageType = rowSet.getInt("USAGETYPE");
            bue = BOMUsageEnum.getEnum(usageType);
            if (null == bue) {
                bti.setBomUsage(BOMUsageEnum.NULL);
            } else {
                bti.setBomUsage(bue);
            }
            bti.setId4Tree(rowSet.getString("FID"));
            bti.setLevel(rowSet.getInt("FLEVEL"));
            parentId = rowSet.getString("fparentId");
            longNumber = this.getLongNumber(rowSet);
            if (longNumberMap.containsKey(parentId)) {
                longNumber = (String)longNumberMap.get(parentId) + longNumber;
            } else {
                if (MMUtils.isEmptyString((String)parentLongNumber)) {
                    parentLongNumber = "";
                }
                longNumber = parentLongNumber + longNumber;
            }
            bti.setLongNumber(longNumber);
            longNumberMap.put(rowSet.getString("FID"), longNumber);
            if (rowSet.getString("BOMID") == null) {
                bti.setIsLeaf(true);
            } else {
                bti.setIsLeaf(false);
            }
            bti.setBomGroupID(rowSet.getString("BOMGROUPID"));
            tmp = rowSet.getString("BOMNUMBER");
            bti.setBomType(BOMTypeEnum.getEnum(rowSet.getInt("BOMTYPE")));
            tmp = null == tmp ? "" : "&" + tmp;
            if (rowSet.getString("ProjectNumber") != null) {
                tmp = tmp + "&" + rowSet.getString("ProjectNumber");
                pInfo = new ProjectInfo();
                pInfo.setId(BOSUuid.read((String)rowSet.getString("ProjectID")));
                pInfo.setNumber(rowSet.getString("ProjectNumber"));
                pInfo.setName(rowSet.getString("ProjectName"));
                bti.setProject(pInfo);
            }
            if (rowSet.getString("trackId") != null) {
                trackInfo = new TrackNumberInfo();
                trackInfo.setId(BOSUuid.read((String)rowSet.getString("trackId")));
                trackInfo.setNumber(rowSet.getString("trackNumber"));
                bti.setTrackNumber(trackInfo);
            }
            bti.setName(rowSet.getString("MATERIALNUMBER") + "(" + rowSet.getString("MATERIALNAME") + ")" + tmp);
            result.addObject((IObjectValue)bti);
        }
        return result;
    }

    private String getLongNumber(IRowSet rs) throws SQLException {
        StringBuffer sb = new StringBuffer();
        int level = rs.getInt("flevel");
        BOMUsageEnum bomUsage = BOMUsageEnum.getEnum(rs.getInt("usagetype"));
        String projectId = rs.getString("ProjectID");
        if (MMUtils.isEmptyString((String)projectId)) {
            projectId = "999999999";
        }
        String materialId = rs.getString("MATERIALID");
        String bomid = rs.getString("BOMID");
        if (level == 0) {
            sb.append("1@").append(bomUsage.getName());
            sb.append("!2@").append(projectId);
            sb.append("!3@").append(materialId);
            sb.append("@").append(bomid);
        } else {
            sb.append("!").append(level);
            sb.append("@").append(materialId);
            if (MMUtils.isNotEmptyString((String)bomid)) {
                sb.append("@").append(bomid);
            }
        }
        return sb.toString();
    }
}

