/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.basedata.CostTypeEnum;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.ValuationTypeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractLaborCostBatchUpdateUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class LaborCostBatchUpdateUI
extends AbstractLaborCostBatchUpdateUI {
    private static final Logger logger = CoreUIObject.getLogger(LaborCostBatchUpdateUI.class);
    private ItemListener proportionItemListener = null;

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.addListeners();
    }

    private void addListeners() {
        if (this.proportionItemListener == null) {
            this.proportionItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (LaborCostBatchUpdateUI.this.kdrProportion.isSelected()) {
                        LaborCostBatchUpdateUI.this.kdtrProportion.setEnabled(true);
                        LaborCostBatchUpdateUI.this.kdtNumber.setEnabled(false);
                        LaborCostBatchUpdateUI.this.kdtNumber.setValue(null);
                    } else {
                        LaborCostBatchUpdateUI.this.kdtNumber.setEnabled(true);
                        LaborCostBatchUpdateUI.this.kdtNumber.setNegatived(true);
                        LaborCostBatchUpdateUI.this.kdtrProportion.setEnabled(false);
                        LaborCostBatchUpdateUI.this.kdtrProportion.setValue(null);
                    }
                }
            };
        }
        this.kdrProportion.addItemListener(this.proportionItemListener);
    }

    private void removeListeners() {
        this.kdrProportion.removeItemListener(this.proportionItemListener);
    }

    public void onLoad() throws Exception {
        this.removeListeners();
        this.kdtNumber.setEnabled(false);
        this.kdtNumber.setNegatived(true);
        this.kdtrProportion.setMinimumValue((Comparable)new BigDecimal("-100.0"));
        this.kdtrProportion.setSupportedEmpty(true);
        this.kdCombovaluationType.removeItem((Object)ValuationTypeEnum.NULL);
        this.kdCombovaluationType.setSelectedItem((Object)ValuationTypeEnum.piece_rate);
        this.kdtNumber.setDataVerifierType(-1);
        this.kdtNumber.setRemoveingZeroInDispaly(true);
        this.kdtNumber.setRemoveingZeroInEdit(true);
        super.onLoad();
        this.addListeners();
    }

    @Override
    public void actionUpdateCost_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List ids = (List)this.getUIContext().get("ids");
        CostTypeEnum costType = (CostTypeEnum)((Object)this.kdComboCostType.getSelectedItem());
        ValuationTypeEnum valuationTypeEnum = (ValuationTypeEnum)((Object)this.kdCombovaluationType.getSelectedItem());
        int isProportion = 0;
        BigDecimal value = this.kdtNumber.getBigDecimalValue();
        if (this.kdrProportion.isSelected()) {
            isProportion = 1;
            value = this.kdtrProportion.getBigDecimalValue();
            if (value != null) {
                value = value.movePointLeft(2);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.StandardRootingResource", (String)"inputProportion"));
                this.abort();
            }
        }
        if (value == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.StandardRootingResource", (String)"inputNumber"));
            this.abort();
        }
        map.put("ids", ids);
        map.put("costType", (Object)costType);
        map.put("isProportion", new Integer(isProportion));
        map.put("value", value);
        map.put("valuationType", (Object)valuationTypeEnum);
        String error = StandardRootingFactory.getRemoteInstance().laborCostBatchUpdate(map);
        if (error != null && error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.StandardRootingResource", (String)"someLaborCostBatchUpdateFail"), (String)error, (int)8188);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.StandardRootingResource", (String)"LaborCostBatchUpdateSuccess"));
            this.getUIWindow().close();
        }
    }
}

