/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.AbilityImpropriateEnum;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.BatchControlEnum;
import com.kingdee.eas.mm.basedata.DayCapacityGranularityEnum;
import com.kingdee.eas.mm.basedata.ExpandStrategyEnum;
import com.kingdee.eas.mm.basedata.ILineSchedulingModel;
import com.kingdee.eas.mm.basedata.IPriorityModel;
import com.kingdee.eas.mm.basedata.LineSchedulingModelCollection;
import com.kingdee.eas.mm.basedata.LineSchedulingModelFactory;
import com.kingdee.eas.mm.basedata.LineSchedulingModelInfo;
import com.kingdee.eas.mm.basedata.OrderModeEnum;
import com.kingdee.eas.mm.basedata.PriorityModelCollection;
import com.kingdee.eas.mm.basedata.PriorityModelFactory;
import com.kingdee.eas.mm.basedata.PriorityModelInfo;
import com.kingdee.eas.mm.basedata.PrioritySelectEnum;
import com.kingdee.eas.mm.basedata.RequireSrcEnum;
import com.kingdee.eas.mm.basedata.SonLineExpandModeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractLineSchedulingModelEditUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class LineSchedulingModelEditUI
extends AbstractLineSchedulingModelEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LineSchedulingModelEditUI.class);
    private DataChangeListener priorityModelChanged = null;
    private DataChangeListener storageChanged = null;
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.basedata.LineSchedulingModelResource";
    private LineSchedulingModelCollection collection = null;
    int currentIndex = 0;

    public void loadDefaultFields(OrgUnitInfo orgUnitInfo) throws BOSException {
        ILineSchedulingModel lineScheduling = LineSchedulingModelFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (orgUnitInfo != null) {
            try {
                PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), (String)this.getPermItemName());
            }
            catch (Exception err) {
                this.handUIException(err);
                this.abort(err);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            LineSchedulingModelCollection collection = lineScheduling.getLineSchedulingModelCollection(viewInfo);
            if (collection.size() > 0) {
                this.setOprtState(OprtState.EDIT);
                this.getUIContext().put("ID", collection.get(0).getId());
            } else {
                this.setOprtState(OprtState.ADDNEW);
            }
        } else {
            this.setOprtState(OprtState.ADDNEW);
        }
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initProductLineAllocate(this.editData.getStorageOrgUnit());
        this.storageChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    LineSchedulingModelEditUI.this.initElementState(eventObj);
                    LineSchedulingModelEditUI.this.storageChanged(eventObj);
                }
                catch (BOSException e) {
                    LineSchedulingModelEditUI.this.handUIException(e);
                }
                catch (Exception e) {
                    LineSchedulingModelEditUI.this.handUIException(e);
                }
            }
        };
        this.prmtstoreOrgUnit.addDataChangeListener(this.storageChanged);
        this.priorityModelChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                LineSchedulingModelEditUI.this.priorityModelChanged(eventObj);
            }
        };
        this.prmtpriorityModel.addDataChangeListener(this.priorityModelChanged);
    }

    private void removeListener() {
        if (this.priorityModelChanged != null) {
            this.prmtpriorityModel.removeDataChangeListener(this.priorityModelChanged);
        }
        if (this.storageChanged != null) {
            this.prmtstoreOrgUnit.removeDataChangeListener(this.storageChanged);
        }
    }

    private void priorityModelChanged(DataChangeEvent e) {
        PriorityModelInfo oldVal = (PriorityModelInfo)e.getOldValue();
        PriorityModelInfo newVal = (PriorityModelInfo)e.getNewValue();
        if (newVal != null && !newVal.equals(oldVal)) {
            String priorityDesc = newVal.getDescription();
            this.priorityDesc.setText(priorityDesc);
        }
        if (newVal == null && oldVal != null) {
            this.priorityDesc.setText("");
        }
    }

    public void storageChanged(DataChangeEvent e) {
        StorageOrgUnitInfo oldVal = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newVal = (StorageOrgUnitInfo)e.getNewValue();
        if (newVal != null && !newVal.equals((Object)oldVal)) {
            this.initProductLineAllocate(newVal);
            if (this.getOprtState().equals("EDIT")) {
                for (int i = 0; i < this.collection.size(); ++i) {
                    if (!this.collection.get(i).getStorageOrgUnit().getId().equals((Object)newVal.getId())) continue;
                    this.currentIndex = i;
                    break;
                }
            }
            this.initMenuBar();
        }
    }

    protected boolean isSubmitLoad() {
        return false;
    }

    public void initElementState(DataChangeEvent e) throws BOSException {
        StorageOrgUnitInfo oldVal = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newVal = (StorageOrgUnitInfo)e.getNewValue();
        if (newVal != null && !newVal.equals((Object)oldVal)) {
            try {
                PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(newVal.getId()), (String)this.getPermItemName());
            }
            catch (Exception err) {
                this.handUIException(err);
                this.prmtstoreOrgUnit.removeDataChangeListener(this.storageChanged);
                this.prmtstoreOrgUnit.setValue((Object)oldVal);
                this.prmtstoreOrgUnit.addDataChangeListener(this.storageChanged);
                this.abort();
            }
            ILineSchedulingModel lineScheduling = LineSchedulingModelFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLineAllocate.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("priorityModel.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)newVal.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            LineSchedulingModelCollection collection = lineScheduling.getLineSchedulingModelCollection(viewInfo);
            if (collection.size() > 0) {
                this.setOprtState(OprtState.EDIT);
                this.initUIElement(collection.get(0), OprtState.EDIT);
            } else {
                this.setOprtState(OprtState.ADDNEW);
                this.initUIElement(null, OprtState.ADDNEW);
            }
        }
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"LineSchedulingModelQueryF7WindowTitle"));
    }

    public void initUIElement(LineSchedulingModelInfo model, String state) throws BOSException {
        if (state.equals(OprtState.EDIT)) {
            this.getUIContext().put("ID", model.getId());
            this.editData.setId(model.getId());
            this.setDataObject((IObjectValue)model);
            this.loadFields();
            this.setSave(true);
            this.initOldData((IObjectValue)this.editData);
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtaheadDay.setText("0");
            this.dayAbilityMetho.setSelectedItem((Object)DayCapacityGranularityEnum.getEnum(10));
            this.order.setSelectedItem((Object)OrderModeEnum.getEnum(10));
            this.prioritySelect.setSelectedItem((Object)PrioritySelectEnum.getEnum(10));
            this.productLineAllocate.setValue(null);
            this.sonLineExpandMode.setSelectedItem((Object)SonLineExpandModeEnum.getEnum(10));
            this.expandStrategy.setSelectedItem((Object)ExpandStrategyEnum.getEnum(10));
            this.abilityImpropriate.setSelectedItem((Object)AbilityImpropriateEnum.getEnum(30));
            this.isDateBefAbility.setSelected(true);
            this.requireSrc.setSelectedItem((Object)RequireSrcEnum.getEnum(10));
            this.isSonLinePlanCalcStock.setSelected(false);
            this.batchControl.setSelectedItem((Object)BatchControlEnum.getEnum(10));
            this.editData.setId(null);
            this.initOldData((IObjectValue)this.editData);
            this.initPriorityModel();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstoreOrgUnit, (OrgType)OrgType.Storage, (String)this.getPermItemName());
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtstoreOrgUnit.getValue();
        if (storageOrgUnit == null) {
            storageOrgUnit = (StorageOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        }
        this.loadDefaultFields((OrgUnitInfo)storageOrgUnit);
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"LineSchedulingModelQueryF7WindowTitle"));
        this.txtaheadDay.setNegatived(false);
        this.initPriorityModel();
        this.initRelateElementState();
        this.initOldData((IObjectValue)this.editData);
        if (this.isSonLinePlanCalcStock.isSelected()) {
            this.sonLineExpandMode.setEnabled(false);
            this.sonLineExpandMode.setSelectedItem((Object)SonLineExpandModeEnum.getEnum(20));
        } else {
            this.sonLineExpandMode.setEnabled(true);
        }
        this.requireSrc.removeAllItems();
        this.requireSrc.addItem((Object)RequireSrcEnum.MPSPlanOrder);
        this.requireSrc.addItem((Object)RequireSrcEnum.RequirePlan);
    }

    @Override
    protected void isSonLinePlanCalcStock_itemStateChanged(ItemEvent e) throws Exception {
        if (this.isSonLinePlanCalcStock.isSelected()) {
            this.sonLineExpandMode.setEnabled(false);
            this.sonLineExpandMode.setSelectedItem((Object)SonLineExpandModeEnum.getEnum(20));
        } else {
            this.sonLineExpandMode.setEnabled(true);
        }
    }

    private void initMenuBar() {
        if (this.collection.size() <= 0 || this.collection.size() == 1 && this.currentIndex == 0) {
            this.btnPre.setEnabled(false);
            this.btnFirst.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else if (this.currentIndex == 0) {
            this.btnPre.setEnabled(false);
            this.btnFirst.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        } else if (this.currentIndex == this.collection.size() - 1) {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnLast.setEnabled(false);
            this.btnNext.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.btnNext.setEnabled(true);
        }
    }

    private void initRelateElementState() {
        OrgUnitInfo[] mainOrgs = null;
        try {
            mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), null);
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < mainOrgs.length; ++i) {
            hs.add(mainOrgs[i].getId().toString());
        }
        ILineSchedulingModel lineScheduling = null;
        try {
            lineScheduling = LineSchedulingModelFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.*"));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", hs, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            this.collection = lineScheduling.getLineSchedulingModelCollection(viewInfo);
            this.sortByStorageNum(this.collection);
            if (this.getOprtState().equals("EDIT")) {
                for (int i = 0; i < this.collection.size(); ++i) {
                    if (!this.collection.get(i).getStorageOrgUnit().getId().equals((Object)this.editData.getStorageOrgUnit().getId())) continue;
                    this.currentIndex = i;
                    break;
                }
            }
            this.initMenuBar();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void sortByStorageNum(LineSchedulingModelCollection collection) {
        for (int i = 0; i < collection.size() - 1; ++i) {
            LineSchedulingModelInfo preInfo = collection.get(i);
            for (int j = i + 1; j < collection.size(); ++j) {
                LineSchedulingModelInfo nextInfo = collection.get(j);
                if (preInfo.getStorageOrgUnit().getNumber().compareTo(nextInfo.getStorageOrgUnit().getNumber()) <= 0) continue;
                collection.swap(i, j);
                preInfo = collection.get(j);
            }
        }
    }

    public void initPriorityModel() throws BOSException {
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            IPriorityModel priority = PriorityModelFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.setFilter(filterInfo);
            PriorityModelCollection collection = priority.getPriorityModelCollection(viewInfo);
            if (collection.size() > 0) {
                this.prmtpriorityModel.setValue((Object)collection.get(0));
                this.priorityDesc.setText(collection.get(0).getDescription());
            }
        }
    }

    private void initProductLineAllocate(StorageOrgUnitInfo storageOrgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)(BDStatusEnum.APPROVE.getValue() + ""), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.productLineAllocate.setEntityViewInfo(viewInfo);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.btnFirst.setEnabled(false);
        this.btnPre.setEnabled(false);
        this.btnNext.setEnabled(false);
        this.btnLast.setEnabled(false);
        this.loadDefaultFields((OrgUnitInfo)((StorageOrgUnitInfo)this.prmtstoreOrgUnit.getValue()));
        if ("EDIT".equals(this.getOprtState())) {
            this.editData.setId((BOSUuid)this.getUIContext().get("ID"));
            this.initOldData((IObjectValue)this.editData);
        }
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"LineSchedulingModelQueryF7WindowTitle"));
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        this.currentIndex = 0;
        LineSchedulingModelInfo info = this.collection.get(this.currentIndex);
        this.prmtstoreOrgUnit.setValue((Object)info.getStorageOrgUnit());
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        --this.currentIndex;
        LineSchedulingModelInfo info = this.collection.get(this.currentIndex);
        this.prmtstoreOrgUnit.setValue((Object)info.getStorageOrgUnit());
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        ++this.currentIndex;
        LineSchedulingModelInfo info = this.collection.get(this.currentIndex);
        this.prmtstoreOrgUnit.setValue((Object)info.getStorageOrgUnit());
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        this.currentIndex = this.collection.size() - 1;
        LineSchedulingModelInfo info = this.collection.get(this.currentIndex);
        this.prmtstoreOrgUnit.setValue((Object)info.getStorageOrgUnit());
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LineSchedulingModelFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        if (this.prmtstoreOrgUnit.getValue() == null) {
            LineSchedulingModelInfo objectValue = new LineSchedulingModelInfo();
            objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
            objectValue.setStorageOrgUnit((StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), null));
            objectValue.put("prioritySelect", new Integer(10));
            objectValue.put("dayAbilityMetho", new Integer(10));
            objectValue.put("dayAbilityGranu", new Integer(10));
            objectValue.put("order", new Integer(10));
            objectValue.put("sonLineExpandMode", new Integer(10));
            objectValue.put("expandStrategy", new Integer(10));
            objectValue.put("abilityImpropriate", new Integer(30));
            objectValue.setIsDateBefAbility(true);
            objectValue.put("requireSrc", new Integer(10));
            objectValue.setIsSonLinePlanCalcStock(false);
            objectValue.put("batchControl", new Integer(10));
            return objectValue;
        }
        LineSchedulingModelCollection collection = null;
        try {
            ILineSchedulingModel lineScheduling = LineSchedulingModelFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtstoreOrgUnit.getValue();
            viewInfo.getSelector().add(new SelectorItemInfo("productLineAllocate.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("priorityModel.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            collection = lineScheduling.getLineSchedulingModelCollection(viewInfo);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return collection.get(0);
    }

    protected String getPermItemName() {
        if ("ADDNEW".equalsIgnoreCase(this.getOprtState()) || "EDIT".equalsIgnoreCase(this.getOprtState())) {
            return "mm_lineSchedulingModel_edit";
        }
        return null;
    }
}

