/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.ILowLevelCode;
import com.kingdee.eas.mm.basedata.LowLevelCodeFactory;
import com.kingdee.eas.mm.basedata.client.AbstractLowLevelCodeCalculateUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class LowLevelCodeCalculateUI
extends AbstractLowLevelCodeCalculateUI {
    private static final Logger logger = CoreUIObject.getLogger(LowLevelCodeCalculateUI.class);
    private static final String LOWLEVELCODE_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.LowLevelCodeResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_LowLevel_Cal");
        StorageOrgUnitInfo foi = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_bom_LowLevel_Cal");
        this.prmtStorageOrgUnit.setValue((Object)foi);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify()) {
            return;
        }
        this.lblInfo.setText(EASResource.getString((String)LOWLEVELCODE_RESOURCE_PATH, (String)"msgStart"));
        super.actionConfirm_actionPerformed(e);
        final MonitorInfo info = new MonitorInfo(this.getUITitle(), null, (Object)this, true);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    boolean bRet = LowLevelCodeCalculateUI.this.calLowLvlCode();
                    return bRet;
                }
                catch (Throwable e) {
                    return null;
                }
            }

            public void finished() {
                boolean bRet2 = false;
                Object obj = this.getValue();
                if (obj != null) {
                    bRet2 = new Boolean(obj.toString());
                }
                if (!bRet2) {
                    LowLevelCodeCalculateUI.this.getUIContext().put("rs", new Integer(MsgBox.showConfirm2((String)EASResource.getString((String)LowLevelCodeCalculateUI.LOWLEVELCODE_RESOURCE_PATH, (String)"msgErrEnd"))));
                } else {
                    LowLevelCodeCalculateUI.this.getUIContext().put("rs", new Integer(MsgBox.showConfirm2((String)EASResource.getString((String)LowLevelCodeCalculateUI.LOWLEVELCODE_RESOURCE_PATH, (String)"msgEnd"))));
                }
                ThreadPool.destroyMonitor((MonitorInfo)info);
            }
        };
        info.setWorker(worker);
        ThreadPool.addActionThread((MonitorInfo)info);
    }

    private boolean calLowLvlCode() throws Exception {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.getUIContext().put("storageOrgUnit", storageOrgUnit);
        this.actionExitCurrent_actionPerformed(null);
        ILowLevelCode iLowLevelCode = LowLevelCodeFactory.getRemoteInstance();
        boolean bRet = iLowLevelCode.calLowLvlCodeWithReplaceMtl(storageOrgUnit);
        return bRet;
    }

    public boolean verify() {
        boolean bRet = true;
        if (this.prmtStorageOrgUnit.getValue() == null || this.prmtStorageOrgUnit.getText() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)LOWLEVELCODE_RESOURCE_PATH, (String)"storageOrgUnit_IsNull"));
            bRet = false;
        }
        return bRet;
    }
}

