/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import java.awt.Point;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MMSortManagerByNumber
extends KDTSortManager {
    public MMSortManagerByNumber(KDTable table) {
        super(table);
        if (this.table.getSortMange() != null) {
            table.removeKDTMouseListener((KDTMouseListener)this.table.getSortMange());
        }
        table.setSortMange((KDTSortManager)this);
        table.addKDTMouseListener((KDTMouseListener)this);
    }

    public void tableClicked(KDTMouseEvent e) {
        if (e.getButton() == this.getButton() && e.getType() == 0) {
            this.setRefresh(false);
            this.sort(e.getColIndex());
            this.setRefresh(true);
        }
    }

    public void sort(int colIndex, int sortType) {
        if (this.isSortAuto()) {
            IColumn column = this.table.getColumn(colIndex);
            if (column == null) {
                return;
            }
            boolean refresh = this.table.isRefresh();
            this.table.setRefresh(false);
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
            List rows = this.table.getBody().getRows();
            if (this.groupSortConfig != null && this.groupSortConfig.size() > 0) {
                this.sortByGroups(colIndex, sortType);
            } else {
                Collections.sort(rows, new MMTableCellComparator(this.colIndex, sortType));
            }
            this.table.setRefresh(refresh);
        } else {
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
        }
    }

    public void sortByGroups(int colIndex, int sortType) {
        int size = this.groupSortConfig.size();
        for (int i = 0; i < size; ++i) {
            Point scope = (Point)this.groupSortConfig.get(i);
            List rows = this.table.getBody().getRows();
            int rowCount = rows.size();
            ArrayList group = new ArrayList();
            for (int m = scope.x; m <= scope.y && m <= rowCount - 1; ++m) {
                Object row = rows.get(m);
                group.add(row);
            }
            Collections.sort(group, new MMTableCellComparator(this.colIndex, sortType));
            int n = 0;
            for (int m = scope.x; m <= scope.y; ++m) {
                rows.set(m, group.get(n));
                ++n;
            }
        }
    }

    class MMTableCellComparator
    implements Comparator {
        int colIndex = 0;
        int sortType;
        Collator comparator = Collator.getInstance(Locale.getDefault());

        public MMTableCellComparator(int i, int sortType) {
            this.colIndex = i;
            this.sortType = sortType;
        }

        public int compare(Object kdtRow1, Object kdtRow2) {
            int result = this.doCompare(kdtRow1, kdtRow2);
            if (this.sortType == 0) {
                return result;
            }
            if (result < 0) {
                return 1;
            }
            if (result > 0) {
                return -1;
            }
            return result;
        }

        public int doCompare(Object kdtRow1, Object kdtRow2) {
            Object o1 = null;
            Object o2 = null;
            KDTCell cell = ((KDTRow)kdtRow1).getCell(this.colIndex);
            if (cell != null) {
                o1 = cell.getValue() instanceof MaterialInfo ? ((MaterialInfo)cell.getValue()).getNumber() : cell.getValue();
            }
            if ((cell = ((KDTRow)kdtRow2).getCell(this.colIndex)) != null) {
                o2 = cell.getValue() instanceof MaterialInfo ? ((MaterialInfo)cell.getValue()).getNumber() : cell.getValue();
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof Number) {
                if (o2 instanceof Number) {
                    double d2;
                    double d1 = ((Number)o1).doubleValue();
                    if (d1 == (d2 = ((Number)o2).doubleValue())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof String) {
                if (o2 instanceof String) {
                    return this.comparator.compare(o1, o2);
                }
                return ((String)o1).compareTo(o2.toString());
            }
            if (o1 instanceof Date) {
                if (o2 instanceof Date) {
                    return ((Date)o1).compareTo((Date)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Calendar) {
                if (o2 instanceof Calendar) {
                    long d2;
                    long d1 = ((Calendar)o1).getTimeInMillis();
                    if (d1 == (d2 = ((Calendar)o2).getTimeInMillis())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof MaterialInfo) {
                if (o2 instanceof MaterialInfo) {
                    return ((MaterialInfo)o1).getNumber().compareTo(((MaterialInfo)o2).getNumber());
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Comparable) {
                if (o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo((Comparable)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

