/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.MainTenanceLevelFactory;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.client.AbstractMainTenanceLevelEditUI;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class MainTenanceLevelEditUI
extends AbstractMainTenanceLevelEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MainTenanceLevelEditUI.class);
    private String RESOURCE_NAME = "com.kingdee.eas.mm.basedata.MainTenanceLevelResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MainTenanceLevelFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        MainTenanceLevelInfo objectValue = new MainTenanceLevelInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")).getBoolean("isBizUnit")) {
            objectValue.put("CU", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setStatus(MMBaseStatusEnum.SAVED);
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.btnSave.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initBtnEnabled();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE) && this.editData.getId() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUsed_NoSave"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void checkEditData() throws Exception {
        if (this.txtNumber.getText() == null || "".equals(this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"numberIsNUll"));
            SysUtil.abort();
        }
        if (this.txtName.getSelectedItem() == null || "".equals(this.txtName.getSelectedItem().toString())) {
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"nameIsNUll"));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUsed_NoEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUsed_NoDelete"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getStatus() == null || !this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUnEnabled"));
            SysUtil.abort();
        }
        super.actionCancel_actionPerformed(e);
        this.refreshCurPage();
    }

    protected void initBtnEnabled() {
        if (this.getOprtState().equals("ADDNEW")) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.btnCopy.setEnabled(false);
        } else {
            if (this.editData == null || this.editData.getId() == null) {
                this.btnCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(false);
                this.btnCopy.setEnabled(false);
            } else if (this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                this.btnCancel.setEnabled(true);
                this.btnCancelCancel.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnSubmit.setEnabled(false);
            } else {
                this.btnCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.btnSubmit.setEnabled(true);
            }
            if (this.getOprtState().equals("VIEW")) {
                this.btnSubmit.setEnabled(false);
            }
        }
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.setSave(true);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isEnabled"));
            SysUtil.abort();
        }
        super.actionCancelCancel_actionPerformed(e);
        this.refreshCurPage();
    }
}

