/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IMaterialReplace;
import com.kingdee.eas.mm.basedata.MaterialReplaceFactory;
import com.kingdee.eas.mm.basedata.ReplaceMaterailVO;
import com.kingdee.eas.mm.basedata.client.AbstractMaterialReplaceTestUI;
import com.kingdee.eas.mm.basedata.client.OrderMaterialReplace;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class MaterialReplaceTestUI
extends AbstractMaterialReplaceTestUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialReplaceTestUI.class);
    private DataChangeListener storageDataChanged = null;
    private DataChangeListener bomDataChanged = null;
    public static final String MATERIAL_PLAN_FORBOM = "com.kingdee.eas.mm.basedata.app.F7MaterialTestQuery";

    public void onLoad() throws Exception {
        super.onLoad();
        this.removeListener();
        Object obj = this.getUIContext().get("storageOrgUni");
        this.kDBizPromptBox1.setValue(obj);
        this.prmtmaterial.setQueryInfo(MATERIAL_PLAN_FORBOM);
        this.materialRep.setEnabled(true);
        this.initMaterialEntityViewInfo();
        this.initBomEntityViewInfo();
        this.textAvaQty.setValue((Object)new BigDecimal(100));
        this.textReqOty.setValue((Object)new BigDecimal(100));
        this.addListener();
    }

    private void addListener() {
        this.storageDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialReplaceTestUI.this.prmtStorage_dataChanged(e);
                }
                catch (Exception exc) {
                    MaterialReplaceTestUI.this.handUIException(exc);
                }
            }
        };
        this.kDBizPromptBox1.addDataChangeListener(this.storageDataChanged);
        this.bomDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialReplaceTestUI.this.prmtBom_dataChanged(e);
                }
                catch (Exception exc) {
                    MaterialReplaceTestUI.this.handUIException(exc);
                }
            }
        };
        this.prmtbom.addDataChangeListener(this.bomDataChanged);
    }

    private void removeListener() {
        if (this.storageDataChanged != null) {
            this.kDBizPromptBox1.removeDataChangeListener(this.storageDataChanged);
        }
        if (this.bomDataChanged != null) {
            this.prmtbom.removeDataChangeListener(this.bomDataChanged);
        }
    }

    private void prmtStorage_dataChanged(DataChangeEvent e) {
        StorageOrgUnitInfo newValue;
        StorageOrgUnitInfo oldValue = (StorageOrgUnitInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (StorageOrgUnitInfo)e.getNewValue()));
        if (isDiffrent) {
            this.prmtbom.setValue(null);
            this.prmtmaterial.setValue(null);
            this.initMaterialEntityViewInfo();
            this.initBomEntityViewInfo();
        }
    }

    private void prmtBom_dataChanged(DataChangeEvent e) {
        BomInfo newValue;
        BomInfo oldValue = (BomInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (BomInfo)e.getNewValue()));
        if (isDiffrent) {
            this.prmtmaterial.setValue(null);
            this.initMaterialEntityViewInfo();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionClick_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable2.removeRows();
        Object obj1 = this.kDBizPromptBox1.getValue();
        Object obj2 = this.prmtbom.getValue();
        Object obj3 = this.prmtmaterial.getValue();
        if (obj1 == null || obj2 == null || obj3 == null) {
            return;
        }
        String materialId = ((MaterialInfo)obj3).getId().toString();
        String bomId = ((BomInfo)obj2).getId().toString();
        String storageOrgUnitId = ((StorageOrgUnitInfo)obj1).getId().toString();
        MaterialPlanInfo planInfo = this.getMaterialPlanInfo(materialId, storageOrgUnitId);
        String materialUnitId = planInfo.getProductUnit().getId().toString();
        Date reqDate = new Date(110, 10, 19);
        BigDecimal reqQty = new BigDecimal(this.textReqOty.getNumberValue().intValue());
        List list = new ArrayList();
        OrderMaterialReplace omr = new OrderMaterialReplace();
        String lineSeq = "10";
        list = omr.getSuitableReplaceMaterial(lineSeq, materialId, bomId, reqDate, reqQty, storageOrgUnitId, materialUnitId);
        if (list != null && list.size() != 0) {
            IMaterialReplace im = MaterialReplaceFactory.getRemoteInstance();
            for (int i = 0; i < list.size(); ++i) {
                this.kDTable2.addRow();
                ReplaceMaterailVO replaceMaterail = new ReplaceMaterailVO();
                replaceMaterail = (ReplaceMaterailVO)list.get(i);
                this.kDTable2.getCell(i, "replaceMaterailID").setValue((Object)replaceMaterail.getReplaceMaterailID());
                this.kDTable2.getCell(i, "rawMaterailID").setValue((Object)replaceMaterail.getRawMaterailID());
                this.kDTable2.getCell(i, "prior").setValue((Object)new Integer(replaceMaterail.getPriority()));
                this.kDTable2.getCell(i, "qty").setValue((Object)replaceMaterail.getqty());
                this.kDTable2.getCell(i, "replaceQty").setValue((Object)replaceMaterail.getReplaceQty());
                this.kDTable2.getCell(i, "isKeyMaterial").setValue((Object)new Boolean(replaceMaterail.isKeyMaterial()));
                this.kDTable2.getCell(i, "isCombination").setValue((Object)new Boolean(replaceMaterail.isCombination()));
                this.kDTable2.getCell(i, "isShortSupply").setValue((Object)new Boolean(replaceMaterail.getIsShortSupply()));
                String replaceMaterailId = null;
                if (replaceMaterail.getReplaceMaterailID() != null) {
                    replaceMaterailId = replaceMaterail.getReplaceMaterailID().toString();
                }
                String rawMaterailID = null;
                if (replaceMaterail.getRawMaterailID() != null) {
                    rawMaterailID = replaceMaterail.getRawMaterailID().toString();
                }
                String[] s = null;
                if (replaceMaterailId != null && rawMaterailID != null) {
                    s = new String[]{replaceMaterailId, rawMaterailID};
                } else if (replaceMaterailId != null) {
                    s = new String[]{replaceMaterailId};
                } else if (rawMaterailID != null) {
                    s = new String[]{rawMaterailID};
                }
                if (s == null || s.length <= 0) continue;
                IRowSet mi = im.getMaterialInfoByIds(s, storageOrgUnitId);
                while (mi.next()) {
                    String materialName = mi.getString("materialName");
                    String material = mi.getString("materialId");
                    if (material.equalsIgnoreCase(replaceMaterailId)) {
                        this.kDTable2.getCell(i, "replaceMaterailName").setValue((Object)materialName);
                    }
                    if (!material.equalsIgnoreCase(rawMaterailID)) continue;
                    this.kDTable2.getCell(i, "rawMaterailName").setValue((Object)materialName);
                }
            }
        }
    }

    private void initMaterialEntityViewInfo() {
        String fid = ((StorageOrgUnitInfo)this.kDBizPromptBox1.getValue()).getId().toString();
        String fbomId = null;
        if (this.prmtbom.getValue() != null) {
            fbomId = ((BomInfo)this.prmtbom.getValue()).getId().toString();
        }
        EntityViewInfo eView = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        FilterItemCollection fic = fInfo.getFilterItems();
        fic.add(new FilterItemInfo("STORAGEORGUNIT.id", (Object)fid, CompareType.EQUALS));
        fic.add(new FilterItemInfo("MATERIAL.status", (Object)new Integer(1), CompareType.EQUALS));
        if (fbomId != null) {
            fic.add(new FilterItemInfo("B.id", (Object)fbomId, CompareType.EQUALS));
        }
        eView.setFilter(fInfo);
        this.prmtmaterial.setEntityViewInfo(eView);
    }

    private void initBomEntityViewInfo() {
        String fid = ((StorageOrgUnitInfo)this.kDBizPromptBox1.getValue()).getId().toString();
        EntityViewInfo eView = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        FilterItemCollection fic = fInfo.getFilterItems();
        fic.add(new FilterItemInfo("STORAGEORGUNIT.id", (Object)fid, CompareType.EQUALS));
        fic.add(new FilterItemInfo("BOM.basestatus", (Object)new Integer(4), CompareType.EQUALS));
        eView.setFilter(fInfo);
        this.prmtbom.setEntityViewInfo(eView);
    }

    private MaterialPlanInfo getMaterialPlanInfo(String materialID, String storageOrgUnitID) throws BOSException {
        MaterialPlanInfo materialPlanInfo = null;
        MaterialPlanCollection materialPlanColls = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitID));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("productUnit.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("planner.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("materialAttr"));
        viewInfo.getSelector().add(new SelectorItemInfo("manufactureStrategy.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("dutyDepartment.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("recevingLeadTime"));
        materialPlanColls = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewInfo);
        if (materialPlanColls != null && materialPlanColls.size() > 0) {
            materialPlanInfo = materialPlanColls.get(0);
        }
        return materialPlanInfo;
    }
}

