/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.IMaterialReplace;
import com.kingdee.eas.mm.basedata.IMaterialReplaceFacade;
import com.kingdee.eas.mm.basedata.MaterialReplaceCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceCombinationCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceCombinationInfo;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryCollection;
import com.kingdee.eas.mm.basedata.MaterialReplaceEntryInfo;
import com.kingdee.eas.mm.basedata.MaterialReplaceFacadeFactory;
import com.kingdee.eas.mm.basedata.MaterialReplaceFactory;
import com.kingdee.eas.mm.basedata.MaterialReplaceInfo;
import com.kingdee.eas.mm.basedata.ReplaceMaterailVO;
import com.kingdee.eas.mm.basedata.SubstituteModeEnum;
import com.kingdee.eas.mm.basedata.client.AbstractMaterialReplaceUI;
import com.kingdee.eas.mm.common.loadmass.MaterialSustituteVO;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.control.util.MaterialSustituteHelper;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialReplaceUI
extends AbstractMaterialReplaceUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialReplaceUI.class);
    private static final String STT_REPLACESEQ = "substituteSeq";
    private static final String STT_MATERIALID = "substituteMaterial";
    private static final String STT_MATERIALNUM = "substituteMaterialNum";
    private static final String STT_MATERIALNAME = "substituteMaterialName";
    private static final String STT_MODEL = "substituteMaterialMode";
    private static final String STT_FUNIT = "substituteUnit";
    private static final String STT_UNITREPQTY = "substituteUnitQty";
    private static final String STT_PERPROPORTION = "substituteProportion";
    private static final String STT_EFFECTIVEDATE = "effectiveDate";
    private static final String STT_INVALIDATE = "invalidDate";
    private static final String STT_SURPLUSQTY = "surplusQty";
    private static final String STT_SUBSTITUTEQTY = "substituteQty";
    private static final String STT_SUBSTITUTEBASEQTY = "substituteBaseQty";
    private KDTPropertyChangeListener kdtEntrysChangeListener = null;
    private KDTMouseListener kdtEntryClickListener = null;
    private static final String STT_ENTRYID = "materialReplaceEntryId";
    private static final String STT_REPLACESCALE = "substituteScale";
    private static final String STT_COMBINATIONKEY = "combinationKey";
    private static final String STT_REPLACEBASEQTY = "substituteBaseUnitQty";
    private static final String COMBOMNUMBER = "bomNumber";
    private static final String COMBOMNAME = "bomName";
    private static final String COMMATERIALID = "materialId";
    private static final String COMMATERIALNUMBER = "materialNumber";
    private static final String COMMATERIALNAME = "materialName";
    private static final String COMMATERIALMODEL = "materialModel";
    private static final String COMREPMATERIALID = "repMaterialId";
    private static final String COMREPMATERIALNUMBER = "replaceMaterialNumber";
    private static final String COMREPMATERIALNAME = "replaceMaterialName";
    private static final String COMREPMATERIALMODEL = "replaceMaterialModel";
    private static final String COMREPQTY = "replaceQty";
    private static final String COMREPPRECE = "replaceProportion";
    private static final String COMREPSEQ = "replaceSeq";
    private static final String COMREPSCALE = "replaceScale";
    private static final String COMCOMBINATIONKEY = "combinationKey";
    private static final String COMSURPLUSQTY = "surplusQty";
    private static final String COMSUBSTITUEQTY = "substituteQty";
    private static final String COMSUBSTITUEBASEQTY = "substituteBaseQty";
    private static final String COMSHORSUPPLY = "shortSupply";
    private static final String COMMATERIALREPLACEID = "materialReplaceId";
    private static final String COMENTRYID = "entryId";
    private static final String COMBASEQTY = "baseQty";
    private static final String COMBASEREPLACEQTY = "baseReplaceQty";
    private static final String COMUNITID = "unitId";
    private static final String COMMEASUREUNITID = "measureUnitId";
    private static final String COMSUPPLYTYPE = "supplyType";
    private static final String COMSUPPLYORG = "supplyOrg";
    private final String[] STT_DATES = new String[]{"effectiveDate", "invalidDate"};
    private static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderNextResource";
    private int headPrecision = 0;
    private BigDecimal headBaseRate = new BigDecimal("0.00");
    private KDFormattedTextField[] initHeadTxtField = new KDFormattedTextField[]{this.txtCanBeUseQty, this.txtQty, this.txtReplaceQty, this.txtSurplusQty};
    private Map entryPrecision = new HashMap();
    private Map entryBaseRate = new HashMap();
    private boolean isReplaceSeq = true;
    private String materialReplaceId = null;
    private Map combinationMap = new HashMap();
    private Map comSustitueQtyMap = new HashMap();
    private Map comRepBaseQtyMap = new HashMap();
    private Map combinationConvsRateMap = new HashMap();
    private Map combinationPrecisionMap = new HashMap();
    private List combinationMaterials = new ArrayList();
    private List combinationUnits = new ArrayList();
    private String materialId = null;
    private String storageOrgUnitId = null;
    private String bomId = null;
    private Date repDate = null;
    private BigDecimal reqQty = new BigDecimal("0.00");
    private BigDecimal reqBaseQty = new BigDecimal("0.00");
    private BigDecimal replaceQty = new BigDecimal("0.00");
    private BigDecimal replaceBaseQty = new BigDecimal("0.00");
    private SubstituteModeEnum replaceMode = null;
    private MaterialReplaceInfo mri = new MaterialReplaceInfo();
    private BigDecimal zeroDecimal = new BigDecimal("0.00");
    private BigDecimal oneDecimal = new BigDecimal("1.00");
    private BigDecimal hundredDecimal = new BigDecimal("100.00");
    private List entryMaterialIds = new ArrayList();
    private Map entryInventorySurplusQtyMap = new HashMap();
    private List combMaterialIds = new ArrayList();
    private Map combInventorySurplusQtyMap = new HashMap();
    Map replaceSeqMap = new HashMap();

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.mri = this.getMaterialReplaceInfo();
        this.getCombinationByMaterial();
        this.addListener();
    }

    private MaterialReplaceInfo getMaterialReplaceInfo() {
        MaterialReplaceCollection mrc = (MaterialReplaceCollection)((Object)this.getUIContext().get("materialReplace"));
        MaterialReplaceInfo mri = mrc.get(0);
        this.isReplaceSeq = mri.isIsReplaceSeq();
        this.materialReplaceId = mri.getId().toString();
        this.materialId = mri.getMaterial().getId().toString();
        this.storageOrgUnitId = mri.getStorageOrgUnit().getId().toString();
        this.repDate = (Date)this.getUIContext().get("repDate");
        this.bomId = (String)this.getUIContext().get("bomId");
        this.replaceBaseQty = mri.getBaseQty();
        this.replaceMode = mri.getSubstituteMode();
        this.reqBaseQty = (BigDecimal)this.getUIContext().get("repBaseQty");
        return mri;
    }

    private void getCombinationByMaterial() throws Exception {
        try {
            IMaterialReplace mr = MaterialReplaceFactory.getRemoteInstance();
            this.combinationMap.putAll(mr.getComByMalRepIdAndBomId(this.materialReplaceId, this.bomId));
            this.combinationMaterials = (List)this.combinationMap.get("materials");
            this.combinationUnits = (List)this.combinationMap.get("units");
            this.combMaterialIds = (List)this.combinationMap.get("replaceMaterials");
            this.combinationMap.remove("materials");
            this.combinationMap.remove("units");
            this.combinationMap.remove("replaceMaterials");
            this.getCombinationMultiMeasureUnit();
            this.combInventorySurplusQtyMap = MaterialSustituteHelper.getInventorySurplusQty((String)this.storageOrgUnitId, (List)this.combMaterialIds, (Date)this.repDate);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void getCombinationMultiMeasureUnit() {
        MaterialInfo[] materials = new MaterialInfo[this.combinationMaterials.size()];
        MeasureUnitInfo[] units = new MeasureUnitInfo[this.combinationUnits.size()];
        for (int i = 0; i < this.combinationMaterials.size(); ++i) {
            materials[i] = (MaterialInfo)this.combinationMaterials.get(i);
            units[i] = (MeasureUnitInfo)this.combinationUnits.get(i);
        }
        StorageOrgUnitInfo orgUnitInfo = new StorageOrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)this.storageOrgUnitId));
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materials);
        vo.setMeasureUnitInfos(units);
        vo.setMainOrg((OrgUnitInfo)orgUnitInfo);
        try {
            SCMEntryDataVO combinationVO = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
            if (combinationVO.getMmuConvsRate() != null) {
                this.combinationConvsRateMap.putAll(combinationVO.getMmuConvsRate());
            }
            if (combinationVO.getMmuPrecisions() != null) {
                this.combinationPrecisionMap.putAll(combinationVO.getMmuPrecisions());
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private void addListener() {
        if (this.kdtEntrysChangeListener == null) {
            this.kdtEntrysChangeListener = new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent evt) {
                    try {
                        MaterialReplaceUI.this.subStituteQty_propertyChange(evt);
                    }
                    catch (Exception exc) {
                        MaterialReplaceUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kDReplaceMaterial.addKDTPropertyChangeListener(this.kdtEntrysChangeListener);
        if (this.kdtEntryClickListener == null) {
            this.kdtEntryClickListener = new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    MaterialReplaceUI.this.materialReplaceEntry_tableClicked(e);
                }
            };
        }
        this.kDReplaceMaterial.addKDTMouseListener(this.kdtEntryClickListener);
    }

    private void removeListener() {
        if (this.kdtEntrysChangeListener != null) {
            this.kDReplaceMaterial.removeKDTPropertyChangeListener(this.kdtEntrysChangeListener);
        }
        if (this.kdtEntryClickListener != null) {
            this.kDReplaceMaterial.removeKDTMouseListener(this.kdtEntryClickListener);
        }
    }

    private void subStituteQty_propertyChange(KDTPropertyChangeEvent evt) throws Exception {
        int rowIndex = evt.getRowIndex();
        int colIndex = evt.getColIndex();
        String fieldName = this.kDReplaceMaterial.getColumnKey(colIndex);
        if ("substituteQty".equals(fieldName)) {
            if (this.kDReplaceMaterial.getRow(rowIndex) == null) {
                return;
            }
            this.kDReplaceMaterial.removeKDTPropertyChangeListener(this.kdtEntrysChangeListener);
            boolean isCombinationKey = (Boolean)this.kDReplaceMaterial.getCell(rowIndex, "combinationKey").getValue();
            this.replaceQtyDeal(rowIndex, evt, isCombinationKey);
            this.kDReplaceMaterial.addKDTPropertyChangeListener(this.kdtEntrysChangeListener);
        }
    }

    private void replaceQtyDeal(int rowIndex, KDTPropertyChangeEvent e, boolean isCombinationKey) {
        BigDecimal newValue = (BigDecimal)e.getNewValue();
        if (newValue == null) {
            newValue = this.zeroDecimal;
        }
        BigDecimal oldValue = (BigDecimal)e.getOldValue();
        BigDecimal oldBaseQty = (BigDecimal)this.kDReplaceMaterial.getCell(rowIndex, "substituteBaseQty").getValue();
        if (oldValue == null) {
            oldValue = this.zeroDecimal;
            oldBaseQty = this.zeroDecimal;
        }
        int precision = this.getRowIndexPrecision(rowIndex);
        BigDecimal baseRate = this.getRowIndexBaseRate(rowIndex);
        BigDecimal newBaseQty = newValue.multiply(baseRate).setScale(precision, 4);
        this.kDReplaceMaterial.getCell(rowIndex, "substituteBaseQty").setValue((Object)newBaseQty);
        BigDecimal qty = this.getReplaceHeadQty(rowIndex, newBaseQty).subtract(this.getReplaceHeadQty(rowIndex, oldBaseQty));
        if (this.isReplaceSeq) {
            this.dealRepSeq(isCombinationKey, rowIndex);
        } else {
            this.dealValueForEntryReplaceQtyChange(rowIndex, qty, isCombinationKey);
        }
    }

    private BigDecimal getRepSeqMinRepQty(int replaceSeq) {
        BigDecimal baseQty = this.zeroDecimal;
        BigDecimal curRepBaseQty = this.zeroDecimal;
        BigDecimal curBaseQty = this.zeroDecimal;
        boolean isFrist = true;
        int curRepSeq = 0;
        for (int i = 0; i < this.kDReplaceMaterial.getRowCount(); ++i) {
            curRepSeq = (Integer)this.kDReplaceMaterial.getCell(i, STT_REPLACESEQ).getValue();
            if (curRepSeq != replaceSeq) continue;
            curRepBaseQty = (BigDecimal)this.kDReplaceMaterial.getCell(i, "substituteBaseQty").getValue();
            if (curRepBaseQty == null) {
                curRepBaseQty = this.zeroDecimal;
            }
            curBaseQty = this.getReplaceHeadQty(i, curRepBaseQty);
            if (isFrist) {
                baseQty = curBaseQty;
            } else if (baseQty.compareTo(curBaseQty) == 1) {
                baseQty = curBaseQty;
            }
            isFrist = false;
        }
        return baseQty;
    }

    private void dealValueForEntryReplaceQtyChange(int rowIndex, BigDecimal qty, boolean isCombinationKey) {
        this.replaceQty = this.replaceQty.add(qty);
        this.setHeadQty(this.replaceQty);
        if (isCombinationKey) {
            this.setCombinationRepQty(rowIndex);
        }
    }

    private void setHeadQty(BigDecimal replaceQty) {
        BigDecimal headQty = replaceQty.divide(this.headBaseRate, this.headPrecision, 4);
        this.txtReplaceQty.setValue((Object)headQty);
        this.txtSurplusQty.setValue((Object)this.reqQty.subtract(headQty));
    }

    private void dealRepSeq(boolean isCombinationKey, int rowIndex) {
        Iterator it = this.replaceSeqMap.keySet().iterator();
        int curReplaceSeq = 0;
        this.replaceQty = this.zeroDecimal;
        while (it.hasNext()) {
            curReplaceSeq = (Integer)it.next();
            this.replaceQty = this.replaceQty.add(this.getRepSeqMinRepQty(curReplaceSeq));
        }
        this.setHeadQty(this.replaceQty);
        if (isCombinationKey) {
            this.setCombinationRepQty(rowIndex);
        }
    }

    private void setCombinationRepQty(int rowIndex) {
        try {
            String entryId = (String)this.kDReplaceMaterial.getCell(rowIndex, STT_ENTRYID).getValue();
            String combEntryId = null;
            ArrayList<String> combMaterialIds = new ArrayList<String>();
            Map repQtyMap = new HashMap();
            Map<String, BigDecimal> combQtyMap = new HashMap<String, BigDecimal>();
            Map<String, BigDecimal> combBaseQtyMap = new HashMap<String, BigDecimal>();
            IMaterialReplaceFacade imm = MaterialReplaceFacadeFactory.getRemoteInstance();
            for (int i = 0; i < this.kDCombination.getRowCount(); ++i) {
                combMaterialIds.add((String)this.kDCombination.getCell(i, COMMATERIALID).getValue());
            }
            if (combMaterialIds != null && combMaterialIds.size() != 0) {
                BigDecimal entryRepQty = this.zeroDecimal;
                entryRepQty = (BigDecimal)this.kDReplaceMaterial.getCell(rowIndex, "substituteBaseQty").getValue();
                entryRepQty = this.getReplaceHeadQty(rowIndex, entryRepQty);
                repQtyMap = imm.getReqQtyByBom(this.bomId, this.repDate, this.materialId, combMaterialIds, entryRepQty, this.storageOrgUnitId, null);
                BigDecimal repQty = this.zeroDecimal;
                String combMaterialId = null;
                String replaceMaterialId = null;
                BigDecimal baseConvsRate = null;
                BigDecimal entryBaseQty = this.zeroDecimal;
                BigDecimal entryReplaseQty = this.zeroDecimal;
                BigDecimal headBaseQty = this.zeroDecimal;
                BigDecimal replacePercent = this.zeroDecimal;
                BigDecimal entryBaseConvsRate = null;
                String unitId = null;
                String measureUnitId = null;
                String keyMaterialIdAndUnitId = null;
                int entryPrecision = 0;
                for (int i = 0; i < this.kDCombination.getRowCount(); ++i) {
                    combMaterialId = (String)this.kDCombination.getCell(i, COMMATERIALID).getValue();
                    combEntryId = (String)this.kDCombination.getCell(i, COMENTRYID).getValue();
                    repQty = (BigDecimal)repQtyMap.get(combMaterialId);
                    if (repQty == null) {
                        repQty = this.zeroDecimal;
                    }
                    headBaseQty = (BigDecimal)this.kDCombination.getCell(i, COMBASEQTY).getValue();
                    unitId = (String)this.kDCombination.getCell(i, COMUNITID).getValue();
                    baseConvsRate = (BigDecimal)this.combinationConvsRateMap.get(combMaterialId + unitId);
                    replaceMaterialId = (String)this.kDCombination.getCell(i, COMREPMATERIALID).getValue();
                    measureUnitId = (String)this.kDCombination.getCell(i, COMMEASUREUNITID).getValue();
                    entryBaseQty = (BigDecimal)this.kDCombination.getCell(i, COMBASEREPLACEQTY).getValue();
                    replacePercent = (BigDecimal)this.kDCombination.getCell(i, COMREPPRECE).getValue();
                    keyMaterialIdAndUnitId = replaceMaterialId + measureUnitId;
                    entryBaseConvsRate = (BigDecimal)this.combinationConvsRateMap.get(keyMaterialIdAndUnitId);
                    entryPrecision = (Integer)this.combinationPrecisionMap.get(keyMaterialIdAndUnitId);
                    entryReplaseQty = entryBaseQty != null && entryBaseQty.compareTo(this.zeroDecimal) > 0 ? entryBaseQty.multiply(repQty).divide(headBaseQty, entryPrecision, 4) : repQty.multiply(entryBaseConvsRate).multiply(replacePercent).divide(baseConvsRate.multiply(this.hundredDecimal), entryPrecision, 4);
                    this.kDCombination.getCell(i, "substituteBaseQty").setValue((Object)entryReplaseQty);
                    this.kDCombination.getCell(i, "substituteQty").setValue((Object)entryReplaseQty.divide(entryBaseConvsRate, entryPrecision, 4));
                    if (this.comSustitueQtyMap.get(entryId) != null) {
                        combQtyMap = (Map)this.comSustitueQtyMap.get(entryId);
                        combBaseQtyMap = (Map)this.comRepBaseQtyMap.get(entryId);
                    }
                    combQtyMap.put(combEntryId, entryReplaseQty);
                    combBaseQtyMap.put(combEntryId, repQty);
                    this.comSustitueQtyMap.put(entryId, combQtyMap);
                    this.comRepBaseQtyMap.put(entryId, combBaseQtyMap);
                }
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    private BigDecimal getReplaceHeadQty(int rowIndex, BigDecimal baseReqQty) {
        BigDecimal replaceHeadQty = this.zeroDecimal;
        BigDecimal entryBaseQty = (BigDecimal)this.kDReplaceMaterial.getCell(rowIndex, STT_REPLACEBASEQTY).getValue();
        BigDecimal baseRate = this.getRowIndexBaseRate(rowIndex);
        if (entryBaseQty != null && entryBaseQty.compareTo(this.zeroDecimal) == 1) {
            replaceHeadQty = baseReqQty.multiply(this.replaceBaseQty).divide(entryBaseQty, this.headPrecision, 4);
        } else {
            BigDecimal repProtion = (BigDecimal)this.kDReplaceMaterial.getCell(rowIndex, STT_PERPROPORTION).getValue();
            replaceHeadQty = baseReqQty.multiply(this.headBaseRate).multiply(this.hundredDecimal).divide(repProtion.multiply(baseRate), this.headPrecision, 4);
        }
        return replaceHeadQty;
    }

    private int getRowIndexPrecision(int rowIndex) {
        String entryId = this.kDReplaceMaterial.getCell(rowIndex, STT_ENTRYID).getValue().toString();
        int precision = (Integer)this.entryPrecision.get(entryId);
        return precision;
    }

    private BigDecimal getRowIndexBaseRate(int rowIndex) {
        String entryId = this.kDReplaceMaterial.getCell(rowIndex, STT_ENTRYID).getValue().toString();
        BigDecimal baseRate = this.oneDecimal;
        baseRate = (BigDecimal)this.entryBaseRate.get(entryId);
        return baseRate;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initHead(this.mri);
        Collection bomSubs = (Collection)this.getUIContext().get("bomSubs");
        this.kDReplaceMaterial.checkParsed();
        this.kDReplaceMaterial.removeRows();
        this.entryInventorySurplusQtyMap = new HashMap();
        this.entryMaterialIds = new ArrayList();
        this.replaceSeqMap = new HashMap();
        for (MaterialSustituteVO bs : bomSubs) {
            if (this.isReplaceSeq) {
                this.replaceSeqMap.put(new Integer(bs.getSubstituteSeq()), null);
            }
            this.initEntry(bs, this.repDate);
        }
        this.entryInventorySurplusQtyMap = MaterialSustituteHelper.getInventorySurplusQty((String)this.storageOrgUnitId, (List)this.entryMaterialIds, (Date)this.repDate);
        this.initInventorySurplusQty();
        this.setCombinationValue(0);
        this.repaint();
        EditTableUtil.formatColDate((KDTable)this.kDReplaceMaterial, (String[])this.STT_DATES);
    }

    private void initInventorySurplusQty() {
        int entryQtyPrecision = 0;
        BigDecimal entryBaseRate = this.zeroDecimal;
        String materialId = null;
        BigDecimal inventorySurplusBaseQty = this.zeroDecimal;
        BigDecimal inventorySurplusQty = this.zeroDecimal;
        for (int i = 0; i < this.kDReplaceMaterial.getRowCount(); ++i) {
            entryQtyPrecision = this.getRowIndexPrecision(i);
            entryBaseRate = this.getRowIndexBaseRate(i);
            materialId = this.kDReplaceMaterial.getCell(i, STT_MATERIALID).getValue().toString();
            inventorySurplusBaseQty = (BigDecimal)this.entryInventorySurplusQtyMap.get(materialId);
            if (inventorySurplusBaseQty == null) {
                inventorySurplusBaseQty = this.zeroDecimal;
            }
            inventorySurplusQty = inventorySurplusBaseQty.divide(entryBaseRate, entryQtyPrecision, 4);
            this.kDReplaceMaterial.getCell(i, "surplusQty").setValue((Object)inventorySurplusQty);
        }
    }

    private void initHead(MaterialReplaceInfo mri) {
        this.txtLineNo.setText(this.getUIContext().get("lineSeq").toString());
        this.pkDemandDate.setValue((Object)this.repDate);
        this.txtModel.setStringValue(mri.getMaterial().getModel());
        this.prmtMaterial.setValue((Object)mri.getMaterial().getNumber());
        this.prmtUnit.setValue((Object)mri.getUnit().getName());
        this.cmbReplaceMode.setSelectedItem((Object)this.replaceMode);
        this.txtReplaceQty.setValue((Object)this.zeroDecimal);
        try {
            MultiMeasureUnitInfo multiUnifInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(this.materialId, mri.getUnit().getId().toString());
            this.headBaseRate = multiUnifInfo.getBaseConvsRate();
            this.headPrecision = multiUnifInfo.getQtyPrecision();
            this.reqQty = this.reqBaseQty.divide(this.headBaseRate, this.headPrecision, 4);
            this.txtSurplusQty.setValue((Object)this.reqQty);
            this.txtQty.setValue((Object)this.reqQty);
            BigDecimal result = MaterialSustituteHelper.getInventorySurplusQty((String)this.storageOrgUnitId, (String)this.materialId, (BigDecimal)this.headBaseRate, (int)this.headPrecision, (Date)this.repDate);
            if (result.doubleValue() <= 0.0) {
                this.txtCanBeUseQty.setValue((Object)this.zeroDecimal);
            } else {
                this.txtCanBeUseQty.setValue((Object)result);
            }
            for (int i = 0; i < this.initHeadTxtField.length; ++i) {
                KDFormattedTextField field = this.initHeadTxtField[i];
                field.setPrecision(multiUnifInfo.getQtyPrecision());
                field.setHorizontalAlignment(4);
                field.setRemoveingZeroInDispaly(false);
            }
            int precision = 2;
            String colPrecision = PrecisionUtil.getFormatString((int)precision);
            this.kDReplaceMaterial.getColumn(STT_PERPROPORTION).getStyleAttributes().setNumberFormat(colPrecision);
            this.kDReplaceMaterial.getColumn(STT_REPLACESCALE).getStyleAttributes().setNumberFormat(colPrecision);
            this.kDCombination.getColumn(COMREPPRECE).getStyleAttributes().setNumberFormat(colPrecision);
            this.kDCombination.getColumn(COMREPSCALE).getStyleAttributes().setNumberFormat(colPrecision);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initEntry(MaterialSustituteVO bs, Date endDate) throws Exception {
        IRow row = this.kDReplaceMaterial.addRow();
        row.setUserObject((Object)bs);
        row.getCell(STT_MATERIALID).setValue((Object)bs.getSubstituteMaterial().getId().toString());
        this.entryMaterialIds.add(bs.getSubstituteMaterial().getId().toString());
        row.getCell(STT_MATERIALNUM).setValue((Object)bs.getSubstituteMaterial().getNumber());
        row.getCell(STT_MATERIALNAME).setValue((Object)bs.getSubstituteMaterial().getName());
        row.getCell(STT_MODEL).setValue((Object)bs.getSubstituteMaterial().getModel());
        row.getCell(STT_FUNIT).setValue((Object)bs.getSubstituteUnit().getName());
        if (bs.getSubstituteQty().compareTo(this.zeroDecimal) == 1) {
            row.getCell(STT_UNITREPQTY).setValue((Object)bs.getSubstituteQty());
        } else {
            row.getCell(STT_PERPROPORTION).setValue((Object)bs.getSubstituteProportion());
        }
        row.getCell(STT_EFFECTIVEDATE).setValue((Object)bs.getEffectiveDate());
        row.getCell(STT_INVALIDATE).setValue((Object)bs.getInvalidDate());
        if (this.isReplaceSeq) {
            row.getCell(STT_REPLACESEQ).setValue((Object)new Integer(bs.getSubstituteSeq()));
        } else {
            row.getCell(STT_REPLACESCALE).setValue((Object)bs.getSubstitueScale());
        }
        row.getCell("combinationKey").setValue((Object)new Boolean(bs.getCombinationKey()));
        row.getCell(STT_ENTRYID).setValue((Object)bs.getMaterialReplaceId());
        row.getCell(STT_REPLACEBASEQTY).setValue((Object)bs.getBaseReplaceQty());
        this.entryPrecision.put(bs.getMaterialReplaceId(), new Integer(bs.getSubstituteUnit().getQtyPrecision()));
        this.entryBaseRate.put(bs.getMaterialReplaceId(), bs.getToBaseUnitRate());
        row.getCell(STT_UNITREPQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        row.getCell(STT_UNITREPQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        row.getCell("surplusQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        row.getCell("substituteQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)bs.getSubstituteUnit().getQtyPrecision()));
        KDTDefaultCellEditor kdCellUnitNumEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)bs.getSubstituteUnit().getQtyPrecision(), (boolean)false);
        row.getCell("substituteQty").setEditor((ICellEditor)kdCellUnitNumEditor);
    }

    private void setCombinationValue(int rowIndex) {
        String entryId = this.kDReplaceMaterial.getCell(rowIndex, STT_ENTRYID).getValue().toString();
        MaterialReplaceCombinationCollection mrcc = new MaterialReplaceCombinationCollection();
        MaterialReplaceCombinationInfo mrci = null;
        String keyName = null;
        BigDecimal baseConvsRate = this.zeroDecimal;
        int precision = 0;
        BigDecimal surplusQty = this.zeroDecimal;
        BigDecimal sustitueQty = this.zeroDecimal;
        if (this.combinationMap.get(entryId) != null) {
            mrcc = (MaterialReplaceCombinationCollection)((Object)this.combinationMap.get(entryId));
            for (int i = 0; i < mrcc.size(); ++i) {
                mrci = mrcc.get(i);
                if (mrci == null) continue;
                IRow row = this.kDCombination.addRow();
                try {
                    keyName = mrci.getReplaceMaterial().getId().toString() + mrci.getMaterialReplaceEntity().getMeasureUnit().getId().toString();
                    baseConvsRate = (BigDecimal)this.combinationConvsRateMap.get(keyName);
                    precision = (Integer)this.combinationPrecisionMap.get(keyName);
                    row.getCell(COMBOMNUMBER).setValue((Object)mrci.getBom().getNumber());
                    row.getCell(COMBOMNAME).setValue((Object)mrci.getBom().getName());
                    row.getCell(COMMATERIALID).setValue((Object)mrci.getMaterial().getId().toString());
                    row.getCell(COMMATERIALNUMBER).setValue((Object)mrci.getMaterial().getNumber());
                    row.getCell(COMMATERIALNAME).setValue((Object)mrci.getMaterial().getName());
                    row.getCell(COMMATERIALMODEL).setValue((Object)mrci.getMaterial().getModel());
                    row.getCell(COMREPMATERIALID).setValue((Object)mrci.getReplaceMaterial().getId().toString());
                    row.getCell(COMREPMATERIALNUMBER).setValue((Object)mrci.getReplaceMaterial().getNumber());
                    row.getCell(COMREPMATERIALNAME).setValue((Object)mrci.getReplaceMaterial().getName());
                    row.getCell(COMREPMATERIALMODEL).setValue((Object)mrci.getReplaceMaterial().getModel());
                    row.getCell(COMMATERIALREPLACEID).setValue((Object)mrci.getMaterialReplace().getId().toString());
                    row.getCell(COMENTRYID).setValue((Object)mrci.getMaterialReplaceEntity().getId().toString());
                    row.getCell(COMBASEQTY).setValue((Object)mrci.getMaterialReplace().getBaseQty());
                    row.getCell(COMBASEREPLACEQTY).setValue((Object)mrci.getMaterialReplaceEntity().getBaseReplaceQty());
                    row.getCell(COMUNITID).setValue((Object)mrci.getMaterialReplace().getUnit().getId().toString());
                    row.getCell(COMMEASUREUNITID).setValue((Object)mrci.getMaterialReplaceEntity().getMeasureUnit().getId().toString());
                    if (mrci.getMaterialReplaceEntity().getReplaceQty().compareTo(this.zeroDecimal) == 1) {
                        row.getCell(COMREPQTY).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
                        row.getCell(COMREPQTY).setValue((Object)mrci.getMaterialReplaceEntity().getReplaceQty());
                    } else {
                        row.getCell(COMREPPRECE).setValue((Object)mrci.getMaterialReplaceEntity().getReplacePercent());
                    }
                    if (mrci.getMaterialReplace().isIsReplaceSeq()) {
                        row.getCell(COMREPSEQ).setValue((Object)new Integer(mrci.getMaterialReplaceEntity().getReplaceSeq()));
                    } else {
                        row.getCell(COMREPSCALE).setValue((Object)mrci.getMaterialReplaceEntity().getReplaceScale());
                    }
                    row.getCell("combinationKey").setValue((Object)new Boolean(mrci.getMaterialReplaceEntity().isIsCombinationKey()));
                    surplusQty = (BigDecimal)this.combInventorySurplusQtyMap.get(mrci.getReplaceMaterial().getId().toString());
                    if (surplusQty == null) {
                        surplusQty = this.zeroDecimal;
                    }
                    row.getCell("surplusQty").setValue((Object)surplusQty.divide(baseConvsRate, precision, 4));
                    if (this.comSustitueQtyMap.size() > 0 && this.comSustitueQtyMap.get(entryId) != null) {
                        sustitueQty = (BigDecimal)((Map)this.comSustitueQtyMap.get(entryId)).get(mrci.getMaterialReplaceEntity().getId().toString());
                        row.getCell("substituteQty").setValue((Object)sustitueQty.divide(baseConvsRate, precision, 4));
                        row.getCell("substituteBaseQty").setValue((Object)sustitueQty);
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                row.getCell(COMSHORSUPPLY).setValue((Object)new Boolean(mrci.getMaterialReplaceEntity().isIsShortSupplyDis()));
                row.getCell(COMSUPPLYTYPE).setValue((Object)mrci.getMaterialReplaceEntity().getProvideType());
                row.getCell(COMSUPPLYORG).setValue((Object)mrci.getMaterialReplaceEntity().getSupplyOrgUnit().getName());
            }
        }
    }

    @Override
    public void actionAutoAllot_actionPerformed(ActionEvent e) throws Exception {
        this.kDReplaceMaterial.removeKDTPropertyChangeListener(this.kdtEntrysChangeListener);
        for (int j = 0; j < this.kDReplaceMaterial.getRowCount(); ++j) {
            this.kDReplaceMaterial.getCell(j, "substituteQty").setValue(null);
            this.kDReplaceMaterial.getCell(j, "substituteBaseQty").setValue((Object)this.zeroDecimal);
        }
        this.replaceQty = this.zeroDecimal;
        IMaterialReplaceFacade iMaterailReplaceFacade = MaterialReplaceFacadeFactory.getRemoteInstance();
        List replaceMaterialList = null;
        BigDecimal storeQty = this.txtCanBeUseQty.getBigDecimalValue();
        BigDecimal requireQty = this.txtQty.getBigDecimalValue();
        if (this.cmbReplaceMode.getSelectedItem().equals((Object)SubstituteModeEnum.PARTSUBS)) {
            if (storeQty.compareTo(requireQty) >= 0) {
                this.kDReplaceMaterial.addKDTPropertyChangeListener(this.kdtEntrysChangeListener);
                return;
            }
            BigDecimal replaceQty = requireQty.subtract(storeQty);
            BigDecimal replaceBaseQty = replaceQty.multiply(this.headBaseRate).setScale(8, 4);
            replaceMaterialList = iMaterailReplaceFacade.getMaterialReplaceInfo(this.entryInventorySurplusQtyMap, this.materialId, this.bomId, this.repDate, replaceBaseQty, this.storageOrgUnitId);
        } else {
            if (storeQty.compareTo(requireQty) >= 0) {
                this.kDReplaceMaterial.addKDTPropertyChangeListener(this.kdtEntrysChangeListener);
                return;
            }
            replaceMaterialList = iMaterailReplaceFacade.getMaterialReplaceInfo(this.entryInventorySurplusQtyMap, this.materialId, this.bomId, this.repDate, this.reqBaseQty, this.storageOrgUnitId);
        }
        if (replaceMaterialList != null && replaceMaterialList.size() > 0) {
            ReplaceMaterailVO rv = null;
            BigDecimal repQty = this.zeroDecimal;
            BigDecimal qty = this.zeroDecimal;
            MaterialReplaceEntryInfo mri = null;
            String repEntryId = null;
            String combinationKeyEntryId = null;
            String preCombKeyEbtryId = null;
            HashMap<String, BigDecimal> entryQtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> entryBaseQtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> comQtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> comBaseQtyMap = new HashMap<String, BigDecimal>();
            for (int i = 0; i < replaceMaterialList.size(); ++i) {
                rv = (ReplaceMaterailVO)replaceMaterialList.get(i);
                mri = rv.getMaterialReplaceEntryInfo();
                combinationKeyEntryId = rv.getCombinationEntryId();
                if (mri == null) continue;
                repEntryId = mri.getId().toString();
                repQty = rv.getReplaceQty();
                qty = rv.getqty();
                if (combinationKeyEntryId == null) {
                    entryQtyMap.put(repEntryId, repQty);
                    entryBaseQtyMap.put(repEntryId, qty);
                    continue;
                }
                if (!combinationKeyEntryId.equals(preCombKeyEbtryId) && comQtyMap.size() > 0) {
                    this.comSustitueQtyMap.put(preCombKeyEbtryId, comQtyMap);
                    this.comRepBaseQtyMap.put(preCombKeyEbtryId, comBaseQtyMap);
                    comQtyMap = new HashMap();
                    comBaseQtyMap = new HashMap();
                }
                comQtyMap.put(repEntryId, repQty);
                comBaseQtyMap.put(repEntryId, qty);
                preCombKeyEbtryId = combinationKeyEntryId;
            }
            if (combinationKeyEntryId != null) {
                this.comSustitueQtyMap.put(combinationKeyEntryId, comQtyMap);
                this.comRepBaseQtyMap.put(combinationKeyEntryId, comBaseQtyMap);
            }
            this.setEntryReplaceQtyByEntryId(entryQtyMap, entryBaseQtyMap);
            this.kDCombination.removeRows();
            this.setCombinationValue(0);
            this.setHeadQty(this.replaceQty);
        } else {
            for (int j = 0; j < this.kDReplaceMaterial.getRowCount(); ++j) {
                this.kDReplaceMaterial.getCell(j, "substituteQty").setValue(null);
                this.kDReplaceMaterial.getCell(j, "substituteBaseQty").setValue((Object)this.zeroDecimal);
                this.replaceQty = this.zeroDecimal;
            }
        }
        this.kDReplaceMaterial.addKDTPropertyChangeListener(this.kdtEntrysChangeListener);
    }

    private void setEntryReplaceQtyByEntryId(Map entryQtyMap, Map entryBaseQtyMap) {
        String entryId = null;
        BigDecimal baseConvsRate = this.zeroDecimal;
        BigDecimal repQty = this.zeroDecimal;
        BigDecimal qty = this.zeroDecimal;
        int replaceSeq = 0;
        int previousRepSeq = 0;
        int precision = 0;
        boolean isSameRepSeq = false;
        for (int j = 0; j < this.kDReplaceMaterial.getRowCount(); ++j) {
            entryId = (String)this.kDReplaceMaterial.getCell(j, STT_ENTRYID).getValue();
            repQty = (BigDecimal)entryQtyMap.get(entryId);
            qty = (BigDecimal)entryBaseQtyMap.get(entryId);
            if (this.isReplaceSeq) {
                replaceSeq = (Integer)this.kDReplaceMaterial.getCell(j, STT_REPLACESEQ).getValue();
                isSameRepSeq = j != 0 && previousRepSeq == replaceSeq;
                previousRepSeq = replaceSeq;
            }
            if (repQty != null && repQty.compareTo(this.zeroDecimal) == 1) {
                precision = (Integer)this.entryPrecision.get(entryId);
                baseConvsRate = (BigDecimal)this.entryBaseRate.get(entryId);
                this.kDReplaceMaterial.getCell(j, "substituteQty").setValue((Object)repQty);
                this.kDReplaceMaterial.getCell(j, "substituteBaseQty").setValue((Object)repQty.multiply(baseConvsRate).setScale(precision, 4));
                if (isSameRepSeq) continue;
                this.replaceQty = this.replaceQty.add(qty);
                continue;
            }
            this.kDReplaceMaterial.getCell(j, "substituteQty").setValue(null);
            this.kDReplaceMaterial.getCell(j, "substituteBaseQty").setValue((Object)this.zeroDecimal);
        }
    }

    @Override
    public void actionReplace_actionPerformed(ActionEvent e) throws Exception {
        if (this.zeroDecimal.compareTo(this.txtReplaceQty.getBigDecimalValue()) == 0) {
            MsgBox.showInfo((String)this.getResourceMsg("127_replace_qty_not_zero", new String[0]));
            return;
        }
        ArrayList replaceMaterialList = new ArrayList();
        String MaterialNumber = this.prmtMaterial.getValue().toString();
        if (this.replaceMode.getValue() == 10 && this.isReplaceSeq && this.txtSurplusQty.getBigDecimalValue().compareTo(this.zeroDecimal) == 1) {
            MsgBox.showInfo((String)this.getResourceMsg("NoCompletesubs", new String[]{MaterialNumber}));
            return;
        }
        this.setMaterialReplaceHeadIntoList(replaceMaterialList);
        this.setMaterialReplaceEntryIntoList(replaceMaterialList);
        this.setCombnationIntoList(replaceMaterialList);
        if (this.txtSurplusQty.getBigDecimalValue().compareTo(this.zeroDecimal) == -1) {
            int confirmResult = MsgBox.showConfirm3((String)this.getResourceMsg("MoreMaterialReplaceQty", new String[]{MaterialNumber}));
            if (confirmResult == 2) {
                return;
            }
            if (confirmResult == 1) {
                this.getUIContext().put("replaceMaterialList", null);
                this.actionExitCurrent_actionPerformed(e);
                return;
            }
        }
        this.getUIContext().put("replaceMaterialList", replaceMaterialList);
        this.actionExitCurrent_actionPerformed(e);
    }

    private void setMaterialReplaceHeadIntoList(List replaceMaterialList) {
        BigDecimal repQty = this.reqBaseQty.subtract(this.replaceQty);
        ReplaceMaterailVO replaceMaterial = this.getReplaceMaterailVO(0, repQty, this.replaceQty, this.materialId, this.materialId, null, false, false);
        replaceMaterial.setReplaceMode(this.replaceMode);
        replaceMaterialList.add(replaceMaterial);
    }

    private void setMaterialReplaceEntryIntoList(List replaceMaterialList) {
        ReplaceMaterailVO replaceMaterial = null;
        String replaceMaterialId = null;
        String entryId = null;
        BigDecimal repBaseQty = this.zeroDecimal;
        BigDecimal repQty = this.zeroDecimal;
        BigDecimal qty = this.zeroDecimal;
        MaterialReplaceEntryInfo mei = null;
        boolean isCombinationKey = false;
        MaterialReplaceEntryCollection entryCollection = this.mri.getEntry();
        boolean hasReplaceQty = false;
        for (int i = 0; i < this.kDReplaceMaterial.getRowCount(); ++i) {
            IRow row = this.kDReplaceMaterial.getRow(i);
            repBaseQty = (BigDecimal)row.getCell("substituteBaseQty").getValue();
            if (repBaseQty == null || repBaseQty.compareTo(this.zeroDecimal) != 1) continue;
            int seq = 0;
            if (this.isReplaceSeq) {
                seq = (Integer)row.getCell(STT_REPLACESEQ).getValue();
            }
            qty = this.getReplaceHeadQty(i, repBaseQty);
            replaceMaterialId = (String)row.getCell(STT_MATERIALID).getValue();
            repQty = (BigDecimal)row.getCell("substituteQty").getValue();
            entryId = (String)row.getCell(STT_ENTRYID).getValue();
            mei = new MaterialReplaceEntryInfo();
            int count = entryCollection.size();
            for (int j = 0; j < count; ++j) {
                if (!entryCollection.get(j).getId().toString().equals(entryId)) continue;
                mei = entryCollection.get(j);
            }
            isCombinationKey = (Boolean)row.getCell("combinationKey").getValue();
            replaceMaterial = this.getReplaceMaterailVO(seq, repBaseQty, qty, replaceMaterialId, this.materialId, mei, isCombinationKey, isCombinationKey);
            replaceMaterial.setReplaceQty(repQty);
            replaceMaterialList.add(replaceMaterial);
            hasReplaceQty = true;
        }
        if (!hasReplaceQty) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BASEDATAAutoGenerateResource", (String)"51_MaterialReplaceUI"));
            SysUtil.abort();
        }
    }

    private void setCombnationIntoList(List replaceMaterialList) {
        if (this.comSustitueQtyMap.isEmpty()) {
            return;
        }
        String entryId = null;
        String comEntryId = null;
        MaterialReplaceCombinationCollection mrcc = null;
        MaterialReplaceCombinationInfo mrci = null;
        MaterialReplaceEntryInfo mei = null;
        BigDecimal repBaseQty = this.zeroDecimal;
        BigDecimal repQty = this.zeroDecimal;
        BigDecimal qty = this.zeroDecimal;
        ReplaceMaterailVO replaceMaterial = null;
        String replaceMaterialId = null;
        String materialId = null;
        int seq = 0;
        String replaceMaterialUnitId = null;
        BigDecimal entryConvsRate = this.zeroDecimal;
        int entryPrecision = 0;
        String keyName = null;
        HashMap<String, BigDecimal> combReplaceMaterialQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> combReplaceMaterialBaseQtyMap = new HashMap<String, BigDecimal>();
        Map tempMap = new HashMap();
        Map tempBaseMap = new HashMap();
        Iterator qtyIt = this.comSustitueQtyMap.keySet().iterator();
        Iterator tempIt = null;
        String combEntryId = null;
        BigDecimal materialIdAllBaseQty = this.zeroDecimal;
        BigDecimal materialIdAllQty = this.zeroDecimal;
        while (qtyIt.hasNext()) {
            entryId = qtyIt.next().toString();
            tempMap = (Map)this.comSustitueQtyMap.get(entryId);
            tempBaseMap = (Map)this.comRepBaseQtyMap.get(entryId);
            tempIt = tempMap.keySet().iterator();
            while (tempIt.hasNext()) {
                combEntryId = tempIt.next().toString();
                materialIdAllQty = (BigDecimal)tempMap.get(combEntryId);
                materialIdAllBaseQty = (BigDecimal)tempBaseMap.get(combEntryId);
                if (combReplaceMaterialQtyMap != null && combReplaceMaterialQtyMap.get(combEntryId) != null) {
                    materialIdAllQty = materialIdAllQty.add((BigDecimal)combReplaceMaterialQtyMap.get(combEntryId));
                    combReplaceMaterialQtyMap.put(combEntryId, materialIdAllQty);
                    materialIdAllBaseQty = materialIdAllBaseQty.add((BigDecimal)combReplaceMaterialBaseQtyMap.get(combEntryId));
                    combReplaceMaterialBaseQtyMap.put(combEntryId, materialIdAllBaseQty);
                    continue;
                }
                combReplaceMaterialQtyMap.put(combEntryId, materialIdAllQty);
                combReplaceMaterialBaseQtyMap.put(combEntryId, materialIdAllBaseQty);
            }
        }
        Iterator it = this.combinationMap.keySet().iterator();
        while (it.hasNext()) {
            entryId = it.next().toString();
            mrcc = (MaterialReplaceCombinationCollection)((Object)this.combinationMap.get(entryId));
            for (int i = 0; i < mrcc.size(); ++i) {
                mrci = mrcc.get(i);
                comEntryId = mrci.getMaterialReplaceEntity().getId().toString();
                repBaseQty = (BigDecimal)combReplaceMaterialQtyMap.get(comEntryId);
                combReplaceMaterialQtyMap.remove(comEntryId);
                if (repBaseQty == null || repBaseQty.compareTo(this.zeroDecimal) != 1) continue;
                mei = mrci.getMaterialReplaceEntity();
                seq = mei.getReplaceSeq();
                qty = (BigDecimal)combReplaceMaterialBaseQtyMap.get(comEntryId);
                replaceMaterialId = mrci.getReplaceMaterial().getId().toString();
                replaceMaterialUnitId = mei.getMeasureUnit().getId().toString();
                keyName = replaceMaterialId + replaceMaterialUnitId;
                entryConvsRate = (BigDecimal)this.combinationConvsRateMap.get(keyName);
                entryPrecision = (Integer)this.combinationPrecisionMap.get(keyName);
                repQty = repBaseQty.divide(entryConvsRate, entryPrecision, 4);
                materialId = mrci.getMaterial().getId().toString();
                replaceMaterial = this.getReplaceMaterailVO(seq, repBaseQty, qty, replaceMaterialId, materialId, mei, true, mei.isIsCombinationKey());
                replaceMaterial.setReplaceQty(repQty);
                replaceMaterialList.add(replaceMaterial);
            }
        }
    }

    private ReplaceMaterailVO getReplaceMaterailVO(int seq, BigDecimal repQty, BigDecimal qty, String replaceMaterialId, String materialId, MaterialReplaceEntryInfo entryInfo, boolean isCombination, boolean isCombinationKey) {
        ReplaceMaterailVO replaceMaterial = new ReplaceMaterailVO();
        if (this.isReplaceSeq) {
            replaceMaterial.setPriority(seq);
        } else {
            replaceMaterial.setPriority(0);
        }
        replaceMaterial.setReplaceBaseQty(repQty);
        replaceMaterial.setqty(qty);
        replaceMaterial.setReplaceMaterailID(replaceMaterialId);
        replaceMaterial.setRawMaterailID(materialId);
        replaceMaterial.setMaterialReplaceEntryInfo(entryInfo);
        replaceMaterial.setCombination(isCombination);
        replaceMaterial.setKeyMaterial(isCombinationKey);
        return replaceMaterial;
    }

    private String getResourceMsg(String key, String[] params) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key, (String[])params);
    }

    private void materialReplaceEntry_tableClicked(KDTMouseEvent e) {
        this.kDCombination.removeRows();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0) {
            this.setCombinationValue(rowIndex);
        }
    }
}

