/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.DesignModeCollection;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.client.AbstractMfgBomFilterUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MfgBomFilterUI
extends AbstractMfgBomFilterUI {
    private static final long serialVersionUID = 4297577863208945960L;
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";
    private DataChangeListener prmtProjListener = null;
    private DataChangeListener storageOrgUnitChanged = null;
    private DataChangeListener designModeChanged = null;
    private DataChangeListener mainTenanceLevelChanged = null;

    public MfgBomFilterUI() throws Exception {
        this.isReport = false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement pjNumElement = new SingleFilterElement("project.number", (Component)this.prmtProject);
        elements.add((FilterElement)pjNumElement);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.promptStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_view");
        SingleFilterElement designModeElement = new SingleFilterElement("designMode.number", (Component)this.prmtDesignMode);
        elements.add((FilterElement)designModeElement);
        SingleFilterElement mainTenanceLevelElement = new SingleFilterElement("mainTenanceLevel.number", (Component)this.prmtMainTenanceLevel);
        elements.add((FilterElement)mainTenanceLevelElement);
        this.cmbBillStatus.removeAllItems();
        this.cmbBillStatus.addItems(new Object[]{BillBaseStatusEnum.NULL, BillBaseStatusEnum.TEMPORARILYSAVED, BillBaseStatusEnum.SUBMITED, BillBaseStatusEnum.AUDITED, BillBaseStatusEnum.DELETED});
        this.cmbUsageType.removeAllItems();
        this.cmbUsageType.addItems(new Object[]{BOMUsageEnum.Master, BOMUsageEnum.Other, BOMUsageEnum.BackingOut, BOMUsageEnum.maintaining, BOMUsageEnum.NULL});
        this.cmbUsageType.setSelectedItem((Object)BOMUsageEnum.NULL);
        this.setBizMaterialF7(this.prmptMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmptMaterialTo, false, null);
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmptNumFrom, (Component)this.prmptNumTo));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cmbBillStatus, (Object)BillBaseStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("usageType", (Component)this.cmbUsageType, (Object)BOMUsageEnum.NULL));
        elements.add((FilterElement)new MMRangeFilterElement("material.number", (Component)this.prmptMaterialFrom, (Component)this.prmptMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("BOMGROUP.number", (Component)this.prmpbomGroup));
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.promptStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, MfgBomFilterUI.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.initProjectTrackF7();
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmptNumFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmptNumTo, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmptMaterialFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmptMaterialTo, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmpbomGroup, this.getPropertyOfMainBizOrg());
        this.prmptNumFrom.setCommitFormat("$number$");
        this.prmptNumTo.setCommitFormat("$number$");
        this.prmptNumFrom.setHasCUDefaultFilter(false);
        this.prmptNumTo.setHasCUDefaultFilter(false);
        this.prmtDesignMode.setRequired(false);
        this.initMainTenanceLevelFilters();
    }

    private void initMainTenanceLevelFilters() {
        MfgBomUtil.initPrmtMainTenanceFilters(this.prmtMainTenanceLevel);
    }

    public void clear() {
        super.clear();
        try {
            this.prmtDesignMode.setValue((Object)MfgBomUtil.getDefaultDesignMode(null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initProjectTrackF7() {
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.promptStorageOrgUnit, (KDBizPromptBox)this.prmtProject);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.promptStorageOrgUnit, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTrackNumber, (boolean)false);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        this.prmtDesignMode.setEnabledMultiSelection(true);
        this.prmtProject.setEnabledMultiSelection(true);
        this.prmtTrackNumber.setEnabledMultiSelection(true);
        return this.promptStorageOrgUnit;
    }

    private void initF7Material(OrgUnitInfo orgInfo, Set<String> orgIDSet) {
        this.entityViewInfo = new EntityViewInfo();
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(this.prmptMaterialFrom, null, materialPlanQuery, null, false);
        this.f7Manager.registerBizMaterialF7(this.prmptMaterialTo, null, materialPlanQuery, null, false);
        FilterInfo filterInfo = new FilterInfo();
        if (orgIDSet != null && orgIDSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", orgIDSet, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        String sMask = "#0 and #1 ";
        Set<String> designModeIDSet = this.getDesignModeIDSet(this.prmtDesignMode.getValue());
        if (designModeIDSet != null && designModeIDSet.size() >= 1) {
            Map dataMap = null;
            try {
                dataMap = MfgBomUtil.getDesignModeManufactureStrategySet(null, designModeIDSet);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (dataMap == null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("manufactureStrategy.id", null, CompareType.EQUALS));
                sMask = sMask + " and #2 ";
            } else {
                HashSet manufactureStrategyIDSet = (HashSet)dataMap.get("manufactureStrategyIDSet");
                HashSet isolatedRuleSet = (HashSet)dataMap.get("isolatedRuleSet");
                filterInfo.getFilterItems().add(new FilterItemInfo("manufactureStrategy.id", (Object)manufactureStrategyIDSet, CompareType.INCLUDE));
                if (isolatedRuleSet != null && isolatedRuleSet.contains("NONE")) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("plan.isolatedRule", (Object)"NONE", CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("plan.isolatedRule", (Object)isolatedRuleSet, CompareType.INCLUDE));
                    sMask = sMask + " and #2  and ( #3 or #4 )";
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("plan.isolatedRule", (Object)isolatedRuleSet, CompareType.INCLUDE));
                    sMask = sMask + " and #2  and #3 ";
                }
            }
        }
        filterInfo.setMaskString(sMask);
        this.entityViewInfo.setFilter(filterInfo);
        this.prmptMaterialFrom.setEntityViewInfo(this.entityViewInfo);
        this.prmptMaterialTo.setEntityViewInfo(this.entityViewInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)8, CompareType.EQUALS));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        this.prmtDesignMode.setEntityViewInfo(env);
    }

    private void initF7BomNumber(StorageOrgUnitInfo[] orgInfos) {
        Set<String> mainTenanceLevelIDSet;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (orgInfos != null && orgInfos.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < orgInfos.length; ++i) {
                idSet.add(orgInfos[i].getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", idSet, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
        }
        Set<String> designModeIDSet = this.getDesignModeIDSet(this.prmtDesignMode.getValue());
        if (designModeIDSet != null && designModeIDSet.size() >= 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("designMode.id", designModeIDSet, CompareType.INCLUDE));
        }
        if ((mainTenanceLevelIDSet = this.getMainTenanceLevelIDSet(this.prmtMainTenanceLevel.getValue())) != null && mainTenanceLevelIDSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("mainTenanceLevel.id", mainTenanceLevelIDSet, CompareType.INCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        this.prmptNumFrom.setEntityViewInfo(viewInfo);
        this.prmptNumFrom.getQueryAgent().resetRuntimeEntityView();
        this.prmptNumFrom.setRefresh(true);
        this.prmptNumTo.setEntityViewInfo(viewInfo);
        this.prmptNumTo.getQueryAgent().resetRuntimeEntityView();
        this.prmptNumTo.setRefresh(true);
    }

    protected void initListener() {
        super.initListener();
        this.promptStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        if (this.storageOrgUnitChanged == null) {
            this.storageOrgUnitChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        MfgBomFilterUI.this.prmtStorageOrgUnit_dataChanged(e);
                    }
                    catch (Exception exc) {
                        MfgBomFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.promptStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.prmtDesignMode.removeDataChangeListener(this.designModeChanged);
        if (this.designModeChanged == null) {
            this.designModeChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        MfgBomFilterUI.this.prmtDesignMode_dataChanged(e);
                    }
                    catch (Exception exc) {
                        MfgBomFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtDesignMode.addDataChangeListener(this.designModeChanged);
        if (this.mainTenanceLevelChanged != null) {
            this.prmtMainTenanceLevel.removeDataChangeListener(this.mainTenanceLevelChanged);
        }
        if (this.mainTenanceLevelChanged == null) {
            this.mainTenanceLevelChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        MfgBomFilterUI.this.prmtMainTenanceLevel_dataChanged(e);
                    }
                    catch (Exception exc) {
                        MfgBomFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtMainTenanceLevel.addDataChangeListener(this.mainTenanceLevelChanged);
        if (this.prmtProjListener == null) {
            this.prmtProjListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        MfgBomFilterUI.this.selectProjNumber(e);
                    }
                    catch (Exception e1) {
                        MfgBomFilterUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.prmtProject.addDataChangeListener(this.prmtProjListener);
        this.prmptMaterialFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MfgBomFilterUI.this.setMaterialFilter();
            }
        });
        this.prmptMaterialFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                MfgBomFilterUI.this.setMaterialFilter();
            }
        });
        this.prmptMaterialTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MfgBomFilterUI.this.setMaterialFilter();
            }
        });
        this.prmptMaterialTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                MfgBomFilterUI.this.setMaterialFilter();
            }
        });
        this.prmptNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MfgBomFilterUI.this.setBomNumberFilter();
            }
        });
        this.prmptNumFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                MfgBomFilterUI.this.setBomNumberFilter();
            }
        });
        this.prmptNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MfgBomFilterUI.this.setBomNumberFilter();
            }
        });
        this.prmptNumTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                MfgBomFilterUI.this.setBomNumberFilter();
            }
        });
    }

    private void setBomNumberFilter() {
        Object storageOrgUnitObj = this.promptStorageOrgUnit.getValue();
        if (storageOrgUnitObj == null) {
            return;
        }
        if (storageOrgUnitObj instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])storageOrgUnitObj;
            StorageOrgUnitInfo[] objValues = new StorageOrgUnitInfo[orgUnitInfos.length];
            StorageOrgUnitInfo storage = null;
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                storage = new StorageOrgUnitInfo();
                storage.setId(orgUnitInfos[i].getId());
                objValues[i] = storage;
            }
            this.initF7BomNumber(objValues);
        } else if (storageOrgUnitObj instanceof StorageOrgUnitInfo) {
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)storageOrgUnitObj;
            this.initF7BomNumber(new StorageOrgUnitInfo[]{storageOrgUnitInfo});
        } else if (storageOrgUnitObj instanceof Object[]) {
            Object[] storageObjs = (Object[])storageOrgUnitObj;
            if (storageObjs.length == 1 && storageObjs[0] == null) {
                return;
            }
            StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[storageObjs.length];
            System.arraycopy(storageObjs, 0, storageOrgUnitInfos, 0, storageObjs.length);
            this.initF7BomNumber(storageOrgUnitInfos);
        }
    }

    private Set<String> getDesignModeIDSet(Object designModeObject) {
        HashSet<String> idSet;
        block5: {
            block6: {
                block4: {
                    if (designModeObject == null) {
                        return null;
                    }
                    idSet = new HashSet<String>();
                    if (!(designModeObject instanceof DesignModeInfo[])) break block4;
                    DesignModeInfo[] designModeInfos = (DesignModeInfo[])designModeObject;
                    for (int i = 0; i < designModeInfos.length; ++i) {
                        idSet.add(designModeInfos[i].getId().toString());
                    }
                    break block5;
                }
                if (!(designModeObject instanceof DesignModeInfo)) break block6;
                DesignModeInfo dsInfo = (DesignModeInfo)designModeObject;
                idSet.add(dsInfo.getId().toString());
                break block5;
            }
            if (!(designModeObject instanceof Object[])) break block5;
            Object[] designObjs = (Object[])designModeObject;
            if (designObjs.length == 1 && designObjs[0] == null) {
                return null;
            }
            DesignModeInfo[] designModeInfos = new DesignModeInfo[designObjs.length];
            System.arraycopy(designObjs, 0, designModeInfos, 0, designObjs.length);
            for (int i = 0; i < designModeInfos.length; ++i) {
                idSet.add(designModeInfos[i].getId().toString());
            }
        }
        return idSet;
    }

    private Set<String> getMainTenanceLevelIDSet(Object mainTenanceLevelObject) {
        HashSet<String> idSet;
        block5: {
            block6: {
                block4: {
                    if (mainTenanceLevelObject == null) {
                        return null;
                    }
                    idSet = new HashSet<String>();
                    if (!(mainTenanceLevelObject instanceof MainTenanceLevelInfo[])) break block4;
                    MainTenanceLevelInfo[] mainTenanceLevelInfos = (MainTenanceLevelInfo[])mainTenanceLevelObject;
                    for (int i = 0; i < mainTenanceLevelInfos.length; ++i) {
                        idSet.add(mainTenanceLevelInfos[i].getId().toString());
                    }
                    break block5;
                }
                if (!(mainTenanceLevelObject instanceof MainTenanceLevelInfo)) break block6;
                MainTenanceLevelInfo mainTenanceLevelInfo = (MainTenanceLevelInfo)mainTenanceLevelObject;
                idSet.add(mainTenanceLevelInfo.getId().toString());
                break block5;
            }
            if (!(mainTenanceLevelObject instanceof Object[])) break block5;
            Object[] mainTenanceLevelObjs = (Object[])mainTenanceLevelObject;
            if (mainTenanceLevelObjs.length == 1 && mainTenanceLevelObjs[0] == null) {
                return null;
            }
            MainTenanceLevelInfo[] mainTenanceLevelInfos = new MainTenanceLevelInfo[mainTenanceLevelObjs.length];
            System.arraycopy(mainTenanceLevelObjs, 0, mainTenanceLevelInfos, 0, mainTenanceLevelObjs.length);
            for (int i = 0; i < mainTenanceLevelInfos.length; ++i) {
                idSet.add(mainTenanceLevelInfos[i].getId().toString());
            }
        }
        return idSet;
    }

    private void setMaterialFilter() {
        if (null != this.promptStorageOrgUnit.getValue()) {
            HashSet<String> orgIDSet = new HashSet<String>();
            if (this.promptStorageOrgUnit.getValue() instanceof Object[]) {
                Object[] objValues = (Object[])this.promptStorageOrgUnit.getValue();
                for (int i = 0; i < objValues.length; ++i) {
                    orgIDSet.add(((OrgUnitInfo)objValues[i]).getId().toString());
                }
                this.initF7Material((OrgUnitInfo)objValues[0], orgIDSet);
            } else if (this.promptStorageOrgUnit.getValue() instanceof Object) {
                Object objValue = this.promptStorageOrgUnit.getValue();
                orgIDSet.add(((OrgUnitInfo)objValue).getId().toString());
                this.initF7Material((OrgUnitInfo)objValue, orgIDSet);
            }
        }
    }

    private void selectProjNumber(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (e.getNewValue() == null || isDiffrent) {
            this.prmtTrackNumber.setValue(null);
        }
    }

    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getNewValue());
        if (isDiffrent) {
            this.prmptNumFrom.setValue(null);
            this.prmptNumTo.setValue(null);
            this.prmptMaterialFrom.setValue(null);
            this.prmptMaterialTo.setValue(null);
            this.prmpbomGroup.setValue(null);
            this.setBomNumberFilter();
        }
    }

    protected void prmtMainTenanceLevel_dataChanged(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getNewValue());
        if (isDiffrent) {
            this.setBomNumberFilter();
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_bom_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public boolean verify() {
        return super.verify();
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BasedataResource", (String)strKey);
    }

    public String getBizOrgPropertyName() {
        return "storageOrgUnit.id";
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.promptStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        this.prmtDesignMode.removeDataChangeListener(this.designModeChanged);
        this.prmtMainTenanceLevel.removeDataChangeListener(this.mainTenanceLevelChanged);
        super.loadData(entityViewInfo);
        this.promptStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.prmtDesignMode.addDataChangeListener(this.designModeChanged);
        this.prmtMainTenanceLevel.addDataChangeListener(this.mainTenanceLevelChanged);
    }

    protected void prmtDesignMode_dataChanged(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getNewValue());
        if (isDiffrent) {
            Set<String> idSet;
            this.prmptNumFrom.setValue(null);
            this.prmptNumTo.setValue(null);
            this.prmptMaterialFrom.setValue(null);
            this.prmptMaterialTo.setValue(null);
            this.prmtProject.setValue(null);
            this.prmtTrackNumber.setValue(null);
            if (e.getNewValue() != null && (idSet = this.getDesignModeIDSet(e.getNewValue())) != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                DesignModeCollection dsColl = DesignModeFactory.getRemoteInstance().getDesignModeCollection(view);
                if (dsColl != null && dsColl.size() == 1) {
                    if (dsColl.get(0).isProject()) {
                        this.prmtProject.setVisible(true);
                        this.prmtProject.setEnabled(true);
                        this.contProject.setVisible(true);
                    } else {
                        this.prmtProject.setVisible(false);
                        this.prmtProject.setEnabled(false);
                        this.contProject.setVisible(false);
                    }
                    if (!dsColl.get(0).isProject() && dsColl.get(0).isTrackNumber()) {
                        this.prmtTrackNumber.setVisible(true);
                        this.prmtTrackNumber.setEnabled(true);
                        this.kDLabelContainer13.setVisible(true);
                    } else {
                        this.prmtTrackNumber.setVisible(false);
                        this.prmtTrackNumber.setEnabled(false);
                        this.kDLabelContainer13.setVisible(false);
                    }
                }
            }
            this.setBomNumberFilter();
        }
    }
}

