/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.mm.basedata.client.MultiInsertAfterSelectSupport;
import com.kingdee.eas.scm.common.util.LongtimeIndicator;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MultiInsertAfterSelectManager {
    private static final Logger logger = Logger.getLogger(MultiInsertAfterSelectManager.class);
    private MultiInsertAfterSelectSupport support;

    public MultiInsertAfterSelectManager(MultiInsertAfterSelectSupport support) {
        this.support = support;
    }

    public void setMultiInsertAfterSelectSupport(MultiInsertAfterSelectSupport support) {
        this.support = support;
    }

    public MultiInsertAfterSelectSupport getMultiInsertAfterSelectSupport() {
        return this.support;
    }

    public void fireDataChanged(final KDTable table, final String colname, final DataChangeListener dataChangeListener, DataChangeEvent event) {
        try {
            int rowIndex;
            final KDBizPromptBox bizBox = (KDBizPromptBox)event.getSource();
            KDTSelectBlock block = table.getSelectManager().get();
            if (block != null && (rowIndex = block.getBeginRow()) >= 0) {
                if (bizBox.getValue() == null) {
                    this.support.clearAfterSelect(table, rowIndex, colname);
                    return;
                }
                IObjectValue[] array = null;
                if (bizBox.getValue() instanceof IObjectValue[]) {
                    array = (IObjectValue[])bizBox.getValue();
                } else if (bizBox.getValue() instanceof Object[]) {
                    Object[] objects = (Object[])bizBox.getValue();
                    array = new IObjectValue[objects.length];
                    System.arraycopy(objects, 0, array, 0, objects.length);
                } else if (bizBox.getValue() instanceof IObjectValue) {
                    array = new IObjectValue[]{(IObjectValue)bizBox.getValue()};
                }
                if (array != null) {
                    Object o;
                    ICell cell;
                    if (array.length == 1 && (cell = table.getRow(rowIndex).getCell(colname)) != null && (o = cell.getValue()) != null && o instanceof IObjectValue && array[0].get("id").toString().equals(((IObjectValue)o).get("id").toString())) {
                        return;
                    }
                    if (array.length >= 5) {
                        LongtimeIndicator waiting = new LongtimeIndicator();
                        final IObjectValue[] ovs = array;
                        waiting.letMeDo(new ILongTimeTask(){

                            public Object exec() throws Exception {
                                MultiInsertAfterSelectManager.this.performDataChanged(table, rowIndex, colname, ovs, bizBox, dataChangeListener);
                                return new Boolean(true);
                            }

                            public void afterExec(Object result) throws Exception {
                            }
                        });
                        waiting.doJob();
                    } else {
                        this.performDataChanged(table, rowIndex, colname, array, bizBox, dataChangeListener);
                    }
                }
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performDataChanged(KDTable table, int selectedRow, String colname, IObjectValue[] array, KDBizPromptBox bizBox, DataChangeListener dataChangeListener) throws Exception {
        if ((array = this.support.verifyAfterSelect(table, selectedRow, colname, array)) == null || array.length == 0) {
            bizBox.setValue(null);
            return;
        }
        HashMap<IObjectValue, Exception> beforeExceptionMap = new HashMap<IObjectValue, Exception>();
        HashMap<IObjectValue, Exception> afterExceptionMap = new HashMap<IObjectValue, Exception>();
        KDTSelectBlock ksb = table.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow curRow = table.getRow(beginRow);
        int curCol = table.getColumnIndex(colname);
        bizBox.removeDataChangeListener(dataChangeListener);
        int length = array.length;
        if (length > 0) {
            IRow curRow2 = null;
            IObjectValue value = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.insertLine(table, beginRow + insertedRowCount);
                    needInsert = false;
                }
                value = array[i];
                curRow2 = table.getRow(beginRow + insertedRowCount);
                if (array[i] == null) {
                    curRow2.getCell(curCol).setValue((Object)value);
                    curRow2.getCell(curCol).setValue(null);
                    return;
                }
                curRow2.getCell(curCol).setValue(null);
                try {
                    this.beforeInsertUserObject(value);
                    curRow2.getCell(curCol).setValue((Object)value);
                }
                catch (Exception ex) {
                    curRow2.getCell(curCol).setValue((Object)value);
                    curRow2.getCell(curCol).setValue(null);
                    beforeExceptionMap.put(value, ex);
                    continue;
                }
                finally {
                    try {
                        this.afterInsertUserObject(beginRow + insertedRowCount);
                    }
                    catch (Exception ex) {
                        afterExceptionMap.put(value, ex);
                    }
                }
                needInsert = true;
                ++insertedRowCount;
            }
            if (!needInsert && insertedRowCount > 0) {
                this.removeLine(table, beginRow + insertedRowCount);
            }
            if (beforeExceptionMap != null && beforeExceptionMap.size() > 0) {
                this.handleBeforeInsertRowException(beforeExceptionMap);
            }
            if (afterExceptionMap != null && afterExceptionMap.size() > 0) {
                this.handleAfterInsertRowException(afterExceptionMap);
            }
            this.support.multiInsertAfterSelect(table, beginRow, colname, array);
        } else {
            curRow.getCell(curCol).setValue((Object)this.support.createUserObject(table));
            curRow.getCell(curCol).setValue(null);
            this.afterInsertUserObject(beginRow);
        }
        bizBox.addDataChangeListener(dataChangeListener);
    }

    protected void insertLine(KDTable table, int rowIndex) {
        if (table != null) {
            IObjectValue value = this.support.createUserObject(table);
            table.addRow(rowIndex);
            this.support.bindUserObject(table, rowIndex, value);
            this.afterInsertLine(table, value);
        }
    }

    protected void removeLine(KDTable table, int rowIndex) {
        if (table != null && table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue value = (IObjectValue)table.getRow(rowIndex).getUserObject();
            this.beforeRemoveLine(table, value);
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection is not be binded to table");
            } else if (value != null) {
                collection.removeObject(value);
            }
            this.afterRemoveLine(table, value);
        }
    }

    protected void beforeInsertUserObject(IObjectValue value) throws Exception {
    }

    protected void afterInsertUserObject(int rowIndex) throws Exception {
    }

    protected void afterInsertLine(KDTable table, IObjectValue value) {
    }

    protected void beforeRemoveLine(KDTable talbe, IObjectValue value) {
    }

    protected void afterRemoveLine(KDTable table, IObjectValue value) {
    }

    protected void handleAfterInsertRowException(HashMap afterExceptionMap) {
        this.showExceptionMessage(afterExceptionMap);
    }

    protected void handleBeforeInsertRowException(HashMap beforeExceptionMap) {
        this.showExceptionMessage(beforeExceptionMap);
    }

    protected void showExceptionMessage(HashMap exceptionMap) {
        if (exceptionMap != null && exceptionMap.size() > 0) {
            StringBuffer exMsg = new StringBuffer();
            Iterator keyIt = exceptionMap.keySet().iterator();
            IObjectValue value = null;
            Exception ex = null;
            boolean isFirst = true;
            while (keyIt.hasNext()) {
                if (!isFirst) {
                    exMsg.append("\n");
                } else {
                    isFirst = false;
                }
                value = (IObjectValue)keyIt.next();
                ex = (Exception)exceptionMap.get(value);
                exMsg.append(value.get("name")).append(":").append(ex.getMessage());
            }
            if (exMsg.length() > 0) {
                MsgBox.showInfo((String)exMsg.toString());
            }
        }
    }
}

