/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.client.AbstractOperationEditBatchUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class OperationEditBatchUI
extends AbstractOperationEditBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(OperationEditBatchUI.class);
    private List map = new ArrayList();
    private StorageOrgUnitInfo currStorageInfo = null;
    private int selectedCount = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed();
        this.btnAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnUnAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAll.setEnabled(true);
        this.btnUnAll.setEnabled(false);
        this.chkControlStrategy.setSelected(true);
        this.chkKeyOperation.setSelected(true);
        this.chkWorkCenter.setSelected(true);
        KDCheckBox chkBox = new KDCheckBox();
        this.kDTable1.getColumn("selected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkBox));
        this.kDTable1.getColumn("selected").setWidth(50);
        this.map = (List)this.getUIContext().get("map");
        this.currStorageInfo = (StorageOrgUnitInfo)this.getUIContext().get("storageid");
        this.initData();
        this.kDTable1.getActionMap().remove("Delete");
    }

    private void initData() throws BOSException, Exception {
        IRowSet rs = StandardRootingFactory.getRemoteInstance().getStandardRooting(this.map, this.currStorageInfo);
        this.kDTable1.removeRows();
        while (rs.next()) {
            IRow row = this.kDTable1.addRow();
            row.getCell("selected").setValue((Object)new Boolean(false));
            row.getCell("number").setValue((Object)rs.getString("sFNumber"));
            row.getCell("name").setValue((Object)rs.getString("sFName"));
            row.getCell("isMainRooting").setValue((Object)new Boolean(rs.getBoolean("FIsMainRooting")));
            row.getCell("materialNumber").setValue((Object)rs.getString("mFNumber"));
            row.getCell("materialName").setValue((Object)rs.getString("mFName"));
            row.getCell("status").setValue((Object)rs.getString("sStatus"));
            row.getCell("operation").setValue((Object)rs.getString("pFWpSeq"));
            row.getCell("operationNumber").setValue((Object)rs.getString("oFNumber"));
            row.getCell("operationName").setValue((Object)rs.getString("oFName"));
            row.getCell("workCenter").setValue((Object)rs.getString("wFName"));
            row.getCell("keyOperation").setValue((Object)new Boolean(rs.getBoolean("pFIsImportantWP")));
            row.getCell("storage").setValue((Object)rs.getString("storageFNumber"));
            row.getCell("id").setValue((Object)rs.getString("oFid"));
            row.getCell("sid").setValue((Object)rs.getString("sFID"));
            row.getCell("cFName").setValue((Object)rs.getString("cFName"));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandardRootingFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void actionAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable1.getRowCount3(); ++i) {
            this.kDTable1.getRow(i).getCell("selected").setValue((Object)Boolean.TRUE);
        }
        this.selectedCount = this.kDTable1.getRowCount3();
        this.enableSelectAllAndNoneAction();
    }

    private void enableSelectAllAndNoneAction() {
        this.btnAll.setEnabled(this.kDTable1.getRowCount3() > 0);
        this.btnUnAll.setEnabled(this.selectedCount > 0);
    }

    @Override
    public void actionUnAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable1.getRowCount3(); ++i) {
            this.kDTable1.getRow(i).getCell("selected").setValue((Object)Boolean.FALSE);
        }
        this.selectedCount = 0;
        this.enableSelectAllAndNoneAction();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        List successList;
        List workCenterList;
        List errorList;
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<Object> standList = new ArrayList<Object>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            if (!Boolean.valueOf(true).equals(this.kDTable1.getRow(i).getCell(0).getValue())) continue;
            if (!list.contains(this.kDTable1.getRow(i).getCell("id").getValue())) {
                list.add(this.kDTable1.getRow(i).getCell("id").getValue());
            }
            if (standList.contains(this.kDTable1.getRow(i).getCell("sid").getValue())) continue;
            standList.add(this.kDTable1.getRow(i).getCell("sid").getValue());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)this.getResource("UPDATE_STANDARDROOTING"));
            return;
        }
        boolean workCenter = this.chkWorkCenter.isSelected();
        boolean controlStrategy = this.chkControlStrategy.isSelected();
        boolean keyOperation = this.chkKeyOperation.isSelected();
        if (!(workCenter || controlStrategy || keyOperation)) {
            return;
        }
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
        paramMap.put("workCenter", new Boolean(workCenter));
        paramMap.put("controlStrategy", new Boolean(controlStrategy));
        paramMap.put("keyOperation", new Boolean(keyOperation));
        Map resultMap = StandardRootingFactory.getRemoteInstance().batchUpdateStandardRooting(paramMap, list, this.currStorageInfo, standList);
        List failList = (List)resultMap.get("fail");
        if (failList != null && failList.size() > 0) {
            MsgBox.showInfo((String)this.getResource("UPDATE_FAIL"));
        }
        if ((errorList = (List)resultMap.get("errorList")) != null && errorList.size() > 0) {
            MsgBox.showInfo((String)this.getResource("UPDATE_FAIL_EDIT"));
        }
        if ((workCenterList = (List)resultMap.get("workCenterList")) != null && workCenterList.size() > 0) {
            for (int i = 0; i < workCenterList.size(); ++i) {
                OperationInfo info = OperationFactory.getRemoteInstance().getOperationInfo((IObjectPK)new ObjectStringPK(workCenterList.get(i).toString()));
                String msg = this.getResource("Update_WorkCenter");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showInfo((String)msgFmt.format(new Object[]{info.getNumber()}));
            }
        }
        if ((successList = (List)resultMap.get("total")) != null && successList.size() > 0) {
            String msg = this.getResource("UPDATE_SUCCESS");
            MessageFormat msgFmt = new MessageFormat(msg);
            MsgBox.showInfo((String)msgFmt.format(new Integer[]{new Integer(successList.size())}));
            this.initData();
        }
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.StandardRootingResource", (String)sKey);
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.kDTable1.getViewManager().getFreezeCol() <= 0) {
            KDTableUtils.setDefaultFreezeCol((KDTable)this.kDTable1, (int)6);
        }
    }
}

