/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.IOrderBomCompleteCheckFacade;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.OrderBomCompleteCheckFacadeFactory;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomCompleteCheckUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.Set;

public class OrderBomCompleteCheckUI
extends AbstractOrderBomCompleteCheckUI {
    private static final long serialVersionUID = 3501511581507849358L;
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";
    private DataChangeListener prmtStorageOrgUnitListener = null;
    private static final String TB_MATERIALID = "materialID";
    private static final String TB_PROJECTID = "projectID";
    private static final String TB_TRACKID = "trackNumberID";
    private static final String TB_STORAGEORGUNITID = "storageOrgUnit";
    private static final String TB_MATERIALNUM = "materialNum";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIAL_MODEL = "modelType";
    private static final String TB_MATERIAL_ATTR = "materialArr";
    private static final String TB_ERRORMSG = "errMessage";

    private void removeListener() {
        if (this.prmtStorageOrgUnitListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.prmtStorageOrgUnitListener);
        }
    }

    private void addListener() {
        if (this.prmtStorageOrgUnitListener == null) {
            this.prmtStorageOrgUnitListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    try {
                        OrderBomCompleteCheckUI.this.prmtStorageOrgUnit_dataChange(event);
                    }
                    catch (Exception e) {
                        OrderBomCompleteCheckUI.this.handUIExceptionAndAbort(e);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.prmtStorageOrgUnitListener);
    }

    private void prmtStorageOrgUnit_dataChange(DataChangeEvent event) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)event.getNewValue(), (Object)event.getOldValue());
        if (isDiffrent) {
            this.errBomList.removeRows();
        }
    }

    private boolean isExistRow(String materialId, String projectId, String trackId) {
        String track1;
        boolean ret = false;
        int rowCount = this.errBomList.getRowCount();
        boolean isComparePT = true;
        String project1 = projectId;
        if (project1 == null) {
            project1 = "999999999";
        }
        if ((track1 = trackId) == null) {
            track1 = "999999999";
        }
        if (project1 == "999999999" && track1 == "999999999") {
            isComparePT = false;
        }
        for (int i = 0; i < rowCount; ++i) {
            String track2;
            String materialId2 = (String)this.errBomList.getRow(i).getCell(TB_MATERIALID).getValue();
            String project2 = (String)this.errBomList.getRow(i).getCell(TB_PROJECTID).getValue();
            if (project2 == null) {
                project2 = "999999999";
            }
            if ((track2 = (String)this.errBomList.getRow(i).getCell(TB_TRACKID).getValue()) == null) {
                track2 = "999999999";
            }
            if (isComparePT) {
                if (!materialId.equals(materialId2) || !project1.equals(project2) || !track1.equals(track2)) continue;
                ret = true;
                break;
            }
            if (!materialId.equals(materialId2)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    public void actionCompleteCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionCompleteCheck_actionPerformed(e);
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)BOM_RESOURCE_PATH, (String)"storageOrgUnit_Required"));
            this.prmtStorageOrgUnit.requestFocus(true);
            SysUtil.abort();
            return;
        }
        this.errBomList.removeRows();
        this.setMessageText(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"completeCheck.checking"));
        IOrderBomCompleteCheckFacade iOrderBomCC = OrderBomCompleteCheckFacadeFactory.getRemoteInstance();
        this.showMessage();
        IRowSet errOrderBomRowSet1 = null;
        IRowSet errOrderBomRowSet2 = null;
        StorageOrgUnitInfo storageOrgUnit = null;
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            String strStorageOrgUnitId = storageOrgUnit.getId().toString();
            errOrderBomRowSet1 = iOrderBomCC.getBomCompleteCheckList(strStorageOrgUnitId, OrderBomCompleteCheckUI.getDefaultLocale());
            errOrderBomRowSet2 = iOrderBomCC.getNoMasterBomMaterialList(strStorageOrgUnitId, OrderBomCompleteCheckUI.getDefaultLocale());
        }
        this.setMessageText(EASResource.getString((String)BOM_RESOURCE_PATH, (String)"completeCheck.checked"));
        this.showMessage();
        this.errBomList.setColumnMoveable(false);
        this.setInfo2Table(storageOrgUnit, errOrderBomRowSet1, errOrderBomRowSet2);
    }

    public void setInfo2Table(StorageOrgUnitInfo storageOrgUnit, IRowSet errOrderBomRowSet1, IRowSet errOrderBomRowSet2) throws Exception {
        String materialId;
        Locale locale = SysContext.getSysContext().getLocale();
        if (errOrderBomRowSet1 != null) {
            while (errOrderBomRowSet1.next()) {
                String trackNumber;
                Set noOrderBomStrategySet;
                materialId = errOrderBomRowSet1.getString("FMATERIALID");
                String materialNumber = errOrderBomRowSet1.getString("FMATERIALNUMBER");
                String materialName = errOrderBomRowSet1.getString("FMATERIALNAME");
                String materialModel = errOrderBomRowSet1.getString("FMATERIALMODEL");
                String materialAttr = MaterialAttributeEnum.getEnum((int)errOrderBomRowSet1.getInt("FMATERIALATTR")).getAlias(OrderBomCompleteCheckUI.getDefaultLocale());
                int bomTye = errOrderBomRowSet1.getInt("FBomType");
                boolean isConfigable = errOrderBomRowSet1.getBoolean("FIsConfigable");
                String manuStrategy = errOrderBomRowSet1.getString("FManufactureStrategyID");
                if (com.kingdee.eas.mm.common.util.MMUtils.isEmptyString((String)manuStrategy)) {
                    manuStrategy = "NUnM+gEcEADgAA3cwKgL09g0uEU=";
                }
                if ((noOrderBomStrategySet = ManufactureStrategyGroup.getNoOrderBomStrategyIdSet()).contains(manuStrategy)) {
                    boolean isExist = this.isExistRow(materialId, null, null);
                    if (isExist || bomTye != 40) continue;
                    IRow row = this.errBomList.addRow();
                    row.getCell(TB_STORAGEORGUNITID).setValue((Object)storageOrgUnit.getName(OrderBomCompleteCheckUI.getDefaultLocale()));
                    row.getCell(TB_MATERIALNUM).setValue((Object)materialNumber);
                    row.getCell(TB_MATERIALNAME).setValue((Object)materialName);
                    row.getCell(TB_MATERIAL_MODEL).setValue((Object)materialModel);
                    row.getCell(TB_MATERIAL_ATTR).setValue((Object)materialAttr);
                    row.getCell(TB_ERRORMSG).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"completeCheck.errorMessage", (String[])new String[]{materialAttr, materialName == null ? "" : materialName}));
                    row.getCell(TB_MATERIALID).setValue((Object)materialId);
                    row.getCell(TB_PROJECTID).setValue(null);
                    row.getCell(TB_TRACKID).setValue(null);
                    continue;
                }
                String pManuStrategy = errOrderBomRowSet1.getString("FPManufactureStrategyID");
                if (com.kingdee.eas.mm.common.util.MMUtils.isEmptyString((String)pManuStrategy)) {
                    pManuStrategy = "NUnM+gEcEADgAA3cwKgL09g0uEU=";
                }
                if (noOrderBomStrategySet.contains(pManuStrategy)) {
                    boolean isExist = this.isExistRow(materialId, null, null);
                    if (isExist) continue;
                    IRow row = this.errBomList.addRow();
                    row.getCell(TB_STORAGEORGUNITID).setValue((Object)storageOrgUnit.getName(OrderBomCompleteCheckUI.getDefaultLocale()));
                    row.getCell(TB_MATERIALNUM).setValue((Object)materialNumber);
                    row.getCell(TB_MATERIALNAME).setValue((Object)materialName);
                    row.getCell(TB_MATERIAL_MODEL).setValue((Object)materialModel);
                    row.getCell(TB_MATERIAL_ATTR).setValue((Object)materialAttr);
                    row.getCell(TB_ERRORMSG).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"completeCheck.errorMessage", (String[])new String[]{materialAttr, materialName == null ? "" : materialName}));
                    row.getCell(TB_MATERIALID).setValue((Object)materialId);
                    row.getCell(TB_PROJECTID).setValue(null);
                    row.getCell(TB_TRACKID).setValue(null);
                    continue;
                }
                String projectNumber = errOrderBomRowSet1.getString("FPROJECTNUMBER");
                if (projectNumber == null) {
                    projectNumber = ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderBomcompleteCheck.null");
                }
                if ((trackNumber = errOrderBomRowSet1.getString("FTRACKNUMBER")) == null) {
                    trackNumber = ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderBomcompleteCheck.null");
                }
                String projectId = errOrderBomRowSet1.getString("FPROJECTID");
                String trackId = errOrderBomRowSet1.getString("FTRACKID");
                Set trackStrategySet = ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet();
                Set proTrackStrategySet = ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet();
                if (trackStrategySet.contains(pManuStrategy) && proTrackStrategySet.contains(manuStrategy) && isConfigable) continue;
                boolean isExist = false;
                isExist = bomTye == 40 ? this.isExistRow(materialId, null, null) : this.isExistRow(materialId, projectId, trackId);
                if (isExist) continue;
                IRow row = this.errBomList.addRow();
                row.getCell(TB_STORAGEORGUNITID).setValue((Object)storageOrgUnit.getName(OrderBomCompleteCheckUI.getDefaultLocale()));
                row.getCell(TB_MATERIALNUM).setValue((Object)materialNumber);
                row.getCell(TB_MATERIALNAME).setValue((Object)materialName);
                row.getCell(TB_MATERIAL_MODEL).setValue((Object)materialModel);
                row.getCell(TB_MATERIAL_ATTR).setValue((Object)materialAttr);
                if (bomTye == 40) {
                    row.getCell(TB_ERRORMSG).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"completeCheck.errorMessage", (String[])new String[]{materialAttr, materialName == null ? "" : materialName}));
                    row.getCell(TB_MATERIALID).setValue((Object)materialId);
                    row.getCell(TB_PROJECTID).setValue(null);
                    row.getCell(TB_TRACKID).setValue(null);
                    continue;
                }
                row.getCell(TB_ERRORMSG).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderBomcompleteCheck.errorMessage2", (String[])new String[]{materialAttr, materialName == null ? "" : materialName, projectNumber, trackNumber}));
                row.getCell(TB_MATERIALID).setValue((Object)materialId);
                row.getCell(TB_PROJECTID).setValue((Object)projectId);
                row.getCell(TB_TRACKID).setValue((Object)trackId);
            }
        }
        if (errOrderBomRowSet2 != null) {
            while (errOrderBomRowSet2.next()) {
                materialId = errOrderBomRowSet2.getString("FID");
                boolean isExist = this.isExistRow(materialId, null, null);
                if (isExist) continue;
                IRow row = this.errBomList.addRow();
                row.getCell(TB_STORAGEORGUNITID).setValue((Object)storageOrgUnit.getName(OrderBomCompleteCheckUI.getDefaultLocale()));
                row.getCell(TB_MATERIALNUM).setValue((Object)errOrderBomRowSet2.getString("FNUMBER"));
                row.getCell(TB_MATERIALNAME).setValue((Object)errOrderBomRowSet2.getString("FNAME_" + locale.toString()));
                row.getCell(TB_MATERIAL_MODEL).setValue((Object)errOrderBomRowSet2.getString("FMODEL"));
                String materialArr = MaterialAttributeEnum.getEnum((int)Integer.parseInt(errOrderBomRowSet2.getString("FMATERIALATTR"))).getAlias(locale);
                row.getCell(TB_MATERIAL_ATTR).setValue((Object)materialArr);
                row.getCell(TB_ERRORMSG).setValue((Object)ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"orderBomcompleteCheck.errorMessage", (String[])new String[]{materialArr, errOrderBomRowSet2.getString("FNAME_" + locale.toString()) == null ? "" : errOrderBomRowSet2.getString("FNAME_" + locale.toString())}));
            }
        }
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_orderbom_completecheck");
        StorageOrgUnitInfo foi = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_orderbom_completecheck");
        this.prmtStorageOrgUnit.setValue((Object)foi);
        this.errBomList.checkParsed();
        this.addListener();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTable getTableForCommon() {
        return this.errBomList;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getOnloadPermItemName() {
        return "mm_orderbom_completecheck";
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.errBomList);
        this.errBomList.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.errBomList);
        this.errBomList.getPrintManager().printPreview();
    }
}

