/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMAntiExtendCondition;
import com.kingdee.eas.mm.basedata.BOMAntiExtendLevelEnum;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFilterCondition;
import com.kingdee.eas.mm.basedata.BOMSearchBackFlagEnum;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomAntiSearchCondition;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.IBOMExtend2Facade;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomExtendSearchBackListUI;
import com.kingdee.eas.mm.basedata.client.BomAntiExtendSearchPrintDataProvider;
import com.kingdee.eas.mm.basedata.client.BomExtendSearchListUI;
import com.kingdee.eas.mm.basedata.client.OrderBomAntiExtendSearchPrintDataProvider;
import com.kingdee.eas.mm.basedata.client.OrderBomExtendSearchBackQueryUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.YesOrNoEnum;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;

public class OrderBomExtendSearchBackListUI
extends AbstractOrderBomExtendSearchBackListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BomExtendSearchListUI.class);
    private static final String RESOURCE_BOM = "com.kingdee.eas.mm.basedata.BOMResource";
    protected OrderBomExtendSearchBackQueryUI bomExtendSearchBackQueryUI;
    private CommonQueryDialog commonQueryDialog;
    protected IMetaDataPK mainQueryPK;
    private boolean showDialogOnLoad = true;
    private int qtyPrecision1 = 4;
    private StorageOrgUnitInfo souQuery = null;
    private MaterialInfo miQuery = null;
    private BOMUsageEnum bueQuery = null;
    private BOMSearchBackFlagEnum queryType = null;
    private Date queryDate = null;
    private List materialIds = new ArrayList();
    private int currentLocation = -1;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private boolean materialIsConfigable = false;
    private String trackID = null;
    private String projectID = null;
    private String prjNumber = null;
    private String trackNumber = null;
    private static final String[] DTE_DATES = new String[]{"effectiveDate", "disableDate"};
    private static final String[] KDT_DATES = new String[]{"queryDate"};
    private int freezeColIndex = 6;

    public OrderBomExtendSearchBackListUI() throws Exception {
        this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.base.message", (String)"MsgQuery");
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanelTop.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 998, 200));
        this.kDPanelRBottom.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 998, 390));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnUpQuery.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_topviewbom", (Locale)this.getLocale()));
        this.menuItemQueryUp.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_topviewbom", (Locale)this.getLocale()));
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrintPre);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPre);
        this.setButtonDefaultStyl(this.btnFirst);
        this.setButtonDefaultStyl(this.btnExport);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed(true);
        this.dtEntry.checkParsed(true);
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
        this.dtEntry.getStyleAttributes().setLocked(true);
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.dtEntry.getColumn("feture").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("canSelected").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("firstCfg").setEditor((ICellEditor)checkBoxEditor);
        if (this.showDialogOnLoad && this.showDialogOnLoad && !this.showQueryDialog()) {
            SysUtil.abort();
        }
        EditTableUtil.formatColDate((KDTable)this.dtEntry, (String[])DTE_DATES);
        EditTableUtil.formatColDate((KDTable)this.kDTable1, (String[])KDT_DATES);
    }

    protected boolean showQueryDialog() {
        try {
            this.initCommonQueryDialog();
            this.bomExtendSearchBackQueryUI.getUIContext().clear();
            this.bomExtendSearchBackQueryUI.getUIContext().putAll(this.getUIContext());
            if (this.commonQueryDialog.show()) {
                this.kDTable1.removeRows();
                this.dtEntry.removeRows();
                OrderBomExtendSearchBackQueryUI potq = (OrderBomExtendSearchBackQueryUI)this.commonQueryDialog.getUserPanel(0);
                this.souQuery = (StorageOrgUnitInfo)potq.prmtStorageOrgUnit.getValue();
                this.miQuery = null != potq.prmtMaterial.getValue() ? (MaterialInfo)potq.prmtMaterial.getValue() : null;
                this.queryType = (BOMSearchBackFlagEnum)((Object)potq.cmbSearchType.getSelectedItem());
                this.queryDate = (Date)potq.kDDate.getValue();
                this.bueQuery = (BOMUsageEnum)((Object)potq.cmbBomUsage.getSelectedItem());
                BomAntiSearchCondition condition = new BomAntiSearchCondition();
                condition.setBomUsage(this.bueQuery);
                condition.setFlag(true);
                if (this.miQuery != null) {
                    condition.setMaterialID(this.miQuery.getId().toString());
                }
                condition.setOnlyAuditStatus(true);
                condition.setQueryDate(this.queryDate);
                condition.setQueryType(this.queryType);
                condition.setOnlyAuditStatus(true);
                condition.setStorageOrgUnitID(this.souQuery.getId().toString());
                this.actionUpQuery.setEnabled(false);
                this.actionFirst.setEnabled(false);
                this.actionPre.setEnabled(false);
                MaterialInfo materialInfo = (MaterialInfo)potq.prmtMaterial.getValue();
                MaterialInfo[] materialInfos = new MaterialInfo[]{materialInfo};
                SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)this.souQuery, (MaterialInfo[])materialInfos);
                String key1 = materialInfo.getId().toString() + this.souQuery.getId().toString();
                MaterialPlanInfo materialPlan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key1);
                this.materialIsConfigable = materialPlan.isIsConfigable();
                condition.setBomtype(BOMTypeEnum.OrderBOM);
                if (potq.prmtProjectNumber.getValue() != null) {
                    ProjectInfo prj = (ProjectInfo)potq.prmtProjectNumber.getValue();
                    this.projectID = prj.getId().toString();
                    this.prjNumber = prj.getNumber();
                } else {
                    this.projectID = null;
                    this.prjNumber = null;
                }
                if (potq.prmtTrackNumber.getValue() != null) {
                    TrackNumberInfo trackNum = (TrackNumberInfo)potq.prmtTrackNumber.getValue();
                    this.trackID = trackNum.getId().toString();
                    this.trackNumber = trackNum.getNumber();
                } else {
                    this.trackID = null;
                    this.trackNumber = null;
                }
                condition.setProjectNumID(this.projectID);
                condition.setTrackNumID(this.trackID);
                condition.setOrderBom(true);
                this.searchResult(condition);
                return true;
            }
            return false;
        }
        catch (BomException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)((Object)e));
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handUIException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handUIException(e);
        }
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        Object filterCondition = this.getUIContext().get("BOMExtendSearchFilterCondition");
        if (this.getUIContext().get("IsFromTree") != null && ((Boolean)this.getUIContext().get("IsFromTree")).booleanValue() && this.commonQueryDialog != null && filterCondition != null && filterCondition instanceof BOMExtendSearchFilterCondition) {
            this.commonQueryDialog = null;
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setUiObject((IUIObject)this);
            String classFullName = this.getMetaDataPK().getFullName();
            this.commonQueryDialog.setParentUIClassName(classFullName);
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setTitle(EASResource.getString((String)RESOURCE_BOM, (String)"bomBackSearchWindowTitle"));
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.commonQueryDialog.setShowShareType(16);
            try {
                this.bomExtendSearchBackQueryUI = new OrderBomExtendSearchBackQueryUI();
                this.commonQueryDialog.addUserPanel((KDPanel)this.bomExtendSearchBackQueryUI);
                this.commonQueryDialog.setWidth(580);
                this.commonQueryDialog.setHeight(435);
                String strParam = (String)this.getUIContext().get("UIClassParam");
                if (strParam != null && strParam.equals("1")) {
                    this.commonQueryDialog.setTitle(EASResource.getString((String)RESOURCE_BOM, (String)"orderbom_backSearch_filter"));
                    this.getUIContext().put("orderBomExtend", "1");
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    private void refreshTable(String topInfo, IRowSet rowSet) {
        try {
            this.fillTableRow(rowSet);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.repaint();
        this.btnQuery.setEnabled(true);
    }

    private void fillTableRow(RowValue rowValue, int levelNo) {
        IRow row = this.dtEntry.addRow();
        row.getCell("model").setValue((Object)rowValue.model);
        row.getCell("unit").setValue((Object)rowValue.unit);
        if ("0".equals(this.queryType.getValue())) {
            row.getCell("parentMaterialNumber").setValue((Object)rowValue.parentMaterialNumber);
            row.getCell("parentMaterialName").setValue((Object)rowValue.parentMaterialName);
            row.getCell("parentProductQty").setValue((Object)this.formatZero(rowValue.parentProductQty));
            row.getCell("yield").setValue((Object)this.formatZero(rowValue.yield));
            String enumName = this.getAlias(ConsumeTypeEnum.class, Integer.parseInt(rowValue.consumeType));
            row.getCell("consumeType").setValue((Object)enumName);
            row.getCell("proportion").setValue((Object)this.formatZero(rowValue.proportion));
            row.getCell("scrapRatio").setValue((Object)this.formatZero(rowValue.scrapRatio));
            row.getCell("effectiveDate").setValue((Object)rowValue.effectiveDate);
            enumName = this.getAlias(MaterialProductEnum.class, rowValue.outputType);
            row.getCell("consumeFixQty").setValue((Object)this.formatZero(rowValue.baseQty.toString()));
            row.getCell("disableDate").setValue((Object)rowValue.disableDate);
            enumName = this.getAlias(MaterialAttributeEnum.class, Integer.parseInt(rowValue.materialAttr));
            row.getCell("materialAttr").setValue((Object)enumName);
            enumName = this.getAlias(MaterialProductEnum.class, rowValue.outputType);
            row.getCell("outputType").setValue((Object)enumName);
            enumName = this.getAlias(MaterialCharEnum.class, rowValue.materialChar);
            row.getCell("materialChar").setValue((Object)enumName);
            enumName = this.getAlias(MaterialIssueModeEnum.class, rowValue.issMode);
            row.getCell("issMode").setValue((Object)enumName);
            row.getCell("defaultWarehouseName").setValue((Object)rowValue.defaultWarehouseName);
            row.getCell("bomNumber").setValue((Object)rowValue.bomNumber);
            row.getCell("bomName").setValue((Object)rowValue.bomName);
            enumName = BOMTypeEnum.getEnum(rowValue.bomType).getAlias();
            row.getCell("bomType").setValue((Object)enumName);
            row.getCell("showProject").setValue((Object)rowValue.showProject);
            row.getCell("showTrack").setValue((Object)rowValue.showTrack);
            row.getCell("netWeight").setValue((Object)this.formatZero(rowValue.netWeight));
            row.getCell("blkSize").setValue((Object)rowValue.blkSize);
            row.getCell("specifiedLength").setValue((Object)rowValue.specifiedLength);
            row.getCell("usedUnit").setValue((Object)rowValue.usedUnit);
            row.getCell("designUnit").setValue((Object)rowValue.designUnit);
            row.getCell("designRemark").setValue((Object)rowValue.designRemark);
            row.getCell("feture").setValue((Object)Boolean.valueOf(rowValue.feture));
            row.getCell("canSelected").setValue((Object)Boolean.valueOf(rowValue.canSelected));
            row.getCell("firstCfg").setValue((Object)Boolean.valueOf(rowValue.firstCfg));
        } else if ("1".equals(this.queryType.getValue())) {
            row.getCell("parentMaterialNumber").setValue((Object)rowValue.parentMaterialNumber);
            row.getCell("parentMaterialName").setValue((Object)rowValue.parentMaterialName);
            row.getCell("parentProductQty").setValue((Object)this.formatZero(rowValue.parentProductQty));
            row.getCell("yield").setValue((Object)this.formatZero(rowValue.yield));
            String enumName = this.getAlias(ConsumeTypeEnum.class, Integer.parseInt(rowValue.consumeType));
            row.getCell("consumeType").setValue((Object)enumName);
            row.getCell("proportion").setValue((Object)this.formatZero(rowValue.proportion));
            row.getCell("scrapRatio").setValue((Object)this.formatZero(rowValue.scrapRatio));
            row.getCell("effectiveDate").setValue((Object)rowValue.effectiveDate);
            row.getCell("consumeFixQty").setValue((Object)this.formatZero(rowValue.baseQty.toString()));
            row.getCell("levelNo").setValue((Object)this.getLevelStr(String.valueOf(levelNo)));
            row.getCell("disableDate").setValue((Object)rowValue.disableDate);
            enumName = this.getAlias(MaterialAttributeEnum.class, Integer.parseInt(rowValue.materialAttr));
            row.getCell("materialAttr").setValue((Object)enumName);
            enumName = this.getAlias(MaterialProductEnum.class, rowValue.outputType);
            row.getCell("outputType").setValue((Object)enumName);
            enumName = this.getAlias(MaterialCharEnum.class, rowValue.materialChar);
            row.getCell("materialChar").setValue((Object)enumName);
            enumName = this.getAlias(MaterialIssueModeEnum.class, rowValue.issMode);
            row.getCell("issMode").setValue((Object)enumName);
            row.getCell("defaultWarehouseName").setValue((Object)rowValue.defaultWarehouseName);
            row.getCell("bomNumber").setValue((Object)rowValue.bomNumber);
            row.getCell("bomName").setValue((Object)rowValue.bomName);
            enumName = BOMTypeEnum.getEnum(rowValue.bomType).getAlias();
            row.getCell("bomType").setValue((Object)enumName);
            row.getCell("bomUsage").setValue((Object)BOMUsageEnum.Master.getAlias());
            row.getCell("showProject").setValue((Object)rowValue.showProject);
            row.getCell("showTrack").setValue((Object)rowValue.showTrack);
            row.getCell("netWeight").setValue((Object)this.formatZero(rowValue.netWeight));
            row.getCell("blkSize").setValue((Object)rowValue.blkSize);
            row.getCell("specifiedLength").setValue((Object)rowValue.specifiedLength);
            row.getCell("usedUnit").setValue((Object)rowValue.usedUnit);
            row.getCell("designUnit").setValue((Object)rowValue.designUnit);
            row.getCell("designRemark").setValue((Object)rowValue.designRemark);
            row.getCell("feture").setValue((Object)Boolean.valueOf(rowValue.feture));
            row.getCell("canSelected").setValue((Object)Boolean.valueOf(rowValue.canSelected));
            row.getCell("firstCfg").setValue((Object)Boolean.valueOf(rowValue.firstCfg));
        } else if ("2".equals(this.queryType.getValue())) {
            row.getCell("showProject").setValue((Object)this.prjNumber);
            row.getCell("showTrack").setValue((Object)this.trackNumber);
            row.getCell("parentMaterialNumber").setValue((Object)rowValue.parentMaterialNumber);
            row.getCell("parentMaterialName").setValue((Object)rowValue.parentMaterialName);
            row.getCell("parentProductQty").setValue((Object)this.formatZero(rowValue.parentProductQty));
            row.getCell("consumeQtyChild").setValue((Object)rowValue.baseQty.setScale(rowValue.qtyPrecision, 4));
            row.getCell("model").setValue((Object)rowValue.model);
            row.getCell("bomUsage").setValue((Object)BOMUsageEnum.Master.getAlias());
        }
    }

    private void processPriorLevelExtend(List bomList) {
        Iterator it = bomList.iterator();
        while (it.hasNext()) {
            this.fillTableRow((RowValue)it.next(), 1);
        }
    }

    private void processBeginLevelExtend(Map bomId2BOMMap, List bomList) {
        Iterator it = bomList.iterator();
        while (it.hasNext()) {
            this.fillTableRow((RowValue)it.next(), 1);
        }
    }

    private void processAllLevelExtend(Map bomId2BOMMap, List bottonList) {
        block21: {
            List[] results;
            block20: {
                ArrayList<RowValue> topList = new ArrayList<RowValue>();
                HashMap<String, RowValue> child2ParentMap = new HashMap<String, RowValue>();
                for (RowValue parent : bomId2BOMMap.values()) {
                    RowValue child = (RowValue)bomId2BOMMap.get(parent.childId);
                    if (child == null) continue;
                    child2ParentMap.put(child.id, parent);
                }
                for (RowValue bom : bomId2BOMMap.values()) {
                    boolean isTop = true;
                    if (child2ParentMap.get(bom.id) != null) {
                        isTop = false;
                    }
                    if (!isTop) continue;
                    Set proTrackStrategySet = ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet();
                    Set trackStrategySet = ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet();
                    if (proTrackStrategySet.contains(bom.manufactureStrategyID) && this.projectID != null) {
                        topList.add(bom);
                    }
                    if (!trackStrategySet.contains(bom.manufactureStrategyID) || this.trackID == null || this.projectID != null) continue;
                    topList.add(bom);
                }
                results = new List[topList.size()];
                if (!this.queryType.getValue().equals("0")) {
                    Iterator<Object> it = topList.iterator();
                    int i = 0;
                    RowValue rv = null;
                    while (it.hasNext()) {
                        ArrayList<RowValue> oneList;
                        results[i] = oneList = new ArrayList<RowValue>();
                        try {
                            RowValue child;
                            RowValue top;
                            RowValue parent = top = (RowValue)((RowValue)it.next()).clone();
                            oneList.add(parent);
                            RowValue orgChild = (RowValue)bomId2BOMMap.get(parent.childId);
                            RowValue rowValue = child = orgChild == null ? null : (RowValue)orgChild.clone();
                            while (child != null) {
                                oneList.add(child);
                                if (this.queryType.getValue().equals("2")) {
                                    if (child.consumeType.equals(String.valueOf(20))) {
                                        child.baseQty = new BigDecimal(parent.baseQty.floatValue() * child.baseQty.floatValue() / child.productQty.floatValue());
                                    } else if (child.consumeType.equals(String.valueOf(30))) {
                                        child.baseQty = new BigDecimal((double)(parent.baseQty.floatValue() * (child.productQty.floatValue() / child.baseQty.floatValue()) * child.productQty.floatValue()) * 0.01);
                                    }
                                }
                                parent = child;
                                if (parent.childId != null && (rv = (RowValue)bomId2BOMMap.get(parent.childId)) != null) {
                                    child = (RowValue)rv.clone();
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (CloneNotSupportedException e) {
                            this.handUIException(e);
                        }
                        ++i;
                    }
                }
                if (!this.queryType.getValue().equals("1")) break block20;
                for (int i = 0; i < results.length; ++i) {
                    for (int j = results[i].size() - 1; j >= 0; --j) {
                        RowValue bom = (RowValue)results[i].get(j);
                        this.fillTableRow(bom, results[i].size() - j);
                    }
                }
                break block21;
            }
            if (!this.queryType.getValue().equals("2")) break block21;
            HashMap<String, RowValue> resultTopMap = new HashMap<String, RowValue>();
            for (int i = 0; i < results.length; ++i) {
                RowValue botton;
                RowValue top = (RowValue)results[i].get(0);
                if (resultTopMap.containsKey(top.parentMaterialId)) {
                    botton = (RowValue)results[i].get(results[i].size() - 1);
                    RowValue oldTop = (RowValue)resultTopMap.get(top.parentMaterialId);
                    oldTop.baseQty = oldTop.baseQty.add(new BigDecimal(botton.baseQty.floatValue()));
                    continue;
                }
                botton = (RowValue)results[i].get(results[i].size() - 1);
                top.baseQty = botton.baseQty;
                resultTopMap.put(top.parentMaterialId, top);
            }
            for (RowValue top : resultTopMap.values()) {
                this.fillTableRow(top, 1);
            }
        }
    }

    private void fillTableRow(IRowSet rowSet) throws SQLException {
        HashMap<String, RowValue> bomId2BOMMap = new HashMap<String, RowValue>();
        ArrayList<RowValue> bottonList = new ArrayList<RowValue>();
        ArrayList<RowValue> topList = new ArrayList<RowValue>();
        while (rowSet.next()) {
            RowValue row = new RowValue();
            if (this.queryType.getValue().equals("0") || this.queryType.getValue().equals("1")) {
                row.model = rowSet.getString("FModel");
                row.showProject = rowSet.getString("fprojectNumber");
                row.showTrack = rowSet.getString("ftrackNumber");
                row.unit = rowSet.getString("FUnitname");
                row.id = rowSet.getString("fid");
                row.childId = rowSet.getString("fchildid");
                row.parentMaterialNumber = rowSet.getString("FParentMaterialNumber");
                row.parentMaterialName = rowSet.getString("FParentMaterialName");
                row.parentMaterialId = rowSet.getString("FParentMaterialID");
                row.parentProductQty = this.formatZero(rowSet.getString("FPRODUCTQTY"));
                row.childMaterialId = rowSet.getString("FChildMaterialID");
                row.childMaterialNumber = rowSet.getString("FMaterialNumber");
                row.childMaterialName = rowSet.getString("FMaterialName");
                row.baseQty = rowSet.getBigDecimal("FBaseQty");
                row.yield = this.formatZero(rowSet.getString("FYIELD"));
                row.materialAttr = rowSet.getString("FMaterialAttr");
                row.consumeType = rowSet.getString("FConsumeType");
                row.proportion = this.formatZero(rowSet.getString("FProportion"));
                row.scrapRatio = this.formatZero(rowSet.getString("FScrapRatio"));
                row.effectiveDate = rowSet.getString("FEffectiveDate");
                row.disableDate = rowSet.getString("FDisableDate");
                row.outputType = rowSet.getInt("FOutputType");
                row.materialChar = rowSet.getInt("FMaterialChar");
                row.issMode = rowSet.getInt("FIssMode");
                row.defaultWarehouseName = rowSet.getString("FDefaultWarehouseName");
                row.level = rowSet.getString("FLevel");
                row.bomId = rowSet.getString("FBomId");
                row.parentBomId = rowSet.getString("FParentBomId");
                row.bomName = rowSet.getString("FBomName");
                row.bomEntryId = rowSet.getString("FBomEntryID");
                row.scraprateExpression = rowSet.getInt("fscraprateexpression");
                row.productQty = rowSet.getBigDecimal("FProductQty");
                row.bomType = rowSet.getInt("FBomType");
                row.bomNumber = rowSet.getString("Fnumber");
                row.materialAttr = rowSet.getString("fmaterialAttr");
                row.netWeight = this.formatZero(rowSet.getString("netWeight"));
                row.blkSize = rowSet.getString("blkSize");
                row.specifiedLength = rowSet.getString("specifiedLength");
                row.usedUnit = rowSet.getString("usedUnit");
                row.designUnit = rowSet.getString("designUnit");
                row.designRemark = rowSet.getString("designRemark");
                row.manufactureStrategyID = rowSet.getString("FPManufactureStrategyID");
                row.projectID = rowSet.getString("FProjectID");
            } else if (this.queryType.getValue().equals("2")) {
                row.model = rowSet.getString("FModel");
                row.unit = rowSet.getString("FParentUnitname");
                row.parentMaterialNumber = rowSet.getString("FParentMaterialNumber");
                row.parentMaterialName = rowSet.getString("FParentMaterialName");
                row.parentProductQty = this.formatZero(rowSet.getString("FPRODUCTQTY"));
                row.baseQty = rowSet.getBigDecimal("FBaseQty");
                row.qtyPrecision = this.qtyPrecision1;
            }
            if (row.childId == null) {
                bottonList.add(row);
            }
            if (this.queryType.getValue().equals("2")) {
                topList.add(row);
            }
            bomId2BOMMap.put(row.id, row);
        }
        if (this.queryType.getValue().equals("0")) {
            this.processPriorLevelExtend(bottonList);
        } else if (this.queryType.getValue().equals("1")) {
            this.processAllLevelExtend(bomId2BOMMap, bottonList);
        } else {
            this.processBeginLevelExtend(bomId2BOMMap, topList);
        }
    }

    public void searchResult(BomAntiSearchCondition condition) throws BOSException, EASBizException {
        this.setDynamicResultCol(this.queryType, condition);
        this.kDTable1.removeRows();
        this.dtEntry.removeRows();
        this.loadBomList(condition, true);
        this.materialIds.clear();
        this.materialIds.add(condition.getMaterialID());
        this.currentLocation = 0;
        if (this.currentLocation == 0) {
            this.actionPre.setEnabled(false);
            this.actionFirst.setEnabled(false);
        } else {
            this.actionPre.setEnabled(true);
            this.actionFirst.setEnabled(true);
        }
        this.actionUpQuery.setEnabled(false);
    }

    private void loadBomList(BomAntiSearchCondition condition, boolean isSelectFirstRow) {
        IRowSet rowSet = null;
        try {
            rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getBomAntiList4Query(condition);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (null != rowSet) {
            this.kDTable1.removeRows();
            IRow row = null;
            try {
                while (rowSet.next()) {
                    row = this.kDTable1.addRow();
                    this.fillupTableRow(row, rowSet);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (isSelectFirstRow) {
            if (this.kDTable1.getRowCount() > 0) {
                this.kDTable1.getSelectManager().select(0, 0, 2);
            } else {
                this.dtEntry.removeRows();
            }
        } else {
            this.dtEntry.removeRows();
        }
    }

    private boolean fillupTableRow(IRow row, IRowSet rowSet) {
        boolean flag = true;
        String enumName = null;
        try {
            row.getCell("storageOrgUnitNumber").setValue((Object)rowSet.getString("ORGNAME"));
            row.getCell("queryDate").setValue((Object)this.queryDate);
            row.getCell("searchType").setValue((Object)this.queryType.getAlias());
            row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
            row.getCell("childMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
            row.getCell("childMaterialModel").setValue((Object)rowSet.getString("MATERIALMODE"));
            row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("UNITNAME"));
            enumName = this.getAlias(MaterialAttributeEnum.class, rowSet.getInt("MATERIALATTR"));
            row.getCell("childMaterialAttr").setValue((Object)enumName);
            row.getCell("childMaterialID").setValue((Object)rowSet.getString("MATERIALID"));
        }
        catch (SQLException e) {
            logger.error((Object)"error:fillupTableRow ", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    private void setDynamicResultCol(BOMSearchBackFlagEnum type, BomAntiSearchCondition condition) {
        if (type == BOMSearchBackFlagEnum.S) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else if (type == BOMSearchBackFlagEnum.ManySearch) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else if (this.bueQuery != BOMUsageEnum.Master) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("yield").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("materialAttr").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("materialChar").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("issMode").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("bomNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("bomName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("bomType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeQtyChild").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
        }
    }

    private void setColumnByBOMType(BomAntiSearchCondition condition) {
        this.dtEntry.getColumn("showProject").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("feture").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(false);
    }

    @Override
    public void actionUpQuery_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        ICell cell;
        String materialId;
        super.actionUpQuery_actionPerformed(e);
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (-1 != selectedIndex && null != (materialId = (String)(cell = (row = this.dtEntry.getRow(selectedIndex)).getCell("parentMaterialId")).getValue())) {
            BomAntiSearchCondition condition = new BomAntiSearchCondition();
            condition.setBomUsage(this.bueQuery);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setOnlyAuditStatus(true);
            condition.setProjectNumID(this.projectID);
            condition.setTrackNumID(this.trackID);
            condition.setOrderBom(true);
            this.loadBomList(condition, true);
            this.materialIds.add(materialId);
            ++this.currentLocation;
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    protected void dtEntry_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.queryType == BOMSearchBackFlagEnum.ManySearch || this.queryType == BOMSearchBackFlagEnum.MutliSraech) {
            return;
        }
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (-1 == selectedIndex) {
            return;
        }
        IRow row = this.dtEntry.getRow(selectedIndex);
        ICell cell = row.getCell("parentMaterialId");
        String materialId = (String)cell.getValue();
        if (null != materialId) {
            this.actionUpQuery.setEnabled(true);
        } else {
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    protected void kDTable1_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int selectedIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow row = this.kDTable1.getRow(selectedIndex);
        ICell cell = row.getCell("childMaterialID");
        String materialId = (String)cell.getValue();
        if (null != materialId) {
            this.loadResultList(materialId);
        }
    }

    private void loadResultList(String materialId) throws Exception {
        this.dtEntry.removeRows();
        BomAntiSearchCondition condition = new BomAntiSearchCondition();
        condition.setQueryType(this.queryType);
        if (this.queryType == BOMSearchBackFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            condition.setQueryType(BOMSearchBackFlagEnum.S);
        }
        condition.setQueryDate(this.queryDate);
        condition.setMaterialID(materialId);
        condition.setStorageOrgUnitID(this.souQuery.getId().toString());
        condition.setBomUsage(this.bueQuery);
        condition.setProjectNumID(this.projectID);
        condition.setTrackNumID(this.trackID);
        condition.setOrderBom(true);
        IRowSet rowSet = null;
        if (condition.getQueryType() == BOMSearchBackFlagEnum.S) {
            try {
                rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getAntiResultList4Query(condition);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            String topInfo = BOMExtendSearchFacadeFactory.getRemoteInstance().getBOMTopDataBack(this.souQuery.getId().toString(), this.miQuery.getId().toString(), this.queryDate, this.queryType.getValue());
            ArrayList<String> returnFieldList = new ArrayList<String>();
            returnFieldList.add("FMODEL");
            returnFieldList.add("FUnitName");
            returnFieldList.add("FID");
            returnFieldList.add("FChildID");
            returnFieldList.add("FParentMaterialNumber");
            returnFieldList.add("FParentMaterialName");
            returnFieldList.add("FPARENTMATERIALID");
            returnFieldList.add("FProductQty");
            returnFieldList.add("FCHILDMATERIALID");
            returnFieldList.add("FMaterialNumber");
            returnFieldList.add("FMaterialName");
            returnFieldList.add("FBaseQty");
            returnFieldList.add("FYIELD");
            returnFieldList.add("FMaterialAttr");
            returnFieldList.add("FConsumeType");
            returnFieldList.add("FProportion");
            returnFieldList.add("FScrapRatio");
            returnFieldList.add("FScrapRatio");
            returnFieldList.add("FEffectiveDate");
            returnFieldList.add("FDisableDate");
            returnFieldList.add("FOutputType");
            returnFieldList.add("FMaterialChar");
            returnFieldList.add("FIssMode");
            returnFieldList.add("FDefaultWarehouseName");
            returnFieldList.add("FLevel");
            returnFieldList.add("FBomId");
            returnFieldList.add("FParentBomId");
            returnFieldList.add("FBomName");
            returnFieldList.add("FBomEntryID");
            returnFieldList.add("FScraprateExpression");
            returnFieldList.add("FProductQty");
            returnFieldList.add("FBomType");
            returnFieldList.add("Fnumber");
            returnFieldList.add("FParentID");
            returnFieldList.add("FPManufactureStrategyID");
            returnFieldList.add("FProjectID");
            String[] returnFields = returnFieldList.toArray(new String[0]);
            IBOMExtend2Facade facade = BOMExtend2FacadeFactory.getRemoteInstance();
            if (condition.getQueryType() == BOMSearchBackFlagEnum.ManySearch) {
                BOMAntiExtendCondition condition1 = new BOMAntiExtendCondition();
                condition1.setAntiExtendLevel(BOMAntiExtendLevelEnum.AllLevelExtend);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(false);
                condition1.setReturnFields(returnFields);
                condition1.setMaterialIsConfigable(this.materialIsConfigable);
                condition1.setProjectNumID(this.projectID);
                condition1.setTrackNumID(this.trackID);
                condition1.setOrderBom(true);
                try {
                    rowSet = facade.getAntiExtendRowSetByMaterialID(this.miQuery.getId().toString(), this.queryDate, condition1);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                }
            } else {
                returnFieldList = new ArrayList();
                returnFieldList.add("FMODEL");
                returnFieldList.add("FParentUnitName");
                returnFieldList.add("FParentMaterialNumber");
                returnFieldList.add("FParentMaterialName");
                returnFieldList.add("FProductQty");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFields = returnFieldList.toArray(new String[0]);
                BOMAntiExtendCondition condition1 = new BOMAntiExtendCondition();
                condition1.setAntiExtendLevel(BOMAntiExtendLevelEnum.BeginLevelExtend);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(true);
                condition1.setOnlyExtendConfig(false);
                condition1.setComputeYieldAndScrapRatio(false);
                condition1.setReturnFields(returnFields);
                condition1.setOrderBom(true);
                condition1.setProjectNumID(this.projectID);
                condition1.setTrackNumID(this.trackID);
                try {
                    rowSet = facade.getAntiExtendRowSetByMaterialID(this.miQuery.getId().toString(), this.queryDate, condition1);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"Info_PleaseCheckBOMData"));
                }
            }
            this.refreshTable(topInfo, rowSet);
            return;
        }
        if (null != rowSet) {
            this.dtEntry.removeRows();
            IRow row = null;
            try {
                while (null != rowSet && rowSet.next()) {
                    row = this.dtEntry.addRow();
                    String enumName = null;
                    row.getCell("parentMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
                    row.getCell("parentMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
                    row.getCell("model").setValue((Object)rowSet.getString("MATERIALMODE"));
                    enumName = this.getAlias(MaterialAttributeEnum.class, rowSet.getInt("MATERIALATTR"));
                    row.getCell("materialAttr").setValue((Object)enumName);
                    enumName = this.getAlias(ConsumeTypeEnum.class, rowSet.getInt("CONSUMETYPE"));
                    row.getCell("consumeType").setValue((Object)enumName);
                    row.getCell("consumeFixQty").setValue((Object)this.formatZero(rowSet.getString("CONSUMEFIXQTY")));
                    row.getCell("yield").setValue((Object)this.formatZero(rowSet.getString("YIELD")));
                    row.getCell("proportion").setValue((Object)this.formatZero(rowSet.getString("PROPORTION")));
                    row.getCell("parentProductQty").setValue((Object)this.formatZero(rowSet.getString("PRODUCTQTY")));
                    row.getCell("unit").setValue((Object)rowSet.getString("UNITNAME"));
                    row.getCell("scrapRatio").setValue((Object)this.formatZero(rowSet.getString("SCRAPRATIO")));
                    row.getCell("effectiveDate").setValue((Object)rowSet.getString("EFFECTIVEDATE"));
                    row.getCell("disableDate").setValue((Object)rowSet.getString("DISABLEDATE"));
                    enumName = this.getAlias(MaterialProductEnum.class, rowSet.getInt("OUTPUTTYPE"));
                    row.getCell("outputType").setValue((Object)enumName);
                    enumName = this.getAlias(MaterialCharEnum.class, rowSet.getInt("MATERIALCHAR"));
                    row.getCell("materialChar").setValue((Object)enumName);
                    enumName = this.getAlias(MaterialIssueModeEnum.class, rowSet.getInt("ISSMODE"));
                    row.getCell("issMode").setValue((Object)enumName);
                    row.getCell("defaultWarehouseName").setValue((Object)rowSet.getString("DEFAULTWAREHOUSENAME"));
                    row.getCell("bomNumber").setValue((Object)rowSet.getString("BOMNUMBER"));
                    row.getCell("bomName").setValue((Object)rowSet.getString("BOMNAME"));
                    row.getCell("parentMaterialId").setValue((Object)rowSet.getString("MATERIALID"));
                    enumName = BOMTypeEnum.getEnum(Integer.parseInt(rowSet.getString("BOMTYPE"))).getAlias();
                    row.getCell("bomType").setValue((Object)enumName);
                    enumName = BOMUsageEnum.getEnum(Integer.parseInt(rowSet.getString("BOMUSAGETYPE"))).getAlias();
                    row.getCell("bomUsage").setValue((Object)enumName);
                    row.getCell("showProject").setValue((Object)this.prjNumber);
                    row.getCell("showTrack").setValue((Object)this.trackNumber);
                    row.getCell("netWeight").setValue((Object)this.formatZero(rowSet.getString("netWeight")));
                    row.getCell("blkSize").setValue((Object)rowSet.getString("blkSize"));
                    row.getCell("specifiedLength").setValue((Object)rowSet.getString("specifiedLength"));
                    row.getCell("usedUnit").setValue((Object)rowSet.getString("usedUnit"));
                    row.getCell("designUnit").setValue((Object)rowSet.getString("designUnit"));
                    row.getCell("designRemark").setValue((Object)rowSet.getString("designRemark"));
                    row.getCell("feture").setValue((Object)rowSet.getBoolean("feture"));
                    row.getCell("canSelected").setValue((Object)rowSet.getBoolean("canSelected"));
                    row.getCell("firstCfg").setValue((Object)rowSet.getBoolean("firstCfg"));
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().containsKey("IsFromTree")) {
            this.getUIContext().put("IsFromTree", Boolean.FALSE);
            this.getUIContext().put("BOMExtendSearchFilterCondition", new BOMExtendSearchFilterCondition());
        }
        this.showQueryDialog();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        int loop = 0;
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotExport"));
            return;
        }
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        IRow bomRow = null;
        KDTHead head = this.kDTable1.getHead();
        ArrayList headList = head.getRow(0).getCells();
        IRow resultRow = null;
        head = this.dtEntry.getHead();
        ArrayList resultHeadList = head.getRow(0).getCells();
        Object obj = null;
        Boolean tmpBoolean = Boolean.FALSE;
        File tempFile = File.createTempFile("tmp", ".xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Sheet1");
        int curRowIndex = 0;
        HSSFRow row = null;
        HSSFCell hcell = null;
        HSSFCellStyle style = null;
        HSSFPalette palette = wb.getCustomPalette();
        palette.setColorAtIndex(IndexedColors.BLUE_GREY.index, (byte)this.kDTable1.getHeadSSA().getBackground().getRed(), (byte)this.kDTable1.getHeadSSA().getBackground().getGreen(), (byte)this.kDTable1.getHeadSSA().getBackground().getBlue());
        row = sheet.createRow(curRowIndex++);
        hcell = row.createCell(5);
        String title = null;
        if (this.queryType.equals((Object)BOMSearchBackFlagEnum.S)) {
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}");
            title = format.format(new Object[]{EASResource.getString((String)RESOURCE_BOM, (String)"orderbom_backSearch"), this.queryType.getAlias()});
        } else {
            title = this.queryType.getAlias();
        }
        hcell.setCellValue((RichTextString)new HSSFRichTextString(title));
        style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
        hcell.setCellStyle(style);
        for (int i = 0; i < count; ++i) {
            int k;
            this.kDTable1.getSelectManager().select(i, 0);
            bomRow = this.kDTable1.getRow(i);
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.childMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            int count1 = headList.size();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)headList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = this.kDTable1.getColumnCount();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                if (this.kDTable1.getColumn(k).getKey().equalsIgnoreCase("queryDate")) {
                    if (null != (Date)bomRow.getCell(k).getValue()) {
                        row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString(dtformat.format((Date)bomRow.getCell(k).getValue())));
                        continue;
                    }
                    row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString((String)bomRow.getCell(k).getValue()));
                    continue;
                }
                row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString((String)bomRow.getCell(k).getValue()));
            }
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.parentMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = resultHeadList.size();
            for (k = 0; k < count1; ++k) {
                if (this.dtEntry.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)resultHeadList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            int n = 0;
            int count11 = this.dtEntry.getRowCount();
            for (int j = 0; j < count11; ++j) {
                n = 0;
                row = sheet.createRow(curRowIndex++);
                resultRow = this.dtEntry.getRow(j);
                int count3 = resultHeadList.size();
                for (int m = 0; m < count3; ++m) {
                    if (resultRow.getCell(m).getStyleAttributes().isHided()) continue;
                    if (resultRow.getCell(m).getFormattedValue() != null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(resultRow.getCell(m).getFormattedValue().toString()));
                        continue;
                    }
                    obj = resultRow.getCell(m).getValue();
                    if (obj == null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(""));
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        tmpBoolean = (Boolean)obj;
                        if (tmpBoolean.equals(Boolean.TRUE)) {
                            row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.YES.getAlias());
                            continue;
                        }
                        row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.NO.getAlias());
                        continue;
                    }
                    row.createCell((int)((short)n++)).setCellValue(obj.toString());
                }
            }
            ++curRowIndex;
        }
        FileOutputStream fileOut = new FileOutputStream(tempFile);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        try {
            KDTMenuManager.openFileInExcel((String)tempFile.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempFile.deleteOnExit();
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.currentLocation = 0;
        String materialId = (String)this.materialIds.get(this.currentLocation);
        if (null != materialId) {
            BomAntiSearchCondition condition = new BomAntiSearchCondition();
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setOrderBom(true);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setOnlyAuditStatus(true);
            this.loadBomList(condition, true);
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        --this.currentLocation;
        String materialId = (String)this.materialIds.get(this.currentLocation);
        if (null != materialId) {
            BomAntiSearchCondition condition = new BomAntiSearchCondition();
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(materialId);
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setOrderBom(true);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            condition.setOnlyAuditStatus(true);
            this.loadBomList(condition, true);
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionUpQuery.setEnabled(false);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = null;
        BOMSearchBackFlagEnum tmp = this.queryType;
        if (tmp == BOMSearchBackFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchBackFlagEnum.S;
        }
        BomAntiExtendSearchPrintDataProvider data = new BomAntiExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, false, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = null;
        BOMSearchBackFlagEnum tmp = this.queryType;
        if (tmp == BOMSearchBackFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchBackFlagEnum.S;
        }
        OrderBomAntiExtendSearchPrintDataProvider data = new OrderBomAntiExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, true, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private String getTemplatePath(BOMSearchBackFlagEnum queryType) {
        String templatePath = null;
        templatePath = BOMSearchBackFlagEnum.S == queryType ? "/MM/basedata/BOM/BOMANTIEXTENDSEARCH_SINGLE.r1-print" : (BOMSearchBackFlagEnum.ManySearch == queryType ? "/MM/basedata/BOM/BOMANTIEXTENDSEARCH_MANY.r1-print" : "/MM/basedata/BOM/BOMANTIEXTENDSEARCH_MULTI.r1-print");
        return templatePath;
    }

    private String getLevelStr(String level) {
        if (level.equals("1")) {
            return "*" + level;
        }
        if (level.equals("2")) {
            return "**" + level;
        }
        if (level.equals("3")) {
            return "***" + level;
        }
        if (level.equals("4")) {
            return "****" + level;
        }
        if (level.equals("5")) {
            return "*****" + level;
        }
        if (level.equals("6")) {
            return "******" + level;
        }
        if (level.equals("7")) {
            return "*******" + level;
        }
        return "********" + level;
    }

    protected String getOnloadPermItemName() {
        return "mm_orderbom_searchBack";
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }

    private String getAlias(Object enumObj, int val) {
        MaterialIssueModeEnum miEnum;
        String name = null;
        if (enumObj.equals(MaterialAttributeEnum.class)) {
            MaterialAttributeEnum maEnum = MaterialAttributeEnum.getEnum((int)val);
            if (maEnum != null) {
                name = maEnum.getAlias();
            }
        } else if (enumObj.equals(ConsumeTypeEnum.class)) {
            ConsumeTypeEnum ctEnum = ConsumeTypeEnum.getEnum(val);
            if (ctEnum != null) {
                name = ctEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialProductEnum.class)) {
            MaterialProductEnum mpEnum = MaterialProductEnum.getEnum((int)val);
            if (mpEnum != null) {
                name = mpEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialCharEnum.class)) {
            MaterialCharEnum mtEnum = MaterialCharEnum.getEnum((int)val);
            if (mtEnum != null) {
                name = mtEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialIssueModeEnum.class) && (miEnum = MaterialIssueModeEnum.getEnum((int)val)) != null) {
            name = miEnum.getAlias();
        }
        return name;
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.dtEntry, (int)this.freezeColIndex);
    }

    private static class RowValue
    implements Cloneable {
        String id = "";
        String childId = "";
        String parentMaterialId = "";
        String parentMaterialNumber = "";
        String parentMaterialName = "";
        String parentProductQty = "";
        String yield = "";
        String childMaterialNumber = "";
        String childMaterialName = "";
        String childMaterialId = "";
        String model = "";
        String unit = "";
        String materialAttr = "";
        String consumeType = "";
        BigDecimal baseQty = null;
        String proportion = "";
        String scrapRatio = "";
        String effectiveDate = "";
        String disableDate = "";
        int outputType = 0;
        int materialChar = 0;
        int issMode = 0;
        String defaultWarehouseName = "";
        String level = "";
        String bomId = "";
        String parentBomId = "";
        String bomName = "";
        String bomEntryId = "";
        String manufactureStrategyID = "";
        String projectID = "";
        int scraprateExpression = -1;
        BigDecimal productQty = null;
        String bomNumber = "";
        int bomType = 0;
        int qtyPrecision = 4;
        String showProject = "";
        String showTrack = "";
        String netWeight = "";
        String blkSize = "";
        String specifiedLength = "";
        String usedUnit = "";
        String designUnit = "";
        String designRemark = "";
        String feture = "";
        String canSelected = "";
        String firstCfg = "";

        RowValue() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

