/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFilterCondition;
import com.kingdee.eas.mm.basedata.BOMSearchBackFlagEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomExtendSearchBackQueryUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class OrderBomExtendSearchBackQueryUI
extends AbstractOrderBomExtendSearchBackQueryUI {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_BOM = "com.kingdee.eas.mm.basedata.BOMResource";
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    private DataChangeListener projectDataChangeListener = null;

    public OrderBomExtendSearchBackQueryUI() throws Exception {
        this.prmtStorageOrgUnit.setRequired(true);
    }

    private void projectChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            this.prmtTrackNumber.setValue(null);
        } else if (!e.getNewValue().equals(e.getOldValue())) {
            this.prmtTrackNumber.setValue(null);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.prmtProjectNumber.removeDataChangeListener(this.projectDataChangeListener);
        super.loadData(entityViewInfo);
        this.prmtStorageOrgUnit.setValue(null);
        this.prmtMaterial.setValue(null);
        this.prmtTrackNumber.setValue(null);
        this.prmtProjectNumber.setValue(null);
        try {
            if (entityViewInfo != null) {
                this.kDDate.setValue(null);
                FilterInfo filterInfo = entityViewInfo.getFilter();
                if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                    for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                        IMaterial factory;
                        FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                        if ("storageOrgUnitID".equals(filterItemInfo.getPropertyName())) {
                            String orgID = filterItemInfo.getCompareValue().toString();
                            orgID = orgID.substring(1, orgID.length() - 1);
                            factory = StorageOrgUnitFactory.getRemoteInstance();
                            StorageOrgUnitInfo org = factory.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
                            this.prmtStorageOrgUnit.setValue((Object)org);
                            continue;
                        }
                        if ("materialID".equals(filterItemInfo.getPropertyName())) {
                            String materialID = filterItemInfo.getCompareValue().toString();
                            factory = MaterialFactory.getRemoteInstance();
                            MaterialInfo material = factory.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                            this.prmtMaterial.setValue((Object)material);
                            continue;
                        }
                        if ("searchType".equals(filterItemInfo.getPropertyName())) {
                            this.cmbSearchType.removeAllItems();
                            this.cmbSearchType.addItems(BOMSearchBackFlagEnum.getEnumList().toArray());
                            this.cmbSearchType.setSelectedIndex(new Integer(filterItemInfo.getCompareValue().toString()).intValue());
                            continue;
                        }
                        if ("date".equals(filterItemInfo.getPropertyName())) {
                            this.kDDate.setValue(filterItemInfo.getCompareValue());
                            continue;
                        }
                        if ("prjNumberID".equals(filterItemInfo.getPropertyName())) {
                            String prjNumberID = filterItemInfo.getCompareValue().toString();
                            ProjectInfo prj = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(prjNumberID));
                            this.prmtProjectNumber.setValue((Object)prj);
                            continue;
                        }
                        if ("trackNumberID".equals(filterItemInfo.getPropertyName())) {
                            String trackNumberID = filterItemInfo.getCompareValue().toString();
                            TrackNumberInfo tackNumber = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackNumberID));
                            this.prmtTrackNumber.setValue((Object)tackNumber);
                            continue;
                        }
                        if (!"usageType".equals(filterItemInfo.getPropertyName())) continue;
                        this.cmbBomUsage.setSelectedIndex(new Integer(filterItemInfo.getCompareValue().toString()).intValue());
                    }
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtProjectNumber.addDataChangeListener(this.projectDataChangeListener);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo.getFilterItems().clear();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            StringBuffer ids = new StringBuffer();
            StringBuffer numbers = new StringBuffer();
            StringBuffer names = new StringBuffer();
            if (this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo) {
                ids.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
                numbers.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getNumber());
                names.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getName());
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString()));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString(), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)names.toString(), CompareType.INCLUDE));
            } else if (this.prmtStorageOrgUnit.getValue() instanceof LinkedHashSet) {
                LinkedHashSet set = (LinkedHashSet)this.prmtStorageOrgUnit.getValue();
                for (String id : set) {
                    ids.append(id + ";");
                }
            } else if (this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
                Object[] storages = (Object[])this.prmtStorageOrgUnit.getValue();
                if (storages.length > 0) {
                    for (int i = 0; i < storages.length; ++i) {
                        ids.append(((StorageOrgUnitInfo)storages[i]).getId() + ";");
                        numbers.append(((StorageOrgUnitInfo)storages[i]).getNumber() + ";");
                    }
                }
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)numbers.toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString(), CompareType.EQUALS));
            }
        }
        if (this.prmtMaterial.getValue() != null && this.prmtMaterial.getText() != null && this.prmtMaterial.getText().length() > 0) {
            if (this.prmtMaterial.getValue() instanceof MaterialInfo) {
                itemCollection.add(new FilterItemInfo("materialID", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("materialNumber", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getNumber().toString()));
            } else if (this.prmtMaterial.getValue() instanceof LinkedHashSet) {
                for (String id : (LinkedHashSet)this.prmtMaterial.getValue()) {
                    itemCollection.add(new FilterItemInfo("materialID", (Object)id, CompareType.EQUALS));
                }
            }
        }
        if (this.kDDate.getValue() != null) {
            itemCollection.add(new FilterItemInfo("date", (Object)new Timestamp(((Date)this.kDDate.getValue()).getTime()), CompareType.EQUALS));
        }
        if (this.cmbSearchType.getSelectedIndex() >= 0) {
            itemCollection.add(new FilterItemInfo("searchType", (Object)new Integer(this.cmbSearchType.getSelectedIndex())));
        }
        if (this.prmtProjectNumber.getValue() != null && this.prmtProjectNumber.getText().length() > 0) {
            itemCollection.add(new FilterItemInfo("prjNumberID", (Object)((ProjectInfo)this.prmtProjectNumber.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtTrackNumber.getValue() != null && this.prmtTrackNumber.getText().length() > 0) {
            itemCollection.add(new FilterItemInfo("trackNumberID", (Object)((TrackNumberInfo)this.prmtTrackNumber.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.cmbBomUsage.getSelectedIndex() >= 0) {
            itemCollection.add(new FilterItemInfo("usageType", (Object)new Integer(this.cmbBomUsage.getSelectedIndex())));
        }
        return this.filterInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_orderbom_searchBack");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_orderbom_searchBack");
        if (orgInfo == null) {
            return;
        }
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.prmtStorageOrgUnit.setRequired(true);
        this.prmtMaterial.setRequired(true);
        this.cmbSearchType.setRequired(true);
        this.initF7Material(orgInfo);
        this.initBomUsage(false);
        if (this.projectDataChangeListener == null) {
            this.projectDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    OrderBomExtendSearchBackQueryUI.this.projectChanged(e);
                }
            };
        }
        this.prmtProjectNumber.addDataChangeListener(this.projectDataChangeListener);
    }

    public boolean verify() {
        StringBuffer msg = new StringBuffer();
        if (this.prmtStorageOrgUnit.getText() == null || this.prmtStorageOrgUnit.getText().trim().length() == 0) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"storageOrgUnit_Required"));
        } else if (this.prmtStorageOrgUnit.getValue() == null) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"storageOrgUnit_CodeError"));
        }
        if (this.prmtMaterial.getText() == null || this.prmtMaterial.getText().trim().length() == 0) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"childMaterial_Required"));
        } else if (this.prmtMaterial.getValue() == null) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"childMaterial_CodeError"));
        }
        if (this.prmtProjectNumber.getValue() == null && this.prmtTrackNumber.getValue() == null) {
            msg.append(ResourceUtils.getMessage((String)RESOURCE_BOM, (String)"pt_notnull"));
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            return false;
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_orderbom_searchBack");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_orderbom_searchBack");
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.kDDate.setValue((Object)new Date());
        this.cmbSearchType.setSelectedIndex(0);
        this.prmtMaterial.setValue(null);
        this.prmtTrackNumber.setValue(null);
        this.prmtProjectNumber.setValue(null);
        this.cmbBomUsage.setSelectedIndex(0);
    }

    private void ensureChangeLine(StringBuffer msg, String info) {
        if (msg.length() > 0) {
            msg.append("\n\r");
        }
        msg.append(info);
    }

    private void initF7Material(StorageOrgUnitInfo orgInfo) {
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS));
        this.entityViewInfo.setFilter(filterInfo);
        this.prmtMaterial.setEntityViewInfo(this.entityViewInfo);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNumber);
        OrderBomExtendSearchBackQueryUI.registerTrackNumberF7ForEdit(this.prmtStorageOrgUnit, null, this.prmtProjectNumber, this.prmtTrackNumber, false, false);
    }

    @Override
    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            this.initF7Material((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        }
        this.prmtMaterial.setValue(null);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected void cmbBomUsage_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 2) {
            int i;
            int count;
            BOMUsageEnum usageEnum = (BOMUsageEnum)((Object)e.getItem());
            ItemListener[] listener = this.cmbSearchType.getItemListeners();
            if (null != listener) {
                count = listener.length;
                for (i = 0; i < count; ++i) {
                    this.cmbSearchType.removeItemListener(listener[i]);
                }
            }
            this.cmbSearchType.removeAllItems();
            this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.S);
            if (usageEnum == BOMUsageEnum.Master) {
                this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.ManySearch);
                this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.MutliSraech);
            }
            if (null != listener) {
                count = listener.length;
                for (i = 0; i < count; ++i) {
                    this.cmbSearchType.addItemListener(listener[i]);
                }
            }
        }
    }

    @Override
    protected void cmbSearchType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 2) {
            BOMSearchBackFlagEnum searchTypeEnum = (BOMSearchBackFlagEnum)((Object)e.getItem());
            if (searchTypeEnum == BOMSearchBackFlagEnum.ManySearch) {
                this.initBomUsage(true);
            } else if (searchTypeEnum == BOMSearchBackFlagEnum.MutliSraech) {
                this.initBomUsage(true);
            } else {
                this.initBomUsage(false);
            }
        }
    }

    private void initBomUsage(boolean onlyMasterBom) {
        int i;
        int count;
        ItemListener[] listener = this.cmbBomUsage.getItemListeners();
        BOMUsageEnum pre = (BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem());
        if (null != listener) {
            count = listener.length;
            for (i = 0; i < count; ++i) {
                this.cmbBomUsage.removeItemListener(listener[i]);
            }
        }
        this.cmbBomUsage.removeAllItems();
        this.cmbBomUsage.addItem((Object)BOMUsageEnum.Master);
        if (!onlyMasterBom) {
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.Other);
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.BackingOut);
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.maintaining);
        }
        this.cmbBomUsage.setSelectedItem((Object)pre);
        if (null != listener) {
            count = listener.length;
            for (i = 0; i < count; ++i) {
                this.cmbBomUsage.addItemListener(listener[i]);
            }
        }
    }

    public static void registerTrackNumberF7ForEdit(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, boolean isAutoCreateNew, boolean isMulSelect) {
        trackNumberBox.setEnabledMultiSelection(isMulSelect);
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        status.add(new Integer(80));
        UIHelper.registerTrackNumberF7((KDBizPromptBox)mainOrgUnitBox, (KDBizPromptBox)mainOrgUnitBox2, (KDBizPromptBox)projectBox, (KDBizPromptBox)trackNumberBox, status, (boolean)isAutoCreateNew);
    }

    public void show() {
        if (this.getUIContext().get("IsFromTree") != null && ((Boolean)this.getUIContext().get("IsFromTree")).booleanValue()) {
            int i;
            int count;
            Object filterCondition;
            ItemListener[] bomUsageListener;
            DataChangeListener[] trackListener;
            DataChangeListener[] projectListener;
            DataChangeListener[] materiallistener;
            DataChangeListener[] souListener = (DataChangeListener[])this.prmtStorageOrgUnit.getListeners(DataChangeListener.class);
            if (null != souListener) {
                int count2 = souListener.length;
                for (int i2 = 0; i2 < count2; ++i2) {
                    this.prmtStorageOrgUnit.removeDataChangeListener(souListener[i2]);
                }
            }
            if (null != (materiallistener = (DataChangeListener[])this.prmtMaterial.getListeners(DataChangeListener.class))) {
                int count3 = materiallistener.length;
                for (int i3 = 0; i3 < count3; ++i3) {
                    this.prmtMaterial.removeDataChangeListener(materiallistener[i3]);
                }
            }
            if (null != (projectListener = (DataChangeListener[])this.prmtProjectNumber.getListeners(DataChangeListener.class))) {
                int count4 = projectListener.length;
                for (int i4 = 0; i4 < count4; ++i4) {
                    this.prmtProjectNumber.removeDataChangeListener(projectListener[i4]);
                }
            }
            if (null != (trackListener = (DataChangeListener[])this.prmtTrackNumber.getListeners(DataChangeListener.class))) {
                int count5 = trackListener.length;
                for (int i5 = 0; i5 < count5; ++i5) {
                    this.prmtTrackNumber.removeDataChangeListener(trackListener[i5]);
                }
            }
            if (null != (bomUsageListener = (ItemListener[])this.cmbBomUsage.getListeners(ItemListener.class))) {
                int count6 = bomUsageListener.length;
                for (int i6 = 0; i6 < count6; ++i6) {
                    this.cmbBomUsage.removeItemListener(bomUsageListener[i6]);
                }
            }
            if ((filterCondition = this.getUIContext().get("BOMExtendSearchFilterCondition")) != null && filterCondition instanceof BOMExtendSearchFilterCondition) {
                this.prmtStorageOrgUnit.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getOrgInfo());
                if (((BOMExtendSearchFilterCondition)filterCondition).getBomInfo() != null) {
                    this.prmtMaterial.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getBomInfo().getMaterial());
                }
                this.prmtProjectNumber.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getProjectInfo());
                this.prmtTrackNumber.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getTrackNumberInfo());
                this.cmbBomUsage.setSelectedItem((Object)((BOMExtendSearchFilterCondition)filterCondition).getBomUsage());
                this.cmbSearchType.removeAllItems();
                this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.S);
                if (this.cmbBomUsage.getSelectedItem() == BOMUsageEnum.Master) {
                    this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.ManySearch);
                    this.cmbSearchType.addItem((Object)BOMSearchBackFlagEnum.MutliSraech);
                }
                this.prmtStorageOrgUnit.setText(((BOMExtendSearchFilterCondition)filterCondition).getOrgInfo().getNumber());
                if (this.prmtMaterial.getValue() != null) {
                    this.prmtMaterial.setText(((BOMExtendSearchFilterCondition)filterCondition).getBomInfo().getMaterial().getNumber());
                }
                if (((BOMExtendSearchFilterCondition)filterCondition).getProjectInfo() != null) {
                    this.prmtProjectNumber.setText(((BOMExtendSearchFilterCondition)filterCondition).getProjectInfo().getNumber());
                }
                if (((BOMExtendSearchFilterCondition)filterCondition).getTrackNumberInfo() != null) {
                    this.prmtTrackNumber.setText(((BOMExtendSearchFilterCondition)filterCondition).getTrackNumberInfo().getNumber());
                }
            }
            if (null != souListener) {
                count = souListener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtStorageOrgUnit.addDataChangeListener(souListener[i]);
                }
            }
            if (null != materiallistener) {
                count = materiallistener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtMaterial.addDataChangeListener(materiallistener[i]);
                }
            }
            if (null != projectListener) {
                count = projectListener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtMaterial.addDataChangeListener(projectListener[i]);
                }
            }
            if (null != trackListener) {
                count = trackListener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtMaterial.addDataChangeListener(trackListener[i]);
                }
            }
            if (null != bomUsageListener) {
                count = bomUsageListener.length;
                for (i = 0; i < count; ++i) {
                    this.cmbBomUsage.addItemListener(bomUsageListener[i]);
                }
            }
        }
        super.show();
    }
}

