/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BOMExtendCondition;
import com.kingdee.eas.mm.basedata.BOMExtendLevelEnum;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFilterCondition;
import com.kingdee.eas.mm.basedata.BOMSearchFlagEnum;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.BomTreeCondition;
import com.kingdee.eas.mm.basedata.BomTreeInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomExtendSearchListUI;
import com.kingdee.eas.mm.basedata.client.BomExtendSearchPrintDataProvider;
import com.kingdee.eas.mm.basedata.client.LNBom4QueryTreeNodeCtrl;
import com.kingdee.eas.mm.basedata.client.OrderBomExtendSearchPrintDataProvider;
import com.kingdee.eas.mm.basedata.client.OrderBomExtendSearchQueryUI;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.YesOrNoEnum;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;

public class OrderBomExtendSearchListUI
extends AbstractOrderBomExtendSearchListUI {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_BOM = "com.kingdee.eas.mm.basedata.BOMResource";
    protected OrderBomExtendSearchQueryUI bomExtendSearchQueryUi;
    private CommonQueryDialog commonQueryDialog;
    protected IMetaDataPK mainQueryPK;
    private boolean showDialogOnLoad = true;
    private static final BigDecimal ZERO = new BigDecimal("0");
    protected ITreeBuilder treeBuilder;
    private BomTreeInfo sourceTreeNode = null;
    private DefaultKingdeeTreeNode currentNode = null;
    private StorageOrgUnitInfo souQuery = null;
    private MaterialInfo miQuery = null;
    private String bomNumberQuery = null;
    private BOMUsageEnum bueQuery = null;
    private BOMSearchFlagEnum queryType = null;
    private Date queryDate = null;
    private String pjQuery = null;
    private String tkQuery = null;
    private boolean orderQuery = false;
    private boolean downQuery = false;
    private boolean treeQuery = false;
    private ProjectInfo pinfo = null;
    private TrackNumberInfo tinfo = null;
    private static final String[] KDT_DATES = new String[]{"queryDate"};
    private List conditionList = new ArrayList();
    private Map materialIsConfigableMap = new HashMap();
    private int currentLocation = -1;
    private boolean materialIsConfigable = false;
    private BomTreeCondition treecondition = new BomTreeCondition();
    private TreeSelectionListener treeSelectionListener;
    private int freezeColIndex = 7;

    public OrderBomExtendSearchListUI() throws Exception {
        this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.mm.basedata.app", (String)"OrderBom4TreeQuery");
        this.kDTreeView1.setShowButton(false);
        this.kDTreeBOM.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    OrderBomExtendSearchListUI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    OrderBomExtendSearchListUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanelRTop.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 746, 200));
        this.kDPanelRBottom.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 746, 368));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDownQuery.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_downviewbom", (Locale)this.getLocale()));
        this.menuItemQueryDown.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_downviewbom", (Locale)this.getLocale()));
        this.menuItemPrintPreview.setEnabled(true);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPre);
        this.setButtonDefaultStyl(this.btnFirst);
        this.setButtonDefaultStyl(this.btnExport);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) {
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            TrackNumberInfo track;
            boolean expendFlag = true;
            this.sourceTreeNode = (BomTreeInfo)this.getSelectedTreeNode().getUserObject();
            this.currentNode = this.getSelectedTreeNode();
            BomTreeInfo treeInfo = (BomTreeInfo)this.currentNode.getUserObject();
            if (((KDTreeNode)this.currentNode.getParent()).getUserObject() instanceof BomTreeInfo) {
                this.sourceTreeNode = (BomTreeInfo)((KDTreeNode)this.currentNode.getParent()).getUserObject();
            }
            String bomId = treeInfo.getBomID();
            treeInfo.setBomType(treeInfo.getBomType());
            this.treecondition.setSerchMFGBOM(!this.treeQuery);
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(this.sourceTreeNode.getMaterialInfo().getId());
            MaterialInfo cmaterialInfo = new MaterialInfo();
            cmaterialInfo.setId(treeInfo.getMaterialInfo().getId());
            BomTreeCondition condition = new BomTreeCondition();
            String projectId = null;
            String trackId = null;
            ProjectInfo project = treeInfo.getProject();
            if (project != null) {
                projectId = project.getId().toString();
            }
            if ((track = treeInfo.getTrackNumber()) != null) {
                trackId = track.getId().toString();
            }
            condition.setProjectNumID(projectId);
            condition.setTrackNumID(trackId);
            condition.setBomID(bomId);
            condition.setBomtype(treeInfo.getBomType());
            condition.setBomUsage(this.bueQuery);
            condition.setFlag(true);
            condition.setMaterialID(treeInfo.getMaterialInfo().getId().toString());
            condition.setOnlyAuditStatus(true);
            condition.setQueryDate(this.queryDate);
            condition.setQueryType(this.queryType);
            condition.setStorageOrgUnitID(this.souQuery.getId().toString());
            this.downQuery = true;
            condition.setSerchMFGBOM(!this.treeQuery);
            condition.setOnlyAuditStatus(true);
            this.loadBomList(condition, true);
            this.downQuery = false;
            if (expendFlag) {
                try {
                    this.treeBuilder.refreshTreeNode(this.kDTreeBOM, this.getSelectedTreeNode());
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
            }
            this.kDTreeBOM.expandAllNodes(true, (TreeNode)this.getSelectedTreeNode());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed(true);
        this.dtEntry.checkParsed(true);
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
        String numberFormatString = CtrlFormatUtilities.getDecimalFormatString();
        String dateFormatString = CtrlFormatUtilities.getDateFormatString();
        this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("proportion").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setNumberFormat(numberFormatString);
        this.kDTable1.getColumn("productQty").getStyleAttributes().setNumberFormat(numberFormatString);
        this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(dateFormatString);
        this.dtEntry.getColumn("disableDate").getStyleAttributes().setNumberFormat(dateFormatString);
        EditTableUtil.formatColDate((KDTable)this.kDTable1, (String[])KDT_DATES);
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.dtEntry.getColumn("feture").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("canSelected").setEditor((ICellEditor)checkBoxEditor);
        this.dtEntry.getColumn("firstCfg").setEditor((ICellEditor)checkBoxEditor);
        this.kDTable1.getColumn("projectNumber").getStyleAttributes().setHided(false);
        this.kDTable1.getColumn("trackNumber").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("showProject").getStyleAttributes().setHided(true);
        this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
        this.treeQuery = true;
        if (this.showDialogOnLoad && !this.showQueryDialog()) {
            SysUtil.abort();
        }
        this.treeQuery = false;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().containsKey("IsFromTree")) {
            this.getUIContext().put("IsFromTree", Boolean.FALSE);
            this.getUIContext().put("BOMExtendSearchFilterCondition", new BOMExtendSearchFilterCondition());
        }
        this.treeQuery = true;
        this.showQueryDialog();
        this.treeQuery = false;
    }

    protected boolean showQueryDialog() {
        try {
            this.initCommonQueryDialog();
            this.bomExtendSearchQueryUi.getUIContext().clear();
            this.bomExtendSearchQueryUi.getUIContext().putAll(this.getUIContext());
            if (this.commonQueryDialog.show()) {
                this.kDTable1.removeRows();
                this.dtEntry.removeRows();
                OrderBomExtendSearchQueryUI potq = (OrderBomExtendSearchQueryUI)this.commonQueryDialog.getUserPanel(0);
                FilterInfo commonFI = this.commonQueryDialog.getCommonFilter();
                this.souQuery = (StorageOrgUnitInfo)potq.prmtStorageOrgUnit.getValue();
                this.miQuery = null != potq.prmtMaterial.getValue() ? (MaterialInfo)potq.prmtMaterial.getValue() : null;
                this.bueQuery = (BOMUsageEnum)((Object)potq.cmbBomUsage.getSelectedItem());
                this.bomNumberQuery = null != potq.prmtBom.getValue() ? ((BomInfo)potq.prmtBom.getValue()).getId().toString() : null;
                this.queryType = (BOMSearchFlagEnum)((Object)potq.cmbSearchType.getSelectedItem());
                this.queryDate = (Date)potq.kDDate.getValue();
                if (null != potq.prmtProjectNumber.getValue()) {
                    ProjectInfo prj = (ProjectInfo)potq.prmtProjectNumber.getValue();
                    this.pjQuery = prj.getId().toString();
                    this.orderQuery = true;
                } else {
                    this.pjQuery = null;
                }
                if (null != potq.prmtTrackNumber.getValue()) {
                    TrackNumberInfo track = (TrackNumberInfo)potq.prmtTrackNumber.getValue();
                    this.tkQuery = track.getId().toString();
                    this.orderQuery = true;
                } else {
                    this.tkQuery = null;
                }
                this.pinfo = (ProjectInfo)potq.prmtProjectNumber.getValue();
                this.tinfo = (TrackNumberInfo)potq.prmtTrackNumber.getValue();
                this.treecondition.setBomID(this.bomNumberQuery);
                this.treecondition.setBomUsage(this.bueQuery);
                this.treecondition.setFlag(true);
                if (this.miQuery != null) {
                    this.treecondition.setMaterialID(this.miQuery.getId().toString());
                }
                this.treecondition.setOnlyAuditStatus(true);
                this.treecondition.setQueryDate(this.queryDate);
                this.treecondition.setQueryType(this.queryType);
                this.treecondition.setOnlyAuditStatus(true);
                this.treecondition.setStorageOrgUnitID(this.souQuery.getId().toString());
                this.treecondition.setProjectNumID(this.pjQuery);
                this.treecondition.setTrackNumID(this.tkQuery);
                this.treecondition.setBomExtendFilterInfo(commonFI);
                this.actionDownQuery.setEnabled(false);
                this.actionFirst.setEnabled(false);
                this.actionPre.setEnabled(false);
                MaterialInfo materialInfo = (MaterialInfo)potq.prmtMaterial.getValue();
                MaterialInfo[] materialInfos = new MaterialInfo[]{materialInfo};
                SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)this.souQuery, (MaterialInfo[])materialInfos);
                String key1 = materialInfo.getId().toString() + this.souQuery.getId().toString();
                MaterialPlanInfo materialPlan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key1);
                this.materialIsConfigable = materialPlan.isIsConfigable();
                this.materialIsConfigableMap.put(key1, new Boolean(this.materialIsConfigable));
                this.treecondition.setBomtype(BOMTypeEnum.OrderBOM);
                this.searchResult(this.treecondition);
                return true;
            }
            return false;
        }
        catch (BomException e) {
            this.handUIException((Throwable)((Object)e));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        Object filterCondition = this.getUIContext().get("BOMExtendSearchFilterCondition");
        if (this.getUIContext().get("IsFromTree") != null && ((Boolean)this.getUIContext().get("IsFromTree")).booleanValue() && this.commonQueryDialog != null && filterCondition != null && filterCondition instanceof BOMExtendSearchFilterCondition) {
            this.commonQueryDialog = null;
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setUiObject((IUIObject)this);
            String classFullName = this.getMetaDataPK().getFullName();
            this.commonQueryDialog.setParentUIClassName(classFullName);
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setTitle(EASResource.getString((String)RESOURCE_BOM, (String)"bomSearchWindowTitle"));
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.commonQueryDialog.setShowShareType(16);
            try {
                this.bomExtendSearchQueryUi = new OrderBomExtendSearchQueryUI();
                this.commonQueryDialog.addUserPanel((KDPanel)this.bomExtendSearchQueryUi);
                this.commonQueryDialog.setWidth(580);
                this.commonQueryDialog.setHeight(435);
                String strParam = (String)this.getUIContext().get("UIClassParam");
                if (strParam != null && strParam.equals("1")) {
                    this.bomExtendSearchQueryUi.kDLabelContainer6.setVisible(true);
                    this.bomExtendSearchQueryUi.prmtProjectNumber.setVisible(true);
                    this.bomExtendSearchQueryUi.kDLabelContainer7.setVisible(true);
                    this.bomExtendSearchQueryUi.prmtTrackNumber.setVisible(true);
                    this.commonQueryDialog.setTitle(EASResource.getString((String)RESOURCE_BOM, (String)"orderbom_search_filter"));
                    this.getUIContext().put("orderBomExtend", "1");
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.commonQueryDialog;
    }

    private String getLevelStr(String level) {
        if (level.equals("1")) {
            return "*" + level;
        }
        if (level.equals("2")) {
            return "**" + level;
        }
        if (level.equals("3")) {
            return "***" + level;
        }
        if (level.equals("4")) {
            return "****" + level;
        }
        if (level.equals("5")) {
            return "*****" + level;
        }
        if (level.equals("6")) {
            return "******" + level;
        }
        if (level.equals("7")) {
            return "*******" + level;
        }
        return "********" + level;
    }

    public void searchResult(BomTreeCondition condition) throws BOSException, EASBizException {
        this.setDynamicResultCol(this.queryType, condition);
        this.kDTable1.removeRows();
        this.dtEntry.removeRows();
        if (this.queryType == BOMSearchFlagEnum.ManySearch) {
            this.kDSplitPaneLeft.setDividerSize(10);
            this.kDSplitPaneLeft.setDividerLocation(240);
            try {
                this.initTree(condition);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.kDSplitPaneLeft.setDividerSize(0);
            this.kDSplitPaneLeft.setDividerLocation(0);
            this.loadBomList(condition, true);
            this.conditionList.clear();
            this.conditionList.add(condition);
            this.currentLocation = 0;
            if (this.currentLocation == 0) {
                this.actionPre.setEnabled(false);
                this.actionFirst.setEnabled(false);
            } else {
                this.actionPre.setEnabled(true);
                this.actionFirst.setEnabled(true);
            }
            this.actionDownQuery.setEnabled(false);
        }
    }

    private String getParentMaterialNumber() {
        int[] rowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (rowIndexes == null || rowIndexes.length == 0) {
            return null;
        }
        ICell cell = this.kDTable1.getCell(rowIndexes[0], "parentMaterialNumber");
        String parentMaterialNumber = (String)cell.getValue();
        return parentMaterialNumber;
    }

    private BOMTypeEnum getBomType() {
        int[] rowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (rowIndexes == null || rowIndexes.length == 0) {
            return null;
        }
        return this.getBomType(rowIndexes[0]);
    }

    private BOMTypeEnum getBomType(int rowIndex) {
        ICell cell = this.kDTable1.getCell(rowIndex, "BOMType");
        String bomTypeAlis = (String)cell.getValue();
        if (BOMTypeEnum.OrderBOM.getAlias().equals(bomTypeAlis)) {
            return BOMTypeEnum.OrderBOM;
        }
        return BOMTypeEnum.MfgBOM;
    }

    private String getProjectNumber() {
        int[] rowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (rowIndexes == null || rowIndexes.length == 0) {
            return null;
        }
        ICell cell = this.kDTable1.getCell(rowIndexes[0], "projectNumber");
        String prjectNumber = (String)cell.getValue();
        return prjectNumber;
    }

    private String[] getTrackNumber() {
        int[] rowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (rowIndexes == null || rowIndexes.length == 0) {
            return null;
        }
        ICell cell = this.kDTable1.getCell(rowIndexes[0], "trackNumber");
        String trackNums = (String)cell.getValue();
        if (MMUtils.isEmptyString((String)trackNums)) {
            return null;
        }
        String[] trackNumbers = trackNums.split(";");
        return trackNumbers;
    }

    private void setDynamicResultCol(BOMSearchFlagEnum type, BomTreeCondition condition) {
        if (type == BOMSearchFlagEnum.ManySearch) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else if (type == BOMSearchFlagEnum.SampleSearch) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(true);
            this.setColumnByBOMType(condition);
        } else if (type == BOMSearchFlagEnum.MutliSraech) {
            if (this.bueQuery != BOMUsageEnum.Master) {
                this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(true);
                this.setColumnByBOMType(condition);
            } else {
                this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(false);
                this.dtEntry.getColumn("showProject").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
                this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
            }
        } else if (type == BOMSearchFlagEnum.IntegratedSearch) {
            this.dtEntry.getColumn("levelNo").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialNumber").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialName").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialModel").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("childMaterialAttr").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("consumeType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("consumeFixQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("proportion").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("parentProductQty").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childMaterialUnit").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("scrapRatio").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("effectiveDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("disableDate").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("outputType").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("materialChara").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("pickingMode").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("defaultWarehouseName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMNumber").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("BOMName").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("childConsumeQty").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("showProject").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
        }
        this.dtEntry.setColumnMoveable(false);
        this.dtEntry.setEditable(false);
    }

    private void setColumnByBOMType(BomTreeCondition condition) {
        this.dtEntry.getColumn("showProject").getStyleAttributes().setHided(true);
        this.dtEntry.getColumn("showTrack").getStyleAttributes().setHided(true);
        this.dtEntry.getColumn("netWeight").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("blkSize").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("specifiedLength").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("usedUnit").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("designUnit").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("designRemark").getStyleAttributes().setHided(false);
        this.dtEntry.getColumn("feture").getStyleAttributes().setHided(true);
        this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(true);
        this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(true);
        if (this.materialIsConfigable) {
            this.dtEntry.getColumn("feture").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("canSelected").getStyleAttributes().setHided(false);
            this.dtEntry.getColumn("firstCfg").getStyleAttributes().setHided(false);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.kDTreeBOM.getLastSelectedPathComponent();
    }

    public void initTree(BomTreeCondition condition) throws Exception {
        this.kDTreeBOM.setRootVisible(false);
        TreeSelectionListener[] listeners = this.kDTreeBOM.getTreeSelectionListeners();
        TreeSelectionListener treeSelectionListener = this.treeSelectionListener = listeners.length > 0 ? listeners[0] : null;
        if (this.treeSelectionListener != null) {
            this.kDTreeBOM.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(condition), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree(), (SelectorItemCollection)this.getSelectorForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.kDTreeBOM.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.kDTreeBOM.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.kDTreeBOM);
        if (this.treeSelectionListener != null) {
            this.kDTreeBOM.addTreeSelectionListener(this.treeSelectionListener);
        }
        this.kDTreeBOM.setShowPopMenuDefaultItem(true);
        this.kDTreeBOM.expandOnLevel(3);
        if (((KDTreeNode)((DefaultTreeModel)this.kDTreeBOM.getModel()).getRoot()).getChildCount() > 0) {
            this.kDTreeBOM.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)((DefaultTreeModel)this.kDTreeBOM.getModel()).getRoot()).getChildAt(0));
        } else {
            this.currentNode = (DefaultKingdeeTreeNode)((DefaultTreeModel)this.kDTreeBOM.getModel()).getRoot();
        }
    }

    public void initUserConfig() {
        super.initUserConfig();
        this.setDynamicResultCol(this.queryType, this.treecondition);
    }

    protected FilterInfo getDefaultFilterForTree() {
        return null;
    }

    protected int getTreeExpandLevel() {
        return 1;
    }

    protected SelectorItemCollection getSelectorForTree() {
        return null;
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl(BomTreeCondition condition) throws Exception {
        return new LNBom4QueryTreeNodeCtrl(this.souQuery, this.miQuery, this.bomNumberQuery, this.bueQuery, this.queryDate, this.queryType, BOMTypeEnum.OrderBOM, true, this.pinfo, this.tinfo, condition);
    }

    protected int getTreeInitialLevel() {
        return 2;
    }

    protected String getRootName() {
        return "BOM ROOT";
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    @Override
    protected void dtEntry_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.queryType == BOMSearchFlagEnum.ManySearch || this.queryType == BOMSearchFlagEnum.MutliSraech || this.queryType == BOMSearchFlagEnum.IntegratedSearch) {
            return;
        }
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (-1 == selectedIndex) {
            return;
        }
        IRow row = this.dtEntry.getRow(selectedIndex);
        ICell cell = row.getCell("childMaterialID");
        String materialId = (String)cell.getValue();
        if (null != materialId) {
            this.actionDownQuery.setEnabled(true);
        } else {
            this.actionDownQuery.setEnabled(false);
        }
    }

    @Override
    protected void kDTable1_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.kDTable1_tableSelectChanged(e);
        int selectedIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow row = this.kDTable1.getRow(selectedIndex);
        ICell cell = row.getCell("BOMID");
        String value = (String)cell.getValue();
        cell = row.getCell("parentMaterialID");
        String materialId = (String)cell.getValue();
        cell = row.getCell("productQty");
        BigDecimal bd = new BigDecimal((String)cell.getValue());
        if (null != value) {
            cell = row.getCell("BOMType");
            String bomTypeStr = cell.getValue().toString();
            BOMTypeEnum bomType = this.getBOMTypeByAlias(bomTypeStr);
            try {
                this.loadResultList(value, bomType, materialId, bd);
            }
            catch (Exception exce) {
                this.handUIException(exce);
            }
        }
    }

    private BOMTypeEnum getBOMTypeByAlias(String alias) {
        List list = BOMTypeEnum.getEnumList();
        Object obj = null;
        BOMTypeEnum bomType = null;
        for (int i = 0; !(i >= list.size() || (obj = list.get(i)) != null && (bomType = (BOMTypeEnum)obj).getAlias().equals(alias)); ++i) {
        }
        return bomType;
    }

    @Override
    public void actionDownQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionDownQuery_actionPerformed(e);
        int selectedIndex = this.dtEntry.getSelectManager().getActiveRowIndex();
        if (-1 != selectedIndex) {
            IRow row = this.dtEntry.getRow(selectedIndex);
            ICell cell = row.getCell("childMaterialID");
            String materialId = (String)cell.getValue();
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)materialId));
            MaterialInfo[] materialInfos = new MaterialInfo[]{materialInfo};
            try {
                SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)this.souQuery, (MaterialInfo[])materialInfos);
                String key1 = materialInfo.getId().toString() + this.souQuery.getId().toString();
                MaterialPlanInfo materialPlan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key1);
                this.materialIsConfigable = materialPlan.isIsConfigable();
                this.materialIsConfigableMap.put(key1, new Boolean(this.materialIsConfigable));
            }
            catch (EASBizException e2) {
                this.handUIException(e2);
            }
            catch (BOSException e2) {
                this.handUIException(e2);
            }
            if (null != materialId) {
                BomTreeCondition condition = new BomTreeCondition();
                condition.setBomID(null);
                condition.setBomUsage(this.bueQuery);
                condition.setFlag(true);
                condition.setMaterialID(materialId);
                condition.setOnlyAuditStatus(true);
                condition.setQueryDate(this.queryDate);
                condition.setQueryType(this.queryType);
                condition.setBomtype(this.getBomType());
                String projectNumber = this.getProjectNumber();
                String[] trackNumbers = this.getTrackNumber();
                if (MMUtils.isNotEmptyString((String)projectNumber)) {
                    condition.setProjectNumID(this.pjQuery);
                }
                if (trackNumbers != null && trackNumbers.length > 0) {
                    condition.setTrackNumID(this.tkQuery);
                }
                this.downQuery = true;
                condition.setSerchMFGBOM(this.downQuery);
                condition.setDownQuery(this.downQuery);
                condition.setStorageOrgUnitID(this.souQuery.getId().toString());
                condition.setOnlyAuditStatus(true);
                String parentMaterialNumber = this.getParentMaterialNumber();
                condition.setParentMaterialNumber(parentMaterialNumber);
                this.conditionList.add(condition);
                this.loadBomList(condition, true);
                this.downQuery = false;
                ++this.currentLocation;
                if (this.currentLocation == 0) {
                    this.actionPre.setEnabled(false);
                    this.actionFirst.setEnabled(false);
                } else {
                    this.actionPre.setEnabled(true);
                    this.actionFirst.setEnabled(true);
                }
                this.actionDownQuery.setEnabled(false);
            }
        }
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.currentLocation = 0;
        BomTreeCondition condition = (BomTreeCondition)this.conditionList.get(this.currentLocation);
        this.conditionList.clear();
        this.conditionList.add(condition);
        if (condition == null) {
            return;
        }
        String materialId = condition.getMaterialID();
        String storageId = condition.getStorageOrgUnitID();
        String key = materialId + storageId;
        boolean isConfigabled = false;
        if (this.materialIsConfigableMap.containsKey(key)) {
            Boolean isConfigabledObj = (Boolean)this.materialIsConfigableMap.get(key);
            isConfigabled = isConfigabledObj;
        } else {
            isConfigabled = this.isConfigable(storageId, materialId);
        }
        this.materialIsConfigable = isConfigabled;
        this.loadBomList(condition, true);
        if (this.currentLocation == 0) {
            this.actionPre.setEnabled(false);
            this.actionFirst.setEnabled(false);
        } else {
            this.actionPre.setEnabled(true);
            this.actionFirst.setEnabled(true);
        }
        this.actionDownQuery.setEnabled(false);
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        --this.currentLocation;
        BomTreeCondition condition = (BomTreeCondition)this.conditionList.get(this.currentLocation);
        this.conditionList.remove(this.currentLocation + 1);
        if (condition == null) {
            return;
        }
        String materialId = condition.getMaterialID();
        String storageId = condition.getStorageOrgUnitID();
        String key = materialId + storageId;
        boolean isConfigabled = false;
        if (this.materialIsConfigableMap.containsKey(key)) {
            Boolean isConfigabledObj = (Boolean)this.materialIsConfigableMap.get(key);
            isConfigabled = isConfigabledObj;
        } else {
            isConfigabled = this.isConfigable(storageId, materialId);
        }
        this.materialIsConfigable = isConfigabled;
        this.downQuery = true;
        this.loadBomList(condition, true);
        this.downQuery = false;
        if (this.currentLocation == 0) {
            this.actionPre.setEnabled(false);
            this.actionFirst.setEnabled(false);
        } else {
            this.actionPre.setEnabled(true);
            this.actionFirst.setEnabled(true);
        }
        this.actionDownQuery.setEnabled(false);
    }

    private void loadBomList(BomTreeCondition condition, boolean isSelectFirstRow) {
        IRowSet rowSet = null;
        try {
            rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getBomList4Query(condition);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.kDTable1.removeRows();
        if (null != rowSet) {
            IRow row = null;
            try {
                if (this.queryType != BOMSearchFlagEnum.IntegratedSearch && this.queryType != BOMSearchFlagEnum.MutliSraech) {
                    this.setColumnByBOMType(condition);
                }
                while (null != rowSet && rowSet.next()) {
                    row = this.kDTable1.addRow();
                    this.fillupTableRow(row, rowSet);
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
        if (isSelectFirstRow) {
            if (this.kDTable1.getRowCount() > 0) {
                this.kDTable1.getSelectManager().select(0, 0, 2);
            } else {
                this.dtEntry.removeRows();
            }
        } else {
            this.dtEntry.removeRows();
        }
    }

    private boolean fillupTableRow(IRow row, IRowSet rowSet) {
        boolean flag = true;
        String enumName = null;
        try {
            row.getCell("storageOrgUnitNumber").setValue((Object)rowSet.getString("ORGNAME"));
            row.getCell("queryDate").setValue((Object)this.queryDate);
            row.getCell("searchType").setValue((Object)this.queryType.getAlias());
            row.getCell("parentMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
            row.getCell("parentMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
            row.getCell("parentMaterialModel").setValue((Object)rowSet.getString("MATERIALMODE"));
            row.getCell("productQty").setValue((Object)rowSet.getString("PRODUCTQTY"));
            row.getCell("parentMaterialUnit").setValue((Object)rowSet.getString("UNITNAME"));
            enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("MATERIALATTR"));
            row.getCell("parentMaterialAttr").setValue((Object)enumName);
            row.getCell("BOMNumber").setValue((Object)rowSet.getString("BOMNUMBER"));
            enumName = BOMTypeEnum.getEnum(Integer.parseInt(rowSet.getString("BOMTYPE"))).getAlias();
            row.getCell("BOMType").setValue((Object)enumName);
            enumName = BOMUsageEnum.getEnum(Integer.parseInt(rowSet.getString("BOMUSAGETYPE"))).getAlias();
            row.getCell("BOMUsage").setValue((Object)enumName);
            row.getCell("BOMID").setValue((Object)rowSet.getString("BOMID"));
            row.getCell("parentMaterialID").setValue((Object)rowSet.getString("MATERIALID"));
            if (this.orderQuery && rowSet.getInt("BOMTYPE") == 45) {
                String projectNumber = rowSet.getString("ProjectNumber");
                if (MMUtils.isNotEmptyString((String)projectNumber)) {
                    row.getCell("projectNumber").setValue((Object)projectNumber);
                }
                String trackNumber = rowSet.getString("trackNumber");
                row.getCell("trackNumber").setValue((Object)trackNumber);
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        return flag;
    }

    private IRowSet getResultRowSet(BomTreeCondition condition, String bomId, String materialId) throws EASBizException, BOSException {
        IRowSet rowSet = null;
        BOMSearchFlagEnum queryType = condition.getQueryType();
        if (condition.getQueryType() != BOMSearchFlagEnum.MutliSraech && condition.getQueryType() != BOMSearchFlagEnum.IntegratedSearch) {
            rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getResultList4Query(condition);
        } else if (BOMSearchFlagEnum.MutliSraech.equals((Object)queryType)) {
            ArrayList<String> returnFieldList = new ArrayList<String>();
            returnFieldList.add("FCHILDMATERIALID");
            returnFieldList.add("FMaterialNumber");
            returnFieldList.add("FMaterialName");
            returnFieldList.add("FMODEL");
            returnFieldList.add("FUnitName");
            returnFieldList.add("FMaterialAttr");
            returnFieldList.add("FBaseQty");
            returnFieldList.add("qtyPrecision");
            String[] returnFields = returnFieldList.toArray(new String[0]);
            BOMExtendCondition condition1 = new BOMExtendCondition();
            condition1.setBOMSearchFlagEnum(queryType);
            condition1.setExtendLevel(BOMExtendLevelEnum.EndLevelExtend);
            condition1.setStorateOrgID(this.souQuery.getId().toString());
            condition1.setGroupByMaterial(true);
            condition1.setOnlyExtendConfig(false);
            condition1.setOnlyExtendVirtual(false);
            condition1.setReturnFields(returnFields);
            condition1.setProjectNumID(this.pjQuery);
            condition1.setTrackNumID(this.tkQuery);
            condition1.setOrderBom(this.orderQuery);
            condition1.setBomId(bomId);
            rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
        } else if (BOMSearchFlagEnum.IntegratedSearch.equals((Object)queryType)) {
            ArrayList<String> returnFieldList = new ArrayList<String>();
            returnFieldList.add("FCHILDMATERIALID");
            returnFieldList.add("FMaterialNumber");
            returnFieldList.add("FMaterialName");
            returnFieldList.add("FMODEL");
            returnFieldList.add("FUnitName");
            returnFieldList.add("FMaterialAttr");
            returnFieldList.add("FBaseQty");
            returnFieldList.add("qtyPrecision");
            String[] returnFields = returnFieldList.toArray(new String[0]);
            BOMExtendCondition conditionForIntegratedSearch = new BOMExtendCondition();
            conditionForIntegratedSearch.setBOMSearchFlagEnum(queryType);
            conditionForIntegratedSearch.setExtendLevel(BOMExtendLevelEnum.IntegratedExtend);
            conditionForIntegratedSearch.setStorateOrgID(this.souQuery.getId().toString());
            conditionForIntegratedSearch.setGroupByMaterial(true);
            conditionForIntegratedSearch.setOnlyExtendConfig(false);
            conditionForIntegratedSearch.setOnlyExtendVirtual(false);
            conditionForIntegratedSearch.setReturnFields(returnFields);
            conditionForIntegratedSearch.setProjectNumID(this.pjQuery);
            conditionForIntegratedSearch.setTrackNumID(this.tkQuery);
            conditionForIntegratedSearch.setOrderBom(this.orderQuery);
            conditionForIntegratedSearch.setBomId(bomId);
            rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, conditionForIntegratedSearch);
        }
        return rowSet;
    }

    private void loadDataOfMutliSraech(IRowSet rowSet) throws SQLException {
        this.dtEntry.removeRows();
        IRow row = null;
        BigDecimal bd = null;
        String enumName = null;
        while (null != rowSet && rowSet.next()) {
            row = this.dtEntry.addRow();
            row.getCell("childMaterialID").setValue((Object)rowSet.getString("FchildMaterialID"));
            row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("FMaterialNumber"));
            row.getCell("childMaterialName").setValue((Object)rowSet.getString("FMaterialName"));
            row.getCell("childMaterialModel").setValue((Object)rowSet.getString("FModel"));
            enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("FMATERIALATTR"));
            row.getCell("childMaterialAttr").setValue((Object)enumName);
            row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("FUnitname"));
            bd = rowSet.getBigDecimal("FBaseQty");
            bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
            row.getCell("childConsumeQty").setValue((Object)bd);
        }
    }

    private void loadDataOfSampleSearch(IRowSet rowSet) throws SQLException {
        this.dtEntry.removeRows();
        IRow row = null;
        String enumName = null;
        while (null != rowSet && rowSet.next()) {
            row = this.dtEntry.addRow();
            row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
            row.getCell("childMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
            row.getCell("childMaterialModel").setValue((Object)rowSet.getString("MATERIALMODE"));
            enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("MATERIALATTR"));
            row.getCell("childMaterialAttr").setValue((Object)enumName);
            enumName = UIHelper.getAlias(ConsumeTypeEnum.class, (int)rowSet.getInt("CONSUMETYPE"));
            row.getCell("consumeType").setValue((Object)enumName);
            row.getCell("consumeFixQty").setValue((Object)rowSet.getString("CONSUMEFIXQTY"));
            row.getCell("proportion").setValue((Object)rowSet.getString("PROPORTION"));
            row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("UNITNAME"));
            row.getCell("scrapRatio").setValue((Object)rowSet.getString("SCRAPRATIO"));
            row.getCell("effectiveDate").setValue((Object)rowSet.getString("EFFECTIVEDATE"));
            row.getCell("disableDate").setValue((Object)rowSet.getString("DISABLEDATE"));
            enumName = UIHelper.getAlias(MaterialProductEnum.class, (int)rowSet.getInt("OUTPUTTYPE"));
            row.getCell("outputType").setValue((Object)enumName);
            enumName = UIHelper.getAlias(MaterialCharEnum.class, (int)rowSet.getInt("MATERIALCHAR"));
            row.getCell("materialChara").setValue((Object)enumName);
            enumName = UIHelper.getAlias(MaterialIssueModeEnum.class, (int)rowSet.getInt("ISSMODE"));
            row.getCell("pickingMode").setValue((Object)enumName);
            row.getCell("defaultWarehouseName").setValue((Object)rowSet.getString("DEFAULTWAREHOUSENAME"));
            row.getCell("childMaterialID").setValue((Object)rowSet.getString("MATERIALID"));
            row.getCell("showProject").setValue((Object)rowSet.getString("showProject"));
            row.getCell("showTrack").setValue((Object)rowSet.getString("showTrack"));
            row.getCell("netWeight").setValue((Object)this.formatZero(rowSet.getString("netWeight")));
            row.getCell("blkSize").setValue((Object)rowSet.getString("blkSize"));
            row.getCell("specifiedLength").setValue((Object)rowSet.getString("specifiedLength"));
            row.getCell("usedUnit").setValue((Object)rowSet.getString("usedUnit"));
            row.getCell("designUnit").setValue((Object)rowSet.getString("designUnit"));
            row.getCell("designRemark").setValue((Object)rowSet.getString("designRemark"));
            row.getCell("feture").setValue((Object)rowSet.getBoolean("feture"));
            row.getCell("canSelected").setValue((Object)rowSet.getBoolean("canSelected"));
            row.getCell("firstCfg").setValue((Object)rowSet.getBoolean("firstCfg"));
        }
    }

    private void loadDataOfManySearch(IRowSet rowSet, String bomId) throws SQLException {
        this.dtEntry.removeRows();
        IRow row = null;
        String enumName = null;
        BomTreeInfo treeInfo = (BomTreeInfo)this.currentNode.getUserObject();
        if (treeInfo != null) {
            treeInfo.setBomID(bomId);
        }
        while (null != rowSet && rowSet.next()) {
            row = this.dtEntry.addRow();
            row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("MATERIALNUMBER"));
            row.getCell("childMaterialName").setValue((Object)rowSet.getString("MATERIALNAME"));
            row.getCell("childMaterialModel").setValue((Object)rowSet.getString("MATERIALMODE"));
            enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("MATERIALATTR"));
            row.getCell("childMaterialAttr").setValue((Object)enumName);
            enumName = UIHelper.getAlias(ConsumeTypeEnum.class, (int)rowSet.getInt("CONSUMETYPE"));
            row.getCell("consumeType").setValue((Object)enumName);
            row.getCell("consumeFixQty").setValue((Object)rowSet.getString("CONSUMEFIXQTY"));
            row.getCell("proportion").setValue((Object)rowSet.getString("PROPORTION"));
            row.getCell("parentProductQty").setValue((Object)rowSet.getString("PRODUCTQTY"));
            row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("UNITNAME"));
            row.getCell("scrapRatio").setValue((Object)rowSet.getString("SCRAPRATIO"));
            row.getCell("effectiveDate").setValue((Object)rowSet.getString("EFFECTIVEDATE"));
            row.getCell("disableDate").setValue((Object)rowSet.getString("DISABLEDATE"));
            enumName = UIHelper.getAlias(MaterialProductEnum.class, (int)rowSet.getInt("OUTPUTTYPE"));
            row.getCell("outputType").setValue((Object)enumName);
            enumName = UIHelper.getAlias(MaterialCharEnum.class, (int)rowSet.getInt("MATERIALCHAR"));
            row.getCell("materialChara").setValue((Object)enumName);
            enumName = UIHelper.getAlias(MaterialIssueModeEnum.class, (int)rowSet.getInt("ISSMODE"));
            row.getCell("pickingMode").setValue((Object)enumName);
            row.getCell("defaultWarehouseName").setValue((Object)rowSet.getString("DEFAULTWAREHOUSENAME"));
            row.getCell("BOMNumber").setValue((Object)rowSet.getString("BOMNUMBER"));
            row.getCell("BOMName").setValue((Object)rowSet.getString("BOMNAME"));
            row.getCell("childMaterialID").setValue((Object)rowSet.getString("MATERIALID"));
            row.getCell("showProject").setValue((Object)rowSet.getString("showProject"));
            row.getCell("showTrack").setValue((Object)rowSet.getString("showTrack"));
            row.getCell("netWeight").setValue((Object)this.formatZero(rowSet.getString("netWeight")));
            row.getCell("blkSize").setValue((Object)rowSet.getString("blkSize"));
            row.getCell("specifiedLength").setValue((Object)rowSet.getString("specifiedLength"));
            row.getCell("usedUnit").setValue((Object)rowSet.getString("usedUnit"));
            row.getCell("designUnit").setValue((Object)rowSet.getString("designUnit"));
            row.getCell("designRemark").setValue((Object)rowSet.getString("designRemark"));
            row.getCell("feture").setValue((Object)rowSet.getBoolean("feture"));
            row.getCell("canSelected").setValue((Object)rowSet.getBoolean("canSelected"));
            row.getCell("firstCfg").setValue((Object)rowSet.getBoolean("firstCfg"));
        }
    }

    private void loadDataOfIntegratedSearch(IRowSet rowSet) throws SQLException {
        this.dtEntry.removeRows();
        IRow row = null;
        String enumName = null;
        BigDecimal bd = null;
        while (null != rowSet && rowSet.next()) {
            row = this.dtEntry.addRow();
            row.getCell("childMaterialID").setValue((Object)rowSet.getString("FchildMaterialID"));
            row.getCell("childMaterialNumber").setValue((Object)rowSet.getString("FMaterialNumber"));
            row.getCell("childMaterialName").setValue((Object)rowSet.getString("FMaterialName"));
            row.getCell("childMaterialModel").setValue((Object)rowSet.getString("FModel"));
            enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)rowSet.getInt("FMATERIALATTR"));
            row.getCell("childMaterialAttr").setValue((Object)enumName);
            row.getCell("childMaterialUnit").setValue((Object)rowSet.getString("FUnitname"));
            bd = rowSet.getBigDecimal("FBaseQty");
            bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
            row.getCell("childConsumeQty").setValue((Object)bd);
        }
    }

    private void loadResultList(String bomId, BOMTypeEnum bomType, String materialId, BigDecimal productQty) throws Exception {
        if (MMUtils.isEmptyString((String)bomId)) {
            return;
        }
        this.dtEntry.removeRows();
        BomTreeCondition condition = new BomTreeCondition();
        condition.setBomtype(bomType);
        condition.setBomID(bomId);
        if (BOMSearchFlagEnum.MutliSraech.equals((Object)this.queryType) && this.bueQuery != BOMUsageEnum.Master) {
            condition.setQueryType(BOMSearchFlagEnum.SampleSearch);
        }
        condition.setQueryDate(this.queryDate);
        if (!this.downQuery) {
            condition.setProjectNumID(this.pjQuery);
            condition.setTrackNumID(this.tkQuery);
        }
        condition.setSerchMFGBOM(this.downQuery);
        condition.setQueryType(this.queryType);
        IRowSet rowSet = this.getResultRowSet(condition, bomId, materialId);
        if (rowSet == null) {
            return;
        }
        if (BOMSearchFlagEnum.MutliSraech == condition.getQueryType()) {
            this.loadDataOfMutliSraech(rowSet);
        } else if (BOMSearchFlagEnum.SampleSearch == condition.getQueryType()) {
            this.loadDataOfSampleSearch(rowSet);
        } else if (BOMSearchFlagEnum.ManySearch == condition.getQueryType()) {
            this.loadDataOfManySearch(rowSet, bomId);
        } else if (BOMSearchFlagEnum.IntegratedSearch == condition.getQueryType()) {
            this.loadDataOfIntegratedSearch(rowSet);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = this.preparePrintDate();
        BOMSearchFlagEnum tmp = this.queryType;
        if (tmp == BOMSearchFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchFlagEnum.SampleSearch;
        }
        BomExtendSearchPrintDataProvider data = new BomExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, false, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map resultMap = this.preparePrintDate();
        BOMSearchFlagEnum tmp = this.queryType;
        if (tmp == BOMSearchFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
            tmp = BOMSearchFlagEnum.SampleSearch;
        }
        OrderBomExtendSearchPrintDataProvider data = new OrderBomExtendSearchPrintDataProvider(resultMap, tmp, this.kDTable1, this.dtEntry);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, true, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private String getTemplatePath(BOMSearchFlagEnum queryType) {
        String templatePath = null;
        if (BOMSearchFlagEnum.SampleSearch == queryType) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_SINGLE.r1-print";
        } else if (BOMSearchFlagEnum.ManySearch == queryType) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_TREE.r1-print";
        } else if (BOMSearchFlagEnum.MultilevelSearch == queryType) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_MANY.r1-print";
        } else if (BOMSearchFlagEnum.MutliSraech == queryType) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_MULTI.r1-print";
        } else if (BOMSearchFlagEnum.IntegratedSearch == queryType) {
            templatePath = "/MM/basedata/BOM/BOMEXTENDSEARCH_INTEGRATED.r1-print";
        }
        return templatePath;
    }

    private Map preparePrintDate() throws Exception {
        HashMap<Integer, IRowSet> map = new HashMap<Integer, IRowSet>();
        String bomId = null;
        String materialId = null;
        IRow bomRow = null;
        ICell cell = null;
        int count = this.kDTable1.getRowCount();
        for (int i = 0; i < count; ++i) {
            BOMExtendCondition condition1;
            String[] returnFields;
            ArrayList<String> returnFieldList;
            bomRow = this.kDTable1.getRow(i);
            cell = bomRow.getCell("BOMID");
            bomId = (String)cell.getValue();
            cell = bomRow.getCell("parentMaterialID");
            materialId = (String)cell.getValue();
            BomTreeCondition condition = new BomTreeCondition();
            condition.setBomtype(this.getBomType(i));
            condition.setBomID(bomId);
            condition.setQueryType(this.queryType);
            condition.setProjectNumID(this.pjQuery);
            condition.setTrackNumID(this.tkQuery);
            if (this.queryType == BOMSearchFlagEnum.MutliSraech && this.bueQuery != BOMUsageEnum.Master) {
                condition.setQueryType(BOMSearchFlagEnum.SampleSearch);
            }
            condition.setQueryDate(this.queryDate);
            IRowSet rowSet = null;
            if (condition.getQueryType() == BOMSearchFlagEnum.SampleSearch) {
                try {
                    rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getResultList4Query(condition);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else if (condition.getQueryType() == BOMSearchFlagEnum.ManySearch) {
                returnFieldList = new ArrayList<String>();
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("FConsumeType");
                returnFieldList.add("FProportion");
                returnFieldList.add("FScrapRatio");
                returnFieldList.add("FEffectiveDate");
                returnFieldList.add("FDisableDate");
                returnFieldList.add("FOutputType");
                returnFieldList.add("FMaterialChar");
                returnFieldList.add("FIssMode");
                returnFieldList.add("FDefaultWarehouseName");
                returnFieldList.add("FLevel");
                returnFieldList.add("FBomId");
                returnFieldList.add("FParentBomId");
                returnFieldList.add("FBomName");
                returnFieldList.add("FParentComsumeQty");
                returnFieldList.add("Fnumber");
                returnFields = returnFieldList.toArray(new String[0]);
                condition1 = new BOMExtendCondition();
                condition1.setExtendLevel(BOMExtendLevelEnum.AllLevelExtend);
                condition1.setBOMSearchFlagEnum(BOMSearchFlagEnum.ManySearch);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(false);
                condition1.setOnlyExtendConfig(true);
                condition1.setOnlyExtendVirtual(false);
                condition1.setReturnFields(returnFields);
                condition1.setProjectNumID(this.pjQuery);
                condition1.setTrackNumID(this.tkQuery);
                condition1.setOrderBom(this.orderQuery);
                try {
                    rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getResultList4Query(condition);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else if (condition.getQueryType() == BOMSearchFlagEnum.MutliSraech) {
                returnFieldList = new ArrayList();
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFields = returnFieldList.toArray(new String[0]);
                condition1 = new BOMExtendCondition();
                condition1.setExtendLevel(BOMExtendLevelEnum.EndLevelExtend);
                condition1.setBOMSearchFlagEnum(BOMSearchFlagEnum.MutliSraech);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(true);
                condition1.setOnlyExtendConfig(false);
                condition1.setOnlyExtendVirtual(false);
                condition1.setReturnFields(returnFields);
                condition1.setProjectNumID(this.pjQuery);
                condition1.setTrackNumID(this.tkQuery);
                condition1.setOrderBom(this.orderQuery);
                try {
                    rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            } else if (condition.getQueryType() == BOMSearchFlagEnum.IntegratedSearch) {
                returnFieldList = new ArrayList();
                returnFieldList.add("FCHILDMATERIALID");
                returnFieldList.add("FMaterialNumber");
                returnFieldList.add("FMaterialName");
                returnFieldList.add("FMODEL");
                returnFieldList.add("FUnitName");
                returnFieldList.add("FMaterialAttr");
                returnFieldList.add("FBaseQty");
                returnFieldList.add("qtyPrecision");
                returnFields = returnFieldList.toArray(new String[0]);
                condition1 = new BOMExtendCondition();
                condition1.setExtendLevel(BOMExtendLevelEnum.IntegratedExtend);
                condition1.setBOMSearchFlagEnum(BOMSearchFlagEnum.IntegratedSearch);
                condition1.setStorateOrgID(this.souQuery.getId().toString());
                condition1.setGroupByMaterial(true);
                condition1.setOnlyExtendConfig(false);
                condition1.setOnlyExtendVirtual(false);
                condition1.setReturnFields(returnFields);
                condition1.setProjectNumID(this.pjQuery);
                condition1.setTrackNumID(this.tkQuery);
                condition1.setOrderBom(this.orderQuery);
                try {
                    rowSet = BOMExtend2FacadeFactory.getRemoteInstance().getExtendRowSetByMaterialID(materialId, this.queryDate, condition1);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            }
            if (null == rowSet) continue;
            map.put(new Integer(i), rowSet);
        }
        return map;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        int loop = 0;
        int count = this.kDTable1.getRowCount();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotExport"));
            return;
        }
        IRow bomRow = null;
        KDTHead head = this.kDTable1.getHead();
        ArrayList headList = head.getRow(0).getCells();
        IRow resultRow = null;
        head = this.dtEntry.getHead();
        ArrayList resultHeadList = head.getRow(0).getCells();
        File tempFile = File.createTempFile("tmp", ".xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Sheet1");
        int curRowIndex = 0;
        HSSFRow row = null;
        HSSFCell hcell = null;
        Object obj = null;
        Boolean tmpBoolean = Boolean.FALSE;
        HSSFCellStyle style = null;
        HSSFPalette palette = wb.getCustomPalette();
        palette.setColorAtIndex(IndexedColors.BLUE_GREY.index, (byte)this.kDTable1.getHeadSSA().getBackground().getRed(), (byte)this.kDTable1.getHeadSSA().getBackground().getGreen(), (byte)this.kDTable1.getHeadSSA().getBackground().getBlue());
        row = sheet.createRow(curRowIndex++);
        hcell = row.createCell(5);
        if (this.queryType == BOMSearchFlagEnum.MutliSraech) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.orderBomMultiSearch")));
        } else if (this.queryType == BOMSearchFlagEnum.ManySearch) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.orderBomManySearch")));
        } else if (this.queryType == BOMSearchFlagEnum.SampleSearch) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.orderBomSimpleSearch")));
        } else if (this.queryType == BOMSearchFlagEnum.IntegratedSearch) {
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.orderBomIntegratedSearch")));
        }
        style = wb.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
        hcell.setCellStyle(style);
        for (int i = 0; i < count; ++i) {
            int k;
            this.kDTable1.getSelectManager().select(i, 0);
            bomRow = this.kDTable1.getRow(i);
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.parentMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            int count1 = headList.size();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)headList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = this.kDTable1.getColumnCount();
            for (k = 0; k < count1; ++k) {
                if (this.kDTable1.getColumn(k).getStyleAttributes().isHided()) continue;
                if (this.kDTable1.getColumn(k).getKey().equalsIgnoreCase("queryDate")) {
                    if (null != (Date)bomRow.getCell(k).getValue()) {
                        row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString(dtformat.format((Date)bomRow.getCell(k).getValue())));
                        continue;
                    }
                    row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString((String)bomRow.getCell(k).getValue()));
                    continue;
                }
                row.createCell((int)((short)loop++)).setCellValue((RichTextString)new HSSFRichTextString((String)bomRow.getCell(k).getValue()));
            }
            row = sheet.createRow(curRowIndex++);
            hcell = row.createCell(0);
            hcell.setCellValue((RichTextString)new HSSFRichTextString(EASResource.getString((String)RESOURCE_BOM, (String)"export.childMaterial")));
            style = wb.createCellStyle();
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
            hcell.setCellStyle(style);
            row = sheet.createRow(curRowIndex++);
            loop = 0;
            count1 = resultHeadList.size();
            for (k = 0; k < count1; ++k) {
                if (this.dtEntry.getColumn(k).getStyleAttributes().isHided()) continue;
                hcell = row.createCell((int)((short)loop++));
                hcell.setCellValue((RichTextString)new HSSFRichTextString((String)((KDTCell)resultHeadList.get(k)).getValue()));
                style = wb.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
                hcell.setCellStyle(style);
            }
            int n = 0;
            int count11 = this.dtEntry.getRowCount();
            for (int j = 0; j < count11; ++j) {
                n = 0;
                row = sheet.createRow(curRowIndex++);
                resultRow = this.dtEntry.getRow(j);
                int count3 = resultHeadList.size();
                for (int m = 0; m < count3; ++m) {
                    if (resultRow.getCell(m).getStyleAttributes().isHided()) continue;
                    if (resultRow.getCell(m).getFormattedValue() != null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(resultRow.getCell(m).getFormattedValue().toString()));
                        continue;
                    }
                    obj = resultRow.getCell(m).getValue();
                    if (obj == null) {
                        row.createCell((int)((short)n++)).setCellValue((RichTextString)new HSSFRichTextString(""));
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        tmpBoolean = (Boolean)obj;
                        if (tmpBoolean.equals(Boolean.TRUE)) {
                            row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.YES.getAlias());
                            continue;
                        }
                        row.createCell((int)((short)n++)).setCellValue(YesOrNoEnum.NO.getAlias());
                        continue;
                    }
                    row.createCell((int)((short)n++)).setCellValue(obj.toString());
                }
            }
            ++curRowIndex;
        }
        FileOutputStream fileOut = new FileOutputStream(tempFile);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        try {
            KDTMenuManager.openFileInExcel((String)tempFile.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempFile.deleteOnExit();
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }

    protected String getOnloadPermItemName() {
        return "mm_orderbom_search";
    }

    public void repaint() {
        super.repaint();
        if (this.queryType == BOMSearchFlagEnum.IntegratedSearch || this.queryType == BOMSearchFlagEnum.MutliSraech || this.queryType == BOMSearchFlagEnum.SampleSearch) {
            this.kDSplitPaneLeft.setDividerSize(0);
            this.kDSplitPaneLeft.setDividerLocation(0);
        }
    }

    private Tree buildTree4ManySearch(IRowSet rowSet) throws SQLException {
        HashMap parentChildrenMap = new HashMap();
        ArrayList<RowValue4ManySearch> topLevelList = new ArrayList<RowValue4ManySearch>();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        while (rowSet.next()) {
            RowValue4ManySearch row = new RowValue4ManySearch();
            row.FMaterialNumber = rowSet.getString("FMaterialNumber");
            row.FMaterialName = rowSet.getString("FMaterialName");
            row.FModel = rowSet.getString("FModel");
            row.FUnitname = rowSet.getString("FUnitname");
            row.FMaterialAttr = rowSet.getString("FMaterialAttr");
            row.FBaseQty = rowSet.getString("FBaseQty");
            row.FLevel = rowSet.getString("FLevel");
            row.FConsumeType = rowSet.getString("FConsumeType");
            row.FProportion = rowSet.getString("FProportion");
            row.FParentComsumeQty = rowSet.getString("FParentComsumeQty");
            row.FScrapRatio = rowSet.getString("FScrapRatio");
            row.FEffectiveDate = dtformat.format(rowSet.getDate("FEffectiveDate"));
            row.FDisableDate = dtformat.format(rowSet.getDate("FDisableDate"));
            row.FMaterialChar = rowSet.getString("FMaterialChar");
            row.FIssMode = rowSet.getString("FIssMode");
            row.FOutputType = rowSet.getString("FOutputType");
            row.FDEFAULTWAREHOUSENAME = rowSet.getString("FDEFAULTWAREHOUSENAME");
            row.Fnumber = rowSet.getString("Fnumber");
            row.FBomName = rowSet.getString("FBomName");
            row.bomId = rowSet.getString("FBomId");
            row.parentBomId = rowSet.getString("FParentBomId");
            if (this.materialIsConfigable) {
                row.netWeight = this.formatZero(rowSet.getString("netWeight"));
                row.blkSize = rowSet.getString("blkSize");
                row.specifiedLength = rowSet.getString("specifiedLength");
                row.usedUnit = rowSet.getString("usedUnit");
                row.designUnit = rowSet.getString("designUnit");
                row.designRemark = rowSet.getString("designRemark");
                row.feture = this.getYesOrNoDescription(rowSet.getBoolean("feture"));
                row.canSelected = this.getYesOrNoDescription(rowSet.getBoolean("canSelected"));
                row.firstCfg = this.getYesOrNoDescription(rowSet.getBoolean("firstCfg"));
            } else {
                row.netWeight = this.formatZero(rowSet.getString("netWeight"));
                row.blkSize = rowSet.getString("blkSize");
                row.specifiedLength = rowSet.getString("specifiedLength");
                row.usedUnit = rowSet.getString("usedUnit");
                row.designUnit = rowSet.getString("designUnit");
                row.designRemark = rowSet.getString("designRemark");
            }
            if (this.queryType != BOMSearchFlagEnum.ManySearch) continue;
            if (row.FLevel.equals("1")) {
                topLevelList.add(row);
                continue;
            }
            ArrayList<RowValue4ManySearch> childList = (ArrayList<RowValue4ManySearch>)parentChildrenMap.get(row.parentBomId + row.FLevel);
            if (childList == null) {
                childList = new ArrayList<RowValue4ManySearch>();
                childList.add(row);
                parentChildrenMap.put(row.parentBomId + row.FLevel, childList);
                continue;
            }
            if (childList.contains(row)) continue;
            childList.add(row);
        }
        Tree tree = new Tree();
        tree.parentChildrenMap = parentChildrenMap;
        tree.topLevelList = topLevelList;
        return tree;
    }

    private String getYesOrNoDescription(boolean yesOrNo) {
        if (yesOrNo) {
            return YesOrNoEnum.YES.getAlias();
        }
        return YesOrNoEnum.NO.getAlias();
    }

    private void fillTableRow4ManySearch(List bomList, Map parentChildrenMap, int levelNo, HSSFSheet sheet, List list) {
        HSSFRow row = null;
        Iterator it = bomList.iterator();
        String enumName = null;
        int m = 0;
        while (it.hasNext()) {
            List childList;
            RowValue4ManySearch rowValue = (RowValue4ManySearch)it.next();
            m = 0;
            if (this.queryType == BOMSearchFlagEnum.ManySearch) {
                row = sheet.createRow(((Integer)list.get(0)).intValue());
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(this.getLevelStr(rowValue.FLevel)));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FMaterialNumber));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FMaterialName));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FModel));
                enumName = UIHelper.getAlias(MaterialAttributeEnum.class, (int)Integer.parseInt(rowValue.FMaterialAttr));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(enumName));
                enumName = UIHelper.getAlias(ConsumeTypeEnum.class, (int)Integer.parseInt(rowValue.FConsumeType));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(enumName));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(this.formatZero(rowValue.FBaseQty)));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(this.formatZero(rowValue.FProportion)));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(this.formatZero(rowValue.FParentComsumeQty)));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FUnitname));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(this.formatZero(rowValue.FScrapRatio)));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FEffectiveDate));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FDisableDate));
                enumName = UIHelper.getAlias(MaterialProductEnum.class, (int)Integer.parseInt(rowValue.FOutputType));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(enumName));
                enumName = UIHelper.getAlias(MaterialCharEnum.class, (int)Integer.parseInt(rowValue.FMaterialChar));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(enumName));
                enumName = UIHelper.getAlias(MaterialIssueModeEnum.class, (int)Integer.parseInt(rowValue.FIssMode));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(enumName));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FDEFAULTWAREHOUSENAME));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.Fnumber));
                row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.FBomName));
                if (this.materialIsConfigable) {
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(this.formatZero(rowValue.netWeight)));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.blkSize));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.specifiedLength));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.usedUnit));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.designUnit));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.designRemark));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.feture));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.canSelected));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.firstCfg));
                } else {
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(this.formatZero(rowValue.netWeight)));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.blkSize));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.specifiedLength));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.usedUnit));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.designUnit));
                    row.createCell((int)((short)m++)).setCellValue((RichTextString)new HSSFRichTextString(rowValue.designRemark));
                }
                list.add(0, new Integer((Integer)list.get(0) + 1));
            }
            if ((childList = (List)parentChildrenMap.get(rowValue.bomId + (Integer.parseInt(rowValue.FLevel) + 1))) == null) continue;
            this.fillTableRow4ManySearch(childList, parentChildrenMap, levelNo + 1, sheet, list);
        }
    }

    private boolean isConfigable(String storageId, String materialId) {
        MaterialPlanInfo materialPlan = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)storageId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialId, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add("isConfigable");
            view.setSelector(selectorColl);
            MaterialPlanCollection coll = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
            if (coll != null && coll.size() > 0) {
                materialPlan = coll.get(0);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        boolean rst = false;
        if (materialPlan != null) {
            rst = materialPlan.isIsConfigable();
            String key = materialId + storageId;
            boolean isConfigabled = false;
            this.materialIsConfigableMap.put(key, new Boolean(isConfigabled));
        }
        return rst;
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kDTable1, (int)this.freezeColIndex);
    }

    class RowValue4ManySearch {
        String FLevel = "";
        String FMaterialNumber = "";
        String FMaterialName = "";
        String FModel = "";
        String FMaterialAttr = "";
        String FConsumeType = "";
        String FBaseQty = "";
        String FProportion = "";
        String FParentComsumeQty = "";
        String FUnitname = "";
        String FScrapRatio = "";
        String FEffectiveDate = "";
        String FDisableDate = "";
        String FMaterialChar = "";
        String FIssMode = "";
        String FOutputType = "";
        String FDEFAULTWAREHOUSENAME = "";
        String Fnumber = "";
        String FBomName = "";
        String bomId = "";
        String parentBomId = "";
        String showProject = "";
        String showTrack = "";
        String netWeight = "";
        String blkSize = "";
        String specifiedLength = "";
        String usedUnit = "";
        String designUnit = "";
        String designRemark = "";
        String feture = "";
        String canSelected = "";
        String firstCfg = "";

        RowValue4ManySearch() {
        }

        public boolean equals(Object anotherRow) {
            if (anotherRow == null) {
                return false;
            }
            RowValue4ManySearch bRow = (RowValue4ManySearch)anotherRow;
            return this.FMaterialNumber.equals(bRow.FMaterialNumber) && this.parentBomId.equals(bRow.parentBomId) && this.FLevel.equals(bRow.FLevel);
        }
    }

    class Tree {
        Map parentChildrenMap = null;
        Map bomMap = null;
        List topLevelList = null;

        Tree() {
        }
    }

    class RowValue {
        String materialNumber = "";
        String materialName = "";
        String model = "";
        String unit = "";
        String materialAttr = "";
        String consumeType = "";
        BigDecimal baseQty = null;
        String proportion = "";
        String scrapRatio = "";
        String effectiveDate = "";
        String disableDate = "";
        int outputType = 0;
        int materialChar = 0;
        int issMode = 0;
        String defaultWarehouseName = "";
        String level = "";
        String bomId = "";
        String parentBomId = "";
        String bomName = "";
        String parentComsumeQty = "";
        String bomNumber = "";
        int qtyPrecision = 4;

        RowValue() {
        }

        public boolean equals(Object anatherRow) {
            if (anatherRow == null) {
                return false;
            }
            RowValue bRow = (RowValue)anatherRow;
            return this.materialNumber.equals(bRow.materialNumber) && this.parentBomId.equals(bRow.parentBomId);
        }
    }
}

