/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.mm.basedata.BOMSearchFlagEnum;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrderBomExtendSearchPrintDataProvider
extends AbstractPrintDataProvider {
    private Map resultMap = null;
    private BOMSearchFlagEnum queryType = null;
    private KDTable bomListTable = null;
    private KDTable resultTable = null;
    private static final BigDecimal ZERO = new BigDecimal("0");

    public OrderBomExtendSearchPrintDataProvider(Map resultMap, BOMSearchFlagEnum queryType, KDTable bomListTable, KDTable resultTable) {
        this.resultMap = resultMap;
        this.queryType = queryType;
        this.bomListTable = bomListTable;
        this.resultTable = resultTable;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        int k;
        DynamicRowSet dynamicRowSet = null;
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        int loop = 0;
        KDTHead head = this.bomListTable.getHead();
        ArrayList headList = head.getRow(0).getCells();
        head = this.resultTable.getHead();
        ArrayList resultHeadList = head.getRow(0).getCells();
        ArrayList<String> cellKeyList = new ArrayList<String>();
        int count1 = headList.size();
        for (k = 0; k < count1; ++k) {
            cellKeyList.add(this.bomListTable.getColumn(k).getKey());
            ++loop;
        }
        count1 = resultHeadList.size();
        for (k = 0; k < count1; ++k) {
            if ((BOMSearchFlagEnum.MultilevelSearch == this.queryType || BOMSearchFlagEnum.ManySearch == this.queryType) && (!this.resultTable.getColumn(k).getStyleAttributes().isHided() || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("levelNo") || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMNumber") || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMName") || this.resultTable.getColumn(k).getKey().equalsIgnoreCase("parentProductQty"))) {
                if (this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMNumber")) {
                    cellKeyList.add("childBOMNumber");
                } else if (this.resultTable.getColumn(k).getKey().equalsIgnoreCase("BOMName")) {
                    cellKeyList.add("childBOMName");
                } else {
                    cellKeyList.add(this.resultTable.getColumn(k).getKey());
                }
                ++loop;
                continue;
            }
            if (this.resultTable.getColumn(k).getStyleAttributes().isHided()) continue;
            cellKeyList.add(this.resultTable.getColumn(k).getKey());
            ++loop;
        }
        int columnCount = loop;
        dynamicRowSet = new DynamicRowSet(loop);
        ColInfo ciId = null;
        for (int i = 0; i < loop; ++i) {
            ciId = new ColInfo((String)cellKeyList.get(i), (String)cellKeyList.get(i), 12, null);
            dynamicRowSet.setColInfo(i + 1, ciId);
        }
        String bomId = null;
        String materialId = null;
        BigDecimal productQty = null;
        IRow bomRow = null;
        ICell cell = null;
        int count = this.bomListTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            bomRow = this.bomListTable.getRow(i);
            cell = bomRow.getCell("BOMID");
            bomId = (String)cell.getValue();
            cell = bomRow.getCell("parentMaterialID");
            materialId = (String)cell.getValue();
            cell = bomRow.getCell("productQty");
            productQty = new BigDecimal((String)cell.getValue());
            IRowSet rowSet = (IRowSet)this.resultMap.get(new Integer(i));
            if (null == rowSet || 0 == rowSet.size()) {
                int ii;
                dynamicRowSet.moveToInsertRow();
                loop = 0;
                int count12 = this.bomListTable.getColumnCount();
                for (int k2 = 0; k2 < count12; ++k2) {
                    if (this.bomListTable.getColumn(k2).getStyleAttributes().isHided() && !this.bomListTable.getColumn(k2).getKey().equalsIgnoreCase("bomid")) continue;
                    if (bomRow.getCell(k2).getValue() instanceof Date) {
                        dynamicRowSet.updateString(++loop, dtformat.format((Date)bomRow.getCell(k2).getValue()));
                        continue;
                    }
                    dynamicRowSet.updateString(++loop, (String)bomRow.getCell(k2).getValue());
                }
                if (BOMSearchFlagEnum.SampleSearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 16) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.ManySearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 20) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.MutliSraech == this.queryType) {
                    ii = 0;
                    while (ii++ < 7) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.IntegratedSearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 7) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                } else if (BOMSearchFlagEnum.MultilevelSearch == this.queryType) {
                    ii = 0;
                    while (ii++ < 20) {
                        dynamicRowSet.updateString(++loop, null);
                    }
                }
                dynamicRowSet.insertRow();
                continue;
            }
            if (BOMSearchFlagEnum.MultilevelSearch == this.queryType) {
                Tree tree = null;
                tree = this.buildTree4ManySearch(rowSet);
                this.fillTableRow4ManySearch(tree.topLevelList, tree.parentChildrenMap, 1, dynamicRowSet, bomRow, columnCount);
                continue;
            }
            String enumName = null;
            while (rowSet.next()) {
                BigDecimal bd;
                dynamicRowSet.moveToInsertRow();
                loop = 0;
                while (loop < columnCount) {
                    dynamicRowSet.updateString(++loop, null);
                }
                dynamicRowSet.updateString("storageOrgUnitNumber", (String)bomRow.getCell("storageOrgUnitNumber").getValue());
                if (bomRow.getCell("queryDate").getValue() != null) {
                    dynamicRowSet.updateString("queryDate", dtformat.format((Date)bomRow.getCell("queryDate").getValue()));
                } else {
                    dynamicRowSet.updateString("queryDate", null);
                }
                dynamicRowSet.updateString("searchType", (String)bomRow.getCell("searchType").getValue());
                dynamicRowSet.updateString("parentMaterialNumber", (String)bomRow.getCell("parentMaterialNumber").getValue());
                dynamicRowSet.updateString("parentMaterialName", (String)bomRow.getCell("parentMaterialName").getValue());
                dynamicRowSet.updateString("parentMaterialModel", (String)bomRow.getCell("parentMaterialModel").getValue());
                dynamicRowSet.updateString("productQty", this.formatZero((String)bomRow.getCell("productQty").getValue()));
                dynamicRowSet.updateString("parentMaterialUnit", (String)bomRow.getCell("parentMaterialUnit").getValue());
                dynamicRowSet.updateString("parentMaterialAttr", (String)bomRow.getCell("parentMaterialAttr").getValue());
                dynamicRowSet.updateString("BOMNumber", (String)bomRow.getCell("BOMNumber").getValue());
                dynamicRowSet.updateString("BOMType", (String)bomRow.getCell("BOMType").getValue());
                dynamicRowSet.updateString("BOMUsage", (String)bomRow.getCell("BOMUsage").getValue());
                dynamicRowSet.updateString("BOMID", (String)bomRow.getCell("BOMID").getValue());
                if (BOMSearchFlagEnum.SampleSearch.equals((Object)this.queryType)) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("MATERIALNUMBER"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("MATERIALNAME"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("MATERIALMODE"));
                    enumName = MaterialAttributeEnum.getEnum((int)Integer.parseInt(rowSet.getString("MATERIALATTR"))).getAlias();
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    enumName = ConsumeTypeEnum.getEnum(Integer.parseInt(rowSet.getString("CONSUMETYPE"))).getAlias();
                    dynamicRowSet.updateString("consumeType", enumName);
                    dynamicRowSet.updateString("consumeFixQty", this.formatZero(rowSet.getString("CONSUMEFIXQTY")));
                    dynamicRowSet.updateString("proportion", this.formatZero(rowSet.getString("PROPORTION")));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("UNITNAME"));
                    dynamicRowSet.updateString("scrapRatio", this.formatZero(rowSet.getString("SCRAPRATIO")));
                    dynamicRowSet.updateString("effectiveDate", rowSet.getString("EFFECTIVEDATE"));
                    dynamicRowSet.updateString("disableDate", rowSet.getString("DISABLEDATE"));
                    enumName = MaterialProductEnum.getEnum((int)Integer.parseInt(rowSet.getString("OUTPUTTYPE"))).getAlias();
                    dynamicRowSet.updateString("outputType", enumName);
                    enumName = MaterialCharEnum.getEnum((int)Integer.parseInt(rowSet.getString("MATERIALCHAR"))).getAlias();
                    dynamicRowSet.updateString("materialChara", enumName);
                    enumName = MaterialIssueModeEnum.getEnum((int)Integer.parseInt(rowSet.getString("ISSMODE"))).getAlias();
                    dynamicRowSet.updateString("pickingMode", enumName);
                    dynamicRowSet.updateString("defaultWarehouseName", rowSet.getString("DEFAULTWAREHOUSENAME"));
                } else if (BOMSearchFlagEnum.ManySearch.equals((Object)this.queryType)) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("MATERIALNUMBER"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("MATERIALNAME"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("MATERIALMODE"));
                    enumName = MaterialAttributeEnum.getEnum((int)Integer.parseInt(rowSet.getString("MATERIALATTR"))).getAlias();
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    enumName = ConsumeTypeEnum.getEnum(Integer.parseInt(rowSet.getString("CONSUMETYPE"))).getAlias();
                    dynamicRowSet.updateString("consumeType", enumName);
                    dynamicRowSet.updateString("consumeFixQty", this.formatZero(rowSet.getString("CONSUMEFIXQTY")));
                    dynamicRowSet.updateString("proportion", this.formatZero(rowSet.getString("PROPORTION")));
                    dynamicRowSet.updateString("PRODUCTQTY", this.formatZero(rowSet.getString("PRODUCTQTY")));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("UNITNAME"));
                    dynamicRowSet.updateString("scrapRatio", this.formatZero(rowSet.getString("SCRAPRATIO")));
                    dynamicRowSet.updateString("effectiveDate", rowSet.getString("EFFECTIVEDATE"));
                    dynamicRowSet.updateString("disableDate", rowSet.getString("DISABLEDATE"));
                    enumName = MaterialCharEnum.getEnum((int)Integer.parseInt(rowSet.getString("MATERIALCHAR"))).getAlias();
                    dynamicRowSet.updateString("materialChara", enumName);
                    enumName = MaterialIssueModeEnum.getEnum((int)Integer.parseInt(rowSet.getString("ISSMODE"))).getAlias();
                    dynamicRowSet.updateString("pickingMode", enumName);
                    enumName = MaterialProductEnum.getEnum((int)Integer.parseInt(rowSet.getString("OUTPUTTYPE"))).getAlias();
                    dynamicRowSet.updateString("outputType", enumName);
                    dynamicRowSet.updateString("defaultWarehouseName", rowSet.getString("DEFAULTWAREHOUSENAME"));
                    dynamicRowSet.updateString("BOMNUMBER", rowSet.getString("BOMNUMBER"));
                } else if (BOMSearchFlagEnum.MultilevelSearch.equals((Object)this.queryType)) {
                    dynamicRowSet.updateString(++loop, this.getLevelStr(rowSet.getString("FLevel")));
                    dynamicRowSet.updateString(++loop, rowSet.getString("FMaterialNumber"));
                    dynamicRowSet.updateString(++loop, rowSet.getString("FMaterialName"));
                    dynamicRowSet.updateString(++loop, rowSet.getString("FModel"));
                    enumName = MaterialAttributeEnum.getEnum((int)Integer.parseInt(rowSet.getString("FMaterialAttr"))).getAlias();
                    dynamicRowSet.updateString(++loop, enumName);
                    enumName = ConsumeTypeEnum.getEnum(Integer.parseInt(rowSet.getString("FConsumeType"))).getAlias();
                    dynamicRowSet.updateString(++loop, enumName);
                    dynamicRowSet.updateString(++loop, this.formatZero(rowSet.getString("FBaseQty")));
                    dynamicRowSet.updateString(++loop, this.formatZero(rowSet.getString("FProportion")));
                    dynamicRowSet.updateString(++loop, this.formatZero(rowSet.getString("FParentComsumeQty")));
                    dynamicRowSet.updateString(++loop, rowSet.getString("FUnitname"));
                    dynamicRowSet.updateString(++loop, this.formatZero(rowSet.getString("FScrapRatio")));
                    dynamicRowSet.updateString(++loop, rowSet.getString("FEffectiveDate"));
                    dynamicRowSet.updateString(++loop, rowSet.getString("FDisableDate"));
                    enumName = MaterialCharEnum.getEnum((int)Integer.parseInt(rowSet.getString("FMaterialChar"))).getAlias();
                    dynamicRowSet.updateString(++loop, enumName);
                    enumName = MaterialIssueModeEnum.getEnum((int)Integer.parseInt(rowSet.getString("FIssMode"))).getAlias();
                    dynamicRowSet.updateString(++loop, enumName);
                    enumName = MaterialProductEnum.getEnum((int)Integer.parseInt(rowSet.getString("FOutputType"))).getAlias();
                    dynamicRowSet.updateString(++loop, enumName);
                    dynamicRowSet.updateString(++loop, rowSet.getString("FDEFAULTWAREHOUSENAME"));
                    dynamicRowSet.updateString(++loop, rowSet.getString("Fnumber"));
                    dynamicRowSet.updateString(++loop, rowSet.getString("FBomName"));
                } else if (BOMSearchFlagEnum.MutliSraech.equals((Object)this.queryType)) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("FMaterialNumber"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("FMaterialName"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("FModel"));
                    enumName = MaterialAttributeEnum.getEnum((int)Integer.parseInt(rowSet.getString("FMaterialAttr"))).getAlias();
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    bd = rowSet.getBigDecimal("FBaseQty");
                    bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
                    dynamicRowSet.updateString("childConsumeQty", this.formatZero(bd.toString()));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("FUnitname"));
                } else if (BOMSearchFlagEnum.IntegratedSearch.equals((Object)this.queryType)) {
                    dynamicRowSet.updateString("childMaterialNumber", rowSet.getString("FMaterialNumber"));
                    dynamicRowSet.updateString("childMaterialName", rowSet.getString("FMaterialName"));
                    dynamicRowSet.updateString("childMaterialModel", rowSet.getString("FModel"));
                    enumName = MaterialAttributeEnum.getEnum((int)Integer.parseInt(rowSet.getString("FMaterialAttr"))).getAlias();
                    dynamicRowSet.updateString("childMaterialAttr", enumName);
                    bd = rowSet.getBigDecimal("FBaseQty");
                    bd = bd.setScale(rowSet.getInt("qtyPrecision"), 4);
                    dynamicRowSet.updateString("childConsumeQty", this.formatZero(bd.toString()));
                    dynamicRowSet.updateString("childMaterialUnit", rowSet.getString("FUnitname"));
                }
                dynamicRowSet.insertRow();
            }
        }
        return dynamicRowSet;
    }

    private String getLevelStr(String level) {
        if (level.equals("1")) {
            return "*" + level;
        }
        if (level.equals("2")) {
            return "**" + level;
        }
        if (level.equals("3")) {
            return "***" + level;
        }
        if (level.equals("4")) {
            return "****" + level;
        }
        if (level.equals("5")) {
            return "*****" + level;
        }
        if (level.equals("6")) {
            return "******" + level;
        }
        if (level.equals("7")) {
            return "*******" + level;
        }
        return "********" + level;
    }

    private String formatZero(String str) {
        String returnStr = "";
        if (null != str && !"".equals(str)) {
            try {
                returnStr = ZERO.compareTo(new BigDecimal(str)) == 0 ? "0" : CtrlFormatUtilities.getDecimalFormat().format(new BigDecimal(str));
            }
            catch (Exception e) {
                returnStr = str;
            }
        }
        return returnStr;
    }

    private Tree buildTree4ManySearch(IRowSet rowSet) throws SQLException {
        HashMap parentChildrenMap = new HashMap();
        ArrayList<RowValue4ManySearch> topLevelList = new ArrayList<RowValue4ManySearch>();
        boolean i = true;
        while (rowSet.next()) {
            RowValue4ManySearch row = new RowValue4ManySearch();
            row.FMaterialNumber = rowSet.getString("FMaterialNumber");
            row.FMaterialName = rowSet.getString("FMaterialName");
            row.FModel = rowSet.getString("FModel");
            row.FUnitname = rowSet.getString("FUnitname");
            row.FMaterialAttr = rowSet.getString("FMaterialAttr");
            row.FBaseQty = rowSet.getString("FBaseQty");
            row.FLevel = rowSet.getString("FLevel");
            row.FConsumeType = rowSet.getString("FConsumeType");
            row.FProportion = rowSet.getString("FProportion");
            row.FParentComsumeQty = rowSet.getString("FParentComsumeQty");
            row.FScrapRatio = rowSet.getString("FScrapRatio");
            row.FEffectiveDate = rowSet.getString("FEffectiveDate");
            row.FDisableDate = rowSet.getString("FDisableDate");
            row.FMaterialChar = rowSet.getString("FMaterialChar");
            row.FIssMode = rowSet.getString("FIssMode");
            row.FOutputType = rowSet.getString("FOutputType");
            row.FDEFAULTWAREHOUSENAME = rowSet.getString("FDEFAULTWAREHOUSENAME");
            row.location = rowSet.getString("location");
            row.Fnumber = rowSet.getString("Fnumber");
            row.FBomName = rowSet.getString("FBomName");
            row.bomId = rowSet.getString("FBomId");
            row.parentBomId = rowSet.getString("FParentBomId");
            if (this.queryType != BOMSearchFlagEnum.ManySearch && this.queryType != BOMSearchFlagEnum.MultilevelSearch) continue;
            if (row.FLevel.equals("1")) {
                topLevelList.add(row);
                continue;
            }
            ArrayList<RowValue4ManySearch> childList = (ArrayList<RowValue4ManySearch>)parentChildrenMap.get(row.parentBomId + row.FLevel);
            if (childList == null) {
                childList = new ArrayList<RowValue4ManySearch>();
                childList.add(row);
                parentChildrenMap.put(row.parentBomId + row.FLevel, childList);
                continue;
            }
            if (childList.contains(row)) continue;
            childList.add(row);
        }
        Tree tree = new Tree();
        tree.parentChildrenMap = parentChildrenMap;
        tree.topLevelList = topLevelList;
        return tree;
    }

    private void fillTableRow4ManySearch(List bomList, Map parentChildrenMap, int levelNo, DynamicRowSet dynamicRowSet, IRow bomRow, int columnCount) throws Exception {
        Iterator it = bomList.iterator();
        String enumName = null;
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        int loop = 0;
        while (it.hasNext()) {
            dynamicRowSet.moveToInsertRow();
            dynamicRowSet.updateString("BOMType", (String)bomRow.getCell("BOMType").getValue());
            loop = 0;
            int count1 = this.bomListTable.getColumnCount();
            for (int k = 0; k < count1; ++k) {
                if (this.bomListTable.getColumn(k).getStyleAttributes().isHided() && !this.bomListTable.getColumn(k).getKey().equalsIgnoreCase("bomid")) continue;
                if (this.bomListTable.getColumn(k).getKey().equalsIgnoreCase("queryDate")) {
                    if (null != (Date)bomRow.getCell(k).getValue()) {
                        dynamicRowSet.updateString(++loop, dtformat.format((Date)bomRow.getCell(k).getValue()));
                        continue;
                    }
                    dynamicRowSet.updateString(++loop, (String)bomRow.getCell(k).getValue());
                    continue;
                }
                if (this.bomListTable.getColumn(k).getKey().equalsIgnoreCase("productQty")) {
                    dynamicRowSet.updateString(++loop, this.formatZero((String)bomRow.getCell(k).getValue()));
                    continue;
                }
                if (this.bomListTable.getColumn(k).getKey().equalsIgnoreCase("isProjectManu")) {
                    String isProjectManuToStr = null;
                    isProjectManuToStr = bomRow.getCell(k).getValue().equals(Boolean.TRUE) ? EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"IsSame_YES") : EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMCompareResource", (String)"IsSame_NO");
                    dynamicRowSet.updateString(++loop, isProjectManuToStr);
                    continue;
                }
                dynamicRowSet.updateString(++loop, (String)bomRow.getCell(k).getValue());
            }
            RowValue4ManySearch rowValue = (RowValue4ManySearch)it.next();
            dynamicRowSet.updateString(++loop, this.getLevelStr(rowValue.FLevel));
            dynamicRowSet.updateString(++loop, rowValue.FMaterialNumber);
            dynamicRowSet.updateString(++loop, rowValue.FMaterialName);
            dynamicRowSet.updateString(++loop, rowValue.FModel);
            enumName = MaterialAttributeEnum.getEnum((int)Integer.parseInt(rowValue.FMaterialAttr)).getAlias();
            dynamicRowSet.updateString(++loop, enumName);
            enumName = ConsumeTypeEnum.getEnum(Integer.parseInt(rowValue.FConsumeType)).getAlias();
            dynamicRowSet.updateString(++loop, enumName);
            dynamicRowSet.updateString(++loop, this.formatZero(rowValue.FBaseQty));
            dynamicRowSet.updateString(++loop, this.formatZero(rowValue.FProportion));
            dynamicRowSet.updateString(++loop, this.formatZero(rowValue.FParentComsumeQty));
            dynamicRowSet.updateString(++loop, rowValue.FUnitname);
            dynamicRowSet.updateString(++loop, this.formatZero(rowValue.FScrapRatio));
            dynamicRowSet.updateString(++loop, rowValue.FEffectiveDate);
            dynamicRowSet.updateString(++loop, rowValue.FDisableDate);
            enumName = MaterialProductEnum.getEnum((int)Integer.parseInt(rowValue.FOutputType)).getAlias();
            dynamicRowSet.updateString(++loop, enumName);
            enumName = MaterialCharEnum.getEnum((int)Integer.parseInt(rowValue.FMaterialChar)).getAlias();
            dynamicRowSet.updateString(++loop, enumName);
            enumName = MaterialIssueModeEnum.getEnum((int)Integer.parseInt(rowValue.FIssMode)).getAlias();
            dynamicRowSet.updateString(++loop, enumName);
            dynamicRowSet.updateString(++loop, rowValue.FDEFAULTWAREHOUSENAME);
            dynamicRowSet.updateString(++loop, rowValue.location);
            dynamicRowSet.updateString(++loop, rowValue.Fnumber);
            dynamicRowSet.updateString(++loop, rowValue.FBomName);
            while (loop < columnCount) {
                dynamicRowSet.updateString(++loop, null);
            }
            dynamicRowSet.insertRow();
            List childList = (List)parentChildrenMap.get(rowValue.bomId + (Integer.parseInt(rowValue.FLevel) + 1));
            if (childList == null) continue;
            this.fillTableRow4ManySearch(childList, parentChildrenMap, levelNo + 1, dynamicRowSet, bomRow, columnCount);
        }
    }

    class Tree {
        Map parentChildrenMap = null;
        Map bomMap = null;
        List topLevelList = null;

        Tree() {
        }
    }

    class RowValue4ManySearch {
        String FLevel = "";
        String FMaterialNumber = "";
        String FMaterialName = "";
        String FModel = "";
        String FMaterialAttr = "";
        String FConsumeType = "";
        String FBaseQty = "";
        String FProportion = "";
        String FParentComsumeQty = "";
        String FUnitname = "";
        String FScrapRatio = "";
        String FEffectiveDate = "";
        String FDisableDate = "";
        String FMaterialChar = "";
        String FIssMode = "";
        String FOutputType = "";
        String FDEFAULTWAREHOUSENAME = "";
        String location = "";
        String Fnumber = "";
        String FBomName = "";
        String bomId = "";
        String parentBomId = "";

        RowValue4ManySearch() {
        }

        public boolean equals(Object anotherRow) {
            if (anotherRow == null) {
                return false;
            }
            RowValue4ManySearch bRow = (RowValue4ManySearch)anotherRow;
            return this.FMaterialNumber.equals(bRow.FMaterialNumber) && this.parentBomId.equals(bRow.parentBomId) && this.FLevel.equals(bRow.FLevel);
        }
    }
}

