/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMExtendSearchFilterCondition;
import com.kingdee.eas.mm.basedata.BOMSearchFlagEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomExtendSearchQueryUI;
import com.kingdee.eas.mm.basedata.client.BOMUIHelper;
import com.kingdee.eas.mm.basedata.client.F7BomSelectProcessor;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OrderBomExtendSearchQueryUI
extends AbstractOrderBomExtendSearchQueryUI {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_BOM = "com.kingdee.eas.mm.basedata.BOMResource";
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);

    public OrderBomExtendSearchQueryUI() throws Exception {
        this.prmtStorageOrgUnit.setRequired(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtBom.setHasCUDefaultFilter(false);
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_bom_search");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)com.kingdee.eas.mm.common.client.MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_bom_search");
        if (orgInfo == null) {
            this.cmbBomUsage.removeItem((Object)BOMUsageEnum.NULL);
            return;
        }
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.prmtStorageOrgUnit.setRequired(true);
        this.prmtStorageOrgUnit.setEditable(false);
        this.prmtMaterial.setRequired(true);
        this.cmbSearchType.setRequired(true);
        this.initF7Material(orgInfo);
        this.initBomUsage(false);
        this.initBom(orgInfo);
        this.initF7View();
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNumber);
        OrderBomExtendSearchQueryUI.registerTrackNumberF7ForEdit(this.prmtStorageOrgUnit, null, this.prmtProjectNumber, this.prmtTrackNumber, false, false);
        this.cmbSearchType.removeAllItems();
        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.SampleSearch);
        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.ManySearch);
        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.IntegratedSearch);
        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.MutliSraech);
        this.prmtProjectNumber.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    OrderBomExtendSearchQueryUI.this.prmtBom.setValue(null);
                    OrderBomExtendSearchQueryUI.this.prmtTrackNumber.setValue(null);
                }
                catch (Exception exc) {
                    OrderBomExtendSearchQueryUI.this.handUIException(exc);
                }
            }
        });
        this.prmtTrackNumber.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    OrderBomExtendSearchQueryUI.this.prmtBom.setValue(null);
                }
                catch (Exception exc) {
                    OrderBomExtendSearchQueryUI.this.handUIException(exc);
                }
            }
        });
        F7BomSelectProcessor selectProcessorFrom = new F7BomSelectProcessor(this.prmtBom);
        this.prmtBom.setSelector((KDPromptSelector)selectProcessorFrom);
        this.prmtBom.setCommitParser((IParser)selectProcessorFrom);
        this.prmtBom.setCommitFormat("$number$");
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        block17: {
            super.loadData(entityViewInfo);
            this.prmtStorageOrgUnit.setValue(null);
            this.prmtMaterial.setValue(null);
            this.prmtTrackNumber.setValue(null);
            this.prmtProjectNumber.setValue(null);
            try {
                if (entityViewInfo == null) break block17;
                this.kDDate.setValue(null);
                FilterInfo filterInfo = entityViewInfo.getFilter();
                if (filterInfo.getFilterItems() == null || filterInfo.getFilterItems().size() <= 0) break block17;
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    IMaterial factory;
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if ("storageOrgUnitID".equals(filterItemInfo.getPropertyName())) {
                        String orgID = filterItemInfo.getCompareValue().toString();
                        orgID = orgID.substring(1, orgID.length() - 1);
                        factory = StorageOrgUnitFactory.getRemoteInstance();
                        StorageOrgUnitInfo org = factory.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
                        this.prmtStorageOrgUnit.setValue((Object)org);
                        continue;
                    }
                    if ("materialID".equals(filterItemInfo.getPropertyName())) {
                        String materialID = filterItemInfo.getCompareValue().toString();
                        factory = MaterialFactory.getRemoteInstance();
                        MaterialInfo material = factory.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                        this.prmtMaterial.setValue((Object)material);
                        continue;
                    }
                    if ("searchType".equals(filterItemInfo.getPropertyName())) {
                        this.cmbSearchType.removeAllItems();
                        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.SampleSearch);
                        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.ManySearch);
                        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.IntegratedSearch);
                        this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.MutliSraech);
                        this.cmbSearchType.setSelectedIndex(new Integer(filterItemInfo.getCompareValue().toString()).intValue());
                        continue;
                    }
                    if ("date".equals(filterItemInfo.getPropertyName())) {
                        this.kDDate.setValue(filterItemInfo.getCompareValue());
                        continue;
                    }
                    if ("prjNumberID".equals(filterItemInfo.getPropertyName())) {
                        String prjNumberID = filterItemInfo.getCompareValue().toString();
                        ProjectInfo prj = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(prjNumberID));
                        this.prmtProjectNumber.setValue((Object)prj);
                        continue;
                    }
                    if ("trackNumberID".equals(filterItemInfo.getPropertyName())) {
                        String trackNumberID = filterItemInfo.getCompareValue().toString();
                        TrackNumberInfo tackNumber = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackNumberID));
                        this.prmtTrackNumber.setValue((Object)tackNumber);
                        continue;
                    }
                    if ("bomId".equalsIgnoreCase(filterItemInfo.getPropertyName())) {
                        int count;
                        DataChangeListener[] materiallistener;
                        DataChangeListener[] bomListener = (DataChangeListener[])this.prmtBom.getListeners(DataChangeListener.class);
                        if (null != bomListener) {
                            int count2 = bomListener.length;
                            for (int j = 0; j < count2; ++j) {
                                this.prmtBom.removeDataChangeListener(bomListener[j]);
                            }
                        }
                        if (null != (materiallistener = (DataChangeListener[])this.prmtMaterial.getListeners(DataChangeListener.class))) {
                            int count3 = materiallistener.length;
                            for (int k = 0; k < count3; ++k) {
                                this.prmtMaterial.removeDataChangeListener(materiallistener[k]);
                            }
                        }
                        IBom facactory = BomFactory.getRemoteInstance();
                        BomInfo bomInfo = facactory.getBomInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString()));
                        this.prmtBom.setValue((Object)bomInfo);
                        if (null != bomListener) {
                            count = bomListener.length;
                            for (int j = 0; j < count; ++j) {
                                this.prmtBom.addDataChangeListener(bomListener[j]);
                            }
                        }
                        if (null == materiallistener) continue;
                        count = materiallistener.length;
                        for (int k = 0; k < count; ++k) {
                            this.prmtMaterial.addDataChangeListener(materiallistener[k]);
                        }
                        continue;
                    }
                    if (!"usageType".equals(filterItemInfo.getPropertyName())) continue;
                    this.cmbBomUsage.setSelectedIndex(new Integer(filterItemInfo.getCompareValue().toString()).intValue());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo.getFilterItems().clear();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        this.filterInfo.setMaskString(null);
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() > 0) {
            StringBuffer ids = new StringBuffer();
            StringBuffer numbers = new StringBuffer();
            StringBuffer names = new StringBuffer();
            if (this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo) {
                ids.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
                numbers.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getNumber());
                names.append(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getName());
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString()));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString(), CompareType.INCLUDE));
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)names.toString(), CompareType.INCLUDE));
            } else if (this.prmtStorageOrgUnit.getValue() instanceof LinkedHashSet) {
                LinkedHashSet set = (LinkedHashSet)this.prmtStorageOrgUnit.getValue();
                for (String id : set) {
                    ids.append(id + ";");
                }
            } else if (this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
                Object[] storages = (Object[])this.prmtStorageOrgUnit.getValue();
                if (storages.length > 0) {
                    for (int i = 0; i < storages.length; ++i) {
                        ids.append(((StorageOrgUnitInfo)storages[i]).getId() + ";");
                        numbers.append(((StorageOrgUnitInfo)storages[i]).getNumber() + ";");
                    }
                }
                itemCollection.add(new FilterItemInfo("storageOrgUnitName", (Object)numbers.toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("storageOrgUnitNumber", (Object)numbers.toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)ids.toString(), CompareType.EQUALS));
            }
        }
        if (this.prmtMaterial.getValue() != null && this.prmtMaterial.getText() != null && this.prmtMaterial.getText().length() > 0) {
            if (this.prmtMaterial.getValue() instanceof MaterialInfo) {
                itemCollection.add(new FilterItemInfo("materialID", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
                itemCollection.add(new FilterItemInfo("materialNumber", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getNumber().toString()));
            } else if (this.prmtMaterial.getValue() instanceof LinkedHashSet) {
                for (String id : (LinkedHashSet)this.prmtMaterial.getValue()) {
                    itemCollection.add(new FilterItemInfo("materialID", (Object)id, CompareType.EQUALS));
                }
            }
        }
        if (this.kDDate.getValue() != null) {
            itemCollection.add(new FilterItemInfo("date", (Object)new Timestamp(((Date)this.kDDate.getValue()).getTime()), CompareType.EQUALS));
        }
        if (this.cmbSearchType.getSelectedIndex() >= 0) {
            itemCollection.add(new FilterItemInfo("searchType", (Object)new Integer(this.cmbSearchType.getSelectedIndex())));
        }
        if (this.prmtProjectNumber.getValue() != null && this.prmtProjectNumber.getText().length() > 0) {
            itemCollection.add(new FilterItemInfo("prjNumberID", (Object)((ProjectInfo)this.prmtProjectNumber.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtTrackNumber.getValue() != null && this.prmtTrackNumber.getText().length() > 0) {
            itemCollection.add(new FilterItemInfo("trackNumberID", (Object)((TrackNumberInfo)this.prmtTrackNumber.getValue()).getId().toString(), CompareType.EQUALS));
        }
        if (this.cmbBomUsage.getSelectedIndex() >= 0) {
            itemCollection.add(new FilterItemInfo("usageType", (Object)new Integer(this.cmbBomUsage.getSelectedIndex())));
        }
        if (this.prmtBom != null && !StringUtils.isEmpty((String)this.prmtBom.getText())) {
            itemCollection.add(new FilterItemInfo("bomNumber", (Object)((BomInfo)this.prmtBom.getValue()).getNumber()));
            itemCollection.add(new FilterItemInfo("bomId", (Object)((BomInfo)this.prmtBom.getValue()).getId()));
        }
        return this.filterInfo;
    }

    public boolean verify() {
        StringBuffer msg = new StringBuffer();
        if (this.prmtStorageOrgUnit.getText() == null || this.prmtStorageOrgUnit.getText().trim().length() == 0) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"storageOrgUnit_Required"));
        } else if (this.prmtStorageOrgUnit.getValue() == null) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"storageOrgUnit_CodeError"));
        }
        if (this.prmtMaterial.getText() == null || this.prmtMaterial.getText().trim().length() == 0) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"fatherMaterial_Required"));
        } else if (this.prmtMaterial.getValue() == null) {
            this.ensureChangeLine(msg, EASResource.getString((String)RESOURCE_BOM, (String)"fatherMaterial_CodeError"));
        }
        Map map = this.getUIContext();
        if (map.get("orderBomExtend") != null && "1".equals(map.get("orderBomExtend").toString()) && this.prmtProjectNumber.getValue() == null && this.prmtTrackNumber.getValue() == null) {
            msg.append(ResourceUtils.getMessage((String)RESOURCE_BOM, (String)"pt_notnull"));
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
            return false;
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_orderbom_search");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)com.kingdee.eas.mm.common.client.MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_orderbom_search");
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
        this.kDDate.setValue((Object)new Date());
        this.cmbSearchType.setSelectedIndex(0);
        this.prmtMaterial.setValue(null);
        this.prmtTrackNumber.setValue(null);
        this.prmtProjectNumber.setValue(null);
        this.cmbBomUsage.setSelectedItem((Object)BOMUsageEnum.Master);
    }

    private void ensureChangeLine(StringBuffer msg, String info) {
        if (msg.length() > 0) {
            msg.append("\n\r");
        }
        msg.append(info);
    }

    private void initF7Material(StorageOrgUnitInfo orgInfo) throws BOSException {
        String materialPlanQuery = BOMUIHelper.getMaterialPlanForBOMQuery(this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, materialPlanQuery, (OrgUnitInfo)orgInfo, false);
        FilterInfo filterInfo = new FilterInfo();
        if (orgInfo != null) {
            String orgUnitId = orgInfo.getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        }
        Integer status = new Integer(1);
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)status, CompareType.EQUALS));
        Set strategyIds = ManufactureStrategyGroup.getOrderBomStrategyIdSet();
        filterInfo.getFilterItems().add(new FilterItemInfo("manufactureStrategy.id", (Object)strategyIds, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        this.prmtMaterial.setEntityViewInfo(entityViewInfo);
    }

    private void initBomUsage(boolean onlyMasterBom) {
        int i;
        int count;
        ItemListener[] listener = this.cmbBomUsage.getItemListeners();
        BOMUsageEnum pre = (BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem());
        if (null != listener) {
            count = listener.length;
            for (i = 0; i < count; ++i) {
                this.cmbBomUsage.removeItemListener(listener[i]);
            }
        }
        this.cmbBomUsage.removeAllItems();
        this.cmbBomUsage.addItem((Object)BOMUsageEnum.Master);
        if (!onlyMasterBom) {
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.Other);
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.BackingOut);
            this.cmbBomUsage.addItem((Object)BOMUsageEnum.maintaining);
        }
        this.cmbBomUsage.setSelectedItem((Object)pre);
        if (null != listener) {
            count = listener.length;
            for (i = 0; i < count; ++i) {
                this.cmbBomUsage.addItemListener(listener[i]);
            }
        }
    }

    private void initBom(StorageOrgUnitInfo info) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (null != info) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)info.getId().toString(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("basestatus", (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(((BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem())).getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(45), CompareType.EQUALS));
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        view.setFilter(filterInfo);
        this.prmtBom.setSelectorCollection(sic);
        this.prmtBom.setEntityViewInfo(view);
    }

    @Override
    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitInfo oldObject = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newObject = (StorageOrgUnitInfo)e.getNewValue();
        if (null != newObject && !newObject.equals((Object)oldObject)) {
            this.initF7Material((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
            this.initBom((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        }
        this.prmtMaterial.setValue(null);
        this.prmtTrackNumber.setValue(null);
        this.prmtProjectNumber.setValue(null);
    }

    @Override
    protected void cmbBomUsage_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbBomUsage_itemStateChanged(e);
        if (e.getStateChange() != 2) {
            BOMUsageEnum usageEnum = (BOMUsageEnum)((Object)e.getItem());
            ItemListener[] listener = this.cmbSearchType.getItemListeners();
            if (null != listener) {
                int count = listener.length;
                for (int i = 0; i < count; ++i) {
                    this.cmbSearchType.removeItemListener(listener[i]);
                }
            }
            this.cmbSearchType.removeAllItems();
            this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.SampleSearch);
            this.prmtBom.setValue(null);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(45), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("basestatus", (Object)new Integer(4), CompareType.EQUALS));
            if (this.prmtMaterial.getValue() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
            }
            if (this.prmtStorageOrgUnit.getValue() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
            }
            if (this.cmbBomUsage.getSelectedItem() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(((BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem())).getValue()), CompareType.EQUALS));
            }
            view.setFilter(filterInfo);
            this.prmtBom.setEntityViewInfo(view);
            if (usageEnum == BOMUsageEnum.Master) {
                this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.ManySearch);
                this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.IntegratedSearch);
                this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.MutliSraech);
            }
            if (null != listener) {
                int count = listener.length;
                for (int i = 0; i < count; ++i) {
                    this.cmbSearchType.addItemListener(listener[i]);
                }
            }
        }
    }

    @Override
    protected void cmbSearchType_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbSearchType_itemStateChanged(e);
        if (e.getStateChange() != 2) {
            BOMSearchFlagEnum searchTypeEnum = (BOMSearchFlagEnum)((Object)e.getItem());
            if (searchTypeEnum == BOMSearchFlagEnum.ManySearch) {
                this.initBomUsage(true);
                this.cmbBomUsage.setEnabled(true);
            } else if (searchTypeEnum == BOMSearchFlagEnum.MutliSraech) {
                this.initBomUsage(true);
                this.cmbBomUsage.setEnabled(true);
            } else if (searchTypeEnum == BOMSearchFlagEnum.IntegratedSearch) {
                this.initBomUsage(true);
                this.cmbBomUsage.setEnabled(false);
            } else {
                this.initBomUsage(false);
                this.cmbBomUsage.setEnabled(true);
            }
        }
    }

    @Override
    protected void prmtBom_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBom_dataChanged(e);
        BomInfo newValue = (BomInfo)e.getNewValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent) {
            EntityViewInfo view = new EntityViewInfo();
            if (null != newValue) {
                MaterialInfo mi = newValue.getMaterial();
                DataChangeListener[] listener = (DataChangeListener[])this.prmtMaterial.getListeners(DataChangeListener.class);
                if (null != listener) {
                    int count = listener.length;
                    for (int i = 0; i < count; ++i) {
                        this.prmtMaterial.removeDataChangeListener(listener[i]);
                    }
                }
                this.prmtMaterial.setValue((Object)mi);
                FilterInfo filterInfo = new FilterInfo();
                if (null != this.prmtStorageOrgUnit.getValue()) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)mi.getId().toString(), CompareType.EQUALS));
                view.setFilter(filterInfo);
                this.prmtMaterial.setEntityViewInfo(view);
                if (null != listener) {
                    int count = listener.length;
                    for (int i = 0; i < count; ++i) {
                        this.prmtMaterial.addDataChangeListener(listener[i]);
                    }
                }
                EntityViewInfo newview = new EntityViewInfo();
                FilterInfo newfilterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(45), CompareType.EQUALS));
                newfilterInfo.getFilterItems().add(new FilterItemInfo("basestatus", (Object)new Integer(4), CompareType.EQUALS));
                if (this.prmtMaterial.getValue() != null) {
                    newfilterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
                }
                if (this.prmtStorageOrgUnit.getValue() != null) {
                    newfilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
                }
                if (this.cmbBomUsage.getSelectedItem() != null) {
                    newfilterInfo.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(((BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem())).getValue()), CompareType.EQUALS));
                }
                newview.setFilter(newfilterInfo);
                this.prmtBom.setEntityViewInfo(newview);
            } else {
                FilterInfo filterInfo = new FilterInfo();
                if (null != this.prmtStorageOrgUnit.getValue()) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
                }
                view.setFilter(filterInfo);
                this.prmtMaterial.setEntityViewInfo(view);
            }
        }
    }

    @Override
    protected void prmtMaterial_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMaterial_dataChanged(e);
        MaterialInfo newValue = (MaterialInfo)e.getNewValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent) {
            EntityViewInfo view = new EntityViewInfo();
            if (null != newValue) {
                StorageOrgUnitInfo storage;
                DataChangeListener[] listener = (DataChangeListener[])this.prmtBom.getListeners(DataChangeListener.class);
                if (null != listener) {
                    int count = listener.length;
                    for (int i = 0; i < count; ++i) {
                        this.prmtBom.removeDataChangeListener(listener[i]);
                    }
                }
                if ((storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()) != null) {
                    String storageId = storage.getId().toString();
                    String strategyId = this.getMaterialStrategy(storageId, newValue.getId().toString());
                    this.setProjectAndTrackStatus(strategyId);
                }
                FilterInfo filterInfo = new FilterInfo();
                if (null != this.prmtStorageOrgUnit.getValue()) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
                }
                if (null != this.cmbBomUsage.getSelectedItem()) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(((BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem())).getValue()), CompareType.EQUALS));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(45), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)newValue.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("basestatus", (Object)new Integer(4), CompareType.EQUALS));
                SelectorItemCollection sic = super.getSelectors();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("material.id"));
                sic.add(new SelectorItemInfo("material.number"));
                sic.add(new SelectorItemInfo("material.name"));
                view.setFilter(filterInfo);
                this.prmtBom.setSelectorCollection(sic);
                this.prmtBom.setEntityViewInfo(view);
                if (null != listener) {
                    int count = listener.length;
                    for (int i = 0; i < count; ++i) {
                        this.prmtBom.addDataChangeListener(listener[i]);
                    }
                }
            } else {
                FilterInfo filterInfo = new FilterInfo();
                if (null != this.prmtStorageOrgUnit.getValue()) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(45), CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("basestatus", (Object)new Integer(4), CompareType.EQUALS));
                SelectorItemCollection sic = super.getSelectors();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("material.id"));
                sic.add(new SelectorItemInfo("material.number"));
                sic.add(new SelectorItemInfo("material.name"));
                view.setFilter(filterInfo);
                this.prmtBom.setSelectorCollection(sic);
                this.prmtBom.setEntityViewInfo(view);
                this.prmtBom.setValue(null);
            }
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public static void registerTrackNumberF7ForEdit(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, boolean isAutoCreateNew, boolean isMulSelect) {
        trackNumberBox.setEnabledMultiSelection(isMulSelect);
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        status.add(new Integer(80));
        UIHelper.registerTrackNumberF7((KDBizPromptBox)mainOrgUnitBox, (KDBizPromptBox)mainOrgUnitBox2, (KDBizPromptBox)projectBox, (KDBizPromptBox)trackNumberBox, status, (boolean)isAutoCreateNew);
    }

    private void initF7View() {
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                StorageOrgUnitInfo storage = (StorageOrgUnitInfo)OrderBomExtendSearchQueryUI.this.prmtStorageOrgUnit.getValue();
                try {
                    OrderBomExtendSearchQueryUI.this.initF7Material(storage);
                }
                catch (BOSException ee) {
                    OrderBomExtendSearchQueryUI.this.handUIException(ee);
                }
            }
        });
        this.prmtBom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    OrderBomExtendSearchQueryUI.this.loadBomQuery();
                }
                catch (EASBizException e1) {
                    OrderBomExtendSearchQueryUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    OrderBomExtendSearchQueryUI.this.handUIException(e1);
                }
            }
        });
    }

    private void loadBomQuery() throws EASBizException, BOSException {
        if (this.prmtStorageOrgUnit.getValue() != null) {
            MaterialInfo material;
            StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            String prj = null;
            String track = null;
            String mid = null;
            if (this.prmtProjectNumber.getValue() != null) {
                ProjectInfo project = (ProjectInfo)this.prmtProjectNumber.getValue();
                prj = project.getId().toString();
            }
            if (this.prmtTrackNumber.getValue() != null) {
                TrackNumberInfo trackNumberInfo = (TrackNumberInfo)this.prmtTrackNumber.getValue();
                track = trackNumberInfo.getId().toString();
            }
            if ((material = (MaterialInfo)this.prmtMaterial.getValue()) != null) {
                mid = material.getId().toString();
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
            if (null != this.cmbBomUsage.getSelectedItem()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(((BOMUsageEnum)((Object)this.cmbBomUsage.getSelectedItem())).getValue()), CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(45), CompareType.EQUALS));
            if (MMUtils.isNotEmptyString((String)mid)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)mid, CompareType.EQUALS));
            }
            if (MMUtils.isNotEmptyString((String)prj)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("orderBomTP.projectId", (Object)prj, CompareType.EQUALS));
            }
            if (MMUtils.isNotEmptyString((String)track)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("orderBomTP.trackId", (Object)track, CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("basestatus", (Object)new Integer(4), CompareType.EQUALS));
            SelectorItemCollection sic = super.getSelectors();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            view.setFilter(filterInfo);
            this.prmtBom.setSelectorCollection(sic);
            this.prmtBom.setEntityViewInfo(view);
            this.prmtBom.getQueryAgent().resetRuntimeEntityView();
        }
    }

    public void show() {
        if (this.getUIContext().get("IsFromTree") != null && ((Boolean)this.getUIContext().get("IsFromTree")).booleanValue()) {
            int i;
            int count;
            Object filterCondition;
            ItemListener[] bomUsageListener;
            DataChangeListener[] trackListener;
            DataChangeListener[] projectListener;
            DataChangeListener[] materiallistener;
            DataChangeListener[] bomListener;
            DataChangeListener[] souListener = (DataChangeListener[])this.prmtStorageOrgUnit.getListeners(DataChangeListener.class);
            if (null != souListener) {
                int count2 = souListener.length;
                for (int i2 = 0; i2 < count2; ++i2) {
                    this.prmtStorageOrgUnit.removeDataChangeListener(souListener[i2]);
                }
            }
            if (null != (bomListener = (DataChangeListener[])this.prmtBom.getListeners(DataChangeListener.class))) {
                int count3 = bomListener.length;
                for (int i3 = 0; i3 < count3; ++i3) {
                    this.prmtBom.removeDataChangeListener(bomListener[i3]);
                }
            }
            if (null != (materiallistener = (DataChangeListener[])this.prmtMaterial.getListeners(DataChangeListener.class))) {
                int count4 = materiallistener.length;
                for (int i4 = 0; i4 < count4; ++i4) {
                    this.prmtMaterial.removeDataChangeListener(materiallistener[i4]);
                }
            }
            if (null != (projectListener = (DataChangeListener[])this.prmtProjectNumber.getListeners(DataChangeListener.class))) {
                int count5 = projectListener.length;
                for (int i5 = 0; i5 < count5; ++i5) {
                    this.prmtProjectNumber.removeDataChangeListener(projectListener[i5]);
                }
            }
            if (null != (trackListener = (DataChangeListener[])this.prmtTrackNumber.getListeners(DataChangeListener.class))) {
                int count6 = trackListener.length;
                for (int i6 = 0; i6 < count6; ++i6) {
                    this.prmtTrackNumber.removeDataChangeListener(trackListener[i6]);
                }
            }
            if (null != (bomUsageListener = (ItemListener[])this.cmbBomUsage.getListeners(ItemListener.class))) {
                int count7 = bomUsageListener.length;
                for (int i7 = 0; i7 < count7; ++i7) {
                    this.cmbBomUsage.removeItemListener(bomUsageListener[i7]);
                }
            }
            if ((filterCondition = this.getUIContext().get("BOMExtendSearchFilterCondition")) != null && filterCondition instanceof BOMExtendSearchFilterCondition) {
                this.prmtStorageOrgUnit.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getOrgInfo());
                this.prmtBom.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getBomInfo());
                this.prmtMaterial.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getBomInfo().getMaterial());
                this.prmtProjectNumber.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getProjectInfo());
                this.prmtTrackNumber.setValue((Object)((BOMExtendSearchFilterCondition)filterCondition).getTrackNumberInfo());
                this.cmbBomUsage.setSelectedItem((Object)((BOMExtendSearchFilterCondition)filterCondition).getBomUsage());
                this.cmbSearchType.removeAllItems();
                this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.SampleSearch);
                if (this.cmbBomUsage.getSelectedItem() == BOMUsageEnum.Master) {
                    this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.ManySearch);
                    this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.IntegratedSearch);
                    this.cmbSearchType.addItem((Object)BOMSearchFlagEnum.MutliSraech);
                }
                this.prmtStorageOrgUnit.setText(((BOMExtendSearchFilterCondition)filterCondition).getOrgInfo().getNumber());
                this.prmtBom.setText(((BOMExtendSearchFilterCondition)filterCondition).getBomInfo().getNumber());
                this.prmtMaterial.setText(((BOMExtendSearchFilterCondition)filterCondition).getBomInfo().getMaterial().getNumber());
                if (((BOMExtendSearchFilterCondition)filterCondition).getProjectInfo() != null) {
                    this.prmtProjectNumber.setText(((BOMExtendSearchFilterCondition)filterCondition).getProjectInfo().getNumber());
                }
                if (((BOMExtendSearchFilterCondition)filterCondition).getTrackNumberInfo() != null) {
                    this.prmtTrackNumber.setText(((BOMExtendSearchFilterCondition)filterCondition).getTrackNumberInfo().getNumber());
                }
            }
            if (null != souListener) {
                count = souListener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtStorageOrgUnit.addDataChangeListener(souListener[i]);
                }
            }
            if (null != bomListener) {
                count = bomListener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtBom.addDataChangeListener(bomListener[i]);
                }
            }
            if (null != materiallistener) {
                count = materiallistener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtMaterial.addDataChangeListener(materiallistener[i]);
                }
            }
            if (null != projectListener) {
                count = projectListener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtMaterial.addDataChangeListener(projectListener[i]);
                }
            }
            if (null != trackListener) {
                count = trackListener.length;
                for (i = 0; i < count; ++i) {
                    this.prmtMaterial.addDataChangeListener(trackListener[i]);
                }
            }
            if (null != bomUsageListener) {
                count = bomUsageListener.length;
                for (i = 0; i < count; ++i) {
                    this.cmbBomUsage.addItemListener(bomUsageListener[i]);
                }
            }
        }
        super.show();
    }

    private void setProjectAndTrackStatus(String materialStrategyId) {
        Set proTrackOrderBomStrategySet = ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet();
        Set trackOrderBomStrategySet = ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet();
        if (proTrackOrderBomStrategySet.contains(materialStrategyId)) {
            this.prmtProjectNumber.setEnabled(true);
            this.prmtProjectNumber.setRequired(true);
            this.prmtTrackNumber.setEnabled(true);
            this.prmtTrackNumber.setRequired(false);
        } else if (trackOrderBomStrategySet.contains(materialStrategyId)) {
            this.prmtProjectNumber.setEnabled(false);
            this.prmtProjectNumber.setValue(null);
            this.prmtTrackNumber.setEnabled(true);
            this.prmtTrackNumber.setRequired(true);
        } else {
            this.prmtProjectNumber.setEnabled(true);
            this.prmtProjectNumber.setRequired(false);
            this.prmtTrackNumber.setEnabled(true);
            this.prmtTrackNumber.setRequired(false);
        }
    }

    private String getMaterialStrategy(String storageOrgUnitId, String materialId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("manufactureStrategy.id");
        view.setSelector(coll);
        String strategyId = null;
        MaterialPlanCollection mpColl = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
        if (mpColl != null && mpColl.size() > 0) {
            MaterialPlanInfo mp = mpColl.get(0);
            strategyId = mp.getManufactureStrategy().getId().toString();
        }
        return strategyId;
    }
}

