/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.btp.client.BTPBillListImpl;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.OrderBOMPTCollection;
import com.kingdee.eas.mm.basedata.OrderBOMPTFactory;
import com.kingdee.eas.mm.basedata.OrderBOMPTInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractOrderBomListUI;
import com.kingdee.eas.mm.basedata.client.BomFilterUI;
import com.kingdee.eas.mm.basedata.client.PBOMEditUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class OrderBomListUI
extends AbstractOrderBomListUI {
    private static final long serialVersionUID = 3423050417620610174L;
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";
    private static final String TB_BOMNO = "id";
    private static final String TB_PROJECTNO = "project.number";
    private static final String TB_TRACKNO = "trackNumber.number";
    private static final String QUERY_PROJECT = "com.kingdee.eas.mm.project.app.F7ProjectQuery";
    private static final String QUERY_TRACK = "com.kingdee.eas.mm.basedata.app.TrackNumberQuery";
    private BomFilterUI conditionPanel = null;
    private String[] KDTOB_DATES = new String[]{"entrys.effectiveDate", "entrys.disableDate", "dateCreateTime", "dateModificactionTime", "dateAuditTime", "assignTime", "lastUpdateTime", "createTime"};

    @Override
    protected String[] getTableDateColumnKeyArray() {
        return this.KDTOB_DATES;
    }

    public OrderBomListUI() throws Exception {
        this.tblMain.checkParsed(true);
    }

    @Override
    public void onLoad() throws Exception {
        this.fillTrackToTable();
        super.onLoad();
        this.btnViewTrackNumber.setEnabled(true);
        this.menuViewTrackNumber.setEnabled(true);
        this.btnBOMChange.setEnabled(true);
        Icon viewTrackNumberIcon = com.kingdee.eas.mm.common.client.MMUtils.getNewIcon((String)"imgTbtn_integralitycheck");
        this.btnViewTrackNumber.setIcon(viewTrackNumberIcon);
        this.menuViewTrackNumber.setIcon(viewTrackNumberIcon);
        this.actionViewOption.setEnabled(true);
        super.setViewOptionValue();
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{TB_BOMNO, "storageOrgUnit.number", "storageOrgUnit.name", "bomGroupName", "number", "name", "baseStatus", "material.number", "usageType", "unit.name", "bomType", "material.name", "material.model", "productQty", "productBaseQty", "yield", TB_PROJECTNO, "pictureNumber", TB_TRACKNO, "sourceCfgBom"};
    }

    @Override
    protected CustomerQueryPanel getFilterUI() throws Exception {
        String order = "1";
        if (this.conditionPanel == null) {
            this.conditionPanel = new BomFilterUI(order);
        }
        return this.conditionPanel;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemInfo number_SorterItemInfo = new SorterItemInfo("number");
        number_SorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(number_SorterItemInfo);
        SorterItemInfo sourceBomNumber_SorterItemInfo = new SorterItemInfo("sourceBomNumber");
        sourceBomNumber_SorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sourceBomNumber_SorterItemInfo);
        SorterItemInfo id_SorterItemInfo = new SorterItemInfo(TB_BOMNO);
        id_SorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(id_SorterItemInfo);
        FilterInfo addfilterInfo = new FilterInfo();
        addfilterInfo.getFilterItems().add(new FilterItemInfo("designMode.id", null, CompareType.EQUALS));
        try {
            viewInfo.getFilter().mergeFilter(addfilterInfo, "and");
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        IQueryExecutor executor = super.getQueryExecutor(queryPK, viewInfo);
        if (viewInfo.getSorter() != null && viewInfo.getSorter().size() > 0 && !viewInfo.getSorter().toString().equals("")) {
            SorterItemCollection sorters = viewInfo.getSorter();
            for (int i = 0; i < sorters.size(); ++i) {
                if (!sorters.get(i).getPropertyName().equals(this.getEntriesName() + ".seq") && !sorters.get(i).getPropertyName().equals("sourceBomNumber")) continue;
                viewInfo.getSorter().removeObject(i);
            }
        }
        return executor;
    }

    public String getEntriesName() {
        return "orderBomTP";
    }

    @Override
    protected String[] getQtyColumns() throws Exception {
        return new String[]{"productQty", "entrys.netWeight"};
    }

    private void getBillIdList2(List idList, List entriesList) {
        block7: {
            block6: {
                int mode = 0;
                ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
                if (blockList != null && blockList.size() == 1) {
                    mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
                }
                if (mode != 8) break block6;
                List selectIdList = this.getQueryPkList();
                if (selectIdList == null) break block7;
                for (Object[] idObj : selectIdList) {
                    if (idObj == null) continue;
                    if (!idList.contains(idObj[0].toString())) {
                        idList.add(idObj[0].toString());
                    }
                    if (idObj.length != 2) continue;
                    entriesList.add(idObj[1]);
                }
                break block7;
            }
            ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
            for (KDTSelectBlock block : blocks) {
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                    ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                    if (this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()) != null && this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()).getValue() != null) {
                        entriesList.add(this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()).getValue().toString());
                    }
                    if (idList.contains(cell.getValue())) continue;
                    idList.add(cell.getValue());
                }
            }
        }
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("orderBomTP.*"));
        return sic;
    }

    private QueryFieldCollection getQueryPKFileds() {
        QueryFieldCollection fields = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = loader.getQuery(this.mainQueryPK);
        QueryPKInfo pkInfo = queryInfo.getQueryPK();
        if (pkInfo != null) {
            fields = queryInfo.getQueryPK().getKeyPropertys();
        }
        return fields;
    }

    public String getEntriesPKName() {
        QueryFieldCollection fields = this.getQueryPKFileds();
        if (fields != null && fields.size() == 2) {
            String fieldName = fields.get(1).getName();
            return this.getColsName(fieldName);
        }
        return "orderBomTP.id";
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.separator3);
        this.toolBar.remove((Component)this.btnVoucher);
        this.toolBar.remove((Component)this.separatorFW4);
        this.toolBar.remove((Component)this.btnDelVoucher);
        this.toolBar.remove((Component)this.btnAuditResult);
    }

    private String getColsName(String QueryfieldName) {
        int colCount = this.tblMain.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            IColumn col = this.tblMain.getColumn(i);
            String key = col.getKey();
            String fieldname = col.getFieldName();
            if (fieldname == null || !fieldname.equals(QueryfieldName)) continue;
            return key;
        }
        return QueryfieldName;
    }

    private void fillTrackToTable() {
        IColumn column = this.tblMain.getColumn(TB_TRACKNO);
        KDBizPromptBox trackBox = new KDBizPromptBox();
        trackBox.setQueryInfo(QUERY_TRACK);
        trackBox.setDisplayFormat("$number$");
        trackBox.setEditFormat("$number$");
        trackBox.setCommitFormat("$number$");
        trackBox.setEnabledMultiSelection(true);
        ObjectValueRender kdtEntry_OVR = new ObjectValueRender();
        kdtEntry_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        column.setRenderer((IBasicRender)kdtEntry_OVR);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)trackBox));
        column = this.tblMain.getColumn(TB_PROJECTNO);
        KDBizPromptBox projectBox = new KDBizPromptBox();
        projectBox.setQueryInfo(QUERY_PROJECT);
        projectBox.setDisplayFormat("$number$");
        projectBox.setEditFormat("$number$");
        projectBox.setCommitFormat("$number$");
        projectBox.setEnabledMultiSelection(false);
        kdtEntry_OVR = new ObjectValueRender();
        kdtEntry_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        column.setRenderer((IBasicRender)kdtEntry_OVR);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)projectBox));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    OrderBomListUI.this.kdtable_afterDataFill(e);
                }
                catch (EASBizException e1) {
                    OrderBomListUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    OrderBomListUI.this.handUIException(e1);
                }
            }
        });
    }

    @Override
    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.tblMain.getColumn("leadtime").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    protected String[] getQueryShowField() {
        return new String[]{"storageOrgUnit.number", "bomGroupName", "number", "name", "usageType", "bomType", "baseStatus", "material.number", "material.name", "material.model", "unit.name", "productQty", "yield", "pictureNumber", TB_PROJECTNO, TB_TRACKNO, "entry_material.number", "entry_material.name", "entry_material.model", "entry_unit.name", "consuleFixQty"};
    }

    @Override
    public void kdtable_afterDataFill(KDTDataRequestEvent e) throws EASBizException, BOSException {
        int currRowCount = this.tblMain.getRowCount3();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        HashSet<String> bomIdSet = new HashSet<String>();
        String bomId = null;
        for (int i = start; i <= end && i <= currRowCount - 1; ++i) {
            bomId = (String)this.tblMain.getCell(i, TB_BOMNO).getValue();
            if (!MMUtils.isNotEmptyString((String)bomId) || bomIdSet.contains(bomId)) continue;
            bomIdSet.add(bomId);
        }
        if (bomIdSet == null || bomIdSet.size() == 0) {
            return;
        }
        IBom bom = BomFactory.getRemoteInstance();
        Map map = bom.getOrderBomTracks(bomIdSet);
        String trackKey = null;
        List trackList = null;
        String oldBomId = null;
        Object projectValue = null;
        Object[] trackValue = null;
        for (int i = start; i <= end && i <= currRowCount - 1; ++i) {
            bomId = (String)this.tblMain.getCell(i, TB_BOMNO).getValue();
            if (MMUtils.isNotEmptyString((String)bomId) && !bomId.equals(oldBomId)) {
                oldBomId = bomId;
                projectValue = map.get(bomId);
                trackValue = null;
                trackKey = bomId + "_track";
                if (map.containsKey(trackKey)) {
                    trackList = (List)map.get(trackKey);
                    trackValue = trackList.toArray();
                }
            }
            this.tblMain.getCell(i, TB_PROJECTNO).setValue(projectValue);
            this.tblMain.getCell(i, TB_TRACKNO).setValue(trackValue);
        }
    }

    @Override
    protected boolean isSupportDynQuery() {
        return false;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.uiContext.put((Object)"UIClassParam", (Object)"1");
        super.actionView_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiContext.put((Object)"UIClassParam", (Object)"1");
        super.actionEdit_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        BTPBillListImpl billList = null;
        billList = new BTPBillListImpl((CoreBillListUI)this);
        if (this.getUIContext() != null) {
            this.getUIContext().put("UIClassParam", "1");
        }
        this.checkSelected();
        ArrayList idList = new ArrayList();
        ArrayList entriesKey = new ArrayList();
        this.getBillIdList2(idList, entriesKey);
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        billList.createTo(idArray, new String[]{"orderBomTP"}, entriesKey, this.getBizType().toString(), this.getBOTPSelectors());
    }

    @Override
    public void actionPBom_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idLst = this.getSelectedIdValues();
        StringBuffer stringMessage = new StringBuffer(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"billNumberis"));
        if (null != idLst && idLst.size() > 0 && idLst.get(0) != null) {
            IBom ibom = BomFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("material.*"));
            sic.add(new SelectorItemInfo("storageOrgUnit.*"));
            BomInfo bomInfo = (BomInfo)ibom.getValue((IObjectPK)new ObjectStringPK(idLst.get(0).toString()), sic);
            stringMessage.append(bomInfo.getNumber() + ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"isBom"));
            if (bomInfo.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                if (bomInfo.getBomType() == BOMTypeEnum.MfgBOM || bomInfo.getBomType() == BOMTypeEnum.OrderBOM) {
                    if (bomInfo.getUsageType() == BOMUsageEnum.Master) {
                        String projectid = null;
                        String tracknumberid = null;
                        String bomid = bomInfo.getId().toString();
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("orderId.id", (Object)bomid, CompareType.EQUALS));
                        view.setFilter(filter);
                        OrderBOMPTCollection col = OrderBOMPTFactory.getRemoteInstance().getOrderBOMPTCollection(view);
                        if (col != null && col.size() > 0) {
                            OrderBOMPTInfo orderBOMPTInfo = col.get(0);
                            projectid = orderBOMPTInfo.getProjectId();
                            tracknumberid = orderBOMPTInfo.getTrackId();
                        }
                        ProjectInfo pInfo = null;
                        TrackNumberInfo tInfo = null;
                        if (projectid != null && projectid.trim().length() > 0) {
                            pInfo = (ProjectInfo)ProjectFactory.getRemoteInstance().getValue((IObjectPK)new ObjectStringPK(projectid));
                        }
                        if (tracknumberid != null && tracknumberid.trim().length() > 0) {
                            tInfo = (TrackNumberInfo)TrackNumberFactory.getRemoteInstance().getValue((IObjectPK)new ObjectStringPK(tracknumberid));
                        }
                        bomInfo.put("orderTrack", tInfo);
                        bomInfo.put("orderProject", pInfo);
                        PBOMEditUI.openPBOMByBom(bomInfo, (Object)this);
                        return;
                    }
                    stringMessage.append(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"bom_not_master"));
                } else {
                    stringMessage.append(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"bom_not_maf_order"));
                }
            } else {
                stringMessage.append(ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)"bom_not_audit"));
            }
            MsgBox.showInfo((String)stringMessage.toString());
        }
    }

    @Override
    public void actionViewTrackNumber_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        ArrayList list = this.tblMain.getSelectManager().getBlocks();
        if (list == null || list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        KDTSelectBlock block = (KDTSelectBlock)list.get(0);
        int rowIndex = block.getTop();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        String bomNo = (String)this.tblMain.getCell(rowIndex, TB_BOMNO).getValue();
        if (!MMUtils.isNotEmptyString((String)bomNo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.basedata.BasedataResource", (String)"BOM_ISNULL"));
            return;
        }
        UIHelper.openTrackNumberListUIforBom((String)bomNo, (Map)this.getUIContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionStandardRooting_actionPerformed(ActionEvent e) throws Exception {
        String uiClassName = null;
        Map uiContext = this.getUIContext();
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        String storageOrgUnitID = (String)this.tblMain.getRow(index).getCell("storageOrgUnit.id").getValue();
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)StorageOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(storageOrgUnitID));
        String userInfoID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String materialNumber = (String)this.tblMain.getRow(index).getCell("material.number").getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialNumber));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("material.id"));
        coll.add(new SelectorItemInfo(TB_BOMNO));
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("isMainRooting"));
        coll.add(new SelectorItemInfo("isChildRooting"));
        coll.add(new SelectorItemInfo("rootingType"));
        coll.add(new SelectorItemInfo("material.name"));
        coll.add(new SelectorItemInfo("storageOrgUnit.name"));
        coll.add(new SelectorItemInfo("storageOrgUnit.name"));
        coll.add(new SelectorItemInfo("materialRooting.firstWP"));
        coll.add(new SelectorItemInfo("materialRooting.lastWP"));
        coll.add(new SelectorItemInfo("status"));
        coll.add(new SelectorItemInfo("storageOrgUnit.id"));
        view.setSelector(coll);
        view.setFilter(filter);
        CoreBaseCollection invents = null;
        try {
            invents = StandardRootingFactory.getRemoteInstance().getCollection(view);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (invents.size() > 0) {
            boolean ispermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(storageOrgUnitInfo.getId().toString()), "mm_standardRooting_view");
            if (ispermission) {
                uiContext.put("ID", null);
                uiContext.put("material.number", materialNumber);
                uiContext.put("storageOrgUnit.id", storageOrgUnitInfo.getId().toString());
                uiClassName = "com.kingdee.eas.mm.basedata.client.StandardRootingForBomQueryUI";
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                return;
            }
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("Has_Not_View_Permission", new String[]{storageOrgUnitInfo.getNumber()}));
            return;
        }
        boolean ispermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(storageOrgUnitInfo.getId().toString()), "mm_standardRooting_addnew");
        if (!ispermission) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("Has_Not_AddNew_Permission", new String[]{storageOrgUnitInfo.getNumber()}));
            return;
        }
        MaterialInfo materialInfo = null;
        String adminCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("adminCU.id", (Object)adminCU));
        filter1.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumber));
        view1.setFilter(filter1);
        MaterialCollection materialColl = MaterialFactory.getRemoteInstance().getMaterialCollection(view1);
        if (materialColl.size() > 0) {
            materialInfo = materialColl.get(0);
        }
        uiContext.put("materialfrombom", materialInfo);
        uiContext.put("storageOrgUnitfrombom", storageOrgUnitInfo);
        uiClassName = "com.kingdee.eas.mm.basedata.client.StandardRootingEditUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private String getResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)BOM_RESOURCE_PATH, (String)key, (String[])params);
    }
}

